(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    397659,       8658]
NotebookOptionsPosition[    391807,       8494]
NotebookOutlinePosition[    392155,       8509]
CellTagsIndexPosition[    392112,       8506]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Example 6.5: Random tensor networks for holographic duality", "Title",
 CellChangeTimes->{{3.7590665072886477`*^9, 3.7590665216877947`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"<<", "RTNI`"}]}]}]], "Input",
 CellChangeTimes->{3.759067315941244*^9},
 ExpressionUUID -> "1b188f6f-38fa-422b-8c1a-f688519beece"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package RTNI (Random Tensor Network Integrator) version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.5\"\>", 
   "\[InvisibleSpace]", "\<\" (last modification: \"\>", 
   "\[InvisibleSpace]", "\<\"26/01/2019\"\>", 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "Package RTNI (Random Tensor Network Integrator) version ", "1.0.5", 
   " (last modification: ", "26/01/2019", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014641550245`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions1.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions1.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401464231942*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions2.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions2.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401464443713*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions3.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions3.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.75940146449266*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions4.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions4.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401464545102*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions5.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions5.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401464604039*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions6.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions6.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014646569815`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions7.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions7.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014647089252`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions8.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions8.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401464766863*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions9.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions9.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014648248*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions10.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions10.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014648812385`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions11.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions11.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014649396763`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions12.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions12.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014649926176`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions13.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions13.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014650425634`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions14.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions14.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014651010003`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions15.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions15.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401465158938*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions16.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions16.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401465246843*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions17.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions17.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014653477335`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions18.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions18.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.759401465459613*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions19.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions19.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014656164417`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions20.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions20.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7574779272614403`*^9, 3.7574779344292693`*^9}, 
   3.7574809510065413`*^9, 3.7574823167317896`*^9, 3.7574951318296585`*^9, 
   3.7575700818533106`*^9, 3.757750440004025*^9, 3.757855062115176*^9, 
   3.757952288262907*^9, 3.7583488997503414`*^9, 3.7590668465162334`*^9, 
   3.7590669866914015`*^9, 3.7590673173902626`*^9, 3.7590711161323357`*^9, 
   3.7593716492347355`*^9, 3.7594014658571815`*^9},
 ExpressionUUID -> "46f5e893-d2cc-41a9-9268-422c0ff18abd"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "subroutine", " ", "for", " ", "creating", " ", "tensor", " ", "networks", 
    " ", "representing", " ", "Tr", 
    RowBox[{"(", 
     RowBox[{"\\r", 
      RowBox[{"ho", "\\", "otimes"}], " ", "rho"}], ")"}], " ", 
    RowBox[{"and", " ", "\\", "tr"}], 
    RowBox[{"(", 
     RowBox[{"\\r", 
      RowBox[{"ho_A", "^", "2"}]}], ")"}], " ", "for", " ", "a", " ", "given",
     " ", "graph", " ", "G", " ", "and", " ", "subset", " ", "A", " ", "of", 
    " ", "the", " ", "vertices"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"buildTNfromGraph", "[", 
      RowBox[{"g_", ",", "marginal_", ",", 
       RowBox[{"debug_:", "False"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "psi", ",", "nV", ",", "nE", ",", "i", ",", "e", ",", "traceRho", ",",
          "traceRhoASquared", ",", "newEdge", ",", "degree", ",", "v1", ",", 
         "v2", ",", "v", ",", "psiStar", ",", "rho"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nV", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"VertexList", "[", "g", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nE", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"EdgeList", "[", "g", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"degree", "=", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"1", ",", "nV"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"psi", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"psiStar", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", "nE"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"e", "=", 
            RowBox[{
             RowBox[{"EdgeList", "[", "g", "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"v1", "=", 
            RowBox[{"e", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"v2", "=", 
            RowBox[{"e", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{"debug", ",", 
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<edge: \>\"", ",", "v1", ",", "\"\< --- \>\"", ",", "v2", 
               ",", "\"\<  read.\>\""}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"degree", "[", 
             RowBox[{"[", "v1", "]"}], "]"}], "++"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"degree", "[", 
             RowBox[{"[", "v2", "]"}], "]"}], "++"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"newEdge", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<U\>\"", "<>", 
                 RowBox[{"ToString", "[", "v1", "]"}]}], ",", "1", ",", 
                "\"\<out\>\"", ",", 
                RowBox[{"degree", "[", 
                 RowBox[{"[", "v1", "]"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<U\>\"", "<>", 
                 RowBox[{"ToString", "[", "v2", "]"}]}], ",", "1", ",", 
                "\"\<out\>\"", ",", 
                RowBox[{"degree", "[", 
                 RowBox[{"[", "v2", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"psi", ",", "newEdge"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"newEdge", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<U\>\"", "<>", 
                 RowBox[{"ToString", "[", "v1", "]"}], "<>", "\"\<*\>\""}], 
                ",", "1", ",", "\"\<in\>\"", ",", 
                RowBox[{"degree", "[", 
                 RowBox[{"[", "v1", "]"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<U\>\"", "<>", 
                 RowBox[{"ToString", "[", "v2", "]"}], "<>", "\"\<*\>\""}], 
                ",", "1", ",", "\"\<in\>\"", ",", 
                RowBox[{"degree", "[", 
                 RowBox[{"[", "v2", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"psiStar", ",", "newEdge"}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"rho", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"psi", ",", "psiStar"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"traceRho", "=", "rho"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", "nV"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"v", "=", "i"}], ";", "\[IndentingNewLine]", 
           RowBox[{"newEdge", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<U\>\"", "<>", 
                 RowBox[{"ToString", "[", "v", "]"}]}], ",", "1", ",", 
                "\"\<out\>\"", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<U\>\"", "<>", 
                 RowBox[{"ToString", "[", "v", "]"}], "<>", "\"\<*\>\""}], 
                ",", "1", ",", "\"\<in\>\"", ",", "1"}], "}"}]}], "}"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"traceRho", ",", "newEdge"}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"traceRhoASquared", "=", 
         RowBox[{"cloneGraph", "[", 
          RowBox[{"rho", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", "nV"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"v", "=", "i"}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"marginal", ",", "v"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"newEdge", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}]}], ",", "1", ",", 
                   "\"\<out\>\"", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}], "<>", "\"\<*\>\""}], 
                   ",", "2", ",", "\"\<in\>\"", ",", "1"}], "}"}]}], "}"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"traceRhoASquared", ",", "newEdge"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"newEdge", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}]}], ",", "2", ",", 
                   "\"\<out\>\"", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}], "<>", "\"\<*\>\""}], 
                   ",", "1", ",", "\"\<in\>\"", ",", "1"}], "}"}]}], "}"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"traceRhoASquared", ",", "newEdge"}], "]"}], ";"}], 
             "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"newEdge", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}]}], ",", "1", ",", 
                   "\"\<out\>\"", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}], "<>", "\"\<*\>\""}], 
                   ",", "1", ",", "\"\<in\>\"", ",", "1"}], "}"}]}], "}"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"traceRhoASquared", ",", "newEdge"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"newEdge", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}]}], ",", "2", ",", 
                   "\"\<out\>\"", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<U\>\"", "<>", 
                    RowBox[{"ToString", "[", "v", "]"}], "<>", "\"\<*\>\""}], 
                   ",", "2", ",", "\"\<in\>\"", ",", "1"}], "}"}]}], "}"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"traceRhoASquared", ",", "newEdge"}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"cloneGraph", "[", 
           RowBox[{"traceRho", ",", "2"}], "]"}], ",", "traceRhoASquared"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "routine", " ", "for", " ", "integrating", " ", "over", " ", "all", " ", 
     "unitaries", " ", "by", " ", "invoking", " ", "integrateHaarUnitary", 
     " ", "several", " ", "times"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{"tn_", ",", "d_", ",", "s_", ",", 
       RowBox[{"debug_:", "False"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "listU", ",", "i", ",", "name", ",", "v", ",", "p", ",", "maxLeg", 
         ",", "intTN"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"listU", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxLeg", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"Length", "[", "tn", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "1"}], ",", 
            RowBox[{"j", "\[LessEqual]", "2"}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"name", "=", 
              RowBox[{"Characters", "[", 
               RowBox[{"tn", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "j", ",", "1"}], "]"}], "]"}], "]"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"debug", ",", 
               RowBox[{"Print", "[", "name", "]"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"name", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "\"\<U\>\""}], "&&", 
                RowBox[{
                 RowBox[{"Last", "[", "name", "]"}], "\[NotEqual]", 
                 "\"\<*\>\""}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"v", "=", 
                 RowBox[{"ToExpression", "[", 
                  RowBox[{"StringJoin", "[", 
                   RowBox[{"name", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ";;"}], "]"}], "]"}], "]"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{"debug", ",", 
                  RowBox[{"Print", "[", "v", "]"}]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{"listU", ",", "v"}], "]"}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"AppendTo", "[", 
                    RowBox[{"listU", ",", "v"}], "]"}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"AppendTo", "[", 
                    RowBox[{"maxLeg", ",", "1"}], "]"}], ";"}]}], 
                 "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{"debug", ",", 
                  RowBox[{"Print", "[", "listU", "]"}]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"p", "=", 
                 RowBox[{
                  RowBox[{"Position", "[", 
                   RowBox[{"listU", ",", "v"}], "]"}], "[", 
                  RowBox[{"[", 
                   RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"maxLeg", "[", 
                  RowBox[{"[", "p", "]"}], "]"}], "=", 
                 RowBox[{"Max", "[", 
                  RowBox[{
                   RowBox[{"tn", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"maxLeg", "[", 
                    RowBox[{"[", "p", "]"}], "]"}]}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{"debug", ",", 
                  RowBox[{"Print", "[", "maxLeg", "]"}]}], "]"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"intTN", "=", "tn"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"Length", "[", "listU", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"intTN", "=", 
            RowBox[{"integrateHaarUnitary", "[", 
             RowBox[{"intTN", ",", 
              RowBox[{"\"\<U\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"listU", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"{", "d", "}"}], ",", 
                RowBox[{"ConstantArray", "[", 
                 RowBox[{"s", ",", 
                  RowBox[{
                   RowBox[{"maxLeg", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "]"}]}], 
               "]"}], ",", 
              RowBox[{"d", " ", 
               RowBox[{"s", "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"maxLeg", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], ")"}]}]}]}], 
             "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "intTN"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "routines", " ", "for", " ", "computing", " ", "the", " ", "averages", 
     " ", "via", " ", "the", " ", "Ising", " ", "model", " ", "formulation"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"computeenergy", "[", 
      RowBox[{"spinconfig_", ",", "g_", ",", "marginal_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"result", "=", "0"}], ",", "nV", ",", "nE", ",", "degree", 
         ",", "v1", ",", "v2", ",", "v"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nV", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"VertexList", "[", "g", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nE", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"EdgeList", "[", "g", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"degree", "=", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"1", ",", "nV"}], "]"}]}], ";", 
        RowBox[{"(*", " ", 
         RowBox[{
         "add", " ", "energy", " ", "contribution", " ", "from", " ", "Ising",
           " ", "interaction"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", "nE"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"e", "=", 
            RowBox[{
             RowBox[{"EdgeList", "[", "g", "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"v1", "=", 
            RowBox[{"e", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"v2", "=", 
            RowBox[{"e", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<vertex v1=\>\"", ",", " ", "v1", ",", "\"\< v2=\>\"", ",", 
               "v2", ",", "\"\< energy contrib=\>\"", ",", 
               RowBox[{
                RowBox[{"spinconfig", "[", 
                 RowBox[{"[", "v1", "]"}], "]"}], "*", 
                RowBox[{"spinconfig", "[", 
                 RowBox[{"[", "v2", "]"}], "]"}]}]}], "]"}], ";"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"result", "=", 
            RowBox[{"result", "+", 
             RowBox[{
              RowBox[{"spinconfig", "[", 
               RowBox[{"[", "v1", "]"}], "]"}], "*", 
              RowBox[{"spinconfig", "[", 
               RowBox[{"[", "v2", "]"}], "]"}]}]}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "add", " ", "energy", " ", "contribution", " ", "from", " ", 
          "field"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", "nV"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"v", "=", "i"}], ";", " ", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<vertex v=\>\"", ",", " ", "v", ",", 
               "\"\<  field energy contrib=\>\"", ",", 
               RowBox[{
                RowBox[{"spinconfig", "[", 
                 RowBox[{"[", "v", "]"}], "]"}], "*", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"marginal", ",", "v"}], "]"}], ",", "1", ",", 
                  RowBox[{"-", "1"}]}], "]"}]}]}], "]"}], ";"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"result", "=", 
            RowBox[{"result", "+", 
             RowBox[{
              RowBox[{"spinconfig", "[", 
               RowBox[{"[", "v", "]"}], "]"}], "*", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"marginal", ",", "v"}], "]"}], ",", 
                RowBox[{"-", "1"}], ",", "1"}], "]"}]}]}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"result", "=", 
         RowBox[{"result", "/", "2"}]}], ";", "\[IndentingNewLine]", 
        "result"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"findallenergies", "[", 
      RowBox[{"g_", ",", "marginal_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"spinconfiglist", ",", "nV", ",", "result", ",", "j"}], "}"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nV", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"VertexList", "[", "g", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"spinconfiglist", "=", 
         RowBox[{"Tuples", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "nV"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"result", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"spinconfiglist", "[", 
              RowBox[{"[", "j", "]"}], "]"}], ",", 
             RowBox[{"computeenergy", "[", 
              RowBox[{
               RowBox[{"spinconfiglist", "[", 
                RowBox[{"[", "j", "]"}], "]"}], ",", "g", ",", "marginal"}], 
              "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"2", "^", "nV"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"result", "=", 
         RowBox[{"SortBy", "[", 
          RowBox[{"result", ",", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"computeexponents", "[", 
      RowBox[{"g_", ",", "marginal_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "allspinsE", ",", "marginalspinsE", ",", "Eminall", ",", 
         "Eminmarginal", ",", "result"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nV", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"VertexList", "[", "g", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"allspinsE", "=", 
         RowBox[{"findallenergies", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"marginalspinsE", "=", 
         RowBox[{"findallenergies", "[", 
          RowBox[{"g", ",", "marginal"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Emaxall", "=", 
         RowBox[{
          RowBox[{"allspinsE", "[", 
           RowBox[{"[", 
            RowBox[{"Length", "[", "allspinsE", "]"}], "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Emaxmarginal", "=", 
         RowBox[{
          RowBox[{"marginalspinsE", "[", 
           RowBox[{"[", 
            RowBox[{"Length", "[", "allspinsE", "]"}], "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"result", "=", 
         RowBox[{"{", 
          RowBox[{"Emaxall", ",", "Emaxmarginal"}], "}"}]}], ";", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
           RowBox[{",", 
            RowBox[{"Emaxall", "-", "Emaxmarginal"}], ",", 
            RowBox[{"marginalspinsE", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.757477951083728*^9, 3.757478032070171*^9}, {
   3.7574780640556126`*^9, 3.757478109513034*^9}, {3.757478260021556*^9, 
   3.757478260848353*^9}, {3.757478296248639*^9, 3.7574783940949907`*^9}, {
   3.7574784668753576`*^9, 3.7574788637828655`*^9}, {3.7574789386805525`*^9, 
   3.7574790111956315`*^9}, {3.7574792333771067`*^9, 
   3.7574792383328257`*^9}, {3.7574792789462347`*^9, 3.757479515753933*^9}, {
   3.757479598602339*^9, 3.757479627004418*^9}, {3.757479675652279*^9, 
   3.7574799293268957`*^9}, {3.757480028198479*^9, 3.7574800306379313`*^9}, {
   3.7574803812462783`*^9, 3.7574804038657846`*^9}, {3.7574805245151553`*^9, 
   3.7574807830597286`*^9}, {3.7574808483291364`*^9, 3.757480925271366*^9}, {
   3.757480984302526*^9, 3.7574809887506375`*^9}, {3.7574810443858523`*^9, 
   3.757481044731929*^9}, {3.7574810919426627`*^9, 3.757481131479935*^9}, {
   3.757481167664157*^9, 3.757481174459953*^9}, {3.7574812045335627`*^9, 
   3.75748123813466*^9}, {3.757481273051284*^9, 3.757481290473693*^9}, {
   3.757481424730676*^9, 3.757481483677039*^9}, {3.75748152488081*^9, 
   3.757481526800706*^9}, {3.757481577094203*^9, 3.7574815788055925`*^9}, {
   3.757481625764037*^9, 3.757481657015456*^9}, {3.757481712181937*^9, 
   3.757481809143592*^9}, {3.757481856646225*^9, 3.7574819223604827`*^9}, {
   3.7574819621131954`*^9, 3.7574819989157805`*^9}, {3.7574820334713626`*^9, 
   3.7574822857197547`*^9}, {3.7574950264075594`*^9, 3.757495029262923*^9}, {
   3.757495074616633*^9, 3.7574950986433764`*^9}, {3.757495263869542*^9, 
   3.757495290108367*^9}, {3.7579544286999235`*^9, 3.757954432813924*^9}, {
   3.7579620453164797`*^9, 3.757962062822998*^9}, {3.7590665361036367`*^9, 
   3.759066577577833*^9}, {3.759066613122818*^9, 3.75906663964314*^9}, 
   3.759067266391449*^9, {3.759067652215277*^9, 3.7590677034859867`*^9}},
 ExpressionUUID -> "187df12f-9e18-4e6b-8313-3cd646261178"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triangle graph example", "Title",
 CellChangeTimes->{{3.759066729505299*^9, 3.7590667320564346`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Graph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[UndirectedEdge]", "2"}], ",", 
      RowBox[{"2", "\[UndirectedEdge]", "3"}], ",", 
      RowBox[{"3", "\[UndirectedEdge]", "1"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"edgeNormalization", "=", 
   RowBox[{"d", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], 
      RowBox[{"EdgeCount", "[", "g", "]"}]}], ")"}]}]}], ";", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "pre"}], "-", 
    RowBox[{
    "factor", " ", "corresponds", " ", "to", " ", "using", " ", "normalized", 
     " ", "maximally", " ", "entangled", " ", "states", " ", "in", " ", "the",
      " ", "main", " ", "text"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"marginal", ",", "#2"}], "]"}], ",", "Green", ",", "Red"}],
          "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<triangle-1.pdf\>\"", ",", "%"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<triangle-2.pdf\>\"", ",", "%"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<triangle-3.pdf\>\"", ",", "%"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ZA", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", "  ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "ZA", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7578551540744123`*^9, 3.75785523241078*^9}, {
  3.757954235451889*^9, 3.7579542362041345`*^9}, {3.7579542762291813`*^9, 
  3.757954336545849*^9}, {3.757954413334041*^9, 3.7579544176978097`*^9}, {
  3.7579614401739893`*^9, 3.7579615095258636`*^9}, {3.7579615448639917`*^9, 
  3.757961567970441*^9}, {3.757961995412036*^9, 3.7579620118073215`*^9}, {
  3.757962089619403*^9, 3.7579620937090106`*^9}, {3.75834890923661*^9, 
  3.7583489399037914`*^9}, {3.7583492756395993`*^9, 3.7583492757765374`*^9}, {
  3.7583501452300305`*^9, 3.7583501453996153`*^9}, {3.7590675491013093`*^9, 
  3.759067580207058*^9}, {3.759373024432658*^9, 3.7593730516801443`*^9}},
 ExpressionUUID -> "7ecbc005-788a-4157-ab6c-a84ca887f41e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{-0.8660254037844384, -0.49999999999999933`}, {
      0.8660254037844389, -0.5000000000000012}, {1.8369701987210297`*^-16, 
      1.}}, 
      {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {2, 3}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{-0.8660254037844384, -0.49999999999999933}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {-0.8660254037844384, -0.49999999999999933}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8660254037844389, -0.5000000000000012}, 0.1], 
       {GrayLevel[0], 
        InsetBox["2", {0.8660254037844389, -0.5000000000000012}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.8369701987210297*^-16, 1.}, 0.1], 
       {GrayLevel[0], InsetBox["3", {1.8369701987210297*^-16, 1.}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{-0.8660254037844384, -0.49999999999999933`}, {
     0.8660254037844389, -0.5000000000000012}, {1.8369701987210297`*^-16, 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.7593716524572444`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.5018706832597943`, -3.4273020872337883`}, {
    1.5016055222587246`, -2.255493884864645}, {
    2.079168845117362, -2.841303598998876}, {
    0.36208794611954664`, -3.3743092781511614`}, {
    0.36122856083183397`, -2.3092337790878767`}, {
    0.9303854922096613, -2.841159640103638}, {
    1.5018706832597943`, -1.5330367632009771`}, {
    1.5016055222587246`, -0.36122856083183397`}, {
    2.079168845117362, -0.9470382749660651}, {
    0.36208794611954664`, -1.4800439541183503`}, {
    0.36122856083183397`, -0.41496845505506563`}, {
    0.9303854922096613, -0.9468943160708265}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 4}], 
      LineBox[{2, 3}], LineBox[{2, 5}], LineBox[{3, 1}], LineBox[{3, 6}], 
      LineBox[{4, 5}], LineBox[{5, 6}], LineBox[{6, 4}], LineBox[{7, 8}], 
      LineBox[{7, 10}], LineBox[{8, 9}], LineBox[{8, 11}], LineBox[{9, 7}], 
      LineBox[{9, 12}], LineBox[{10, 11}], LineBox[{11, 12}], 
      LineBox[{12, 10}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 12]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.5018706832597943`, -3.4273020872337883`}, {
     1.5016055222587246`, -2.255493884864645}, {
     2.079168845117362, -2.841303598998876}, {
     0.36208794611954664`, -3.3743092781511614`}, {
     0.36122856083183397`, -2.3092337790878767`}, {
     0.9303854922096613, -2.841159640103638}, {
     1.5018706832597943`, -1.5330367632009771`}, {
     1.5016055222587246`, -0.36122856083183397`}, {
     2.079168845117362, -0.9470382749660651}, {
     0.36208794611954664`, -1.4800439541183503`}, {
     0.36122856083183397`, -0.41496845505506563`}, {
     0.9303854922096613, -0.9468943160708265}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.7593716538702145`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.4636260929135156`, 1.290145831593079}, {
    3.291202163362989, 1.7477561887228183`}, {2.4877549782426467`, 
    1.9807759782584107`}, {0.0798791007556805, 1.7960932666563298`}, {
    0.3803557719112236, 1.341669886866006}, {1.1180634040708508`, 
    2.0215324472983243`}, {0., 0.732338841991403}, {0.17276886809519643`, 
    0.27487393011628103`}, {0.9754102723381994, 0.041113810048168276`}, {
    3.383633404681032, 0.22526219621529608`}, {3.0838354707298987`, 
    0.6796043062474217}, {2.344379278655326, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 10}], 
      LineBox[{2, 3}], LineBox[{2, 11}], LineBox[{3, 1}], LineBox[{3, 6}], 
      LineBox[{4, 5}], LineBox[{5, 6}], LineBox[{6, 4}], LineBox[{7, 8}], 
      LineBox[{7, 4}], LineBox[{8, 9}], LineBox[{8, 5}], LineBox[{9, 7}], 
      LineBox[{9, 12}], LineBox[{10, 11}], LineBox[{11, 12}], 
      LineBox[{12, 10}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 12]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.4636260929135156`, 1.290145831593079}, {
     3.291202163362989, 1.7477561887228183`}, {2.4877549782426467`, 
     1.9807759782584107`}, {0.0798791007556805, 1.7960932666563298`}, {
     0.3803557719112236, 1.341669886866006}, {1.1180634040708508`, 
     2.0215324472983243`}, {0., 0.732338841991403}, {0.17276886809519643`, 
     0.27487393011628103`}, {0.9754102723381994, 0.041113810048168276`}, {
     3.383633404681032, 0.22526219621529608`}, {3.0838354707298987`, 
     0.6796043062474217}, {2.344379278655326, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.759371654315232*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", "d"}]}], 
  RowBox[{
   SuperscriptBox["d", "7"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "d"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], 
    "3"]}]]], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.7593716549905024`*^9}],

Cell[BoxData["12"], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.759371655132347*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox["d", "2"]}], 
  RowBox[{
   SuperscriptBox["d", "8"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "d"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], 
    "3"]}]]], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.759371655231739*^9}],

Cell[BoxData["13"], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.759371655298168*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{
  3.759066699476001*^9, {3.7590667436040144`*^9, 3.7590667677963667`*^9}, 
   3.7590668538708615`*^9, {3.7590672431797905`*^9, 3.75906727289822*^9}, 
   3.75906733019331*^9, 3.759067580939381*^9, 3.7590676711895065`*^9, 
   3.7590677052566123`*^9, 3.7590711372073436`*^9, 3.759371655353108*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"TO", " ", "BE", " ", "FIXED"}], " ", "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7590677608297424`*^9, 3.759067768036339*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Graph", "[", 
    RowBox[{"{", 
     RowBox[{"1", "\[UndirectedEdge]", "2"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"edgeNormalization", "=", 
   RowBox[{"d", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"EdgeCount", "[", "g", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", "1", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"marginal", ",", "#2"}], "]"}], ",", "Green", ",", "Red"}],
          "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ZA", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", "  ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Log", "[", "ZA", "]"}]}], "/", 
     RowBox[{"Log", "[", "d", "]"}]}], ",", 
    RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"renyi2", "=", 
    RowBox[{
     RowBox[{"Z1", "/", "Z0"}], "//", "FullSimplify"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"renyi2", "/.", 
      RowBox[{"{", 
       RowBox[{"s", "\[Rule]", "d"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "Infinity", ",", "20"}], "}"}]}], "]"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.757570134933444*^9, 3.757570171574742*^9}, {
  3.7575702029907994`*^9, 3.7575702228257933`*^9}, {3.757570614707822*^9, 
  3.7575706147852373`*^9}, {3.757750464966151*^9, 3.75775047834033*^9}, {
  3.757751989121285*^9, 3.7577519891844053`*^9}, {3.757855084314023*^9, 
  3.757855132298112*^9}, {3.757954443211197*^9, 3.7579544467213445`*^9}, {
  3.757962073491387*^9, 3.757962078847126*^9}, {3.757962406774063*^9, 
  3.75796240686047*^9}, {3.759067405950833*^9, 3.759067527888554*^9}, {
  3.759071181907997*^9, 3.759071186590198*^9}},
 ExpressionUUID -> "d0489858-ea72-4208-855f-33f7742e8f9a"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{GraphicsComplexBox[{{1., 0.}, {-1., 0.}}, 
      {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], DiskBox[{1., 0.}, 0.1], 
       {GrayLevel[0], InsetBox["1", {1., 0.}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], DiskBox[{-1., 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {-1., 0.}]}}}},
    ContentSelectable->True],
   Annotation[#, VertexCoordinateRules -> {{1., 0.}, {-1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.7593716555843577`*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.25751589410206166`, -2.802595135548581}, {
    1.25760651422916, -2.832540539744804}, {
    0.28864412776723825`, -1.8025441110254945`}, {
    1.2875666181992453`, -1.8334654025658077`}, {
    0.25751589410206166`, -1.2575669186251481`}, {
    1.25760651422916, -1.287512322821371}, {
    0.28864412776723825`, -0.25751589410206166`}, {
    1.2875666181992453`, -0.28843718564237497`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 4}], LineBox[{3, 4}], LineBox[{5, 6}], LineBox[{5, 7}], 
      LineBox[{6, 8}], LineBox[{7, 8}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 8]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.25751589410206166`, -2.802595135548581}, {
     1.25760651422916, -2.832540539744804}, {
     0.28864412776723825`, -1.8025441110254945`}, {
     1.2875666181992453`, -1.8334654025658077`}, {
     0.25751589410206166`, -1.2575669186251481`}, {
     1.25760651422916, -1.287512322821371}, {
     0.28864412776723825`, -0.25751589410206166`}, {
     1.2875666181992453`, -0.28843718564237497`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.75937165565578*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7127257515423839, 2.414831829334526}, {
    0.0033205987463897912`, 1.7097577582075656`}, {0.7059391523979848, 
    0.0020522840132326525`}, {0., 0.7106752975065056}, {1.7058768633939234`, 
    0.}, {2.4156455551162406`, 0.7047806547719655}, {1.713600127787104, 
    2.4128800023904704`}, {2.4192631229587427`, 1.70382353516607}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 7}], 
      LineBox[{2, 4}], LineBox[{3, 4}], LineBox[{5, 6}], LineBox[{5, 3}], 
      LineBox[{6, 8}], LineBox[{7, 8}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 8]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7127257515423839, 2.414831829334526}, {
     0.0033205987463897912`, 1.7097577582075656`}, {0.7059391523979848, 
     0.0020522840132326525`}, {0., 0.7106752975065056}, {1.7058768633939234`, 
     0.}, {2.4156455551162406`, 0.7047806547719655}, {1.713600127787104, 
     2.4128800023904704`}, {2.4192631229587427`, 1.70382353516607}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.759371655727203*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", 
   SuperscriptBox["d", "2"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"d", "+", 
     SuperscriptBox["d", "3"]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.759371655794629*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.7593716558620567`*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["d", "2"]}]}], 
  RowBox[{
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["d", "2"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.7593716559184957`*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.7593716559784307`*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.757570174740317*^9, {3.7575702063086634`*^9, 3.7575702239056253`*^9}, 
   3.7575706152822*^9, {3.7577504506198463`*^9, 3.7577504788533688`*^9}, 
   3.757751989602078*^9, 3.757855067398047*^9, {3.7578550994644947`*^9, 
   3.757855132742297*^9}, 3.75795229470093*^9, 3.757954447288729*^9, {
   3.7579620654271297`*^9, 3.7579620790798287`*^9}, 3.757962407188616*^9, 
   3.75834897124751*^9, 3.758349757051282*^9, 3.7583501280875072`*^9, 
   3.75906735473865*^9, {3.759067433194564*^9, 3.759067490428732*^9}, 
   3.759067528573159*^9, 3.759071148395961*^9, 3.759071188191439*^9, 
   3.7593716560493536`*^9},
 ExpressionUUID -> "44c733a0-7c65-4b6e-9140-cc7ed388faac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Graph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[UndirectedEdge]", "2"}], ",", 
      RowBox[{"2", "\[UndirectedEdge]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"marginal", ",", "#2"}], "]"}], ",", "Green", ",", "Red"}],
          "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"integrateAllUs", "[", 
     RowBox[{
      RowBox[{"tn", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Z1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"integrateAllUs", "[", 
     RowBox[{
      RowBox[{"tn", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"renyi2", "=", 
     RowBox[{"Z1", "/", "Z0"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{"renyi2", ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "Infinity", ",", "4"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"computeexponents", "[", 
      RowBox[{"g", ",", "marginal"}], "]"}]}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7579523150988717`*^9, 3.7579523167769957`*^9}, {
  3.757962414343359*^9, 3.757962428361206*^9}, {3.758349025809202*^9, 
  3.758349044727384*^9}, {3.7583491427759066`*^9, 3.7583491472573614`*^9}, {
  3.7583492025049314`*^9, 3.7583492404556217`*^9}, {3.7583501394063253`*^9, 
  3.758350139584116*^9}, {3.7590712025863423`*^9, 3.7590712277590775`*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0., 3.6739403974420594`*^-16}, {1., 
      2.4492935982947064`*^-16}, {2., 0.}}, 
      {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 3.6739403974420594*^-16}, 0.1], 
       {GrayLevel[0], InsetBox["1", {0., 3.6739403974420594*^-16}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1., 2.4492935982947064*^-16}, 0.1], 
       {GrayLevel[0], InsetBox["2", {1., 2.4492935982947064*^-16}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], DiskBox[{2., 0.}, 0.1], 
       {GrayLevel[0], InsetBox["3", {2., 0.}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 3.6739403974420594`*^-16}, {1., 
     2.4492935982947064`*^-16}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.759371656231157*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.488048364371523, -3.0313323841496236`}, {
    1.4353080884247384`, -3.0525022157618174`}, {
    0.3832628897545698, -3.032165640559458}, {
    2.486972524979387, -2.1202857706701064`}, {
    1.434346931709032, -2.0997338896312563`}, {
    0.3823218545002316, -2.1207608031279266`}, {
    2.488048364371523, -1.3139203490185993`}, {
    1.4353080884247384`, -1.3350901806307929`}, {
    0.3832628897545698, -1.3147536054284332`}, {
    2.486972524979387, -0.4028737355390818}, {
    1.434346931709032, -0.3823218545002316}, {
    0.3823218545002316, -0.40334876799690234`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 4}], 
      LineBox[{2, 3}], LineBox[{2, 5}], LineBox[{3, 6}], LineBox[{4, 5}], 
      LineBox[{5, 6}], LineBox[{7, 8}], LineBox[{7, 10}], LineBox[{8, 9}], 
      LineBox[{8, 11}], LineBox[{9, 12}], LineBox[{10, 11}], 
      LineBox[{11, 12}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 12]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.488048364371523, -3.0313323841496236`}, {
     1.4353080884247384`, -3.0525022157618174`}, {
     0.3832628897545698, -3.032165640559458}, {
     2.486972524979387, -2.1202857706701064`}, {
     1.434346931709032, -2.0997338896312563`}, {
     0.3823218545002316, -2.1207608031279266`}, {
     2.488048364371523, -1.3139203490185993`}, {
     1.4353080884247384`, -1.3350901806307929`}, {
     0.3832628897545698, -1.3147536054284332`}, {
     2.486972524979387, -0.4028737355390818}, {
     1.434346931709032, -0.3823218545002316}, {
     0.3823218545002316, -0.40334876799690234`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.7593716563340454`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.264608308892339, 1.6955156536355784`}, {
    0.9764539260809065, 1.6934235834346363`}, {0., 1.062709543862417}, {
    3.2246309391954293`, 1.0615089499281702`}, {2.2493433783398955`, 
    1.6932820458151188`}, {2.9606133623821647`, 1.6946188022252102`}, {
    3.181582539918236, 0.11625026088634849`}, {2.218140025903658, 
    0.00029943705344037674`}, {2.7197926537683177`, 0.7626309617902882}, {
    0.5033143447850357, 0.7635400423776577}, {1.0030302632928305`, 0.}, {
    0.04082762877157897, 0.11773614657237319`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 10}], 
      LineBox[{2, 3}], LineBox[{2, 5}], LineBox[{3, 12}], LineBox[{4, 5}], 
      LineBox[{5, 6}], LineBox[{7, 8}], LineBox[{7, 4}], LineBox[{8, 9}], 
      LineBox[{8, 11}], LineBox[{9, 6}], LineBox[{10, 11}], 
      LineBox[{11, 12}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 12]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.264608308892339, 1.6955156536355784`}, {
     0.9764539260809065, 1.6934235834346363`}, {0., 1.062709543862417}, {
     3.2246309391954293`, 1.0615089499281702`}, {2.2493433783398955`, 
     1.6932820458151188`}, {2.9606133623821647`, 1.6946188022252102`}, {
     3.181582539918236, 0.11625026088634849`}, {2.218140025903658, 
     0.00029943705344037674`}, {2.7197926537683177`, 0.7626309617902882}, {
     0.5033143447850357, 0.7635400423776577}, {1.0030302632928305`, 0.}, {
     0.04082762877157897, 0.11773614657237319`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.7593716564174547`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}]}]}], 
  RowBox[{"d", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["d", "2"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.759371656617238*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"d", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "d"}], ")"}]}]}], ")"}]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      SuperscriptBox["d", "3"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.75937165673561*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.759371656836501*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.7593716569164143`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "2"], ",", 
   FractionBox["3", "2"]}], "}"}]], "Output",
 CellChangeTimes->{{3.7583492310906057`*^9, 3.7583492408415956`*^9}, 
   3.758349766029104*^9, 3.758350140175683*^9, 3.7590712282078834`*^9, 
   3.759371657010812*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"CompleteGraph", "[", "6", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"marginal", ",", "#2"}], "]"}], ",", "Green", ",", "Red"}],
          "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z1", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"computeexponents", "[", 
   RowBox[{"g", ",", "marginal"}], "]"}], "\n", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Z1", "/", "Z0"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "Infinity", ",", "3"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"computeexponents", "[", 
     RowBox[{"g", ",", "marginal"}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7574783978279815`*^9, 3.757478397876851*^9}, {
   3.7574784404540157`*^9, 3.7574784546211295`*^9}, {3.757478875104587*^9, 
   3.75747891046704*^9}, {3.75747951911495*^9, 3.757479519429079*^9}, {
   3.757479940913908*^9, 3.757479945657209*^9}, {3.757480042359581*^9, 
   3.757480042592987*^9}, {3.7574801375390406`*^9, 3.7574801798189645`*^9}, {
   3.7574807539415665`*^9, 3.757480795273039*^9}, 3.7574809408168216`*^9, {
   3.757481015748439*^9, 3.7574810261067247`*^9}, {3.7574820186829042`*^9, 
   3.7574820188255014`*^9}, {3.757482308593561*^9, 3.7574824112041464`*^9}, {
   3.757482456327275*^9, 3.7574825182426853`*^9}, {3.7574825695155373`*^9, 
   3.7574826899624467`*^9}, {3.7574827215270042`*^9, 
   3.7574827501664476`*^9}, {3.7574827871305604`*^9, 3.757482796682043*^9}, {
   3.7574831902714434`*^9, 3.7574832511356506`*^9}, {3.7574833009903545`*^9, 
   3.7574833406293435`*^9}, {3.757484721201848*^9, 3.75748476313175*^9}, {
   3.757485642561889*^9, 3.7574856669347143`*^9}, {3.7574857117179456`*^9, 
   3.7574857234126434`*^9}, {3.7574858529462605`*^9, 3.757485867654925*^9}, {
   3.7574865386779966`*^9, 3.75748656018052*^9}, {3.7579626014410596`*^9, 
   3.7579626149483757`*^9}, {3.7583493014800787`*^9, 
   3.7583493206554527`*^9}, {3.758350152086079*^9, 3.7583501525118995`*^9}, {
   3.7590712419279194`*^9, 3.7590712527872343`*^9}},
 ExpressionUUID -> "3c15102c-d122-4495-af79-25be06054e25"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{-0.8660254037844389, 
      0.5000000000000008}, {-0.8660254037844384, -0.49999999999999933`}, {
      3.8285686989269494`*^-16, -1.}, {
      0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
      0.4999999999999992}, {1.8369701987210297`*^-16, 1.}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 4}, {2, 
        5}, {2, 6}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{-0.8660254037844389, 0.5000000000000008}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {-0.8660254037844389, 0.5000000000000008}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{-0.8660254037844384, -0.49999999999999933}, 0.1], 
       {GrayLevel[0], 
        InsetBox["2", {-0.8660254037844384, -0.49999999999999933}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.8285686989269494*^-16, -1.}, 0.1], 
       {GrayLevel[0], InsetBox["3", {3.8285686989269494*^-16, -1.}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8660254037844389, -0.5000000000000012}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {0.8660254037844389, -0.5000000000000012}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8660254037844386, 0.4999999999999992}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.8660254037844386, 0.4999999999999992}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.8369701987210297*^-16, 1.}, 0.1], 
       {GrayLevel[0], InsetBox["6", {1.8369701987210297*^-16, 1.}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{-0.8660254037844389, 
     0.5000000000000008}, {-0.8660254037844384, -0.49999999999999933`}, {
     3.8285686989269494`*^-16, -1.}, {
     0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
     0.4999999999999992}, {1.8369701987210297`*^-16, 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.7593716572705307`*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQfeVWIWes+mN7/mnFehp2LAdmWD102ql4xz4v/pFm
Yy3HAQeh5QvKdT7Z+0pLrT+sxHtgo2zRr49Gn+xTH7zTab7JfOCMRW+Ph9Jj
+08h0XZSB3gOTFh1Ojlu1md7i8u2n9TrOQ7cfOF4L/ckg4Ohi/89kPpFbrFv
qoQYHFr2yKl6NnAcaDwQ/HilGKvD76lh7qL7eA6Y899OqZNgdchz93Q7BHSP
77KckmvHGBwueZ18kKDGe2Dn0+9HX0SwOWjFnGXXaOQ4AHP/i+ds/g/d7u+H
uX+Hz3yvrIAP+2HuLzvCF/p+1s/9MPdD1e2Huf+A+cTiOVd/7Ie538ck7Pb2
4A/7Ye7/EfHk7D6gepj7n7BJOP4K/bAf5v5LO9tbJ138sR/m/gdFW3g3ed/f
D3N/g3LuDs1FP/fD3G/gVsq2I/zDfgCD7L5t
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{1, 5}], LineBox[{1, 6}], LineBox[{1, 7}], 
      LineBox[{2, 3}], LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{2, 6}], 
      LineBox[{2, 8}], LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{3, 6}], 
      LineBox[{3, 9}], LineBox[{4, 5}], LineBox[{4, 6}], LineBox[{4, 10}], 
      LineBox[{5, 6}], LineBox[{5, 11}], LineBox[{6, 12}], LineBox[{7, 8}], 
      LineBox[{7, 9}], LineBox[{7, 10}], LineBox[{7, 11}], LineBox[{7, 12}], 
      LineBox[{8, 9}], LineBox[{8, 10}], LineBox[{8, 11}], LineBox[{8, 12}], 
      LineBox[{9, 10}], LineBox[{9, 11}], LineBox[{9, 12}], LineBox[{10, 11}],
       LineBox[{10, 12}], LineBox[{11, 12}], LineBox[{13, 14}], 
      LineBox[{13, 15}], LineBox[{13, 16}], LineBox[{13, 17}], 
      LineBox[{13, 18}], LineBox[{13, 19}], LineBox[{14, 15}], 
      LineBox[{14, 16}], LineBox[{14, 17}], LineBox[{14, 18}], 
      LineBox[{14, 20}], LineBox[{15, 16}], LineBox[{15, 17}], 
      LineBox[{15, 18}], LineBox[{15, 21}], LineBox[{16, 17}], 
      LineBox[{16, 18}], LineBox[{16, 22}], LineBox[{17, 18}], 
      LineBox[{17, 23}], LineBox[{18, 24}], LineBox[{19, 20}], 
      LineBox[{19, 21}], LineBox[{19, 22}], LineBox[{19, 23}], 
      LineBox[{19, 24}], LineBox[{20, 21}], LineBox[{20, 22}], 
      LineBox[{20, 23}], LineBox[{20, 24}], LineBox[{21, 22}], 
      LineBox[{21, 23}], LineBox[{21, 24}], LineBox[{22, 23}], 
      LineBox[{22, 24}], LineBox[{23, 24}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 24]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGCQAGIQfeVWIWes+mN7/mnFehp2LAdmWD102ql4xz4v/pFm
Yy3HAQeh5QvKdT7Z+0pLrT+sxHtgo2zRr49Gn+xTH7zTab7JfOCMRW+Ph9Jj
+08h0XZSB3gOTFh1Ojlu1md7i8u2n9TrOQ7cfOF4L/ckg4Ohi/89kPpFbrFv
qoQYHFr2yKl6NnAcaDwQ/HilGKvD76lh7qL7eA6Y899OqZNgdchz93Q7BHSP
77KckmvHGBwueZ18kKDGe2Dn0+9HX0SwOWjFnGXXaOQ4AHP/i+ds/g/d7u+H
uX+Hz3yvrIAP+2HuLzvCF/p+1s/9MPdD1e2Huf+A+cTiOVd/7Ie538ck7Pb2
4A/7Ye7/EfHk7D6gepj7n7BJOP4K/bAf5v5LO9tbJ138sR/m/gdFW3g3ed/f
D3N/g3LuDs1FP/fD3G/gVsq2I/zDfgCD7L5t
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.7593716573699236`*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQLRh++v73Hi6HqtaIeT97n9r/a/r+6sQLTgfWG70b
HXQ/2rMf3H7Di4Xd4dBBC2MunXf2fbWxZ7XnMzkc4L+UNt96r/3H5/qmTK3M
Dil3E1T237hnH7bz4F6bu6wODUllHX8s1tgvcHt189HLPfY7TNTVzfa8tz/g
/Tds67ZV9lN8vv7feeaRPU/VjSVCG+/Zv5GQtVKWe2Nvtz9ajLX8qT0DFJxd
r2YWKf3OXqB3BieP4x37vtdprIYaH+031JnftZ+8Ba7u0R37V0lGrA4Lopk+
7HTcYp+V3Hi38A+jwxs16+IAyzv2rZfD+26yMztYTX+Zk3Lskf2xO3mLgpS5
HOZt2MP2bsN7e4nck0dXreB0OPRLX2qRzBv7F1wnxYN2sDlku3mYNi/ndFDQ
fHM9aBGTQ5n5q2OsSlwOH8yPyQvdZ3Uojv/DPAOojq2hI/N1J7PDnMb4HIdf
jA6z/yrOvvOG02Edj6Jigz6rg9Of95cTJ3E58BQV3xXlYHYo2ve5/hkHuwMA
m4Wqjg==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{1, 5}], LineBox[{1, 6}], LineBox[{1, 19}], 
      LineBox[{2, 3}], LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{2, 6}], 
      LineBox[{2, 20}], LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{3, 6}], 
      LineBox[{3, 21}], LineBox[{4, 5}], LineBox[{4, 6}], LineBox[{4, 10}], 
      LineBox[{5, 6}], LineBox[{5, 11}], LineBox[{6, 12}], LineBox[{7, 8}], 
      LineBox[{7, 9}], LineBox[{7, 10}], LineBox[{7, 11}], LineBox[{7, 12}], 
      LineBox[{8, 9}], LineBox[{8, 10}], LineBox[{8, 11}], LineBox[{8, 12}], 
      LineBox[{9, 10}], LineBox[{9, 11}], LineBox[{9, 12}], LineBox[{10, 11}],
       LineBox[{10, 12}], LineBox[{11, 12}], LineBox[{13, 14}], 
      LineBox[{13, 15}], LineBox[{13, 16}], LineBox[{13, 17}], 
      LineBox[{13, 18}], LineBox[{13, 7}], LineBox[{14, 15}], 
      LineBox[{14, 16}], LineBox[{14, 17}], LineBox[{14, 18}], 
      LineBox[{14, 8}], LineBox[{15, 16}], LineBox[{15, 17}], 
      LineBox[{15, 18}], LineBox[{15, 9}], LineBox[{16, 17}], 
      LineBox[{16, 18}], LineBox[{16, 22}], LineBox[{17, 18}], 
      LineBox[{17, 23}], LineBox[{18, 24}], LineBox[{19, 20}], 
      LineBox[{19, 21}], LineBox[{19, 22}], LineBox[{19, 23}], 
      LineBox[{19, 24}], LineBox[{20, 21}], LineBox[{20, 22}], 
      LineBox[{20, 23}], LineBox[{20, 24}], LineBox[{21, 22}], 
      LineBox[{21, 23}], LineBox[{21, 24}], LineBox[{22, 23}], 
      LineBox[{22, 24}], LineBox[{23, 24}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 24]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGCQAGIQLRh++v73Hi6HqtaIeT97n9r/a/r+6sQLTgfWG70b
HXQ/2rMf3H7Di4Xd4dBBC2MunXf2fbWxZ7XnMzkc4L+UNt96r/3H5/qmTK3M
Dil3E1T237hnH7bz4F6bu6wODUllHX8s1tgvcHt189HLPfY7TNTVzfa8tz/g
/Tds67ZV9lN8vv7feeaRPU/VjSVCG+/Zv5GQtVKWe2Nvtz9ajLX8qT0DFJxd
r2YWKf3OXqB3BieP4x37vtdprIYaH+031JnftZ+8Ba7u0R37V0lGrA4Lopk+
7HTcYp+V3Hi38A+jwxs16+IAyzv2rZfD+26yMztYTX+Zk3Lskf2xO3mLgpS5
HOZt2MP2bsN7e4nck0dXreB0OPRLX2qRzBv7F1wnxYN2sDlku3mYNi/ndFDQ
fHM9aBGTQ5n5q2OsSlwOH8yPyQvdZ3Uojv/DPAOojq2hI/N1J7PDnMb4HIdf
jA6z/yrOvvOG02Edj6Jigz6rg9Of95cTJ3E58BQV3xXlYHYo2ve5/hkHuwMA
m4Wqjg==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.759371657541238*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData[
 FractionBox[
  RowBox[{"35", "+", 
   RowBox[{"21", " ", 
    SuperscriptBox["d", "2"]}], "+", 
   RowBox[{"7", " ", 
    SuperscriptBox["d", "6"]}], "+", 
   SuperscriptBox["d", "12"]}], 
  RowBox[{
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["d", "6"]}], ")"}], "6"]}]]], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.7593716590251303`*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData["32"], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.7593716591110373`*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"15", " ", 
    SuperscriptBox["d", "2"]}], "+", 
   RowBox[{"27", " ", 
    SuperscriptBox["d", "4"]}], "+", 
   RowBox[{"13", " ", 
    SuperscriptBox["d", "6"]}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["d", "8"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["d", "12"]}]}], 
  RowBox[{
   SuperscriptBox["d", "11"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["d", "6"]}], ")"}], "6"]}]]], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.759371660914084*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData["35"], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.759371661020469*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["21", "2"], ",", 
   FractionBox["15", "2"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7574856678422527`*^9, {3.757485713593897*^9, 3.7574857239312515`*^9}, {
   3.75748655073578*^9, 3.757486560826764*^9}, 3.7574951380959015`*^9, 
   3.757570086954322*^9, {3.757962605913669*^9, 3.757962615217083*^9}, {
   3.7583492935516605`*^9, 3.758349321859922*^9}, 3.7583497884344025`*^9, 
   3.758350154122338*^9, 3.759071253235873*^9, 3.759371661127853*^9},
 ExpressionUUID -> "68e7a4bd-c218-44ff-b10d-30b9a64ed302"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"21", "-", "15"}]], "Input",
 CellChangeTimes->{{3.759071261959589*^9, 3.7590712631267147`*^9}}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{3.759071263832083*^9, 3.7593716613321314`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"squareLatticeGraph", "[", 
    RowBox[{"m_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "i", ",", "j"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", "m"}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "1"}], ",", 
          RowBox[{"j", "\[LessEqual]", 
           RowBox[{"n", "-", "1"}]}], ",", 
          RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"g", ",", 
             RowBox[{"UndirectedEdge", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"n", 
                 RowBox[{"(", 
                  RowBox[{"i", "-", "1"}], ")"}]}], "+", "j"}], ",", 
               RowBox[{
                RowBox[{"n", 
                 RowBox[{"(", 
                  RowBox[{"i", "-", "1"}], ")"}]}], "+", "j", "+", "1"}]}], 
              "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"m", "-", "1"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "1"}], ",", 
          RowBox[{"j", "\[LessEqual]", "n"}], ",", 
          RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"g", ",", 
             RowBox[{"UndirectedEdge", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"n", 
                 RowBox[{"(", 
                  RowBox[{"i", "-", "1"}], ")"}]}], "+", "j"}], ",", 
               RowBox[{
                RowBox[{"n", 
                 RowBox[{"(", "i", ")"}]}], "+", "j"}]}], "]"}]}], "]"}], 
           ";"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Graph", "[", "g", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7574939313760524`*^9, 3.757493943147605*^9}, {
  3.757494139310998*^9, 3.757494306761143*^9}, {3.7574943897671957`*^9, 
  3.757494399653718*^9}, {3.7574947652878838`*^9, 3.7574947957264795`*^9}, {
  3.757495394542041*^9, 3.757495397263764*^9}, {3.757495452194858*^9, 
  3.7574954684653797`*^9}, {3.7579531347482023`*^9, 3.757953162918661*^9}},
 ExpressionUUID -> "5647c35d-4f37-471d-9bd1-e1b56f41aab5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Graph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[UndirectedEdge]", "2"}], ",", 
      RowBox[{"2", "\[UndirectedEdge]", "3"}], ",", 
      RowBox[{"3", "\[UndirectedEdge]", "4"}], ",", 
      RowBox[{"4", "\[UndirectedEdge]", "5"}], ",", 
      RowBox[{"5", "\[UndirectedEdge]", "6"}], ",", 
      RowBox[{"6", "\[UndirectedEdge]", "1"}], ",", 
      RowBox[{"2", "\[UndirectedEdge]", "5"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"edgeNormalization", "=", 
   RowBox[{"d", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], 
      RowBox[{"EdgeCount", "[", "g", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"marginal", ",", "#2"}], "]"}]}], ",", "Red", ",", 
          "Green"}], "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z1", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"computeexponents", "[", 
   RowBox[{"g", ",", "marginal"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Z1", "/", "Z0"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "Infinity", ",", "3"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"computeexponents", "[", 
     RowBox[{"g", ",", "marginal"}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.757494287532598*^9, 3.7574942927127137`*^9}, {
   3.7574943294465127`*^9, 3.7574943315927706`*^9}, {3.7574944172227306`*^9, 
   3.757494419228366*^9}, {3.757494473948062*^9, 3.75749447858064*^9}, {
   3.7574945293788214`*^9, 3.7574945336344385`*^9}, 3.7574946313690653`*^9, {
   3.757494669775352*^9, 3.7574947181848516`*^9}, {3.757494774833355*^9, 
   3.7574948705434303`*^9}, {3.7574949881259375`*^9, 3.757495001695659*^9}, {
   3.757495316730138*^9, 3.757495350249528*^9}, {3.75749549798842*^9, 
   3.757495500656287*^9}, {3.757953181555457*^9, 3.757953187771717*^9}, {
   3.757953257655958*^9, 3.757953344091745*^9}, 3.757953381902753*^9, {
   3.7579538624887543`*^9, 3.757953929442207*^9}, {3.7579539646530404`*^9, 
   3.7579540598183465`*^9}, {3.7579543633492317`*^9, 3.757954381220417*^9}, {
   3.7579626495183992`*^9, 3.7579626645956125`*^9}, {3.7583493581202345`*^9, 
   3.7583493857931128`*^9}, 3.7583494536852202`*^9, {3.758349542063939*^9, 
   3.758349564970368*^9}, {3.758350162886183*^9, 3.7583501630250425`*^9}, {
   3.7590712796257854`*^9, 3.759071290492771*^9}},
 ExpressionUUID -> "b5cc9cb7-4f6c-4043-95de-e5c7bab3a60d"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.002565023953302159, 0.020103909215160698`}, {
      1.0536623915055698`, 0.}, {2.105136698961335, 0.020876169515363974`}, {
      2.105554699309111, 0.9324858079105091}, {1.0525332548796775`, 
      0.9533707690632327}, {0., 0.9318159981542953}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 6}, {2, 3}, {2, 5}, {3, 4}, {4, 5}, {5, 6}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.002565023953302159, 0.020103909215160698}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.002565023953302159, 0.020103909215160698}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.0536623915055698, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {1.0536623915055698, 0.}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.105136698961335, 0.020876169515363974}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {2.105136698961335, 0.020876169515363974}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.105554699309111, 0.9324858079105091}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {2.105554699309111, 0.9324858079105091}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.0525332548796775, 0.9533707690632327}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {1.0525332548796775, 0.9533707690632327}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 0.9318159981542953}, 0.1], 
       {GrayLevel[0], InsetBox["6", {0., 0.9318159981542953}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.002565023953302159, 0.020103909215160698`}, {
     1.0536623915055698`, 0.}, {2.105136698961335, 0.020876169515363974`}, {
     2.105554699309111, 0.9324858079105091}, {1.0525332548796775`, 
     0.9533707690632327}, {0., 0.9318159981542953}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.7593716615883536`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQbZe24RD7dE6HE1I3Wlf3ixzITbzdunURg0Op2bZl
podFDqR1TeIsWffO/nOzw3bmdSIHGko3xHdNeGSvHRTwZ2uP4IFzE36YNfn/
se/4rPa+o0XwwLoA3fLqAnYHTfkVr5YWCB4we8O7mPsHt4PfpR9T7EQFD1Tc
s36lX8zksNf8vrC5tOCBum9yx8SCP9kveZj2aYae4IG4TyuN5jK9sU/YGeW5
RZHngEZgGoPTp//2rUkzujJ3ch/wi/JcGvKJwyFDKLcy8gn3AZj7sz8wSwpw
McHdf1T9QJRKIRPc/YcOXak+4MYEd3/SvhfcXhw/9sPcf8PZ+frU59/3w9wf
9cn9KOeM7/th7n+3rysvR+vbfpj714SoZPk5fdsPc7/HH6cnV/u/7Ye5/92F
nVFbDZ/sh7kfau9+mPt5TJmlvWwe7wcACJW5jg==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 7}], 
      LineBox[{2, 3}], LineBox[{2, 5}], LineBox[{2, 8}], LineBox[{3, 4}], 
      LineBox[{3, 9}], LineBox[{4, 5}], LineBox[{4, 10}], LineBox[{5, 6}], 
      LineBox[{5, 11}], LineBox[{6, 1}], LineBox[{6, 12}], LineBox[{7, 8}], 
      LineBox[{8, 9}], LineBox[{8, 11}], LineBox[{9, 10}], LineBox[{10, 11}], 
      LineBox[{11, 12}], LineBox[{12, 7}], LineBox[{13, 14}], 
      LineBox[{13, 19}], LineBox[{14, 15}], LineBox[{14, 17}], 
      LineBox[{14, 20}], LineBox[{15, 16}], LineBox[{15, 21}], 
      LineBox[{16, 17}], LineBox[{16, 22}], LineBox[{17, 18}], 
      LineBox[{17, 23}], LineBox[{18, 13}], LineBox[{18, 24}], 
      LineBox[{19, 20}], LineBox[{20, 21}], LineBox[{20, 23}], 
      LineBox[{21, 22}], LineBox[{22, 23}], LineBox[{23, 24}], 
      LineBox[{24, 19}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 24]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGCQAGIQbZe24RD7dE6HE1I3Wlf3ixzITbzdunURg0Op2bZl
podFDqR1TeIsWffO/nOzw3bmdSIHGko3xHdNeGSvHRTwZ2uP4IFzE36YNfn/
se/4rPa+o0XwwLoA3fLqAnYHTfkVr5YWCB4we8O7mPsHt4PfpR9T7EQFD1Tc
s36lX8zksNf8vrC5tOCBum9yx8SCP9kveZj2aYae4IG4TyuN5jK9sU/YGeW5
RZHngEZgGoPTp//2rUkzujJ3ch/wi/JcGvKJwyFDKLcy8gn3AZj7sz8wSwpw
McHdf1T9QJRKIRPc/YcOXak+4MYEd3/SvhfcXhw/9sPcf8PZ+frU59/3w9wf
9cn9KOeM7/th7n+3rysvR+vbfpj714SoZPk5fdsPc7/HH6cnV/u/7Ye5/92F
nVFbDZ/sh7kfau9+mPt5TJmlvWwe7wcACJW5jg==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.7593716617826433`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAApFJO4kRi9j/uVz77wtMKQI9JP3Fz
5QBAAJZLLJqpCkC5VN9KOKYGQEXGvQkAWwpAc+N43eTo/D/5HdNxG4AFQDLQ
BDkAbfE/iEFyafAQBkDM9fFU8V3ZP5S2+/b0egZA+EibBqrX1z9uW46fUIzj
P+bBI9BR6fA/dEIr4Wkv4z9UtDbVXjr8P8JdtdCTseI/QBH+Pa2F9j/D/V33
+BP6P6TaLukLEuY/bLc7fMbk+j8AAAAAAAAAAGQWWo2UePs/rmZv58LN9T/g
EmZU/52xP+nQeILGogBAwLn0gwVFkT9FXRGpz0UGQAAAAAAAAAAApK/2IM5S
DkCkFFvO3CHhPzg7YmpezQhAhFKhiTDf4j8yF3U4EhQDQGAYDKcIbOU/U74L
3GdyA0C43e5AYjAGQCcPm3yQIAlAYgS/1c4YBkBrFTIk6p0OQOrOv26W9gVA
TW8SWsfGEEBXPrquYQj6P8+QhfxrCwxANKvepua3+j/67WYnzkYGQA/wkUK0
bPs/cMewaQ==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 19}], 
      LineBox[{2, 3}], LineBox[{2, 5}], LineBox[{2, 20}], LineBox[{3, 4}], 
      LineBox[{3, 21}], LineBox[{4, 5}], LineBox[{4, 10}], LineBox[{5, 6}], 
      LineBox[{5, 11}], LineBox[{6, 1}], LineBox[{6, 12}], LineBox[{7, 8}], 
      LineBox[{8, 9}], LineBox[{8, 11}], LineBox[{9, 10}], LineBox[{10, 11}], 
      LineBox[{11, 12}], LineBox[{12, 7}], LineBox[{13, 14}], 
      LineBox[{13, 7}], LineBox[{14, 15}], LineBox[{14, 17}], 
      LineBox[{14, 8}], LineBox[{15, 16}], LineBox[{15, 9}], 
      LineBox[{16, 17}], LineBox[{16, 22}], LineBox[{17, 18}], 
      LineBox[{17, 23}], LineBox[{18, 13}], LineBox[{18, 24}], 
      LineBox[{19, 20}], LineBox[{20, 21}], LineBox[{20, 23}], 
      LineBox[{21, 22}], LineBox[{22, 23}], LineBox[{23, 24}], 
      LineBox[{24, 19}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 24]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAApFJO4kRi9j/uVz77wtMKQI9JP3Fz
5QBAAJZLLJqpCkC5VN9KOKYGQEXGvQkAWwpAc+N43eTo/D/5HdNxG4AFQDLQ
BDkAbfE/iEFyafAQBkDM9fFU8V3ZP5S2+/b0egZA+EibBqrX1z9uW46fUIzj
P+bBI9BR6fA/dEIr4Wkv4z9UtDbVXjr8P8JdtdCTseI/QBH+Pa2F9j/D/V33
+BP6P6TaLukLEuY/bLc7fMbk+j8AAAAAAAAAAGQWWo2UePs/rmZv58LN9T/g
EmZU/52xP+nQeILGogBAwLn0gwVFkT9FXRGpz0UGQAAAAAAAAAAApK/2IM5S
DkCkFFvO3CHhPzg7YmpezQhAhFKhiTDf4j8yF3U4EhQDQGAYDKcIbOU/U74L
3GdyA0C43e5AYjAGQCcPm3yQIAlAYgS/1c4YBkBrFTIk6p0OQOrOv26W9gVA
TW8SWsfGEEBXPrquYQj6P8+QhfxrCwxANKvepua3+j/67WYnzkYGQA/wkUK0
bPs/cMewaQ==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.759371662098801*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "+", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"9", "+", 
      RowBox[{"d", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "d", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["d", "3"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["d", "4"]}], "+", 
         SuperscriptBox["d", "5"]}], ")"}]}]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox["d", "18"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
   " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["d", "4"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.759371662892941*^9}],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.759371662997328*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"d", " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"d", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", "d"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], 
  RowBox[{
   SuperscriptBox["d", "19"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
   " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["d", "4"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.7593716637110543`*^9}],

Cell[BoxData["31"], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.759371663830925*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["13", "2"], ",", 
   FractionBox["7", "2"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.758349533189996*^9, 3.758349566125863*^9, 3.7583498015083275`*^9, 
   3.75835016360909*^9, {3.7590712743177476`*^9, 3.7590712908901377`*^9}, 
   3.7593716640307083`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "=", 
     RowBox[{"Graph", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[UndirectedEdge]", "2"}], ",", 
        RowBox[{"2", "\[UndirectedEdge]", "3"}], ",", 
        RowBox[{"3", "\[UndirectedEdge]", "4"}], ",", 
        RowBox[{"4", "\[UndirectedEdge]", "5"}], ",", 
        RowBox[{"5", "\[UndirectedEdge]", "6"}], ",", 
        RowBox[{"6", "\[UndirectedEdge]", "1"}], ",", 
        RowBox[{"2", "\[UndirectedEdge]", "5"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g", "=", 
     RowBox[{"EdgeDelete", "[", 
      RowBox[{"g", ",", 
       RowBox[{"{", 
        RowBox[{"2", "\[UndirectedEdge]", "5"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"edgeNormalization", "=", 
     RowBox[{"d", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], 
        RowBox[{"EdgeCount", "[", "g", "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GraphPlot", "[", 
    RowBox[{"g", ",", 
     RowBox[{"VertexRenderingFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"MemberQ", "[", 
              RowBox[{"marginal", ",", "#2"}], "]"}]}], ",", "Red", ",", 
            "Green"}], "]"}], ",", 
          RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
          RowBox[{"Text", "[", 
           RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], "]"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tn", "=", 
     RowBox[{"buildTNfromGraph", "[", 
      RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"visualizeTN", "[", 
    RowBox[{"tn", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"visualizeTN", "[", 
    RowBox[{"tn", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Z0", "=", 
    RowBox[{
     RowBox[{"edgeNormalization", " ", 
      RowBox[{
       RowBox[{"integrateAllUs", "[", 
        RowBox[{
         RowBox[{"tn", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
      RowBox[{"Log", "[", "d", "]"}]}], ",", 
     RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Z1", "=", 
    RowBox[{
     RowBox[{"edgeNormalization", " ", 
      RowBox[{
       RowBox[{"integrateAllUs", "[", 
        RowBox[{
         RowBox[{"tn", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
      RowBox[{"Log", "[", "d", "]"}]}], ",", 
     RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"computeexponents", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7583494894002504`*^9, 3.7583494907838573`*^9}, {
  3.758350168925909*^9, 3.75835016920704*^9}, {3.7590713197082176`*^9, 
  3.759071333106299*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{-0.8660254037844389, 
      0.5000000000000008}, {-0.8660254037844384, -0.49999999999999933`}, {
      3.8285686989269494`*^-16, -1.}, {
      0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
      0.4999999999999992}, {1.8369701987210297`*^-16, 1.}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 6}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{-0.8660254037844389, 0.5000000000000008}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {-0.8660254037844389, 0.5000000000000008}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{-0.8660254037844384, -0.49999999999999933}, 0.1], 
       {GrayLevel[0], 
        InsetBox["2", {-0.8660254037844384, -0.49999999999999933}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.8285686989269494*^-16, -1.}, 0.1], 
       {GrayLevel[0], InsetBox["3", {3.8285686989269494*^-16, -1.}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8660254037844389, -0.5000000000000012}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {0.8660254037844389, -0.5000000000000012}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8660254037844386, 0.4999999999999992}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.8660254037844386, 0.4999999999999992}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.8369701987210297*^-16, 1.}, 0.1], 
       {GrayLevel[0], InsetBox["6", {1.8369701987210297*^-16, 1.}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{-0.8660254037844389, 
     0.5000000000000008}, {-0.8660254037844384, -0.49999999999999933`}, {
     3.8285686989269494`*^-16, -1.}, {
     0.8660254037844389, -0.5000000000000012}, {0.8660254037844386, 
     0.4999999999999992}, {1.8369701987210297`*^-16, 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.7593716645531435`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQLfykVFF43mf7uEmZLIotogeCdq/f/HnqX/sige/X
v3NIHlg4bd1OrYfsDgrlX5tSJSUPdIs9M2W8weVQpdurcOuRyAHxgrTcvHms
Dv1bM+drGgsesFj8LuN64k/7Hfytv46aCB5QMeRR0sp6Yn/q+g7elfziB27w
L8lQWfXFfsMNvqLmfVIHmCY/nnjfkdlB48sBveV7pA58K+Cz+qXA5mCm7HX2
c47YgSO9KdKr1RgdRBbYLPnzQuiAy65j6TuVP9gX65486X1D6ADM/We6WZd+
qvi9H+Z+/kNzf6odY4G7P6t/lj/Tcxa4+x1+TBa9/vnHfpj7oe7cD3N/BtPz
XzzlT/bD3H8gQDG18zID3P3dQWd17Qw54O6v7jRc3qrLAXe/zvn2E7Yy//fD
3L/kUKBKIs/H/TD3K/5o3jX35If9AIWqtjk=
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 7}], 
      LineBox[{2, 3}], LineBox[{2, 8}], LineBox[{3, 4}], LineBox[{3, 9}], 
      LineBox[{4, 5}], LineBox[{4, 10}], LineBox[{5, 6}], LineBox[{5, 11}], 
      LineBox[{6, 1}], LineBox[{6, 12}], LineBox[{7, 8}], LineBox[{8, 9}], 
      LineBox[{9, 10}], LineBox[{10, 11}], LineBox[{11, 12}], 
      LineBox[{12, 7}], LineBox[{13, 14}], LineBox[{13, 19}], 
      LineBox[{14, 15}], LineBox[{14, 20}], LineBox[{15, 16}], 
      LineBox[{15, 21}], LineBox[{16, 17}], LineBox[{16, 22}], 
      LineBox[{17, 18}], LineBox[{17, 23}], LineBox[{18, 13}], 
      LineBox[{18, 24}], LineBox[{19, 20}], LineBox[{20, 21}], 
      LineBox[{21, 22}], LineBox[{22, 23}], LineBox[{23, 24}], 
      LineBox[{24, 19}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 24]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGCQAGIQLfykVFF43mf7uEmZLIotogeCdq/f/HnqX/sige/X
v3NIHlg4bd1OrYfsDgrlX5tSJSUPdIs9M2W8weVQpdurcOuRyAHxgrTcvHms
Dv1bM+drGgsesFj8LuN64k/7Hfytv46aCB5QMeRR0sp6Yn/q+g7elfziB27w
L8lQWfXFfsMNvqLmfVIHmCY/nnjfkdlB48sBveV7pA58K+Cz+qXA5mCm7HX2
c47YgSO9KdKr1RgdRBbYLPnzQuiAy65j6TuVP9gX65486X1D6ADM/We6WZd+
qvi9H+Z+/kNzf6odY4G7P6t/lj/Tcxa4+x1+TBa9/vnHfpj7oe7cD3N/BtPz
XzzlT/bD3H8gQDG18zID3P3dQWd17Qw54O6v7jRc3qrLAXe/zvn2E7Yy//fD
3L/kUKBKIs/H/TD3K/5o3jX35If9AIWqtjk=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.7593716649237413`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAbfF+zdkfBUCiuhCvkWEMQLZIz+Lq
TQpAOgts1ZVQDEBWccUSX28EQG/wEWTewwdAGAPYsqN49D+O7AOT1EAIQA5/
usyjKuY/+ld4lU18DUA+J6WWAqv2P5KAN9Xl+AxAxJYaja414D/fH/zC3l34
PwAAAAAAAAAAcNnZ0aJ55j/sLKFiCZLaP/B8j/ZB3fA/MAS66DV92D8v/Inp
aYACQOBQ2QwVl7Y/wmHoCLVYCUBQKxuyjSvjP9tPUIixPwZAOkj0wx2p9D9g
pJqNXNvmPzYtfCczt+E/SOWZWYPewj/zNb8+RijzP2D8HsGyC8I/Si5Z90li
A0Dg5yla/ruwP/BbvFHyLwlAAAAAAAAAAAD00fhJAX8EQLIHMtBY6uQ/nM49
PqVYC0DeaIjN4BIFQIy7GAlHuw5AgvgxiGbbB0D4xm0ua7gKQCL0r/ajSwFA
vOUSvbf0CUB8y6n30uvsP9Ie4rw0BQ5ApoiE2saR4D/G7BCHX6ALQPgenSrH
/fU/9Ka0eg==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 19}], 
      LineBox[{2, 3}], LineBox[{2, 20}], LineBox[{3, 4}], LineBox[{3, 21}], 
      LineBox[{4, 5}], LineBox[{4, 10}], LineBox[{5, 6}], LineBox[{5, 11}], 
      LineBox[{6, 1}], LineBox[{6, 12}], LineBox[{7, 8}], LineBox[{8, 9}], 
      LineBox[{9, 10}], LineBox[{10, 11}], LineBox[{11, 12}], 
      LineBox[{12, 7}], LineBox[{13, 14}], LineBox[{13, 7}], 
      LineBox[{14, 15}], LineBox[{14, 8}], LineBox[{15, 16}], 
      LineBox[{15, 9}], LineBox[{16, 17}], LineBox[{16, 22}], 
      LineBox[{17, 18}], LineBox[{17, 23}], LineBox[{18, 13}], 
      LineBox[{18, 24}], LineBox[{19, 20}], LineBox[{20, 21}], 
      LineBox[{21, 22}], LineBox[{22, 23}], LineBox[{23, 24}], 
      LineBox[{24, 19}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 24]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAbfF+zdkfBUCiuhCvkWEMQLZIz+Lq
TQpAOgts1ZVQDEBWccUSX28EQG/wEWTewwdAGAPYsqN49D+O7AOT1EAIQA5/
usyjKuY/+ld4lU18DUA+J6WWAqv2P5KAN9Xl+AxAxJYaja414D/fH/zC3l34
PwAAAAAAAAAAcNnZ0aJ55j/sLKFiCZLaP/B8j/ZB3fA/MAS66DV92D8v/Inp
aYACQOBQ2QwVl7Y/wmHoCLVYCUBQKxuyjSvjP9tPUIixPwZAOkj0wx2p9D9g
pJqNXNvmPzYtfCczt+E/SOWZWYPewj/zNb8+RijzP2D8HsGyC8I/Si5Z90li
A0Dg5yla/ruwP/BbvFHyLwlAAAAAAAAAAAD00fhJAX8EQLIHMtBY6uQ/nM49
PqVYC0DeaIjN4BIFQIy7GAlHuw5AgvgxiGbbB0D4xm0ua7gKQCL0r/ajSwFA
vOUSvbf0CUB8y6n30uvsP9Ie4rw0BQ5ApoiE2saR4D/G7BCHX6ALQPgenSrH
/fU/9Ka0eg==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.7593716651964464`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["d", "15"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "d"}], ")"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], 
    "6"]}]]], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.7593716659905853`*^9}],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.759371666224832*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"d", " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", "d"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox["d", "16"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "d"}], ")"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], 
    "6"]}]]], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.7593716668376675`*^9}],

Cell[BoxData["26"], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.7593716669460506`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.758349502232813*^9, 3.758350172608177*^9, 
  3.759071333905114*^9, 3.759371667074911*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"squareLatticeGraph", "[", 
    RowBox[{"4", ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "10", ",", "11"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"marginal", ",", "#2"}], "]"}]}], ",", "Red", ",", 
          "Green"}], "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z1", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
     RowBox[{"Log", "[", "d", "]"}]}], ",", 
    RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Z1", "/", "Z0"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "Infinity", ",", "3"}], "}"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7574955290353947`*^9, 3.7574955399930863`*^9}, {
  3.757962685414979*^9, 3.7579626958676467`*^9}, {3.757962732642779*^9, 
  3.7579627949637127`*^9}, {3.758350180414336*^9, 3.758350198934317*^9}, {
  3.758350314624346*^9, 3.758350316438711*^9}},
 ExpressionUUID -> "f8367793-63bc-444f-8138-a5514013ae06"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.06445039786353624, 0.03975936004709957}, {
      1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
      3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
      0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
      2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
      1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
      2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
      3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
      2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
      2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
      3.0081501925681415`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
        6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 10}, {9, 
        13}, {10, 11}, {10, 14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {14, 
        15}, {15, 16}}]}], {
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.06445039786353624, 0.03975936004709957}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.06445039786353624, 0.03975936004709957}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.0036656179292778, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {1.0036656179292778, 0.}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.069128569913092, 0.008371147079157648}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {2.069128569913092, 0.008371147079157648}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.008385085706979, 0.0638054315390828}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {3.008385085706979, 0.0638054315390828}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.007980584197669671, 0.9792408360644795}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.007980584197669671, 0.9792408360644795}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9798966882042173, 0.9704561192526617}, 0.1], 
       {GrayLevel[0], 
        InsetBox["6", {0.9798966882042173, 0.9704561192526617}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0788742495115127, 0.9797479274578499}, 0.1], 
       {GrayLevel[0], 
        InsetBox["7", {2.0788742495115127, 0.9797479274578499}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0491561344905045, 1.0035986779750865}, 0.1], 
       {GrayLevel[0], 
        InsetBox["8", {3.0491561344905045, 1.0035986779750865}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 2.044861098298084}, 0.1], 
       {GrayLevel[0], InsetBox["9", {0., 2.044861098298084}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.971383681625486, 2.0693675735977783}, 0.1], 
       {GrayLevel[0], 
        InsetBox["10", {0.971383681625486, 2.0693675735977783}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.070153806986097, 2.0786044432653603}, 0.1], 
       {GrayLevel[0], 
        InsetBox["11", {2.070153806986097, 2.0786044432653603}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0413284390602406, 2.068940685090622}, 0.1], 
       {GrayLevel[0], 
        InsetBox["12", {3.0413284390602406, 2.068940685090622}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.04062357638236036, 2.984844005621651}, 0.1], 
       {GrayLevel[0], 
        InsetBox["13", {0.04062357638236036, 2.984844005621651}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9794392576731297, 3.0406513989835564}, 0.1], 
       {GrayLevel[0], 
        InsetBox["14", {0.9794392576731297, 3.0406513989835564}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0452812178624686, 3.049337825525834}, 0.1], 
       {GrayLevel[0], 
        InsetBox["15", {2.0452812178624686, 3.049337825525834}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9858570468615255, 3.0081501925681415}, 0.1], 
       {GrayLevel[0], 
        InsetBox["16", {2.9858570468615255, 3.0081501925681415}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.06445039786353624, 0.03975936004709957}, {
     1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
     3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
     0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
     2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
     1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
     2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
     3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
     2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
     2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
     3.0081501925681415`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.759371667383577*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 17}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 18}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 21}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 22}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 23}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 26}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 49}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 50}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 53}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 54}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 55}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 58}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.75937166774069*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9k3k0GwYcxyOSitSRSBwjrSpaedT1POdrfr9O1zHU0RjP3NaqtWXW17Ki
Mw2qWNrN1FUy01LVosPMzUarnbT6iLUrdV8zcaVxJbbuj33f+7zPX58/vwbh
MT4niQQCAf/lnRvbMzOjYA6yJjolvYEaKOdZQnzzElgWSA8ptarh79NeB81D
Z4AnLumvFii9y/7btkPkgniDiN6hW+VZ6xJwrhB66Keo4zzfz6LGQgFtO2aj
nOlUrGkISKGwZJBnG1Sc70pE5pHbx6jDU/Dn2WcRRJdtYHfrvmT9JIWee1dZ
6WIlzG2QBSkuEpFdyM5eGldAll4i0ggKWJlnE827sAZlZ4PNU++IIZwj9E+5
tACk/aOLrdy/YfXiz+dZlUQ841PksaIrhfP3U/ftubsB2f1sXvioBEYJAWOu
3ClI9HywFtszAwIbbWeSuBM4b/fm+z1ehad8Vt/NIgbWsV9kF3y8Dm3dj8ve
ttLw+XgtPFpbhs0bnsFoSsXGuIwuwetBuNFI4m59Scbhbj9STbwMmqz0xEID
Og4+KZq0oJHRxdEhWjdcFUuNayfyw4joc+kuctPIyNrXCyuSZTie3dOhG0ZA
lwiyiptIBsKVrGmrDCqWLEvuWf+4C481CnWvHCLjgfg3N1OekFDQEFkaaLYJ
HO4U2SNYCjb8hBD1r5ehTcdev6dNAmxbQkBxEgnTR8vLw3LkkHuxaXh3gQxy
7YNSzE/JQDSoHGJW8xc8GlxMvMBbBYFScZuNnRAmH1qJRRpa+A31h4U5JQaa
LUW6i64zsF1eYWmyRMOAsV8PC5CBZTub44QIKsq3krwdAjXxCC9n4Mw1Ejom
edwaZWqiP9OYwqHS0GKE4KSQQUOv6qnKpxsq2Ou7M/TFAXUsXjfqjfAiY6Kh
s9MdFgO1XhquqWXKobXJ99X+41roQ1Fp36uhjCrTFiZWv9HxoYf3J7cXSRjQ
PM59HkvDBW7agKH7Jsy/eMX3zmJgpa/RV259i2AYcpCvQnkPCevzqVwOCW1n
umyS92jhlShvZ5HdDnx2IjrM9DUTz9lrDE1Kl2CNYkz5ZVYTTRxGTp9jDYDc
tIxXzGbi4qw35JVroJf2LUlJNR1J9TqVBsY0tKts79f7lI4OCyFv8k9R8Hud
jl0+eQy0PXE4mV9HxJytxA/rrRn4h31/S+Hnapi36mqe66qKbt9Gx+XoU1G3
jK7WG7sbx4ROnpeViHg93T849Ds6Jl+mpql7bkDV0Sr75Cwmtryf4m4k2oWB
jrSExjp1zAs5GSN6oICZp2cUpYqqWCXn6FQJVoHfXEEMu0/Ha2RO3HjXBHg9
6x5qqdLGTknhnHW3AsaMQPBSNhP9OR/JOFqbMHBUOaFTooEutbS+7fFpqP+g
NJqtz/z/x/8A0xvFVA==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 17}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 18}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 21}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 54}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 55}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 58}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 59}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 49}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 50}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 53}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 22}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 23}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 26}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 27}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9k3k0GwYcxyOSitSRSBwjrSpaedT1POdrfr9O1zHU0RjP3NaqtWXW17Ki
Mw2qWNrN1FUy01LVosPMzUarnbT6iLUrdV8zcaVxJbbuj33f+7zPX58/vwbh
MT4niQQCAf/lnRvbMzOjYA6yJjolvYEaKOdZQnzzElgWSA8ptarh79NeB81D
Z4AnLumvFii9y/7btkPkgniDiN6hW+VZ6xJwrhB66Keo4zzfz6LGQgFtO2aj
nOlUrGkISKGwZJBnG1Sc70pE5pHbx6jDU/Dn2WcRRJdtYHfrvmT9JIWee1dZ
6WIlzG2QBSkuEpFdyM5eGldAll4i0ggKWJlnE827sAZlZ4PNU++IIZwj9E+5
tACk/aOLrdy/YfXiz+dZlUQ841PksaIrhfP3U/ftubsB2f1sXvioBEYJAWOu
3ClI9HywFtszAwIbbWeSuBM4b/fm+z1ehad8Vt/NIgbWsV9kF3y8Dm3dj8ve
ttLw+XgtPFpbhs0bnsFoSsXGuIwuwetBuNFI4m59Scbhbj9STbwMmqz0xEID
Og4+KZq0oJHRxdEhWjdcFUuNayfyw4joc+kuctPIyNrXCyuSZTie3dOhG0ZA
lwiyiptIBsKVrGmrDCqWLEvuWf+4C481CnWvHCLjgfg3N1OekFDQEFkaaLYJ
HO4U2SNYCjb8hBD1r5ehTcdev6dNAmxbQkBxEgnTR8vLw3LkkHuxaXh3gQxy
7YNSzE/JQDSoHGJW8xc8GlxMvMBbBYFScZuNnRAmH1qJRRpa+A31h4U5JQaa
LUW6i64zsF1eYWmyRMOAsV8PC5CBZTub44QIKsq3krwdAjXxCC9n4Mw1Ejom
edwaZWqiP9OYwqHS0GKE4KSQQUOv6qnKpxsq2Ou7M/TFAXUsXjfqjfAiY6Kh
s9MdFgO1XhquqWXKobXJ99X+41roQ1Fp36uhjCrTFiZWv9HxoYf3J7cXSRjQ
PM59HkvDBW7agKH7Jsy/eMX3zmJgpa/RV259i2AYcpCvQnkPCevzqVwOCW1n
umyS92jhlShvZ5HdDnx2IjrM9DUTz9lrDE1Kl2CNYkz5ZVYTTRxGTp9jDYDc
tIxXzGbi4qw35JVroJf2LUlJNR1J9TqVBsY0tKts79f7lI4OCyFv8k9R8Hud
jl0+eQy0PXE4mV9HxJytxA/rrRn4h31/S+Hnapi36mqe66qKbt9Gx+XoU1G3
jK7WG7sbx4ROnpeViHg93T849Ds6Jl+mpql7bkDV0Sr75Cwmtryf4m4k2oWB
jrSExjp1zAs5GSN6oICZp2cUpYqqWCXn6FQJVoHfXEEMu0/Ha2RO3HjXBHg9
6x5qqdLGTknhnHW3AsaMQPBSNhP9OR/JOFqbMHBUOaFTooEutbS+7fFpqP+g
NJqtz/z/x/8A0xvFVA==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.759371667964947*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"28", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "36"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"82", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "4"}], "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"106", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"220", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "46"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"536", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "416"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"640", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "324"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"116", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"294", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "512"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"689", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "702"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"645", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "500"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"344", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "204"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"110", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "d"}], ")"}], " ", "d", " ", 
                    RowBox[{"(", 
                    RowBox[{"13", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.7593716897448554`*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData["60"], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.7593716903347173`*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"32", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "32"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"43", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{"166", "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "139"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"400", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "71"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"178", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"279", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "232"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"534", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "460"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"504", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "328"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"239", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "142"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"91", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "48"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"21", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.759371712089652*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData["64"], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.7593717124777317`*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "16"}], "}"}]], "Output",
 CellChangeTimes->{
  3.757495540399965*^9, 3.75796269675918*^9, {3.7579627752910414`*^9, 
   3.7579627956774397`*^9}, 3.7583501993334155`*^9, 3.7590713486966696`*^9, 
   3.7593717896281643`*^9},
 ExpressionUUID -> "4e72cba9-dce3-4c58-a043-9375279d8655"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"squareLatticeGraph", "[", 
    RowBox[{"4", ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "10"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"marginal", ",", "#2"}], "]"}]}], ",", "Red", ",", 
          "Green"}], "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z1", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
     RowBox[{"Log", "[", "d", "]"}]}], ",", 
    RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Z1", "/", "Z0"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "Infinity", ",", "3"}], "}"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}]}], "Input",
 CellChangeTimes->{{3.757496090274413*^9, 3.757496090567627*^9}, 
   3.757496774394609*^9, {3.757962837931131*^9, 3.7579628477105865`*^9}, {
   3.758350222406451*^9, 3.758350228717785*^9}, {3.7583506803596296`*^9, 
   3.758350682598572*^9}},
 ExpressionUUID -> "78070770-eeba-430c-96a1-11821b6fe85c"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.06445039786353624, 0.03975936004709957}, {
      1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
      3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
      0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
      2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
      1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
      2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
      3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
      2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
      2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
      3.0081501925681415`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
        6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 10}, {9, 
        13}, {10, 11}, {10, 14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {14, 
        15}, {15, 16}}]}], {
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.06445039786353624, 0.03975936004709957}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.06445039786353624, 0.03975936004709957}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.0036656179292778, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {1.0036656179292778, 0.}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.069128569913092, 0.008371147079157648}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {2.069128569913092, 0.008371147079157648}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.008385085706979, 0.0638054315390828}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {3.008385085706979, 0.0638054315390828}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.007980584197669671, 0.9792408360644795}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.007980584197669671, 0.9792408360644795}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9798966882042173, 0.9704561192526617}, 0.1], 
       {GrayLevel[0], 
        InsetBox["6", {0.9798966882042173, 0.9704561192526617}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0788742495115127, 0.9797479274578499}, 0.1], 
       {GrayLevel[0], 
        InsetBox["7", {2.0788742495115127, 0.9797479274578499}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0491561344905045, 1.0035986779750865}, 0.1], 
       {GrayLevel[0], 
        InsetBox["8", {3.0491561344905045, 1.0035986779750865}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 2.044861098298084}, 0.1], 
       {GrayLevel[0], InsetBox["9", {0., 2.044861098298084}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.971383681625486, 2.0693675735977783}, 0.1], 
       {GrayLevel[0], 
        InsetBox["10", {0.971383681625486, 2.0693675735977783}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.070153806986097, 2.0786044432653603}, 0.1], 
       {GrayLevel[0], 
        InsetBox["11", {2.070153806986097, 2.0786044432653603}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0413284390602406, 2.068940685090622}, 0.1], 
       {GrayLevel[0], 
        InsetBox["12", {3.0413284390602406, 2.068940685090622}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.04062357638236036, 2.984844005621651}, 0.1], 
       {GrayLevel[0], 
        InsetBox["13", {0.04062357638236036, 2.984844005621651}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9794392576731297, 3.0406513989835564}, 0.1], 
       {GrayLevel[0], 
        InsetBox["14", {0.9794392576731297, 3.0406513989835564}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0452812178624686, 3.049337825525834}, 0.1], 
       {GrayLevel[0], 
        InsetBox["15", {2.0452812178624686, 3.049337825525834}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9858570468615255, 3.0081501925681415}, 0.1], 
       {GrayLevel[0], 
        InsetBox["16", {2.9858570468615255, 3.0081501925681415}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.06445039786353624, 0.03975936004709957}, {
     1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
     3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
     0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
     2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
     1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
     2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
     3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
     2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
     2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
     3.0081501925681415`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.759371790516203*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 17}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 18}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 21}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 22}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 23}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 26}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 49}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 50}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 53}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 54}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 55}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 58}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.759371790834858*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw1ko0z23ccx39SP4+pPFRETZRVNY3FU9uwG76f2zpmU6WXtYo0bB6CTDX1
eEOt2gxryiJunrbFlOtqUy1qC4ZNO09TvZmHTTDUQ6dDJOLEw+xue9+97v0H
vF527106G0XAMAz2+Pd7xtJ4ZsO7qDMlNoJ9DwMzUcf5Ii4Buu1Gw97sNgCf
H9yKg0wxaEv548nU+H64btrSntOzhrzbA8+sWFNAPRTcYyEiwFJDJTm7QINe
uZqa7e5hBMcCdJbiKAxaLo52Jf2JgwgGoq5+bQhx2jh/3EyLuhMyW/JumwLH
o4Aga8Yg8UKh1ZbDJJolUblnLAwgUNw6rVCo0MvyoNJeySbSMEeUk40Y+I9m
ildfmkfs4fTMsXIcNsJS32plrSOMLPRV6sWhOZ76Yo5Ci7Ikecw7RYsom+/L
CtHNIevIquEvH28g7L+tlUVGNexisHPbsFimh0H1A8blrDx94AQxr2j4BOAs
qgbfbzSBDt+mosCHGHiytYk+E2SwD/nrbpfnOkp/ggaeT1ABt1F+GhBPgB8Z
iXbLwm0063KE8v0JI/iQJjhVBTgkXEjV3qQZwE7P65Gz54iQ9Xa2+4ZSi3wk
PZpfhSSYi0ixvU/BIH+prLTRehnV9NdXzP+OQx+/Pf3W8S3UJXXWlUo30fOl
uWreQRwA1cnunJpHD9YudR/OMQbVwX0lfRNrSGb02g7HdRxN34/hB26uo3d0
zxzNuGokaJ5PZJHmUcegH9HNd087Mc3bc1mIfg772CZ0RR9YlL75ACkNrh2Z
tZfp9GFW8Jv/6jlzOMw/Oz04bQKLrN1HVSdocLpa7UVZIEOK8otDvfqWYN/m
buIwRYXmN0q6CDxz6JQbFmz2bKPQ0FGzgCsUWHW2Dq8JwEFqWc4Yz6WCmhnP
tQ0mQlNDPWflczrQd/3iHWNIkFXrI1Xn0aD/QEoyMXwZHa3cvRwtp8JjF41U
wNxCfHF/2sDfFsAVFxY7GeNQNWbrva/Was/bT0MCkTHc9Z5ResktIVwLDTWc
cbSR4SY3GKRDekJtcydSIynZomanzgqih0OT65ww4Hn1uuK3GKByl3TYjuhD
7Le5Hw19RoOZfG6IcxcGxStl9r/wzSGJ40I+OW4AC6uJBdc+ocHNlNMFrQv7
wbGs5NGNSks4HvDM1ZVBgUMmrnXJIeZA9HpqmNGmQb05HQP5yRQQkRhXK4QY
UNgOzk5fUWGEXRmoV2sIRK4qxuUpHcTNHoJcuSkoXv1gqtqdBuTR9vOSjEkk
5Pu5yPKp8F1kaVBstwoprieSbqxYAHMm/55mr//12CgfXr0V2NjqKo4W4hBd
HlyybWgJ/3cdfXJLyJbTQaZs3DkQsYhYx7zpTd9YgeJFQ8J0yQZKkjxcf7eA
ARP4CxvRHAb/ANFRxJ4=
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 17}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 18}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 21}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 54}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 55}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 58}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 49}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 50}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 53}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 22}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 23}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 26}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1ko0z23ccx39SP4+pPFRETZRVNY3FU9uwG76f2zpmU6WXtYo0bB6CTDX1
eEOt2gxryiJunrbFlOtqUy1qC4ZNO09TvZmHTTDUQ6dDJOLEw+xue9+97v0H
vF527106G0XAMAz2+Pd7xtJ4ZsO7qDMlNoJ9DwMzUcf5Ii4Buu1Gw97sNgCf
H9yKg0wxaEv548nU+H64btrSntOzhrzbA8+sWFNAPRTcYyEiwFJDJTm7QINe
uZqa7e5hBMcCdJbiKAxaLo52Jf2JgwgGoq5+bQhx2jh/3EyLuhMyW/JumwLH
o4Aga8Yg8UKh1ZbDJJolUblnLAwgUNw6rVCo0MvyoNJeySbSMEeUk40Y+I9m
ildfmkfs4fTMsXIcNsJS32plrSOMLPRV6sWhOZ76Yo5Ci7Ikecw7RYsom+/L
CtHNIevIquEvH28g7L+tlUVGNexisHPbsFimh0H1A8blrDx94AQxr2j4BOAs
qgbfbzSBDt+mosCHGHiytYk+E2SwD/nrbpfnOkp/ggaeT1ABt1F+GhBPgB8Z
iXbLwm0063KE8v0JI/iQJjhVBTgkXEjV3qQZwE7P65Gz54iQ9Xa2+4ZSi3wk
PZpfhSSYi0ixvU/BIH+prLTRehnV9NdXzP+OQx+/Pf3W8S3UJXXWlUo30fOl
uWreQRwA1cnunJpHD9YudR/OMQbVwX0lfRNrSGb02g7HdRxN34/hB26uo3d0
zxzNuGokaJ5PZJHmUcegH9HNd087Mc3bc1mIfg772CZ0RR9YlL75ACkNrh2Z
tZfp9GFW8Jv/6jlzOMw/Oz04bQKLrN1HVSdocLpa7UVZIEOK8otDvfqWYN/m
buIwRYXmN0q6CDxz6JQbFmz2bKPQ0FGzgCsUWHW2Dq8JwEFqWc4Yz6WCmhnP
tQ0mQlNDPWflczrQd/3iHWNIkFXrI1Xn0aD/QEoyMXwZHa3cvRwtp8JjF41U
wNxCfHF/2sDfFsAVFxY7GeNQNWbrva/Was/bT0MCkTHc9Z5ResktIVwLDTWc
cbSR4SY3GKRDekJtcydSIynZomanzgqih0OT65ww4Hn1uuK3GKByl3TYjuhD
7Le5Hw19RoOZfG6IcxcGxStl9r/wzSGJ40I+OW4AC6uJBdc+ocHNlNMFrQv7
wbGs5NGNSks4HvDM1ZVBgUMmrnXJIeZA9HpqmNGmQb05HQP5yRQQkRhXK4QY
UNgOzk5fUWGEXRmoV2sIRK4qxuUpHcTNHoJcuSkoXv1gqtqdBuTR9vOSjEkk
5Pu5yPKp8F1kaVBstwoprieSbqxYAHMm/55mr//12CgfXr0V2NjqKo4W4hBd
HlyybWgJ/3cdfXJLyJbTQaZs3DkQsYhYx7zpTd9YgeJFQ8J0yQZKkjxcf7eA
ARP4CxvRHAb/ANFRxJ4=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.759371791223437*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"28", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "36"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"82", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "4"}], "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"106", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"220", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "46"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"536", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "416"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"640", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "324"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"116", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"294", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "512"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"689", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "702"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"645", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "500"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"344", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "204"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"110", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "d"}], ")"}], " ", "d", " ", 
                    RowBox[{"(", 
                    RowBox[{"13", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.7593718072740517`*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData["60"], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.75937180745086*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"16", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "22"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"43", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{"34", "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "32"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"296", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "150"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"366", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"55", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"29", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"359", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "303"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"495", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "404"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"404", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "300"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"229", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "149"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"94", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "49"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"21", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "29"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.759371824066862*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData["63"], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.7593718244329653`*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "17"}], "}"}]], "Output",
 CellChangeTimes->{3.757496775065811*^9, 3.75796288359962*^9, 
  3.758350381068741*^9, 3.7583506838808165`*^9, 3.759371885717084*^9},
 ExpressionUUID -> "11770524-e65c-4daa-a35a-6d342f003a96"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"squareLatticeGraph", "[", 
    RowBox[{"4", ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5", ",", "6"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"marginal", ",", "#2"}], "]"}]}], ",", "Red", ",", 
          "Green"}], "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z1", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z1", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}]}], "Input",
 CellChangeTimes->{{3.757495911063721*^9, 3.7574959141205454`*^9}, {
  3.7574966345739503`*^9, 3.7574966546018105`*^9}, {3.757496704564168*^9, 
  3.757496705982927*^9}, {3.757962929328044*^9, 3.7579629505560303`*^9}, {
  3.758350396885667*^9, 3.7583504068373976`*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.06445039786353624, 0.03975936004709957}, {
      1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
      3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
      0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
      2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
      1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
      2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
      3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
      2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
      2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
      3.0081501925681415`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
        6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 10}, {9, 
        13}, {10, 11}, {10, 14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {14, 
        15}, {15, 16}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.06445039786353624, 0.03975936004709957}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.06445039786353624, 0.03975936004709957}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.0036656179292778, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {1.0036656179292778, 0.}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.069128569913092, 0.008371147079157648}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {2.069128569913092, 0.008371147079157648}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.008385085706979, 0.0638054315390828}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {3.008385085706979, 0.0638054315390828}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.007980584197669671, 0.9792408360644795}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.007980584197669671, 0.9792408360644795}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9798966882042173, 0.9704561192526617}, 0.1], 
       {GrayLevel[0], 
        InsetBox["6", {0.9798966882042173, 0.9704561192526617}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0788742495115127, 0.9797479274578499}, 0.1], 
       {GrayLevel[0], 
        InsetBox["7", {2.0788742495115127, 0.9797479274578499}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0491561344905045, 1.0035986779750865}, 0.1], 
       {GrayLevel[0], 
        InsetBox["8", {3.0491561344905045, 1.0035986779750865}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 2.044861098298084}, 0.1], 
       {GrayLevel[0], InsetBox["9", {0., 2.044861098298084}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.971383681625486, 2.0693675735977783}, 0.1], 
       {GrayLevel[0], 
        InsetBox["10", {0.971383681625486, 2.0693675735977783}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.070153806986097, 2.0786044432653603}, 0.1], 
       {GrayLevel[0], 
        InsetBox["11", {2.070153806986097, 2.0786044432653603}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0413284390602406, 2.068940685090622}, 0.1], 
       {GrayLevel[0], 
        InsetBox["12", {3.0413284390602406, 2.068940685090622}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.04062357638236036, 2.984844005621651}, 0.1], 
       {GrayLevel[0], 
        InsetBox["13", {0.04062357638236036, 2.984844005621651}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9794392576731297, 3.0406513989835564}, 0.1], 
       {GrayLevel[0], 
        InsetBox["14", {0.9794392576731297, 3.0406513989835564}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0452812178624686, 3.049337825525834}, 0.1], 
       {GrayLevel[0], 
        InsetBox["15", {2.0452812178624686, 3.049337825525834}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9858570468615255, 3.0081501925681415}, 0.1], 
       {GrayLevel[0], 
        InsetBox["16", {2.9858570468615255, 3.0081501925681415}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.06445039786353624, 0.03975936004709957}, {
     1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
     3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
     0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
     2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
     1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
     2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
     3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
     2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
     2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
     3.0081501925681415`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.7593718861795826`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 17}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 18}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 21}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 22}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 23}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 26}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 49}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 50}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 53}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 54}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 55}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 58}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.7593718864692693`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAALNkDn/EcFUAWeNsavF/oP5jSHCwl
OhZAsk8AdnbH+j8nNCBHftIaQDG0DsqGsARAy0zpniqKHkB+ppsIj1kJQLwv
xHnmVxZAWAKBcdYO1j8W07DUDaIXQGV/bn7kXvM/u+xwDp0YHUC0kH63OFQA
QCr0IQM1eyBA58PGaeINBUBkOC0JmS8bQLhLm4oVndU/TvEg4stOHUCs1hPA
mc7vP766cIKvliBAcuBc9RJn+T/6yvPjWTAiQGRag/ao4gBAUBThVgDwHkAA
Qp97FRx6PxnRHhsgpiBAHlnngAsE4j/6IUGXAUAiQIngZGTEovE/5O40T8eh
I0ARENGaipP5P/U/lVb47BRAOHdFPcPPB0Csi6WbFj8WQCTzYevGFAtAD3Fm
Py0mG0APfkoZgkILQN57SM+i7R5Amvf4U8nFDUC1SVFL+yUWQEXh4P29hwBA
0Kam/L2KF0DKJ7nLNCsEQAhzgf0MQR1AiQAt86nyBUD/C7k7qKEgQIiSj95D
RQlAOFL+tPbFGkDixEFxBYjyP+BC4v5OBB1AQpPmbc0v+z+T3fIiVo8gQPS3
9Y/JGAFAZSzSd208IkDNhOvOC94EQLaU1zBIeB5ARrtbphO44T8fL5dzGnMg
QMzEJn5xhfE/Wl6mQ5coIkA+FXbvd575PwnVnECunSNAyFHwWli/AECRiDIm
7SYSQKxaUDqGtgdAEYo/4+DpEEAITgSfaAoLQKFeriD2IQhA5v+7un8WC0DA
63CeWp8AQCKNSRZXuw1AVKPV6wAJEUB17zmwq2gAQLb8u0wFQQ9A8KO65R8b
BEBgfhEe6OQDQMwhcDZC0wVA9PQDTKbP9z+21t/hdkIJQI3m6VzM4whAqr9x
pbIx8j+55eTqaFYEQGD0tF7o5Po/jDtzvDxU+D84I6HWEg0BQLBY2bp/BuY/
lZ3ySdvpBEDft3ML/HcBQGj21ZvttuE/FlWEbkY++T/MaD3pCWfxP6irne2u
I+c/mhigaRKe+T8AAAAAAAAAADUpt4gq4gBAaCAb7O9VEkB8cNkfufznP8U9
WUE6HBFA+eb+pm2L+j/Em99oGPcIQDOcKDv/hgRArVijbzOQAUBEpwJNUlsJ
QHboX6X2AxFAsGgWtyS51T/2uxCaMnEPQJ2P1dojPfM/fEc8xTt7BEBUXVm6
mC8AQOjFJpAravk/S4x/VhECBUCu+/SWST0IQMjPgFFSNtQ/pe5RdAsGBECP
A7/YmE/vP7wfWISMkfg/8hqyO/5Q+T8AO5+fvIXnP/5AAbLq6wBAM02DwJix
AEAAAAAAAAAAAHinWtatCvg/hondu33t4T8Yr8G5bGTmPyDL/wG1sPE/ABwa
r+sjgj+qAlsCo9r5P7B4yWc=
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 49}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 50}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 53}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 54}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 23}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 26}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 17}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 18}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 21}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 22}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 55}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 58}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAALNkDn/EcFUAWeNsavF/oP5jSHCwl
OhZAsk8AdnbH+j8nNCBHftIaQDG0DsqGsARAy0zpniqKHkB+ppsIj1kJQLwv
xHnmVxZAWAKBcdYO1j8W07DUDaIXQGV/bn7kXvM/u+xwDp0YHUC0kH63OFQA
QCr0IQM1eyBA58PGaeINBUBkOC0JmS8bQLhLm4oVndU/TvEg4stOHUCs1hPA
mc7vP766cIKvliBAcuBc9RJn+T/6yvPjWTAiQGRag/ao4gBAUBThVgDwHkAA
Qp97FRx6PxnRHhsgpiBAHlnngAsE4j/6IUGXAUAiQIngZGTEovE/5O40T8eh
I0ARENGaipP5P/U/lVb47BRAOHdFPcPPB0Csi6WbFj8WQCTzYevGFAtAD3Fm
Py0mG0APfkoZgkILQN57SM+i7R5Amvf4U8nFDUC1SVFL+yUWQEXh4P29hwBA
0Kam/L2KF0DKJ7nLNCsEQAhzgf0MQR1AiQAt86nyBUD/C7k7qKEgQIiSj95D
RQlAOFL+tPbFGkDixEFxBYjyP+BC4v5OBB1AQpPmbc0v+z+T3fIiVo8gQPS3
9Y/JGAFAZSzSd208IkDNhOvOC94EQLaU1zBIeB5ARrtbphO44T8fL5dzGnMg
QMzEJn5xhfE/Wl6mQ5coIkA+FXbvd575PwnVnECunSNAyFHwWli/AECRiDIm
7SYSQKxaUDqGtgdAEYo/4+DpEEAITgSfaAoLQKFeriD2IQhA5v+7un8WC0DA
63CeWp8AQCKNSRZXuw1AVKPV6wAJEUB17zmwq2gAQLb8u0wFQQ9A8KO65R8b
BEBgfhEe6OQDQMwhcDZC0wVA9PQDTKbP9z+21t/hdkIJQI3m6VzM4whAqr9x
pbIx8j+55eTqaFYEQGD0tF7o5Po/jDtzvDxU+D84I6HWEg0BQLBY2bp/BuY/
lZ3ySdvpBEDft3ML/HcBQGj21ZvttuE/FlWEbkY++T/MaD3pCWfxP6irne2u
I+c/mhigaRKe+T8AAAAAAAAAADUpt4gq4gBAaCAb7O9VEkB8cNkfufznP8U9
WUE6HBFA+eb+pm2L+j/Em99oGPcIQDOcKDv/hgRArVijbzOQAUBEpwJNUlsJ
QHboX6X2AxFAsGgWtyS51T/2uxCaMnEPQJ2P1dojPfM/fEc8xTt7BEBUXVm6
mC8AQOjFJpAravk/S4x/VhECBUCu+/SWST0IQMjPgFFSNtQ/pe5RdAsGBECP
A7/YmE/vP7wfWISMkfg/8hqyO/5Q+T8AO5+fvIXnP/5AAbLq6wBAM02DwJix
AEAAAAAAAAAAAHinWtatCvg/hondu33t4T8Yr8G5bGTmPyDL/wG1sPE/ABwa
r+sjgj+qAlsCo9r5P7B4yWc=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.759371886743472*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"28", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "36"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"82", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "4"}], "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"106", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"220", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "46"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"536", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "416"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"640", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "324"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"116", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"294", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "512"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"689", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "702"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"645", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "500"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"344", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "204"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"110", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "d"}], ")"}], " ", "d", " ", 
                    RowBox[{"(", 
                    RowBox[{"13", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.7593719013911066`*^9}],

Cell[BoxData["60"], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.7593719015644183`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"31", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "50"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"137", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "111"}], "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"289", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"92", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"441", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "384"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"706", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "535"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"531", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "265"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"132", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"24", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "61"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"71", "+", 
                    RowBox[{"2", " ", "d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "22"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"12", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.7593719175461073`*^9}],

Cell[BoxData["64"], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.7593719178757505`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "16"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7574959147129235`*^9, 3.757496656789364*^9, 3.757496706559345*^9, {
   3.757962932555545*^9, 3.757962951046997*^9}, 3.7583508596610255`*^9, 
   3.759371975018855*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"squareLatticeGraph", "[", 
    RowBox[{"4", ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"marginal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "7"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"marginal", ",", "#2"}], "]"}]}], ",", "Red", ",", 
          "Green"}], "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tn", "=", 
   RowBox[{"buildTNfromGraph", "[", 
    RowBox[{"g", ",", "marginal"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"visualizeTN", "[", 
  RowBox[{"tn", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Z0", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "Z0", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ZA", "=", 
  RowBox[{
   RowBox[{"edgeNormalization", " ", 
    RowBox[{
     RowBox[{"integrateAllUs", "[", 
      RowBox[{
       RowBox[{"tn", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "d", ",", "d"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "ZA", "]"}]}], "/", 
    RowBox[{"Log", "[", "d", "]"}]}], ",", 
   RowBox[{"d", "\[Rule]", "Infinity"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.757963006294664*^9, 3.7579630093587813`*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.06445039786353624, 0.03975936004709957}, {
      1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
      3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
      0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
      2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
      1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
      2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
      3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
      2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
      2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
      3.0081501925681415`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
        6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 10}, {9, 
        13}, {10, 11}, {10, 14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {14, 
        15}, {15, 16}}]}], {
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.06445039786353624, 0.03975936004709957}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.06445039786353624, 0.03975936004709957}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.0036656179292778, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {1.0036656179292778, 0.}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.069128569913092, 0.008371147079157648}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {2.069128569913092, 0.008371147079157648}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.008385085706979, 0.0638054315390828}, 0.1], 
       {GrayLevel[0], 
        InsetBox["4", {3.008385085706979, 0.0638054315390828}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.007980584197669671, 0.9792408360644795}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.007980584197669671, 0.9792408360644795}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9798966882042173, 0.9704561192526617}, 0.1], 
       {GrayLevel[0], 
        InsetBox["6", {0.9798966882042173, 0.9704561192526617}]}}, 
      {RGBColor[0, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0788742495115127, 0.9797479274578499}, 0.1], 
       {GrayLevel[0], 
        InsetBox["7", {2.0788742495115127, 0.9797479274578499}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0491561344905045, 1.0035986779750865}, 0.1], 
       {GrayLevel[0], 
        InsetBox["8", {3.0491561344905045, 1.0035986779750865}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 2.044861098298084}, 0.1], 
       {GrayLevel[0], InsetBox["9", {0., 2.044861098298084}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.971383681625486, 2.0693675735977783}, 0.1], 
       {GrayLevel[0], 
        InsetBox["10", {0.971383681625486, 2.0693675735977783}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.070153806986097, 2.0786044432653603}, 0.1], 
       {GrayLevel[0], 
        InsetBox["11", {2.070153806986097, 2.0786044432653603}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{3.0413284390602406, 2.068940685090622}, 0.1], 
       {GrayLevel[0], 
        InsetBox["12", {3.0413284390602406, 2.068940685090622}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.04062357638236036, 2.984844005621651}, 0.1], 
       {GrayLevel[0], 
        InsetBox["13", {0.04062357638236036, 2.984844005621651}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.9794392576731297, 3.0406513989835564}, 0.1], 
       {GrayLevel[0], 
        InsetBox["14", {0.9794392576731297, 3.0406513989835564}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.0452812178624686, 3.049337825525834}, 0.1], 
       {GrayLevel[0], 
        InsetBox["15", {2.0452812178624686, 3.049337825525834}]}}, 
      {RGBColor[1, 0, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9858570468615255, 3.0081501925681415}, 0.1], 
       {GrayLevel[0], 
        InsetBox["16", {2.9858570468615255, 3.0081501925681415}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.06445039786353624, 0.03975936004709957}, {
     1.0036656179292778`, 0.}, {2.069128569913092, 0.008371147079157648}, {
     3.008385085706979, 0.0638054315390828}, {0.007980584197669671, 
     0.9792408360644795}, {0.9798966882042173, 0.9704561192526617}, {
     2.0788742495115127`, 0.9797479274578499}, {3.0491561344905045`, 
     1.0035986779750865`}, {0., 2.044861098298084}, {0.971383681625486, 
     2.0693675735977783`}, {2.070153806986097, 2.0786044432653603`}, {
     3.0413284390602406`, 2.068940685090622}, {0.04062357638236036, 
     2.984844005621651}, {0.9794392576731297, 3.0406513989835564`}, {
     2.0452812178624686`, 3.049337825525834}, {2.9858570468615255`, 
     3.0081501925681415`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.759371975375968*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 17}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 18}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 19}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 21}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 22}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 23}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 26}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 49}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 50}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 51}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 53}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 54}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 55}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 58}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw90WtMU3cYBvBT6pAeerKew0VlTW9WFMMQ2AccST3/wFa0gOIVbBgasSpe
oUiZMFZcKxleIigBvCLYiqiogFMupeedMV5AUBEzRSNmrKkRpJDYonOQsSz9
f3jz5E2eT89PvmnPKp0PQRBo+v7LvuSholDdBCti9g/lEkqo8ZVp1OQMtDVI
qroQrIS0D9q38iIKJRj9eD2BSshot2iFHxi0lHQe8/88F9DJNzyNwsP+ydtq
Eo7I4TY69/X3Vj4aOPFjeu6oHEYWPKk5k06hugexBX3Tv597y0AoGYBuDo6c
/MYhB8mmN8YWs5s1CoxBYUFSYFaaa03r+ejlRv5V67gE+m536mw0hRYX0h3N
HgnUUOPSOQMMCo/M2zE/WAqv9dcXqbrdbGES74e8ZyFQ8V1i9EcFH00ZDVkH
T4fAzSuiqtYjQvTH+dKM32pDQCvUnHq8nUGuisvLbr0Pgf6Zx19A4zg7WTlG
f2lXQp+tpKVYykOHuZJYH4cSIjTbdgUfIhGS/VXb5FRCbOeUIWczjay+5anu
LiVsj3JtWDHqYieaDcZZlxSgL71WXHuaQOvyhzNN7QrwC3am9a4h0aWySDvT
qYC9TfYZ1nwakTq/qu7pvrpB+DRizyj77tzC7KwUGWQOzXrxdAWBDvlPJdjU
Mqi7Lzlj8iXR892dw0SCDKoPKOrbl9MovaylK2OZDAqa7gqeBLrYnIb+/b/s
FUNvgc7QE0kgQ4dzMjdODJb1zmawCNCJo83P65eIoeE1N/vZpAid9Th9HmSJ
weuf+O37mPhoGvt/YsOG6zNo7N8W8I/eraWxvy2srVI/n8b+g1F611uGxP62
8tbVZjGJ/QdTfu8iJCT2D28oTT4wIcD+a1T9QsERAvsLR16pfNQE9r8r+5Qq
TiGwf+NBaP3iKIH9q0uaYuK/GuO8/kv/35Xz+ovuWwtLqkc5r/+2i9p3mp/G
OK//vPiHFfsaGewfV/HRseEzg/0vr225YScCsH+egpKp7zHYP9pzfTDQn8L+
jTPNOXeSKOxP7Koe4KVS2L/IPqFyUBT2J64W16Vb+NjflNbLu1jEx/6tju6y
9p/52P/eDosw+lc+9s/+e6orv8rDef3NcYkdqkduzusvOm4IpcDNef0Vi5Ie
le/0cP8COi3aeQ==
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.7593719756571627`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAAOABJNsPJDEDiYGFf88MTQEhqFSto
jQxAktjDOBoJEEB42C8QDT8LQISp8dx2twZApMUE3v5/BUBQxcROLX76P1qy
xag5EQpANtvZVKSUEUB+DuPBU5MJQCE3b/IMQwxA9qufnUcMCECCDAhrV+ED
QOYqfLIvPwBAsh5GHXYg+T+7HXP1HnMAQH4vvoI6Ig9A7j2v5169/T/rTz0B
CgkJQFChImmCnPg/nct5AGOxAUBwKygoSyzuP3IMSUt57Pc/2ABnNnTR8D+0
+OFNpfYOQNTk0rsN6+g/E/CFUML1CED4OrGc+VfcPz21TBU+KQJAAAAAAAAA
AAA8QYgK45L5P+3bczLqAA1ALP71S2o28j9ItY74nJcMQLhSXkdGJ+A/WIcS
76oPC0AAUCck/49fPzYiUM47lARAyKbUYu6C3z8mOHxKAIcKQMLL7jI8TQBA
GdBhZEDbCUAKrN1Sbh72P7Gz544NMAhAptPVGcXB5j8IlY5F1Rj/PwBVotWJ
ZeU/QJyvQ79YAUAiQnq5MEIHQFyM3vxQbv8/KN3Eje5hAUD+nYUlCbH5P3Ao
hotGTPU/bBiQtBi97T8AS+MvRdXqP0rs2/M43fI/RlV9jB1QCkDkygbsIFrt
P0FlhoLbTQRAhMAlyAO84T/mUoEJEg/7P+BjUYWRYbE/Vchwf+Lx8D9rkFQg
SPAQQK0wZa+AK/I/hTPzbiQgEUDkbltJJBTgPwQC6o1z5xFAAAAAAAAAAACl
ejL+xyUVQGgP5kcaH98/xLP2x9gzEkC985od2EwAQJrbuqS5gBJAIqzEM/UZ
9j9L1jVaqVcTQFyQXtJxyeY/YroyCNymF0COJpFuLYPlP0McStRU0hZAkM6t
1u9IB0C0kFUh+ZMXQFJQVJMKagFAj0tVNRsEGUC2/10jF1D1P8hkmXXGsxtA
zCjKi5HK6j8E1JN1kckaQEWjIJO5RgpALkc19ULFG0Aad30IVkcEQHCzniNp
Ph1A/8QFQxAZ+z/jSkke7CgfQOJkBZSj2fA/eRCeZ8AMEUBexvBQdcETQK8j
kyHyKRFADFLN74cGEEC+jH06ANMRQIuBRAocsAZAznuaDgirFECI1i6l9lP6
P8uF3+sQbhJAlreC8nWUEUCp24/hhagSQKyg8NafQgxAfrjgv21rE0D4swub
ed0DQCbMTpbKThdA5ggT830Z+T+nFCzRVEUXQFh/bJbrKw9AxJrj0FcJGECF
fozG1goJQBDdLU9OShlAZwDRaw6qAUAeTp5OP6wbQN7m460Jyvc/egG/OthJ
G0CJwR6K0PcOQN0cOwCVXRxAzZ+VZuLsCEAOLxZO7K0dQMZtnw0rHgJAitrs
5O9xH0C8kgUbjm75P794uZA=
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 49}], LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{2, 50}], 
      LineBox[{3, 4}], LineBox[{3, 7}], LineBox[{3, 51}], LineBox[{4, 8}], 
      LineBox[{4, 20}], LineBox[{5, 6}], LineBox[{5, 9}], LineBox[{5, 53}], 
      LineBox[{6, 7}], LineBox[{6, 10}], LineBox[{6, 54}], LineBox[{7, 8}], 
      LineBox[{7, 11}], LineBox[{7, 55}], LineBox[{8, 12}], LineBox[{8, 24}], 
      LineBox[{9, 10}], LineBox[{9, 13}], LineBox[{9, 25}], LineBox[{10, 11}],
       LineBox[{10, 14}], LineBox[{10, 26}], LineBox[{11, 12}], 
      LineBox[{11, 15}], LineBox[{11, 27}], LineBox[{12, 16}], 
      LineBox[{12, 28}], LineBox[{13, 14}], LineBox[{13, 29}], 
      LineBox[{14, 15}], LineBox[{14, 30}], LineBox[{15, 16}], 
      LineBox[{15, 31}], LineBox[{16, 32}], LineBox[{17, 18}], 
      LineBox[{17, 21}], LineBox[{18, 19}], LineBox[{18, 22}], 
      LineBox[{19, 20}], LineBox[{19, 23}], LineBox[{20, 24}], 
      LineBox[{21, 22}], LineBox[{21, 25}], LineBox[{22, 23}], 
      LineBox[{22, 26}], LineBox[{23, 24}], LineBox[{23, 27}], 
      LineBox[{24, 28}], LineBox[{25, 26}], LineBox[{25, 29}], 
      LineBox[{26, 27}], LineBox[{26, 30}], LineBox[{27, 28}], 
      LineBox[{27, 31}], LineBox[{28, 32}], LineBox[{29, 30}], 
      LineBox[{30, 31}], LineBox[{31, 32}], LineBox[{33, 34}], 
      LineBox[{33, 37}], LineBox[{33, 17}], LineBox[{34, 35}], 
      LineBox[{34, 38}], LineBox[{34, 18}], LineBox[{35, 36}], 
      LineBox[{35, 39}], LineBox[{35, 19}], LineBox[{36, 40}], 
      LineBox[{36, 52}], LineBox[{37, 38}], LineBox[{37, 41}], 
      LineBox[{37, 21}], LineBox[{38, 39}], LineBox[{38, 42}], 
      LineBox[{38, 22}], LineBox[{39, 40}], LineBox[{39, 43}], 
      LineBox[{39, 23}], LineBox[{40, 44}], LineBox[{40, 56}], 
      LineBox[{41, 42}], LineBox[{41, 45}], LineBox[{41, 57}], 
      LineBox[{42, 43}], LineBox[{42, 46}], LineBox[{42, 58}], 
      LineBox[{43, 44}], LineBox[{43, 47}], LineBox[{43, 59}], 
      LineBox[{44, 48}], LineBox[{44, 60}], LineBox[{45, 46}], 
      LineBox[{45, 61}], LineBox[{46, 47}], LineBox[{46, 62}], 
      LineBox[{47, 48}], LineBox[{47, 63}], LineBox[{48, 64}], 
      LineBox[{49, 50}], LineBox[{49, 53}], LineBox[{50, 51}], 
      LineBox[{50, 54}], LineBox[{51, 52}], LineBox[{51, 55}], 
      LineBox[{52, 56}], LineBox[{53, 54}], LineBox[{53, 57}], 
      LineBox[{54, 55}], LineBox[{54, 58}], LineBox[{55, 56}], 
      LineBox[{55, 59}], LineBox[{56, 60}], LineBox[{57, 58}], 
      LineBox[{57, 61}], LineBox[{58, 59}], LineBox[{58, 62}], 
      LineBox[{59, 60}], LineBox[{59, 63}], LineBox[{60, 64}], 
      LineBox[{61, 62}], LineBox[{62, 63}], LineBox[{63, 64}]}, 
     {RGBColor[0, 0, 0.7], 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[1, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[1, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"1\"\>"], 1]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[2, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[2, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"1\"\>"], 2]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[3, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[3, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"1\"\>"], 3]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[4, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[4, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"1\"\>"], 4]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[5, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[5, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"1\"\>"], 5]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[6, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[6, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"1\"\>"], 6]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[7, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[7, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"1\"\>"], 7]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[8, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[8, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"1\"\>"], 8]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[9, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[9, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"1\"\>"], 9]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[10, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[10, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"1\"\>"], 10]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[11, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[11, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"1\"\>"], 11]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[12, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[12, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"1\"\>"], 12]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[13, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[13, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"1\"\>"], 13]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[14, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[14, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"1\"\>"], 14]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[15, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[15, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"1\"\>"], 15]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[16, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[16, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"1\"\>"], 16]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[17, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[17, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 17]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[18, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[18, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 18]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[19, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[19, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 19]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[20, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[20, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 20]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[21, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[21, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 21]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[22, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[22, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 22]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[23, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[23, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 23]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[24, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[24, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 24]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[25, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[25, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 25]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[26, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[26, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 26]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[27, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[27, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 27]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[28, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[28, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 28]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[29, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[29, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 29]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[30, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[30, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 30]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[31, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[31, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 31]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[32, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[32, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"1\"\>"], 32]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[33, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[33, 0.06]}, InsetBox[
        SubscriptBox["\<\"U1\"\>", "\<\"2\"\>"], 33]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[34, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[34, 0.06]}, InsetBox[
        SubscriptBox["\<\"U2\"\>", "\<\"2\"\>"], 34]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[35, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[35, 0.06]}, InsetBox[
        SubscriptBox["\<\"U3\"\>", "\<\"2\"\>"], 35]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[36, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[36, 0.06]}, InsetBox[
        SubscriptBox["\<\"U4\"\>", "\<\"2\"\>"], 36]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[37, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[37, 0.06]}, InsetBox[
        SubscriptBox["\<\"U5\"\>", "\<\"2\"\>"], 37]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[38, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[38, 0.06]}, InsetBox[
        SubscriptBox["\<\"U6\"\>", "\<\"2\"\>"], 38]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[39, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[39, 0.06]}, InsetBox[
        SubscriptBox["\<\"U7\"\>", "\<\"2\"\>"], 39]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[40, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[40, 0.06]}, InsetBox[
        SubscriptBox["\<\"U8\"\>", "\<\"2\"\>"], 40]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[41, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[41, 0.06]}, InsetBox[
        SubscriptBox["\<\"U9\"\>", "\<\"2\"\>"], 41]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[42, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[42, 0.06]}, InsetBox[
        SubscriptBox["\<\"U10\"\>", "\<\"2\"\>"], 42]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[43, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[43, 0.06]}, InsetBox[
        SubscriptBox["\<\"U11\"\>", "\<\"2\"\>"], 43]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[44, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[44, 0.06]}, InsetBox[
        SubscriptBox["\<\"U12\"\>", "\<\"2\"\>"], 44]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[45, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[45, 0.06]}, InsetBox[
        SubscriptBox["\<\"U13\"\>", "\<\"2\"\>"], 45]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[46, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[46, 0.06]}, InsetBox[
        SubscriptBox["\<\"U14\"\>", "\<\"2\"\>"], 46]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[47, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[47, 0.06]}, InsetBox[
        SubscriptBox["\<\"U15\"\>", "\<\"2\"\>"], 47]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[48, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[48, 0.06]}, InsetBox[
        SubscriptBox["\<\"U16\"\>", "\<\"2\"\>"], 48]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[49, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[49, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U1\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 49]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[50, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[50, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U2\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 50]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[51, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[51, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U3\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 51]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[52, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[52, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U4\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 52]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[53, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[53, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U5\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 53]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[54, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[54, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U6\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 54]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[55, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[55, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U7\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 55]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[56, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[56, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U8\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 56]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[57, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[57, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U9\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 57]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[58, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[58, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U10\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 58]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[59, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[59, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U11\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 59]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[60, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[60, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U12\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 60]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[61, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[61, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U13\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 61]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[62, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[62, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U14\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 62]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[63, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[63, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U15\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 63]}, 
      {GrayLevel[0], AbsoluteThickness[2], CircleBox[64, 0.06], 
       {RGBColor[1, 1, 0], DiskBox[64, 0.06]}, InsetBox[
        SubscriptBox[
         TemplateBox[{"\"U16\"","\"*\""},
          "Superscript"], "\<\"2\"\>"], 64]}}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAAOABJNsPJDEDiYGFf88MTQEhqFSto
jQxAktjDOBoJEEB42C8QDT8LQISp8dx2twZApMUE3v5/BUBQxcROLX76P1qy
xag5EQpANtvZVKSUEUB+DuPBU5MJQCE3b/IMQwxA9qufnUcMCECCDAhrV+ED
QOYqfLIvPwBAsh5GHXYg+T+7HXP1HnMAQH4vvoI6Ig9A7j2v5169/T/rTz0B
CgkJQFChImmCnPg/nct5AGOxAUBwKygoSyzuP3IMSUt57Pc/2ABnNnTR8D+0
+OFNpfYOQNTk0rsN6+g/E/CFUML1CED4OrGc+VfcPz21TBU+KQJAAAAAAAAA
AAA8QYgK45L5P+3bczLqAA1ALP71S2o28j9ItY74nJcMQLhSXkdGJ+A/WIcS
76oPC0AAUCck/49fPzYiUM47lARAyKbUYu6C3z8mOHxKAIcKQMLL7jI8TQBA
GdBhZEDbCUAKrN1Sbh72P7Gz544NMAhAptPVGcXB5j8IlY5F1Rj/PwBVotWJ
ZeU/QJyvQ79YAUAiQnq5MEIHQFyM3vxQbv8/KN3Eje5hAUD+nYUlCbH5P3Ao
hotGTPU/bBiQtBi97T8AS+MvRdXqP0rs2/M43fI/RlV9jB1QCkDkygbsIFrt
P0FlhoLbTQRAhMAlyAO84T/mUoEJEg/7P+BjUYWRYbE/Vchwf+Lx8D9rkFQg
SPAQQK0wZa+AK/I/hTPzbiQgEUDkbltJJBTgPwQC6o1z5xFAAAAAAAAAAACl
ejL+xyUVQGgP5kcaH98/xLP2x9gzEkC985od2EwAQJrbuqS5gBJAIqzEM/UZ
9j9L1jVaqVcTQFyQXtJxyeY/YroyCNymF0COJpFuLYPlP0McStRU0hZAkM6t
1u9IB0C0kFUh+ZMXQFJQVJMKagFAj0tVNRsEGUC2/10jF1D1P8hkmXXGsxtA
zCjKi5HK6j8E1JN1kckaQEWjIJO5RgpALkc19ULFG0Aad30IVkcEQHCzniNp
Ph1A/8QFQxAZ+z/jSkke7CgfQOJkBZSj2fA/eRCeZ8AMEUBexvBQdcETQK8j
kyHyKRFADFLN74cGEEC+jH06ANMRQIuBRAocsAZAznuaDgirFECI1i6l9lP6
P8uF3+sQbhJAlreC8nWUEUCp24/hhagSQKyg8NafQgxAfrjgv21rE0D4swub
ed0DQCbMTpbKThdA5ggT830Z+T+nFCzRVEUXQFh/bJbrKw9AxJrj0FcJGECF
fozG1goJQBDdLU9OShlAZwDRaw6qAUAeTp5OP6wbQN7m460Jyvc/egG/OthJ
G0CJwR6K0PcOQN0cOwCVXRxAzZ+VZuLsCEAOLxZO7K0dQMZtnw0rHgJAitrs
5O9xH0C8kgUbjm75P794uZA=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.7593719758839192`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"28", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "36"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"82", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "4"}], "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"106", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"220", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "46"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"536", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "416"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"640", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "324"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"116", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"294", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "512"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"689", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "702"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"645", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "500"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"344", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "204"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"110", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "d"}], ")"}], " ", "d", " ", 
                    RowBox[{"(", 
                    RowBox[{"13", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.7593719899701605`*^9}],

Cell[BoxData["60"], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.7593719901614523`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"27", "+", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "35"}], "+", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"99", "+", 
                RowBox[{"d", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "32"}], "+", 
                   RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"174", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"124", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"6", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"474", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "364"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"615", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "366"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"341", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "118"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"62", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"20", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "9"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"9", "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d", "28"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d"}]}], ")"}], "4"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["d", "4"]}], ")"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "d"}], ")"}], " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["d", "2"]}], ")"}]}]}], ")"}], "4"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.7593720065237293`*^9}],

Cell[BoxData["65"], "Output",
 CellChangeTimes->{3.7579630097813215`*^9, 3.7583509454497175`*^9, 
  3.759372006894828*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"computeexponents", "[", 
  RowBox[{"g", ",", "marginal"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "15"}], "}"}]], "Output",
 CellChangeTimes->{3.7583510761198053`*^9, 3.759372073137576*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1200, 717},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 146, 1, 144, "Title"],
Cell[CellGroupData[{
Cell[751, 27, 334, 9, 69, "Input"],
Cell[CellGroupData[{
Cell[1110, 40, 945, 17, 22, "Print"],
Cell[2058, 59, 782, 14, 22, "Print"],
Cell[2843, 75, 782, 14, 22, "Print"],
Cell[3628, 91, 781, 14, 22, "Print"],
Cell[4412, 107, 782, 14, 22, "Print"],
Cell[5197, 123, 782, 14, 22, "Print"],
Cell[5982, 139, 784, 14, 22, "Print"],
Cell[6769, 155, 784, 14, 22, "Print"],
Cell[7556, 171, 782, 14, 22, "Print"],
Cell[8341, 187, 780, 14, 22, "Print"],
Cell[9124, 203, 786, 14, 22, "Print"],
Cell[9913, 219, 786, 14, 22, "Print"],
Cell[10702, 235, 786, 14, 22, "Print"],
Cell[11491, 251, 786, 14, 22, "Print"],
Cell[12280, 267, 786, 14, 22, "Print"],
Cell[13069, 283, 784, 14, 22, "Print"],
Cell[13856, 299, 784, 14, 22, "Print"],
Cell[14643, 315, 786, 14, 22, "Print"],
Cell[15432, 331, 784, 14, 22, "Print"],
Cell[16219, 347, 786, 14, 22, "Print"],
Cell[17008, 363, 786, 14, 22, "Print"]
}, Open  ]]
}, Open  ]],
Cell[17821, 381, 26355, 601, 2064, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44213, 987, 107, 1, 90, "Title"],
Cell[CellGroupData[{
Cell[44345, 992, 4312, 114, 316, "Input"],
Cell[48660, 1108, 1524, 31, 332, "Output"],
Cell[50187, 1141, 4567, 90, 447, "Output"],
Cell[54757, 1233, 4423, 82, 231, "Output"],
Cell[59183, 1317, 782, 23, 50, "Output"],
Cell[59968, 1342, 344, 5, 30, "Output"],
Cell[60315, 1349, 708, 20, 52, "Output"],
Cell[61026, 1371, 344, 5, 30, "Output"],
Cell[61373, 1378, 388, 7, 30, "Output"]
}, Open  ]],
Cell[61776, 1388, 254, 5, 88, "Input"],
Cell[CellGroupData[{
Cell[62055, 1397, 3856, 108, 278, "Input"],
Cell[65914, 1507, 1298, 24, 49, "Output"],
Cell[67215, 1533, 3517, 69, 447, "Output"],
Cell[70735, 1604, 3403, 63, 374, "Output"],
Cell[74141, 1669, 881, 18, 52, "Output"],
Cell[75025, 1689, 715, 11, 30, "Output"],
Cell[75743, 1702, 960, 21, 52, "Output"],
Cell[76706, 1725, 715, 11, 30, "Output"],
Cell[77424, 1738, 804, 15, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78265, 1758, 3369, 94, 278, "Input"],
Cell[81637, 1854, 1140, 24, 49, "Output"],
Cell[82780, 1880, 4321, 87, 447, "Output"],
Cell[87104, 1969, 4211, 79, 211, "Output"],
Cell[91318, 2050, 714, 23, 50, "Output"],
Cell[92035, 2075, 700, 23, 50, "Output"],
Cell[92738, 2100, 196, 3, 30, "Output"],
Cell[92937, 2105, 198, 3, 30, "Output"],
Cell[93138, 2110, 285, 7, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93460, 2122, 4340, 105, 297, "Input"],
Cell[97803, 2229, 2620, 50, 425, "Output"],
Cell[100426, 2281, 8057, 151, 447, "Output"],
Cell[108486, 2434, 8243, 155, 375, "Output"],
Cell[116732, 2591, 818, 20, 52, "Output"],
Cell[117553, 2613, 476, 7, 30, "Output"],
Cell[118032, 2622, 963, 25, 52, "Output"],
Cell[118998, 2649, 474, 7, 30, "Output"],
Cell[119475, 2658, 564, 11, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120076, 2674, 119, 2, 30, "Input"],
Cell[120198, 2678, 94, 1, 30, "Output"]
}, Open  ]],
Cell[120307, 2682, 2834, 70, 240, "Input"],
Cell[CellGroupData[{
Cell[123166, 2756, 4737, 120, 316, "Input"],
Cell[127906, 2878, 2235, 44, 196, "Output"],
Cell[130144, 2924, 7165, 139, 447, "Output"],
Cell[137312, 3065, 7351, 143, 305, "Output"],
Cell[144666, 3210, 1071, 35, 52, "Output"],
Cell[145740, 3247, 221, 4, 30, "Output"],
Cell[145964, 3253, 1153, 39, 52, "Output"],
Cell[147120, 3294, 221, 4, 30, "Output"],
Cell[147344, 3300, 312, 8, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147693, 3313, 3621, 98, 259, "Input"],
Cell[151317, 3413, 2205, 44, 425, "Output"],
Cell[153525, 3459, 6996, 136, 447, "Output"],
Cell[160524, 3597, 7192, 140, 361, "Output"],
Cell[167719, 3739, 1020, 36, 50, "Output"],
Cell[168742, 3777, 140, 2, 30, "Output"],
Cell[168885, 3781, 884, 30, 50, "Output"],
Cell[169772, 3813, 142, 2, 30, "Output"],
Cell[169917, 3817, 184, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170138, 3826, 3161, 89, 240, "Input"],
Cell[173302, 3917, 5470, 102, 375, "Output"],
Cell[178775, 4021, 18729, 352, 447, "Output"],
Cell[197507, 4375, 19226, 360, 299, "Output"],
Cell[216736, 4737, 4590, 128, 94, "Output"],
Cell[221329, 4867, 284, 5, 30, "Output"],
Cell[221616, 4874, 4039, 115, 94, "Output"],
Cell[225658, 4991, 284, 5, 30, "Output"],
Cell[225945, 4998, 330, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226312, 5010, 3122, 88, 240, "Input"],
Cell[229437, 5100, 5410, 100, 375, "Output"],
Cell[234850, 5202, 18670, 350, 447, "Output"],
Cell[253523, 5554, 19166, 358, 247, "Output"],
Cell[272692, 5914, 4530, 126, 94, "Output"],
Cell[277225, 6042, 221, 3, 30, "Output"],
Cell[277449, 6047, 4234, 119, 94, "Output"],
Cell[281686, 6168, 224, 3, 30, "Output"],
Cell[281913, 6173, 268, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[282218, 6183, 2869, 80, 221, "Input"],
Cell[285090, 6265, 5410, 101, 375, "Output"],
Cell[290503, 6368, 18670, 351, 447, "Output"],
Cell[309176, 6721, 19172, 359, 155, "Output"],
Cell[328351, 7082, 4528, 127, 94, "Output"],
Cell[332882, 7211, 222, 4, 30, "Output"],
Cell[333107, 7217, 3949, 113, 94, "Output"],
Cell[337059, 7332, 222, 4, 30, "Output"],
Cell[337284, 7338, 266, 6, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337587, 7349, 2588, 75, 202, "Input"],
Cell[340178, 7426, 5310, 99, 375, "Output"],
Cell[345491, 7527, 18572, 349, 447, "Output"],
Cell[364066, 7878, 19076, 357, 244, "Output"],
Cell[383145, 8237, 4430, 125, 94, "Output"],
Cell[387578, 8364, 124, 2, 30, "Output"],
Cell[387705, 8368, 3669, 106, 54, "Output"],
Cell[391377, 8476, 122, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[391536, 8483, 99, 2, 30, "Input"],
Cell[391638, 8487, 141, 3, 30, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

