(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    267455,       7253]
NotebookOptionsPosition[    265915,       7201]
NotebookOutlinePosition[    266463,       7222]
CellTagsIndexPosition[    266420,       7219]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Additional examples for MultinomialexpectationvalueHaar ", "Title",
 CellChangeTimes->{{3.7590663247921457`*^9, 3.75906632834408*^9}, {
  3.7590663893175974`*^9, 3.7590663910694504`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "RTNI`"}]}], "Input",
 CellChangeTimes->{{3.7499515425433083`*^9, 3.749951542735793*^9}, {
  3.7499518167324204`*^9, 3.749951817365728*^9}, {3.7499519252115097`*^9, 
  3.7499519278394876`*^9}, {3.7547244300889335`*^9, 3.7547244323459015`*^9}, {
  3.754737906092081*^9, 3.75473790746142*^9}, {3.755603108143794*^9, 
  3.75560310895862*^9}},
 ExpressionUUID -> "edbadc7c-ff24-4b16-8569-2722c6918d7f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package RTNI (Random Tensor Network Integrator) version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.5\"\>", 
   "\[InvisibleSpace]", "\<\" (last modification: \"\>", 
   "\[InvisibleSpace]", "\<\"26/01/2019\"\>", 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "Package RTNI (Random Tensor Network Integrator) version ", "1.0.5", 
   " (last modification: ", "26/01/2019", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014480290375`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions1.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions1.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014482452583`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions2.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions2.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401448407084*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions3.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions3.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014484445424`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions4.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions4.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401448486497*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions5.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions5.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.75940144852995*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions6.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions6.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401448571904*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions7.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions7.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401448616356*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions8.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions8.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401448716248*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions9.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions9.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014487681923`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions10.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions10.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401448913534*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions11.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions11.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014489714727`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions12.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions12.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401449023915*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions13.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions13.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014492127104`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions14.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions14.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401449267152*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions15.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions15.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014493820276`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions16.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions16.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014495043945`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions17.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions17.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014495997915`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions18.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions18.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.7594014497071753`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions19.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions19.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401449854515*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading precomputed Weingarten Functions from \"\>", 
   "\[InvisibleSpace]", "\<\"/precomputedWG/functions20.txt\"\>"}],
  SequenceForm[
  "Loading precomputed Weingarten Functions from ", 
   "/precomputedWG/functions20.txt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7590662568154373`*^9, 3.759401450047806*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"allexamples", "[", 
      RowBox[{"j_", ",", "d_"}], "]"}], ":=", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"assumes", " ", "j", " ", "to", " ", "be", " ", "even"}], ",", 
       " ", 
       RowBox[{
       "produces", " ", "all", " ", "monomials", " ", "of", " ", "degree", 
        " ", "j"}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"epslist", ",", "retvalue", ",", "k"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"epslist", "=", 
         RowBox[{"Tuples", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "j"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"retvalue", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Producemultinomialexpression", "[", 
              RowBox[{"epslist", "[", 
               RowBox[{"[", "k", "]"}], "]"}], "]"}], ",", 
             RowBox[{"MultinomialexpectationvalueHaar", "[", 
              RowBox[{"d", ",", 
               RowBox[{"epslist", "[", 
                RowBox[{"[", "k", "]"}], "]"}], ",", 
               RowBox[{"Table", "[", 
                RowBox[{
                 SubscriptBox["X", "k"], ",", 
                 RowBox[{"{", 
                  RowBox[{"k", ",", "1", ",", "j"}], "}"}]}], "]"}], ",", 
               "False"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "1", ",", 
             RowBox[{"Length", "[", "epslist", "]"}]}], "}"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "retvalue", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"allexamples", "[", 
     RowBox[{"2", ",", "d"}], "]"}], "]"}], "\n", 
   RowBox[{"TableForm", "[", 
    RowBox[{"allexamples", "[", 
     RowBox[{"4", ",", "d"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.737694428605708*^9, 3.7376944389638186`*^9}, 
   3.7376948102136717`*^9, {3.737695052626259*^9, 3.737695057592676*^9}, {
   3.7377068298674808`*^9, 3.737706830021238*^9}, 3.737706898314749*^9, {
   3.7377092507172956`*^9, 3.73770925529593*^9}, {3.7377096273587337`*^9, 
   3.7377096286090775`*^9}, {3.737712279930832*^9, 3.737712296020511*^9}, {
   3.7377125403548226`*^9, 3.7377125431745386`*^9}, 3.737712984658517*^9, {
   3.737783335815358*^9, 3.737783337062541*^9}, 3.7556102170915213`*^9, 
   3.759066271477318*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], " ", 
       RowBox[{"Tr", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], ".", 
       RowBox[{"Transpose", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], " ", 
       RowBox[{"Tr", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], ".", 
       RowBox[{"Transpose", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], ".", 
       RowBox[{"Transpose", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], " ", 
       RowBox[{"Tr", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], ".", 
       RowBox[{"Transpose", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     FractionBox[
      RowBox[{
       SubscriptBox["X", "1"], " ", 
       RowBox[{"Tr", "[", 
        SubscriptBox["X", "2"], "]"}]}], "d"]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7377130581671934`*^9, {3.737781983688101*^9, 3.7377819908227835`*^9}, 
   3.737782188141136*^9, {3.7377824548529434`*^9, 3.7377824850839005`*^9}, 
   3.737782560755271*^9, 3.7377826542768784`*^9, {3.7377833320243044`*^9, 
   3.737783337462146*^9}, {3.755610211648076*^9, 3.7556102180040803`*^9}, 
   3.7556102515191474`*^9, 3.7571513171105747`*^9, 3.7590662729430804`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "3"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "3"], ".", 
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "3"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "4"], "]"}], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "2"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "3"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "2"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "4"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "3"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "3"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "3"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "3"], ".", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["X", "2"], "]"}], ".", 
          SubscriptBox["X", "4"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], ".", "\<\"U\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "4"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "2"], "]"}], ".", 
        RowBox[{"Transpose", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "4"], "]"}], ".", 
         RowBox[{"Transpose", "[", 
          SubscriptBox["X", "2"], "]"}]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], ".", 
        SubscriptBox["X", "4"], ".", 
        SubscriptBox["X", "3"], ".", 
        SubscriptBox["X", "2"]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"], ".", 
          SubscriptBox["X", "3"]}], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["X", "1"], ".", 
         SubscriptBox["X", "4"], ".", 
         SubscriptBox["X", "2"]}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{"d", "-", 
        SuperscriptBox["d", "3"]}]], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"Tr", "[", 
         RowBox[{
          SubscriptBox["X", "2"], ".", 
          SubscriptBox["X", "4"]}], "]"}], " ", 
        RowBox[{"Tr", "[", 
         SubscriptBox["X", "3"], "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["d", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], ".", "\<\"U\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(*\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*SuperscriptBox[\\(U\\), \\(T\\)]\\)\"\>"}], "0"},
    {
     RowBox[{
      SubscriptBox["\<\"X\"\>", "1"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "2"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "3"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>", ".", 
      SubscriptBox["\<\"X\"\>", "4"], 
      ".", "\<\"\\!\\(\\*OverscriptBox[\\(U\\), \\(_\\)]\\)\"\>"}], "0"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7377130581671934`*^9, {3.737781983688101*^9, 3.7377819908227835`*^9}, 
   3.737782188141136*^9, {3.7377824548529434`*^9, 3.7377824850839005`*^9}, 
   3.737782560755271*^9, 3.7377826542768784`*^9, {3.7377833320243044`*^9, 
   3.737783337462146*^9}, {3.755610211648076*^9, 3.7556102180040803`*^9}, 
   3.7556102515191474`*^9, 3.7571513171105747`*^9, 3.759066273522537*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{831, 882},
WindowMargins->{{401, Automatic}, {212, Automatic}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.3199999999999, 841.92}},
Magnification:>1.25 Inherited,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 193, 2, 249, "Title"],
Cell[CellGroupData[{
Cell[797, 28, 555, 11, 62, "Input"],
Cell[CellGroupData[{
Cell[1377, 43, 534, 11, 52, "Print"],
Cell[1914, 56, 373, 8, 28, "Print"],
Cell[2290, 66, 371, 8, 28, "Print"],
Cell[2664, 76, 373, 8, 28, "Print"],
Cell[3040, 86, 371, 8, 28, "Print"],
Cell[3414, 96, 370, 8, 28, "Print"],
Cell[3787, 106, 371, 8, 28, "Print"],
Cell[4161, 116, 371, 8, 28, "Print"],
Cell[4535, 126, 371, 8, 28, "Print"],
Cell[4909, 136, 373, 8, 28, "Print"],
Cell[5285, 146, 373, 8, 28, "Print"],
Cell[5661, 156, 375, 8, 28, "Print"],
Cell[6039, 166, 373, 8, 28, "Print"],
Cell[6415, 176, 375, 8, 28, "Print"],
Cell[6793, 186, 373, 8, 28, "Print"],
Cell[7169, 196, 375, 8, 28, "Print"],
Cell[7547, 206, 375, 8, 28, "Print"],
Cell[7925, 216, 375, 8, 28, "Print"],
Cell[8303, 226, 375, 8, 28, "Print"],
Cell[8681, 236, 373, 8, 28, "Print"],
Cell[9057, 246, 373, 8, 28, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9479, 260, 2684, 63, 350, "Input"],
Cell[12166, 325, 5575, 148, 464, "Output"],
Cell[17744, 475, 248143, 6722, 8870, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

