(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    206441,       4885]
NotebookOptionsPosition[    195045,       4736]
NotebookOutlinePosition[    195410,       4752]
CellTagsIndexPosition[    195367,       4749]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Block", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "predictor", ",", "scanner", ",", "completer", ",", "stringText", ",", 
     "listA", ",", "i", ",", "grammar1", ",", "words", ",", "S1", ",", "k", 
     ",", "stateIndex", ",", "state", ",", "X", ",", "\[Alpha]", ",", 
     "\[Beta]", ",", "posDot"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"predictor", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"scanner", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"completer", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"predictor", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "grammar_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"65", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "90"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"i1", "=", "1"}], ",", 
          RowBox[{"i1", "\[LessEqual]", 
           RowBox[{"Length", "[", "grammar", "]"}]}], ",", 
          RowBox[{"i1", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], "\[Equal]", 
             " ", "B1"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"AppendTo", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"S2", ",", "k"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], ",", 
                   RowBox[{"\"\<.\>\"", "<>", 
                    RowBox[{"Part", "[", 
                    RowBox[{"grammar", ",", "i1", ",", "2"}], "]"}]}]}], 
                  "}"}], ",", "k"}], "}"}]}], "]"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"scanner", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "word_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A1", ",", "B1", ",", "j1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "alpha", ",", "beta", ",", "a"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"j1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"97", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "122"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"alpha", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"beta", "=", 
            RowBox[{"StringTake", "[", 
             RowBox[{"B1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"positionDot", "+", "2"}], ",", 
                RowBox[{"StringLength", "[", "B1", "]"}]}], "}"}]}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", 
          RowBox[{"beta", "=", "\"\<\>\""}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"StringTake", "[", 
            RowBox[{"word", ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "k"}], "}"}]}], "]"}], "\[Equal]", " ", "a"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{"S2", ",", 
               RowBox[{"k", "+", "1"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"A1", ",", 
                 RowBox[{
                 "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                "}"}], ",", "j1"}], "}"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"completer", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B", ",", "\[Gamma]", ",", 
         RowBox[{"S2", "=", "S"}], ",", "x", ",", "m", ",", "A", ",", "alpha",
          ",", "B1", ",", "beta", ",", "positionDot", ",", "j1", ",", 
         "segment"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Gamma]", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
              "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x"}], "]"}], "]"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"A", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "1"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"segment", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "2"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"positionDot", "=", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{"StringPosition", "[", 
               RowBox[{"segment", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", 
              "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"j1", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "2"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"alpha", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"positionDot", "\[GreaterEqual]", "1"}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"beta", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "2"}], ",", 
                  RowBox[{"StringLength", "[", "segment", "]"}]}], "}"}]}], 
               "]"}], ",", "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"B1", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "1"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "1"}], ",", 
                  RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"B1", "\[Equal]", "B"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"S2", ",", "k"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"A", ",", 
                    RowBox[{
                    "alpha", "<>", "B", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                   "}"}], ",", "j1"}], "}"}]}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"stringText", "=", 
     RowBox[{
     "Import", "[", 
      "\"\<Documents/PersonalFolder/CompilerDesign/grammarText1.txt\>\"", 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"listA", "=", 
     RowBox[{"TextWords", "[", "stringText", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"grammar1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{
          RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", 
       RowBox[{
        RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"grammar1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", "*", "i"}], "-", "1"}], "]"}], "]"}], ",", 
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{"2", "*", "i"}], "]"}], "]"}]}], "}"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Grammar \>\"", ",", "grammar1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"words", "=", "\"\<aabb\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"S1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"S1", ",", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"grammar1", ",", "1", ",", "1"}], "]"}], ",", 
          RowBox[{"\"\<.\>\"", "<>", 
           RowBox[{"Part", "[", 
            RowBox[{"grammar1", ",", "1", ",", "2"}], "]"}]}]}], "}"}], ",", 
        "1"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Initial state of the chart \>\"", ",", "S1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k", "=", "1"}], ",", 
      RowBox[{"k", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], ",", 
      RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Marker position->\>\"", ",", "k"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"stateIndex", "=", "1"}], ",", 
         RowBox[{"stateIndex", "\[LessEqual]", " ", 
          RowBox[{"Length", "[", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k"}], "]"}], "]"}]}], ",", 
         RowBox[{"stateIndex", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"state", "=", " ", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k", ",", "stateIndex"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Current state being shown \>\"", ",", "state"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"X", "=", 
           RowBox[{"Part", "[", 
            RowBox[{"state", ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"posDot", "=", 
           RowBox[{"Part", "[", 
            RowBox[{
             RowBox[{"StringPosition", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"posDot", "\[GreaterEqual]", "1"}], ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"posDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
             "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Beta]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"posDot", "+", "1"}], "\[LessEqual]", 
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], " ", 
             ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"posDot", "+", "1"}], ",", 
                 RowBox[{"StringLength", "[", 
                  RowBox[{"Part", "[", 
                   RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], 
                "}"}]}], "]"}], ",", "\"\<\>\""}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"StringLength", "[", "\[Beta]", "]"}], "\[NotEqual]", 
             " ", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"65", "\[LessEqual]", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"StringTake", "[", 
                   RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                 "1"}], "]"}], "\[LessEqual]", "90"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"predictor", "[", 
               RowBox[{"S1", ",", "state", ",", "k", ",", "grammar1"}], "]"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"If", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"97", "\[LessEqual]", 
                 RowBox[{"Part", "[", 
                  RowBox[{
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                   "1"}], "]"}], "\[LessEqual]", "122"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"scanner", "[", 
                 RowBox[{"S1", ",", "state", ",", "k", ",", "words"}], 
                 "]"}]}], "\[IndentingNewLine]", "]"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"completer", "[", 
             RowBox[{"S1", ",", "state", ",", "k"}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Final state of the chart \>\"", ",", "S1"}], "]"}], ";"}]}],
   "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.813161245596055*^9, 3.813161283995738*^9}, {
   3.8131614108111897`*^9, 3.81316141142057*^9}, {3.8131727720029783`*^9, 
   3.813172811604389*^9}, {3.813172868443242*^9, 3.813172944393732*^9}, {
   3.8131733896993437`*^9, 3.813173408588579*^9}, {3.813173473151021*^9, 
   3.813173498136088*^9}, {3.813173591726737*^9, 3.813173642955079*^9}, {
   3.8131737779944468`*^9, 3.8131737907875977`*^9}, {3.813174281222889*^9, 
   3.81317428138955*^9}, {3.813174425237109*^9, 3.813174427323574*^9}, {
   3.813174503688929*^9, 3.813174532703866*^9}, {3.81317457930345*^9, 
   3.8131746849059277`*^9}, {3.813174982859693*^9, 3.8131750266581793`*^9}, {
   3.813175062210472*^9, 3.813175085633336*^9}, {3.813175357351801*^9, 
   3.8131754144495363`*^9}, {3.813175471580306*^9, 3.8131757099403763`*^9}, {
   3.8131758292617903`*^9, 3.813175849272442*^9}, {3.8131759094869423`*^9, 
   3.8131759661182737`*^9}, {3.81317601287498*^9, 3.8131760833924007`*^9}, {
   3.8131762343661137`*^9, 3.81317623749228*^9}, {3.813176325116693*^9, 
   3.81317635727957*^9}, {3.8131763928944473`*^9, 3.813176674685019*^9}, {
   3.813176706687907*^9, 3.813176706832335*^9}, {3.813177024854231*^9, 
   3.813177036369254*^9}, {3.81317710299669*^9, 3.813177138257018*^9}, {
   3.8131772744534492`*^9, 3.8131773794586782`*^9}, {3.8131774326867733`*^9, 
   3.813177439336265*^9}, {3.813177494071083*^9, 3.8131775011076393`*^9}, {
   3.813177536175335*^9, 3.813177626567748*^9}, {3.8131776581098948`*^9, 
   3.813177671760893*^9}, {3.813177715743679*^9, 3.8131777480662727`*^9}, {
   3.813177839446171*^9, 3.8131778404513073`*^9}, {3.813178623180558*^9, 
   3.813178651923747*^9}, {3.8131787037998657`*^9, 3.813178726178495*^9}, {
   3.8131802719448347`*^9, 3.813180306908958*^9}, {3.813181114246807*^9, 
   3.813181134152676*^9}, {3.813183444345271*^9, 3.813183481223318*^9}, {
   3.813187210866098*^9, 3.8131872156619368`*^9}, {3.813193154820719*^9, 
   3.813193209006421*^9}, {3.8131943051505737`*^9, 3.813194305335478*^9}, 
   3.813195159761876*^9, {3.8131953247621527`*^9, 3.813195327741701*^9}, {
   3.8132322191125298`*^9, 3.81323225425135*^9}, {3.813237878090254*^9, 
   3.813237896556643*^9}, {3.813237955748393*^9, 3.81323796629196*^9}, {
   3.813238152763774*^9, 3.813238167464299*^9}, 3.8132381979527273`*^9, {
   3.813238441416862*^9, 3.81323845381925*^9}, {3.8132391145425863`*^9, 
   3.813239115419861*^9}, {3.8132391694365273`*^9, 3.8132391695694103`*^9}, {
   3.813239212382637*^9, 3.813239225241722*^9}, {3.8132396433088903`*^9, 
   3.8132398893350363`*^9}, {3.8132400756198053`*^9, 
   3.8132400856278467`*^9}, {3.813240147534068*^9, 3.813240165708768*^9}, {
   3.813240207742229*^9, 3.8132402085786133`*^9}, {3.813240440654212*^9, 
   3.813240506863839*^9}, {3.813240606819686*^9, 3.813240671903029*^9}, {
   3.813241033014455*^9, 3.813241064551553*^9}, {3.813242251017076*^9, 
   3.813242370857518*^9}, {3.813242409937428*^9, 3.813242498723736*^9}, {
   3.813242644016122*^9, 3.8132426507683067`*^9}, {3.8132428077334433`*^9, 
   3.813242811030261*^9}, {3.813242841188005*^9, 3.813242842111992*^9}, {
   3.813242969954438*^9, 3.8132429789417686`*^9}, {3.813243313201125*^9, 
   3.813243339536343*^9}, {3.813243406721182*^9, 3.813243406898899*^9}, {
   3.813244519354875*^9, 3.813244524245944*^9}, {3.81324467393931*^9, 
   3.813244692116789*^9}, {3.81324473432485*^9, 3.8132447619867887`*^9}, {
   3.813244936572015*^9, 3.813245061070053*^9}, {3.813245141820406*^9, 
   3.813245188657597*^9}, {3.813245230869544*^9, 3.813245306684093*^9}, {
   3.8132454443374434`*^9, 3.8132454706059437`*^9}, {3.813250323980433*^9, 
   3.813250332943001*^9}, {3.8132503743608*^9, 3.813250376813595*^9}, {
   3.813250486130128*^9, 3.813250499993581*^9}, {3.813250737621107*^9, 
   3.81325079329801*^9}, {3.81325089085716*^9, 3.813250900048204*^9}, {
   3.813251035510748*^9, 3.813251045767146*^9}, {3.813258591573715*^9, 
   3.813258598325177*^9}, {3.813258683881515*^9, 3.81325868855548*^9}, {
   3.8132589445509863`*^9, 3.81325907026884*^9}, {3.8132591448732023`*^9, 
   3.8132592360350237`*^9}, {3.813259515686029*^9, 3.813259524912566*^9}, {
   3.813259556774037*^9, 3.8132596753396177`*^9}, {3.813259889053245*^9, 
   3.8132599151207542`*^9}, {3.813259974342279*^9, 3.81326004737698*^9}, {
   3.8132600781890697`*^9, 3.813260118734866*^9}, {3.81326017828784*^9, 
   3.8132601807436438`*^9}, {3.813260281375361*^9, 3.813260289976831*^9}, {
   3.813260569781275*^9, 3.8132606573605747`*^9}, {3.8132608611048822`*^9, 
   3.81326089995408*^9}, {3.813260972744894*^9, 3.8132609815070877`*^9}, {
   3.813261052002496*^9, 3.813261074069181*^9}, {3.813261320499062*^9, 
   3.8132613653347483`*^9}, {3.81326141432848*^9, 3.8132614337057457`*^9}, {
   3.8132614958885*^9, 3.813261540130618*^9}, 3.813261696310176*^9, {
   3.813261795481683*^9, 3.813261861822803*^9}, {3.813261894198691*^9, 
   3.813262017256701*^9}, {3.813262198800187*^9, 3.813262551613288*^9}, {
   3.8132627957956877`*^9, 3.813262931997551*^9}, {3.813263056692666*^9, 
   3.813263075529436*^9}, {3.8132632376434937`*^9, 3.813263309071774*^9}, {
   3.813263346456777*^9, 3.8132633989110823`*^9}, {3.8132646980873013`*^9, 
   3.813264704034678*^9}, {3.813264770330132*^9, 
   3.813264771652808*^9}},ExpressionUUID->"c424a6bd-9c04-4f00-b295-\
0ac719b8a982"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Grammar \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"ab\"\>"}], "}"}]}], "}"}]}],
  SequenceForm["Grammar ", {{"G", "S"}, {"S", "aSb"}, {"S", "ab"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772052392*^9},ExpressionUUID->"734732aa-96e0-43a0-8cf0-\
250d6d2a1958"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}],
  SequenceForm[
  "Initial state of the chart ", {{{{"G", ".S"}, 1}}, {}, {}, {}, {}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647720599117`*^9},ExpressionUUID->"73db450d-e3d2-464f-bf2b-\
73adeb565af1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Marker position->", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772066845*^9},ExpressionUUID->"03cd9e31-87ee-441e-a50a-\
972ea22a4a28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", ".S"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772072029*^9},ExpressionUUID->"136c5d3e-cd65-4983-9de1-\
87055a49667c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.81326477207727*^9},ExpressionUUID->"fbe2faed-438c-450c-a500-348c54862680"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647720820227`*^9},ExpressionUUID->"c0a92673-2d85-4d83-895d-\
1123de2bf53c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Marker position->", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772086701*^9},ExpressionUUID->"243223f4-fe4b-44cd-b7fb-\
1ee75a180769"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772091455*^9},ExpressionUUID->"26b9186e-c642-4063-8a6d-\
bd7c56f38699"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647720965843`*^9},ExpressionUUID->"c9797515-4b3b-4225-abc6-\
8a1bc5a37a47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772101975*^9},ExpressionUUID->"1c8df121-4d76-4053-9602-\
dbffd620c3ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647721070232`*^9},ExpressionUUID->"c37b2ebe-50db-437b-993f-\
27120cde9f74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Marker position->", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772111897*^9},ExpressionUUID->"0c75e53a-2887-4cd8-b1aa-\
1e59c46f4da9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647721173983`*^9},ExpressionUUID->"45c3fffa-f487-4ea2-ae93-\
a7e771a619ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647721226482`*^9},ExpressionUUID->"6a164fbc-ef9b-4962-9d19-\
053fcf3de1b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772127314*^9},ExpressionUUID->"e8b85067-c696-49d1-9105-\
7bf7c77d6997"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772132023*^9},ExpressionUUID->"da9b0f17-dc63-4fa4-ab91-\
e0cf26c582c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Marker position->", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.81326477213488*^9},ExpressionUUID->"26e6eb07-2f48-4e9d-9989-9c9cc1de4119"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"ab.\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "ab."}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772137864*^9},ExpressionUUID->"feb16bfa-956a-4c89-add8-\
887943cddb8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aS.b"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772140952*^9},ExpressionUUID->"1c255217-b2b8-40cd-b8ac-\
29fdfab88e51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["Marker position->", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647721441*^9},ExpressionUUID->"10192fff-b024-47e6-b14d-160e13a1e899"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aSb."}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.8132647721469507`*^9},ExpressionUUID->"be18b26d-f10c-4fb8-9324-\
041a31a61073"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S.\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", "S."}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772150177*^9},ExpressionUUID->"f0ccff26-2142-4470-9052-\
b00367774f2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Final state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "1"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "2"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "2"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "3"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "3"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"ab.\"\>"}], "}"}], ",", "2"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\"S.\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Final state of the chart ", {{{{"G", ".S"}, 1}, {{"S", ".aSb"}, 1}, {{
      "S", ".ab"}, 1}}, {{{"S", "a.Sb"}, 1}, {{"S", "a.b"}, 1}, {{
      "S", ".aSb"}, 2}, {{"S", ".ab"}, 2}}, {{{"S", "a.Sb"}, 2}, {{
      "S", "a.b"}, 2}, {{"S", ".aSb"}, 3}, {{"S", ".ab"}, 3}}, {{{"S", "ab."},
       2}, {{"S", "aS.b"}, 1}}, {{{"S", "aSb."}, 1}, {{"G", "S."}, 1}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8132647111073723`*^9, 
  3.813264772153831*^9},ExpressionUUID->"c79a5829-74a9-4a6d-bcac-\
882ae0221738"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "predictor", ",", "scanner", ",", "completer", ",", "stringText", ",", 
     "listA", ",", "i", ",", "grammar1", ",", "words", ",", "S1", ",", "k", 
     ",", "stateIndex", ",", "state", ",", "X", ",", "\[Alpha]", ",", 
     "\[Beta]", ",", "posDot"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"predictor", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"scanner", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"completer", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"predictor", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "grammar_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"65", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "90"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"i1", "=", "1"}], ",", 
          RowBox[{"i1", "\[LessEqual]", 
           RowBox[{"Length", "[", "grammar", "]"}]}], ",", 
          RowBox[{"i1", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], "\[Equal]", 
             " ", "B1"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"AppendTo", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"S2", ",", "k"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], ",", 
                   RowBox[{"\"\<.\>\"", "<>", 
                    RowBox[{"Part", "[", 
                    RowBox[{"grammar", ",", "i1", ",", "2"}], "]"}]}]}], 
                  "}"}], ",", "k"}], "}"}]}], "]"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"scanner", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "word_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A1", ",", "B1", ",", "j1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "alpha", ",", "beta", ",", "a"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"j1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"97", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "122"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"alpha", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"beta", "=", 
            RowBox[{"StringTake", "[", 
             RowBox[{"B1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"positionDot", "+", "2"}], ",", 
                RowBox[{"StringLength", "[", "B1", "]"}]}], "}"}]}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", 
          RowBox[{"beta", "=", "\"\<\>\""}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"StringTake", "[", 
            RowBox[{"word", ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "k"}], "}"}]}], "]"}], "\[Equal]", " ", "a"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{"S2", ",", 
               RowBox[{"k", "+", "1"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"A1", ",", 
                 RowBox[{
                 "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                "}"}], ",", "j1"}], "}"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"completer", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B", ",", "\[Gamma]", ",", 
         RowBox[{"S2", "=", "S"}], ",", "x", ",", "m", ",", "A", ",", "alpha",
          ",", "B1", ",", "beta", ",", "positionDot", ",", "j1", ",", 
         "segment"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Gamma]", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
              "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x"}], "]"}], "]"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"A", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "1"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"segment", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "2"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"positionDot", "=", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{"StringPosition", "[", 
               RowBox[{"segment", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", 
              "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"j1", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "2"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"alpha", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"positionDot", "\[GreaterEqual]", "1"}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"beta", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "2"}], ",", 
                  RowBox[{"StringLength", "[", "segment", "]"}]}], "}"}]}], 
               "]"}], ",", "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"B1", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "1"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "1"}], ",", 
                  RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"B1", "\[Equal]", "B"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"S2", ",", "k"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"A", ",", 
                    RowBox[{
                    "alpha", "<>", "B", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                   "}"}], ",", "j1"}], "}"}]}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"stringText", "=", 
     RowBox[{
     "Import", "[", 
      "\"\<Documents/PersonalFolder/CompilerDesign/grammarText1.txt\>\"", 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"listA", "=", 
     RowBox[{"TextWords", "[", "stringText", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"grammar1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{
          RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", 
       RowBox[{
        RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"grammar1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", "*", "i"}], "-", "1"}], "]"}], "]"}], ",", 
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{"2", "*", "i"}], "]"}], "]"}]}], "}"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Grammar \>\"", ",", "grammar1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"words", "=", "\"\<aaabbb\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"S1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"S1", ",", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"grammar1", ",", "1", ",", "1"}], "]"}], ",", 
          RowBox[{"\"\<.\>\"", "<>", 
           RowBox[{"Part", "[", 
            RowBox[{"grammar1", ",", "1", ",", "2"}], "]"}]}]}], "}"}], ",", 
        "1"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Initial state of the chart \>\"", ",", "S1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k", "=", "1"}], ",", 
      RowBox[{"k", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], ",", 
      RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Marker position->\>\"", ",", "k"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"stateIndex", "=", "1"}], ",", 
         RowBox[{"stateIndex", "\[LessEqual]", " ", 
          RowBox[{"Length", "[", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k"}], "]"}], "]"}]}], ",", 
         RowBox[{"stateIndex", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"state", "=", " ", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k", ",", "stateIndex"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Current state being shown \>\"", ",", "state"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"X", "=", 
           RowBox[{"Part", "[", 
            RowBox[{"state", ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"posDot", "=", 
           RowBox[{"Part", "[", 
            RowBox[{
             RowBox[{"StringPosition", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"posDot", "\[GreaterEqual]", "1"}], ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"posDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
             "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Beta]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"posDot", "+", "1"}], "\[LessEqual]", 
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], " ", 
             ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"posDot", "+", "1"}], ",", 
                 RowBox[{"StringLength", "[", 
                  RowBox[{"Part", "[", 
                   RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], 
                "}"}]}], "]"}], ",", "\"\<\>\""}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"StringLength", "[", "\[Beta]", "]"}], "\[NotEqual]", 
             " ", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"65", "\[LessEqual]", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"StringTake", "[", 
                   RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                 "1"}], "]"}], "\[LessEqual]", "90"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"predictor", "[", 
               RowBox[{"S1", ",", "state", ",", "k", ",", "grammar1"}], "]"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"If", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"97", "\[LessEqual]", 
                 RowBox[{"Part", "[", 
                  RowBox[{
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                   "1"}], "]"}], "\[LessEqual]", "122"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"scanner", "[", 
                 RowBox[{"S1", ",", "state", ",", "k", ",", "words"}], 
                 "]"}]}], "\[IndentingNewLine]", "]"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"completer", "[", 
             RowBox[{"S1", ",", "state", ",", "k"}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Final state of the chart \>\"", ",", "S1"}], "]"}], ";"}]}],
   "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.813161245596055*^9, 3.813161283995738*^9}, {
   3.8131614108111897`*^9, 3.81316141142057*^9}, {3.8131727720029783`*^9, 
   3.813172811604389*^9}, {3.813172868443242*^9, 3.813172944393732*^9}, {
   3.8131733896993437`*^9, 3.813173408588579*^9}, {3.813173473151021*^9, 
   3.813173498136088*^9}, {3.813173591726737*^9, 3.813173642955079*^9}, {
   3.8131737779944468`*^9, 3.8131737907875977`*^9}, {3.813174281222889*^9, 
   3.81317428138955*^9}, {3.813174425237109*^9, 3.813174427323574*^9}, {
   3.813174503688929*^9, 3.813174532703866*^9}, {3.81317457930345*^9, 
   3.8131746849059277`*^9}, {3.813174982859693*^9, 3.8131750266581793`*^9}, {
   3.813175062210472*^9, 3.813175085633336*^9}, {3.813175357351801*^9, 
   3.8131754144495363`*^9}, {3.813175471580306*^9, 3.8131757099403763`*^9}, {
   3.8131758292617903`*^9, 3.813175849272442*^9}, {3.8131759094869423`*^9, 
   3.8131759661182737`*^9}, {3.81317601287498*^9, 3.8131760833924007`*^9}, {
   3.8131762343661137`*^9, 3.81317623749228*^9}, {3.813176325116693*^9, 
   3.81317635727957*^9}, {3.8131763928944473`*^9, 3.813176674685019*^9}, {
   3.813176706687907*^9, 3.813176706832335*^9}, {3.813177024854231*^9, 
   3.813177036369254*^9}, {3.81317710299669*^9, 3.813177138257018*^9}, {
   3.8131772744534492`*^9, 3.8131773794586782`*^9}, {3.8131774326867733`*^9, 
   3.813177439336265*^9}, {3.813177494071083*^9, 3.8131775011076393`*^9}, {
   3.813177536175335*^9, 3.813177626567748*^9}, {3.8131776581098948`*^9, 
   3.813177671760893*^9}, {3.813177715743679*^9, 3.8131777480662727`*^9}, {
   3.813177839446171*^9, 3.8131778404513073`*^9}, {3.813178623180558*^9, 
   3.813178651923747*^9}, {3.8131787037998657`*^9, 3.813178726178495*^9}, {
   3.8131802719448347`*^9, 3.813180306908958*^9}, {3.813181114246807*^9, 
   3.813181134152676*^9}, {3.813183444345271*^9, 3.813183481223318*^9}, {
   3.813187210866098*^9, 3.8131872156619368`*^9}, {3.813193154820719*^9, 
   3.813193209006421*^9}, {3.8131943051505737`*^9, 3.813194305335478*^9}, 
   3.813195159761876*^9, {3.8131953247621527`*^9, 3.813195327741701*^9}, {
   3.8132322191125298`*^9, 3.81323225425135*^9}, {3.813237878090254*^9, 
   3.813237896556643*^9}, {3.813237955748393*^9, 3.81323796629196*^9}, {
   3.813238152763774*^9, 3.813238167464299*^9}, 3.8132381979527273`*^9, {
   3.813238441416862*^9, 3.81323845381925*^9}, {3.8132391145425863`*^9, 
   3.813239115419861*^9}, {3.8132391694365273`*^9, 3.8132391695694103`*^9}, {
   3.813239212382637*^9, 3.813239225241722*^9}, {3.8132396433088903`*^9, 
   3.8132398893350363`*^9}, {3.8132400756198053`*^9, 
   3.8132400856278467`*^9}, {3.813240147534068*^9, 3.813240165708768*^9}, {
   3.813240207742229*^9, 3.8132402085786133`*^9}, {3.813240440654212*^9, 
   3.813240506863839*^9}, {3.813240606819686*^9, 3.813240671903029*^9}, {
   3.813241033014455*^9, 3.813241064551553*^9}, {3.813242251017076*^9, 
   3.813242370857518*^9}, {3.813242409937428*^9, 3.813242498723736*^9}, {
   3.813242644016122*^9, 3.8132426507683067`*^9}, {3.8132428077334433`*^9, 
   3.813242811030261*^9}, {3.813242841188005*^9, 3.813242842111992*^9}, {
   3.813242969954438*^9, 3.8132429789417686`*^9}, {3.813243313201125*^9, 
   3.813243339536343*^9}, {3.813243406721182*^9, 3.813243406898899*^9}, {
   3.813244519354875*^9, 3.813244524245944*^9}, {3.81324467393931*^9, 
   3.813244692116789*^9}, {3.81324473432485*^9, 3.8132447619867887`*^9}, {
   3.813244936572015*^9, 3.813245061070053*^9}, {3.813245141820406*^9, 
   3.813245188657597*^9}, {3.813245230869544*^9, 3.813245306684093*^9}, {
   3.8132454443374434`*^9, 3.8132454706059437`*^9}, {3.813250323980433*^9, 
   3.813250332943001*^9}, {3.8132503743608*^9, 3.813250376813595*^9}, {
   3.813250486130128*^9, 3.813250499993581*^9}, {3.813250737621107*^9, 
   3.81325079329801*^9}, {3.81325089085716*^9, 3.813250900048204*^9}, {
   3.813251035510748*^9, 3.813251045767146*^9}, {3.813258591573715*^9, 
   3.813258598325177*^9}, {3.813258683881515*^9, 3.81325868855548*^9}, {
   3.8132589445509863`*^9, 3.81325907026884*^9}, {3.8132591448732023`*^9, 
   3.8132592360350237`*^9}, {3.813259515686029*^9, 3.813259524912566*^9}, {
   3.813259556774037*^9, 3.8132596753396177`*^9}, {3.813259889053245*^9, 
   3.8132599151207542`*^9}, {3.813259974342279*^9, 3.81326004737698*^9}, {
   3.8132600781890697`*^9, 3.813260118734866*^9}, {3.81326017828784*^9, 
   3.8132601807436438`*^9}, {3.813260281375361*^9, 3.813260289976831*^9}, {
   3.813260569781275*^9, 3.8132606573605747`*^9}, {3.8132608611048822`*^9, 
   3.81326089995408*^9}, {3.813260972744894*^9, 3.8132609815070877`*^9}, {
   3.813261052002496*^9, 3.813261074069181*^9}, {3.813261320499062*^9, 
   3.8132613653347483`*^9}, {3.81326141432848*^9, 3.8132614337057457`*^9}, {
   3.8132614958885*^9, 3.813261540130618*^9}, 3.813261696310176*^9, {
   3.813261795481683*^9, 3.813261861822803*^9}, {3.813261894198691*^9, 
   3.813262017256701*^9}, {3.813262198800187*^9, 3.813262551613288*^9}, {
   3.8132627957956877`*^9, 3.813262931997551*^9}, {3.813263056692666*^9, 
   3.813263075529436*^9}, {3.8132632376434937`*^9, 3.813263309071774*^9}, {
   3.813263346456777*^9, 3.8132633989110823`*^9}, {3.8132646980873013`*^9, 
   3.813264704034678*^9}, {3.813264770330132*^9, 3.813264771652808*^9}, {
   3.813264906571568*^9, 
   3.813264907515176*^9}},ExpressionUUID->"9a743a0a-ebfe-4fa0-87f3-\
8dabf59fe184"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Grammar \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"ab\"\>"}], "}"}]}], "}"}]}],
  SequenceForm["Grammar ", {{"G", "S"}, {"S", "aSb"}, {"S", "ab"}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908285467*^9},ExpressionUUID->"e45e43db-f867-4716-92ad-\
220f14cee7cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}],
  SequenceForm[
  "Initial state of the chart ", {{{{"G", ".S"}, 1}}, {}, {}, {}, {}, {}, {}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908290065*^9},ExpressionUUID->"8a97848d-ee20-4961-89b9-\
fbf7ffd363da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Marker position->", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908296475*^9},ExpressionUUID->"f4fdb8c0-b7d7-4040-8f4e-\
77a66f9d4da9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", ".S"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908300592*^9},ExpressionUUID->"f40cbfba-2095-4445-b8cc-\
28374144deb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8132649083049583`*^9},ExpressionUUID->"0c56693a-3eb9-479f-ab0e-\
e709ef969e63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326490830963*^9},ExpressionUUID->"6be35a2f-d232-4362-8e45-2c6e811da328"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Marker position->", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908313905*^9},ExpressionUUID->"89fcfa9d-9394-432e-adc9-\
a88073607b9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908318343*^9},ExpressionUUID->"e2c3c6f8-c24e-4332-95c5-\
267f0690f379"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908322671*^9},ExpressionUUID->"f3f89e07-084c-4481-9774-\
5340703d8747"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908327064*^9},ExpressionUUID->"45c6ca2d-e4da-43ef-929c-\
ce4a7716b3d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908331319*^9},ExpressionUUID->"3a45a479-8a1f-4b55-bff3-\
c43a34b8c4e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Marker position->", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908335532*^9},ExpressionUUID->"68c5745d-0738-4845-a301-\
9edfb9139d94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8132649083397827`*^9},ExpressionUUID->"a4fdc0cf-4ef3-4175-865b-\
39146321c306"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908344214*^9},ExpressionUUID->"ea48e32f-518d-44fd-907a-\
baf80996de15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908348483*^9},ExpressionUUID->"8aa60ce2-d3dc-4bfc-9691-\
af134222e384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8132649083529387`*^9},ExpressionUUID->"450531c3-6f4b-4f4a-8c10-\
00faa067565f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Marker position->", 4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908355575*^9},ExpressionUUID->"23e181c5-074a-4eff-854f-\
b6ca5fb3c8c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908358089*^9},ExpressionUUID->"148e212a-763c-4522-b5ae-\
03a4754ce775"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908360743*^9},ExpressionUUID->"f0593df7-d709-4270-a962-\
313b299e3163"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "4"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908363415*^9},ExpressionUUID->"c8e6da14-6e11-4ab4-97ab-\
f2dc55537bae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "4"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908366045*^9},ExpressionUUID->"92c88ba9-4033-42a9-90b6-\
5b8e7ccb574b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["Marker position->", 5],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908368939*^9},ExpressionUUID->"1e6f12a8-d2d3-4d0d-a210-\
4e0a1b673409"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"ab.\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "ab."}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908371615*^9},ExpressionUUID->"20fcfb3f-dc41-4162-b6f8-\
83630f87e338"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aS.b"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908374297*^9},ExpressionUUID->"9c28b189-499d-4d6c-b394-\
f93d04660728"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["Marker position->", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908376957*^9},ExpressionUUID->"094f0e12-0ef9-44b0-a795-\
44cc31fbb48c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aSb."}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908379771*^9},ExpressionUUID->"ecea5b70-fb74-463f-a79e-\
418a8dbc3bf8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aS.b"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8132649083825827`*^9},ExpressionUUID->"92bf8da8-4a70-421b-b740-\
4dc69dcf2e46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["Marker position->", 7],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326490838521*^9},ExpressionUUID->"b55f5cc1-fc40-44f9-af9b-b500fa4b043d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aSb."}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908387938*^9},ExpressionUUID->"433bb101-17dd-4730-8a9c-\
f3ce306b73e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S.\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", "S."}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908390601*^9},ExpressionUUID->"44f0b389-e384-4785-b497-\
68b01ead2d14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Final state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "1"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "2"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "2"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "3"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "3"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "3"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "3"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "4"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "4"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"ab.\"\>"}], "}"}], ",", "3"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "2"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\"S.\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Final state of the chart ", {{{{"G", ".S"}, 1}, {{"S", ".aSb"}, 1}, {{
      "S", ".ab"}, 1}}, {{{"S", "a.Sb"}, 1}, {{"S", "a.b"}, 1}, {{
      "S", ".aSb"}, 2}, {{"S", ".ab"}, 2}}, {{{"S", "a.Sb"}, 2}, {{
      "S", "a.b"}, 2}, {{"S", ".aSb"}, 3}, {{"S", ".ab"}, 3}}, {{{
      "S", "a.Sb"}, 3}, {{"S", "a.b"}, 3}, {{"S", ".aSb"}, 4}, {{"S", ".ab"}, 
      4}}, {{{"S", "ab."}, 3}, {{"S", "aS.b"}, 2}}, {{{"S", "aSb."}, 2}, {{
      "S", "aS.b"}, 1}}, {{{"S", "aSb."}, 1}, {{"G", "S."}, 1}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813264908394102*^9},ExpressionUUID->"dbaf8e9c-7aa9-46c2-9fe2-\
a906b9bf3256"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Some", " ", "more", " ", "things", " ", "that", " ", "I", " ", "want", " ",
    "to", " ", "collect"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8132656902958508`*^9, 
  3.81326571001425*^9}},ExpressionUUID->"0f2f4392-93b5-4e8a-9f86-\
c59cb5d7e914"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.813265710599863*^9, 
  3.8132657195922527`*^9}},ExpressionUUID->"5f8916cd-2e38-4275-9ebc-\
f087887b19cf"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.81326571984048*^9},ExpressionUUID->"ea6bc154-c69e-4604-aad9-f9eed82dfb12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5"}], "}"}], ",", "5"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8132657246172132`*^9, 
  3.813265727368882*^9}},ExpressionUUID->"eeb3a58f-336e-4174-a86d-\
62b211ab6876"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.81326572772169*^9},ExpressionUUID->"b6f422a8-7b5d-4438-ba32-1eff94aab790"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "I", " ", "think", " ", "I", " ", "can", " ", "debug", " ", "here", " ", 
   "preventing", " ", "running", " ", "into", " ", "infinite", " ", "loops"}],
   "*)"}]], "Input",
 CellChangeTimes->{{3.81326501854571*^9, 3.813265021246725*^9}, {
  3.81326506468871*^9, 
  3.813265111010025*^9}},ExpressionUUID->"22573732-3e90-4b98-8825-\
35d97fe54f6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "predictor", ",", "scanner", ",", "completer", ",", "stringText", ",", 
     "listA", ",", "i", ",", "grammar1", ",", "words", ",", "S1", ",", "k", 
     ",", "stateIndex", ",", "state", ",", "X", ",", "\[Alpha]", ",", 
     "\[Beta]", ",", "posDot", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"predictor", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"scanner", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"completer", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"predictor", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "grammar_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "package"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"65", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "90"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"i1", "=", "1"}], ",", 
          RowBox[{"i1", "\[LessEqual]", 
           RowBox[{"Length", "[", "grammar", "]"}]}], ",", 
          RowBox[{"i1", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"package", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], ",", 
                RowBox[{"\"\<.\>\"", "<>", 
                 RowBox[{"Part", "[", 
                  RowBox[{"grammar", ",", "i1", ",", "2"}], "]"}]}]}], "}"}], 
              ",", "k"}], "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], "\[Equal]", 
              " ", "B1"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", "k"}], "]"}], ",", " ", "package"}], 
                 "]"}], "\[Equal]", "False"}], ",", 
               RowBox[{"AppendTo", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}]}], 
              "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"scanner", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "word_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A1", ",", "B1", ",", "j1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "alpha", ",", "beta", ",", "a", ",", 
         "package"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"j1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"97", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "122"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"alpha", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"beta", "=", 
            RowBox[{"StringTake", "[", 
             RowBox[{"B1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"positionDot", "+", "2"}], ",", 
                RowBox[{"StringLength", "[", "B1", "]"}]}], "}"}]}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", 
          RowBox[{"beta", "=", "\"\<\>\""}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"StringTake", "[", 
            RowBox[{"word", ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "k"}], "}"}]}], "]"}], "\[Equal]", " ", "a"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"package", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A1", ",", 
                RowBox[{
                "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
               "}"}], ",", "j1"}], "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"S2", ",", 
                  RowBox[{"k", "+", "1"}]}], "]"}], ",", "package"}], "]"}], 
              "\[Equal]", "False"}], ",", 
             RowBox[{"AppendTo", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"S2", ",", 
                 RowBox[{"k", "+", "1"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"A1", ",", 
                   RowBox[{
                   "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                  "}"}], ",", "j1"}], "}"}]}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"completer", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B", ",", "\[Gamma]", ",", 
         RowBox[{"S2", "=", "S"}], ",", "x", ",", "m", ",", "A", ",", "alpha",
          ",", "B1", ",", "beta", ",", "positionDot", ",", "j1", ",", 
         "segment", ",", "package"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Gamma]", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
              "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x"}], "]"}], "]"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"A", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "1"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"segment", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "2"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"positionDot", "=", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{"StringPosition", "[", 
               RowBox[{"segment", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", 
              "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"j1", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "2"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"alpha", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"positionDot", "\[GreaterEqual]", "1"}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"beta", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "2"}], ",", 
                  RowBox[{"StringLength", "[", "segment", "]"}]}], "}"}]}], 
               "]"}], ",", "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"B1", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "1"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "1"}], ",", 
                  RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"B1", "\[Equal]", "B"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"package", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"A", ",", 
                   RowBox[{
                   "alpha", "<>", "B", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                  "}"}], ",", "j1"}], "}"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}], 
                 "\[Equal]", "False"}], ",", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}]}],
                "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"stringText", "=", 
     RowBox[{
     "Import", "[", 
      "\"\<Documents/PersonalFolder/CompilerDesign/grammarText1.txt\>\"", 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"listA", "=", 
     RowBox[{"TextWords", "[", "stringText", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"grammar1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{
          RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", 
       RowBox[{
        RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"grammar1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", "*", "i"}], "-", "1"}], "]"}], "]"}], ",", 
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{"2", "*", "i"}], "]"}], "]"}]}], "}"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Grammar \>\"", ",", "grammar1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"words", "=", "\"\<aaabbb\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"S1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"S1", ",", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"grammar1", ",", "1", ",", "1"}], "]"}], ",", 
          RowBox[{"\"\<.\>\"", "<>", 
           RowBox[{"Part", "[", 
            RowBox[{"grammar1", ",", "1", ",", "2"}], "]"}]}]}], "}"}], ",", 
        "1"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Initial state of the chart \>\"", ",", "S1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k", "=", "1"}], ",", 
      RowBox[{"k", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], ",", 
      RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Marker position->\>\"", ",", "k"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"stateIndex", "=", "1"}], ",", 
         RowBox[{"stateIndex", "\[LessEqual]", " ", 
          RowBox[{"Length", "[", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k"}], "]"}], "]"}]}], ",", 
         RowBox[{"stateIndex", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"state", "=", " ", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k", ",", "stateIndex"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Current state being shown \>\"", ",", "state"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"X", "=", 
           RowBox[{"Part", "[", 
            RowBox[{"state", ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"posDot", "=", 
           RowBox[{"Part", "[", 
            RowBox[{
             RowBox[{"StringPosition", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"posDot", "\[GreaterEqual]", "1"}], ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"posDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
             "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Beta]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"posDot", "+", "1"}], "\[LessEqual]", 
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], " ", 
             ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"posDot", "+", "1"}], ",", 
                 RowBox[{"StringLength", "[", 
                  RowBox[{"Part", "[", 
                   RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], 
                "}"}]}], "]"}], ",", "\"\<\>\""}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"StringLength", "[", "\[Beta]", "]"}], "\[NotEqual]", 
             " ", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"65", "\[LessEqual]", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"StringTake", "[", 
                   RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                 "1"}], "]"}], "\[LessEqual]", "90"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"predictor", "[", 
               RowBox[{"S1", ",", "state", ",", "k", ",", "grammar1"}], "]"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"If", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"97", "\[LessEqual]", 
                 RowBox[{"Part", "[", 
                  RowBox[{
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                   "1"}], "]"}], "\[LessEqual]", "122"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"scanner", "[", 
                 RowBox[{"S1", ",", "state", ",", "k", ",", "words"}], 
                 "]"}]}], "\[IndentingNewLine]", "]"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"completer", "[", 
             RowBox[{"S1", ",", "state", ",", "k"}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Final state of the chart \>\"", ",", "S1"}], "]"}], ";"}]}],
   "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.813161245596055*^9, 3.813161283995738*^9}, {
   3.8131614108111897`*^9, 3.81316141142057*^9}, {3.8131727720029783`*^9, 
   3.813172811604389*^9}, {3.813172868443242*^9, 3.813172944393732*^9}, {
   3.8131733896993437`*^9, 3.813173408588579*^9}, {3.813173473151021*^9, 
   3.813173498136088*^9}, {3.813173591726737*^9, 3.813173642955079*^9}, {
   3.8131737779944468`*^9, 3.8131737907875977`*^9}, {3.813174281222889*^9, 
   3.81317428138955*^9}, {3.813174425237109*^9, 3.813174427323574*^9}, {
   3.813174503688929*^9, 3.813174532703866*^9}, {3.81317457930345*^9, 
   3.8131746849059277`*^9}, {3.813174982859693*^9, 3.8131750266581793`*^9}, {
   3.813175062210472*^9, 3.813175085633336*^9}, {3.813175357351801*^9, 
   3.8131754144495363`*^9}, {3.813175471580306*^9, 3.8131757099403763`*^9}, {
   3.8131758292617903`*^9, 3.813175849272442*^9}, {3.8131759094869423`*^9, 
   3.8131759661182737`*^9}, {3.81317601287498*^9, 3.8131760833924007`*^9}, {
   3.8131762343661137`*^9, 3.81317623749228*^9}, {3.813176325116693*^9, 
   3.81317635727957*^9}, {3.8131763928944473`*^9, 3.813176674685019*^9}, {
   3.813176706687907*^9, 3.813176706832335*^9}, {3.813177024854231*^9, 
   3.813177036369254*^9}, {3.81317710299669*^9, 3.813177138257018*^9}, {
   3.8131772744534492`*^9, 3.8131773794586782`*^9}, {3.8131774326867733`*^9, 
   3.813177439336265*^9}, {3.813177494071083*^9, 3.8131775011076393`*^9}, {
   3.813177536175335*^9, 3.813177626567748*^9}, {3.8131776581098948`*^9, 
   3.813177671760893*^9}, {3.813177715743679*^9, 3.8131777480662727`*^9}, {
   3.813177839446171*^9, 3.8131778404513073`*^9}, {3.813178623180558*^9, 
   3.813178651923747*^9}, {3.8131787037998657`*^9, 3.813178726178495*^9}, {
   3.8131802719448347`*^9, 3.813180306908958*^9}, {3.813181114246807*^9, 
   3.813181134152676*^9}, {3.813183444345271*^9, 3.813183481223318*^9}, {
   3.813187210866098*^9, 3.8131872156619368`*^9}, {3.813193154820719*^9, 
   3.813193209006421*^9}, {3.8131943051505737`*^9, 3.813194305335478*^9}, 
   3.813195159761876*^9, {3.8131953247621527`*^9, 3.813195327741701*^9}, {
   3.8132322191125298`*^9, 3.81323225425135*^9}, {3.813237878090254*^9, 
   3.813237896556643*^9}, {3.813237955748393*^9, 3.81323796629196*^9}, {
   3.813238152763774*^9, 3.813238167464299*^9}, 3.8132381979527273`*^9, {
   3.813238441416862*^9, 3.81323845381925*^9}, {3.8132391145425863`*^9, 
   3.813239115419861*^9}, {3.8132391694365273`*^9, 3.8132391695694103`*^9}, {
   3.813239212382637*^9, 3.813239225241722*^9}, {3.8132396433088903`*^9, 
   3.8132398893350363`*^9}, {3.8132400756198053`*^9, 
   3.8132400856278467`*^9}, {3.813240147534068*^9, 3.813240165708768*^9}, {
   3.813240207742229*^9, 3.8132402085786133`*^9}, {3.813240440654212*^9, 
   3.813240506863839*^9}, {3.813240606819686*^9, 3.813240671903029*^9}, {
   3.813241033014455*^9, 3.813241064551553*^9}, {3.813242251017076*^9, 
   3.813242370857518*^9}, {3.813242409937428*^9, 3.813242498723736*^9}, {
   3.813242644016122*^9, 3.8132426507683067`*^9}, {3.8132428077334433`*^9, 
   3.813242811030261*^9}, {3.813242841188005*^9, 3.813242842111992*^9}, {
   3.813242969954438*^9, 3.8132429789417686`*^9}, {3.813243313201125*^9, 
   3.813243339536343*^9}, {3.813243406721182*^9, 3.813243406898899*^9}, {
   3.813244519354875*^9, 3.813244524245944*^9}, {3.81324467393931*^9, 
   3.813244692116789*^9}, {3.81324473432485*^9, 3.8132447619867887`*^9}, {
   3.813244936572015*^9, 3.813245061070053*^9}, {3.813245141820406*^9, 
   3.813245188657597*^9}, {3.813245230869544*^9, 3.813245306684093*^9}, {
   3.8132454443374434`*^9, 3.8132454706059437`*^9}, {3.813250323980433*^9, 
   3.813250332943001*^9}, {3.8132503743608*^9, 3.813250376813595*^9}, {
   3.813250486130128*^9, 3.813250499993581*^9}, {3.813250737621107*^9, 
   3.81325079329801*^9}, {3.81325089085716*^9, 3.813250900048204*^9}, {
   3.813251035510748*^9, 3.813251045767146*^9}, {3.813258591573715*^9, 
   3.813258598325177*^9}, {3.813258683881515*^9, 3.81325868855548*^9}, {
   3.8132589445509863`*^9, 3.81325907026884*^9}, {3.8132591448732023`*^9, 
   3.8132592360350237`*^9}, {3.813259515686029*^9, 3.813259524912566*^9}, {
   3.813259556774037*^9, 3.8132596753396177`*^9}, {3.813259889053245*^9, 
   3.8132599151207542`*^9}, {3.813259974342279*^9, 3.81326004737698*^9}, {
   3.8132600781890697`*^9, 3.813260118734866*^9}, {3.81326017828784*^9, 
   3.8132601807436438`*^9}, {3.813260281375361*^9, 3.813260289976831*^9}, {
   3.813260569781275*^9, 3.8132606573605747`*^9}, {3.8132608611048822`*^9, 
   3.81326089995408*^9}, {3.813260972744894*^9, 3.8132609815070877`*^9}, {
   3.813261052002496*^9, 3.813261074069181*^9}, {3.813261320499062*^9, 
   3.8132613653347483`*^9}, {3.81326141432848*^9, 3.8132614337057457`*^9}, {
   3.8132614958885*^9, 3.813261540130618*^9}, 3.813261696310176*^9, {
   3.813261795481683*^9, 3.813261861822803*^9}, {3.813261894198691*^9, 
   3.813262017256701*^9}, {3.813262198800187*^9, 3.813262551613288*^9}, {
   3.8132627957956877`*^9, 3.813262931997551*^9}, {3.813263056692666*^9, 
   3.813263075529436*^9}, {3.8132632376434937`*^9, 3.813263309071774*^9}, {
   3.813263346456777*^9, 3.8132633989110823`*^9}, {3.8132646980873013`*^9, 
   3.813264704034678*^9}, {3.813264770330132*^9, 3.813264771652808*^9}, {
   3.813264906571568*^9, 3.813264907515176*^9}, {3.813265264033187*^9, 
   3.8132653720442963`*^9}, {3.8132654322292843`*^9, 3.813265443082346*^9}, {
   3.813265630055305*^9, 3.81326565278187*^9}, {3.8132657367844877`*^9, 
   3.813265770500132*^9}, {3.8132658937669907`*^9, 3.8132659350039787`*^9}, {
   3.813265966455318*^9, 3.813266152154606*^9}, {3.813266209970484*^9, 
   3.813266212628346*^9}},ExpressionUUID->"d5321d68-4291-4891-9a9c-\
d63685316c8d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Grammar \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"ab\"\>"}], "}"}]}], "}"}]}],
  SequenceForm["Grammar ", {{"G", "S"}, {"S", "aSb"}, {"S", "ab"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213918178*^9},ExpressionUUID->"a5abe1a5-a1af-4d01-92ad-\
9740b5a5b3b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}],
  SequenceForm[
  "Initial state of the chart ", {{{{"G", ".S"}, 1}}, {}, {}, {}, {}, {}, {}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213924594*^9},ExpressionUUID->"d47f2ec8-f838-4d4a-b143-\
b91034d32b36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Marker position->", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213930822*^9},ExpressionUUID->"67073172-b2ca-410c-8f79-\
759cbb954664"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", ".S"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213935162*^9},ExpressionUUID->"3fc5cf3c-c362-4e11-8ab7-\
587d616e95ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213939646*^9},ExpressionUUID->"787f8f09-81ea-46b9-be46-\
7969e576dc37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213945109*^9},ExpressionUUID->"858ad611-d7ba-4a75-8f09-\
0f88c4d577ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Marker position->", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662139502287`*^9},ExpressionUUID->"8f9d9c11-df51-4f40-891b-\
37de8f0dafc1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662139545918`*^9},ExpressionUUID->"4fb4cb96-7bff-476b-ae5e-\
ce5f9b764c19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213958995*^9},ExpressionUUID->"300c696d-8d06-4504-85db-\
4f7d0c23ea14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213963482*^9},ExpressionUUID->"e839f925-d6ad-4ce5-9259-\
fbd0176dd88d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662139679747`*^9},ExpressionUUID->"6a43585a-fc29-4bc5-9044-\
4abe3ce61bb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Marker position->", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.81326621397248*^9},ExpressionUUID->"b1fbf5cc-cbfc-421f-b690-634ff21fbdec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213976819*^9},ExpressionUUID->"8bd73b14-9b53-4f45-9364-\
29c322334071"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213981288*^9},ExpressionUUID->"312e7a62-0e67-49a7-a5c2-\
69b9e08b7227"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662139857473`*^9},ExpressionUUID->"4e818b76-813b-4c61-8bbe-\
e5f1500baea8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662139910593`*^9},ExpressionUUID->"155f0982-8392-4b1e-a93c-\
2e90368eaacf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Marker position->", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213993847*^9},ExpressionUUID->"12d73b08-3764-4e9d-8ca8-\
5f9a8cd2b6b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.Sb"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213996832*^9},ExpressionUUID->"89c9c70d-7f05-4d2b-b897-\
c3a98ccc1d10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "a.b"}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266213999743*^9},ExpressionUUID->"56fd9470-2ec2-4ba9-a265-\
1c449a610697"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "4"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".aSb"}, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662140032263`*^9},ExpressionUUID->"565641a7-578e-42b0-9a0e-\
7edf6f5c167b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "4"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".ab"}, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214006062*^9},ExpressionUUID->"b404dfb9-9ca6-4ad1-9bdb-\
e8f2074ca375"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["Marker position->", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214008792*^9},ExpressionUUID->"dd2578c7-1ed5-4f79-95af-\
d66e695f7992"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"ab.\"\>"}], "}"}], ",", "3"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "ab."}, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214011997*^9},ExpressionUUID->"6b67994e-b5d8-43bd-9f16-\
0e19f4316428"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aS.b"}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.8132662140152807`*^9},ExpressionUUID->"adec3858-6f93-4934-b9ea-\
524d504a953b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["Marker position->", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214018111*^9},ExpressionUUID->"58963d0d-6954-4e60-825a-\
a26a469b4806"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "2"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aSb."}, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.81326621402212*^9},ExpressionUUID->"a20e9181-1322-48b6-bb91-daa835362e65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aS.b"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214026774*^9},ExpressionUUID->"7bddbbd4-ea62-4fe4-92f6-\
2e41d4b33b3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["Marker position->", 7],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214031357*^9},ExpressionUUID->"11756fcf-5a60-49ca-805f-\
2fd9bb1676ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", "aSb."}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214035616*^9},ExpressionUUID->"b93da798-4bb7-4578-85f0-\
c92162e95a71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S.\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", "S."}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214040134*^9},ExpressionUUID->"7d8febd5-ce3d-4d55-a6d0-\
0f7142eb8bdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Final state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "1"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "2"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "2"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "3"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "3"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.Sb\"\>"}], "}"}], ",", "3"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"a.b\"\>"}], "}"}], ",", "3"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".aSb\"\>"}], "}"}], ",", "4"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".ab\"\>"}], "}"}], ",", "4"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"ab.\"\>"}], "}"}], ",", "3"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "2"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aS.b\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\"aSb.\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\"S.\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Final state of the chart ", {{{{"G", ".S"}, 1}, {{"S", ".aSb"}, 1}, {{
      "S", ".ab"}, 1}}, {{{"S", "a.Sb"}, 1}, {{"S", "a.b"}, 1}, {{
      "S", ".aSb"}, 2}, {{"S", ".ab"}, 2}}, {{{"S", "a.Sb"}, 2}, {{
      "S", "a.b"}, 2}, {{"S", ".aSb"}, 3}, {{"S", ".ab"}, 3}}, {{{
      "S", "a.Sb"}, 3}, {{"S", "a.b"}, 3}, {{"S", ".aSb"}, 4}, {{"S", ".ab"}, 
      4}}, {{{"S", "ab."}, 3}, {{"S", "aS.b"}, 2}}, {{{"S", "aSb."}, 2}, {{
      "S", "aS.b"}, 1}}, {{{"S", "aSb."}, 1}, {{"G", "S."}, 1}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.813266161772655*^9, 
  3.813266214046472*^9},ExpressionUUID->"6ac5a4f6-2276-4cec-8ff6-\
bfc3402bd0a9"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Arithmetic", " ", "grammar"}], "*)"}]], "Input",
 CellChangeTimes->{{3.813266230441646*^9, 
  3.8132662375584183`*^9}},ExpressionUUID->"aa791875-8f52-47fb-99f0-\
6f28b49fe34c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "predictor", ",", "scanner", ",", "completer", ",", "stringText", ",", 
     "listA", ",", "i", ",", "grammar1", ",", "words", ",", "S1", ",", "k", 
     ",", "stateIndex", ",", "state", ",", "X", ",", "\[Alpha]", ",", 
     "\[Beta]", ",", "posDot", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"predictor", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"scanner", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"completer", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"predictor", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "grammar_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "package"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"65", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "90"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"i1", "=", "1"}], ",", 
          RowBox[{"i1", "\[LessEqual]", 
           RowBox[{"Length", "[", "grammar", "]"}]}], ",", 
          RowBox[{"i1", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"package", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], ",", 
                RowBox[{"\"\<.\>\"", "<>", 
                 RowBox[{"Part", "[", 
                  RowBox[{"grammar", ",", "i1", ",", "2"}], "]"}]}]}], "}"}], 
              ",", "k"}], "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], "\[Equal]", 
              " ", "B1"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", "k"}], "]"}], ",", " ", "package"}], 
                 "]"}], "\[Equal]", "False"}], ",", 
               RowBox[{"AppendTo", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}]}], 
              "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"scanner", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "word_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A1", ",", "B1", ",", "j1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "alpha", ",", "beta", ",", "a", ",", 
         "package"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"j1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"97", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "122"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"alpha", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"beta", "=", 
            RowBox[{"StringTake", "[", 
             RowBox[{"B1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"positionDot", "+", "2"}], ",", 
                RowBox[{"StringLength", "[", "B1", "]"}]}], "}"}]}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", 
          RowBox[{"beta", "=", "\"\<\>\""}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"k", "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "word", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"word", ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "k"}], "}"}]}], "]"}], "\[Equal]", " ", 
             "a"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"package", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"A1", ",", 
                  RowBox[{
                  "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                 "}"}], ",", "j1"}], "}"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", 
                    RowBox[{"k", "+", "1"}]}], "]"}], ",", "package"}], "]"}],
                 "\[Equal]", "False"}], ",", 
               RowBox[{"AppendTo", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"S2", ",", 
                   RowBox[{"k", "+", "1"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"A1", ",", 
                    RowBox[{
                    "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                    "}"}], ",", "j1"}], "}"}]}], "]"}]}], "]"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"completer", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B", ",", "\[Gamma]", ",", 
         RowBox[{"S2", "=", "S"}], ",", "x", ",", "m", ",", "A", ",", "alpha",
          ",", "B1", ",", "beta", ",", "positionDot", ",", "j1", ",", 
         "segment", ",", "package"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Gamma]", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
              "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x"}], "]"}], "]"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"A", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "1"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"segment", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "2"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"positionDot", "=", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{"StringPosition", "[", 
               RowBox[{"segment", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", 
              "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"j1", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "2"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"alpha", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"positionDot", "\[GreaterEqual]", "1"}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"beta", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "2"}], ",", 
                  RowBox[{"StringLength", "[", "segment", "]"}]}], "}"}]}], 
               "]"}], ",", "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"B1", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "1"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "1"}], ",", 
                  RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"B1", "\[Equal]", "B"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"package", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"A", ",", 
                   RowBox[{
                   "alpha", "<>", "B", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                  "}"}], ",", "j1"}], "}"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}], 
                 "\[Equal]", "False"}], ",", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}]}],
                "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"stringText", "=", 
     RowBox[{
     "Import", "[", 
      "\"\<Documents/PersonalFolder/CompilerDesign/grammarText7.txt\>\"", 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"listA", "=", 
     RowBox[{"TextWords", "[", "stringText", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"grammar1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{
          RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", 
       RowBox[{
        RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"grammar1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", "*", "i"}], "-", "1"}], "]"}], "]"}], ",", 
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{"2", "*", "i"}], "]"}], "]"}]}], "}"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Grammar \>\"", ",", "grammar1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"words", "=", "\"\<s\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"S1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"S1", ",", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"grammar1", ",", "1", ",", "1"}], "]"}], ",", 
          RowBox[{"\"\<.\>\"", "<>", 
           RowBox[{"Part", "[", 
            RowBox[{"grammar1", ",", "1", ",", "2"}], "]"}]}]}], "}"}], ",", 
        "1"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Initial state of the chart \>\"", ",", "S1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k", "=", "1"}], ",", 
      RowBox[{"k", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], ",", 
      RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Marker position->\>\"", ",", "k"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"stateIndex", "=", "1"}], ",", 
         RowBox[{"stateIndex", "\[LessEqual]", " ", 
          RowBox[{"Length", "[", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k"}], "]"}], "]"}]}], ",", 
         RowBox[{"stateIndex", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"state", "=", " ", 
           RowBox[{"Part", "[", 
            RowBox[{"S1", ",", "k", ",", "stateIndex"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Current state being shown \>\"", ",", "state"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"X", "=", 
           RowBox[{"Part", "[", 
            RowBox[{"state", ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"posDot", "=", 
           RowBox[{"Part", "[", 
            RowBox[{
             RowBox[{"StringPosition", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"posDot", "\[GreaterEqual]", "1"}], ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"posDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
             "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Beta]", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"posDot", "+", "1"}], "\[LessEqual]", 
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], " ", 
             ",", 
             RowBox[{"StringTake", "[", 
              RowBox[{
               RowBox[{"Part", "[", 
                RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"posDot", "+", "1"}], ",", 
                 RowBox[{"StringLength", "[", 
                  RowBox[{"Part", "[", 
                   RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], 
                "}"}]}], "]"}], ",", "\"\<\>\""}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"StringLength", "[", "\[Beta]", "]"}], "\[NotEqual]", 
             " ", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"65", "\[LessEqual]", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"StringTake", "[", 
                   RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                 "1"}], "]"}], "\[LessEqual]", "90"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"predictor", "[", 
               RowBox[{"S1", ",", "state", ",", "k", ",", "grammar1"}], "]"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"If", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"97", "\[LessEqual]", 
                 RowBox[{"Part", "[", 
                  RowBox[{
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                   "1"}], "]"}], "\[LessEqual]", "122"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"scanner", "[", 
                 RowBox[{"S1", ",", "state", ",", "k", ",", "words"}], 
                 "]"}]}], "\[IndentingNewLine]", "]"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"completer", "[", 
             RowBox[{"S1", ",", "state", ",", "k"}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Final state of the chart \>\"", ",", "S1"}], "]"}], ";"}]}],
   "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.813161245596055*^9, 3.813161283995738*^9}, {
   3.8131614108111897`*^9, 3.81316141142057*^9}, {3.8131727720029783`*^9, 
   3.813172811604389*^9}, {3.813172868443242*^9, 3.813172944393732*^9}, {
   3.8131733896993437`*^9, 3.813173408588579*^9}, {3.813173473151021*^9, 
   3.813173498136088*^9}, {3.813173591726737*^9, 3.813173642955079*^9}, {
   3.8131737779944468`*^9, 3.8131737907875977`*^9}, {3.813174281222889*^9, 
   3.81317428138955*^9}, {3.813174425237109*^9, 3.813174427323574*^9}, {
   3.813174503688929*^9, 3.813174532703866*^9}, {3.81317457930345*^9, 
   3.8131746849059277`*^9}, {3.813174982859693*^9, 3.8131750266581793`*^9}, {
   3.813175062210472*^9, 3.813175085633336*^9}, {3.813175357351801*^9, 
   3.8131754144495363`*^9}, {3.813175471580306*^9, 3.8131757099403763`*^9}, {
   3.8131758292617903`*^9, 3.813175849272442*^9}, {3.8131759094869423`*^9, 
   3.8131759661182737`*^9}, {3.81317601287498*^9, 3.8131760833924007`*^9}, {
   3.8131762343661137`*^9, 3.81317623749228*^9}, {3.813176325116693*^9, 
   3.81317635727957*^9}, {3.8131763928944473`*^9, 3.813176674685019*^9}, {
   3.813176706687907*^9, 3.813176706832335*^9}, {3.813177024854231*^9, 
   3.813177036369254*^9}, {3.81317710299669*^9, 3.813177138257018*^9}, {
   3.8131772744534492`*^9, 3.8131773794586782`*^9}, {3.8131774326867733`*^9, 
   3.813177439336265*^9}, {3.813177494071083*^9, 3.8131775011076393`*^9}, {
   3.813177536175335*^9, 3.813177626567748*^9}, {3.8131776581098948`*^9, 
   3.813177671760893*^9}, {3.813177715743679*^9, 3.8131777480662727`*^9}, {
   3.813177839446171*^9, 3.8131778404513073`*^9}, {3.813178623180558*^9, 
   3.813178651923747*^9}, {3.8131787037998657`*^9, 3.813178726178495*^9}, {
   3.8131802719448347`*^9, 3.813180306908958*^9}, {3.813181114246807*^9, 
   3.813181134152676*^9}, {3.813183444345271*^9, 3.813183481223318*^9}, {
   3.813187210866098*^9, 3.8131872156619368`*^9}, {3.813193154820719*^9, 
   3.813193209006421*^9}, {3.8131943051505737`*^9, 3.813194305335478*^9}, 
   3.813195159761876*^9, {3.8131953247621527`*^9, 3.813195327741701*^9}, {
   3.8132322191125298`*^9, 3.81323225425135*^9}, {3.813237878090254*^9, 
   3.813237896556643*^9}, {3.813237955748393*^9, 3.81323796629196*^9}, {
   3.813238152763774*^9, 3.813238167464299*^9}, 3.8132381979527273`*^9, {
   3.813238441416862*^9, 3.81323845381925*^9}, {3.8132391145425863`*^9, 
   3.813239115419861*^9}, {3.8132391694365273`*^9, 3.8132391695694103`*^9}, {
   3.813239212382637*^9, 3.813239225241722*^9}, {3.8132396433088903`*^9, 
   3.8132398893350363`*^9}, {3.8132400756198053`*^9, 
   3.8132400856278467`*^9}, {3.813240147534068*^9, 3.813240165708768*^9}, {
   3.813240207742229*^9, 3.8132402085786133`*^9}, {3.813240440654212*^9, 
   3.813240506863839*^9}, {3.813240606819686*^9, 3.813240671903029*^9}, {
   3.813241033014455*^9, 3.813241064551553*^9}, {3.813242251017076*^9, 
   3.813242370857518*^9}, {3.813242409937428*^9, 3.813242498723736*^9}, {
   3.813242644016122*^9, 3.8132426507683067`*^9}, {3.8132428077334433`*^9, 
   3.813242811030261*^9}, {3.813242841188005*^9, 3.813242842111992*^9}, {
   3.813242969954438*^9, 3.8132429789417686`*^9}, {3.813243313201125*^9, 
   3.813243339536343*^9}, {3.813243406721182*^9, 3.813243406898899*^9}, {
   3.813244519354875*^9, 3.813244524245944*^9}, {3.81324467393931*^9, 
   3.813244692116789*^9}, {3.81324473432485*^9, 3.8132447619867887`*^9}, {
   3.813244936572015*^9, 3.813245061070053*^9}, {3.813245141820406*^9, 
   3.813245188657597*^9}, {3.813245230869544*^9, 3.813245306684093*^9}, {
   3.8132454443374434`*^9, 3.8132454706059437`*^9}, {3.813250323980433*^9, 
   3.813250332943001*^9}, {3.8132503743608*^9, 3.813250376813595*^9}, {
   3.813250486130128*^9, 3.813250499993581*^9}, {3.813250737621107*^9, 
   3.81325079329801*^9}, {3.81325089085716*^9, 3.813250900048204*^9}, {
   3.813251035510748*^9, 3.813251045767146*^9}, {3.813258591573715*^9, 
   3.813258598325177*^9}, {3.813258683881515*^9, 3.81325868855548*^9}, {
   3.8132589445509863`*^9, 3.81325907026884*^9}, {3.8132591448732023`*^9, 
   3.8132592360350237`*^9}, {3.813259515686029*^9, 3.813259524912566*^9}, {
   3.813259556774037*^9, 3.8132596753396177`*^9}, {3.813259889053245*^9, 
   3.8132599151207542`*^9}, {3.813259974342279*^9, 3.81326004737698*^9}, {
   3.8132600781890697`*^9, 3.813260118734866*^9}, {3.81326017828784*^9, 
   3.8132601807436438`*^9}, {3.813260281375361*^9, 3.813260289976831*^9}, {
   3.813260569781275*^9, 3.8132606573605747`*^9}, {3.8132608611048822`*^9, 
   3.81326089995408*^9}, {3.813260972744894*^9, 3.8132609815070877`*^9}, {
   3.813261052002496*^9, 3.813261074069181*^9}, {3.813261320499062*^9, 
   3.8132613653347483`*^9}, {3.81326141432848*^9, 3.8132614337057457`*^9}, {
   3.8132614958885*^9, 3.813261540130618*^9}, 3.813261696310176*^9, {
   3.813261795481683*^9, 3.813261861822803*^9}, {3.813261894198691*^9, 
   3.813262017256701*^9}, {3.813262198800187*^9, 3.813262551613288*^9}, {
   3.8132627957956877`*^9, 3.813262931997551*^9}, {3.813263056692666*^9, 
   3.813263075529436*^9}, {3.8132632376434937`*^9, 3.813263309071774*^9}, {
   3.813263346456777*^9, 3.8132633989110823`*^9}, {3.8132646980873013`*^9, 
   3.813264704034678*^9}, {3.813264770330132*^9, 3.813264771652808*^9}, {
   3.813264906571568*^9, 3.813264907515176*^9}, {3.813265264033187*^9, 
   3.8132653720442963`*^9}, {3.8132654322292843`*^9, 3.813265443082346*^9}, {
   3.813265630055305*^9, 3.81326565278187*^9}, {3.8132657367844877`*^9, 
   3.813265770500132*^9}, {3.8132658937669907`*^9, 3.8132659350039787`*^9}, {
   3.813265966455318*^9, 3.813266152154606*^9}, {3.813266209970484*^9, 
   3.813266212628346*^9}, {3.81326632600928*^9, 3.8132663347068357`*^9}, {
   3.813266370186675*^9, 3.813266370503096*^9}, {3.813266776030047*^9, 
   3.8132667767894506`*^9}, {3.813267042261223*^9, 3.813267042683157*^9}, {
   3.813267178865963*^9, 
   3.813267221980547*^9}},ExpressionUUID->"25bf0452-7244-464b-aba2-\
633889f29eeb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Grammar \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"SpM\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"M\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M\"\>", ",", "\<\"MsT\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M\"\>", ",", "\<\"T\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"T\"\>", ",", "\<\"x\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Grammar ", {{"G", "S"}, {"S", "SpM"}, {"S", "M"}, {"M", "MsT"}, {
    "M", "T"}, {"T", "x"}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222481325*^9}},ExpressionUUID->"98740997-ddaf-4fed-9e25-\
c1355a6132cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}],
  SequenceForm["Initial state of the chart ", {{{{"G", ".S"}, 1}}, {}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222488562*^9}},ExpressionUUID->"ad367a3c-d5e5-4238-8f2f-\
396f909eef94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Marker position->", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222495451*^9}},ExpressionUUID->"342d52ce-1bcb-4ec1-b7ee-\
34e587afd121"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"G", ".S"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.8132672225005903`*^9}},ExpressionUUID->"198953f4-78ec-4cfe-bc89-\
1e423dbe24ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".SpM\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".SpM"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222505639*^9}},ExpressionUUID->"65e36fce-d174-4dfd-bd9d-\
3d5a2011d5a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\".M\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"S", ".M"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222510681*^9}},ExpressionUUID->"aa38df3c-c95b-4102-8603-\
d4a186294941"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"M\"\>", ",", "\<\".MsT\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"M", ".MsT"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222515826*^9}},ExpressionUUID->"4b4e8c87-516a-4014-b171-\
11f50b497dcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"M\"\>", ",", "\<\".T\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"M", ".T"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222521137*^9}},ExpressionUUID->"376d5b9d-cf21-4193-b69e-\
7bf67eca649c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Current state being shown \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"T\"\>", ",", "\<\".x\"\>"}], "}"}], ",", "1"}], "}"}]}],
  SequenceForm["Current state being shown ", {{"T", ".x"}, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.8132672225261173`*^9}},ExpressionUUID->"2bb64ad8-1aed-4395-b9db-\
32542cca6a6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Marker position->\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Marker position->", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.813267222531736*^9}},ExpressionUUID->"d222cec8-4136-415b-8ac7-\
eae039510fe5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Final state of the chart \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"G\"\>", ",", "\<\".S\"\>"}], "}"}], ",", "1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".SpM\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"S\"\>", ",", "\<\".M\"\>"}], "}"}], ",", "1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"M\"\>", ",", "\<\".MsT\"\>"}], "}"}], ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"M\"\>", ",", "\<\".T\"\>"}], "}"}], ",", "1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"T\"\>", ",", "\<\".x\"\>"}], "}"}], ",", "1"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}],
  SequenceForm[
  "Final state of the chart ", {{{{"G", ".S"}, 1}, {{"S", ".SpM"}, 1}, {{
      "S", ".M"}, 1}, {{"M", ".MsT"}, 1}, {{"M", ".T"}, 1}, {{"T", ".x"}, 
      1}}, {}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.81326633840879*^9, 3.813266477819661*^9, 3.8132667780722933`*^9, 
   3.81326704331783*^9, {3.813267212437976*^9, 
   3.8132672225369596`*^9}},ExpressionUUID->"7367e185-2686-404b-9fce-\
19207fe37443"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
     "Since", " ", "all", " ", "the", " ", "processes", " ", "seem", " ", 
      "to", " ", "somewhat", " ", "work"}], " ", "..."}], " ", "I", " ", 
    "can", " ", "now", " ", "work", " ", "into", " ", "printing", " ", "the", 
    " ", "actual", " ", "output"}], " ", "..."}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8132672375483847`*^9, 
  3.813267271031001*^9}},ExpressionUUID->"526c70de-e722-4231-a123-\
5da88034eda3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "predictor", ",", "scanner", ",", "completer", ",", "stringText", ",", 
     "listA", ",", "i", ",", "grammar1", ",", "words", ",", "S1", ",", "k", 
     ",", "stateIndex", ",", "state", ",", "X", ",", "\[Alpha]", ",", 
     "\[Beta]", ",", "posDot", ",", "S3", ",", "finop"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"predictor", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"scanner", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SetAttributes", "[", 
     RowBox[{"completer", ",", 
      RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"predictor", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "grammar_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "package"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"65", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "90"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"i1", "=", "1"}], ",", 
          RowBox[{"i1", "\[LessEqual]", 
           RowBox[{"Length", "[", "grammar", "]"}]}], ",", 
          RowBox[{"i1", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"package", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], ",", 
                RowBox[{"\"\<.\>\"", "<>", 
                 RowBox[{"Part", "[", 
                  RowBox[{"grammar", ",", "i1", ",", "2"}], "]"}]}]}], "}"}], 
              ",", "k"}], "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"grammar", ",", "i1", ",", "1"}], "]"}], "\[Equal]", 
              " ", "B1"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", "k"}], "]"}], ",", " ", "package"}], 
                 "]"}], "\[Equal]", "False"}], ",", 
               RowBox[{"AppendTo", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}]}], 
              "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"scanner", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_", ",", "word_"}], "]"}], ":=",
      "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A1", ",", "B1", ",", "j1", ",", "i1", ",", "positionDot", ",", 
         RowBox[{"S2", "=", "S"}], ",", "alpha", ",", "beta", ",", "a", ",", 
         "package"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"B1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"j1", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"positionDot", "=", 
         RowBox[{"Part", "[", 
          RowBox[{
           RowBox[{"StringPosition", "[", 
            RowBox[{"B1", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"positionDot", "\[Equal]", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"positionDot", "+", "1"}], ",", 
             RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"97", "\[LessEqual]", 
            RowBox[{"Part", "[", 
             RowBox[{"ToCharacterCode", "[", "B1", "]"}], "]"}], 
            "\[LessEqual]", "122"}], "]"}], ",", 
          RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"alpha", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{"B1", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "B1", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"beta", "=", 
            RowBox[{"StringTake", "[", 
             RowBox[{"B1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"positionDot", "+", "2"}], ",", 
                RowBox[{"StringLength", "[", "B1", "]"}]}], "}"}]}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", 
          RowBox[{"beta", "=", "\"\<\>\""}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"k", "\[LessEqual]", " ", 
           RowBox[{"StringLength", "[", "word", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringTake", "[", 
              RowBox[{"word", ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "k"}], "}"}]}], "]"}], "\[Equal]", " ", 
             "a"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"package", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"A1", ",", 
                  RowBox[{
                  "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                 "}"}], ",", "j1"}], "}"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", 
                    RowBox[{"k", "+", "1"}]}], "]"}], ",", "package"}], "]"}],
                 "\[Equal]", "False"}], ",", 
               RowBox[{"AppendTo", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"S2", ",", 
                   RowBox[{"k", "+", "1"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"A1", ",", 
                    RowBox[{
                    "alpha", "<>", "a", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                    "}"}], ",", "j1"}], "}"}]}], "]"}]}], "]"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"completer", "[", 
      RowBox[{"S_", ",", "stateItem_", ",", "k_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"B", ",", "\[Gamma]", ",", 
         RowBox[{"S2", "=", "S"}], ",", "x", ",", "m", ",", "A", ",", "alpha",
          ",", "B1", ",", "beta", ",", "positionDot", ",", "j1", ",", 
         "segment", ",", "package"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "1", ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Gamma]", "=", 
         RowBox[{"StringTake", "[", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{
              RowBox[{"StringLength", "[", 
               RowBox[{"Part", "[", 
                RowBox[{"stateItem", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
              "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x", "=", 
         RowBox[{"Part", "[", 
          RowBox[{"stateItem", ",", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "=", "1"}], ",", 
          RowBox[{"m", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x"}], "]"}], "]"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"A", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "1"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"segment", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "1", ",", "2"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"positionDot", "=", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{"StringPosition", "[", 
               RowBox[{"segment", ",", "\"\<.\>\""}], "]"}], ",", "1", ",", 
              "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"j1", "=", 
            RowBox[{"Part", "[", 
             RowBox[{"S2", ",", "x", ",", "m", ",", "2"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"alpha", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"positionDot", "\[GreaterEqual]", "1"}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"positionDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"beta", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "2"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "2"}], ",", 
                  RowBox[{"StringLength", "[", "segment", "]"}]}], "}"}]}], 
               "]"}], ",", "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"B1", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"positionDot", "+", "1"}], "\[LessEqual]", " ", 
               RowBox[{"StringLength", "[", "segment", "]"}]}], ",", 
              RowBox[{"StringTake", "[", 
               RowBox[{"segment", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"positionDot", "+", "1"}], ",", 
                  RowBox[{"positionDot", "+", "1"}]}], "}"}]}], "]"}], ",", 
              "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"B1", "\[Equal]", "B"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"package", "=", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"A", ",", 
                   RowBox[{
                   "alpha", "<>", "B", "<>", "\"\<.\>\"", "<>", "beta"}]}], 
                  "}"}], ",", "j1"}], "}"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}], 
                 "\[Equal]", "False"}], ",", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"S2", ",", "k"}], "]"}], ",", "package"}], "]"}]}],
                "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"S", "=", "S2"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"stringText", "=", 
     RowBox[{
     "Import", "[", 
      "\"\<Documents/PersonalFolder/CompilerDesign/grammarText7.txt\>\"", 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"listA", "=", 
     RowBox[{"TextWords", "[", "stringText", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"grammar1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{
          RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", 
       RowBox[{
        RowBox[{"Length", "[", "listA", "]"}], "/", "2"}]}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"grammar1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", "*", "i"}], "-", "1"}], "]"}], "]"}], ",", 
          RowBox[{"listA", "[", 
           RowBox[{"[", 
            RowBox[{"2", "*", "i"}], "]"}], "]"}]}], "}"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Grammar \>\"", ",", "grammar1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"words", "=", "\"\<s\>\""}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Input lex stream \>\"", ",", "words"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"S1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"S1", ",", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"grammar1", ",", "1", ",", "1"}], "]"}], ",", 
          RowBox[{"\"\<.\>\"", "<>", 
           RowBox[{"Part", "[", 
            RowBox[{"grammar1", ",", "1", ",", "2"}], "]"}]}]}], "}"}], ",", 
        "1"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"finop", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Part", "[", 
          RowBox[{"grammar1", ",", "1", ",", "1"}], "]"}], ",", 
         RowBox[{"\"\<.\>\"", "<>", 
          RowBox[{"Part", "[", 
           RowBox[{"grammar1", ",", "1", ",", "2"}], "]"}]}]}], "}"}], ",", 
       "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k", "=", "1"}], ",", 
      RowBox[{"k", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], ",", 
      RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{"For", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"stateIndex", "=", "1"}], ",", 
        RowBox[{"stateIndex", "\[LessEqual]", " ", 
         RowBox[{"Length", "[", 
          RowBox[{"Part", "[", 
           RowBox[{"S1", ",", "k"}], "]"}], "]"}]}], ",", 
        RowBox[{"stateIndex", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"state", "=", " ", 
          RowBox[{"Part", "[", 
           RowBox[{"S1", ",", "k", ",", "stateIndex"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"X", "=", 
          RowBox[{"Part", "[", 
           RowBox[{"state", ",", "1", ",", "1"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"posDot", "=", 
          RowBox[{"Part", "[", 
           RowBox[{
            RowBox[{"StringPosition", "[", 
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
              "\"\<.\>\""}], "]"}], ",", "1", ",", "1"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Alpha]", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"posDot", "\[GreaterEqual]", "1"}], ",", 
            RowBox[{"StringTake", "[", 
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"posDot", "-", "1"}]}], "}"}]}], "]"}], ",", 
            "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Beta]", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"posDot", "+", "1"}], "\[LessEqual]", 
             RowBox[{"StringLength", "[", 
              RowBox[{"Part", "[", 
               RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], " ", 
            ",", 
            RowBox[{"StringTake", "[", 
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"state", ",", "1", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"posDot", "+", "1"}], ",", 
                RowBox[{"StringLength", "[", 
                 RowBox[{"Part", "[", 
                  RowBox[{"state", ",", "1", ",", "2"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], ",", "\"\<\>\""}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"StringLength", "[", "\[Beta]", "]"}], "\[NotEqual]", " ",
             "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"65", "\[LessEqual]", 
              RowBox[{"Part", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"StringTake", "[", 
                  RowBox[{"\[Beta]", ",", 
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                "1"}], "]"}], "\[LessEqual]", "90"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"predictor", "[", 
              RowBox[{"S1", ",", "state", ",", "k", ",", "grammar1"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"97", "\[LessEqual]", 
                RowBox[{"Part", "[", 
                 RowBox[{
                  RowBox[{"ToCharacterCode", "[", 
                   RowBox[{"StringTake", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                  "1"}], "]"}], "\[LessEqual]", "122"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"scanner", "[", 
                RowBox[{"S1", ",", "state", ",", "k", ",", "words"}], "]"}]}],
               "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"completer", "[", 
            RowBox[{"S1", ",", "state", ",", "k"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"S1", ",", 
         RowBox[{
          RowBox[{"StringLength", "[", "words", "]"}], "+", "1"}]}], "]"}], 
       ",", "finop"}], "]"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.813161245596055*^9, 3.813161283995738*^9}, {
   3.8131614108111897`*^9, 3.81316141142057*^9}, {3.8131727720029783`*^9, 
   3.813172811604389*^9}, {3.813172868443242*^9, 3.813172944393732*^9}, {
   3.8131733896993437`*^9, 3.813173408588579*^9}, {3.813173473151021*^9, 
   3.813173498136088*^9}, {3.813173591726737*^9, 3.813173642955079*^9}, {
   3.8131737779944468`*^9, 3.8131737907875977`*^9}, {3.813174281222889*^9, 
   3.81317428138955*^9}, {3.813174425237109*^9, 3.813174427323574*^9}, {
   3.813174503688929*^9, 3.813174532703866*^9}, {3.81317457930345*^9, 
   3.8131746849059277`*^9}, {3.813174982859693*^9, 3.8131750266581793`*^9}, {
   3.813175062210472*^9, 3.813175085633336*^9}, {3.813175357351801*^9, 
   3.8131754144495363`*^9}, {3.813175471580306*^9, 3.8131757099403763`*^9}, {
   3.8131758292617903`*^9, 3.813175849272442*^9}, {3.8131759094869423`*^9, 
   3.8131759661182737`*^9}, {3.81317601287498*^9, 3.8131760833924007`*^9}, {
   3.8131762343661137`*^9, 3.81317623749228*^9}, {3.813176325116693*^9, 
   3.81317635727957*^9}, {3.8131763928944473`*^9, 3.813176674685019*^9}, {
   3.813176706687907*^9, 3.813176706832335*^9}, {3.813177024854231*^9, 
   3.813177036369254*^9}, {3.81317710299669*^9, 3.813177138257018*^9}, {
   3.8131772744534492`*^9, 3.8131773794586782`*^9}, {3.8131774326867733`*^9, 
   3.813177439336265*^9}, {3.813177494071083*^9, 3.8131775011076393`*^9}, {
   3.813177536175335*^9, 3.813177626567748*^9}, {3.8131776581098948`*^9, 
   3.813177671760893*^9}, {3.813177715743679*^9, 3.8131777480662727`*^9}, {
   3.813177839446171*^9, 3.8131778404513073`*^9}, {3.813178623180558*^9, 
   3.813178651923747*^9}, {3.8131787037998657`*^9, 3.813178726178495*^9}, {
   3.8131802719448347`*^9, 3.813180306908958*^9}, {3.813181114246807*^9, 
   3.813181134152676*^9}, {3.813183444345271*^9, 3.813183481223318*^9}, {
   3.813187210866098*^9, 3.8131872156619368`*^9}, {3.813193154820719*^9, 
   3.813193209006421*^9}, {3.8131943051505737`*^9, 3.813194305335478*^9}, 
   3.813195159761876*^9, {3.8131953247621527`*^9, 3.813195327741701*^9}, {
   3.8132322191125298`*^9, 3.81323225425135*^9}, {3.813237878090254*^9, 
   3.813237896556643*^9}, {3.813237955748393*^9, 3.81323796629196*^9}, {
   3.813238152763774*^9, 3.813238167464299*^9}, 3.8132381979527273`*^9, {
   3.813238441416862*^9, 3.81323845381925*^9}, {3.8132391145425863`*^9, 
   3.813239115419861*^9}, {3.8132391694365273`*^9, 3.8132391695694103`*^9}, {
   3.813239212382637*^9, 3.813239225241722*^9}, {3.8132396433088903`*^9, 
   3.8132398893350363`*^9}, {3.8132400756198053`*^9, 
   3.8132400856278467`*^9}, {3.813240147534068*^9, 3.813240165708768*^9}, {
   3.813240207742229*^9, 3.8132402085786133`*^9}, {3.813240440654212*^9, 
   3.813240506863839*^9}, {3.813240606819686*^9, 3.813240671903029*^9}, {
   3.813241033014455*^9, 3.813241064551553*^9}, {3.813242251017076*^9, 
   3.813242370857518*^9}, {3.813242409937428*^9, 3.813242498723736*^9}, {
   3.813242644016122*^9, 3.8132426507683067`*^9}, {3.8132428077334433`*^9, 
   3.813242811030261*^9}, {3.813242841188005*^9, 3.813242842111992*^9}, {
   3.813242969954438*^9, 3.8132429789417686`*^9}, {3.813243313201125*^9, 
   3.813243339536343*^9}, {3.813243406721182*^9, 3.813243406898899*^9}, {
   3.813244519354875*^9, 3.813244524245944*^9}, {3.81324467393931*^9, 
   3.813244692116789*^9}, {3.81324473432485*^9, 3.8132447619867887`*^9}, {
   3.813244936572015*^9, 3.813245061070053*^9}, {3.813245141820406*^9, 
   3.813245188657597*^9}, {3.813245230869544*^9, 3.813245306684093*^9}, {
   3.8132454443374434`*^9, 3.8132454706059437`*^9}, {3.813250323980433*^9, 
   3.813250332943001*^9}, {3.8132503743608*^9, 3.813250376813595*^9}, {
   3.813250486130128*^9, 3.813250499993581*^9}, {3.813250737621107*^9, 
   3.81325079329801*^9}, {3.81325089085716*^9, 3.813250900048204*^9}, {
   3.813251035510748*^9, 3.813251045767146*^9}, {3.813258591573715*^9, 
   3.813258598325177*^9}, {3.813258683881515*^9, 3.81325868855548*^9}, {
   3.8132589445509863`*^9, 3.81325907026884*^9}, {3.8132591448732023`*^9, 
   3.8132592360350237`*^9}, {3.813259515686029*^9, 3.813259524912566*^9}, {
   3.813259556774037*^9, 3.8132596753396177`*^9}, {3.813259889053245*^9, 
   3.8132599151207542`*^9}, {3.813259974342279*^9, 3.81326004737698*^9}, {
   3.8132600781890697`*^9, 3.813260118734866*^9}, {3.81326017828784*^9, 
   3.8132601807436438`*^9}, {3.813260281375361*^9, 3.813260289976831*^9}, {
   3.813260569781275*^9, 3.8132606573605747`*^9}, {3.8132608611048822`*^9, 
   3.81326089995408*^9}, {3.813260972744894*^9, 3.8132609815070877`*^9}, {
   3.813261052002496*^9, 3.813261074069181*^9}, {3.813261320499062*^9, 
   3.8132613653347483`*^9}, {3.81326141432848*^9, 3.8132614337057457`*^9}, {
   3.8132614958885*^9, 3.813261540130618*^9}, 3.813261696310176*^9, {
   3.813261795481683*^9, 3.813261861822803*^9}, {3.813261894198691*^9, 
   3.813262017256701*^9}, {3.813262198800187*^9, 3.813262551613288*^9}, {
   3.8132627957956877`*^9, 3.813262931997551*^9}, {3.813263056692666*^9, 
   3.813263075529436*^9}, {3.8132632376434937`*^9, 3.813263309071774*^9}, {
   3.813263346456777*^9, 3.8132633989110823`*^9}, {3.8132646980873013`*^9, 
   3.813264704034678*^9}, {3.813264770330132*^9, 3.813264771652808*^9}, {
   3.813264906571568*^9, 3.813264907515176*^9}, {3.813265264033187*^9, 
   3.8132653720442963`*^9}, {3.8132654322292843`*^9, 3.813265443082346*^9}, {
   3.813265630055305*^9, 3.81326565278187*^9}, {3.8132657367844877`*^9, 
   3.813265770500132*^9}, {3.8132658937669907`*^9, 3.8132659350039787`*^9}, {
   3.813265966455318*^9, 3.813266152154606*^9}, {3.813266209970484*^9, 
   3.813266212628346*^9}, {3.81326632600928*^9, 3.8132663347068357`*^9}, {
   3.813266370186675*^9, 3.813266370503096*^9}, {3.813266776030047*^9, 
   3.8132667767894506`*^9}, {3.813267042261223*^9, 3.813267042683157*^9}, {
   3.813267178865963*^9, 3.813267221980547*^9}, {3.8132672879905567`*^9, 
   3.813267314510147*^9}, {3.813267345455331*^9, 3.813267445883252*^9}, {
   3.8132674857700167`*^9, 3.813267490702168*^9}, {3.813267531295191*^9, 
   3.813267591546666*^9}, {3.813267686023106*^9, 
   3.813267717454913*^9}},ExpressionUUID->"64477f3e-d888-4e4a-b449-\
823421e80f29"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Grammar \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"S\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"SpM\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"M\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M\"\>", ",", "\<\"MsT\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M\"\>", ",", "\<\"T\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"T\"\>", ",", "\<\"x\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Grammar ", {{"G", "S"}, {"S", "SpM"}, {"S", "M"}, {"M", "MsT"}, {
    "M", "T"}, {"T", "x"}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813267451777975*^9, 3.813267493454376*^9, 3.8132675480888357`*^9, {
   3.813267578882139*^9, 3.813267592648157*^9}, 
   3.813267718594307*^9},ExpressionUUID->"746a5cba-bfd0-4aee-910f-\
1cc614ae7e1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input lex stream \"\>", "\[InvisibleSpace]", "\<\"s\"\>"}],
  SequenceForm["Input lex stream ", "s"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.813267451777975*^9, 3.813267493454376*^9, 3.8132675480888357`*^9, {
   3.813267578882139*^9, 3.813267592648157*^9}, 
   3.813267718602137*^9},ExpressionUUID->"277f6bab-f967-4253-9323-\
fea226998845"],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{
  3.813267451777975*^9, 3.813267493454376*^9, 3.8132675480888357`*^9, {
   3.813267578882139*^9, 3.813267592648157*^9}, 
   3.8132677186089287`*^9},ExpressionUUID->"d91b647c-b8d1-418a-bc3a-\
4ed8c47f6259"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 616},
WindowMargins->{{172, Automatic}, {Automatic, 50}},
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"ReverseColor.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 25760, 558, 2194, "Input",ExpressionUUID->"c424a6bd-9c04-4f00-b295-0ac719b8a982"],
Cell[CellGroupData[{
Cell[26365, 584, 585, 15, 24, "Print",ExpressionUUID->"734732aa-96e0-43a0-8cf0-250d6d2a1958"],
Cell[26953, 601, 683, 20, 24, "Print",ExpressionUUID->"73db450d-e3d2-464f-bf2b-73adeb565af1"],
Cell[27639, 623, 296, 7, 24, "Print",ExpressionUUID->"03cd9e31-87ee-441e-a50a-972ea22a4a28"],
Cell[27938, 632, 448, 11, 24, "Print",ExpressionUUID->"136c5d3e-cd65-4983-9de1-87055a49667c"],
Cell[28389, 645, 449, 10, 24, "Print",ExpressionUUID->"fbe2faed-438c-450c-a500-348c54862680"],
Cell[28841, 657, 452, 11, 24, "Print",ExpressionUUID->"c0a92673-2d85-4d83-895d-1123de2bf53c"],
Cell[29296, 670, 296, 7, 24, "Print",ExpressionUUID->"243223f4-fe4b-44cd-b7fb-1ee75a180769"],
Cell[29595, 679, 452, 11, 24, "Print",ExpressionUUID->"26b9186e-c642-4063-8a6d-bd7c56f38699"],
Cell[30050, 692, 452, 11, 24, "Print",ExpressionUUID->"c9797515-4b3b-4225-abc6-8a1bc5a37a47"],
Cell[30505, 705, 452, 11, 24, "Print",ExpressionUUID->"1c8df121-4d76-4053-9602-dbffd620c3ac"],
Cell[30960, 718, 452, 11, 24, "Print",ExpressionUUID->"c37b2ebe-50db-437b-993f-27120cde9f74"],
Cell[31415, 731, 296, 7, 24, "Print",ExpressionUUID->"0c75e53a-2887-4cd8-b1aa-1e59c46f4da9"],
Cell[31714, 740, 454, 11, 24, "Print",ExpressionUUID->"45c3fffa-f487-4ea2-ae93-a7e771a619ca"],
Cell[32171, 753, 452, 11, 24, "Print",ExpressionUUID->"6a164fbc-ef9b-4962-9d19-053fcf3de1b7"],
Cell[32626, 766, 452, 11, 24, "Print",ExpressionUUID->"e8b85067-c696-49d1-9105-7bf7c77d6997"],
Cell[33081, 779, 450, 11, 24, "Print",ExpressionUUID->"da9b0f17-dc63-4fa4-ab91-e0cf26c582c0"],
Cell[33534, 792, 293, 6, 24, "Print",ExpressionUUID->"26e6eb07-2f48-4e9d-9989-9c9cc1de4119"],
Cell[33830, 800, 450, 11, 24, "Print",ExpressionUUID->"feb16bfa-956a-4c89-add8-887943cddb8f"],
Cell[34283, 813, 452, 11, 24, "Print",ExpressionUUID->"1c255217-b2b8-40cd-b8ac-29fdfab88e51"],
Cell[34738, 826, 292, 6, 24, "Print",ExpressionUUID->"10192fff-b024-47e6-b14d-160e13a1e899"],
Cell[35033, 834, 454, 11, 24, "Print",ExpressionUUID->"be18b26d-f10c-4fb8-9324-041a31a61073"],
Cell[35490, 847, 448, 11, 24, "Print",ExpressionUUID->"f0ccff26-2142-4470-9052-b00367774f2a"],
Cell[35941, 860, 3212, 99, 44, "Print",ExpressionUUID->"c79a5829-74a9-4a6d-bcac-882ae0221738"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39202, 965, 25812, 559, 2194, "Input",ExpressionUUID->"9a743a0a-ebfe-4fa0-87f3-8dabf59fe184"],
Cell[CellGroupData[{
Cell[65039, 1528, 561, 15, 24, "Print",ExpressionUUID->"e45e43db-f867-4716-92ad-220f14cee7cb"],
Cell[65603, 1545, 727, 22, 24, "Print",ExpressionUUID->"8a97848d-ee20-4961-89b9-fbf7ffd363da"],
Cell[66333, 1569, 272, 7, 24, "Print",ExpressionUUID->"f4fdb8c0-b7d7-4040-8f4e-77a66f9d4da9"],
Cell[66608, 1578, 424, 11, 24, "Print",ExpressionUUID->"f40cbfba-2095-4445-b8cc-28374144deb4"],
Cell[67035, 1591, 430, 11, 24, "Print",ExpressionUUID->"0c56693a-3eb9-479f-ab0e-e709ef969e63"],
Cell[67468, 1604, 423, 10, 24, "Print",ExpressionUUID->"6be35a2f-d232-4362-8e45-2c6e811da328"],
Cell[67894, 1616, 272, 7, 24, "Print",ExpressionUUID->"89fcfa9d-9394-432e-adc9-a88073607b9e"],
Cell[68169, 1625, 428, 11, 24, "Print",ExpressionUUID->"e2c3c6f8-c24e-4332-95c5-267f0690f379"],
Cell[68600, 1638, 426, 11, 24, "Print",ExpressionUUID->"f3f89e07-084c-4481-9774-5340703d8747"],
Cell[69029, 1651, 428, 11, 24, "Print",ExpressionUUID->"45c6ca2d-e4da-43ef-929c-ce4a7716b3d2"],
Cell[69460, 1664, 426, 11, 24, "Print",ExpressionUUID->"3a45a479-8a1f-4b55-bff3-c43a34b8c4e2"],
Cell[69889, 1677, 272, 7, 24, "Print",ExpressionUUID->"68c5745d-0738-4845-a301-9edfb9139d94"],
Cell[70164, 1686, 430, 11, 24, "Print",ExpressionUUID->"a4fdc0cf-4ef3-4175-865b-39146321c306"],
Cell[70597, 1699, 426, 11, 24, "Print",ExpressionUUID->"ea48e32f-518d-44fd-907a-baf80996de15"],
Cell[71026, 1712, 428, 11, 24, "Print",ExpressionUUID->"8aa60ce2-d3dc-4bfc-9691-af134222e384"],
Cell[71457, 1725, 428, 11, 24, "Print",ExpressionUUID->"450531c3-6f4b-4f4a-8c10-00faa067565f"],
Cell[71888, 1738, 272, 7, 24, "Print",ExpressionUUID->"23e181c5-074a-4eff-854f-b6ca5fb3c8c8"],
Cell[72163, 1747, 428, 11, 24, "Print",ExpressionUUID->"148e212a-763c-4522-b5ae-03a4754ce775"],
Cell[72594, 1760, 426, 11, 24, "Print",ExpressionUUID->"f0593df7-d709-4270-a962-313b299e3163"],
Cell[73023, 1773, 428, 11, 24, "Print",ExpressionUUID->"c8e6da14-6e11-4ab4-97ab-f2dc55537bae"],
Cell[73454, 1786, 426, 11, 24, "Print",ExpressionUUID->"92c88ba9-4033-42a9-90b6-5b8e7ccb574b"],
Cell[73883, 1799, 272, 7, 24, "Print",ExpressionUUID->"1e6f12a8-d2d3-4d0d-a210-4e0a1b673409"],
Cell[74158, 1808, 426, 11, 24, "Print",ExpressionUUID->"20fcfb3f-dc41-4162-b6f8-83630f87e338"],
Cell[74587, 1821, 428, 11, 24, "Print",ExpressionUUID->"9c28b189-499d-4d6c-b394-f93d04660728"],
Cell[75018, 1834, 272, 7, 24, "Print",ExpressionUUID->"094f0e12-0ef9-44b0-a795-44cc31fbb48c"],
Cell[75293, 1843, 428, 11, 24, "Print",ExpressionUUID->"ecea5b70-fb74-463f-a79e-418a8dbc3bf8"],
Cell[75724, 1856, 430, 11, 24, "Print",ExpressionUUID->"92bf8da8-4a70-421b-b740-4dc69dcf2e46"],
Cell[76157, 1869, 269, 6, 24, "Print",ExpressionUUID->"b55f5cc1-fc40-44f9-af9b-b500fa4b043d"],
Cell[76429, 1877, 428, 11, 24, "Print",ExpressionUUID->"433bb101-17dd-4730-8a9c-f3ce306b73e1"],
Cell[76860, 1890, 424, 11, 24, "Print",ExpressionUUID->"44f0b389-e384-4785-b497-68b01ead2d14"],
Cell[77287, 1903, 4343, 135, 63, "Print",ExpressionUUID->"dbaf8e9c-7aa9-46c2-9fe2-a906b9bf3256"]
}, Open  ]]
}, Open  ]],
Cell[81657, 2042, 292, 7, 30, "Input",ExpressionUUID->"0f2f4392-93b5-4e8a-9f86-c59cb5d7e914"],
Cell[CellGroupData[{
Cell[81974, 2053, 280, 7, 30, "Input",ExpressionUUID->"5f8916cd-2e38-4275-9ebc-f087887b19cf"],
Cell[82257, 2062, 131, 2, 34, "Output",ExpressionUUID->"ea6bc154-c69e-4604-aad9-f9eed82dfb12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82425, 2069, 283, 8, 30, "Input",ExpressionUUID->"eeb3a58f-336e-4174-a86d-62b211ab6876"],
Cell[82711, 2079, 130, 2, 34, "Output",ExpressionUUID->"b6f422a8-7b5d-4438-ba32-1eff94aab790"]
}, Open  ]],
Cell[82856, 2084, 389, 9, 30, "Input",ExpressionUUID->"22573732-3e90-4b98-8825-35d97fe54f6b"],
Cell[CellGroupData[{
Cell[83270, 2097, 27707, 599, 2257, "Input",ExpressionUUID->"d5321d68-4291-4891-9a9c-d63685316c8d"],
Cell[CellGroupData[{
Cell[111002, 2700, 583, 15, 24, "Print",ExpressionUUID->"a5abe1a5-a1af-4d01-92ad-9740b5a5b3b8"],
Cell[111588, 2717, 749, 22, 24, "Print",ExpressionUUID->"d47f2ec8-f838-4d4a-b143-b91034d32b36"],
Cell[112340, 2741, 294, 7, 24, "Print",ExpressionUUID->"67073172-b2ca-410c-8f79-759cbb954664"],
Cell[112637, 2750, 446, 11, 24, "Print",ExpressionUUID->"3fc5cf3c-c362-4e11-8ab7-587d616e95ba"],
Cell[113086, 2763, 450, 11, 24, "Print",ExpressionUUID->"787f8f09-81ea-46b9-be46-7969e576dc37"],
Cell[113539, 2776, 448, 11, 24, "Print",ExpressionUUID->"858ad611-d7ba-4a75-8f09-0f88c4d577ac"],
Cell[113990, 2789, 296, 7, 24, "Print",ExpressionUUID->"8f9d9c11-df51-4f40-891b-37de8f0dafc1"],
Cell[114289, 2798, 452, 11, 24, "Print",ExpressionUUID->"4fb4cb96-7bff-476b-ae5e-ce5f9b764c19"],
Cell[114744, 2811, 448, 11, 24, "Print",ExpressionUUID->"300c696d-8d06-4504-85db-4f7d0c23ea14"],
Cell[115195, 2824, 450, 11, 24, "Print",ExpressionUUID->"e839f925-d6ad-4ce5-9259-fbd0176dd88d"],
Cell[115648, 2837, 450, 11, 24, "Print",ExpressionUUID->"6a43585a-fc29-4bc5-9044-4abe3ce61bb5"],
Cell[116101, 2850, 291, 6, 24, "Print",ExpressionUUID->"b1fbf5cc-cbfc-421f-b690-634ff21fbdec"],
Cell[116395, 2858, 450, 11, 24, "Print",ExpressionUUID->"8bd73b14-9b53-4f45-9364-29c322334071"],
Cell[116848, 2871, 448, 11, 24, "Print",ExpressionUUID->"312e7a62-0e67-49a7-a5c2-69b9e08b7227"],
Cell[117299, 2884, 452, 11, 24, "Print",ExpressionUUID->"4e818b76-813b-4c61-8bbe-e5f1500baea8"],
Cell[117754, 2897, 450, 11, 24, "Print",ExpressionUUID->"155f0982-8392-4b1e-a93c-2e90368eaacf"],
Cell[118207, 2910, 294, 7, 24, "Print",ExpressionUUID->"12d73b08-3764-4e9d-8ca8-5f9a8cd2b6b8"],
Cell[118504, 2919, 450, 11, 24, "Print",ExpressionUUID->"89c9c70d-7f05-4d2b-b897-c3a98ccc1d10"],
Cell[118957, 2932, 448, 11, 24, "Print",ExpressionUUID->"56fd9470-2ec2-4ba9-a265-1c449a610697"],
Cell[119408, 2945, 452, 11, 24, "Print",ExpressionUUID->"565641a7-578e-42b0-9a0e-7edf6f5c167b"],
Cell[119863, 2958, 448, 11, 24, "Print",ExpressionUUID->"b404dfb9-9ca6-4ad1-9bdb-e8f2074ca375"],
Cell[120314, 2971, 294, 7, 24, "Print",ExpressionUUID->"dd2578c7-1ed5-4f79-95af-d66e695f7992"],
Cell[120611, 2980, 448, 11, 24, "Print",ExpressionUUID->"6b67994e-b5d8-43bd-9f16-0e19f4316428"],
Cell[121062, 2993, 452, 11, 24, "Print",ExpressionUUID->"adec3858-6f93-4934-b9ea-524d504a953b"],
Cell[121517, 3006, 294, 7, 24, "Print",ExpressionUUID->"58963d0d-6954-4e60-825a-a26a469b4806"],
Cell[121814, 3015, 447, 10, 24, "Print",ExpressionUUID->"a20e9181-1322-48b6-bb91-daa835362e65"],
Cell[122264, 3027, 450, 11, 24, "Print",ExpressionUUID->"7bddbbd4-ea62-4fe4-92f6-2e41d4b33b3c"],
Cell[122717, 3040, 294, 7, 24, "Print",ExpressionUUID->"11756fcf-5a60-49ca-805f-2fd9bb1676ca"],
Cell[123014, 3049, 450, 11, 24, "Print",ExpressionUUID->"b93da798-4bb7-4578-85f0-c92162e95a71"],
Cell[123467, 3062, 446, 11, 24, "Print",ExpressionUUID->"7d8febd5-ce3d-4d55-a6d0-0f7142eb8bdc"],
Cell[123916, 3075, 4365, 135, 63, "Print",ExpressionUUID->"6ac5a4f6-2276-4cec-8ff6-bfc3402bd0a9"]
}, Open  ]]
}, Open  ]],
Cell[128308, 3214, 217, 5, 30, "Input",ExpressionUUID->"aa791875-8f52-47fb-99f0-6f28b49fe34c"],
Cell[CellGroupData[{
Cell[128550, 3223, 28257, 609, 2299, "Input",ExpressionUUID->"25bf0452-7244-464b-aba2-633889f29eeb"],
Cell[CellGroupData[{
Cell[156832, 3836, 964, 25, 24, "Print",ExpressionUUID->"98740997-ddaf-4fed-9e25-c1355a6132cc"],
Cell[157799, 3863, 669, 18, 24, "Print",ExpressionUUID->"ad367a3c-d5e5-4238-8f2f-396f909eef94"],
Cell[158471, 3883, 392, 9, 24, "Print",ExpressionUUID->"342d52ce-1bcb-4ec1-b7ee-34e587afd121"],
Cell[158866, 3894, 546, 13, 24, "Print",ExpressionUUID->"198953f4-78ec-4cfe-bc89-1e423dbe24ec"],
Cell[159415, 3909, 548, 13, 24, "Print",ExpressionUUID->"65e36fce-d174-4dfd-bd9d-3d5a2011d5a7"],
Cell[159966, 3924, 544, 13, 24, "Print",ExpressionUUID->"aa38df3c-c95b-4102-8603-d4a186294941"],
Cell[160513, 3939, 548, 13, 24, "Print",ExpressionUUID->"4b4e8c87-516a-4014-b171-11f50b497dcb"],
Cell[161064, 3954, 544, 13, 24, "Print",ExpressionUUID->"376d5b9d-cf21-4193-b69e-7bf67eca649c"],
Cell[161611, 3969, 546, 13, 24, "Print",ExpressionUUID->"2bb64ad8-1aed-4395-b9db-32542cca6a6f"],
Cell[162160, 3984, 392, 9, 24, "Print",ExpressionUUID->"d222cec8-4136-415b-8ac7-eae039510fe5"],
Cell[162555, 3995, 1572, 47, 24, "Print",ExpressionUUID->"7367e185-2686-404b-9fce-19207fe37443"]
}, Open  ]]
}, Open  ]],
Cell[164154, 4046, 508, 12, 52, "Input",ExpressionUUID->"526c70de-e722-4231-a123-5da88034eda3"],
Cell[CellGroupData[{
Cell[164687, 4062, 28672, 623, 2362, "Input",ExpressionUUID->"64477f3e-d888-4e4a-b449-823421e80f29"],
Cell[CellGroupData[{
Cell[193384, 4689, 966, 25, 24, "Print",ExpressionUUID->"746a5cba-bfd0-4aee-910f-1cc614ae7e1b"],
Cell[194353, 4716, 404, 9, 24, "Print",ExpressionUUID->"277f6bab-f967-4253-9323-fea226998845"],
Cell[194760, 4727, 257, 5, 24, "Print",ExpressionUUID->"d91b647c-b8d1-418a-bc3a-4ed8c47f6259"]
}, Open  ]]
}, Open  ]]
}
]
*)

