(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='WolframDesktop 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       161,          7]
NotebookDataLength[   2913705,      46997]
NotebookOptionsPosition[   2907270,      46910]
NotebookOutlinePosition[   2907662,      46926]
CellTagsIndexPosition[   2907619,      46923]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Study Aggregation Systems with Multiway Graphs as an approximation to the \
asymmetric tumor growth in a heterogeneous environment\
\>", "Title",
 CellChangeTimes->{{3.770055572438499*^9, 3.7700555729498453`*^9}, {
  3.770055604008165*^9, 3.7700556066618843`*^9}, {3.832335945198794*^9, 
  3.832335946914747*^9}, {3.835165017886293*^9, 3.835165022511331*^9}, {
  3.835165063887413*^9, 3.835165074597142*^9}, {3.835169412920726*^9, 
  3.835169414443342*^9}},ExpressionUUID->"26ebdd0c-60e3-49f3-b040-\
dcc3a36fc7d6"],

Cell["Lina Marcela Ruiz Galvis", "Author",
 CellChangeTimes->{{3.549624168509506*^9, 3.549624171985794*^9}, {
  3.549624508772977*^9, 3.549624510775043*^9}, {3.5498187159613867`*^9, 
  3.5498187170087957`*^9}, {3.549819049020514*^9, 3.5498190533440437`*^9}, {
  3.77005561844785*^9, 3.7700556489651537`*^9}, {3.832335949309461*^9, 
  3.832335952432062*^9}, {3.835165082494986*^9, 
  3.8351650933826933`*^9}},ExpressionUUID->"804b77b3-6c3a-46d8-860f-\
9ce11d950c47"],

Cell["University of Antioquia", "Affiliation",
 CellChangeTimes->{{3.802186209582007*^9, 3.802186214327465*^9}, {
  3.832335954006332*^9, 3.8323359557765293`*^9}, {3.835165096100684*^9, 
  3.8351651095675573`*^9}},ExpressionUUID->"38cd9bbd-33f2-4856-9cfc-\
45f3b18bace3"],

Cell[CellGroupData[{

Cell["Supplementary Information", "Chapter",
 CellChangeTimes->{{3.835219758776425*^9, 3.835219772873774*^9}, {
  3.8352198159175797`*^9, 
  3.8352198351450243`*^9}},ExpressionUUID->"86053596-1417-46cd-bf38-\
e4d5d700bb14"],

Cell["\<\
Here it is shown some Multiway graphs of some System Aggregation simulated \
with the six rules each one with random initial conditions.\
\>", "Text",
 CellChangeTimes->{{3.8352198374137383`*^9, 
  3.8352199030388517`*^9}},ExpressionUUID->"8e46a993-8265-4964-8604-\
af39924632be"],

Cell[CellGroupData[{

Cell["Rule 1", "Subsection",
 CellChangeTimes->{{3.8352144011390676`*^9, 3.835214410659339*^9}, 
   3.835219909327859*^9},ExpressionUUID->"66304a55-ebe2-41e7-accc-\
30230acb4c9d"],

Cell["Graph 1 and three possible paths", "Text",
 CellChangeTimes->{{3.835219936626185*^9, 
  3.835219952404831*^9}},ExpressionUUID->"75cc9cfd-6edc-4ba3-8072-\
689a5081d5f6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
       1}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 
       1}, {0, 1, 1, 0, 1}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}}, {{1, 1, 0, 1, 
       1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 
       1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 
       1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0,
        0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 
       0, 1}, {1, 1, 1, 0, 0}, {0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 
       1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {0, 0, 0, 0, 
       0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
       1}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 
       1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 0, 0, 0, 
       0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 
       1, 1, 0, 1, 0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 
       1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{
       1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0,
        1, 0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 
       1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {
       1, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 
       0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 
       0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 
       1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 
       0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 
       1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 
       1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 
       1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {
       0, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {
       1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {0, 
       1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 
       1, 1, 0, 1}, {1, 1, 1, 1, 0}, {0, 0, 1, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 
       1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 
       0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 
       1, 0, 1}, {1, 1, 1, 0, 0}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 
       1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 1, 
       0, 0}}, {{1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {
       0, 1, 1, 0, 1, 0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 
       1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 
       0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 
       1, 1, 0, 1, 1}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 
       1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{
       1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0,
        1, 0}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0,
        0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {
       0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 0, 0, 0,
        0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {
       0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 1, 0, 0, 0, 0}}, {{1, 1, 0, 
       1, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1}, {
       1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 
       0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1}, {1, 1, 
       1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 
       1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 
       1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1,
        1}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0,
        0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 1, 0, 0, 0,
        0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 
       1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 
       0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 
       1, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 
       1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {1, 
       1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 
       1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 1, 1, 0, 0, 0}}, {{
       1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 
       1, 1, 1, 0}, {0, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 
       1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {1, 1, 0, 0, 0}}, {{1, 
       1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 
       1, 1, 0}, {0, 0, 1, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 
       1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {0, 0, 1, 1, 0}}, {{1, 1, 
       0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 
       0, 0}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 
       0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {1, 1, 1, 0, 0}}, {{1, 1, 0, 
       1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 
       1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 1}, {0, 
       1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 
       1, 1}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 
       1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 
       1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 
       0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 
       1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 1, 0, 0, 0, 0}}, {{
       1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0,
        1, 1}, {1, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {
       0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0,
        0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {
       0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 
       1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {
       1, 1, 1, 0, 0, 0}, {0, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 
       1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {
       0, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 
       0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 
       0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 
       1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 
       1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 
       1, 1, 0, 0, 0}, {0, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0, 0}, {1, 1, 1, 
       1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 0}, {1, 1, 0, 0,
        0, 0, 0}}, {{1, 1, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0,
        1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1,
        0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1}, {1,
        1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1,
        1, 1}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0,
        0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0,
        1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 1, 0, 0, 0, 0}}, {{
       1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0,
        1, 1}, {1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1}, {1, 1, 1, 0,
        0, 0}, {0, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 1, 0, 0,
        0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {
       0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 0}}, {{1, 1, 0, 
       1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {
       1, 1, 1, 0, 0, 0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 
       1, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {
       0, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 
       0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 0, 0, 
       0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 
       1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0}}, {{1, 1, 0, 1, 
       0, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 
       1, 1, 0, 0, 0}, {1, 1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 
       1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {1, 1, 0, 0, 
       0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
       1}, {1, 1, 1, 1, 0}, {0, 0, 1, 1, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 1, 1, 
       0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
       1}, {1, 1, 1, 0, 0}, {1, 1, 1, 0, 0}, {0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 
       0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 0}}}, {CompressedData["
1:eJwVxft+gVAAAGBKJUVXQrqcbud0IWnDImy5i232Bl5gb7Xn3PbH9/vA4/v+
wCqVys+f/6tYFcdqGIGROIXXcbrWqDE1lmCIJtEiOJInBVIkJYqnBEqkpLpc
b9c7tEK36S7da/QbKjNgNFZnDdZkQdNq2q1By2o5nMG5nMdBDvE6b/AmDwRD
cAVPgAISTRGKvhhIQEKSL4VSJJsylH05aA/bo07cGStAQYqvhErUTbqj7qSX
9ib9p/6zOlVn6nzwomXaQlvqU32mz43MWBhLc2YuzNxcgTlYghyswcZ6td7s
wt7aOydzCmfvHNzC3bo7L/MKb+8d4AJu4R4e4Qkt0Q4d0BGd0cXP/aNfBqvg
FFzDdXgOy/AWbaJLdBvmw+OwHL3Hq/gUX8cf489knZyTMrlN7pOvdJNe0tsv
kCsyEA==
       "], Null}, {EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, VertexStyle -> {
         GrayLevel[0]}}]]}, 
    TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1k3s01AkcxYcMY4zxa8yMmcGYMdj0UkiR+t0eHlnaHvJYtvVoi6ySsAlH
2VRrtwhJJUlrCil516JC7UaiaHLII7GIJEoxxc6es3vP+Z77z/efz73niv32
bvlBmUKhbFXcv76YmmvXy2VDNmB6wsudiT+1NZvfvGKgTJoYlVrHhLlUWh90
no/SlI4VzIMErrBXDz04qIr0cMNOhhENZeqbzWm1KojNXmBC5WkjpMSfMiZl
oTVRHNguJuBYbt/d7s0BQzr8NiSewO/v43JPZOnh9fFOjzmBbHTbZJvvq9KH
q+9LZuNxOq6u8/k7yFMJo/Jnr50fysnaZbvVRpYrQXXBjgOdygRMjNvOFm8j
IG5LvhD8RB3SRmuV4exZ8tyisI6qpTogVK2dKvynyb/cGvJ7TDioCWpKoAZp
wdLrELgO2mgi/OLHQ1lIWnjwcn+4BnQpG153l8zFZeH81O9lLKTWt8ZPRHLg
Ld55KEGi4Pkw37J4HxdfatwEzvc0sHbzkEFJvA4qVKh9vVQ2XHq6L2f4GsCf
c8zF4ygBES8pbBHdANsbZI9yq/l4yJKXnwrhQc9hRN7RQQftRnUgqkRYePrZ
UNcVVfTm1Fr6cUXYvSl6YmOMMtaXOUQW5rwjl0SNfVXpOkAuWVWdWLtLkQtR
kxFiO0sSt94+7fvpHSlvDA8+Z8WCvYHHqkNp6rhYEqfqaErA72vG+2OKnLxV
rz62iZ2DdpvcpPEjWnBP3uqqv4mAB51/3+KuNtoThQvuFhKIpJ0q6Gpjgxv7
/IncXg3N68fzurVGSEm+rTAgiocckf+WiEEaHsWU78pU48ElpShGz04VEQac
HI3FHDTN12qJr2RitLwwXIXOResfvmm3hAw0R92eyspnI5cvzFgv1saVznml
uRYcaA9PciLEbNyd2u9EU/RYMG3LKSR5uDiS+PlBCgGbIybmBTIdfIyNfCxT
9JmekeljzBKgj7l/ybdcGtTISSK2ngeTldFnDbyp+PFXI8ccM13EtUX7Hi4i
YO53J+W7p2JcF63aJjrNwLWmO9PUWAGmRtj0SRM+ZMMHmB3pYmy6f7KY1qsP
nzqZX9G4HpiGbpI906pg1F53eGBniADrXP9PrbPk4I6lKzKydBGwsbP+iZkS
0h/qNAU2vCIp/ymk/IbFJCkjj+cNRJoKn5Iqg5ovPpoykNflfr5eb4ocsOor
SAOB0TPuqYvaFbvJXHuNqzEXPR2Sk8WZFFDKtyRZp9eSjhNT0zXLWFBusjAQ
9tIg5FqnRv3GgnFuaNpsDIE3HKatYHIu1sQaPWqfIfDNsXrXqRoGwtsXMz1d
dFBeNXxp1JyJ1VOlqcK1OhCtaGheXsdB8bWrMosYPlqlM24CmgpmYvObI+bx
0OK5r9tzkgI8lof1+9aTMFtDucfQxf9czvO8Ig/e5iNv90Txpws0zCSWVVmP
c1F2mKgYuqXY0wa9/o2OPKz0DpKX7iFQFs36mVTnoKd7bFCqr4k87szSsVIu
3NiWzk71mgjp6dLXkLMw+P4MdaGWDhx6Rk6+iGLhyzYnulodF4I041KfLB4K
NkguVTrwsSMhEZcCNXDUy83Ks0LxH1C3t9NYDR72GS2N2br4rH7nPDueAc1u
75rQm3y4ml3gP78pAC/kTZd3iy7ifwn7zDw8B9u/sHa2FEkU3K0jjskMRK+c
9ojjSFBCOoro1QYQvDyRHxFviML0ymerg0Ww4or2hqoYYU9ys1jp+TQZtq5/
NuGcBD5coZ1V8AfyH+0VLwo=
       "], {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[0.016396441155957477`], 
         ArrowBox[CompressedData["
1:eJwVxft+gVAAAGBKJUVXQrqcbud0IWnDImy5i232Bl5gb7Xn3PbH9/vA4/v+
wCqVys+f/6tYFcdqGIGROIXXcbrWqDE1lmCIJtEiOJInBVIkJYqnBEqkpLpc
b9c7dJtW6C7da/QbKjNgNFZnDdZkQdNq2q1By2o5nMG5nMdBDvE6b/AmDwRD
cAVPgAISTRGKvhhIQEKSL4VSJJsylH05aA/bo07cGStAQYqvhErUHXWT7qQ3
6aX9p/6zOlVn6nzwomXaQlvqU32mz43MWBhLc2YuzNxcgTlYghyswcZ6td7s
wt7aOydzCmfvHNzC3bo7L/MKb+8d4AJu4R4e4Qkt0Q4d0BGd0cXP/aNfBqvg
FFzDdXgOy/AWbaJLdBvmw+OwHL3Hq/gUX8cf489knZyTMrlN7pOvdJNe0tsv
kB8yEA==
          "], 0.06564272955137405]}, 
        {GrayLevel[0], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.06564272955137405], DiskBox[2, 0.06564272955137405], 
         DiskBox[3, 0.06564272955137405], DiskBox[4, 0.06564272955137405], 
         DiskBox[5, 0.06564272955137405], DiskBox[6, 0.06564272955137405], 
         DiskBox[7, 0.06564272955137405], DiskBox[8, 0.06564272955137405], 
         DiskBox[9, 0.06564272955137405], DiskBox[10, 0.06564272955137405], 
         DiskBox[11, 0.06564272955137405], DiskBox[12, 0.06564272955137405], 
         DiskBox[13, 0.06564272955137405], DiskBox[14, 0.06564272955137405], 
         DiskBox[15, 0.06564272955137405], DiskBox[16, 0.06564272955137405], 
         DiskBox[17, 0.06564272955137405], DiskBox[18, 0.06564272955137405], 
         DiskBox[19, 0.06564272955137405], DiskBox[20, 0.06564272955137405], 
         DiskBox[21, 0.06564272955137405], DiskBox[22, 0.06564272955137405], 
         DiskBox[23, 0.06564272955137405], DiskBox[24, 0.06564272955137405], 
         DiskBox[25, 0.06564272955137405], DiskBox[26, 0.06564272955137405], 
         DiskBox[27, 0.06564272955137405], DiskBox[28, 0.06564272955137405], 
         DiskBox[29, 0.06564272955137405], DiskBox[30, 0.06564272955137405], 
         DiskBox[31, 0.06564272955137405], DiskBox[32, 0.06564272955137405], 
         DiskBox[33, 0.06564272955137405], DiskBox[34, 0.06564272955137405], 
         DiskBox[35, 0.06564272955137405], DiskBox[36, 0.06564272955137405], 
         DiskBox[37, 0.06564272955137405], DiskBox[38, 0.06564272955137405], 
         DiskBox[39, 0.06564272955137405], DiskBox[40, 0.06564272955137405], 
         DiskBox[41, 0.06564272955137405], DiskBox[42, 0.06564272955137405], 
         DiskBox[43, 0.06564272955137405], DiskBox[44, 0.06564272955137405], 
         DiskBox[45, 0.06564272955137405], DiskBox[46, 0.06564272955137405], 
         DiskBox[47, 0.06564272955137405], DiskBox[48, 0.06564272955137405], 
         DiskBox[49, 0.06564272955137405], DiskBox[50, 0.06564272955137405], 
         DiskBox[51, 0.06564272955137405], DiskBox[52, 0.06564272955137405], 
         DiskBox[53, 0.06564272955137405], DiskBox[54, 0.06564272955137405], 
         DiskBox[55, 0.06564272955137405], DiskBox[56, 0.06564272955137405], 
         DiskBox[57, 0.06564272955137405], DiskBox[58, 0.06564272955137405], 
         DiskBox[59, 0.06564272955137405], DiskBox[60, 0.06564272955137405], 
         DiskBox[61, 0.06564272955137405], DiskBox[62, 0.06564272955137405], 
         DiskBox[63, 0.06564272955137405], DiskBox[64, 0.06564272955137405], 
         DiskBox[65, 0.06564272955137405], DiskBox[66, 0.06564272955137405], 
         DiskBox[67, 0.06564272955137405], DiskBox[68, 0.06564272955137405], 
         DiskBox[69, 0.06564272955137405], DiskBox[70, 0.06564272955137405], 
         DiskBox[71, 0.06564272955137405], DiskBox[72, 0.06564272955137405], 
         DiskBox[73, 0.06564272955137405], DiskBox[74, 0.06564272955137405], 
         DiskBox[75, 0.06564272955137405], DiskBox[76, 0.06564272955137405], 
         DiskBox[77, 0.06564272955137405], DiskBox[78, 0.06564272955137405], 
         DiskBox[79, 0.06564272955137405], DiskBox[80, 0.06564272955137405], 
         DiskBox[81, 0.06564272955137405], DiskBox[82, 0.06564272955137405], 
         DiskBox[83, 0.06564272955137405]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Input",ExpressionUUID->"c12b86d6-b298-49cb-bf44-\
71870994192b"],

Cell[BoxData[
 RowBox[{
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
        1}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 
        1}, {0, 1, 1, 0, 1}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 
        1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 
        0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 
        1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1,
         1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {
        1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1,
         1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 
        0}, {0, 1, 0, 0, 0, 0}}}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}, 
        Null}, {EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {
           0, 1, 1, 0, 1}, {1, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 0, 
             0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0, 0}, {1, 1, 
           1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 
           0, 0}} -> Graphics[
            Raster[{{0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 
             1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 1, 1}}, {{0, 0}, {6, 5}}, {
             0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1, 0}, {1, 1, 
           1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 
           0, 0}, {0, 0, 0, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 
             1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 0, 0, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 0, 
             0, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1, 0}, {1, 1, 
           1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 
           0, 0}, {0, 0, 0, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 
             1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1, 0}, {1, 1, 
           1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 
           0, 0}, {0, 1, 0, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 0, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 
             1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}]}}]]}, 
     TagBox[
      GraphicsGroupBox[
       GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {0., 2.}, {0., 1.}, {
        0., 0.}}, {
         {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
          ArrowBox[{1, 2}, 0.043048128342245986`], 
          ArrowBox[{2, 3}, 0.043048128342245986`], 
          ArrowBox[{3, 4}, 0.043048128342245986`], 
          ArrowBox[{4, 5}, 0.043048128342245986`], 
          ArrowBox[{5, 6}, 0.043048128342245986`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 
             0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 1, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 
             0, 0, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 2, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0,
              1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 1, 1}}, {{0, 0}, {6, 5}}, {
             0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 3, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0,
              1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 4, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0,
              1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 5, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0,
              1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 6, 
           Automatic, {0.08609625668449197, 0.08609625668449197}]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   ImageSize->{186.92166964567346`, Automatic}], 
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
        1}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 
        1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 
        0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 
        0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
        1}, {1, 1, 1, 0, 0}, {0, 1, 1, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 
        1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 1, 0, 
        0}}, {{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 
        1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 1, 1, 0, 0, 0}}}, {{{1, 2}, {
        2, 3}, {3, 4}, {4, 5}, {5, 6}}, Null}, {EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {
           0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 
             0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 6}}, {
             0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 0, 0, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 0, 
             0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1, 0}, {1, 1, 
           1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 
           0, 0}, {0, 1, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 0, 0, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 
             1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 1,
            0, 0}} -> Graphics[
            
            Raster[{{1, 0, 0, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 
             0, 1, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 6}}, {
             0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 0, 
             0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 1,
            0, 0}} -> Graphics[
            
            Raster[{{1, 0, 0, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 
             0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 6}}, {
             0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}]}}]]}, 
     TagBox[
      GraphicsGroupBox[
       GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {0., 2.}, {0., 1.}, {
        0., 0.}}, {
         {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
          ArrowBox[{1, 2}, 0.043048128342245986`], 
          ArrowBox[{2, 3}, 0.043048128342245986`], 
          ArrowBox[{3, 4}, 0.043048128342245986`], 
          ArrowBox[{4, 5}, 0.043048128342245986`], 
          ArrowBox[{5, 6}, 0.043048128342245986`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 
             0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 1, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 
             0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 2, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 
             0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 
             6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 3, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 
             0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 
             6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 4, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 
             0, 0, 1, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 
             6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 5, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0,
              1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 6, 
           Automatic, {0.08609625668449197, 0.08609625668449197}]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   ImageSize->{179.72166964567347`, Automatic}], 
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
        1}, {1, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 
        1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 
        0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 
        0}}, {{1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 
        1}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 
        1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 0, 
        0}, {1, 1, 0, 0, 0, 0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {0, 
        1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 0, 
        0, 0}}}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}, Null}, {EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 1, 0, 1}, {
           0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 
             0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 6}}, {
             0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 0, 0, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 0, 
             0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}, {0, 1, 0,
            0, 0}} -> Graphics[
            
            Raster[{{1, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 
             0, 1, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 6}}, {
             0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 1, 1, 
           1, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 0, 1}, {1, 1, 1, 0, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 0, 
             0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0, 0}, {1, 1, 
           1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 
           0, 0}, {1, 1, 0, 0, 0, 0}} -> Graphics[
            
            Raster[{{0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1}, {1, 0, 0, 1, 0, 
             1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0, 0}, {1, 1, 
           1, 1, 1, 0}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 
           0, 0}, {1, 1, 0, 0, 0, 0}} -> Graphics[
            
            Raster[{{0, 0, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0, 
             1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}]}}]]}, 
     TagBox[
      GraphicsGroupBox[
       GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {0., 2.}, {0., 1.}, {
        0., 0.}}, {
         {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
          ArrowBox[{1, 2}, 0.043048128342245986`], 
          ArrowBox[{2, 3}, 0.043048128342245986`], 
          ArrowBox[{3, 4}, 0.043048128342245986`], 
          ArrowBox[{4, 5}, 0.043048128342245986`], 
          ArrowBox[{5, 6}, 0.043048128342245986`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 1, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 
             0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 1, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 0, 0, 1, 0}, {0, 
             0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 2, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 
             0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 
             6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 3, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {1, 
             0, 0, 1, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 
             6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 4, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 0,
              1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 5, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1}, {1, 0, 0, 1, 0,
              1}, {1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 6, Automatic, 
           {0.08609625668449197, 0.08609625668449197}]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   ImageSize->{180.9216696456735, Automatic}]}]], "Input",
 CellChangeTimes->{{3.8352163739707336`*^9, 
  3.835216398637104*^9}},ExpressionUUID->"1e697a3a-a3ac-4851-9271-\
d3fbc2b5e001"],

Cell["Graph 2 and two possible paths", "Text",
 CellChangeTimes->{{3.835219936626185*^9, 
  3.835219964778989*^9}},ExpressionUUID->"ed1aad50-0a8e-4748-bdd2-\
1d4acbd36c4d"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{{{0, 0, 1, 1, 0}, {1, 1, 0, 1, 1}, {1, 1, 0, 1, 1}, {0, 1, 0, 0, 
       1}, {0, 1, 1, 1, 1}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 
       0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
       1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 
       0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 
       1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{
       0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0,
        0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {
       0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
       1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 
       0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 
       1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0,
        0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 
       1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0,
        1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1,
        1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 
       1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 
       0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1,
        0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 
       0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 
       0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1,
        1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1,
        1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 
       0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 
       0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1,
        1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 
       0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 
       1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1,
        0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 
       0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 
       1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 
       1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 
       1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 
       1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 
       1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1,
        0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1,
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 
       1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 
       1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 
       0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1,
        0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {
       0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 
       0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
       1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1,
        1, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 1, 0, 0}, {0, 1, 
       1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1,
        0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0,
        1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 
       0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0,
        0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0,
        1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 
       1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 
       1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0,
        1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 
       1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1,
        0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 0, 0, 
       0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1,
        0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1,
        0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 
       1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 
       0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 
       0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 
       1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0,
        1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0,
        0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {
       0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {
       0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
       1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 
       0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 
       1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 
       0, 1, 0, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{
       0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0,
        1, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1}}, {{0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {
       0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {0, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 
       0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
       1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{
       0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1,
        1, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}}, {{0, 0, 1, 
       0, 0, 0}, {0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0,
        0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1,
        1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{
       0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1,
        1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 1, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 1, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0,
        0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0,
        0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 1, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        1, 1, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1,
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0,
        0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1,
        1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 
       1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 0, 0}, {0, 1, 
       1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1,
        0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0,
        1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 
       0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0,
        0, 0, 0}}, {{0, 0, 0, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0,
        1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 
       1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1, 0, 0}, {0, 1, 1, 1, 
       1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0,
        1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0,
        0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 
       1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1,
        1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {1, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 1, 
       0}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 
       0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}}, {{0, 0, 0, 1, 0, 
       0}, {0, 0, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 
       0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1}, {1, 
       1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {0, 
       0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1,
        0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 
       0, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1,
        1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 
       0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1,
        0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0,
        0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0}, {0, 0, 1, 1, 1,
        0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1,
        1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        1}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 1,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1,
        1}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 1, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0,
        0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1,
        0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}}, {{0, 1, 1, 1, 0,
        0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1,
        1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1,
        1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1,
        1, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1,
        1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 
       0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1,
        0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 
       1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1,
        0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 
       1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 
       1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}}, {{0, 1, 1, 1, 
       0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 
       1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       0, 0, 1, 1, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}}, {{
       0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0,
        1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
       1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 0,
        0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {
       0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 1, 0}}, {{0, 1, 1, 
       1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {
       0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 1, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       0, 0, 1, 0, 1, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 
       1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 1, 
       1}}, {{0, 1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 
       0}, {0, 1, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 
       0}, {0, 1, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 
       0}, {0, 1, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 
       0}, {0, 1, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
       1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 
       1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 1}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0}, {0, 
       1, 0, 0, 0, 0}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 1}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {0, 
       0, 0, 0, 0, 0}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
       1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1}, {0, 
       0, 0, 0, 1, 0}}}, {CompressedData["
1:eJxN2nmcz9Uex/HvOUmSraFpNNK0Wmbsu2EwtmyzMIxhEAYhSUlIsmanSCVL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       "], Null}, {EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, VertexStyle -> {
         GrayLevel[0]}}]]}, 
    TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9mHc8lf///+29OcvZ24p6ywjxSJQR0ZIkkRVJSaWyIg1SVGhYKW2jEpJK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       "], {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[0.015239397634092315`], 
         ArrowBox[CompressedData["
1:eJxF2mfYFtXRAODdjTHWqEQRfRUxGhsodikCCpao9I4CCiKIDXuJDREbCNgb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          "], 0.08144846642510457]}, 
        {GrayLevel[0], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.08144846642510457], DiskBox[2, 0.08144846642510457], 
         DiskBox[3, 0.08144846642510457], DiskBox[4, 0.08144846642510457], 
         DiskBox[5, 0.08144846642510457], DiskBox[6, 0.08144846642510457], 
         DiskBox[7, 0.08144846642510457], DiskBox[8, 0.08144846642510457], 
         DiskBox[9, 0.08144846642510457], DiskBox[10, 0.08144846642510457], 
         DiskBox[11, 0.08144846642510457], DiskBox[12, 0.08144846642510457], 
         DiskBox[13, 0.08144846642510457], DiskBox[14, 0.08144846642510457], 
         DiskBox[15, 0.08144846642510457], DiskBox[16, 0.08144846642510457], 
         DiskBox[17, 0.08144846642510457], DiskBox[18, 0.08144846642510457], 
         DiskBox[19, 0.08144846642510457], DiskBox[20, 0.08144846642510457], 
         DiskBox[21, 0.08144846642510457], DiskBox[22, 0.08144846642510457], 
         DiskBox[23, 0.08144846642510457], DiskBox[24, 0.08144846642510457], 
         DiskBox[25, 0.08144846642510457], DiskBox[26, 0.08144846642510457], 
         DiskBox[27, 0.08144846642510457], DiskBox[28, 0.08144846642510457], 
         DiskBox[29, 0.08144846642510457], DiskBox[30, 0.08144846642510457], 
         DiskBox[31, 0.08144846642510457], DiskBox[32, 0.08144846642510457], 
         DiskBox[33, 0.08144846642510457], DiskBox[34, 0.08144846642510457], 
         DiskBox[35, 0.08144846642510457], DiskBox[36, 0.08144846642510457], 
         DiskBox[37, 0.08144846642510457], DiskBox[38, 0.08144846642510457], 
         DiskBox[39, 0.08144846642510457], DiskBox[40, 0.08144846642510457], 
         DiskBox[41, 0.08144846642510457], DiskBox[42, 0.08144846642510457], 
         DiskBox[43, 0.08144846642510457], DiskBox[44, 0.08144846642510457], 
         DiskBox[45, 0.08144846642510457], DiskBox[46, 0.08144846642510457], 
         DiskBox[47, 0.08144846642510457], DiskBox[48, 0.08144846642510457], 
         DiskBox[49, 0.08144846642510457], DiskBox[50, 0.08144846642510457], 
         DiskBox[51, 0.08144846642510457], DiskBox[52, 0.08144846642510457], 
         DiskBox[53, 0.08144846642510457], DiskBox[54, 0.08144846642510457], 
         DiskBox[55, 0.08144846642510457], DiskBox[56, 0.08144846642510457], 
         DiskBox[57, 0.08144846642510457], DiskBox[58, 0.08144846642510457], 
         DiskBox[59, 0.08144846642510457], DiskBox[60, 0.08144846642510457], 
         DiskBox[61, 0.08144846642510457], DiskBox[62, 0.08144846642510457], 
         DiskBox[63, 0.08144846642510457], DiskBox[64, 0.08144846642510457], 
         DiskBox[65, 0.08144846642510457], DiskBox[66, 0.08144846642510457], 
         DiskBox[67, 0.08144846642510457], DiskBox[68, 0.08144846642510457], 
         DiskBox[69, 0.08144846642510457], DiskBox[70, 0.08144846642510457], 
         DiskBox[71, 0.08144846642510457], DiskBox[72, 0.08144846642510457], 
         DiskBox[73, 0.08144846642510457], DiskBox[74, 0.08144846642510457], 
         DiskBox[75, 0.08144846642510457], DiskBox[76, 0.08144846642510457], 
         DiskBox[77, 0.08144846642510457], DiskBox[78, 0.08144846642510457], 
         DiskBox[79, 0.08144846642510457], DiskBox[80, 0.08144846642510457], 
         DiskBox[81, 0.08144846642510457], DiskBox[82, 0.08144846642510457], 
         DiskBox[83, 0.08144846642510457], DiskBox[84, 0.08144846642510457], 
         DiskBox[85, 0.08144846642510457], DiskBox[86, 0.08144846642510457], 
         DiskBox[87, 0.08144846642510457], DiskBox[88, 0.08144846642510457], 
         DiskBox[89, 0.08144846642510457], DiskBox[90, 0.08144846642510457], 
         DiskBox[91, 0.08144846642510457], DiskBox[92, 0.08144846642510457], 
         DiskBox[93, 0.08144846642510457], DiskBox[94, 0.08144846642510457], 
         DiskBox[95, 0.08144846642510457], DiskBox[96, 0.08144846642510457], 
         DiskBox[97, 0.08144846642510457], DiskBox[98, 0.08144846642510457], 
         DiskBox[99, 0.08144846642510457], DiskBox[100, 0.08144846642510457], 
         DiskBox[101, 0.08144846642510457], DiskBox[102, 0.08144846642510457],
          DiskBox[103, 0.08144846642510457], 
         DiskBox[104, 0.08144846642510457], DiskBox[105, 0.08144846642510457],
          DiskBox[106, 0.08144846642510457], 
         DiskBox[107, 0.08144846642510457], DiskBox[108, 0.08144846642510457],
          DiskBox[109, 0.08144846642510457], 
         DiskBox[110, 0.08144846642510457], DiskBox[111, 0.08144846642510457],
          DiskBox[112, 0.08144846642510457], 
         DiskBox[113, 0.08144846642510457], DiskBox[114, 0.08144846642510457],
          DiskBox[115, 0.08144846642510457], 
         DiskBox[116, 0.08144846642510457], DiskBox[117, 0.08144846642510457],
          DiskBox[118, 0.08144846642510457], 
         DiskBox[119, 0.08144846642510457], DiskBox[120, 0.08144846642510457],
          DiskBox[121, 0.08144846642510457], 
         DiskBox[122, 0.08144846642510457], DiskBox[123, 0.08144846642510457],
          DiskBox[124, 0.08144846642510457], 
         DiskBox[125, 0.08144846642510457], DiskBox[126, 0.08144846642510457],
          DiskBox[127, 0.08144846642510457], 
         DiskBox[128, 0.08144846642510457], DiskBox[129, 0.08144846642510457],
          DiskBox[130, 0.08144846642510457], 
         DiskBox[131, 0.08144846642510457], DiskBox[132, 0.08144846642510457],
          DiskBox[133, 0.08144846642510457], 
         DiskBox[134, 0.08144846642510457], DiskBox[135, 0.08144846642510457],
          DiskBox[136, 0.08144846642510457], 
         DiskBox[137, 0.08144846642510457], DiskBox[138, 0.08144846642510457],
          DiskBox[139, 0.08144846642510457], 
         DiskBox[140, 0.08144846642510457], DiskBox[141, 0.08144846642510457],
          DiskBox[142, 0.08144846642510457], 
         DiskBox[143, 0.08144846642510457], DiskBox[144, 0.08144846642510457],
          DiskBox[145, 0.08144846642510457], 
         DiskBox[146, 0.08144846642510457], DiskBox[147, 0.08144846642510457],
          DiskBox[148, 0.08144846642510457], 
         DiskBox[149, 0.08144846642510457], DiskBox[150, 0.08144846642510457],
          DiskBox[151, 0.08144846642510457], 
         DiskBox[152, 0.08144846642510457], DiskBox[153, 0.08144846642510457],
          DiskBox[154, 0.08144846642510457], 
         DiskBox[155, 0.08144846642510457], DiskBox[156, 0.08144846642510457],
          DiskBox[157, 0.08144846642510457], 
         DiskBox[158, 0.08144846642510457], DiskBox[159, 0.08144846642510457],
          DiskBox[160, 0.08144846642510457], 
         DiskBox[161, 0.08144846642510457], DiskBox[162, 0.08144846642510457],
          DiskBox[163, 0.08144846642510457], 
         DiskBox[164, 0.08144846642510457], DiskBox[165, 0.08144846642510457],
          DiskBox[166, 0.08144846642510457], 
         DiskBox[167, 0.08144846642510457], DiskBox[168, 0.08144846642510457],
          DiskBox[169, 0.08144846642510457], 
         DiskBox[170, 0.08144846642510457], DiskBox[171, 0.08144846642510457],
          DiskBox[172, 0.08144846642510457], 
         DiskBox[173, 0.08144846642510457], DiskBox[174, 0.08144846642510457],
          DiskBox[175, 0.08144846642510457], 
         DiskBox[176, 0.08144846642510457], DiskBox[177, 0.08144846642510457],
          DiskBox[178, 0.08144846642510457], 
         DiskBox[179, 0.08144846642510457], DiskBox[180, 0.08144846642510457],
          DiskBox[181, 0.08144846642510457], 
         DiskBox[182, 0.08144846642510457], DiskBox[183, 0.08144846642510457],
          DiskBox[184, 0.08144846642510457], 
         DiskBox[185, 0.08144846642510457], DiskBox[186, 0.08144846642510457],
          DiskBox[187, 0.08144846642510457], 
         DiskBox[188, 0.08144846642510457], DiskBox[189, 0.08144846642510457],
          DiskBox[190, 0.08144846642510457], 
         DiskBox[191, 0.08144846642510457], DiskBox[192, 0.08144846642510457],
          DiskBox[193, 0.08144846642510457], 
         DiskBox[194, 0.08144846642510457], DiskBox[195, 0.08144846642510457],
          DiskBox[196, 0.08144846642510457], 
         DiskBox[197, 0.08144846642510457], DiskBox[198, 0.08144846642510457],
          DiskBox[199, 0.08144846642510457], 
         DiskBox[200, 0.08144846642510457], DiskBox[201, 0.08144846642510457],
          DiskBox[202, 0.08144846642510457], 
         DiskBox[203, 0.08144846642510457], DiskBox[204, 0.08144846642510457],
          DiskBox[205, 0.08144846642510457], 
         DiskBox[206, 0.08144846642510457], DiskBox[207, 0.08144846642510457],
          DiskBox[208, 0.08144846642510457], 
         DiskBox[209, 0.08144846642510457], DiskBox[210, 0.08144846642510457],
          DiskBox[211, 0.08144846642510457], 
         DiskBox[212, 0.08144846642510457], DiskBox[213, 0.08144846642510457],
          DiskBox[214, 0.08144846642510457], 
         DiskBox[215, 0.08144846642510457], DiskBox[216, 0.08144846642510457],
          DiskBox[217, 0.08144846642510457], 
         DiskBox[218, 0.08144846642510457], DiskBox[219, 0.08144846642510457],
          DiskBox[220, 0.08144846642510457], 
         DiskBox[221, 0.08144846642510457], DiskBox[222, 0.08144846642510457],
          DiskBox[223, 0.08144846642510457], 
         DiskBox[224, 0.08144846642510457], DiskBox[225, 0.08144846642510457],
          DiskBox[226, 0.08144846642510457], 
         DiskBox[227, 0.08144846642510457], DiskBox[228, 0.08144846642510457],
          DiskBox[229, 0.08144846642510457], 
         DiskBox[230, 0.08144846642510457], DiskBox[231, 0.08144846642510457],
          DiskBox[232, 0.08144846642510457], 
         DiskBox[233, 0.08144846642510457], DiskBox[234, 0.08144846642510457],
          DiskBox[235, 0.08144846642510457], 
         DiskBox[236, 0.08144846642510457], DiskBox[237, 0.08144846642510457],
          DiskBox[238, 0.08144846642510457], 
         DiskBox[239, 0.08144846642510457], DiskBox[240, 0.08144846642510457],
          DiskBox[241, 0.08144846642510457], 
         DiskBox[242, 0.08144846642510457], DiskBox[243, 0.08144846642510457],
          DiskBox[244, 0.08144846642510457], 
         DiskBox[245, 0.08144846642510457], DiskBox[246, 0.08144846642510457],
          DiskBox[247, 0.08144846642510457], 
         DiskBox[248, 0.08144846642510457], DiskBox[249, 0.08144846642510457],
          DiskBox[250, 0.08144846642510457], 
         DiskBox[251, 0.08144846642510457], DiskBox[252, 0.08144846642510457],
          DiskBox[253, 0.08144846642510457], 
         DiskBox[254, 0.08144846642510457], DiskBox[255, 0.08144846642510457],
          DiskBox[256, 0.08144846642510457], 
         DiskBox[257, 0.08144846642510457], DiskBox[258, 0.08144846642510457],
          DiskBox[259, 0.08144846642510457], 
         DiskBox[260, 0.08144846642510457], DiskBox[261, 0.08144846642510457],
          DiskBox[262, 0.08144846642510457], 
         DiskBox[263, 0.08144846642510457], DiskBox[264, 0.08144846642510457],
          DiskBox[265, 0.08144846642510457], 
         DiskBox[266, 0.08144846642510457], DiskBox[267, 0.08144846642510457],
          DiskBox[268, 0.08144846642510457], 
         DiskBox[269, 0.08144846642510457], DiskBox[270, 0.08144846642510457],
          DiskBox[271, 0.08144846642510457], 
         DiskBox[272, 0.08144846642510457], DiskBox[273, 0.08144846642510457],
          DiskBox[274, 0.08144846642510457], 
         DiskBox[275, 0.08144846642510457], DiskBox[276, 0.08144846642510457],
          DiskBox[277, 0.08144846642510457], 
         DiskBox[278, 0.08144846642510457], DiskBox[279, 0.08144846642510457],
          DiskBox[280, 0.08144846642510457], 
         DiskBox[281, 0.08144846642510457], DiskBox[282, 0.08144846642510457],
          DiskBox[283, 0.08144846642510457], 
         DiskBox[284, 0.08144846642510457], DiskBox[285, 0.08144846642510457],
          DiskBox[286, 0.08144846642510457], 
         DiskBox[287, 0.08144846642510457], DiskBox[288, 0.08144846642510457],
          DiskBox[289, 0.08144846642510457], 
         DiskBox[290, 0.08144846642510457], DiskBox[291, 0.08144846642510457],
          DiskBox[292, 0.08144846642510457], 
         DiskBox[293, 0.08144846642510457], DiskBox[294, 0.08144846642510457],
          DiskBox[295, 0.08144846642510457], 
         DiskBox[296, 0.08144846642510457], DiskBox[297, 0.08144846642510457],
          DiskBox[298, 0.08144846642510457], 
         DiskBox[299, 0.08144846642510457], DiskBox[300, 0.08144846642510457],
          DiskBox[301, 0.08144846642510457], 
         DiskBox[302, 0.08144846642510457], DiskBox[303, 0.08144846642510457],
          DiskBox[304, 0.08144846642510457], 
         DiskBox[305, 0.08144846642510457], DiskBox[306, 0.08144846642510457],
          DiskBox[307, 0.08144846642510457], 
         DiskBox[308, 0.08144846642510457], DiskBox[309, 0.08144846642510457],
          DiskBox[310, 0.08144846642510457], 
         DiskBox[311, 0.08144846642510457], DiskBox[312, 0.08144846642510457],
          DiskBox[313, 0.08144846642510457], 
         DiskBox[314, 0.08144846642510457], DiskBox[315, 0.08144846642510457],
          DiskBox[316, 0.08144846642510457], 
         DiskBox[317, 0.08144846642510457], DiskBox[318, 0.08144846642510457],
          DiskBox[319, 0.08144846642510457], 
         DiskBox[320, 0.08144846642510457], DiskBox[321, 0.08144846642510457],
          DiskBox[322, 0.08144846642510457], 
         DiskBox[323, 0.08144846642510457], DiskBox[324, 0.08144846642510457],
          DiskBox[325, 0.08144846642510457], 
         DiskBox[326, 0.08144846642510457], DiskBox[327, 0.08144846642510457],
          DiskBox[328, 0.08144846642510457], 
         DiskBox[329, 0.08144846642510457], DiskBox[330, 0.08144846642510457],
          DiskBox[331, 0.08144846642510457], 
         DiskBox[332, 0.08144846642510457], DiskBox[333, 0.08144846642510457],
          DiskBox[334, 0.08144846642510457], 
         DiskBox[335, 0.08144846642510457], DiskBox[336, 0.08144846642510457],
          DiskBox[337, 0.08144846642510457], 
         DiskBox[338, 0.08144846642510457], DiskBox[339, 0.08144846642510457],
          DiskBox[340, 0.08144846642510457], 
         DiskBox[341, 0.08144846642510457], DiskBox[342, 0.08144846642510457],
          DiskBox[343, 0.08144846642510457], 
         DiskBox[344, 0.08144846642510457], DiskBox[345, 0.08144846642510457],
          DiskBox[346, 0.08144846642510457], 
         DiskBox[347, 0.08144846642510457], DiskBox[348, 0.08144846642510457],
          DiskBox[349, 0.08144846642510457], 
         DiskBox[350, 0.08144846642510457], DiskBox[351, 0.08144846642510457],
          DiskBox[352, 0.08144846642510457], 
         DiskBox[353, 0.08144846642510457], DiskBox[354, 0.08144846642510457],
          DiskBox[355, 0.08144846642510457], 
         DiskBox[356, 0.08144846642510457], DiskBox[357, 0.08144846642510457],
          DiskBox[358, 0.08144846642510457], 
         DiskBox[359, 0.08144846642510457], DiskBox[360, 0.08144846642510457],
          DiskBox[361, 0.08144846642510457], 
         DiskBox[362, 0.08144846642510457], DiskBox[363, 0.08144846642510457],
          DiskBox[364, 0.08144846642510457], 
         DiskBox[365, 0.08144846642510457], DiskBox[366, 0.08144846642510457],
          DiskBox[367, 0.08144846642510457], 
         DiskBox[368, 0.08144846642510457], DiskBox[369, 0.08144846642510457],
          DiskBox[370, 0.08144846642510457], 
         DiskBox[371, 0.08144846642510457], DiskBox[372, 0.08144846642510457],
          DiskBox[373, 0.08144846642510457], 
         DiskBox[374, 0.08144846642510457], DiskBox[375, 0.08144846642510457],
          DiskBox[376, 0.08144846642510457], 
         DiskBox[377, 0.08144846642510457], DiskBox[378, 0.08144846642510457],
          DiskBox[379, 0.08144846642510457], 
         DiskBox[380, 0.08144846642510457], DiskBox[381, 0.08144846642510457],
          DiskBox[382, 0.08144846642510457], 
         DiskBox[383, 0.08144846642510457], DiskBox[384, 0.08144846642510457],
          DiskBox[385, 0.08144846642510457], 
         DiskBox[386, 0.08144846642510457], DiskBox[387, 0.08144846642510457],
          DiskBox[388, 0.08144846642510457], 
         DiskBox[389, 0.08144846642510457], DiskBox[390, 0.08144846642510457],
          DiskBox[391, 0.08144846642510457], 
         DiskBox[392, 0.08144846642510457], DiskBox[393, 0.08144846642510457],
          DiskBox[394, 0.08144846642510457], 
         DiskBox[395, 0.08144846642510457], DiskBox[396, 0.08144846642510457],
          DiskBox[397, 0.08144846642510457], 
         DiskBox[398, 0.08144846642510457], DiskBox[399, 0.08144846642510457],
          DiskBox[400, 0.08144846642510457], 
         DiskBox[401, 0.08144846642510457], DiskBox[402, 0.08144846642510457],
          DiskBox[403, 0.08144846642510457], 
         DiskBox[404, 0.08144846642510457], DiskBox[405, 0.08144846642510457],
          DiskBox[406, 0.08144846642510457], 
         DiskBox[407, 0.08144846642510457], DiskBox[408, 0.08144846642510457],
          DiskBox[409, 0.08144846642510457], 
         DiskBox[410, 0.08144846642510457], DiskBox[411, 0.08144846642510457],
          DiskBox[412, 0.08144846642510457], 
         DiskBox[413, 0.08144846642510457], DiskBox[414, 0.08144846642510457],
          DiskBox[415, 0.08144846642510457], 
         DiskBox[416, 0.08144846642510457], DiskBox[417, 0.08144846642510457],
          DiskBox[418, 0.08144846642510457], 
         DiskBox[419, 0.08144846642510457], DiskBox[420, 0.08144846642510457],
          DiskBox[421, 0.08144846642510457], 
         DiskBox[422, 0.08144846642510457], DiskBox[423, 0.08144846642510457],
          DiskBox[424, 0.08144846642510457], 
         DiskBox[425, 0.08144846642510457], DiskBox[426, 0.08144846642510457],
          DiskBox[427, 0.08144846642510457], 
         DiskBox[428, 0.08144846642510457], DiskBox[429, 0.08144846642510457],
          DiskBox[430, 0.08144846642510457], 
         DiskBox[431, 0.08144846642510457], DiskBox[432, 0.08144846642510457],
          DiskBox[433, 0.08144846642510457], 
         DiskBox[434, 0.08144846642510457], DiskBox[435, 0.08144846642510457],
          DiskBox[436, 0.08144846642510457], 
         DiskBox[437, 0.08144846642510457], DiskBox[438, 0.08144846642510457],
          DiskBox[439, 0.08144846642510457], 
         DiskBox[440, 0.08144846642510457], DiskBox[441, 0.08144846642510457],
          DiskBox[442, 0.08144846642510457], 
         DiskBox[443, 0.08144846642510457], DiskBox[444, 0.08144846642510457],
          DiskBox[445, 0.08144846642510457], 
         DiskBox[446, 0.08144846642510457], DiskBox[447, 0.08144846642510457],
          DiskBox[448, 0.08144846642510457], 
         DiskBox[449, 0.08144846642510457], DiskBox[450, 0.08144846642510457],
          DiskBox[451, 0.08144846642510457], 
         DiskBox[452, 0.08144846642510457], DiskBox[453, 0.08144846642510457],
          DiskBox[454, 0.08144846642510457], 
         DiskBox[455, 0.08144846642510457], DiskBox[456, 0.08144846642510457],
          DiskBox[457, 0.08144846642510457], 
         DiskBox[458, 0.08144846642510457], DiskBox[459, 0.08144846642510457],
          DiskBox[460, 0.08144846642510457], 
         DiskBox[461, 0.08144846642510457], DiskBox[462, 0.08144846642510457],
          DiskBox[463, 0.08144846642510457], 
         DiskBox[464, 0.08144846642510457], DiskBox[465, 0.08144846642510457],
          DiskBox[466, 0.08144846642510457], 
         DiskBox[467, 0.08144846642510457], DiskBox[468, 0.08144846642510457],
          DiskBox[469, 0.08144846642510457], 
         DiskBox[470, 0.08144846642510457], DiskBox[471, 0.08144846642510457],
          DiskBox[472, 0.08144846642510457], 
         DiskBox[473, 0.08144846642510457], DiskBox[474, 0.08144846642510457],
          DiskBox[475, 0.08144846642510457], 
         DiskBox[476, 0.08144846642510457], DiskBox[477, 0.08144846642510457],
          DiskBox[478, 0.08144846642510457], 
         DiskBox[479, 0.08144846642510457], DiskBox[480, 0.08144846642510457],
          DiskBox[481, 0.08144846642510457], 
         DiskBox[482, 0.08144846642510457], DiskBox[483, 0.08144846642510457],
          DiskBox[484, 0.08144846642510457], 
         DiskBox[485, 0.08144846642510457], DiskBox[486, 0.08144846642510457],
          DiskBox[487, 0.08144846642510457], 
         DiskBox[488, 0.08144846642510457], DiskBox[489, 0.08144846642510457],
          DiskBox[490, 0.08144846642510457], 
         DiskBox[491, 0.08144846642510457], DiskBox[492, 0.08144846642510457],
          DiskBox[493, 0.08144846642510457], 
         DiskBox[494, 0.08144846642510457], DiskBox[495, 0.08144846642510457],
          DiskBox[496, 0.08144846642510457], 
         DiskBox[497, 0.08144846642510457], DiskBox[498, 0.08144846642510457],
          DiskBox[499, 0.08144846642510457], 
         DiskBox[500, 0.08144846642510457], DiskBox[501, 0.08144846642510457],
          DiskBox[502, 0.08144846642510457], 
         DiskBox[503, 0.08144846642510457], DiskBox[504, 0.08144846642510457],
          DiskBox[505, 0.08144846642510457], 
         DiskBox[506, 0.08144846642510457], DiskBox[507, 0.08144846642510457],
          DiskBox[508, 0.08144846642510457], 
         DiskBox[509, 0.08144846642510457], DiskBox[510, 0.08144846642510457],
          DiskBox[511, 0.08144846642510457], 
         DiskBox[512, 0.08144846642510457], DiskBox[513, 0.08144846642510457],
          DiskBox[514, 0.08144846642510457], 
         DiskBox[515, 0.08144846642510457], DiskBox[516, 0.08144846642510457],
          DiskBox[517, 0.08144846642510457], 
         DiskBox[518, 0.08144846642510457], DiskBox[519, 0.08144846642510457],
          DiskBox[520, 0.08144846642510457], 
         DiskBox[521, 0.08144846642510457], DiskBox[522, 0.08144846642510457],
          DiskBox[523, 0.08144846642510457], 
         DiskBox[524, 0.08144846642510457], DiskBox[525, 0.08144846642510457],
          DiskBox[526, 0.08144846642510457], 
         DiskBox[527, 0.08144846642510457], DiskBox[528, 0.08144846642510457],
          DiskBox[529, 0.08144846642510457], 
         DiskBox[530, 0.08144846642510457], DiskBox[531, 0.08144846642510457],
          DiskBox[532, 0.08144846642510457], 
         DiskBox[533, 0.08144846642510457], DiskBox[534, 0.08144846642510457],
          DiskBox[535, 0.08144846642510457], 
         DiskBox[536, 0.08144846642510457], DiskBox[537, 0.08144846642510457],
          DiskBox[538, 0.08144846642510457], 
         DiskBox[539, 0.08144846642510457], DiskBox[540, 0.08144846642510457],
          DiskBox[541, 0.08144846642510457], 
         DiskBox[542, 0.08144846642510457], DiskBox[543, 0.08144846642510457],
          DiskBox[544, 0.08144846642510457], 
         DiskBox[545, 0.08144846642510457], DiskBox[546, 0.08144846642510457],
          DiskBox[547, 0.08144846642510457], 
         DiskBox[548, 0.08144846642510457], DiskBox[549, 0.08144846642510457],
          DiskBox[550, 0.08144846642510457], 
         DiskBox[551, 0.08144846642510457], DiskBox[552, 0.08144846642510457],
          DiskBox[553, 0.08144846642510457], 
         DiskBox[554, 0.08144846642510457], DiskBox[555, 0.08144846642510457],
          DiskBox[556, 0.08144846642510457], 
         DiskBox[557, 0.08144846642510457], DiskBox[558, 0.08144846642510457],
          DiskBox[559, 0.08144846642510457], 
         DiskBox[560, 0.08144846642510457], DiskBox[561, 0.08144846642510457],
          DiskBox[562, 0.08144846642510457], 
         DiskBox[563, 0.08144846642510457], DiskBox[564, 0.08144846642510457],
          DiskBox[565, 0.08144846642510457], 
         DiskBox[566, 0.08144846642510457], DiskBox[567, 0.08144846642510457],
          DiskBox[568, 0.08144846642510457], 
         DiskBox[569, 0.08144846642510457], DiskBox[570, 0.08144846642510457],
          DiskBox[571, 0.08144846642510457], 
         DiskBox[572, 0.08144846642510457], DiskBox[573, 0.08144846642510457],
          DiskBox[574, 0.08144846642510457], 
         DiskBox[575, 0.08144846642510457], DiskBox[576, 0.08144846642510457],
          DiskBox[577, 0.08144846642510457], 
         DiskBox[578, 0.08144846642510457], DiskBox[579, 0.08144846642510457],
          DiskBox[580, 0.08144846642510457], 
         DiskBox[581, 0.08144846642510457], DiskBox[582, 0.08144846642510457],
          DiskBox[583, 0.08144846642510457], 
         DiskBox[584, 0.08144846642510457], DiskBox[585, 0.08144846642510457],
          DiskBox[586, 0.08144846642510457], 
         DiskBox[587, 0.08144846642510457], DiskBox[588, 0.08144846642510457],
          DiskBox[589, 0.08144846642510457], 
         DiskBox[590, 0.08144846642510457], DiskBox[591, 0.08144846642510457],
          DiskBox[592, 0.08144846642510457], 
         DiskBox[593, 0.08144846642510457], DiskBox[594, 0.08144846642510457],
          DiskBox[595, 0.08144846642510457], 
         DiskBox[596, 0.08144846642510457], DiskBox[597, 0.08144846642510457],
          DiskBox[598, 0.08144846642510457], 
         DiskBox[599, 0.08144846642510457], DiskBox[600, 0.08144846642510457],
          DiskBox[601, 0.08144846642510457], 
         DiskBox[602, 0.08144846642510457], DiskBox[603, 0.08144846642510457],
          DiskBox[604, 0.08144846642510457], 
         DiskBox[605, 0.08144846642510457], DiskBox[606, 0.08144846642510457],
          DiskBox[607, 0.08144846642510457], 
         DiskBox[608, 0.08144846642510457], DiskBox[609, 0.08144846642510457],
          DiskBox[610, 0.08144846642510457], 
         DiskBox[611, 0.08144846642510457], DiskBox[612, 0.08144846642510457],
          DiskBox[613, 0.08144846642510457], 
         DiskBox[614, 0.08144846642510457], DiskBox[615, 0.08144846642510457],
          DiskBox[616, 0.08144846642510457], 
         DiskBox[617, 0.08144846642510457], DiskBox[618, 0.08144846642510457],
          DiskBox[619, 0.08144846642510457], 
         DiskBox[620, 0.08144846642510457], DiskBox[621, 0.08144846642510457],
          DiskBox[622, 0.08144846642510457], 
         DiskBox[623, 0.08144846642510457], DiskBox[624, 0.08144846642510457],
          DiskBox[625, 0.08144846642510457], 
         DiskBox[626, 0.08144846642510457], DiskBox[627, 0.08144846642510457],
          DiskBox[628, 0.08144846642510457], 
         DiskBox[629, 0.08144846642510457], DiskBox[630, 0.08144846642510457],
          DiskBox[631, 0.08144846642510457], 
         DiskBox[632, 0.08144846642510457], DiskBox[633, 0.08144846642510457],
          DiskBox[634, 0.08144846642510457], 
         DiskBox[635, 0.08144846642510457], DiskBox[636, 0.08144846642510457],
          DiskBox[637, 0.08144846642510457], 
         DiskBox[638, 0.08144846642510457], DiskBox[639, 0.08144846642510457],
          DiskBox[640, 0.08144846642510457], 
         DiskBox[641, 0.08144846642510457], DiskBox[642, 0.08144846642510457],
          DiskBox[643, 0.08144846642510457], 
         DiskBox[644, 0.08144846642510457], DiskBox[645, 0.08144846642510457],
          DiskBox[646, 0.08144846642510457], 
         DiskBox[647, 0.08144846642510457], DiskBox[648, 0.08144846642510457],
          DiskBox[649, 0.08144846642510457], 
         DiskBox[650, 0.08144846642510457], DiskBox[651, 0.08144846642510457],
          DiskBox[652, 0.08144846642510457], 
         DiskBox[653, 0.08144846642510457], 
         DiskBox[654, 0.08144846642510457]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Input",ImageCache->GraphicsData["CompressedBitmap", \
"\<\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\
\>", "ImageResolution" -> \
120.],ExpressionUUID->"58022a41-cfca-472e-934a-051b5503dfa1"],

Cell[BoxData[
 RowBox[{
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{0, 0, 1, 1, 0}, {1, 1, 0, 1, 1}, {1, 1, 0, 1, 1}, {0, 1, 0, 0, 
        1}, {0, 1, 1, 1, 1}}, {{0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 
        0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 
        0}}, {{0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 
        1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0,
         0, 0}, {0, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {
        0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0,
         0, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 
        0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 
        0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 
        1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 
        0}}}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}, Null}, {EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 0, 1, 
           1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 
           0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {
             1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 1, 1, 0}, {1, 1, 
           0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 
           1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 0, 0, 0, 0}, {0, 1, 
           1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 
           1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 1}, {
             1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 0, 0, 0, 0}, {0, 0, 
           1, 1, 1, 0}, {1, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 
           1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0}, {1, 1, 0, 0, 0, 1}, {
             1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 1, 0}, {1, 1, 0, 
           1, 1}, {1, 1, 0, 1, 1}, {0, 1, 0, 0, 1}, {0, 1, 1, 1, 1}} -> 
          Graphics[
            
            Raster[{{1, 0, 0, 0, 0}, {1, 0, 1, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 
             1, 0, 0}, {1, 1, 0, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 1, 0, 0}, {1, 1, 
           0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 
           1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}]}}]]}, 
     TagBox[
      GraphicsGroupBox[
       GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {0., 2.}, {0., 1.}, {
        0., 0.}}, {
         {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
          ArrowBox[{1, 2}, 0.043048128342245986`], 
          ArrowBox[{2, 3}, 0.043048128342245986`], 
          ArrowBox[{3, 4}, 0.043048128342245986`], 
          ArrowBox[{4, 5}, 0.043048128342245986`], 
          ArrowBox[{5, 6}, 0.043048128342245986`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 0, 0}, {1, 0, 1, 1, 0}, {0, 0, 1, 0, 0}, {0, 
             0, 1, 0, 0}, {1, 1, 0, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 1, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 2, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 3, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0}, {1, 1, 0, 0, 0, 
             1}, {1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 4, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 
             1}, {1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 5, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 
             0}, {1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 6, 
           Automatic, {0.08609625668449197, 0.08609625668449197}]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   ImageSize->{145.52166964567354`, Automatic}], 
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{0, 0, 1, 1, 0}, {1, 1, 0, 1, 1}, {1, 1, 0, 1, 1}, {0, 1, 0, 0, 
        1}, {0, 1, 1, 1, 1}}, {{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 
        0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 
        1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 
        0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {
        1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 
        1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 
        0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0,
         0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 
        1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0,
         0, 0, 1, 0, 0}}}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}, Null}, {
       EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{0, 1, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 
           1, 0}, {0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}} -> 
          Graphics[
            
            Raster[{{1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}], Frame -> Automatic, 
            FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 1, 1, 0, 0, 0}, {0, 1, 
           1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 
           1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             0}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1}, {
             1, 0, 0, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 1, 0}, {1, 1, 0, 
           1, 1}, {1, 1, 0, 1, 1}, {0, 1, 0, 0, 1}, {0, 1, 1, 1, 1}} -> 
          Graphics[
            
            Raster[{{1, 0, 0, 0, 0}, {1, 0, 1, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 
             1, 0, 0}, {1, 1, 0, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 0, 0, 0}, {0, 1, 
           1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 
           1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1}, {
             1, 1, 0, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 0, 0, 0, 0}, {0, 1, 
           1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 
           1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1}, {
             1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 1, 1, 0, 0, 0}, {0, 1, 
           1, 1, 0, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 1, 0, 0, 
           1, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 
             1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1}, {
             1, 0, 0, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}]}}]]}, 
     TagBox[
      GraphicsGroupBox[
       GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {0., 2.}, {0., 1.}, {
        0., 0.}}, {
         {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
          ArrowBox[{1, 2}, 0.043048128342245986`], 
          ArrowBox[{2, 3}, 0.043048128342245986`], 
          ArrowBox[{3, 4}, 0.043048128342245986`], 
          ArrowBox[{4, 5}, 0.043048128342245986`], 
          ArrowBox[{5, 6}, 0.043048128342245986`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 0, 0}, {1, 0, 1, 1, 0}, {0, 0, 1, 0, 0}, {0, 
             0, 1, 0, 0}, {1, 1, 0, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 1, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 
             1}}, {{0, 0}, {6, 6}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 2, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 
             1}, {1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 3, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 
             1}, {1, 1, 0, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 4, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              1}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 
             1}, {1, 0, 0, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 5, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0,
              0}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 
             1}, {1, 0, 0, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 6, 
           Automatic, {0.08609625668449197, 0.08609625668449197}]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   ImageSize->{147.32166964567352`, Automatic}]}]], "Input",
 CellChangeTimes->{
  3.83521644538503*^9},ExpressionUUID->"ee2f071a-c58f-4aed-8eec-486b8babf7e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rule 2", "Subsection",
 CellChangeTimes->{{3.835214414184615*^9, 3.835214415523068*^9}, {
  3.8352199766842833`*^9, 
  3.8352199770949793`*^9}},ExpressionUUID->"1474cd39-d2eb-4bbb-8212-\
01699b655107"],

Cell["Graph 1 ", "Text",
 CellChangeTimes->{{3.835219936626185*^9, 
  3.835219981381526*^9}},ExpressionUUID->"4ff11df9-64ce-450d-a32d-\
3f092535a4e6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[CompressedData["
1:eJxTTMoPymNmYGDgAGJWKGZkgABGNMyARw4XRgbo5uBST007qOUPZHtoZQe6
+bQIK3z+oHZ8EGsOJf6gR1ih8wGikwJk
      
      "], {{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {4, 6}, {
       4, 7}, {5, 8}, {6, 8}, {7, 8}}, Null}, {EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
       ImageSize -> Large, 
       VertexShape -> {{{1, 1, 1, 1, 1}, {1, 0, 1, 0, 1}, {1, 1, 1, 1, 1}, {1,
           1, 1, 1, 0}, {0, 0, 1, 1, 0}} -> Graphics[
           
           Raster[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 0, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 0}, {0, 1, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 0}, {0, 0, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 0}, {0, 1, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 1, 1}, {1, 0, 1, 0,
           1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 0, 1, 1, 0}} -> 
         Graphics[
           
           Raster[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 
            0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}]}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{0., 3.}, {-1., 2.}, {0., 2.}, {1., 2.}, {-1., 
       1.}, {0., 1.}, {1., 1.}, {0., 0.}}, {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
         ArrowBox[{1, 2}, 0.030239520958083826`], 
         ArrowBox[{1, 3}, 0.030239520958083826`], 
         ArrowBox[{1, 4}, 0.030239520958083826`], 
         ArrowBox[{2, 5}, 0.030239520958083826`], 
         ArrowBox[{2, 6}, 0.030239520958083826`], 
         ArrowBox[{3, 5}, 0.030239520958083826`], 
         ArrowBox[{3, 7}, 0.030239520958083826`], 
         ArrowBox[{4, 6}, 0.030239520958083826`], 
         ArrowBox[{4, 7}, 0.030239520958083826`], 
         ArrowBox[{5, 8}, 0.030239520958083826`], 
         ArrowBox[{6, 8}, 0.030239520958083826`], 
         ArrowBox[{7, 8}, 0.030239520958083826`]}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 1, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 2, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 3, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 4, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 1, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 5, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 6, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 1, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 7, 
          Automatic, {0.06047904191616765, 0.06047904191616765}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 
            1, 0, 1, 0}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 8, 
          Automatic, {0.06047904191616765, 0.06047904191616765}]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->{318.4129870129868, Automatic}]], "Input",ExpressionUUID->\
"a77ebc8f-db37-46c7-bf3b-4a943bc05559"],

Cell["Graph 2", "Text",
 CellChangeTimes->{{3.835219991444153*^9, 
  3.835219995899229*^9}},ExpressionUUID->"2c4339b5-c6b7-49bf-bc57-\
8b6166a3f83b"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[CompressedData["
1:eJxTTMoPymNmYGBgAWJWKGaEYgYsNDJAlkPG2PSh6ydWLa3swKWfFnagqyHV
DgALxgH4
      "], {{{1, 2}, {1, 3}, {3, 4}}, Null}, {EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
       ImageSize -> Large, 
       VertexShape -> {{{1, 1, 0, 1, 0}, {1, 0, 1, 0, 0}, {1, 0, 1, 1, 1}, {1,
           0, 1, 0, 1}, {0, 1, 0, 0, 0}} -> Graphics[
           
           Raster[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 1, 
            0, 1, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 0, 0, 0,
           0}, {1, 0, 1, 1, 1}, {1, 0, 1, 0, 1}, {0, 1, 0, 0, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 1, 
            1, 1, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 0, 0, 1,
           1}, {1, 0, 1, 1, 1}, {1, 0, 1, 0, 1}, {0, 1, 0, 0, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 1, 
            1, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 0}, {1, 0, 0, 1,
           0}, {1, 0, 1, 1, 1}, {1, 0, 1, 0, 1}, {0, 1, 0, 0, 0}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 1, 
            1, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}]}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{0., 2.}, {0., 1.}, {1., 1.}, {1., 0.}}, {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
         ArrowBox[{1, 2}, 0.02261146496815286], 
         ArrowBox[{1, 3}, 0.02261146496815286], 
         ArrowBox[{3, 4}, 0.02261146496815286]}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 
            1, 1, 1, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 1, 
          Automatic, {0.04522292993630572, 0.04522292993630572}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 
            1, 0, 1, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 2, 
          Automatic, {0.04522292993630572, 0.04522292993630572}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 
            1, 1, 0, 1}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 3, 
          Automatic, {0.04522292993630572, 0.04522292993630572}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 
            1, 1, 0, 0}, {0, 0, 1, 0, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 4, 
          Automatic, {0.04522292993630572, 0.04522292993630572}]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->{205.9601370289629, Automatic}]], "Input",ExpressionUUID->\
"3fe6f7c8-27af-43d1-a78c-90b5f5369e67"],

Cell["Graph 3", "Text",
 CellChangeTimes->{{3.8352200001831303`*^9, 
  3.835220016414576*^9}},ExpressionUUID->"82af06ab-0106-4974-a6e7-\
627f7a763b09"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[CompressedData["
1:eJxTTMoPymNmYGDgB2JWKGaEYhhgRKKxYVxqkAE+M2htBwMONrXtoMQfxJhB
qR3o/iDHjdTwB7XjHJ9eWscHNdMVLr343ECs/ZT4k9g4o1SeUn9QI+0SkyZI
iXNy44OSdIVPHgC6FALb
      
      "], {{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 6}, {2, 7}, {3, 8}, {3, 9}, {
       4, 6}, {4, 8}, {4, 10}, {4, 11}, {5, 7}, {5, 9}, {6, 12}, {6, 13}, {8, 
       14}, {8, 15}, {10, 12}, {10, 14}, {11, 13}, {11, 15}}, Null}, {
      EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
       ImageSize -> Large, 
       VertexShape -> {{{1, 1, 1, 0, 1}, {0, 1, 1, 1, 1}, {1, 1, 0, 1, 0}, {1,
           1, 1, 1, 1}, {0, 1, 0, 1, 1}} -> Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 0, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 0, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 0, 0}, {0, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 1}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 0, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 1}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 0, 
            0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 1}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 1, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 0, 0}, {0, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 1, 0, 0, 1}, {0, 1, 1, 1,
           1}, {1, 1, 0, 1, 0}, {1, 1, 1, 0, 0}, {0, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{1, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 0, 
            0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}]}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{0., 3.}, {0., 2.}, {1., 2.}, {2., 2.}, {-1., 2.}, {
       1., 1.}, {-1., 1.}, {3., 1.}, {0., 1.}, {2., 1.}, {4., 1.}, {1., 0.}, {
       2., 0.}, {3., 0.}, {4., 0.}}, {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
         ArrowBox[{1, 2}, 0.043048128342245986`], 
         ArrowBox[{1, 3}, 0.043048128342245986`], 
         ArrowBox[{1, 4}, 0.043048128342245986`], 
         ArrowBox[{1, 5}, 0.043048128342245986`], 
         ArrowBox[{2, 6}, 0.043048128342245986`], 
         ArrowBox[{2, 7}, 0.043048128342245986`], 
         ArrowBox[{3, 8}, 0.043048128342245986`], 
         ArrowBox[{3, 9}, 0.043048128342245986`], 
         ArrowBox[{4, 6}, 0.043048128342245986`], 
         ArrowBox[{4, 8}, 0.043048128342245986`], 
         ArrowBox[{4, 10}, 0.043048128342245986`], 
         ArrowBox[{4, 11}, 0.043048128342245986`], 
         ArrowBox[{5, 7}, 0.043048128342245986`], 
         ArrowBox[{5, 9}, 0.043048128342245986`], 
         ArrowBox[{6, 12}, 0.043048128342245986`], 
         ArrowBox[{6, 13}, 0.043048128342245986`], 
         ArrowBox[{8, 14}, 0.043048128342245986`], 
         ArrowBox[{8, 15}, 0.043048128342245986`], 
         ArrowBox[{10, 12}, 0.043048128342245986`], 
         ArrowBox[{10, 14}, 0.043048128342245986`], 
         ArrowBox[{11, 13}, 0.043048128342245986`], 
         ArrowBox[{11, 15}, 0.043048128342245986`]}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 1, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 2, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 3, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 4, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 5, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 6, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 7, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 8, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 9, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 10, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 11, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 
            0, 0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 12, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 0, 1, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 13, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 14, 
          Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{1, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 
            0, 0, 0, 0}, {0, 0, 1, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 15, 
          Automatic, {0.08609625668449197, 0.08609625668449197}]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->Large]], "Input",ExpressionUUID->"327e67ac-f80b-4e51-8cb8-\
c74fbe44e49a"],

Cell["Graph 4", "Text",
 CellChangeTimes->{{3.835220020273604*^9, 
  3.835220023928974*^9}},ExpressionUUID->"01e75add-0fec-4ff7-ad90-\
970c061bebef"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[CompressedData["
1:eJxTTMoPymNmYGDgBmJWKGZkgAAYDWMz4hFjJCDGgEUfPjsImUcNO8i1l9b+
INUOSuyltT9IsYNSe2ntD2LtIMVefJha/qC2HaRgAGIoAo8=
      
      "], {{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 6}, {5, 7}, {
       6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}, {10, 11}}, Null}, {EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
       ImageSize -> Large, 
       VertexShape -> {{{1, 0, 1, 0, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1,
           1, 1, 1, 0}, {1, 0, 0, 0, 1}} -> Graphics[
           
           Raster[{{0, 1, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 0,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 0, 0, 0, 1}} -> 
         Graphics[
           
           Raster[{{0, 1, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 0,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 0, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 0,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 0, 0, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 1,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 1,
           0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 
            0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 0,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 1,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 0, 0, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 0,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 1,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 0, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], {{1, 0, 1, 0, 0}, {1, 1, 1, 1,
           0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 1}} -> 
         Graphics[
           
           Raster[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 
            0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
           Automatic, FrameLabel -> {None, None}, 
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
           Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 15, 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}]}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{0., 6.}, {0., 5.}, {1., 5.}, {0., 4.}, {1., 4.}, {
       0., 3.}, {1., 3.}, {0., 2.}, {1., 2.}, {0., 1.}, {0., 0.}}, {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
         ArrowBox[{1, 2}, 0.04847715736040609], 
         ArrowBox[{1, 3}, 0.04847715736040609], 
         ArrowBox[{2, 4}, 0.04847715736040609], 
         ArrowBox[{3, 4}, 0.04847715736040609], 
         ArrowBox[{3, 5}, 0.04847715736040609], 
         ArrowBox[{4, 6}, 0.04847715736040609], 
         ArrowBox[{5, 6}, 0.04847715736040609], 
         ArrowBox[{5, 7}, 0.04847715736040609], 
         ArrowBox[{6, 8}, 0.04847715736040609], 
         ArrowBox[{7, 8}, 0.04847715736040609], 
         ArrowBox[{7, 9}, 0.04847715736040609], 
         ArrowBox[{8, 10}, 0.04847715736040609], 
         ArrowBox[{9, 10}, 0.04847715736040609], 
         ArrowBox[{10, 11}, 0.04847715736040609]}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 1, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 1, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 1, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 2, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          GraphicsBox[
           RasterBox[{{0, 0, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 3, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 1, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 4, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 5, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 6, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 7, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 8, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 1, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 9, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 
            0, 0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 10, 
          Automatic, {0.09695431472081217, 0.09695431472081217}], InsetBox[
          
          GraphicsBox[
           RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 
            0, 0, 0, 1}, {0, 1, 0, 1, 1}}, {{0, 0}, {5, 5}}, {0, 1}],
           Frame->Automatic,
           FrameLabel->{None, None},
           FrameTicks->{{None, None}, {None, None}},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImageSize->15,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultPlotStyle" -> Automatic}], 11, 
          Automatic, {0.09695431472081217, 0.09695431472081217}]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->Large]], "Input",
 CellChangeTimes->{
  3.835220033251878*^9},ExpressionUUID->"be91bd25-ca85-4d34-b396-\
a1247550415b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rule 3", "Subsection",
 CellChangeTimes->{{3.83521464022099*^9, 3.835214642317039*^9}, {
  3.8352200277910013`*^9, 
  3.8352200282986193`*^9}},ExpressionUUID->"78859198-0044-4139-a68e-\
6a7184dac176"],

Cell["Graph 1 and tow possible paths", "Text",
 CellChangeTimes->{{3.835220020273604*^9, 
  3.835220063800763*^9}},ExpressionUUID->"80648ba7-d437-4df2-aec3-\
6a52980c271a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 0}, {1, 1, 1, 0, 1}, {0, 1, 0, 1, 
       1}, {1, 1, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 
       1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 
       1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1,
        0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 1, 1, 0, 1, 
       1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 
       0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{1, 1, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 1, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 1, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{1, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 1, 1, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{1, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 1, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 1, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 1, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0}, {
       1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0,
        1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {
       1, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1,
        0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{
       0, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0,
        0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0}, {1, 1, 1, 1,
        1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0,
        1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 0,
        0, 0}, {1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0,
        0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{1, 1, 1, 0,
        0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 
       0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1,
        0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 
       1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
       1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1,
        0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0,
        0}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{1, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{1, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 
       1}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 
       1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 
       1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 
       1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 
       1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 
       1, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 
       0}}, {{1, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 1, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1,
        0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0, 0}}, {{0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}}, {{0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {1, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0,
        0}}, {{1, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0,
        0}}, {{0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1,
        0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 1, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 1, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0,
        0}}, {{0, 0, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0,
        0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1,
        0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0,
        0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}}, {{0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 1, 1, 0, 1, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 1, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 1, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0}}, {{1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 1, 1, 0, 0, 0}}, {{1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 1}, {0, 0, 0, 1, 0, 0}}, {{0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {
       1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1,
        1, 0}, {0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1,
        1}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 1, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 
       1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1, 0}, {0, 0,
        1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 1, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1,
        0, 1, 0}, {0, 0, 0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 
       0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0,
        1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0,
        0, 0, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1,
        1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1,
        1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0,
        0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 1,
        1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 
       0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1,
        1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 
       1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 1, 0}, {0, 0,
        0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 
       1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1, 0}, {0, 0,
        1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 
       0}, {0, 0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 
       1}, {0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {0, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0,
        0}}, {{0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 
       1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1,
        0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0,
        0}, {1, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1}, {0, 0, 
       1, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 
       0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1,
        1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 0, 1, 1, 0}}, {{0, 0, 1, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 
       1, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 1, 1, 0}, {0, 0, 1,
        0, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 
       0}}, {{0, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 
       1, 0, 0, 0}, {0, 1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 1, 0}, {0, 1,
        1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0,
        1, 1, 0}, {0, 0, 1, 0, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 
       0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 
       0}, {1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 1,
        1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0,
        0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 1, 1}, {0, 1, 1, 1, 1,
        1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1,
        1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 1, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0,
        0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1,
        1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 
       0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 1,
        1, 1, 0, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 
       0}, {0, 0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 
       1, 1, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 1, 1, 0}, {0, 0,
        1, 0, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 0, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       1}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 1, 1, 0, 0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 0, 1, 0, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 
       1}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 0, 1, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 
       0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 
       0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 
       0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 
       0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 
       1}, {0, 0, 1, 0, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 
       0}, {0, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 
       0}, {0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1}}}, {CompressedData["
1:eJxN2nnYV2P6APBzjjWGhlCo9BLJlmTtbbFF+07o1WYZW2+ZZBlMJLK3alFR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       "], Null}, {EdgeStyle -> {
         Opacity[0.4, 
          RGBColor[1, 0, 0]]}, VertexStyle -> {
         GrayLevel[0]}}]]}, 
    TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1mHk0lP///u37MmMWjG02S7YoLW9L91UUSZEkIUXahYpKWmRLJUmWKFtJ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       "], {
        {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[0.013709679228772156`], 
         ArrowBox[CompressedData["
1:eJxN2nfY19TZAOAkTrSKigwHyKsooiIqTl6Gi72HooIsrXWxijiqFsU9mTIE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          "], 
          0.07870323902309703]}, 
        {GrayLevel[0], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.07870323902309703], DiskBox[2, 0.07870323902309703], 
         DiskBox[3, 0.07870323902309703], DiskBox[4, 0.07870323902309703], 
         DiskBox[5, 0.07870323902309703], DiskBox[6, 0.07870323902309703], 
         DiskBox[7, 0.07870323902309703], DiskBox[8, 0.07870323902309703], 
         DiskBox[9, 0.07870323902309703], DiskBox[10, 0.07870323902309703], 
         DiskBox[11, 0.07870323902309703], DiskBox[12, 0.07870323902309703], 
         DiskBox[13, 0.07870323902309703], DiskBox[14, 0.07870323902309703], 
         DiskBox[15, 0.07870323902309703], DiskBox[16, 0.07870323902309703], 
         DiskBox[17, 0.07870323902309703], DiskBox[18, 0.07870323902309703], 
         DiskBox[19, 0.07870323902309703], DiskBox[20, 0.07870323902309703], 
         DiskBox[21, 0.07870323902309703], DiskBox[22, 0.07870323902309703], 
         DiskBox[23, 0.07870323902309703], DiskBox[24, 0.07870323902309703], 
         DiskBox[25, 0.07870323902309703], DiskBox[26, 0.07870323902309703], 
         DiskBox[27, 0.07870323902309703], DiskBox[28, 0.07870323902309703], 
         DiskBox[29, 0.07870323902309703], DiskBox[30, 0.07870323902309703], 
         DiskBox[31, 0.07870323902309703], DiskBox[32, 0.07870323902309703], 
         DiskBox[33, 0.07870323902309703], DiskBox[34, 0.07870323902309703], 
         DiskBox[35, 0.07870323902309703], DiskBox[36, 0.07870323902309703], 
         DiskBox[37, 0.07870323902309703], DiskBox[38, 0.07870323902309703], 
         DiskBox[39, 0.07870323902309703], DiskBox[40, 0.07870323902309703], 
         DiskBox[41, 0.07870323902309703], DiskBox[42, 0.07870323902309703], 
         DiskBox[43, 0.07870323902309703], DiskBox[44, 0.07870323902309703], 
         DiskBox[45, 0.07870323902309703], DiskBox[46, 0.07870323902309703], 
         DiskBox[47, 0.07870323902309703], DiskBox[48, 0.07870323902309703], 
         DiskBox[49, 0.07870323902309703], DiskBox[50, 0.07870323902309703], 
         DiskBox[51, 0.07870323902309703], DiskBox[52, 0.07870323902309703], 
         DiskBox[53, 0.07870323902309703], DiskBox[54, 0.07870323902309703], 
         DiskBox[55, 0.07870323902309703], DiskBox[56, 0.07870323902309703], 
         DiskBox[57, 0.07870323902309703], DiskBox[58, 0.07870323902309703], 
         DiskBox[59, 0.07870323902309703], DiskBox[60, 0.07870323902309703], 
         DiskBox[61, 0.07870323902309703], DiskBox[62, 0.07870323902309703], 
         DiskBox[63, 0.07870323902309703], DiskBox[64, 0.07870323902309703], 
         DiskBox[65, 0.07870323902309703], DiskBox[66, 0.07870323902309703], 
         DiskBox[67, 0.07870323902309703], DiskBox[68, 0.07870323902309703], 
         DiskBox[69, 0.07870323902309703], DiskBox[70, 0.07870323902309703], 
         DiskBox[71, 0.07870323902309703], DiskBox[72, 0.07870323902309703], 
         DiskBox[73, 0.07870323902309703], DiskBox[74, 0.07870323902309703], 
         DiskBox[75, 0.07870323902309703], DiskBox[76, 0.07870323902309703], 
         DiskBox[77, 0.07870323902309703], DiskBox[78, 0.07870323902309703], 
         DiskBox[79, 0.07870323902309703], DiskBox[80, 0.07870323902309703], 
         DiskBox[81, 0.07870323902309703], DiskBox[82, 0.07870323902309703], 
         DiskBox[83, 0.07870323902309703], DiskBox[84, 0.07870323902309703], 
         DiskBox[85, 0.07870323902309703], DiskBox[86, 0.07870323902309703], 
         DiskBox[87, 0.07870323902309703], DiskBox[88, 0.07870323902309703], 
         DiskBox[89, 0.07870323902309703], DiskBox[90, 0.07870323902309703], 
         DiskBox[91, 0.07870323902309703], DiskBox[92, 0.07870323902309703], 
         DiskBox[93, 0.07870323902309703], DiskBox[94, 0.07870323902309703], 
         DiskBox[95, 0.07870323902309703], DiskBox[96, 0.07870323902309703], 
         DiskBox[97, 0.07870323902309703], DiskBox[98, 0.07870323902309703], 
         DiskBox[99, 0.07870323902309703], DiskBox[100, 0.07870323902309703], 
         DiskBox[101, 0.07870323902309703], DiskBox[102, 0.07870323902309703],
          DiskBox[103, 0.07870323902309703], 
         DiskBox[104, 0.07870323902309703], DiskBox[105, 0.07870323902309703],
          DiskBox[106, 0.07870323902309703], 
         DiskBox[107, 0.07870323902309703], DiskBox[108, 0.07870323902309703],
          DiskBox[109, 0.07870323902309703], 
         DiskBox[110, 0.07870323902309703], DiskBox[111, 0.07870323902309703],
          DiskBox[112, 0.07870323902309703], 
         DiskBox[113, 0.07870323902309703], DiskBox[114, 0.07870323902309703],
          DiskBox[115, 0.07870323902309703], 
         DiskBox[116, 0.07870323902309703], DiskBox[117, 0.07870323902309703],
          DiskBox[118, 0.07870323902309703], 
         DiskBox[119, 0.07870323902309703], DiskBox[120, 0.07870323902309703],
          DiskBox[121, 0.07870323902309703], 
         DiskBox[122, 0.07870323902309703], DiskBox[123, 0.07870323902309703],
          DiskBox[124, 0.07870323902309703], 
         DiskBox[125, 0.07870323902309703], DiskBox[126, 0.07870323902309703],
          DiskBox[127, 0.07870323902309703], 
         DiskBox[128, 0.07870323902309703], DiskBox[129, 0.07870323902309703],
          DiskBox[130, 0.07870323902309703], 
         DiskBox[131, 0.07870323902309703], DiskBox[132, 0.07870323902309703],
          DiskBox[133, 0.07870323902309703], 
         DiskBox[134, 0.07870323902309703], DiskBox[135, 0.07870323902309703],
          DiskBox[136, 0.07870323902309703], 
         DiskBox[137, 0.07870323902309703], DiskBox[138, 0.07870323902309703],
          DiskBox[139, 0.07870323902309703], 
         DiskBox[140, 0.07870323902309703], DiskBox[141, 0.07870323902309703],
          DiskBox[142, 0.07870323902309703], 
         DiskBox[143, 0.07870323902309703], DiskBox[144, 0.07870323902309703],
          DiskBox[145, 0.07870323902309703], 
         DiskBox[146, 0.07870323902309703], DiskBox[147, 0.07870323902309703],
          DiskBox[148, 0.07870323902309703], 
         DiskBox[149, 0.07870323902309703], DiskBox[150, 0.07870323902309703],
          DiskBox[151, 0.07870323902309703], 
         DiskBox[152, 0.07870323902309703], DiskBox[153, 0.07870323902309703],
          DiskBox[154, 0.07870323902309703], 
         DiskBox[155, 0.07870323902309703], DiskBox[156, 0.07870323902309703],
          DiskBox[157, 0.07870323902309703], 
         DiskBox[158, 0.07870323902309703], DiskBox[159, 0.07870323902309703],
          DiskBox[160, 0.07870323902309703], 
         DiskBox[161, 0.07870323902309703], DiskBox[162, 0.07870323902309703],
          DiskBox[163, 0.07870323902309703], 
         DiskBox[164, 0.07870323902309703], DiskBox[165, 0.07870323902309703],
          DiskBox[166, 0.07870323902309703], 
         DiskBox[167, 0.07870323902309703], DiskBox[168, 0.07870323902309703],
          DiskBox[169, 0.07870323902309703], 
         DiskBox[170, 0.07870323902309703], DiskBox[171, 0.07870323902309703],
          DiskBox[172, 0.07870323902309703], 
         DiskBox[173, 0.07870323902309703], DiskBox[174, 0.07870323902309703],
          DiskBox[175, 0.07870323902309703], 
         DiskBox[176, 0.07870323902309703], DiskBox[177, 0.07870323902309703],
          DiskBox[178, 0.07870323902309703], 
         DiskBox[179, 0.07870323902309703], DiskBox[180, 0.07870323902309703],
          DiskBox[181, 0.07870323902309703], 
         DiskBox[182, 0.07870323902309703], DiskBox[183, 0.07870323902309703],
          DiskBox[184, 0.07870323902309703], 
         DiskBox[185, 0.07870323902309703], DiskBox[186, 0.07870323902309703],
          DiskBox[187, 0.07870323902309703], 
         DiskBox[188, 0.07870323902309703], DiskBox[189, 0.07870323902309703],
          DiskBox[190, 0.07870323902309703], 
         DiskBox[191, 0.07870323902309703], DiskBox[192, 0.07870323902309703],
          DiskBox[193, 0.07870323902309703], 
         DiskBox[194, 0.07870323902309703], DiskBox[195, 0.07870323902309703],
          DiskBox[196, 0.07870323902309703], 
         DiskBox[197, 0.07870323902309703], DiskBox[198, 0.07870323902309703],
          DiskBox[199, 0.07870323902309703], 
         DiskBox[200, 0.07870323902309703], DiskBox[201, 0.07870323902309703],
          DiskBox[202, 0.07870323902309703], 
         DiskBox[203, 0.07870323902309703], DiskBox[204, 0.07870323902309703],
          DiskBox[205, 0.07870323902309703], 
         DiskBox[206, 0.07870323902309703], DiskBox[207, 0.07870323902309703],
          DiskBox[208, 0.07870323902309703], 
         DiskBox[209, 0.07870323902309703], DiskBox[210, 0.07870323902309703],
          DiskBox[211, 0.07870323902309703], 
         DiskBox[212, 0.07870323902309703], DiskBox[213, 0.07870323902309703],
          DiskBox[214, 0.07870323902309703], 
         DiskBox[215, 0.07870323902309703], DiskBox[216, 0.07870323902309703],
          DiskBox[217, 0.07870323902309703], 
         DiskBox[218, 0.07870323902309703], DiskBox[219, 0.07870323902309703],
          DiskBox[220, 0.07870323902309703], 
         DiskBox[221, 0.07870323902309703], DiskBox[222, 0.07870323902309703],
          DiskBox[223, 0.07870323902309703], 
         DiskBox[224, 0.07870323902309703], DiskBox[225, 0.07870323902309703],
          DiskBox[226, 0.07870323902309703], 
         DiskBox[227, 0.07870323902309703], DiskBox[228, 0.07870323902309703],
          DiskBox[229, 0.07870323902309703], 
         DiskBox[230, 0.07870323902309703], DiskBox[231, 0.07870323902309703],
          DiskBox[232, 0.07870323902309703], 
         DiskBox[233, 0.07870323902309703], DiskBox[234, 0.07870323902309703],
          DiskBox[235, 0.07870323902309703], 
         DiskBox[236, 0.07870323902309703], DiskBox[237, 0.07870323902309703],
          DiskBox[238, 0.07870323902309703], 
         DiskBox[239, 0.07870323902309703], DiskBox[240, 0.07870323902309703],
          DiskBox[241, 0.07870323902309703], 
         DiskBox[242, 0.07870323902309703], DiskBox[243, 0.07870323902309703],
          DiskBox[244, 0.07870323902309703], 
         DiskBox[245, 0.07870323902309703], DiskBox[246, 0.07870323902309703],
          DiskBox[247, 0.07870323902309703], 
         DiskBox[248, 0.07870323902309703], DiskBox[249, 0.07870323902309703],
          DiskBox[250, 0.07870323902309703], 
         DiskBox[251, 0.07870323902309703], DiskBox[252, 0.07870323902309703],
          DiskBox[253, 0.07870323902309703], 
         DiskBox[254, 0.07870323902309703], DiskBox[255, 0.07870323902309703],
          DiskBox[256, 0.07870323902309703], 
         DiskBox[257, 0.07870323902309703], DiskBox[258, 0.07870323902309703],
          DiskBox[259, 0.07870323902309703], 
         DiskBox[260, 0.07870323902309703], DiskBox[261, 0.07870323902309703],
          DiskBox[262, 0.07870323902309703], 
         DiskBox[263, 0.07870323902309703], DiskBox[264, 0.07870323902309703],
          DiskBox[265, 0.07870323902309703], 
         DiskBox[266, 0.07870323902309703], DiskBox[267, 0.07870323902309703],
          DiskBox[268, 0.07870323902309703], 
         DiskBox[269, 0.07870323902309703], DiskBox[270, 0.07870323902309703],
          DiskBox[271, 0.07870323902309703], 
         DiskBox[272, 0.07870323902309703], DiskBox[273, 0.07870323902309703],
          DiskBox[274, 0.07870323902309703], 
         DiskBox[275, 0.07870323902309703], DiskBox[276, 0.07870323902309703],
          DiskBox[277, 0.07870323902309703], 
         DiskBox[278, 0.07870323902309703], DiskBox[279, 0.07870323902309703],
          DiskBox[280, 0.07870323902309703], 
         DiskBox[281, 0.07870323902309703], DiskBox[282, 0.07870323902309703],
          DiskBox[283, 0.07870323902309703], 
         DiskBox[284, 0.07870323902309703], DiskBox[285, 0.07870323902309703],
          DiskBox[286, 0.07870323902309703], 
         DiskBox[287, 0.07870323902309703], DiskBox[288, 0.07870323902309703],
          DiskBox[289, 0.07870323902309703], 
         DiskBox[290, 0.07870323902309703], DiskBox[291, 0.07870323902309703],
          DiskBox[292, 0.07870323902309703], 
         DiskBox[293, 0.07870323902309703], DiskBox[294, 0.07870323902309703],
          DiskBox[295, 0.07870323902309703], 
         DiskBox[296, 0.07870323902309703], DiskBox[297, 0.07870323902309703],
          DiskBox[298, 0.07870323902309703], 
         DiskBox[299, 0.07870323902309703], DiskBox[300, 0.07870323902309703],
          DiskBox[301, 0.07870323902309703], 
         DiskBox[302, 0.07870323902309703], DiskBox[303, 0.07870323902309703],
          DiskBox[304, 0.07870323902309703], 
         DiskBox[305, 0.07870323902309703], DiskBox[306, 0.07870323902309703],
          DiskBox[307, 0.07870323902309703], 
         DiskBox[308, 0.07870323902309703], DiskBox[309, 0.07870323902309703],
          DiskBox[310, 0.07870323902309703], 
         DiskBox[311, 0.07870323902309703], DiskBox[312, 0.07870323902309703],
          DiskBox[313, 0.07870323902309703], 
         DiskBox[314, 0.07870323902309703], DiskBox[315, 0.07870323902309703],
          DiskBox[316, 0.07870323902309703], 
         DiskBox[317, 0.07870323902309703], DiskBox[318, 0.07870323902309703],
          DiskBox[319, 0.07870323902309703], 
         DiskBox[320, 0.07870323902309703], DiskBox[321, 0.07870323902309703],
          DiskBox[322, 0.07870323902309703], 
         DiskBox[323, 0.07870323902309703], DiskBox[324, 0.07870323902309703],
          DiskBox[325, 0.07870323902309703], 
         DiskBox[326, 0.07870323902309703], DiskBox[327, 0.07870323902309703],
          DiskBox[328, 0.07870323902309703], 
         DiskBox[329, 0.07870323902309703], DiskBox[330, 0.07870323902309703],
          DiskBox[331, 0.07870323902309703], 
         DiskBox[332, 0.07870323902309703], DiskBox[333, 0.07870323902309703],
          DiskBox[334, 0.07870323902309703], 
         DiskBox[335, 0.07870323902309703], DiskBox[336, 0.07870323902309703],
          DiskBox[337, 0.07870323902309703], 
         DiskBox[338, 0.07870323902309703], DiskBox[339, 0.07870323902309703],
          DiskBox[340, 0.07870323902309703], 
         DiskBox[341, 0.07870323902309703], DiskBox[342, 0.07870323902309703],
          DiskBox[343, 0.07870323902309703], 
         DiskBox[344, 0.07870323902309703], DiskBox[345, 0.07870323902309703],
          DiskBox[346, 0.07870323902309703], 
         DiskBox[347, 0.07870323902309703], DiskBox[348, 0.07870323902309703],
          DiskBox[349, 0.07870323902309703], 
         DiskBox[350, 0.07870323902309703], DiskBox[351, 0.07870323902309703],
          DiskBox[352, 0.07870323902309703], 
         DiskBox[353, 0.07870323902309703], DiskBox[354, 0.07870323902309703],
          DiskBox[355, 0.07870323902309703], 
         DiskBox[356, 0.07870323902309703], DiskBox[357, 0.07870323902309703],
          DiskBox[358, 0.07870323902309703], 
         DiskBox[359, 0.07870323902309703], DiskBox[360, 0.07870323902309703],
          DiskBox[361, 0.07870323902309703], 
         DiskBox[362, 0.07870323902309703], DiskBox[363, 0.07870323902309703],
          DiskBox[364, 0.07870323902309703], 
         DiskBox[365, 0.07870323902309703], DiskBox[366, 0.07870323902309703],
          DiskBox[367, 0.07870323902309703], 
         DiskBox[368, 0.07870323902309703], DiskBox[369, 0.07870323902309703],
          DiskBox[370, 0.07870323902309703], 
         DiskBox[371, 0.07870323902309703], DiskBox[372, 0.07870323902309703],
          DiskBox[373, 0.07870323902309703], 
         DiskBox[374, 0.07870323902309703], DiskBox[375, 0.07870323902309703],
          DiskBox[376, 0.07870323902309703], 
         DiskBox[377, 0.07870323902309703], DiskBox[378, 0.07870323902309703],
          DiskBox[379, 0.07870323902309703], 
         DiskBox[380, 0.07870323902309703], DiskBox[381, 0.07870323902309703],
          DiskBox[382, 0.07870323902309703], 
         DiskBox[383, 0.07870323902309703], DiskBox[384, 0.07870323902309703],
          DiskBox[385, 0.07870323902309703], 
         DiskBox[386, 0.07870323902309703], DiskBox[387, 0.07870323902309703],
          DiskBox[388, 0.07870323902309703], 
         DiskBox[389, 0.07870323902309703], DiskBox[390, 0.07870323902309703],
          DiskBox[391, 0.07870323902309703], 
         DiskBox[392, 0.07870323902309703], DiskBox[393, 0.07870323902309703],
          DiskBox[394, 0.07870323902309703], 
         DiskBox[395, 0.07870323902309703], DiskBox[396, 0.07870323902309703],
          DiskBox[397, 0.07870323902309703], 
         DiskBox[398, 0.07870323902309703], DiskBox[399, 0.07870323902309703],
          DiskBox[400, 0.07870323902309703], 
         DiskBox[401, 0.07870323902309703], DiskBox[402, 0.07870323902309703],
          DiskBox[403, 0.07870323902309703], 
         DiskBox[404, 0.07870323902309703], DiskBox[405, 0.07870323902309703],
          DiskBox[406, 0.07870323902309703], 
         DiskBox[407, 0.07870323902309703], DiskBox[408, 0.07870323902309703],
          DiskBox[409, 0.07870323902309703], 
         DiskBox[410, 0.07870323902309703], DiskBox[411, 0.07870323902309703],
          DiskBox[412, 0.07870323902309703], 
         DiskBox[413, 0.07870323902309703], DiskBox[414, 0.07870323902309703],
          DiskBox[415, 0.07870323902309703], 
         DiskBox[416, 0.07870323902309703], DiskBox[417, 0.07870323902309703],
          DiskBox[418, 0.07870323902309703], 
         DiskBox[419, 0.07870323902309703], DiskBox[420, 0.07870323902309703],
          DiskBox[421, 0.07870323902309703], 
         DiskBox[422, 0.07870323902309703], DiskBox[423, 0.07870323902309703],
          DiskBox[424, 0.07870323902309703], 
         DiskBox[425, 0.07870323902309703], DiskBox[426, 0.07870323902309703],
          DiskBox[427, 0.07870323902309703], 
         DiskBox[428, 0.07870323902309703], DiskBox[429, 0.07870323902309703],
          DiskBox[430, 0.07870323902309703], 
         DiskBox[431, 0.07870323902309703], DiskBox[432, 0.07870323902309703],
          DiskBox[433, 0.07870323902309703], 
         DiskBox[434, 0.07870323902309703], DiskBox[435, 0.07870323902309703],
          DiskBox[436, 0.07870323902309703], 
         DiskBox[437, 0.07870323902309703], DiskBox[438, 0.07870323902309703],
          DiskBox[439, 0.07870323902309703], 
         DiskBox[440, 0.07870323902309703], DiskBox[441, 0.07870323902309703],
          DiskBox[442, 0.07870323902309703], 
         DiskBox[443, 0.07870323902309703], DiskBox[444, 0.07870323902309703],
          DiskBox[445, 0.07870323902309703], 
         DiskBox[446, 0.07870323902309703], DiskBox[447, 0.07870323902309703],
          DiskBox[448, 0.07870323902309703], 
         DiskBox[449, 0.07870323902309703], DiskBox[450, 0.07870323902309703],
          DiskBox[451, 0.07870323902309703], 
         DiskBox[452, 0.07870323902309703], DiskBox[453, 0.07870323902309703],
          DiskBox[454, 0.07870323902309703], 
         DiskBox[455, 0.07870323902309703], DiskBox[456, 0.07870323902309703],
          DiskBox[457, 0.07870323902309703], 
         DiskBox[458, 0.07870323902309703], DiskBox[459, 0.07870323902309703],
          DiskBox[460, 0.07870323902309703], 
         DiskBox[461, 0.07870323902309703], DiskBox[462, 0.07870323902309703],
          DiskBox[463, 0.07870323902309703], 
         DiskBox[464, 0.07870323902309703], DiskBox[465, 0.07870323902309703],
          DiskBox[466, 0.07870323902309703], 
         DiskBox[467, 0.07870323902309703], DiskBox[468, 0.07870323902309703],
          DiskBox[469, 0.07870323902309703], 
         DiskBox[470, 0.07870323902309703], DiskBox[471, 0.07870323902309703],
          DiskBox[472, 0.07870323902309703], 
         DiskBox[473, 0.07870323902309703], DiskBox[474, 0.07870323902309703],
          DiskBox[475, 0.07870323902309703], 
         DiskBox[476, 0.07870323902309703], DiskBox[477, 0.07870323902309703],
          DiskBox[478, 0.07870323902309703], 
         DiskBox[479, 0.07870323902309703], DiskBox[480, 0.07870323902309703],
          DiskBox[481, 0.07870323902309703], 
         DiskBox[482, 0.07870323902309703], DiskBox[483, 0.07870323902309703],
          DiskBox[484, 0.07870323902309703], 
         DiskBox[485, 0.07870323902309703], DiskBox[486, 0.07870323902309703],
          DiskBox[487, 0.07870323902309703], 
         DiskBox[488, 0.07870323902309703], DiskBox[489, 0.07870323902309703],
          DiskBox[490, 0.07870323902309703], 
         DiskBox[491, 0.07870323902309703], DiskBox[492, 0.07870323902309703],
          DiskBox[493, 0.07870323902309703], 
         DiskBox[494, 0.07870323902309703], DiskBox[495, 0.07870323902309703],
          DiskBox[496, 0.07870323902309703], 
         DiskBox[497, 0.07870323902309703], DiskBox[498, 0.07870323902309703],
          DiskBox[499, 0.07870323902309703], 
         DiskBox[500, 0.07870323902309703], DiskBox[501, 0.07870323902309703],
          DiskBox[502, 0.07870323902309703], 
         DiskBox[503, 0.07870323902309703], DiskBox[504, 0.07870323902309703],
          DiskBox[505, 0.07870323902309703], 
         DiskBox[506, 0.07870323902309703], DiskBox[507, 0.07870323902309703],
          DiskBox[508, 0.07870323902309703], 
         DiskBox[509, 0.07870323902309703], DiskBox[510, 0.07870323902309703],
          DiskBox[511, 0.07870323902309703], 
         DiskBox[512, 0.07870323902309703], DiskBox[513, 0.07870323902309703],
          DiskBox[514, 0.07870323902309703], 
         DiskBox[515, 0.07870323902309703], DiskBox[516, 0.07870323902309703],
          DiskBox[517, 0.07870323902309703], 
         DiskBox[518, 0.07870323902309703], DiskBox[519, 0.07870323902309703],
          DiskBox[520, 0.07870323902309703], 
         DiskBox[521, 0.07870323902309703], DiskBox[522, 0.07870323902309703],
          DiskBox[523, 0.07870323902309703], 
         DiskBox[524, 0.07870323902309703], DiskBox[525, 0.07870323902309703],
          DiskBox[526, 0.07870323902309703], 
         DiskBox[527, 0.07870323902309703], DiskBox[528, 0.07870323902309703],
          DiskBox[529, 0.07870323902309703], 
         DiskBox[530, 0.07870323902309703], DiskBox[531, 0.07870323902309703],
          DiskBox[532, 0.07870323902309703], 
         DiskBox[533, 0.07870323902309703], DiskBox[534, 0.07870323902309703],
          DiskBox[535, 0.07870323902309703], 
         DiskBox[536, 0.07870323902309703], DiskBox[537, 0.07870323902309703],
          DiskBox[538, 0.07870323902309703], 
         DiskBox[539, 0.07870323902309703], DiskBox[540, 0.07870323902309703],
          DiskBox[541, 0.07870323902309703], 
         DiskBox[542, 0.07870323902309703], DiskBox[543, 0.07870323902309703],
          DiskBox[544, 0.07870323902309703], 
         DiskBox[545, 0.07870323902309703], DiskBox[546, 0.07870323902309703],
          DiskBox[547, 0.07870323902309703], 
         DiskBox[548, 0.07870323902309703], DiskBox[549, 0.07870323902309703],
          DiskBox[550, 0.07870323902309703], 
         DiskBox[551, 0.07870323902309703], DiskBox[552, 0.07870323902309703],
          DiskBox[553, 0.07870323902309703], 
         DiskBox[554, 0.07870323902309703], DiskBox[555, 0.07870323902309703],
          DiskBox[556, 0.07870323902309703], 
         DiskBox[557, 0.07870323902309703], DiskBox[558, 0.07870323902309703],
          DiskBox[559, 0.07870323902309703], 
         DiskBox[560, 0.07870323902309703], DiskBox[561, 0.07870323902309703],
          DiskBox[562, 0.07870323902309703], 
         DiskBox[563, 0.07870323902309703], DiskBox[564, 0.07870323902309703],
          DiskBox[565, 0.07870323902309703], 
         DiskBox[566, 0.07870323902309703], DiskBox[567, 0.07870323902309703],
          DiskBox[568, 0.07870323902309703], 
         DiskBox[569, 0.07870323902309703], DiskBox[570, 0.07870323902309703],
          DiskBox[571, 0.07870323902309703], 
         DiskBox[572, 0.07870323902309703], DiskBox[573, 0.07870323902309703],
          DiskBox[574, 0.07870323902309703], 
         DiskBox[575, 0.07870323902309703], DiskBox[576, 0.07870323902309703],
          DiskBox[577, 0.07870323902309703], 
         DiskBox[578, 0.07870323902309703], DiskBox[579, 0.07870323902309703],
          DiskBox[580, 0.07870323902309703], 
         DiskBox[581, 0.07870323902309703], DiskBox[582, 0.07870323902309703],
          DiskBox[583, 0.07870323902309703], 
         DiskBox[584, 0.07870323902309703], DiskBox[585, 0.07870323902309703],
          DiskBox[586, 0.07870323902309703], 
         DiskBox[587, 0.07870323902309703], DiskBox[588, 0.07870323902309703],
          DiskBox[589, 0.07870323902309703], 
         DiskBox[590, 0.07870323902309703], DiskBox[591, 0.07870323902309703],
          DiskBox[592, 0.07870323902309703], 
         DiskBox[593, 0.07870323902309703], DiskBox[594, 0.07870323902309703],
          DiskBox[595, 0.07870323902309703], 
         DiskBox[596, 0.07870323902309703], DiskBox[597, 0.07870323902309703],
          DiskBox[598, 0.07870323902309703], 
         DiskBox[599, 0.07870323902309703], DiskBox[600, 0.07870323902309703],
          DiskBox[601, 0.07870323902309703], 
         DiskBox[602, 0.07870323902309703], DiskBox[603, 0.07870323902309703],
          DiskBox[604, 0.07870323902309703], 
         DiskBox[605, 0.07870323902309703], DiskBox[606, 0.07870323902309703],
          DiskBox[607, 0.07870323902309703], 
         DiskBox[608, 0.07870323902309703], DiskBox[609, 0.07870323902309703],
          DiskBox[610, 0.07870323902309703], 
         DiskBox[611, 0.07870323902309703], DiskBox[612, 0.07870323902309703],
          DiskBox[613, 0.07870323902309703], 
         DiskBox[614, 0.07870323902309703], DiskBox[615, 0.07870323902309703],
          DiskBox[616, 0.07870323902309703], 
         DiskBox[617, 0.07870323902309703], DiskBox[618, 0.07870323902309703],
          DiskBox[619, 0.07870323902309703], 
         DiskBox[620, 0.07870323902309703], DiskBox[621, 0.07870323902309703],
          DiskBox[622, 0.07870323902309703], 
         DiskBox[623, 0.07870323902309703], DiskBox[624, 0.07870323902309703],
          DiskBox[625, 0.07870323902309703], 
         DiskBox[626, 0.07870323902309703], DiskBox[627, 0.07870323902309703],
          DiskBox[628, 0.07870323902309703], 
         DiskBox[629, 0.07870323902309703], DiskBox[630, 0.07870323902309703],
          DiskBox[631, 0.07870323902309703], 
         DiskBox[632, 0.07870323902309703], DiskBox[633, 0.07870323902309703],
          DiskBox[634, 0.07870323902309703], 
         DiskBox[635, 0.07870323902309703], DiskBox[636, 0.07870323902309703],
          DiskBox[637, 0.07870323902309703], 
         DiskBox[638, 0.07870323902309703], DiskBox[639, 0.07870323902309703],
          DiskBox[640, 0.07870323902309703], 
         DiskBox[641, 0.07870323902309703], DiskBox[642, 0.07870323902309703],
          DiskBox[643, 0.07870323902309703], 
         DiskBox[644, 0.07870323902309703], DiskBox[645, 0.07870323902309703],
          DiskBox[646, 0.07870323902309703], 
         DiskBox[647, 0.07870323902309703], DiskBox[648, 0.07870323902309703],
          DiskBox[649, 0.07870323902309703], 
         DiskBox[650, 0.07870323902309703], DiskBox[651, 0.07870323902309703],
          DiskBox[652, 0.07870323902309703], 
         DiskBox[653, 0.07870323902309703], DiskBox[654, 0.07870323902309703],
          DiskBox[655, 0.07870323902309703], 
         DiskBox[656, 0.07870323902309703], DiskBox[657, 0.07870323902309703],
          DiskBox[658, 0.07870323902309703], 
         DiskBox[659, 0.07870323902309703], DiskBox[660, 0.07870323902309703],
          DiskBox[661, 0.07870323902309703], 
         DiskBox[662, 0.07870323902309703], DiskBox[663, 0.07870323902309703],
          DiskBox[664, 0.07870323902309703], 
         DiskBox[665, 0.07870323902309703], DiskBox[666, 0.07870323902309703],
          DiskBox[667, 0.07870323902309703], 
         DiskBox[668, 0.07870323902309703], DiskBox[669, 0.07870323902309703],
          DiskBox[670, 0.07870323902309703], 
         DiskBox[671, 0.07870323902309703], DiskBox[672, 0.07870323902309703],
          DiskBox[673, 0.07870323902309703], 
         DiskBox[674, 0.07870323902309703], DiskBox[675, 0.07870323902309703],
          DiskBox[676, 0.07870323902309703], 
         DiskBox[677, 0.07870323902309703], DiskBox[678, 0.07870323902309703],
          DiskBox[679, 0.07870323902309703], 
         DiskBox[680, 0.07870323902309703], DiskBox[681, 0.07870323902309703],
          DiskBox[682, 0.07870323902309703], 
         DiskBox[683, 0.07870323902309703], DiskBox[684, 0.07870323902309703],
          DiskBox[685, 0.07870323902309703], 
         DiskBox[686, 0.07870323902309703], DiskBox[687, 0.07870323902309703],
          DiskBox[688, 0.07870323902309703], 
         DiskBox[689, 0.07870323902309703], DiskBox[690, 0.07870323902309703],
          DiskBox[691, 0.07870323902309703], 
         DiskBox[692, 0.07870323902309703], DiskBox[693, 0.07870323902309703],
          DiskBox[694, 0.07870323902309703], 
         DiskBox[695, 0.07870323902309703], DiskBox[696, 0.07870323902309703],
          DiskBox[697, 0.07870323902309703], 
         DiskBox[698, 0.07870323902309703], DiskBox[699, 0.07870323902309703],
          DiskBox[700, 0.07870323902309703], 
         DiskBox[701, 0.07870323902309703], DiskBox[702, 0.07870323902309703],
          DiskBox[703, 0.07870323902309703], 
         DiskBox[704, 0.07870323902309703], DiskBox[705, 0.07870323902309703],
          DiskBox[706, 0.07870323902309703], 
         DiskBox[707, 0.07870323902309703], DiskBox[708, 0.07870323902309703],
          DiskBox[709, 0.07870323902309703], 
         DiskBox[710, 0.07870323902309703]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Input",ImageCache->GraphicsData["CompressedBitmap", \
"\<\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\
\>", "ImageResolution" -> \
120.],ExpressionUUID->"21c6d58e-07d4-4ca7-9022-0f723005966b"],

Cell[BoxData[
 RowBox[{
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 0}, {1, 1, 1, 0, 1}, {0, 1, 0, 1, 
        1}, {1, 1, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 
        1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 
        1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {
        0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 
        1, 1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 
        1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1,
         1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}, {{0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 
        1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0,
         1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}}}, {{{1, 2}, {2, 3}, {3, 4}, {4, 
        5}, {5, 6}}, Null}, {EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{0, 0, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 
           1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 
           0}, {0, 1, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0, 
             0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0}, {
             1, 1, 1, 1, 0, 0}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 0, 0, 1, 0}, {0, 1, 
           1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 
           1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0, 
             0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0}, {
             1, 1, 1, 1, 0, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 1, 1}, {1, 1, 1, 
           1, 0}, {1, 1, 1, 0, 1}, {0, 1, 0, 1, 1}, {1, 1, 1, 1, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 0, 0, 1}, {1, 0, 1, 0, 0}, {0, 0, 0, 1, 0}, {0, 0, 
             0, 0, 1}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 0, 1, 1}, {0, 1, 
           1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 
           1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0}} -> Graphics[
            Raster[{{1, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0, 
             0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0}, {
             1, 1, 0, 1, 0, 0}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 0, 0, 0, 0}, {0, 1, 
           1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 
           1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0, 
             0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0}, {
             1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 0, 0, 1, 1}, {0, 1, 
           1, 1, 1, 1}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 
           1, 1}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0, 
             0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0}, {
             1, 1, 1, 1, 0, 0}}, {{0, 0}, {6, 7}}, {0, 1}], Frame -> 
            Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}]}}]]}, 
     TagBox[
      GraphicsGroupBox[
       GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {0., 2.}, {0., 1.}, {
        0., 0.}}, {
         {RGBColor[1, 0, 0], Opacity[0.4], Arrowheads[Medium], 
          ArrowBox[{1, 2}, 0.043048128342245986`], 
          ArrowBox[{2, 3}, 0.043048128342245986`], 
          ArrowBox[{3, 4}, 0.043048128342245986`], 
          ArrowBox[{4, 5}, 0.043048128342245986`], 
          ArrowBox[{5, 6}, 0.043048128342245986`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{0, 0, 0, 0, 1}, {1, 0, 1, 0, 0}, {0, 0, 0, 1, 0}, {0, 
             0, 0, 0, 1}, {0, 0, 0, 0, 0}}, {{0, 0}, {5, 5}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 1, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           GraphicsBox[
            RasterBox[{{1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0,
              0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 
             0}, {1, 1, 1, 1, 1, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 2, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0,
              0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 
             0}, {1, 1, 1, 1, 0, 1}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 3, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0,
              0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 
             0}, {1, 1, 1, 1, 0, 0}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 4, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0,
              0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 
             0}, {1, 1, 1, 1, 0, 0}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 5, 
           Automatic, {0.08609625668449197, 0.08609625668449197}], InsetBox[
           
           GraphicsBox[
            RasterBox[{{1, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 0,
              0}, {1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 
             0}, {1, 1, 0, 1, 0, 0}}, {{0, 0}, {6, 7}}, {0, 1}],
            Frame->Automatic,
            FrameLabel->{None, None},
            FrameTicks->{{None, None}, {None, None}},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            ImageSize->15,
            
            Method->{
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], 6, 
           Automatic, {0.08609625668449197, 0.08609625668449197}]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   ImageSize->{150.32166964567355`, Automatic}], 
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 0}, {1, 1, 1, 0, 1}, {0, 1, 0, 1, 
        1}, {1, 1, 1, 1, 0}}, {{0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 
        1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 1, 
        0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {0, 
        1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 1, 
        1, 0}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1}, {
        0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1}, {0, 1, 1, 
        1, 1, 1}, {0, 0, 1, 0, 0, 0}}, {{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1,
         1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 
        1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}}, {{0, 0, 1, 0, 0,
         0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 
        1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 
        0, 0}}}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}, Null}, {EdgeStyle -> {
          Opacity[0.4, 
           RGBColor[1, 0, 0]]}, GraphLayout -> "LayeredDigraphEmbedding", 
        ImageSize -> Large, 
        VertexShape -> {{{0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 
           1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {0, 
           1, 1, 1, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 0}} -> Graphics[
            
            Raster[{{1, 1, 0, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 1, 0, 1,
              0, 0, 1}, {1, 0, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1, 1}, {1, 0, 
             0, 0, 0, 0, 1}, {1, 1, 0, 1, 1, 1, 1}}, {{0, 0}, {7, 7}}, {0, 
             1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{0, 0, 1, 0, 0, 0, 0}, {0, 
           1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1, 0}, {
           0, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 
           0}} -> Graphics[
            
            Raster[{{1, 0, 0, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 1, 0, 1,
              0, 0, 1}, {1, 0, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1, 1}, {1, 0, 
             0, 0, 0, 0, 1}, {1, 1, 0, 1, 1, 1, 1}}, {{0, 0}, {7, 7}}, {0, 
             1}], Frame -> Automatic, FrameLabel -> {None, None}, 
            FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
            Directive[
              GrayLevel[0.5, 0.4]], ImageSize -> 15, 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, 
              "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
              "DefaultPlotStyle" -> Automatic}], {{1, 1, 1, 1, 1}, {1, 1, 1, 
           1, 0}, {1, 1, 1, 0, 1}, {0, 1, 0, 1, 1}, {1, 1, 1, 1, 0}} -> 
          Graphics[
            
            Raster[{{0, 0, 0, 0, 1}, {1, 0, 1, 0, 0}, {0, 0, 0, 