(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       146,          7]
NotebookDataLength[    397418,      10136]
NotebookOptionsPosition[    381478,       9651]
NotebookOutlinePosition[    386402,       9769]
CellTagsIndexPosition[    386359,       9766]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" Propositional Logic", "Title",
 CellMargins->{{19, 3}, {5, 20}},
 CellChangeTimes->{{3.799765746937962*^9, 3.7997658053012223`*^9}},
 TextAlignment->Center,
 ExpressionUUID -> "6cb20f7e-299e-4e99-9346-ac3403d4c2d6"],

Cell["Definitions", "Subtitle",
 CellMargins->{{27, Inherited}, {5, 2}},
 CellChangeTimes->{{3.7997658109044065`*^9, 3.799765820915303*^9}},
 TextAlignment->Center,ExpressionUUID->"0f65e2dc-4b4a-41c3-a397-1fa8fed19ec0"],

Cell["Vojt\[EHacek]ch Bart\[IAcute]k, March 2023", "Subsubtitle",
 CellChangeTimes->{{3.8884280806952953`*^9, 3.8884280903041654`*^9}},
 TextAlignment->Center,
 ExpressionUUID -> "929b7712-8eae-4c9f-add6-f41a9d485019"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Name", ":", " ", "PropositionalLogic"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Title", ":", " ", 
     RowBox[{"Propositional", " ", "Logic"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Author", ":", " ", 
     RowBox[{"Vojt\[EHacek]ch", " ", "Bart\[IAcute]k"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Summary", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Context", ":", " ", "PropositionalLogic`"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Package", " ", 
     RowBox[{"Version", ":", " ", "final"}]}], ",", " ", 
    RowBox[{"March", " ", "2023"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Mathematica", " ", "Version"}], ":", " ", 
    RowBox[{"Mathematica", " ", "12.2"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"History", ":", " ", 
     RowBox[{
     "First", " ", "version", " ", "was", " ", "created", " ", "in", " ", 
      "Mathematica", " ", "2.2", ".1", " ", "in", " ", 
      RowBox[{"1994", "--"}], "1995", " ", "when", " ", "the", " ", "author", 
      " ", "teached", " ", "propositional", " ", "logic", " ", "at", " ", 
      "Faculty", " ", "of", " ", "Electricity", " ", "of", " ", "Czech", " ", 
      "Technical", " ", "University", " ", "in", " ", 
      RowBox[{"Prague", ".", " ", "In"}], " ", "2019", " ", "and", " ", 
      "2020", " ", "this", " ", "first", " ", "version", " ", "was", " ", 
      "translated", " ", "and", " ", "to", " ", "Mathematica", " ", "8.0", 
      " ", "and", " ", "expanded", " ", "using", " ", "the", " ", "package", 
      " ", "\"\<Notation\>\"", " ", "and", " ", "graphic", " ", "functions", 
      " ", "not", " ", "available", " ", "in", " ", "version", " ", "2.2", 
      RowBox[{".1", ".", " ", "The"}], " ", "present", " ", "version", " ", 
      "is", " ", "only", " ", "an", " ", "adaptation", " ", "to", " ", 
      "Mathematica", " ", "12.2", " ", "of", " ", "the", " ", "version", " ", 
      "for", " ", "Mathematica", " ", 
      RowBox[{"8.0", "."}]}]}]}], "*)"}]}]], "Input",
 CellMargins->{{19, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.8191249213914433`*^9, 3.819124944451668*^9}, {
  3.819125340081794*^9, 3.8191253475636387`*^9}, {3.8884280257096195`*^9, 
  3.888428035019362*^9}},
 ExpressionUUID -> "123e4cb9-28ee-46a8-beb7-ebaafbcab265"],

Cell[CellGroupData[{

Cell["BeginPackage", "Section",
 CellMargins->{{17.2, 10.}, {5., 10.}},
 CellChangeTimes->{{3.713190917873905*^9, 3.7131909208039093`*^9}, 
   3.713894110988794*^9},
 FontFamily->"Arial",
 FontSize->18,ExpressionUUID->"de40361c-d880-4743-8310-b229ff40004a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginPackage", "[", 
   RowBox[{"\"\<PropositionalLogic`\>\"", ",", 
    RowBox[{"{", "\"\<Notation`\>\"", "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{
    RowBox[{"Unset", "::", "norep"}], ",", 
    StyleBox[
     RowBox[{"Notation", "::", "noexbtag"}], "MessageName"]}], "]"}], 
  ";"}]}], "Input",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 InitializationCell->True,
 CellChangeTimes->{{3.7146619947336407`*^9, 3.714662020033676*^9}, {
  3.714662124663823*^9, 3.714662156093867*^9}, {3.714662212403946*^9, 
  3.7146622316239724`*^9}, {3.715576197963747*^9, 3.7155762467038155`*^9}, {
  3.724078983135993*^9, 3.724078985185996*^9}},
 ExpressionUUID -> "c7394c7d-b310-4ac6-baed-aa5edd099f70"],

Cell["Usage", "Subsection",
 CellMargins->{{18.8, 3.}, {8., 12.}},
 CellChangeTimes->{{3.7134443641257467`*^9, 
  3.7134443780657663`*^9}},ExpressionUUID->"2c37c89f-f20d-4d0d-b36e-\
40c45e39a2f2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"PropositionalLogic", "::", "usage"}], "=", " ", 
  "\[IndentingNewLine]", 
  "\"\<Defines non-system logical connectives, admissible logical variables, \
logical strings representing logical formulae in Polish (prefix) notation, \
conversions between them, and many functions operating on logical formulae \
and their sets, such as a \n   function computing the truth table, functions \
converting logical formulae to conjunctive and disjunctive normal forms, \
functions computing resolvents and sequences of resolvents of a set of \
clauses, a function realizing as a table simple resolution algorithms \
suitable for the manual verification of the satisfiability of a set of \
clauses,\n   and a function realizing the algorithm described in Anthony \
Galton`s book Logic for Information Technology (John Wiley & Sons, 1990, \
pp.104-105) and finding and printing a \n   refutation tree if the set of \
clauses is not satisfiable.\>\""}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.845011315680153*^9, 3.8450115738546324`*^9}, {
  3.8450116235556955`*^9, 
  3.8450117488454685`*^9}},ExpressionUUID->"ab5d375c-2482-438e-860b-\
4886f7a81d7b"],

Cell[CellGroupData[{

Cell["Logical Connectives ", "Subsubsection",
 CellMargins->{{19, 3}, {2, 10}},
 CellChangeTimes->{{3.7153471853992233`*^9, 3.71534723302929*^9}, {
  3.715347508849676*^9, 3.715347516239687*^9}, {3.715347641769862*^9, 
  3.7153476552298813`*^9}, {3.7153477217099743`*^9, 
  3.7153477411100016`*^9}},ExpressionUUID->"44609d52-c4b3-42f7-8bf1-\
0517bfcc51c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Logical", " ", "Connectives"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AND", "::", "usage"}], "=", 
     "\"\<Logical connective with obvious meaning and with infix notation x \
\[And] y\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"EQUIV", "::", "usage"}], "=", 
     "\"\<Logical connective with obvious meaning and with infix notation x \
\[Equivalent] y.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"IMPLIES", "::", "usage"}], "=", 
     "\"\<Logical connective with obvious meaning and with infix notation x \
\[Implies] y.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"NAND", "::", "usage"}], "=", 
     "\"\<NAND[x,y] = True iff AND[x,y] = False. Infix notation x \[UpArrow] \
y\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"NOR", "::", "usage"}], "=", 
     "\"\<NOR[x,y] = True iff OR[x,y] = False. Infix notation x \[DownArrow] \
y\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"NOT", "::", "usage"}], "=", 
     "\"\<Logical connective with obvious meaning and with prefix notation @\
\[VeryThinSpace]x\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"OR", "::", "usage"}], "=", 
     "\"\<Logical connective with obvious meaning and with infix notation x \
\[Or] y.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"XOR", "::", "usage"}], "=", 
     "\"\<XOR[x,y] = True iff exactly one of x and y is True. Infix notation \
x \[CirclePlus] y\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Connectives", "::", "usage"}], "=", 
     "\"\<List of all connectives.\>\""}], ";"}]}]}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{3.800125308555105*^9},
 ExpressionUUID -> "edc8d8f5-7510-40a7-b632-29a6a694060b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Logical Variables, Formulae, Strings and Conversions and their Conversions\
\>", "Subsubsection",
 CellMargins->{{19, 3}, {2, 10}},
 CellChangeTimes->{{3.7153471853992233`*^9, 3.71534723302929*^9}, {
  3.715347508849676*^9, 3.715347516239687*^9}, {3.715347641769862*^9, 
  3.7153476552298813`*^9}, {3.7153477217099743`*^9, 3.7153477660200367`*^9}, {
  3.715350441198785*^9, 
  3.715350533548914*^9}},ExpressionUUID->"5a37376f-fb0c-4800-9ff0-\
7226a22cedf3"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Logical", " ", "Variables"}], ",", " ", "Formulae", ",", " ", 
   RowBox[{
   "Strings", " ", "and", " ", "Conversions", " ", "and", " ", "their", " ", 
    "Conversions"}]}], " ", "*)"}]], "Input",
 CellMargins->{{19, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.721938012127198*^9, 3.7219380277572203`*^9}},
 ExpressionUUID -> "29c19dd0-f0c4-4db9-a3df-820968f16aae"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FALSE", "::", "usage"}], "=", " ", 
   "\"\<Unsatisfiable formula.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446233514369*^9, 3.7134462743744264`*^9}, {3.7134463191544886`*^9, 
   3.713446394064594*^9}, {3.713446456764682*^9, 3.7134464589146843`*^9}, 
   3.7139846743986607`*^9, {3.7152677929223795`*^9, 3.7152678207924194`*^9}, {
   3.71526789762253*^9, 3.7152679029175377`*^9}, {3.715268075232785*^9, 
   3.715268117057845*^9}, {3.7152681479228897`*^9, 3.715268163182912*^9}, {
   3.7152682576230483`*^9, 3.7152682847830873`*^9}, {3.7152683609931965`*^9, 
   3.7152684140057726`*^9}, {3.7153259566118736`*^9, 
   3.7153259615018806`*^9}, {3.7153479546003003`*^9, 3.7153479747103286`*^9}, 
   3.715348142070563*^9},
 ExpressionUUID -> "7b4f5fbc-2f7d-4197-af98-5776e0c73cc7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "::", "usage"}], " ", "=", "\[IndentingNewLine]", 
   "\"\<LAtomQ[x] tests whether x is a logical variable. Admissible are \
letters of the English alphabet, symbols consisting of a single letter and \
digits, and single letters subscripted with a natural number.\>\""}], 
  ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.800038693197414*^9, 3.8000387026811476`*^9}, 
   3.8000388162414494`*^9},
 ExpressionUUID -> "a6fadcd3-fd0a-46cc-b7bc-133af97d634c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "::", "usage"}], "=", 
   "\"\<LFormulaQ[x] tests whether x is a logical formula. FALSE, TRUE and \
Hold[x], HoldForm[x], where x is a logical formula, are also logical \
formulae.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "5db98312-420c-43dc-a00e-e3e168b980a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LStringQ", "::", "usage"}], "=", 
   "\"\<LStringQ[x,Trace->False] tests whether x is a logical string, i.e. a \
logical formula in the Polish (prefix) notation. With the option Trace->True \
it also prints the list of steps to the result.\>\""}], ";"}]], "Input",
 CellMargins->{{19, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.7225846319375143`*^9, 3.722584670287568*^9}},
 ExpressionUUID -> "3a4816a1-fd21-4e10-83e5-515e6800ab57"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LVariableSet", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<LVariableSet[x] extractes all logical variables from logical formula \
or set of logical formulae x.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446233514369*^9, 3.7134462743744264`*^9}, {3.7134463191544886`*^9, 
   3.713446394064594*^9}, {3.713446456764682*^9, 3.7134464589146843`*^9}, 
   3.7139846743986607`*^9, {3.7152677929223795`*^9, 3.7152678207924194`*^9}, {
   3.71526789762253*^9, 3.7152679029175377`*^9}, {3.715268075232785*^9, 
   3.715268117057845*^9}, {3.7152681479228897`*^9, 3.715268163182912*^9}, {
   3.7152682576230483`*^9, 3.7152682847830873`*^9}, {3.7152683609931965`*^9, 
   3.7152684140057726`*^9}, {3.7153259566118736`*^9, 
   3.7153259615018806`*^9}, {3.7153479546003003`*^9, 3.7153479747103286`*^9}},
 ExpressionUUID -> "93fb49db-36a2-4b95-8630-54dcb5381784"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToLFormula", "::", "usage"}], " ", "=", "\[IndentingNewLine]", 
   "\"\<ToLFormula[x,Trace->False] returns a corresponding logical formula, \
if x is a logical string, i.e. logical formula in the Polish notation, or \
$Failed in the opposite case. With the option Trace->True it also prints the \
list of steps to the result.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 Evaluatable->True,
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446233514369*^9, 3.7134462743744264`*^9}, {3.7134463191544886`*^9, 
   3.713446394064594*^9}, {3.713446456764682*^9, 3.7134464589146843`*^9}, {
   3.7139846743986607`*^9, 3.7139849422290354`*^9}, {3.713985032089161*^9, 
   3.713985066449209*^9}, {3.713985113909276*^9, 3.7139854244097104`*^9}, {
   3.7139854570297565`*^9, 3.713985516189839*^9}, 3.7139856631600447`*^9, {
   3.713985711660113*^9, 3.7139857124701138`*^9}, {3.713985765420188*^9, 
   3.713985822050267*^9}, {3.71398588104035*^9, 3.7139858828803525`*^9}, {
   3.713986137680709*^9, 3.7139862259608326`*^9}, {3.7139863669310303`*^9, 
   3.7139865214712467`*^9}, {3.7139865860213366`*^9, 
   3.7139866170813804`*^9}, {3.713986703891502*^9, 3.7139868285716763`*^9}, {
   3.713986918211802*^9, 3.7139869228818083`*^9}, {3.7139870785620265`*^9, 
   3.713987079272027*^9}, {3.7140618586596766`*^9, 3.714061892749724*^9}, {
   3.714061936769786*^9, 3.7140620625299616`*^9}, 3.7140620967100096`*^9, {
   3.714663224052563*^9, 3.7146632544426055`*^9}},
 ExpressionUUID -> "73cbcd0a-ab08-4d3d-94cd-d59557978f12"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToLString", "::", "usage"}], "=", 
   "\"\<ToLString[x,Trace->False] returns a corresponding logical string, if \
x is a logical formula, or $Failed in the opposite case. With the option \
Trace->True it also prints the list of steps to the result.\>\""}], 
  ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 Evaluatable->True,
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446233514369*^9, 3.7134462743744264`*^9}, {3.7134463191544886`*^9, 
   3.713446394064594*^9}, {3.713446456764682*^9, 3.7134464589146843`*^9}, {
   3.7139846743986607`*^9, 3.7139849422290354`*^9}, {3.713985032089161*^9, 
   3.713985066449209*^9}, {3.713985113909276*^9, 3.7139854244097104`*^9}, {
   3.7139854570297565`*^9, 3.713985516189839*^9}, 3.7139856631600447`*^9, {
   3.713985711660113*^9, 3.7139857124701138`*^9}, {3.713985765420188*^9, 
   3.713985822050267*^9}, {3.71398588104035*^9, 3.7139858828803525`*^9}, {
   3.713986137680709*^9, 3.7139862259608326`*^9}, {3.7139863669310303`*^9, 
   3.7139865214712467`*^9}, {3.7139865860213366`*^9, 
   3.7139866070313663`*^9}, {3.713986861781723*^9, 3.713987094682049*^9}, {
   3.7139874126624937`*^9, 3.713987439042531*^9}, {3.71406214674008*^9, 
   3.7140621664401073`*^9}, 3.7146629350921583`*^9},
 ExpressionUUID -> "5aec3dec-9fa0-454f-aa80-a66a8010f572"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TRUE", "::", "usage"}], " ", "=", " ", 
   "\"\<Always true formula.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446233514369*^9, 3.7134462743744264`*^9}, {3.7134463191544886`*^9, 
   3.713446394064594*^9}, {3.713446456764682*^9, 3.7134464589146843`*^9}, 
   3.7139846743986607`*^9, {3.7152677929223795`*^9, 3.7152678207924194`*^9}, {
   3.71526789762253*^9, 3.7152679029175377`*^9}, {3.715268075232785*^9, 
   3.715268117057845*^9}, {3.7152681479228897`*^9, 3.715268163182912*^9}, {
   3.7152682576230483`*^9, 3.7152682847830873`*^9}, {3.7152683609931965`*^9, 
   3.7152684140057726`*^9}, {3.7153259566118736`*^9, 
   3.7153259615018806`*^9}, {3.7153479546003003`*^9, 3.7153479747103286`*^9}, 
   3.715348142070563*^9},
 ExpressionUUID -> "0d56df82-1238-43c8-92c3-acf0822fc1c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions ", "Subsubsection",
 CellMargins->{{19, 3}, {2, 10}},
 CellChangeTimes->{{3.7153471853992233`*^9, 3.71534723302929*^9}, {
  3.715347508849676*^9, 3.715347516239687*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"7df8d4e4-a6ec-428e-b932-c5c4adcb9d9c"],

Cell[BoxData[
 RowBox[{"(*", " ", "Functions", " ", "*)"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 CellChangeTimes->{{3.7219380576772623`*^9, 3.721938064937272*^9}},
 ExpressionUUID -> "24e496f8-7b35-4c24-895c-10dd516fd157"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BT", "::", "usage"}], "=", 
   "\"\<Head of vertices of a binary tree.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BTreeQ", "::", "usage"}], "=", " ", 
   "\"\<Defines binary tree.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BTreeForm", "::", "usage"}], "=", " ", 
   "\"\<Outputs binary tree in a convenient graphic form. It has the \
following options (default value = the first alternative):\nThere are the \
following options (default value = the first alternative):\n- RootPosition -> \
Right|Left|Top|Bottom,\n- TableSpacing -> Automatic|{nonnegative integer, \
nonnegative integer},\n- Format -> List|TreePlot|TableForm.\>\""}], 
  ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakAbove->False,
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "664755d4-b989-49a0-91d8-e45eee6ffc08"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ClauseQ", "::", "usage"}], "=", 
   "\"\<Tests whether the expression is clause or not.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "14f6d2fc-4e07-44ce-ab1b-0ef891361530"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CNF", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<CNF[x,type] converts the logical formula x to a minimal conjunctive \
normal form in the case type = Minimal|0 and to the complete conjunctive \
normal form in the case type = Complete|1. In the case type = Minimal|0 the \
system function BooleanConvert is used.\nAttributes[CNF] = {Listable}.\>\""}],
   ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "715303d1-80b9-4d2b-9890-0fef2fe5e570"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertFormula", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<ConvertFormula[x, form] uses system function BooleanConvert[#,form]& \
and finds a formula y tautologically equivalent to x and containing only \
connectives determined by the argument form: \n- if form is \\\"AND\\\", \
formula y contains only connectives AND and NOT,\n- if form is \\\"OR\\\", \
formula y contains only connectives OR and NOT,\n- if form is \
\\\"IMPLIES\\\", formula y contains only connectives IMPLIES and NOT,\n- if \
form is \\\"NAND\\\", formula y contains only connectives NAND and NOT,\n- if \
form is \\\"NOR\\\", formula y contains only connectives NOR and NOT,\n- if \
form is \\\"XOR\\\", formula y contains only connectives XOR, AND and NOT.\n\
Attributes[ConvertFormula] = {Listable}.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "736bfe02-9fb2-40bf-a513-7fd87c90dcb1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DNF", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<DNF[x,type] converts the logical formula x to a minimal disjunctive \
normal form in the case type = Minimal|0 and to the complete disjunctive \
normal form in the case type = Complete|1. In the case type = Minimal|0 the \
system function BooleanConvert is used.\nAttributes[DNF] = {Listable}.\>\""}],
   ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "872bdf44-3fd1-4926-a255-77d90e3cbdcd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EmptyTruthTable", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<EmptyTruthTable[x,options] is a version of TruthTable with no \
truth-values for formulas.\nThere are the following options (default value = \
the first alternative):\n- BooleanValues -> {0,1}|{False,True}|{FalseSymbol, \
TrueSymbol},\n- ReverseValues -> False|True,\n- ItemSize -> Automatic|Full|as \
for Grid,\n- Labels -> None|Automatic|list of sufficient length,\n- Print -> \
False|True,\n- TableBreaks -> None|integer > 1|increasing list of integers > \
1,        \n- Transpose -> False|True.\nItemSize is an option of Grid and \
Transpose is an option of List, Matrix and Tensor.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 TextAlignment->Left,
 ExpressionUUID -> "f6abc4a7-de8e-4526-a977-f742f5a3a7b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FullResolutionSequence", "::", "usage"}], "=", 
   "\"\<FullResolutionSequence[x, options], where x is a list of clauses, \
returns a finite sequence x, R[1,x], R[2,x], R[3,x],..., R[n,x], where R[k,x] \
is the list of all resolvents generated from clauses in the list \
Join[x,R[1,x],...,R[k-1,x]] and satisfying certain condition determined by \
options Reduce and Rules. The last member is either empty or contains FALSE. \
In the case Rules -> True the output contains also certain rules that are \
generated and applied before each step R[k,x] in order to reduce the number \
of clauses and to find truth values for logical variables in case the list x \
is satisfiable. In general case, however, the rules found may not be \
sufficient to transform all the formulae from x to True.\nThere are the \
following options (default value = the first alternative):\n- Print -> \
True|False,\n- Reduce -> True|False,\n- Rules -> True|False,\n- Sort -> \
Union|DeleteDuplicates|False,\n- Variables -> All|list of logical \
variables.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "4f1bc174-0134-44a0-98ea-37c106e19c9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HList", "::", "usage"}], " ", "=", "\[IndentingNewLine]", 
   "\"\<HList[x,y,z,...] and HList[{x,y,z,...}] return list of all arguments \
x,y,z,... wrapped in HoldForm.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713444708196228*^9, 3.7134447082062283`*^9}, {
   3.713444860146441*^9, 3.7134449653965883`*^9}, {3.713445496977332*^9, 
   3.7134455706574354`*^9}, {3.713445901979901*^9, 3.7134459203799267`*^9}, {
   3.713446107250188*^9, 3.713446113150196*^9}, {3.713981469854174*^9, 
   3.7139814893942013`*^9}, {3.713981522734248*^9, 3.713981610994372*^9}, {
   3.7139816443544188`*^9, 3.7139817223445272`*^9}, {3.7139819953449097`*^9, 
   3.7139819957149105`*^9}, {3.713982182485172*^9, 3.713982182975172*^9}, {
   3.714328029148309*^9, 3.714328035558318*^9}, {3.7153223664168477`*^9, 
   3.715322422896927*^9}, {3.715322453276969*^9, 3.715322455336972*^9}, 
   3.719667681784121*^9},
 ExpressionUUID -> "7396f904-e592-473d-97d5-4d1737257b07"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LEquivalentQ", "::", "usage"}], "=", 
   "\"\<LEquivalentQ[x,y] tests whether the logical formulae x and y are \
tautologically equivalent.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LTautologyQ", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<LTautologyQ[x] tests whether the logical formula is a tautology.\n\
Attributes[LTautologyQ] = {Listable}.\>\""}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446477744711*^9, 3.7134464863247232`*^9}, {3.7134465172947664`*^9, 
   3.7134465483048096`*^9}, {3.7134465924748716`*^9, 3.713446640294938*^9}, {
   3.713446682694998*^9, 3.713446740535079*^9}, {3.713446790765149*^9, 
   3.713446872615264*^9}, {3.7134469140053215`*^9, 3.7134469702254004`*^9}, {
   3.7134470466755075`*^9, 3.7134470764355493`*^9}, 3.713447232465768*^9, 
   3.713447847606629*^9, {3.7134479251567373`*^9, 3.7134479511367736`*^9}, {
   3.7153490726818657`*^9, 3.715349081451878*^9}, {3.716276332857757*^9, 
   3.71627634193777*^9}},
 ExpressionUUID -> "addf681d-b31c-4d24-ad15-52cdea3178ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LiteralQ", "::", "usage"}], "=", 
   "\"\<LiteralQ[x]tests whether x is a literal, i.e. a logical variable or \
negative of a logical variable.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446477744711*^9, 3.7134464863247232`*^9}, {3.7134465172947664`*^9, 
   3.7134465483048096`*^9}, {3.7134465924748716`*^9, 3.713446640294938*^9}, {
   3.713446682694998*^9, 3.713446740535079*^9}, {3.713446790765149*^9, 
   3.713446872615264*^9}, {3.7134469140053215`*^9, 3.7134469702254004`*^9}, {
   3.7134470466755075`*^9, 3.7134470764355493`*^9}, 3.713447232465768*^9, 
   3.713447847606629*^9, {3.7134479251567373`*^9, 3.7134479511367736`*^9}, {
   3.7153490726818657`*^9, 3.715349081451878*^9}, {3.716276332857757*^9, 
   3.716276508528003*^9}},
 ExpressionUUID -> "b29ad5e4-4e8b-4657-a2e9-5f4c9a0ae185"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NormalizeLString", "::", "usage"}], "=", 
   "\"\<Reduces all substrings NOT@, ~AND~, ~EQUIV~, ~IMPLIES~, ~NAND~, \
~NOR~, ~OR~, ~XOR~ to corresponding string forms of logical symbols and all \
sequences of any types of spaces in string to one RawSpace.\>\""}], 
  ";"}]], "Input",
 CellMargins->{{19, 10}, {5, 10}},
 ExpressionUUID -> "a823b4c9-fdb0-4802-845c-747c0d339e1c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReduceSpaces", "::", "usage"}], "=", 
   "\"\<Reduces each sequence of any types of spaces in a string to one \
RawSpace.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "183defc1-26e1-410d-8799-ea3d0ef21190"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RefutationTree", "::", "usage"}], "=", " ", 
   "\[IndentingNewLine]", 
   "\"\<RefutationTree[x,options] decides whether the list x of clauses is \
satisfiable or not. In the latter case it finds a refutation tree using the \
algorithm described in the book Logic for Information Technology (Anthony \
Galton, John Wiley & Sons, 1990, pp.104 - 105) and outputs it in a convenient \
graphic form.\nThere are the following options (default value = the first \
alternative):\n- Format -> TreePlot|TableForm.\n- RootPosition -> \
Right|Left|Top|Bottom.\n- TableSpacing -> Automatic|{nonnegative integer, \
nonnegative integer}.\nOption TableSpacing matters only in the case of Format \
-> TableForm\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "ad26c2c9-5c94-44fc-9849-a17fec5219da"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReleaseHE", "::", "usage"}], "=", 
   "\"\<ReleaseHE[x] removes all occurences of Hold, HoldForm and applies \
Evaluate on all arguments.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713444708196228*^9, 3.7134447082062283`*^9}, {
   3.713444860146441*^9, 3.713444929706538*^9}, 3.713445244766979*^9, {
   3.7139814494441457`*^9, 3.7139814614441624`*^9}},
 ExpressionUUID -> "4967e0f5-7983-42bb-baae-38db5f913540"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Resolvents", "::", "usage"}], "=", 
   "\"\<Resolvents[x,options] generates from the list x of clauses the list \
xx of all resolvents with respect to the list of logical variables. \nThere \
are the following options (default value = the first alternative): \n- Reduce \
-> True|False,\n- Sort -> Union|DeleteDuplicates|False,\n- Variables -> \
All|list of logical variables.\nWith Reduce \[Rule] False the list xx does \
not include clauses that are members of x and with Reduce ->True it does not \
include clauses a part of which is a member of x or xx.\>\""}], 
  ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "0d9fd98f-8fbb-44a3-87e7-4f5b050bd424"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionDepth", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<ResolutionDepth[x,options] characterizes the complexity of the list x \
of clauses by the triple depth={\[PlusMinus]n,r,t},where n is the length of \
the list FullResolutionSequence[x,options], r is the total number of clauses \
in it, and t is the CPU time spent in the Mathematica kernel. The sign is \
\\\"+\\\" if the list x is satisfiable,and \\\"-\\\" in the opposite case.\n\
Alternatives for options (default value=the first alternative):\n- Reduce \
\[Rule] True|False,\n- Rules \[Rule] True|False,\n- Sort \[Rule] \
Union|DeleteDuplicates,\n- Trace \[Rule] True|False,\n- Variables \[Rule] \
All|list of logical variables.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 CellChangeTimes->{
  3.8000394155616374`*^9, {3.800039450309269*^9, 3.800039455199561*^9}, {
   3.800039507352257*^9, 3.8000395292413745`*^9}, 3.800039681605991*^9},
 ExpressionUUID -> "63bf6de3-c0f4-43e7-b65f-2fffc02489b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionSequence", "::", "usage"}], "=", 
   "\"\<ResolutionSequence[x, options] tests whether the list x of clauses is \
satisfiable or not and in the positive case finds values of logical variables \
for which all clauses in x are true. The algorithm used can be roughly \
described as a successive elimination of logical variables.\nThere are the \
following options (default value = the first alternative):\n- Abbreviations \
-> {False->0, True->1}|{False->FalseSymbol, True->TrueSymbol}|None,\n- Print \
-> True|False,\n- Reduce -> True|False,\n- Rules -> True|False,\n- \
SequenceBreaks -> None|Automatic|integer > 1|incresing list of integers > 1,\n\
- Sort -> Union|DeleteDuplicates|False,\n- Variables -> Automatic|All|list of \
logical variables.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "38eaa034-42cf-425f-b8db-20ec4bfd4860"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionTable", "::", "usage"}], "=", 
   "\"\<ResolutionTable[x, options] tests whether the list x of clauses is \
satisfiable or not. It uses almost the same algorithm as ResolutionSequence \
does but the result is presented in the form of a table.\nThere are the \
following options (default value = the first alternative):\n- Abbreviations \
-> {False->0, True->1}|{False->FalseSymbol, True->TrueSymbol}|None,\n- \
ItemSize -> Automatic|{{Automatic, {1.5}}, 1}|as for Grid,\n- Reduce -> \
True|False,\n- Rules -> True|False,\n- Sort -> Union|DeleteDuplicates|False,\n\
- TableBreaks -> None|integer > 1|increasing list of integers > 1,\n- \
Transpose -> False|True,\n- Variables -> All|List of logical \
variables.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "4d78e32d-16fb-4b25-aaf1-b5a7031eb8eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<RTree[x] decides whether the list x of clauses is satisfiable or \
not,and in the latter case it finds a refutation tree by the algorithm \
described in Anthony Galton:Logic for Information Technology, John Wiley& \
Sons,1990,pp.104-105.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446477744711*^9, 3.7134464863247232`*^9}, {3.7134465172947664`*^9, 
   3.7134465483048096`*^9}, {3.7134465924748716`*^9, 3.713446640294938*^9}, {
   3.713446682694998*^9, 3.713446740535079*^9}, {3.713446790765149*^9, 
   3.713446872615264*^9}, {3.7134469140053215`*^9, 3.7134469702254004`*^9}, {
   3.7134470466755075`*^9, 3.7134470764355493`*^9}, 3.713447232465768*^9, 
   3.713447847606629*^9, {3.7134479251567373`*^9, 3.7134481925271115`*^9}, 
   3.713448456277481*^9, {3.7153289070560045`*^9, 3.715329101626277*^9}, {
   3.7153291933564053`*^9, 3.715329234846463*^9}, {3.7153292840765324`*^9, 
   3.715329286236535*^9}, {3.7153293692666516`*^9, 3.715329398556692*^9}, {
   3.715330156447754*^9, 3.7153302414578724`*^9}, {3.7153303533980293`*^9, 
   3.715330414708115*^9}, {3.715574754401726*^9, 3.7155747889117746`*^9}},
 ExpressionUUID -> "b438f2e3-61ee-423f-bae2-f9a083811f41"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToClauses", "::", "usage"}], " ", "=", 
   "\"\<ToClauses[x] converts its minimal CNF form to the list of clauses. \
ToClauses has attribute Listable\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446477744711*^9, 3.7134464863247232`*^9}, {3.7134465172947664`*^9, 
   3.7134465483048096`*^9}, {3.7134465924748716`*^9, 3.713446640294938*^9}, {
   3.713446682694998*^9, 3.713446740535079*^9}, {3.713446790765149*^9, 
   3.713446872615264*^9}, {3.7134469140053215`*^9, 3.7134469702254004`*^9}, {
   3.7134470466755075`*^9, 3.7134470764355493`*^9}, 3.713447232465768*^9, 
   3.713447847606629*^9, {3.7134479251567373`*^9, 3.7134481712870817`*^9}, 
   3.713448290807249*^9, {3.7152689529115486`*^9, 3.7152689885666*^9}, {
   3.715269038001671*^9, 3.715269084026737*^9}, {3.715285024021967*^9, 
   3.7152850665420265`*^9}, {3.7152852200422416`*^9, 3.7152854212125235`*^9}, 
   3.7153489863017445`*^9, {3.7240734709262543`*^9, 3.7240734829562707`*^9}, {
   3.7240735285863347`*^9, 3.7240735521763678`*^9}},
 ExpressionUUID -> "cfbecb05-b367-4434-8907-5402228e852d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TruthTable", "::", "usage"}], "=", " ", "\[IndentingNewLine]", 
   "\"\<TruthTable[x,options] computes the truth table of the logical formula \
or list of logical formulae x and outputs or prints it as Grid.\nThere are \
the following options (default value = the first alternative):\n- \
BooleanValues -> {0,1}|{False,True} -> {FalseSymbol,TrueSymbol},\n- \
ReverseValues -> False|True,\n- ItemSize -> Automatic|Full|as for Grid,\n- \
Labels -> None|Automatic|list of sufficient length,\n- Print -> False|True,\n\
- SelectValuations -> \
All|AllTrue|Mixed|AllFalse|LastTrue|LastFalse|OnlyLastFalse| \n         \
{{indexes|labels of formulae} -> FalseSymbol, {indexes|labels of formulae} -> \
TrueSymbol},\n- TableBreaks -> None|integer > 1|increasing list of integers > \
1,       \n- Transpose -> False|True.\nItemSize is an option of Grid and \
Transpose is an option of List, Matrix and Tensor.\>\""}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "ccb6740a-c72a-4500-a279-edbb01a2e786"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Options ", "Subsubsection",
 CellMargins->{{19, 3}, {2, 10}},
 CellChangeTimes->{{3.7153471853992233`*^9, 3.71534723302929*^9}, {
  3.715347508849676*^9, 3.715347516239687*^9}, {3.7153476299498463`*^9, 
  3.715347634299852*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"d1e922df-1d2d-48f4-bb53-90b714749950"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Function", " ", "Options"}], " ", "*)"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 CellChangeTimes->{{3.721938093227312*^9, 3.7219381120373383`*^9}},
 ExpressionUUID -> "b5120625-a74b-4f95-9175-7f0eb7275ffa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AllFalse", "::", "usage"}], "=", 
   "\"\<One of alternative values for SelectValuations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AllTrue", "::", "usage"}], "=", 
   "\"\<One of alternative values for SelectValuations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BooleanValues", "::", "usage"}], "=", 
   "\"\<Option of TruthTable.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Labels", "::", "usage"}], " ", "=", " ", 
   "\"\<Option of TruthTable.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LastFalse", "::", "usage"}], "=", 
   "\"\<One of alternative values for SelectValuations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LastTrue", "::", "usage"}], "=", 
   "\"\<One of alternative values for SelectValuations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Mixed", "::", "usage"}], "=", 
   "\"\<One of alternative values for SelectValuations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OnlyLastFalse", "::", "usage"}], "=", 
   "\"\<One of alternative values for SelectValuations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ReverseValues", "::", "usage"}], "=", 
   "\"\<Option of TruthTable.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RootPosition", "::", "usage"}], "=", 
   "\"\<Option of BTreeForm and RefutationTree.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Rules", "::", "usage"}], "=", " ", 
   "\"\<Option of FullResolutionSequence, ResolutionDepth, \
ResolutionSequence, ResolutionTable and ResolutionTable.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SelectionRule", "::", "usage"}], "=", 
   "\"\<ResolutionSequence, ResolutionTable, RTree, RefutationTree.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SelectValuations", "::", "usage"}], " ", "=", 
   "\"\<Option of TruthTable.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SequenceBreaks", "::", "usage"}], "=", 
   "\"\<Option of ResolutionSequence.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TableBreaks", "::", "usage"}], " ", "=", " ", 
   "\"\<Option of TruthTable and ResolutionTable.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TestResult", "::", "usage"}], "=", 
   "\"\<Option of ResolutionTable.\>\""}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 CellChangeTimes->{{3.713445248426985*^9, 3.713445248426985*^9}, {
   3.7134453305970993`*^9, 3.713445386487178*^9}, 3.7134457309876604`*^9, {
   3.713446477744711*^9, 3.7134464863247232`*^9}, {3.7134465172947664`*^9, 
   3.7134465483048096`*^9}, {3.7134465924748716`*^9, 3.713446640294938*^9}, {
   3.713446682694998*^9, 3.713446740535079*^9}, {3.713446790765149*^9, 
   3.713446872615264*^9}, {3.7134469140053215`*^9, 3.7134469702254004`*^9}, {
   3.7134470466755075`*^9, 3.713447225695758*^9}, {3.713447635036331*^9, 
   3.7134477736465254`*^9}, {3.7134478859366827`*^9, 
   3.7134478966866975`*^9}, {3.7139824858255963`*^9, 3.7139824881356*^9}, {
   3.713982534725665*^9, 3.7139825803757286`*^9}, {3.713982632025801*^9, 
   3.713982689155881*^9}, {3.7139827948160295`*^9, 3.713982798886035*^9}, {
   3.7139829145361967`*^9, 3.713983030506359*^9}, {3.7139830765364237`*^9, 
   3.7139831156564784`*^9}, 3.7139837093273096`*^9, 3.7139837794674077`*^9, {
   3.713983930217619*^9, 3.7139839411376343`*^9}, {3.7139840019977193`*^9, 
   3.7139840567977962`*^9}, {3.7139840989778547`*^9, 3.713984106477865*^9}, {
   3.7139841466879215`*^9, 3.7139841831279726`*^9}, 3.7139842160480185`*^9, {
   3.7139842811181097`*^9, 3.7139842886281204`*^9}, {3.713984327638175*^9, 
   3.7139843574982166`*^9}, {3.7139843927782664`*^9, 3.713984460448361*^9}, {
   3.7139845050784235`*^9, 3.7139845372884684`*^9}, {3.7139875269426537`*^9, 
   3.7139876165527797`*^9}, {3.713987681642871*^9, 3.713987775303002*^9}, {
   3.714045194906347*^9, 3.7140452013163557`*^9}, {3.714045294516486*^9, 
   3.714045295746488*^9}, {3.714050270663453*^9, 3.7140502726834555`*^9}, 
   3.7142304580247955`*^9, {3.7142304945748467`*^9, 3.7142304963348494`*^9}, {
   3.7142305295948954`*^9, 3.7142305314948983`*^9}, 3.714379958893367*^9, {
   3.714381098664963*^9, 3.714381106024973*^9}, 3.7153228673975487`*^9, {
   3.7153229221276255`*^9, 3.715322928127634*^9}, {3.7153229827377105`*^9, 
   3.715322995617728*^9}, {3.7153230948878675`*^9, 3.7153234131483126`*^9}, {
   3.7153486254112396`*^9, 3.7153486669912977`*^9}, {3.7157078419456253`*^9, 
   3.715707926465743*^9}, {3.715708061095932*^9, 3.7157082314661703`*^9}, {
   3.7179492419402647`*^9, 3.7179493244903803`*^9}, {3.7184527642921753`*^9, 
   3.7184528372522774`*^9}, {3.7185590047669497`*^9, 
   3.7185591072970934`*^9}, {3.71883170249841*^9, 3.718831782708523*^9}, {
   3.7188740517088537`*^9, 3.7188740561788597`*^9}, 3.721244867649438*^9, {
   3.722113662400826*^9, 3.722113669480836*^9}, {3.7961521477301807`*^9, 
   3.796152228354823*^9}},
 ExpressionUUID -> "af13e7ce-1125-4cf7-9a46-f1543e4a7e44"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notation for Logical Connectives", "Subsection",
 CellMargins->{{18.0625, 10.}, {5., 10.}},
 FontFamily->"Arial",
 FontSize->16,ExpressionUUID->"de4f3b6a-3427-4bd3-86c2-3ed18a332ab7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[And]"},
     "NotationTemplateTag"], ",", "AND"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[Equivalent]"},
     "NotationTemplateTag"], ",", "EQUIV"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[Implies]"},
     "NotationTemplateTag"], ",", "IMPLIES"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[UpArrow]"},
     "NotationTemplateTag"], ",", "NAND"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[DownArrow]"},
     "NotationTemplateTag"], ",", "NOR"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[Or]"},
     "NotationTemplateTag"], ",", "OR"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[CirclePlus]"},
     "NotationTemplateTag"], ",", "XOR"}], "]"}], ";"}]}], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 InitializationCell->True,
 CellChangeTimes->{{3.7135506223765464`*^9, 3.7135507234866877`*^9}, {
   3.7135511755973206`*^9, 3.7135511825173306`*^9}, {3.7135512214673853`*^9, 
   3.7135512224373865`*^9}, {3.7139906024569597`*^9, 
   3.7139906194069834`*^9}, {3.7139908308372793`*^9, 
   3.7139908318072805`*^9}, {3.713990867547331*^9, 3.7139909282374163`*^9}, {
   3.7139909769774837`*^9, 3.713990982377492*^9}, {3.7139910207875457`*^9, 
   3.713991049147585*^9}, {3.713991103507661*^9, 3.713991125867693*^9}, {
   3.713991355818014*^9, 3.713991373538039*^9}, {3.7139924066494856`*^9, 
   3.7139924270695143`*^9}, {3.713993520641045*^9, 3.7139936435212173`*^9}, {
   3.71403225598065*^9, 3.71403226289066*^9}, {3.714032418600878*^9, 
   3.7140324454709153`*^9}, {3.714032667191226*^9, 3.7140326889812565`*^9}, 
   3.714032719441299*^9, {3.714032822881444*^9, 3.714032828831452*^9}, {
   3.7140329440016136`*^9, 3.714032948261619*^9}, {3.7140330431917524`*^9, 
   3.7140330513917637`*^9}, {3.714033102421835*^9, 3.7140331262418685`*^9}, {
   3.7140332351020207`*^9, 3.714033256462051*^9}, {3.7140333105521264`*^9, 
   3.7140333220221424`*^9}, 3.714033374272216*^9, {3.714033540852449*^9, 
   3.714033547762459*^9}, {3.714034894584344*^9, 3.714034958854434*^9}, {
   3.714045089126199*^9, 3.714045142906274*^9}, {3.714045516016796*^9, 
   3.714045521326804*^9}, 3.714045592276903*^9, 3.7140456518869867`*^9, {
   3.714045683437031*^9, 3.7140457173970785`*^9}, {3.714045995067467*^9, 
   3.7140460004974747`*^9}, {3.714046043527535*^9, 3.714046072837576*^9}, {
   3.7140461141976337`*^9, 3.7140461190776405`*^9}, {3.714046196597749*^9, 
   3.7140462988078923`*^9}, {3.714046364977985*^9, 3.714046392758024*^9}, {
   3.7140464328480797`*^9, 3.7140464695281315`*^9}, {3.7140465854282937`*^9, 
   3.7140466034983187`*^9}, {3.7140471167490377`*^9, 
   3.7140471217590446`*^9}, {3.7140472883792777`*^9, 3.7140473012092957`*^9}, 
   3.7140473552993717`*^9, {3.714047414259454*^9, 3.714047417229458*^9}, 
   3.7140476124597316`*^9, {3.714047670489813*^9, 3.7140476799098263`*^9}, {
   3.7140477359599047`*^9, 3.7140477416099124`*^9}, {3.7140485850610933`*^9, 
   3.714048593451105*^9}, {3.714048721341284*^9, 3.714048722121285*^9}, {
   3.7140487830913706`*^9, 3.7140488880215173`*^9}, {3.7140489917816625`*^9, 
   3.714048998431672*^9}, {3.7140544944793663`*^9, 3.714054501659376*^9}, {
   3.7140549732200365`*^9, 3.7140549824800496`*^9}, {3.714055095560208*^9, 
   3.7140551044202204`*^9}, {3.7149954565937977`*^9, 3.714995513743878*^9}, {
   3.7149959819045334`*^9, 3.714995984694537*^9}, 3.7149963108349943`*^9},
 ExpressionUUID -> "0c35192c-0832-47b9-9282-eeaeb2e8bac9"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[And]"},
     "NotationTemplateTag"], ",", "AND", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[Equivalent]"},
     "NotationTemplateTag"], ",", "EQUIV", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[Implies]"},
     "NotationTemplateTag"], ",", "IMPLIES", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[UpArrow]"},
     "NotationTemplateTag"], ",", "NAND", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[DownArrow]"},
     "NotationTemplateTag"], ",", "NOR", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[Or]"},
     "NotationTemplateTag"], ",", "OR", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixNotation", "[", 
   RowBox[{
    TemplateBox[{"\[CirclePlus]"},
     "NotationTemplateTag"], ",", "XOR", ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}]}], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 InitializationCell->True,
 ExpressionUUID -> "3a264097-1d00-4393-b681-62845b94d7a4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"\[Not]", "x_"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"NOT", "[", "x_", "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[Equivalent]", "y_"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"EQUIV", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[LineSeparator]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[Implies]", "y_"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"IMPLIES", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[UpArrow]", "y_"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"NAND", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[LineSeparator]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"\[Not]", 
        RowBox[{"x_", "\[UpArrow]", "y_"}]}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"NAND", "[", 
        RowBox[{
          RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[UpArrow]", 
        RowBox[{"\[Not]", "y_"}]}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"NAND", "[", 
        RowBox[{"x_", ",", 
          RowBox[{"NOT", "[", "y_", "]"}]}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[DownArrow]", "y_"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"NOR", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Notation", "[", 
  RowBox[{
   TemplateBox[{RowBox[{"\[Not]", 
       RowBox[{"x_", "\[DownArrow]", "y_"}]}]},
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TemplateBox[{RowBox[{"NOR", "[", 
       RowBox[{
         RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}]},
    "NotationTemplateTag"]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[DownArrow]", 
        RowBox[{"\[Not]", "y_"}]}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"NOR", "[", 
        RowBox[{"x_", ",", 
          RowBox[{"NOT", "[", "y_", "]"}]}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[CirclePlus]", "y_"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"XOR", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Notation", "[", 
  RowBox[{
   TemplateBox[{RowBox[{"\[Not]", 
       RowBox[{"x_", "\[CirclePlus]", "y_"}]}]},
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TemplateBox[{RowBox[{"XOR", "[", 
       RowBox[{
         RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}]},
    "NotationTemplateTag"]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{RowBox[{"x_", "\[CirclePlus]", 
        RowBox[{"\[Not]", "y_"}]}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"XOR", "[", 
        RowBox[{"x_", ",", 
          RowBox[{"NOT", "[", "y_", "]"}]}], "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}]}], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "725e7dda-a973-420d-81e2-15fa1b7d0e45"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"\[Not]", "x_"}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NOT", "[", "x_", "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[Equivalent]", "y_"}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"EQUIV", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[Implies]", "y_"}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"IMPLIES", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[UpArrow]", "y_"}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NAND", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"\[Not]", 
         RowBox[{"x_", "\[UpArrow]", "y_"}]}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NAND", "[", 
         RowBox[{
           RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[UpArrow]", 
         RowBox[{"\[Not]", "y_"}]}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NAND", "[", 
         RowBox[{"x_", ",", 
           RowBox[{"NOT", "[", "y_", "]"}]}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[DownArrow]", "y_"}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NOR", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"\[Not]", 
         RowBox[{"x_", "\[DownArrow]", "y_"}]}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NOR", "[", 
         RowBox[{
           RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[DownArrow]", 
         RowBox[{"\[Not]", "y_"}]}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"NOR", "[", 
         RowBox[{"x_", ",", 
           RowBox[{"NOT", "[", "y_", "]"}]}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[CirclePlus]", "y_"}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"XOR", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"\[Not]", 
         RowBox[{"x_", "\[CirclePlus]", "y_"}]}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"XOR", "[", 
         RowBox[{
           RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TemplateBox[{RowBox[{"x_", "\[CirclePlus]", 
         RowBox[{"\[Not]", "y_"}]}]},
      "NotationTemplateTag"], "\[DoubleLongLeftRightArrow]", 
     TemplateBox[{RowBox[{"XOR", "[", 
         RowBox[{"x_", ",", 
           RowBox[{"NOT", "[", "y_", "]"}]}], "]"}]},
      "NotationTemplateTag"]}], ",", 
    RowBox[{"WorkingForm", "\[Rule]", "TraditionalForm"}]}], "]"}], 
  ";"}]}], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 PageBreakWithin->Automatic,
 InitializationCell->True,
 ExpressionUUID -> "adcbac19-e99a-4842-b36e-e808c85cabbd"],

Cell[CellGroupData[{

Cell["Private", "Subsection",
 CellMargins->{{18.8, 3.}, {8., 12.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7134443641257467`*^9, 3.7134443780657663`*^9}, {
  3.713444510265951*^9, 3.713444515235958*^9}},
 FontFamily->"Arial",
 FontSize->16,ExpressionUUID->"f3212c79-0d5c-4b62-b6f0-8128e007491f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "7171cdd3-1b1e-481e-92c4-abfa2eb39e58"],

Cell[CellGroupData[{

Cell["Auxiliary Definitions", "Subsubsection",
 CellMargins->{{18, 3}, {8, 12}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 FontSize->14,ExpressionUUID->"c52af466-5efd-477e-8941-acd93ad237e3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Union", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "Union", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Union", "[", "x_Subscript", "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Union", "[", "x_Symbol", "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "Union", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "DeleteDuplicates", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "DeleteDuplicates", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeleteDuplicates", "[", "x_Subscript", "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeleteDuplicates", "[", "x_Symbol", "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeleteDuplicates", "[", 
    RowBox[{"f_", "[", "x__", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "@@", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"{", "x", "}"}], "]"}]}], "/;", 
    RowBox[{"f", "=!=", "List"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "DeleteDuplicates", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "SubscriptBoxToString", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "SubscriptBoxToString", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SubscriptBoxToString", "[", "string_", "]"}], ":=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"StringReplace", "[", 
      RowBox[{"string", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\\), \\(\>\"", "\[Rule]", "\"\<$\>\""}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<\\!\\(\\*SubscriptBox[\\(\>\"", "\[Rule]", "\"\<\>\""}], 
       ",", 
       RowBox[{"\"\<\\)]\\)\>\"", "\[Rule]", "\"\<\[VeryThinSpace]\>\""}]}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "SubscriptBoxToString", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "ToLettersAndDigits", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "ToLettersAndDigits", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLettersAndDigits", "[", "string_", "]"}], ":=", 
   RowBox[{
    RowBox[{"ToString", "/@", 
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringCases", "[", 
           RowBox[{"string", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"WordBoundary", ":", 
             RowBox[{"LetterCharacter", "..."}]}], "~~", "LetterCharacter"}], 
           ",", "\"\<$\>\"", ",", 
           RowBox[{
            RowBox[{"WordBoundary", ":", 
             RowBox[{"DigitCharacter", "..."}]}], "~~", "DigitCharacter"}]}], 
          "}"}]}], "]"}]}], "]"}]}], "/;", 
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"string", ",", 
      RowBox[{
      "LetterCharacter", " ", "~~", "___", "~~", " ", "DigitCharacter", "~~", 
       "\"\<\[VeryThinSpace]\>\""}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLettersAndDigits", "[", "string_", "]"}], ":=", "string"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "ToLettersAndDigits", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "RestoreSubscript", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "RestoreSubscript", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RestoreSubscript", "[", "False", "]"}], "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RestoreSubscript", "[", "True", "]"}], "=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RestoreSubscript", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"RestoreSubscript", "[", 
    RowBox[{"ToString", " ", "@", " ", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RestoreSubscript", "[", "x_String", "]"}], ":=", 
   RowBox[{"x", "/;", 
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"x", ",", 
      RowBox[{"\"\<,\>\"", "~~", "Whitespace"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RestoreSubscript", "[", "x_String", "]"}], ":=", 
   RowBox[{
    RowBox[{"ToExpression", "[", "x", "]"}], "/;", 
    RowBox[{"StringFreeQ", "[", 
     RowBox[{"x", ",", "\"\<$\>\""}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RestoreSubscript", "[", "x_String", "]"}], ":=", 
   RowBox[{
    RowBox[{"Subscript", "@@", 
     RowBox[{"ToExpression", "/@", 
      RowBox[{"StringSplit", "[", 
       RowBox[{"x", ",", "\"\<$\>\""}], "]"}]}]}], "/;", 
    RowBox[{"!", 
     RowBox[{"StringFreeQ", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "x", "]"}], ",", "\"\<$\>\""}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "RestoreSubscript", "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "RemoveSubscript", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "RemoveSubscript", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveSubscript", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "/.", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"ToExpression", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", 
        RowBox[{"{", 
         RowBox[{"u", ",", "Global`$", ",", "v"}], "}"}]}], "//", 
       "StringJoin"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "RestoreSubscript", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.7032916309310436`*^9, 3.703291636171051*^9}, {
   3.703292112761718*^9, 3.703292117621725*^9}, {3.7032942856947603`*^9, 
   3.7032942904547668`*^9}, {3.7032943693548775`*^9, 
   3.7032943752848854`*^9}, {3.7033431671209717`*^9, 
   3.7033431686909733`*^9}, {3.7033432092710304`*^9, 3.703343220621046*^9}, {
   3.7033432555210953`*^9, 3.7033433182911835`*^9}, {3.7034094419799337`*^9, 
   3.7034094473699408`*^9}, {3.703409524500049*^9, 3.7034095529500885`*^9}, 
   3.703410035800765*^9, {3.7034102074010053`*^9, 3.7034102114010105`*^9}, {
   3.7034102619610815`*^9, 3.703410265911087*^9}, {3.7034103384611883`*^9, 
   3.703410370701234*^9}, {3.715433931887066*^9, 3.7154340143971815`*^9}, {
   3.7154343849477*^9, 3.7154343910077085`*^9}, 3.7155058348635616`*^9, {
   3.715568997513666*^9, 3.715569001693672*^9}, 3.715575110772225*^9, {
   3.715575601442912*^9, 3.715575617352934*^9}, {3.7958614691654544`*^9, 
   3.795861623745103*^9}, {3.795886585305047*^9, 3.795886623496747*^9}, {
   3.795886957776613*^9, 3.795886989317561*^9}, 3.7958875420442595`*^9, {
   3.795887600919324*^9, 3.795887641307829*^9}, {3.7958880731670723`*^9, 
   3.795888103201912*^9}, {3.7958891999759226`*^9, 3.79588920357113*^9}, {
   3.795889729188075*^9, 3.795889751068781*^9}, {3.795889940315965*^9, 
   3.795889941002404*^9}, {3.795890025437848*^9, 3.7958900263249264`*^9}},
 ExpressionUUID -> "eff77432-0a2c-42b2-b0fb-8be4fb6d2788"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ReduceSpaces", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "ReduceSpaces", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ReduceSpaces", "[", "x_String", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xx", "=", "x"}], "}"}], ",", 
     RowBox[{
      RowBox[{"xx", "=", 
       RowBox[{"StringReplace", "[", 
        RowBox[{"xx", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<\[VeryThinSpace]\>\"", "\[Rule]", "\"\< \>\""}], ",", 
           RowBox[{"\"\<\[ThinSpace]\>\"", "\[Rule]", "\"\< \>\""}]}], 
          "}"}]}], "]"}]}], ";", " ", 
      RowBox[{"FixedPoint", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"StringReplace", "[", 
          RowBox[{"#", ",", 
           RowBox[{"\"\<  \>\"", "\[Rule]", "\"\< \>\""}]}], "]"}], "&"}], 
        ",", "xx"}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ReduceSpaces", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "4010773f-1385-4194-982e-ca639969494a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "HList", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "HList", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HList", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HList", "[", "x_List", "]"}], ":=", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"HoldForm", ",", 
      RowBox[{"Hold", "[", "x", "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HList", "[", "x__", "]"}], ":=", 
   RowBox[{"List", "@@", 
    RowBox[{"HoldForm", "/@", 
     RowBox[{"Hold", "[", "x", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "HList", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "ReleaseHE", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "ReleaseHE", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ReleaseHE", "[", "x_", "]"}], ":=", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MapAll", "[", 
        RowBox[{"Evaluate", ",", "#"}], "]"}], "//.", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Hold", "|", "HoldForm"}], ")"}], "[", "u_", "]"}], 
        "\[Rule]", "u"}]}], "&"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ReleaseHE", "[", 
    RowBox[{"x_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{"Evaluate", ",", "#", ",", "n"}], "]"}], "//.", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Hold", "|", "HoldForm"}], ")"}], "[", "u_", "]"}], 
        "\[Rule]", "u"}]}], "&"}], ",", "x", ",", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ReleaseHE", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.7032916309310436`*^9, 3.703291636171051*^9}, {
   3.703292112761718*^9, 3.703292117621725*^9}, {3.7032942856947603`*^9, 
   3.7032942904547668`*^9}, {3.7032943693548775`*^9, 
   3.7032943752848854`*^9}, {3.7033431671209717`*^9, 
   3.7033431686909733`*^9}, {3.7033432092710304`*^9, 3.703343220621046*^9}, {
   3.7033432555210953`*^9, 3.7033433182911835`*^9}, {3.7034094419799337`*^9, 
   3.7034094473699408`*^9}, {3.703409524500049*^9, 3.7034095529500885`*^9}, 
   3.703410035800765*^9, {3.7034102074010053`*^9, 3.7034102114010105`*^9}, {
   3.7034102619610815`*^9, 3.703410265911087*^9}, {3.7034103384611883`*^9, 
   3.703410370701234*^9}, {3.715433931887066*^9, 3.7154340143971815`*^9}, {
   3.7154343849477*^9, 3.7154343910077085`*^9}, {3.7155058348635616`*^9, 
   3.7155058389635673`*^9}},
 ExpressionUUID -> "da324847-e0bc-4b7d-85d2-0d17d6a527f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Definitions for Logical Connectives", "Subsubsection",
 CellMargins->{{18.0625, 10.}, {5., 10.}},
 PageBreakWithin->True,
 GroupPageBreakWithin->
  True,ExpressionUUID->"20f2561b-fbee-4787-99ae-4e98e17e7662"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrefixConnectives", "=", 
   RowBox[{"{", "NOT", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"InfixConnectives", "=", 
   RowBox[{"{", 
    RowBox[{
    "AND", ",", "EQUIV", ",", "IMPLIES", ",", "NAND", ",", "NOR", ",", "OR", 
     ",", "XOR"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Connectives", "=", 
    RowBox[{"{", 
     RowBox[{
     "NOT", ",", "AND", ",", "EQUIV", ",", "IMPLIES", ",", "NAND", ",", "NOR",
       ",", "OR", ",", "XOR"}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrefixStrings", "[", "1", "]"}], "=", 
   RowBox[{"{", "\"\<\[Not]\>\"", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrefixStrings", "[", "2", "]"}], "=", 
   RowBox[{"{", "\"\<NOT@\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InfixStrings", "[", "1", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\[And]\>\"", ",", "\"\<\[Equivalent]\>\"", ",", "\"\<\[Implies]\>\"",
      ",", "\"\<\[UpArrow]\>\"", ",", "\"\<\[DownArrow]\>\"", ",", 
     "\"\<\[Or]\>\"", ",", "\"\<\[CirclePlus]\>\""}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InfixStrings", "[", "2", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<~AND~\>\"", ",", "\"\<~EQUIV~\>\"", ",", "\"\<~IMPLIES~\>\"", ",", 
     "\"\<~NAND~\>\"", ",", "\"\<~NOR~\>\"", ",", "\"\<~OR~\>\"", ",", 
     "\"\<~XOR~\>\""}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Strings", "[", "1", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\[Not]\>\"", ",", "\"\<\[And]\>\"", ",", "\"\<\[Equivalent]\>\"", 
     ",", "\"\<\[Implies]\>\"", ",", "\"\<\[UpArrow]\>\"", ",", 
     "\"\<\[DownArrow]\>\"", ",", "\"\<\[Or]\>\"", ",", 
     "\"\<\[CirclePlus]\>\""}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Strings", "[", "2", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<NOT@\>\"", ",", "\"\<~AND~\>\"", ",", "\"\<~EQUIV~\>\"", ",", 
     "\"\<~IMPLIES~\>\"", ",", "\"\<~NAND~\>\"", ",", "\"\<~NOR~\>\"", ",", 
     "\"\<~OR~\>\"", ",", "\"\<~XOR~\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Strings", "[", "3", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<NOT\>\"", ",", "\"\<AND\>\"", ",", "\"\<EQUIV\>\"", ",", 
     "\"\<IMPLIES\>\"", ",", "\"\<NAND\>\"", ",", "\"\<NOR\>\"", ",", 
     "\"\<OR\>\"", ",", "\"\<XOR\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Strings", "[", "4", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\< \>\"", ",", "#", ",", "\"\< \>\""}], "]"}], 
     "\[ThinSpace]", "&"}], "/@", 
    RowBox[{"Strings", "[", "1", "]"}]}]}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "685d773f-0c91-4038-8d95-69c0a5e9632d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "/@", "Connectives"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "/@", "Connectives"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AND", "[", "]"}], "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AND", "[", "x_", "]"}], " ", "=", " ", "x"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AND", "[", "x__", "]"}], " ", ":=", " ", 
    RowBox[{"False", " ", "/;", " ", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", " ", 
       RowBox[{"False", "|", "FALSE"}]}], "]"}]}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AND", "[", "x__", "]"}], " ", ":=", " ", 
    RowBox[{"True", " ", "/;", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"{", "x", "}"}], "]"}], " ", "===", " ", 
       RowBox[{"{", "True", "}"}]}], "|", 
      RowBox[{"{", "TRUE", "}"}], "|", 
      RowBox[{"{", 
       RowBox[{"True", ",", "TRUE"}], "}"}]}]}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AND", "[", 
     RowBox[{"x___", ",", " ", 
      RowBox[{"True", "|", "TRUE"}], ",", " ", "y___"}], "]"}], " ", "=", " ", 
    RowBox[{"AND", "[", 
     RowBox[{"x", ",", " ", "y"}], "]"}]}], ";"}], " ", 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EQUIV", "[", 
    RowBox[{"x_", ",", "x_"}], "]"}], "=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EQUIV", "[", 
    RowBox[{
     RowBox[{"False", "|", "FALSE"}], ",", 
     RowBox[{"True", "|", "TRUE"}]}], "]"}], "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EQUIV", "[", 
    RowBox[{
     RowBox[{"True", "|", "TRUE"}], ",", 
     RowBox[{"False", "|", "FALSE"}]}], "]"}], "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IMPLIES", "[", 
     RowBox[{
      RowBox[{"False", "|", "FALSE"}], ",", " ", "x_"}], "]"}], " ", "=", " ",
     "True"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IMPLIES", "[", 
    RowBox[{"x_", ",", 
     RowBox[{"True", "|", "TRUE"}]}], "]"}], " ", "=", " ", "True"}], " ", 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IMPLIES", "[", 
    RowBox[{
     RowBox[{"True", "|", "TRUE"}], ",", 
     RowBox[{"False", "|", "FALSE"}]}], "]"}], "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IMPLIES", "[", 
     RowBox[{
      RowBox[{"True", "|", "TRUE"}], ",", "x"}], "]"}], "=", "x"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NAND", "[", "]"}], "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NAND", "[", "x_", "]"}], "=", 
   RowBox[{"NOT", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NAND", "[", 
    RowBox[{"x___", ",", 
     RowBox[{"False", "|", "FALSE"}], ",", "y___"}], "]"}], "=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NAND", "[", 
     RowBox[{"x___", ",", " ", 
      RowBox[{"True", "|", "TRUE"}], ",", " ", "y___"}], "]"}], " ", "=", " ", 
    RowBox[{"NAND", "[", 
     RowBox[{"x", ",", " ", "y"}], "]"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NAND", "[", "x__", "]"}], ":=", 
   RowBox[{"False", "/;", 
    RowBox[{
     RowBox[{"AND", "[", "x", "]"}], "===", "True"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NAND", "[", "x__", "]"}], ":=", 
    RowBox[{"True", "/;", 
     RowBox[{
      RowBox[{"AND", "[", "x", "]"}], "===", "False"}]}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NOR", "[", "]"}], "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NOR", "[", "x_", "]"}], "=", 
   RowBox[{"NOT", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NOR", "[", 
     RowBox[{"x___", ",", 
      RowBox[{"True", "|", "TRUE"}], ",", "y___"}], "]"}], "=", "False"}], 
   ";", " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Corrected", " ", "from", " ", "True", " ", "on", " ", "March", " ", 
      "21"}], ",", " ", "2023"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NOR", "[", 
     RowBox[{"x___", ",", " ", 
      RowBox[{"False", "|", "FALSE"}], ",", " ", "y___"}], "]"}], " ", ":=", 
    " ", 
    RowBox[{"NOR", "[", 
     RowBox[{"x", ",", " ", "y"}], "]"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NOR", "[", "x__", "]"}], ":=", 
   RowBox[{"False", "/;", 
    RowBox[{
     RowBox[{"OR", "[", "x", "]"}], "===", "True"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NOR", "[", "x__", "]"}], ":=", 
    RowBox[{"True", "/;", 
     RowBox[{
      RowBox[{"OR", "[", "x", "]"}], "===", "False"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NOT", "[", 
     RowBox[{"False", "|", "FALSE"}], "]"}], " ", "=", " ", "True"}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NOT", "[", 
     RowBox[{"True", "|", "TRUE"}], "]"}], " ", "=", " ", "False"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NOT", "[", 
     RowBox[{"NOT", "[", "x_", "]"}], "]"}], " ", "=", " ", "x"}], ";"}], " ",
   "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OR", "[", "]"}], "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OR", "[", "x_", "]"}], " ", "=", " ", "x"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"OR", "[", 
    RowBox[{"x___", ",", 
     RowBox[{"True", "|", "TRUE"}], ",", "y___"}], "]"}], "=", " ", "True"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OR", "[", 
     RowBox[{"x___", ",", " ", 
      RowBox[{"False", "|", "FALSE"}], ",", " ", "y___"}], "]"}], " ", "=", 
    " ", 
    RowBox[{"OR", "[", 
     RowBox[{"x", ",", " ", "y"}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"XOR", "[", "]"}], "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XOR", "[", "x_", "]"}], "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XOR", "[", 
    RowBox[{"x_", ",", "x_"}], "]"}], " ", "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XOR", "[", 
    RowBox[{"x___", ",", 
     RowBox[{"False", "|", "FALSE"}], ",", "y___"}], "]"}], "=", 
   RowBox[{"XOR", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"XOR", "[", 
     RowBox[{"x___", ",", 
      RowBox[{"True", "|", "TRUE"}], ",", "y___"}], "]"}], "=", 
    RowBox[{"NOT", "[", 
     RowBox[{"XOR", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "]"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", "Connectives", "]"}], ",", " ", "HoldAll"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "/@", "Connectives"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.888428051195074*^9, 3.888428059432538*^9}},
 ExpressionUUID -> "eadd178d-4c66-4113-b82a-b6b600a34b3e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Precedence", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "Precedence", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Precedence", "[", "NOT", "]"}], "=", "230"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "AND", "]"}], "=", "215"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "EQUIV", "]"}], "=", "205"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "IMPLIES", "]"}], "=", "200"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "NAND", "]"}], "=", "215"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "NOR", "]"}], "=", "215"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "OR", "]"}], "=", "215"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Precedence", "[", "XOR", "]"}], "=", "215"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Precedence", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 GroupPageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.713199577756029*^9, 3.7131995803160324`*^9}, {
   3.713559009028288*^9, 3.713559037698328*^9}, {3.7136380919183283`*^9, 
   3.7136380963483343`*^9}, {3.71363813635839*^9, 3.7136381386383934`*^9}, {
   3.7137984634979253`*^9, 3.713798549278045*^9}, {3.713798820728425*^9, 
   3.7137989102485504`*^9}, {3.7137989752786417`*^9, 3.713799004198682*^9}, {
   3.713799047998743*^9, 3.7137990710387754`*^9}, {3.713799248979025*^9, 
   3.7137993379691496`*^9}, {3.71399169544849*^9, 3.713991703288501*^9}, {
   3.713991760438581*^9, 3.713991764638587*^9}, {3.7139930115903325`*^9, 
   3.7139930991904554`*^9}, {3.713993144760519*^9, 3.7139931587405386`*^9}, {
   3.714144551636919*^9, 3.7141445654369383`*^9}, 3.715403191910806*^9, {
   3.7154032894809427`*^9, 3.715403291150945*^9}, {3.7154059129146156`*^9, 
   3.715405942564657*^9}, {3.715405988974722*^9, 3.715405993114728*^9}, {
   3.7154060558148155`*^9, 3.715406066694831*^9}, {3.7154063356052074`*^9, 
   3.715406342615217*^9}, {3.715406566715531*^9, 3.7154065776655464`*^9}, {
   3.7154067017757196`*^9, 3.7154067112057333`*^9}, {3.7154068034458623`*^9, 
   3.7154068599659414`*^9}, {3.715406890825985*^9, 3.715406913566016*^9}, {
   3.7154070809362507`*^9, 3.7154071858163977`*^9}, 3.715434108187313*^9, {
   3.715434627118039*^9, 3.715434690508128*^9}, {3.715434769398238*^9, 
   3.7154348332683277`*^9}, {3.715434882048396*^9, 3.715434916398444*^9}, 
   3.71544581609465*^9},
 ExpressionUUID -> "9ea9027d-2973-440f-aa21-0b14bc1beccc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logical Variables (or Elementary Formulas or Atoms)", "Subsubsection",
 CellMargins->{{18, 3}, {8, 12}},
 PageBreakWithin->True,
 FontSize->14,ExpressionUUID->"6634f934-f146-4082-ac4c-f4d584ba22b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "LAtomQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "LAtomQ", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "LAtomQ", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"CharacterRange", "[", 
       RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", 
      RowBox[{"ToString", "[", "x", "]"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"CharacterRange", "[", 
       RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ",", 
      RowBox[{"ToString", "[", "x", "]"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", 
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"x", "//", "ToString"}], ",", "1"}], "]"}]}], "]"}], "&&", 
     RowBox[{"DigitQ", "[", 
      RowBox[{"StringDrop", "[", 
       RowBox[{
        RowBox[{"x", "//", "ToString"}], ",", "1"}], "]"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ",", 
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"x", "//", "ToString"}], ",", "1"}], "]"}]}], "]"}], "&&", 
     RowBox[{"DigitQ", "[", 
      RowBox[{"StringDrop", "[", 
       RowBox[{
        RowBox[{"x", "//", "ToString"}], ",", "1"}], "]"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", 
    SubscriptBox["x_Symbol", "n_"], "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", 
       RowBox[{"ToString", "[", "x", "]"}]}], "]"}], "&&", 
     RowBox[{"n", "\[Element]", "Integers"}], " ", "&&", " ", 
     RowBox[{"n", "\[GreaterEqual]", "0"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", 
    SubscriptBox["x_Symbol", "n_"], "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ",", 
       RowBox[{"ToString", "[", "x", "]"}]}], "]"}], "&&", 
     RowBox[{"n", "\[Element]", "Integers"}], " ", "&&", " ", 
     RowBox[{"n", "\[GreaterEqual]", "0"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"Characters", "[", 
        RowBox[{"x", "//", "ToString"}], "]"}], "]"}], ">", "2"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", 
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"x", "//", "ToString"}], ",", "1"}], "]"}]}], "]"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"Characters", "[", 
        RowBox[{"ToString", "[", "x", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "===", "\"\<$\>\""}], "&&", 
     RowBox[{"DigitQ", "[", 
      RowBox[{"StringDrop", "[", 
       RowBox[{
        RowBox[{"x", "//", "ToString"}], ",", "2"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"Characters", "[", 
        RowBox[{"x", "//", "ToString"}], "]"}], "]"}], ">", "2"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ",", 
       RowBox[{"StringTake", "[", 
        RowBox[{
         RowBox[{"x", "//", "ToString"}], ",", "1"}], "]"}]}], "]"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"Characters", "[", 
        RowBox[{"ToString", "[", "x", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "===", "\"\<$\>\""}], "&&", 
     RowBox[{"DigitQ", "[", 
      RowBox[{"StringDrop", "[", 
       RowBox[{
        RowBox[{"x", "//", "ToString"}], ",", "2"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LAtomQ", "[", "x_", "]"}], ":=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "LAtomQ", "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "LVariableSet", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "LVariableSet", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "LVariableSet", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LVariableSet", "[", "x_", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", "x", "}"}], "//.", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "\[Rule]", "List"}], "&"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Hold", ",", "HoldForm"}], "}"}], "~", "Join", "~", 
           "Connectives"}]}], "]"}]}], "//", "Flatten"}], "//", 
      "\[IndentingNewLine]", "Union"}], "//", 
     RowBox[{
      RowBox[{"DeleteCases", "[", 
       RowBox[{"#", ",", 
        RowBox[{"FALSE", "|", "TRUE"}]}], "]"}], "&"}]}], "//", 
    RowBox[{
     RowBox[{"Select", "[", 
      RowBox[{"#", ",", "LAtomQ"}], "]"}], "&"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LVariableSet", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.7121351389366465`*^9, 3.7121351442466545`*^9}, 
   3.7121351758666983`*^9, 3.7122370460762653`*^9, {3.7140632376516066`*^9, 
   3.7140633185817204`*^9}, {3.71406371845228*^9, 3.714063737882307*^9}, 
   3.7140639373525867`*^9, 3.7140639678526287`*^9, {3.7140640213227043`*^9, 
   3.7140640510227456`*^9}, {3.7140642096629677`*^9, 
   3.7140642270029917`*^9}, {3.7140642582130356`*^9, 3.714064258583036*^9}, 
   3.7140643026530976`*^9, {3.714064401553236*^9, 3.7140644254332695`*^9}, {
   3.7140644732833366`*^9, 3.7140644982733717`*^9}, {3.714064548213442*^9, 
   3.7140646025035176`*^9}, {3.7140649082639456`*^9, 3.7140649130239525`*^9}, 
   3.715402924000431*^9, {3.7154036236214104`*^9, 3.7154036440314393`*^9}, {
   3.7154040223919687`*^9, 3.715404031261981*^9}, {3.7154041163821*^9, 
   3.715404119842105*^9}, {3.715404178382187*^9, 3.7154042233222504`*^9}, {
   3.715404277372326*^9, 3.7154042880123405`*^9}, {3.715404339502413*^9, 
   3.715404388882482*^9}, {3.715404449412567*^9, 3.7154045240926714`*^9}, {
   3.715404664422868*^9, 3.715404683532894*^9}, {3.7154048274930964`*^9, 
   3.7154048332131042`*^9}, {3.7154054018739004`*^9, 3.715405424493932*^9}, {
   3.7154058091044703`*^9, 3.7154058147044783`*^9}, {3.7154341570173807`*^9, 
   3.715434269737539*^9}, {3.716295037191863*^9, 3.7162950442018723`*^9}, {
   3.720730069335039*^9, 3.7207300803450546`*^9}, {3.7207301962952166`*^9, 
   3.7207302359052725`*^9}, {3.720730487105624*^9, 3.720730504315648*^9}, 
   3.7207305415557003`*^9, 3.7207310775664506`*^9, {3.720731330576805*^9, 
   3.72073137724687*^9}, {3.7207316194872093`*^9, 3.7207316251672173`*^9}, {
   3.7207316890273066`*^9, 3.7207317306473646`*^9}, {3.7207317878874454`*^9, 
   3.720731821957493*^9}, {3.7207318622175493`*^9, 3.7207318701575603`*^9}, {
   3.7207319718677025`*^9, 3.7207319732777047`*^9}, 3.720732029087783*^9, 
   3.7207321054878893`*^9, {3.720732184778001*^9, 3.7207321884480057`*^9}, {
   3.7207322479380894`*^9, 3.7207322559681005`*^9}, {3.720732404188308*^9, 
   3.7207324223083334`*^9}, 3.720732488588426*^9, 3.7207325212184715`*^9, 
   3.7207325788985524`*^9, {3.7207326937487135`*^9, 3.7207327155287437`*^9}, {
   3.720732773508825*^9, 3.7207327951188555`*^9}, {3.7207328396189175`*^9, 
   3.720732843718923*^9}, {3.724068146438764*^9, 3.7240681610687847`*^9}, {
   3.724068198858837*^9, 3.724068212098856*^9}, {3.7240683338490267`*^9, 
   3.7240683745090833`*^9}, {3.7240684438091803`*^9, 3.724068448229186*^9}, 
   3.7240685463713264`*^9, {3.724068769303641*^9, 3.7240688252257204`*^9}, {
   3.7240688974458213`*^9, 3.7240688991858234`*^9}, {3.724069040788028*^9, 
   3.7240690568980503`*^9}, {3.7240710699208765`*^9, 3.724071104512926*^9}, {
   3.724071137962973*^9, 3.7240711947830524`*^9}, {3.7240712448331227`*^9, 
   3.724071365583292*^9}},
 ExpressionUUID -> "f4bcdef7-6e5c-4e73-bb34-37a25bd97783"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logical Formulae (or Logical Expressions) and Strings", "Subsubsection",
 CellMargins->{{18, 3}, {8, 12}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.715435224678876*^9, 3.7154352338088884`*^9}},
 FontSize->14,ExpressionUUID->"3045ebc7-ecc2-4d5c-87c1-240478ac0bdf"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"LFormulaQ", "[", "x", "]"}], TraditionalForm]],ExpressionUUID->
  "fbcee524-46fb-4af4-90e4-7e8832328ccd"],
 " tests whether the expression ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "de25d206-71b8-4b50-abad-6559d43887ee"],
 " a logical formula. The output is ",
 Cell[BoxData[
  FormBox["True", TraditionalForm]],ExpressionUUID->
  "87378baa-31e1-4c4f-b587-4b76ad189199"],
 " if it does and ",
 Cell[BoxData[
  FormBox["False", TraditionalForm]],ExpressionUUID->
  "37b163a8-9fe5-4a8b-80be-36f222ebd086"],
 " in the opposite case. With the option ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Trace", "\[Rule]", "True"}], TraditionalForm]],ExpressionUUID->
  "7274dcb8-36e3-4d8a-89ca-7b32110848eb"],
 " the main steps to the result are displayed. "
}], "Text",
 CellMargins->{{18.6875, 10.}, {7., 7.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7134497713893223`*^9, 3.713449771869323*^9}, {
  3.715435328189021*^9, 3.7154353771790895`*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"664154ea-39ca-4b91-a3da-37cf42d7be4e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "LFormulaQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "LFormulaQ", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"LFormulaQ", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"Hold", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"LFormulaQ", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"HoldForm", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"LFormulaQ", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"PrecedenceForm", "[", 
     RowBox[{"x_", ",", "y_Integer"}], "]"}], "]"}], "=", 
   RowBox[{"LFormulaQ", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"AND", "[", 
     RowBox[{"x_", ",", "y__"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", 
      RowBox[{"AND", "[", "y", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"EQUIV", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", "y", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"IMPLIES", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", "y", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"NAND", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", 
      RowBox[{"NAND", "[", "y", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"NOR", "[", 
     RowBox[{"x_", ",", "y__"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", 
      RowBox[{"NOR", "[", "y", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"NOT", "[", "x_", "]"}], "]"}], ":=", 
   RowBox[{"LFormulaQ", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"OR", "[", 
     RowBox[{"x_", ",", "y__"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", 
      RowBox[{"OR", "[", "y", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"XOR", "[", 
     RowBox[{"x_", ",", "y__"}], "]"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], ",", 
     RowBox[{"LFormulaQ", "[", 
      RowBox[{"XOR", "[", "y", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"False", "|", "FALSE"}], "]"}], "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", 
    RowBox[{"True", "|", "TRUE"}], "]"}], "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", "x_", "]"}], ":=", 
   RowBox[{"True", "/;", 
    RowBox[{"LAtomQ", "[", "x", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LFormulaQ", "[", "x_", "]"}], ":=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LFormulaQ", "]"}], ";"}]}], "Input",
 CellMargins->{{18.6875, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{
  3.713199588696044*^9, {3.7136421744640436`*^9, 3.713642198534077*^9}, {
   3.713642232514125*^9, 3.7136422417141376`*^9}, {3.713642296864215*^9, 
   3.7136423345742674`*^9}, {3.7141506098054004`*^9, 3.714150619085413*^9}, {
   3.7149923288094187`*^9, 3.7149923399494343`*^9}, 3.715197559655123*^9, {
   3.7151976719752803`*^9, 3.715197758315401*^9}, {3.7151982867161407`*^9, 
   3.7151982971461554`*^9}, {3.715222932369711*^9, 3.715222965139757*^9}, {
   3.7152230205698347`*^9, 3.715223022309837*^9}, {3.7152231040499516`*^9, 
   3.715223118019971*^9}, {3.7152232680901814`*^9, 3.715223279400197*^9}, {
   3.7152235272165985`*^9, 3.7152235668266535`*^9}, {3.715223599276699*^9, 
   3.7152236053767076`*^9}, {3.7154342937275724`*^9, 3.715434338547635*^9}, 
   3.7154344363777723`*^9, {3.7155006484963007`*^9, 3.7155006675763273`*^9}, {
   3.7207691690229654`*^9, 3.720769173592972*^9}, {3.720769397263285*^9, 
   3.720769404043295*^9}},
 ExpressionUUID -> "5122f48b-949c-4830-bcd9-9a3f1e5fa506"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"LStringQ", "[", "x", "]"}], TraditionalForm]],ExpressionUUID->
  "82108d63-9325-46e2-919f-54f799654cd3"],
 " tests whether the string ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "cd8040c6-26fc-4cf1-b08c-af1a571e48ca"],
 " corresponds to a logical formula in the prefix (= Polish) notation. The \
output is ",
 Cell[BoxData[
  FormBox["True", TraditionalForm]],ExpressionUUID->
  "4984700c-7262-4d6a-a398-e92f30d2bf02"],
 " if it does and ",
 Cell[BoxData[
  FormBox["False", TraditionalForm]],ExpressionUUID->
  "39e738c5-b7a6-4141-8355-c69e284d596f"],
 " in the opposite case. With the option ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Trace", "\[Rule]", "True"}], TraditionalForm]],ExpressionUUID->
  "a32352fa-5632-4da9-a74d-bcd8f10ecc55"],
 " the main steps to the result are displayed. \nAlternatives for options \
(default value = the first alternative) :\n- Alignment -> Center | Left | \
Right,\n- Trace -> False | True."
}], "Text",
 CellMargins->{{18.6875, 10.}, {7., 7.}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"dda2458b-6570-4893-94b3-49ff77400f43"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "LStringQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "LStringQ", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "LStringQ", "]"}], "=", 
   RowBox[{"{", "Listable", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "LStringQ", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
      RowBox[{"Trace", "\[Rule]", "False"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LStringQ", "[", 
    RowBox[{"x_String", ",", "opts___Rule"}], "]"}], ":=", 
   RowBox[{"False", "/;", 
    RowBox[{"x", "===", "\"\<\>\""}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LStringQ", "[", 
    RowBox[{"x_String", ",", "opts___Rule"}], "]"}], ":=", 
   RowBox[{"False", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Private`Strings", "[", "1", "]"}], ",", 
      RowBox[{"StringTake", "[", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}]}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LStringQ", "[", 
    RowBox[{"x_String", ",", "opts___Rule"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "alignment", ",", "p", ",", "positions", ",", "trace", ",", "xx", ",", 
       "xx1", ",", "xxx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"alignment", ",", "trace"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Alignment", ",", "Trace"}], "}"}], "/.", 
         RowBox[{"{", "opts", "}"}]}], "/.", 
        RowBox[{"Options", "[", "LStringQ", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"StringReplace", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Thread", "[", 
          RowBox[{"Rule", "[", 
           RowBox[{
            RowBox[{"Strings", "[", "2", "]"}], ",", 
            RowBox[{"Strings", "[", "1", "]"}]}], "]"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"StringReplace", "[", 
          RowBox[{"xx", ",", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Rule", "[", 
               RowBox[{"#", ",", 
                RowBox[{"\"\< \>\"", "~~", "#", "~~", "\"\< \>\""}]}], "]"}], 
              "&"}], ",", 
             RowBox[{"Strings", "[", "1", "]"}]}], "]"}]}], "]"}], "//", 
         "ReduceSpaces"}], "//", "StringTrim"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"{", 
        RowBox[{"{", "xx", "}"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"StringFreeQ", "[", 
          RowBox[{"xx", ",", "\"\<Subscript\>\""}], "]"}]}], ",", 
        RowBox[{"xxx", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"xxx", ",", 
           RowBox[{"{", 
            RowBox[{"xx", "=", 
             RowBox[{"SubscriptBoxToString", "[", "xx", "]"}]}], "}"}]}], 
          "]"}]}]}], "]"}], ";", 
      RowBox[{"xx", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{
         RowBox[{"StringToStream", "[", "xx", "]"}], ",", "Word"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"Print", "[", "False", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx1", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"xx", ",", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"Strings", "[", "1", "]"}], ",", "#"}], "]"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx1", "=", 
       RowBox[{"RestoreSubscript", "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"xx1", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"LAtomQ", "[", 
             RowBox[{"#", "//", "ToExpression"}], "]"}], "===", "False"}], 
           "&"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx1", "=!=", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"If", "[", 
          RowBox[{"trace", ",", 
           RowBox[{"StringForm", "[", 
            RowBox[{
            "\"\<False: Members of the list `` are not logical \
variables.\>\"", ",", "xx1"}], "]"}], ",", "False"}], "]"}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"xx", "/.", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"Strings", "[", "1", "]"}], ",", 
           RowBox[{"Strings", "[", "3", "]"}]}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"StringFreeQ", "[", 
              RowBox[{"#", ",", "\"\<$\>\""}], "]"}], "&"}], "/@", "xx"}], 
           ",", "False"}], "]"}], ",", 
         RowBox[{"RestoreSubscript", "/@", "xx"}], ",", 
         RowBox[{"ToExpression", "/@", "xx"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"xxx", ",", "xx"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"positions", "=", 
       RowBox[{"Position", "[", 
        RowBox[{"xx", ",", 
         RowBox[{"Apply", "[", 
          RowBox[{"Alternatives", ",", "Connectives"}], "]"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"positions", "=", 
       RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"positions", "=!=", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"p", "=", 
          RowBox[{"Last", "[", "positions", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "===", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{"p", "\[LessEqual]", 
              RowBox[{
               RowBox[{"Length", "[", "xx", "]"}], "-", "1"}]}]}], "]"}], ",",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"ReplacePart", "[", 
                RowBox[{"xx", ",", 
                 RowBox[{"p", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"p", "+", "1"}], "}"}]}], "]"}]}], ";", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"xxx", ",", "xx"}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "===", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{"p", "==", 
              RowBox[{"Length", "[", "xx", "]"}]}]}], "]"}], ",", "xxx", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "=!=", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"p", "+", "2"}], "\[LessEqual]", 
              RowBox[{"Length", "[", "xx", "]"}]}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"ReplacePart", "[", 
                RowBox[{"xx", ",", 
                 RowBox[{"p", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"p", "+", "1"}], ",", 
                 RowBox[{"p", "+", "2"}]}], "}"}]}], "]"}]}], ";", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"xxx", ",", "xx"}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "=!=", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"p", "+", "2"}], ">", 
              RowBox[{"Length", "[", "xx", "]"}]}]}], "]"}], ",", "xxx"}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"positions", "=", 
          RowBox[{"Drop", "[", 
           RowBox[{"positions", ",", 
            RowBox[{"-", "1"}]}], "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Last", "@", "xxx"}], "]"}], ">", "1"}], ",", " ", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"xxx", ",", 
          RowBox[{"{", "False", "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"trace", ",", 
        RowBox[{"xxx", "//", 
         RowBox[{
          RowBox[{"Column", "[", 
           RowBox[{"#", ",", "alignment"}], "]"}], "&"}]}], ",", 
        RowBox[{"Last", "@", 
         RowBox[{"Last", "@", "xxx"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LStringQ", "]"}], ";"}]}], "Input",
 CellMargins->{{17.375, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "02ed6c46-7908-48b1-b2aa-03666446b409"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "NormalizeLString", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalizeLString", "[", "s_String", "]"}], ":=", 
   RowBox[{
    RowBox[{"FixedPoint", "[", 
     RowBox[{"ReduceSpaces", ",", 
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{"StringReplace", "[", 
         RowBox[{"s", ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{
             RowBox[{"Strings", "[", "2", "]"}], ",", 
             RowBox[{"Strings", "[", "1", "]"}]}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"Strings", "[", "1", "]"}], ",", 
           RowBox[{"Strings", "[", "4", "]"}]}], "]"}], "]"}]}], "]"}]}], 
     "]"}], "//", "StringTrim"}]}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "50d2e843-0edd-46f7-84a4-dda11db8e23c"],

Cell[CellGroupData[{

Cell["Conversion between Logical Strings and Formulas", "Subsubsection",
 CellMargins->{{18, 3}, {8, 12}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7154354215891514`*^9, 3.715435456749201*^9}},
 FontSize->14,ExpressionUUID->"5587dd38-598c-4e27-944d-392c842d350e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"ToLFormula", "[", "x", "]"}], TraditionalForm]],ExpressionUUID->
  "ba3a4a51-e91c-4ec2-b74c-7973ac1c976d"],
 " tests whether the string ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "4bb28635-5f9f-426c-a13a-60afbdcc0b8e"],
 " corresponds to a logical formula in the prefix (= Polish) notation, and  \
returns a logical formula if the test is succesful or $Failed in the opposite \
case.  With the option ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Trace", "\[Rule]", "True"}], TraditionalForm]],ExpressionUUID->
  "0f020399-b8d5-429c-904d-05ef4decacad"],
 " the main steps to the result are displayed. \nAlternatives for options \
(default value = the first alternative) :\n- Alignment -> Center | Left | \
Right,\n- Trace -> False | True."
}], "Text",
 CellMargins->{{17.999999999999993`, 10.}, {7., 7.}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"fdf10bb5-f3dc-4379-b70f-161ddfc92d4f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ToLFormula", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "ToLFormula", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "ToLFormula", "]"}], "=", 
   RowBox[{"{", "Listable", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ToLFormula", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
      RowBox[{"Trace", "\[Rule]", "False"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLFormula", "[", 
    RowBox[{"x_String", ",", "opts___Rule"}], "]"}], ":=", 
   RowBox[{"$Failed", "/;", 
    RowBox[{"x", "===", "\"\<\>\""}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLFormula", "[", 
    RowBox[{"x_String", ",", "opts___Rule"}], "]"}], ":=", 
   RowBox[{"$Failed", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Strings", "[", "1", "]"}], ",", 
      RowBox[{"StringTake", "[", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}]}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLFormula", "[", 
    RowBox[{"x_String", ",", "opts___Rule"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "alignment", ",", "p", ",", "positions", ",", "rules", ",", "trace", 
       ",", "xx", ",", "xx1", ",", "xxx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"alignment", ",", "trace"}], "}"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Alignment", ",", "Trace"}], "}"}], "/.", 
          RowBox[{"{", "opts", "}"}]}], "/.", 
         RowBox[{"Options", "[", "ToLFormula", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xx", "=", 
        RowBox[{"StringReplace", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{
             RowBox[{"Strings", "[", "2", "]"}], ",", 
             RowBox[{"Strings", "[", "1", "]"}]}], "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"xx", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"StringReplace", "[", 
           RowBox[{"xx", ",", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Rule", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"\"\< \>\"", "~~", "#", "~~", "\"\< \>\""}]}], "]"}],
                "&"}], ",", 
              RowBox[{"Strings", "[", "1", "]"}]}], "]"}]}], "]"}], "//", 
          "ReduceSpaces"}], "//", "StringTrim"}]}], ";"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"{", 
        RowBox[{"{", "xx", "}"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"xx", "//", "ReduceSpaces"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\\), \\(\>\"", " ", "\[Rule]", " ", "\"\<\\),\\(\>\""}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"xx", ",", "\"\<Subscript\>\""}], "]"}]}], ",", 
        RowBox[{"xx", "=", 
         RowBox[{"SubscriptBoxToString", "[", "xx", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{
         RowBox[{"StringToStream", "[", "xx", "]"}], ",", "Word"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"SetAttributes", "[", 
            RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", 
          "Connectives"}], ";", 
         RowBox[{"Return", "[", "False", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx1", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"xx", ",", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"Strings", "[", "1", "]"}], ",", "#"}], "]"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx1", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"xx1", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"LAtomQ", "[", 
            RowBox[{
             RowBox[{"StringReplace", "[", 
              RowBox[{"#", ",", 
               RowBox[{"\"\<$\>\"", "\[Rule]", "\"\<\>\""}]}], "]"}], "//", 
             "ToExpression"}], "]"}], "===", "False"}], "&"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"xx1", "=", 
       RowBox[{"RestoreSubscript", "/@", "xx1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx1", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"SetAttributes", "[", 
            RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", 
          "Connectives"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"If", "[", 
           RowBox[{"trace", ",", 
            RowBox[{"StringForm", "[", 
             RowBox[{
             "\"\<False: Members of the list `` are not logical \
variables.\>\"", ",", "xx1"}], "]"}], ",", "$Failed"}], "]"}], "]"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"xx", "/.", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"Strings", "[", "1", "]"}], ",", 
           RowBox[{"Strings", "[", "3", "]"}]}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"xxx", ",", 
         RowBox[{"xx", "=", 
          RowBox[{"Map", "[", 
           RowBox[{"RestoreSubscript", ",", "xx"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"positions", "=", 
       RowBox[{"Position", "[", 
        RowBox[{"xx", ",", 
         RowBox[{"Apply", "[", 
          RowBox[{"Alternatives", ",", "Connectives"}], "]"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"positions", "=", 
       RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"positions", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{
         RowBox[{"p", "=", 
          RowBox[{"Last", "[", "positions", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "===", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"p", "+", "1"}], "\[LessEqual]", 
              RowBox[{"Length", "[", "xx", "]"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"ReplacePart", "[", 
                RowBox[{"xx", ",", 
                 RowBox[{"p", "\[Rule]", 
                  RowBox[{"PrecedenceForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"xx", "[", 
                    RowBox[{"[", "p", "]"}], "]"}], "@", 
                    RowBox[{"xx", "[", 
                    RowBox[{"[", 
                    RowBox[{"p", "+", "1"}], "]"}], "]"}]}], ",", "600"}], 
                   "]"}]}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"p", "+", "1"}], "}"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xxx", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"xxx", ",", "xx"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "===", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{"p", "==", 
              RowBox[{"Length", "[", "xx", "]"}]}]}], "]"}], ",", "xxx", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "=!=", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"p", "+", "2"}], "\[LessEqual]", 
              RowBox[{"Length", "[", "xx", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"xx", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"p", "+", "1"}], ";;", 
                  RowBox[{"p", "+", "2"}]}], "]"}], "]"}], "\[Intersection]", 
               "Connectives"}], "===", 
              RowBox[{"{", "}"}]}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"ReplacePart", "[", 
                RowBox[{"xx", ",", 
                 RowBox[{"p", "\[Rule]", 
                  RowBox[{"PrecedenceForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"xx", "[", 
                    RowBox[{"[", "p", "]"}], "]"}], "@@", 
                    RowBox[{"xx", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"p", "+", "1"}], ";;", 
                    RowBox[{"p", "+", "2"}]}], "]"}], "]"}]}], ",", "100"}], 
                   "]"}]}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"p", "+", "1"}], ",", 
                 RowBox[{"p", "+", "2"}]}], "}"}]}], "]"}]}], ";", 
            RowBox[{"xxx", "=", 
             RowBox[{"AppendTo", "[", 
              RowBox[{"xxx", ",", "xx"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"NOT", "=!=", 
              RowBox[{"Part", "[", 
               RowBox[{"xx", ",", "p"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"p", "+", "2"}], ">", 
              RowBox[{"Length", "[", "xx", "]"}]}]}], "]"}], ",", "xxx"}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"positions", "=", 
          RowBox[{"Drop", "[", 
           RowBox[{"positions", ",", 
            RowBox[{"-", "1"}]}], "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SetAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Last", "@", "xxx"}], "]"}], ">", "1"}], ",", " ", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"xxx", ",", 
          RowBox[{"{", "$Failed", "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"trace", ",", 
        RowBox[{"xxx", "//", 
         RowBox[{
          RowBox[{"Column", "[", 
           RowBox[{"#", ",", "alignment"}], "]"}], "&"}]}], ",", 
        RowBox[{"Last", "@", 
         RowBox[{"Last", "@", "xxx"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ToLFormula", "]"}], ";"}]}], "Input",
 CellMargins->{{17.999999999999996`, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.8191141269966*^9, 3.8191141582729626`*^9}},
 ExpressionUUID -> "61be6a54-a571-48f9-a50d-b83bf56c0d28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"ToLString", "[", "x", "]"}], TraditionalForm]],ExpressionUUID->
  "ae18bbff-5efe-4255-ade8-8996a0364857"],
 " converts a logical formula ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "4a2b3d17-7a49-4574-939b-260f002a8d65"],
 " to a string corresponding to its prefix (Polish) version.  With the option \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"Trace", "\[Rule]", "True"}], TraditionalForm]],ExpressionUUID->
  "64c29b2d-33f1-4490-adb3-6ac83b008b84"],
 " the main steps to the result are displayed. \nAlternatives for options \
(default value = the first alternative) :\n- Alignment -> Center | Left | \
Right,\n- Trace -> False | True."
}], "Text",
 CellMargins->{{18, 10}, {7, 7}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"c1f88192-1d2e-49fd-a3a0-4ef69e950a22"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ToLString", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "ToLString", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "ToLString", "]"}], "=", 
   RowBox[{"{", "Listable", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ToLString", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
      RowBox[{"Trace", "\[Rule]", "False"}]}], "}"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLString", "[", 
    RowBox[{"x_", ",", "opts___Rule"}], "]"}], ":=", 
   RowBox[{"$Failed", "/;", 
    RowBox[{"Not", "[", 
     RowBox[{"LFormulaQ", "[", "x", "]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLString", "[", 
    RowBox[{"x_", ",", "opts___Rule"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ToString", "[", 
     RowBox[{"x", ",", "StandardForm"}], "]"}], "/;", 
    RowBox[{"LAtomQ", "[", "x", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToLString", "[", 
    RowBox[{"x_", ",", "opts___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "alignment", ",", "rules1", ",", "rules2", ",", "ssVariables1", ",", 
       "ssVariables2", ",", "ss1", ",", "ss2", ",", "ss3", ",", "trace", ",", 
       "xx", ",", "xxx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ClearAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"alignment", ",", "trace"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Alignment", ",", "Trace"}], "}"}], "/.", 
         RowBox[{"{", "opts", "}"}]}], "/.", 
        RowBox[{"Options", "[", "ToLString", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"FixedPoint", "[", 
         RowBox[{"ReleaseHold", ",", "x"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FALSE", "\[Rule]", "False"}], ",", 
          RowBox[{"TRUE", "\[Rule]", "True"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"{", 
        RowBox[{"{", "xx", "}"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ssVariables1", "=", 
       RowBox[{
        RowBox[{"Cases", "[", 
         RowBox[{"xx", ",", 
          RowBox[{"Subscript", "[", 
           RowBox[{"_", ",", "_"}], "]"}], ",", "\[Infinity]"}], "]"}], "//", 
        "Union"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ssVariables1", "=!=", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ss1", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"RemoveSubscript", "[", "#", "]"}], "]"}], "&"}], "/@", 
           "ssVariables1"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"ssVariables2", "=", 
          RowBox[{"ToExpression", "/@", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"#", ",", "\"\<\[Bullet]\>\""}], "]"}], "&"}], ",", 
             "ss1"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"ss2", "=", 
          RowBox[{"ToString", "/@", "ssVariables2"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rules1", "=", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{"ssVariables1", ",", "ssVariables2"}], "]"}], "]"}]}], 
         ";", 
         RowBox[{"ss3", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"StringReplace", "[", 
             RowBox[{"#", ",", 
              RowBox[{
               RowBox[{
                RowBox[{"u", ":", "LetterCharacter"}], "~~", "\"\<$\>\"", "~~", 
                RowBox[{"v", ":", 
                 RowBox[{"DigitCharacter", ".."}]}], "~~", 
                "\"\<\[Bullet]\>\""}], "\[RuleDelayed]", 
               RowBox[{
               "\"\<\[VeryThinSpace]\[VeryThinSpace]\\!\\(\\*SubscriptBox[\\(\
\>\"", "~~", "u", "~~", "\"\<\\), \\(\>\"", "~~", "v", "~~", 
                "\[VeryThinSpace]", "\"\<\\)]\\)\[VeryThinSpace]\>\""}]}]}], 
             "]"}], "&"}], "/@", "ss2"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"rules2", "=", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{"ss2", ",", "ss3"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xxx", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"xxx", ",", 
            RowBox[{
             RowBox[{"xx", "=", 
              RowBox[{"xx", "/.", "rules1"}]}], ";", 
             RowBox[{"{", "xx", "}"}]}]}], "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"xxx", ",", 
         RowBox[{
          RowBox[{"xx", "=", 
           RowBox[{"xx", "//", "ToString"}]}], ";", 
          RowBox[{"{", "xx", "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"StringReplace", "[", 
          RowBox[{"xx", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"\"\<]\>\"", "..."}], "~~", "\"\<]\>\""}], "\[Rule]", 
              "\"\<]\>\""}], ",", 
             RowBox[{"\"\<, \>\"", "\[Rule]", "\"\< \>\""}]}], "}"}]}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<[\>\"", "\[Rule]", "\"\< \>\""}], ",", 
           RowBox[{"\"\<]\>\"", "\[Rule]", "\"\< \>\""}]}], "}"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"xxx", ",", 
         RowBox[{
          RowBox[{"xx", "=", 
           RowBox[{
            RowBox[{"xx", "//", "ReduceSpaces"}], "//", "StringTrim"}]}], ";", 
          RowBox[{"{", "xx", "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"xxx", ",", 
         RowBox[{"xx", "=", 
          RowBox[{
           RowBox[{"StringSplit", "[", "xx", "]"}], "/.", 
           RowBox[{"Thread", "[", 
            RowBox[{"Rule", "[", 
             RowBox[{
              RowBox[{"Strings", "[", "3", "]"}], ",", 
              RowBox[{"Strings", "[", "1", "]"}]}], "]"}], "]"}]}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\< \[VeryThinSpace]\>\"", ",", "#"}], "]"}], "&"}], ",",
          "xx"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xxx", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"xxx", ",", 
         RowBox[{
          RowBox[{"xx", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"xx", "//", "StringJoin"}], "//", "ReduceSpaces"}], "//",
               "StringTrim"}], ",", 
             RowBox[{"\"\< \>\"", "\[Rule]", "\"\<\[VeryThinSpace]\>\""}]}], 
            "]"}]}], ";", 
          RowBox[{"{", "xx", "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ssVariables1", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"xxx", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"xxx", ",", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"StringReplace", "[", 
              RowBox[{"xx", ",", "rules2"}], "]"}]}], ";", " ", 
            RowBox[{"{", "xx", "}"}]}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SetAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"trace", ",", 
        RowBox[{"xxx", "//", 
         RowBox[{
          RowBox[{"Column", "[", 
           RowBox[{"#", ",", "alignment"}], "]"}], "&"}]}], ",", "xx"}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ToLString", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.8191141823908854`*^9, 3.819114205929249*^9}, 
   3.8191157101663647`*^9},
 ExpressionUUID -> "87b831ba-96bc-4400-b81f-0165ec3dfd10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TruthTable", "Subsubsection",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.715865138048131*^9, 3.715865156208156*^9}, 
   3.7158651972982135`*^9},
 FontSize->14,ExpressionUUID->"276312b0-7599-47c1-9b28-48f088802614"],

Cell["\<\
TruthTable[x,options] computes the truth table of the logical formula or list \
of logical formulae x and outputs or prints it as Grid.- Alternatives for \
options (default value = the first alternative) :
- BooleanValues -> { 0,  1} | {False,True} | -> {FalseSymbol,  TrueSymbol},
- ReverseValues -> False | True,
- ItemSize -> Automatic | Full | as for Grid,
- Labels -> None | Automatic |  list of sufficient length,
- Print -> False | True,
- SelectValuations -> All | AllTrue | Mixed | AllFalse | LastTrue | LastFalse \
| 
                          OnlyLastFalse | {{ (indexes | labels of) formulae} \
-> FalseSymbol, {(indexes | labels of) formulae} -> TrueSymbol},
- TableBreaks -> None | integer > 1 | increasing list of integers > 1,
- Transpose -> False | True,
- Variables -> All | List of logical variables.
ItemSize is an option of Grid and Transpose is an option of List, Matrix and \
Tensor.\
\>", "Text",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"13c1389b-bcbb-4064-96e8-249c8e59bf16"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "TruthTable", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "TruthTable", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "TruthTable", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BooleanValues", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"ItemSize", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"Labels", "\[Rule]", "None"}], ",", 
      RowBox[{"Print", "\[Rule]", "False"}], ",", 
      RowBox[{"ReverseValues", "\[Rule]", "False"}], ",", 
      RowBox[{"SelectValuations", "\[Rule]", "All"}], ",", 
      RowBox[{"TableBreaks", "\[Rule]", "None"}], ",", 
      RowBox[{"Transpose", "\[Rule]", "False"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TruthTable", "[", 
    RowBox[{
     RowBox[{"x_List", "/;", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"LFormulaQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}], ",",
      "options___Rule"}], "]"}], ":=", 
   "\"\<Failed, a member of the first argument isn't logical formula\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TruthTable", "[", 
    RowBox[{"x_List", ",", "options___Rule"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "booleanValues", ",", "dividers", ",", "heading", ",", "itemSize", ",", 
       "labels", ",", "position0", ",", "position1", ",", "print", ",", 
       "reverseValues", ",", "selectValuations", ",", "table", ",", 
       "tableBreaks", ",", "tableLength", ",", "tableParts", ",", 
       "tableWidth", ",", "transpose", ",", "variables", ",", 
       "variablesLength", ",", "xx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ClearAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "booleanValues", ",", "itemSize", ",", "labels", ",", "print", ",", 
         "reverseValues", ",", " ", "selectValuations", ",", "tableBreaks", 
         ",", "transpose", ",", "variables"}], "}"}], "=", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "BooleanValues", ",", "ItemSize", ",", "Labels", ",", " ", "Print", 
           ",", "ReverseValues", ",", "SelectValuations", ",", " ", 
           "TableBreaks", ",", "Transpose", ",", "Variables"}], "}"}], "/.", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", "options", "}"}], "]"}]}], "/.", 
        RowBox[{"Options", "[", "TruthTable", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"FixedPoint", "[", 
         RowBox[{"ReleaseHold", ",", "x"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FALSE", "\[Rule]", "False"}], ",", 
          RowBox[{"TRUE", "\[Rule]", "True"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"variables", "===", "All"}], ",", 
         RowBox[{"LVariableSet", "[", "xx", "]"}], ",", 
         RowBox[{"Select", "[", 
          RowBox[{"variables", ",", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"FreeQ", "[", 
              RowBox[{"xx", ",", "#"}], "]"}]}], "&"}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Evaluating", " ", "formulae"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"variablesLength", "=", 
         RowBox[{"variables", "//", "Length"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"SetAttributes", "[", 
            RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", 
          "Connectives"}], ";", 
         RowBox[{"Return", "[", "\"\<There are no variables\>\"", "]"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{"Tuples", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", "reverseValues"}], ",", 
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"True", ",", "False"}], "}"}]}], "]"}], ",", 
         "variablesLength"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{"MapThread", "[", 
        RowBox[{"Join", ",", 
         RowBox[{"{", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"xx", "/.", 
              RowBox[{"MapThread", "[", 
               RowBox[{"Rule", ",", "#"}], "]"}]}], "&"}], "/@", 
            RowBox[{"Tuples", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "variables", "}"}], ",", "table"}], "}"}], 
             "]"}]}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Selecting", " ", "Valuations", " ", "according", " ", "to", " ", 
        "the", " ", "option", " ", "SelectValuations"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"labels", "===", "Automatic"}], ",", 
        RowBox[{"labels", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "[", "xx", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "labels", "]"}], "===", "List"}], "&&", 
         RowBox[{
          RowBox[{"Length", "[", "labels", "]"}], "\[GreaterEqual]", 
          RowBox[{"Length", "[", "xx", "]"}]}]}], ",", 
        RowBox[{"labels", "=", 
         RowBox[{"Take", "[", 
          RowBox[{"labels", ",", 
           RowBox[{"Length", "[", "xx", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "labels", "]"}], "===", "List"}], "&&", 
         RowBox[{"0", "<", 
          RowBox[{"Length", "[", "labels", "]"}], "<", 
          RowBox[{"Length", "[", "xx", "]"}]}]}], ",", 
        RowBox[{"labels", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"labels", ",", 
           RowBox[{"Table", "[", 
            RowBox[{"\"\< \>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Length", "[", "xx", "]"}], "-", 
               RowBox[{"Length", "[", "labels", "]"}]}], "}"}]}], "]"}]}], 
          "]"}]}], ",", "\[IndentingNewLine]", "True", ",", 
        RowBox[{"labels", "=", "False"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "labels", "]"}], "===", "List"}], "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "selectValuations", "]"}], "===", "List"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"selectValuations", "=", 
          RowBox[{"selectValuations", "/.", 
           RowBox[{"MapIndexed", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Rule", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"#2", "//", "First"}]}], "]"}], "&"}], ",", 
             "labels"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"selectValuations", "=", 
          RowBox[{"selectValuations", "/.", 
           RowBox[{
            RowBox[{"Rule", "[", 
             RowBox[{"u_", ",", "v_"}], "]"}], ":>", 
            RowBox[{"Rule", "[", 
             RowBox[{"u", ",", 
              RowBox[{"v", "/.", 
               RowBox[{"Thread", "[", 
                RowBox[{"Rule", "[", 
                 RowBox[{"booleanValues", ",", 
                  RowBox[{"{", 
                   RowBox[{"False", ",", "True"}], "}"}]}], "]"}], "]"}]}]}], 
             "]"}]}]}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"labels", "===", "False"}], "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "selectValuations", "]"}], "===", "List"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"selectValuations", "=", 
         RowBox[{"selectValuations", "/.", 
          RowBox[{
           RowBox[{"Rule", "[", 
            RowBox[{"u_", ",", "v_"}], "]"}], ":>", 
           RowBox[{"Rule", "[", 
            RowBox[{"u", ",", 
             RowBox[{"v", "/.", 
              RowBox[{"Thread", "[", 
               RowBox[{"Rule", "[", 
                RowBox[{"booleanValues", ",", 
                 RowBox[{"{", 
                  RowBox[{"False", ",", "True"}], "}"}]}], "]"}], "]"}]}]}], 
            "]"}]}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "selectValuations", "]"}], "===", "List"}], ",", 
        RowBox[{"selectValuations", "=", 
         RowBox[{"Sort", "[", 
          RowBox[{"selectValuations", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Order", "[", 
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"#2", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", "1"}], 
            "&"}]}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Selecting", " ", "valuations"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"selectValuations", "===", "AllTrue"}], ",", 
        RowBox[{"table", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"Drop", "[", 
               RowBox[{"#", ",", "variablesLength"}], "]"}], ",", "False"}], 
             "]"}], "&"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"selectValuations", "===", "Mixed"}], ",", 
        RowBox[{"table", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Union", "[", 
              RowBox[{"Drop", "[", 
               RowBox[{"#", ",", "variablesLength"}], "]"}], "]"}], "===", 
             RowBox[{"Union", "[", 
              RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}], "]"}]}], "&"}]}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"selectValuations", "===", "AllFalse"}], ",", 
        RowBox[{"table", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"Drop", "[", 
               RowBox[{"#", ",", "variablesLength"}], "]"}], ",", "True"}], 
             "]"}], "&"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"selectValuations", "===", "LastTrue"}], ",", 
        RowBox[{"table", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Last", "[", "#", "]"}], "===", "True"}], "&"}]}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"selectValuations", "===", "LastFalse"}], ",", 
        RowBox[{"table", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Last", "[", "#", "]"}], "===", "False"}], "&"}]}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"selectValuations", "===", "OnlyLastFalse"}], ",", " ", 
        RowBox[{"table", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{
               RowBox[{"Drop", "[", 
                RowBox[{"#", ",", "variablesLength"}], "]"}], ",", "False"}], 
              "]"}], "===", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"Length", "[", "xx", "]"}], "}"}], "}"}]}], "&"}]}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"selectValuations", ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"{", "__Integer", "}"}], "\[Rule]", "False"}], ",", 
             RowBox[{
              RowBox[{"{", "__Integer", "}"}], "\[Rule]", "True"}]}], "}"}], 
           "|", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "__Integer", "}"}], "\[Rule]", "False"}], "}"}], 
           "|", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "__Integer", "}"}], "\[Rule]", "True"}], "}"}]}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"position0", ",", "position1"}], "}"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"False", ",", "True"}], "}"}], "/.", 
            RowBox[{"Map", "[", 
             RowBox[{"Reverse", ",", "selectValuations"}], "]"}]}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"False", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
             RowBox[{"True", "\[Rule]", 
              RowBox[{"{", "}"}]}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"position0", "=!=", "False"}], ",", 
           RowBox[{
            RowBox[{"position0", "=", 
             RowBox[{
              RowBox[{"position0", "+", "variablesLength"}], "//", "Sort"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{"table", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"table", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Intersection", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"#", ",", "False"}], "]"}], "]"}], ",", 
                    "position0"}], "]"}], "===", "position0"}], ")"}], 
                "&"}]}], "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"position1", "=!=", "True"}], ",", 
           RowBox[{
            RowBox[{"position1", "=", 
             RowBox[{
              RowBox[{"position1", "+", "variablesLength"}], "//", "Sort"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{"table", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"table", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Intersection", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"#", ",", "True"}], "]"}], "]"}], ",", 
                    "position1"}], "]"}], "===", "position1"}], ")"}], 
                "&"}]}], "]"}]}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        "True", ",", "table"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"table", "===", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"SetAttributes", "[", 
            RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", 
          "Connectives"}], ";", 
         RowBox[{
         "Return", "[", "\"\<No valuations have been selected\>\"", "]"}]}]}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{"table", "/.", 
        RowBox[{"RuleDelayed", "[", 
         RowBox[{
          RowBox[{"u_", "/;", 
           RowBox[{"FreeQ", "[", 
            RowBox[{"u", ",", 
             RowBox[{"Alternatives", "@@", "Connectives"}]}], "]"}]}], ",", 
          RowBox[{"u", "/.", 
           RowBox[{"Thread", "[", 
            RowBox[{"Rule", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}], ",", "booleanValues"}], 
             "]"}], "]"}]}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SetAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Formating", " ", "output"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tableLength", ",", "tableWidth"}], "}"}], "=", 
       RowBox[{"Dimensions", "[", "table", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"heading", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"variables", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"tableBreaks", "~", "MatchQ", "~", "_Integer"}], ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"tableBreaks", "+", "1"}], ",", "tableLength", ",", " ", 
           "tableBreaks"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"tableBreaks", "~", "MatchQ", "~", 
         RowBox[{"{", "__Integer", "}"}]}], ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"tableBreaks", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"#", "\[LessEqual]", "tableLength"}], "&"}]}], "]"}]}], 
        ",", "\[IndentingNewLine]", "True", ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"{", "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tableBreaks", "=", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "tableBreaks", ",", 
         RowBox[{"{", 
          RowBox[{"tableLength", "+", "1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tableBreaks", "[", 
            RowBox[{"[", "#", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"tableBreaks", "[", 
             RowBox[{"[", 
              RowBox[{"#", "+", "1"}], "]"}], "]"}], "-", "1"}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Length", "[", "tableBreaks", "]"}], "-", "1"}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"table", ",", "#"}], "]"}], "&"}], "/@", "tableParts"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Prepend", "[", 
          RowBox[{"#", ",", "heading"}], "]"}], "&"}], "/@", "tableParts"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"labels", "=!=", "False"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tableParts", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"Prepend", "[", 
             RowBox[{"#", ",", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{"Global`\[FilledSmallCircle]", ",", 
                  RowBox[{"{", "variablesLength", "}"}]}], "]"}], ",", 
                "labels"}], "]"}]}], "]"}], "&"}], "/@", "tableParts"}]}], 
         ";", 
         RowBox[{"dividers", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Thick", ",", 
                RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
              RowBox[{
               RowBox[{"variablesLength", "+", "1"}], "\[Rule]", "Thick"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Thick", ",", "True", ",", "Thick", ",", 
                RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
              RowBox[{
               RowBox[{"-", "1"}], "\[Rule]", "Thick"}]}], "}"}]}], "}"}]}]}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"dividers", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Thick", ",", 
               RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
             RowBox[{
              RowBox[{"variablesLength", "+", "1"}], "\[Rule]", "Thick"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Thick", ",", "Thick", ",", 
               RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
             RowBox[{
              RowBox[{"-", "1"}], "\[Rule]", "Thick"}]}], "}"}]}], "}"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"transpose", ",", 
        RowBox[{
         RowBox[{"tableParts", "=", 
          RowBox[{"Transpose", "/@", "tableParts"}]}], ";", 
         RowBox[{"dividers", "=", 
          RowBox[{"Reverse", "[", "dividers", "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Grid", "[", 
          RowBox[{"#", ",", 
           RowBox[{"Dividers", "\[Rule]", "dividers"}], ",", 
           RowBox[{"ItemSize", "\[Rule]", "itemSize"}]}], "]"}], "&"}], "/@", 
        "tableParts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"print", "===", "False"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "table"}], "\[Equal]", "1"}], ",", 
          RowBox[{"First", "@", "table"}], ",", "table"}], "]"}], ",", 
        RowBox[{
         RowBox[{"StylePrint", "/@", "table"}], ";"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TruthTable", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"TruthTable", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "options"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "TruthTable", "]"}], ";"}]}], "Input",
 CellMargins->{{18.8125, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "f96339e6-240c-4729-bdd0-c4632c815898"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptyTruthTable", "Subsubsection",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.715865138048131*^9, 3.715865156208156*^9}, {
  3.7158651972982135`*^9, 3.715865226688255*^9}},
 FontSize->14,ExpressionUUID->"73968e30-002b-4ea7-ba7d-dd078e940aae"],

Cell["\<\
EmptyTruthTable[x, options] is a version of TruthTable with no truth-values \
for formulas.
- Alternatives for options (default value = the first alternative) :
- BooleanValues -> { 0,  1} | {False,True} | -> {FalseSymbol,  TrueSymbol},
- ReverseValues -> False | True,
- ItemSize -> Automatic | Full | as for Grid,
- Labels -> None | Automatic |  list of sufficient length,
- Print -> False | True,
- TableBreaks -> None | integer > 1 | increasing list of integers > 1,        
- Transpose -> False | True.\
\>", "Text",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7132055823139625`*^9, 3.7132056218240175`*^9}, {
   3.713890508733751*^9, 3.7138905201337667`*^9}, {3.713893350637729*^9, 
   3.713893356117737*^9}, {3.7139632884956264`*^9, 3.7139633955857763`*^9}, {
   3.713963459285866*^9, 3.7139634699058805`*^9}, {3.71396352677596*^9, 
   3.7139636093560753`*^9}, {3.713963657776143*^9, 3.7139637284262424`*^9}, {
   3.7139639132665014`*^9, 3.7139639270565205`*^9}, {3.713964229806944*^9, 
   3.713964230976946*^9}, {3.7139671580510435`*^9, 3.713967164721053*^9}, {
   3.7139675032315273`*^9, 3.7139675426315823`*^9}, {3.7139676296317043`*^9, 
   3.7139676371117144`*^9}, {3.713969117413787*^9, 3.7139691214837923`*^9}, {
   3.7139694058441906`*^9, 3.7139694235542154`*^9}, {3.713969471304282*^9, 
   3.713969473934286*^9}, {3.7139797812818103`*^9, 3.7139798063118453`*^9}, {
   3.71397992424201*^9, 3.713980014042136*^9}, {3.714076212189771*^9, 
   3.714076227139792*^9}, {3.7140763279799333`*^9, 3.714076469520131*^9}, {
   3.714076570750273*^9, 3.7140765766002812`*^9}, {3.714132010419361*^9, 
   3.7141320528394203`*^9}, {3.714157790761981*^9, 3.7141577938119855`*^9}, {
   3.7142299611341*^9, 3.7142299638541036`*^9}, 3.7143798114731607`*^9, {
   3.7143916120457296`*^9, 3.714391615145734*^9}, {3.714391654685789*^9, 
   3.714391663545802*^9}, {3.714391707035863*^9, 3.714391708045864*^9}, {
   3.714394694960046*^9, 3.7143946974500494`*^9}, 3.7158661780695868`*^9, {
   3.715871890097584*^9, 3.7158718969775934`*^9}, {3.7158719765077047`*^9, 
   3.715872024857772*^9}, {3.715872068297833*^9, 3.715872089137862*^9}, {
   3.715872177437986*^9, 3.7158721895480027`*^9}, {3.715872267078111*^9, 
   3.7158722723181186`*^9}, {3.7158750623220243`*^9, 3.715875067112031*^9}, {
   3.715875162442165*^9, 3.7158751817121916`*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"4b982091-2d3d-4f86-a3d6-f66c1ce84c9f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "EmptyTruthTable", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "EmptyTruthTable", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "EmptyTruthTable", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BooleanValues", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"ItemSize", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"Labels", "\[Rule]", "None"}], ",", 
      RowBox[{"Print", "\[Rule]", "False"}], ",", 
      RowBox[{"ReverseValues", "\[Rule]", "False"}], ",", 
      RowBox[{"SelectValuations", "\[Rule]", "All"}], ",", 
      RowBox[{"TableBreaks", "\[Rule]", "None"}], ",", 
      RowBox[{"Transpose", "\[Rule]", "False"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"EmptyTruthTable", "[", 
    RowBox[{
     RowBox[{"x_List", "/;", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"LFormulaQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}], ",",
      "options___Rule"}], "]"}], ":=", 
   "\"\<Failed, a member of the first argument isn't logical formula\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EmptyTruthTable", "[", 
    RowBox[{"x_List", ",", "options___Rule"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "booleanValues", ",", "dividers", ",", "heading", ",", "itemSize", ",", 
       "labels", ",", "print", ",", "reverseValues", ",", "table", ",", 
       "tableBreaks", ",", "tableLength", ",", "tableParts", ",", 
       "tableWidth", ",", "transpose", ",", "variables", ",", 
       "variablesLength", ",", "xx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ClearAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "booleanValues", ",", "itemSize", ",", "labels", ",", "print", ",", 
         "reverseValues", ",", "tableBreaks", ",", "transpose"}], "}"}], "=", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "BooleanValues", ",", "ItemSize", ",", "Labels", ",", " ", "Print", 
           ",", "ReverseValues", ",", " ", "TableBreaks", ",", "Transpose"}], 
          "}"}], "/.", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", "options", "}"}], "]"}]}], "/.", 
        RowBox[{"Options", "[", "TruthTable", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"LVariableSet", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"FixedPoint", "[", 
         RowBox[{"ReleaseHold", ",", "x"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FALSE", "\[Rule]", "False"}], ",", 
          RowBox[{"TRUE", "\[Rule]", "True"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"variablesLength", "=", 
         RowBox[{"variables", "//", "Length"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"SetAttributes", "[", 
            RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", 
          "Connectives"}], ";", 
         RowBox[{"Return", "[", "\"\<There are no variables\>\"", "]"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{"Tuples", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", "reverseValues"}], ",", 
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"True", ",", "False"}], "}"}]}], "]"}], ",", 
         "variablesLength"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{"table", "/.", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", "booleanValues"}], 
          "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"#", ",", 
            RowBox[{"Table", "[", 
             RowBox[{"\"\< \>\"", ",", 
              RowBox[{"{", 
               RowBox[{"xx", "//", "Length"}], "}"}]}], "]"}]}], "]"}], "&"}],
          ",", "table"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"labels", "===", "Automatic"}], ",", 
        RowBox[{"labels", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "[", "xx", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "labels", "]"}], "===", "List"}], "&&", 
         RowBox[{
          RowBox[{"Length", "[", "labels", "]"}], "\[GreaterEqual]", 
          RowBox[{"Length", "[", "xx", "]"}]}]}], ",", 
        RowBox[{"labels", "=", 
         RowBox[{"Take", "[", 
          RowBox[{"labels", ",", 
           RowBox[{"Length", "[", "xx", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "labels", "]"}], "===", "List"}], "&&", 
         RowBox[{"0", "<", 
          RowBox[{"Length", "[", "labels", "]"}], "<", 
          RowBox[{"Length", "[", "xx", "]"}]}]}], ",", 
        RowBox[{"labels", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"labels", ",", 
           RowBox[{"Table", "[", 
            RowBox[{"\"\< \>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Length", "[", "xx", "]"}], "-", 
               RowBox[{"Length", "[", "labels", "]"}]}], "}"}]}], "]"}]}], 
          "]"}]}], ",", "\[IndentingNewLine]", "True", ",", 
        RowBox[{"labels", "=", "False"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SetAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Formating", " ", "output"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tableLength", ",", "tableWidth"}], "}"}], "=", 
       RowBox[{"Dimensions", "[", "table", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"heading", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"variables", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"tableBreaks", "~", "MatchQ", "~", "_Integer"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"tableBreaks", "+", "1"}], ",", "tableLength", ",", " ", 
           "tableBreaks"}], "]"}]}], ",", 
        RowBox[{"tableBreaks", "~", "MatchQ", "~", 
         RowBox[{"{", "__Integer", "}"}]}], ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"tableBreaks", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"#", "\[LessEqual]", "tableLength"}], "&"}]}], "]"}]}], 
        ",", "\[IndentingNewLine]", "True", ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"{", "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tableBreaks", "=", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "tableBreaks", ",", 
         RowBox[{"{", 
          RowBox[{"tableLength", "+", "1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tableBreaks", "[", 
            RowBox[{"[", "#", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"tableBreaks", "[", 
             RowBox[{"[", 
              RowBox[{"#", "+", "1"}], "]"}], "]"}], "-", "1"}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Length", "[", "tableBreaks", "]"}], "-", "1"}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"table", ",", "#"}], "]"}], "&"}], "/@", "tableParts"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Prepend", "[", 
          RowBox[{"#", ",", "heading"}], "]"}], "&"}], "/@", "tableParts"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"labels", "=!=", "False"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tableParts", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"Prepend", "[", 
             RowBox[{"#", ",", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{"Global`\[FilledSmallCircle]", ",", 
                  RowBox[{"{", "variablesLength", "}"}]}], "]"}], ",", 
                "labels"}], "]"}]}], "]"}], "&"}], "/@", "tableParts"}]}], 
         ";", 
         RowBox[{"dividers", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Thick", ",", 
                RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
              RowBox[{
               RowBox[{"variablesLength", "+", "1"}], "\[Rule]", "Thick"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Thick", ",", "True", ",", "Thick", ",", 
                RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
              RowBox[{
               RowBox[{"-", "1"}], "\[Rule]", "Thick"}]}], "}"}]}], "}"}]}]}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"dividers", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Thick", ",", 
               RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
             RowBox[{
              RowBox[{"variablesLength", "+", "1"}], "\[Rule]", "Thick"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Thick", ",", "Thick", ",", 
               RowBox[{"{", "True", "}"}], ",", "Thick"}], "}"}], ",", 
             RowBox[{
              RowBox[{"-", "1"}], "\[Rule]", "Thick"}]}], "}"}]}], "}"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"transpose", ",", 
        RowBox[{
         RowBox[{"tableParts", "=", 
          RowBox[{"Transpose", "/@", "tableParts"}]}], ";", 
         RowBox[{"dividers", "=", 
          RowBox[{"Reverse", "[", "dividers", "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Grid", "[", 
          RowBox[{"#", ",", 
           RowBox[{"Dividers", "\[Rule]", "dividers"}], ",", 
           RowBox[{"ItemSize", "\[Rule]", "itemSize"}]}], "]"}], "&"}], "/@", 
        "tableParts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"print", "===", "False"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "table"}], "\[Equal]", "1"}], ",", 
          RowBox[{"First", "@", "table"}], ",", "table"}], "]"}], ",", 
        RowBox[{
         RowBox[{"StylePrint", "/@", "table"}], ";"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EmptyTruthTable", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"EmptyTruthTable", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "options"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "EmptyTruthTable", "]"}], ";"}]}], "Input",
 CellMargins->{{18.8125, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "cf7ee949-a549-40e1-a9dd-8867e459bbf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tests of Tautology and Tautological Equivalence", "Subsubsection",
 CellMargins->{{18.4375, 3.}, {8., 12.}},
 PageBreakWithin->True,
 FontSize->14,ExpressionUUID->"f15f8cdb-54fb-4920-9fa3-de76e3fa25b9"],

Cell[TextData[{
 " LTautologyQ[",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "ed8d543a-7b1c-490e-b503-c9a32e9b652b"],
 "] returns True if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "dedbcd89-0a26-49c1-bd1a-0e87c9e61471"],
 " is a tautology, and False if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "5a134acc-fccb-401d-9843-382eb0915b08"],
 " is a logical formula but not a tautology."
}], "Text",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.713450714210642*^9, 3.7134507273306603`*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"cad9ac1b-64b7-4526-9988-2efecadb9adc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "LTautologyQ", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "LTautologyQ", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"LTautologyQ", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LTautologyQ", "[", "x_", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tuples", ",", "variables", ",", "xx"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"xx", "=", 
        RowBox[{"FixedPoint", "[", 
         RowBox[{"ReleaseHold", ",", "x"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"xx", "=!=", "True"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"xx", "=", 
           RowBox[{
            RowBox[{"xx", "/.", 
             RowBox[{"FALSE", "\[Rule]", "False"}]}], "/.", 
            RowBox[{"TRUE", "\[Rule]", "True"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"variables", "=", 
           RowBox[{"LVariableSet", "[", "xx", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"tuples", "=", 
           RowBox[{"Tuples", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"False", ",", "True"}], "}"}], ",", 
             RowBox[{"Length", "[", "variables", "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"xx", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"xx", "/.", 
              RowBox[{"MapThread", "[", 
               RowBox[{"Rule", ",", "#"}], "]"}]}], "&"}], "/@", 
            RowBox[{"Tuples", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "variables", "}"}], ",", "tuples"}], "}"}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"SetAttributes", "[", 
             RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", 
           "Connectives"}], ";", "\[IndentingNewLine]", 
          RowBox[{"xx", "=", 
           RowBox[{"MatchQ", "[", 
            RowBox[{
             RowBox[{"Union", "[", "xx", "]"}], ",", 
             RowBox[{"{", "True", "}"}]}], "]"}]}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", "xx"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", "x", "]"}], "===", "True"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LTautologyQ", "[", "x_", "]"}], ":=", 
   "\"\<Failed, the argument is not a logical formula\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LTautologyQ", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "4757dbc3-a474-492f-8d71-0c91fd15b8cb"],

Cell[TextData[{
 "LEquivalentQ[ ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "e5ea2701-7146-4365-83e0-77388ee73e65"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "409f6c85-4be5-4ba8-8027-8a69d24d4673"],
 " ] returns True if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "2018f6ea-fcaf-4c60-ac13-1bd05b2baadb"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "e4cd0a34-9081-4425-a6d2-03cd9986b7f3"],
 " are logically equivalent logical formulas, and False if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "bdddad84-9d61-4d77-9063-524aa8bbff3b"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "27a05a9e-33dc-45bb-8edd-03173fdaa607"],
 " are logically inequvalent logical formulas."
}], "Text",
 CellMargins->{{18.375, 3.}, {8., 12.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7134507717007227`*^9, 3.713450782920738*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"d8285a0b-08b0-47f4-a27a-8feab4f006f6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "LEquivalentQ", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "LEquivalentQ", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LEquivalentQ", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"LTautologyQ", "[", 
     RowBox[{"x", "\[Equivalent]", "y"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"LFormulaQ", "[", 
      RowBox[{"x", "\[Equivalent]", "y"}], "]"}], "===", "True"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LEquivalentQ", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   "\"\<Failed, some argument is not a logical formula\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LEquivalentQ", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{
  3.713199589456045*^9, {3.7149831863666196`*^9, 3.7149831919066277`*^9}, {
   3.714983304466785*^9, 3.7149833291568193`*^9}, {3.7149834050469255`*^9, 
   3.7149834233469515`*^9}, {3.714989104924906*^9, 3.714989110214913*^9}, {
   3.714990961767505*^9, 3.7149909851275377`*^9}, 3.7149911641377883`*^9, {
   3.7149911994678383`*^9, 3.7149912647879295`*^9}, {3.7154360846700797`*^9, 
   3.7154361286301413`*^9}},
 ExpressionUUID -> "3182573b-25bc-44a9-a8b3-5de185261238"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Conjunctive and Disjunctive Normal Forms - Complete and Simplified\
\>", "Subsubsection",
 CellMargins->{{18.375, 3.}, {8., 12.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.715436224350275*^9, 3.7154362330302877`*^9}},
 FontSize->14,ExpressionUUID->"813a74a1-f7b1-499d-8047-2adbdd436f6a"],

Cell[CellGroupData[{

Cell["\<\
CNF[ x, Complete | 1 ] returns the complete CNF of a logical formula x \
obtained from the truth table of x.
CNF[ x, Minimal | 0 ] returns a simplified DNF of x obtained by the system \
function BooleanMinimize.
The second argument is optional and its default value is Simplified | 0.\
\>", "Text",
 CellMargins->{{18.375, 10.}, {7., 7.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7134521342496552`*^9, 3.7134521394196625`*^9}, {
   3.713452178989718*^9, 3.7134521986397457`*^9}, 3.7134522945098796`*^9, {
   3.713452378909998*^9, 3.7134523829100037`*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"2c80b200-d429-47a5-9db5-f6e35b29938f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "CNF", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "CNF", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"CNF", ",", "Listable"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CNF", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{"Not", "@", 
       RowBox[{"LFormulaQ", "[", "x", "]"}]}]}], ",", 
     RowBox[{"t_", ":", "Minimal"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   "\"\<Failed, the argument is not a logical formula\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CNF", "[", 
    RowBox[{"x_", ",", 
     RowBox[{"t_", ":", "Minimal"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rules", ",", "table", ",", "type", ",", "variables", ",", "varsnumber",
        ",", 
       RowBox[{"xx", "=", "x"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ClearAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"AND", ",", "OR"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"FixedPoint", "[", 
         RowBox[{"ReleaseHold", ",", "xx"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FALSE", "\[Rule]", "False"}], ",", 
          RowBox[{"TRUE", "\[Rule]", "True"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"type", "=", 
       RowBox[{"t", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Complete", "\[Rule]", "1"}], ",", 
          RowBox[{"Minimal", "\[Rule]", "0"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"rules", "=", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{"Connectives", ",", 
             RowBox[{"{", 
              RowBox[{
              "Not", ",", "And", ",", "Equivalent", ",", "Implies", ",", 
               "Nand", ",", "Nor", ",", "Or", ",", "Xor"}], "}"}]}], "]"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{
           RowBox[{"xx", "//.", "rules"}], "//", 
           RowBox[{
            RowBox[{"BooleanConvert", "[", 
             RowBox[{"#", ",", "\"\<CNF\>\""}], "]"}], "&"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rules", "=", 
          RowBox[{"Reverse", "/@", "rules"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"xx", "/.", "rules"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"type", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"variables", "=", 
          RowBox[{"LVariableSet", "[", "xx", "]"}]}], ";", 
         RowBox[{"varsnumber", "=", 
          RowBox[{"Length", "[", "variables", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{"Tuples", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"False", ",", "True"}], "}"}], ",", "varsnumber"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"rules", "=", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"MapThread", "[", 
              RowBox[{"Rule", ",", 
               RowBox[{"{", 
                RowBox[{"variables", ",", "#"}], "}"}]}], "]"}], "&"}], ",", 
            "table"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{"MapThread", "[", 
           RowBox[{"Join", ",", 
            RowBox[{"{", 
             RowBox[{"table", ",", 
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", "xx", "}"}], "/.", "#"}], ")"}], "&"}], ",", 
                "rules"}], "]"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Drop", "[", 
              RowBox[{"#", ",", 
               RowBox[{"-", "1"}]}], "]"}], "&"}], ",", 
            RowBox[{"Cases", "[", 
             RowBox[{"table", ",", 
              RowBox[{"{", 
               RowBox[{"___", ",", "False"}], "}"}]}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MapThread", "[", 
               RowBox[{"List", ",", 
                RowBox[{"{", 
                 RowBox[{"#", ",", "variables"}], "}"}]}], "]"}], "&"}], ",", 
             "table"}], "]"}], "//.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{"False", ",", "y_"}], "}"}], "\[Rule]", "y"}], ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"True", ",", "y_"}], "}"}], "\[Rule]", 
              RowBox[{"NOT", "[", "y", "]"}]}]}], "}"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"Apply", "[", 
           RowBox[{"AND", ",", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Apply", "[", 
                RowBox[{"OR", ",", "#"}], "]"}], "&"}], ",", "table"}], 
             "]"}]}], "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"AND", ",", "OR"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SetAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", "xx"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "CNF", "]"}], ";"}]}], "Input",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "9f7fc106-9d71-46be-9fc3-03414388c656"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DNF[x, Complete | 1] returns the complete DNF of a logical formula x obtained \
from the truth table of x.DNF[x, Minimal | 0] returns a simplified DNF of x \
obtained by the system function BooleanMinimize.The second argument is \
optional and its default value is Simplified | 0.\
\>", "Text",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7118977772104936`*^9, 3.7118977848905044`*^9}, {
   3.711898046800871*^9, 3.711898069500903*^9}, {3.711899029702247*^9, 
   3.7118990605822906`*^9}, {3.711899102502349*^9, 3.7118991070823555`*^9}, 
   3.7119038210689554`*^9, {3.712418635646699*^9, 3.7124186446967115`*^9}, {
   3.7124187104568033`*^9, 3.712418711846805*^9}, {3.7145713231506176`*^9, 
   3.7145713567106647`*^9}, {3.7154361558901796`*^9, 3.715436190960229*^9}, {
   3.7154362588403234`*^9, 3.7154362612303267`*^9}, {3.7154362950003743`*^9, 
   3.7154363128203993`*^9}, 3.7154364081105328`*^9},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"7de07d3c-45d3-4627-956f-7eb3cbd134c2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "DNF", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "DNF", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"DNF", ",", "Listable"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DNF", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{"Not", "@", 
       RowBox[{"LFormulaQ", "[", "x", "]"}]}]}], ",", 
     RowBox[{"t_", ":", "Minimal"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   "\"\<Failed, the argument is not a logical formula\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DNF", "[", 
    RowBox[{"x_", ",", 
     RowBox[{"t_", ":", "Minimal"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rules", ",", "table", ",", "type", ",", "variables", ",", "varsnumber",
        ",", 
       RowBox[{"xx", "=", "x"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ClearAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"AND", ",", "OR"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"FixedPoint", "[", 
         RowBox[{"ReleaseHold", ",", "xx"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FALSE", "\[Rule]", "False"}], ",", 
          RowBox[{"TRUE", "\[Rule]", "True"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"type", "=", 
       RowBox[{"t", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Complete", "\[Rule]", "1"}], ",", 
          RowBox[{"Minimal", "\[Rule]", "0"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"rules", "=", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{"Connectives", ",", 
             RowBox[{"{", 
              RowBox[{
              "Not", ",", "And", ",", "Equivalent", ",", "Implies", ",", 
               "Nand", ",", "Nor", ",", "Or", ",", "Xor"}], "}"}]}], "]"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{
           RowBox[{"xx", "//.", "rules"}], "//", 
           RowBox[{
            RowBox[{"BooleanConvert", "[", 
             RowBox[{"#", ",", "\"\<DNF\>\""}], "]"}], "&"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rules", "=", 
          RowBox[{"Reverse", "/@", "rules"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"xx", "/.", "rules"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"type", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"variables", "=", 
          RowBox[{"LVariableSet", "[", "xx", "]"}]}], ";", 
         RowBox[{"varsnumber", "=", 
          RowBox[{"Length", "[", "variables", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{"Tuples", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"False", ",", "True"}], "}"}], ",", "varsnumber"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"rules", "=", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"MapThread", "[", 
              RowBox[{"Rule", ",", 
               RowBox[{"{", 
                RowBox[{"variables", ",", "#"}], "}"}]}], "]"}], "&"}], ",", 
            "table"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{"MapThread", "[", 
           RowBox[{"Join", ",", 
            RowBox[{"{", 
             RowBox[{"table", ",", 
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", "xx", "}"}], "/.", "#"}], ")"}], "&"}], ",", 
                "rules"}], "]"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Drop", "[", 
              RowBox[{"#", ",", 
               RowBox[{"-", "1"}]}], "]"}], "&"}], ",", 
            RowBox[{"Cases", "[", 
             RowBox[{"table", ",", 
              RowBox[{"{", 
               RowBox[{"___", ",", "True"}], "}"}]}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"table", "=", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MapThread", "[", 
               RowBox[{"List", ",", 
                RowBox[{"{", 
                 RowBox[{"#", ",", "variables"}], "}"}]}], "]"}], "&"}], ",", 
             "table"}], "]"}], "//.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{"False", ",", "y_"}], "}"}], "\[Rule]", 
              RowBox[{"NOT", "[", "y", "]"}]}], ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"True", ",", "y_"}], "}"}], "\[Rule]", "y"}]}], 
            "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"Apply", "[", 
           RowBox[{"OR", ",", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Apply", "[", 
                RowBox[{"AND", ",", "#"}], "]"}], "&"}], ",", "table"}], 
             "]"}]}], "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"AND", ",", "OR"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SetAttributes", "[", 
         RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}], 
      ";", "\[IndentingNewLine]", "xx"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DNF", "]"}], ";"}]}], "Input",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "8c6e286c-b123-46e9-96f0-a29689e12674"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Conversion to Complete Sets of Connectives:  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Not]", 
     RowBox[{",", "\[And]"}]}], "}"}], TraditionalForm]],ExpressionUUID->
  "8c442836-a149-4db4-811c-5c46116f4037"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Not]", 
     RowBox[{",", "\[Or]"}]}], "}"}], TraditionalForm]],ExpressionUUID->
  "8105f8fa-c93f-4c98-b7e9-bb9f4a28a1f9"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Not]", 
     RowBox[{",", "\[Implies]"}]}], "}"}], TraditionalForm]],ExpressionUUID->
  "0d7a751c-43a3-4e56-9ff1-2d350ccbd093"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Not]", 
     RowBox[{",", 
      RowBox[{"\[And]", 
       RowBox[{",", "\[CirclePlus]"}]}]}]}], "}"}], TraditionalForm]],
  ExpressionUUID->"3c7507ad-0384-437c-9601-b8f929380748"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"{", "\[UpArrow]", "}"}]}], TraditionalForm]],ExpressionUUID->
  "8d8c3543-cf9c-4f8c-8f51-94fe439dd444"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", "\[DownArrow]", "}"}], TraditionalForm]],ExpressionUUID->
  "d1a7be56-3654-481c-8285-3884f9b59f13"]
}], "Subsubsection",
 CellMargins->{{18.375, 3.}, {8., 12.}},
 PageBreakWithin->True,
 FontSize->14,ExpressionUUID->"8d449e71-7b05-4bc5-8172-ef6771c6d93d"],

Cell[TextData[{
 "ConvertFormula[",
 StyleBox["x",
  FontSlant->"Italic"],
 ", form] uses system function BooleanConvert and finds a formula ",
 StyleBox["y",
  FontSlant->"Italic"],
 " tautologically equivalent to ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "and containing only connectives determined by the argument form: \n- if \
form is \[OpenCurlyDoubleQuote]AND\[CloseCurlyDoubleQuote], formula y \
contains only connectives AND and NOT;\n- if form is \
\[OpenCurlyDoubleQuote]OR\[CloseCurlyDoubleQuote], formula y contains only \
connectives OR and NOT;\n- if form is \[OpenCurlyDoubleQuote]IMPLIES\
\[CloseCurlyDoubleQuote], formula y contains only connectives IMPLIES and \
NOT;\n- if form is \[OpenCurlyDoubleQuote]NAND\[CloseCurlyDoubleQuote], \
formula y contains only connectives NAND and NOT;\n- if form is \
\[OpenCurlyDoubleQuote]NOR\[CloseCurlyDoubleQuote], formula y contains only \
connectives NOR and NOT;\n- if form is \[OpenCurlyDoubleQuote]XOR\
\[CloseCurlyDoubleQuote], formula y contains only connectives XOR, AND and \
NOT."
}], "Text",
 CellMargins->{{18.4375, 10.}, {7., 7.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7134524117000437`*^9, 3.7134524121000443`*^9}, 
   3.7134524514900994`*^9},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"a9574697-7f55-4dee-b1b2-b66d424cdd96"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "ConvertFormula", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "ConvertFormula", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"ConvertFormula", ",", "Listable"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConvertFormula", "[", 
      RowBox[{
       RowBox[{"x_", "/;", 
        RowBox[{"LFormulaQ", "[", "x", "]"}]}], ",", "form_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rules", ",", "xx"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ClearAttributes", "[", 
           RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"SetAttributes", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"AND", ",", "OR"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xx", "=", 
         RowBox[{
          RowBox[{"FixedPoint", "[", 
           RowBox[{"ReleaseHold", ",", "x"}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FALSE", "\[Rule]", "False"}], ",", 
            RowBox[{"TRUE", "\[Rule]", "True"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rules", "=", 
         RowBox[{"Thread", "[", 
          RowBox[{"Rule", "[", 
           RowBox[{"Connectives", ",", 
            RowBox[{"{", 
             RowBox[{
             "Not", ",", "And", ",", "Equivalent", ",", "Implies", ",", 
              "Nand", ",", "Nor", ",", "Or", ",", "Xor"}], "}"}]}], "]"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"xx", "=", 
         RowBox[{"xx", "/.", "rules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"form", "===", "\"\<AND\>\""}], ",", 
          RowBox[{"xx", "=", 
           RowBox[{"BooleanConvert", "[", 
            RowBox[{"xx", ",", "\"\<AND\>\""}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"form", "===", "\"\<OR\>\""}], ",", " ", 
          RowBox[{"xx", "=", 
           RowBox[{"BooleanConvert", "[", 
            RowBox[{"xx", ",", "\"\<OR\>\""}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"form", "===", "\"\<IMPLIES\>\""}], ",", " ", 
          RowBox[{"xx", "=", 
           RowBox[{"BooleanConvert", "[", 
            RowBox[{"xx", ",", "\"\<IMPLIES\>\""}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"form", "===", "\"\<NAND\>\""}], ",", " ", 
          RowBox[{"xx", "=", 
           RowBox[{"BooleanConvert", "[", 
            RowBox[{"xx", ",", "\"\<NAND\>\""}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"form", "===", "\"\<NOR\>\""}], ",", " ", 
          RowBox[{"xx", "=", 
           RowBox[{"BooleanConvert", "[", 
            RowBox[{"xx", ",", "\"\<NOR\>\""}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"form", "===", "\"\<XOR\>\""}], ",", " ", 
          RowBox[{"xx", "=", 
           RowBox[{"BooleanConvert", "[", 
            RowBox[{"xx", ",", "\"\<ESOP\>\""}], "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rules", "=", 
         RowBox[{"Reverse", "/@", "rules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"xx", "=", 
         RowBox[{"xx", "/.", "rules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ClearAttributes", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"AND", ",", "OR"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"SetAttributes", "[", 
           RowBox[{"#", ",", "HoldAll"}], "]"}], "&"}], "/@", "Connectives"}],
         ";", "\[IndentingNewLine]", "xx"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConvertFormula", "[", 
      RowBox[{
       RowBox[{"x_", "/;", 
        RowBox[{"Not", "[", "LFormulaQ", "]"}]}], ",", "form_"}], "]"}], 
     ":=", "\"\<Failed, the argument is not a logical formula\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "ConvertFormula", "]"}], ";"}]}]}]], "Input",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "b0ed833e-73bb-4281-bc1d-5f4ef811f8bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries on Clauses", "Subsubsection",
 CellMargins->{{18.375, 3.}, {8., 12.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7116343835751343`*^9, 3.7116343876851397`*^9}, {
   3.7116355251267323`*^9, 3.711635543326758*^9}, {3.713452538950222*^9, 
   3.713452546760233*^9}, {3.7134525963303022`*^9, 3.7134526106803226`*^9}, 
   3.7134526602103915`*^9, {3.713453444181489*^9, 3.713453453171502*^9}},
 FontSize->14,ExpressionUUID->"14eb05b5-7e6c-4ccd-9e6a-75a7281c2a07"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "LiteralQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "LiteralQ", "]"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LiteralQ", "[", "x_", "]"}], ":=", " ", 
    RowBox[{"True", " ", "/;", " ", 
     RowBox[{"LAtomQ", "[", "x", "]"}]}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LiteralQ", "[", 
     RowBox[{"NOT", "[", "x_", "]"}], "]"}], ":=", 
    RowBox[{"True", " ", "/;", " ", 
     RowBox[{"LAtomQ", "[", "x", "]"}]}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LiteralQ", "[", "x_", "]"}], "=", "False"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "LiteralQ", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "ClauseQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "ClauseQ", "]"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ClauseQ", "[", "]"}], "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ClauseQ", "[", 
    RowBox[{
     RowBox[{"OR", "[", "x___", "]"}], ",", 
     RowBox[{"False", "|", "FALSE", "|", "True", "|", "TRUE"}], ",", 
     RowBox[{"OR", "[", "y___", "]"}]}], "]"}], "=", 
   RowBox[{"ClauseQ", "[", 
    RowBox[{"OR", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ClauseQ", "[", 
     RowBox[{"OR", "[", 
      RowBox[{"x_", ",", "y__"}], "]"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"ClauseQ", "[", "x", "]"}], "&&", 
     RowBox[{"ClauseQ", "[", 
      RowBox[{"OR", "[", "y", "]"}], "]"}]}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ClauseQ", "[", "x_", "]"}], ":=", 
    RowBox[{"True", " ", "/;", " ", 
     RowBox[{"LiteralQ", "[", "x", "]"}]}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ClauseQ", "[", "x_", "]"}], ":=", "False"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "ClauseQ", "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "ToClauses", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "ToClauses", "]"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Attributes", "[", "ToClauses", "]"}], " ", "=", " ", 
    RowBox[{"{", "Listable", "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ToClauses", "[", 
     RowBox[{"x_", " ", "/;", 
      RowBox[{"LFormulaQ", "[", "x", "]"}]}], "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CNF", "[", 
       RowBox[{"{", "x", "}"}], "]"}], " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AND", "\[Rule]", "List"}], ",", 
        RowBox[{"True", " ", "\[Rule]", " ", "TRUE"}]}], "}"}]}], "//", 
     "Flatten"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "ToClauses", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "variableCase", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "variableCase", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableCase", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "&&", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}], ",", "1"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableCase", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}]}], "]"}], "&&", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", "y", ",", "1"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableCase", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{"1", "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}]}], "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableCase", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{"1", "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"x", "/.", 
        RowBox[{
         RowBox[{"NOT", "[", "y", "]"}], "\[Rule]", "False"}]}], ",", "y"}], 
      "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableCase", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{"2", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableCase", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{"2", "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "variableCase", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "variableRule", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "variableRule", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "True"}], "}"}], "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "&&", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}], ",", "1"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "False"}], "}"}], "/;", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}]}], "]"}], "&&", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", "y", ",", "1"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "True"}], "}"}], "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}]}], "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_List", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "False"}], "}"}], "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"x", "/.", 
        RowBox[{
         RowBox[{"NOT", "[", "y", "]"}], "\[Rule]", "False"}]}], ",", "y"}], 
      "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{"x", ",", 
       RowBox[{"NOT", "[", "y", "]"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_OR", ",", "\[Infinity]"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", "\[Rule]", "x"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_OR", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "True"}], "}"}], "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_OR", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "False"}], "}"}], "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{"x", ",", 
      RowBox[{"NOT", "[", "y", "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_OR", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "\"\<\[Bullet]\>\""}], "}"}], "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "&&", 
     RowBox[{"y", "=!=", "\[Infinity]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{
     RowBox[{"NOT", "[", "x_", "]"}], ",", "\[Infinity]"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", "\[Rule]", "x"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{
     RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "False"}], "}"}], "/;", 
    RowBox[{"x", "===", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{
     RowBox[{"NOT", "[", "x_", "]"}], ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "\"\<\[Bullet]\>\""}], "}"}], "/;", 
    RowBox[{"y", "=!=", "\[Infinity]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"Global`\[GraySquare]", ",", "y_"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", "y"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"\[Infinity]", ",", "y_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", "y"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"False", ",", "\[Infinity]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", "\[Rule]", "FALSE"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_Symbol", ",", "\[Infinity]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", "\[Rule]", "x"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_Symbol", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "True"}], "}"}], "/;", 
    RowBox[{"x", "===", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_Symbol", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "\"\<\[Bullet]\>\""}], "}"}], "/;", 
    RowBox[{"x", "=!=", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"variableRule", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "\"\<\[CenterEllipsis]\>\""}], "}"}], "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{"x", ",", "Global`\[Bullet]", ",", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "variableRule", "]"}], ";"}]}], "Input",
 CellMargins->{{18.8125, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "a05ca97c-a08a-410a-88e5-11e02df2eb53"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resolvents and Resolution Sequences", "Subsubsection",
 CellMargins->{{18.375, 10.}, {7., 7.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.71163515180621*^9, 3.711635153166212*^9}, {
  3.711635553916773*^9, 3.711635564636788*^9}},
 FontFamily->"Times New Roman",
 FontSize->14,ExpressionUUID->"c96c9d15-3458-4e69-bcb9-72e56f974554"],

Cell[CellGroupData[{

Cell["generateResolvents", "Text",
 CellMargins->{{17.9375, 10.}, {5., 10.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.7024908367986593`*^9, 3.702490850178678*^9}, {
   3.711634599785437*^9, 3.711634604685444*^9}, 3.7132652642018075`*^9, {
   3.7134527358304977`*^9, 3.7134527770305552`*^9}, 3.7144965065350246`*^9, {
   3.716272601982534*^9, 3.7162726057625394`*^9}, {3.716317570053686*^9, 
   3.7163176157737503`*^9}, {3.716407569611281*^9, 3.7164075723712845`*^9}, {
   3.7182017105884666`*^9, 3.7182017112184677`*^9}, {3.7185614922424335`*^9, 
   3.7185615023124475`*^9}, 3.7188948978581715`*^9},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"d4f91d58-4417-4bef-b9ab-af3b537587d1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "generateResolvents", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "generateResolvents", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"generateResolvents", "[", 
    RowBox[{
    "x1_", ",", "x2_", ",", "x3_", ",", "reduce_", ",", "sort_", ",", 
     "variables_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "v", ",", "variables1", ",", "x10", ",", "x11", ",", "x12", ",", "x20", 
       ",", "x21", ",", "x22", ",", 
       RowBox[{"xx", "=", 
        RowBox[{"{", "}"}]}], ",", "xx12", ",", "xx21", ",", "xx22"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x2", "=!=", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x10", ",", "x20"}], "}"}], "=", 
          RowBox[{"Map", "[", 
           RowBox[{"sort", ",", 
            RowBox[{"{", 
             RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"variables1", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"variables", ",", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"x20", ",", "#", ",", 
               RowBox[{"-", "1"}]}], "]"}], "&"}]}], "]"}]}], ";", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"variables1", "=!=", 
              RowBox[{"{", "}"}]}], ",", 
             RowBox[{"FreeQ", "[", 
              RowBox[{"x20", ",", "False"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"v", "=", 
             RowBox[{"First", "[", "variables1", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"x11", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x10", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "True"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x12", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x10", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "False"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x21", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x20", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "True"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x22", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x20", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "False"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"xx12", "=", 
             RowBox[{"Distribute", "[", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{
                 RowBox[{"x11", "/.", 
                  RowBox[{"v", "\[Rule]", "False"}]}], ",", 
                 RowBox[{"x22", "/.", 
                  RowBox[{
                   RowBox[{"NOT", "[", "v", "]"}], "\[Rule]", "False"}]}]}], 
                "]"}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"xx12", "=", 
             RowBox[{
              RowBox[{"DeleteCases", "[", 
               RowBox[{"xx12", ",", 
                RowBox[{"OR", "[", 
                 RowBox[{"u__", ",", 
                  RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], 
               "]"}], "//.", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xx21", "=", 
             RowBox[{"Distribute", "[", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{
                 RowBox[{"x21", "/.", 
                  RowBox[{"v", "\[Rule]", "False"}]}], ",", 
                 RowBox[{"x12", "/.", 
                  RowBox[{
                   RowBox[{"NOT", "[", "v", "]"}], "\[Rule]", "False"}]}]}], 
                "]"}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"xx21", "=", 
             RowBox[{
              RowBox[{"DeleteCases", "[", 
               RowBox[{"xx21", ",", 
                RowBox[{"OR", "[", 
                 RowBox[{"u__", ",", 
                  RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], 
               "]"}], "//.", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xx22", "=", 
             RowBox[{"Distribute", "[", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{
                 RowBox[{"x21", "/.", 
                  RowBox[{"v", "\[Rule]", "False"}]}], ",", 
                 RowBox[{"x22", "/.", 
                  RowBox[{
                   RowBox[{"NOT", "[", "v", "]"}], "\[Rule]", "False"}]}]}], 
                "]"}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"xx22", "=", 
             RowBox[{
              RowBox[{"DeleteCases", "[", 
               RowBox[{"xx22", ",", 
                RowBox[{"OR", "[", 
                 RowBox[{"u__", ",", 
                  RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], 
               "]"}], "//.", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xx", "=", 
             RowBox[{"Join", "[", 
              RowBox[{"xx", ",", "xx12", ",", "xx21", ",", "xx22"}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"variables1", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{"variables1", ",", "1"}], "]"}]}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"xx", "//", "sort"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"reduce", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{"xx", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"OR", "[", 
                  RowBox[{"u_", ",", "__"}], "]"}], "|", "u_"}], "/;", 
                RowBox[{"MemberQ", "[", 
                 RowBox[{"x3", ",", "u"}], "]"}]}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xx", "=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{"xx", ",", 
               RowBox[{
                RowBox[{"OR", "[", 
                 RowBox[{"u_", ",", "__"}], "]"}], "/;", 
                RowBox[{"MemberQ", "[", 
                 RowBox[{"xx", ",", "u"}], "]"}]}]}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"xx", "=", 
            RowBox[{"DeleteCases", "[", 
             RowBox[{"xx", ",", 
              RowBox[{"u_", "/;", 
               RowBox[{"MemberQ", "[", 
                RowBox[{"x3", ",", "u"}], "]"}]}]}], "]"}]}]}], "]"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", "xx"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "generateResolvents", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "5d9fb9cf-d632-4d4d-953f-1459185dd4d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Resolvents[x, options] generates from the list x of clauses the list xx of \
all resolvents with respect to the list of logical variables given by one of \
the optional arguments, from which, however, some resolvents are deleted:  \
with the option Reduce ->False,  there are excluded resolvents that are \
members of x,  and with the option Reduce ->True there are excluded  \
resolvents a part of which is a member of x or xx. 
Alternatives for options (default value = the first alternative) : 
- Reduce ->  True | False
- Sort ->  DeleteDuplicates | Union | False,
- Variables -> All | List of logical variables.\
\>", "Text",
 CellMargins->{{17.9375, 10.}, {5., 10.}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"de87c463-cc9e-45a5-b97a-956c1b8c979e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Resolvents", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "Resolvents", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "Resolvents", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Reduce", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Sort", "\[Rule]", "DeleteDuplicates"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Resolvents", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, the first argument is not a list\>\"", "/;", 
    RowBox[{
     RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Resolvents", "[", 
    RowBox[{"x_List", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"Resolvents", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "reduce", ",", "rules", ",", "sort", ",", "u", ",", "variables", ",", 
       "variables1", ",", "x1", ",", "x2", ",", "x3", ",", "xx"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"reduce", ",", "sort", ",", "variables"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Reduce", ",", "Sort", ",", "Variables"}], "}"}], "/.", 
          RowBox[{"{", "options", "}"}]}], "/.", 
         RowBox[{"Options", "[", "Resolvents", "]"}]}], "/.", 
        RowBox[{"All", "\[Rule]", 
         RowBox[{"LVariableSet", "[", "x", "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"x", ",", 
         RowBox[{"OR", "[", 
          RowBox[{"u__", ",", 
           RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, all members of the first argument are tautologies\>\"",
           "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"variables", "===", "All"}], ",", 
         RowBox[{"LVariableSet", "[", "xx", "]"}], ",", 
         RowBox[{"Select", "[", 
          RowBox[{"variables", ",", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"FreeQ", "[", 
              RowBox[{"xx", ",", "#"}], "]"}]}], "&"}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, the first argument does not depend on given \
variables\>\"", "]"}]}]}], "]"}], ";", 
      RowBox[{"variables1", "=", 
       RowBox[{"RemoveSubscript", "[", "variables", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables1", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"ToExpression", "@", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", "#", "]"}], ",", 
            RowBox[{"\"\<Private`$\>\"", "\[Rule]", "\"\<$\>\""}]}], "]"}]}], 
         "&"}], "/@", "variables1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rules", "=", 
       RowBox[{"Thread", "[", 
        RowBox[{"Rule", "[", 
         RowBox[{"variables", ",", "variables1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"xx", "/.", "rules"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"DeleteCases", "[", 
         RowBox[{"xx", ",", 
          RowBox[{"OR", "[", 
           RowBox[{"u__", ",", 
            RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], "]"}], "//.", 
        RowBox[{
         RowBox[{"OR", "[", 
          RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", "xx", ",", "xx"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"generateResolvents", "[", 
        RowBox[{
        "x1", ",", "x2", ",", "x3", ",", "reduce", ",", "sort", ",", 
         "variables1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"xx", "/.", 
        RowBox[{"Reverse", "/@", "rules"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "/.", 
       RowBox[{"False", "\[Rule]", "FALSE"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Resolvents", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "2b95152c-f7f4-4807-a6de-d6f28b380ced"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FullResolutionSequence[x, options], where x is a list of clauses and one of \
the optional arguments is Rules -> False, returns a list {x, Complement[R[x], \
x], Complement[R[R[x]], R[x],x], . . .} where R[xx] = Resolvents[xx, opts]. \
The last member is either empty or contains FALSE. In the case Rules -> True \
the output contains also certain rules that are applied repeatedly before \
each application of Resolvents[#, opts] & in order to reduce the number of \
clauses and to find truth values for logical variables in case the list x is \
satisfiable. In general case, however, the rules found may not be sufficient \
to transform all the formulae from x to True.
Alternatives for options (default value = the first alternative) : 
- BooleanValues -> { 0,  1} | {False,True} | -> {FalseSymbol,  TrueSymbol},
- Print -> False | True,
- Reduce -> True | False,
- Rules -> True | False,
- Sort -> DeleteDuplicates | Union | False,
- Variables -> All | List of logical variables.\
\>", "Text",
 CellMargins->{{18.4375, 10.}, {7., 7.}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"9333a140-8426-4e71-bb58-4518500173ed"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "FullResolutionSequence", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "FullResolutionSequence", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "FullResolutionSequence", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "FullResolutionSequence", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BooleanValues", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"Print", "\[Rule]", "False"}], ",", 
      RowBox[{"Reduce", "\[Rule]", "True"}], ",", 
      RowBox[{"Rules", "\[Rule]", "True"}], ",", 
      RowBox[{"Sort", "\[Rule]", "DeleteDuplicates"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FullResolutionSequence", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, the first argument is not a list\>\"", "/;", 
    RowBox[{
     RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FullResolutionSequence", "[", 
    RowBox[{"x_List", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FullResolutionSequence", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "booleanValues", ",", "case", ",", "print", ",", "reduce", ",", "rules",
        ",", "rules1", ",", "rules2", ",", 
       RowBox[{"sequence", "=", 
        RowBox[{"{", "}"}]}], ",", "sort", ",", "variables", ",", 
       "variables1", ",", "x1", ",", "x2", ",", "x3", ",", "xx"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "booleanValues", ",", "print", ",", "reduce", ",", "rules", ",", 
         "sort", ",", "variables"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "BooleanValues", ",", "Print", ",", "Reduce", ",", "Rules", ",", 
           "Sort", ",", "Variables"}], "}"}], "/.", 
         RowBox[{"{", "options", "}"}]}], "/.", 
        RowBox[{"Options", "[", "FullResolutionSequence", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"sort", "===", "False"}], ",", 
        RowBox[{"sort", "=", "Identity"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"DeleteCases", "[", 
         RowBox[{"x", ",", 
          RowBox[{"OR", "[", 
           RowBox[{"u__", ",", 
            RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], "]"}], "//.", 
        RowBox[{
         RowBox[{"OR", "[", 
          RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"xx", ",", 
         RowBox[{
          RowBox[{"OR", "[", 
           RowBox[{"u_", ",", "__"}], "]"}], "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"xx", ",", "u"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, all members of the first argument are tautologies\>\"",
           "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"variables", "===", "All"}], ",", 
         RowBox[{"LVariableSet", "[", "xx", "]"}], ",", 
         RowBox[{"Select", "[", 
          RowBox[{"variables", ",", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{"xx", ",", "#", ",", 
              RowBox[{"-", "1"}]}], "]"}], "&"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, the first argument does not depend on given \
variables\>\"", "]"}]}]}], "]"}], ";", 
      RowBox[{"variables1", "=", 
       RowBox[{"RemoveSubscript", "[", "variables", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rules1", "=", 
       RowBox[{"Thread", "[", 
        RowBox[{"Rule", "[", 
         RowBox[{"variables", ",", "variables1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", "variables1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"xx", "/.", "rules1"}], "//", "sort"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", "xx", ",", "xx"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x2", "=!=", 
          RowBox[{"{", "}"}]}], "&&", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"x2", ",", "FALSE"}], "]"}]}], " ", ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"sequence", ",", "x2"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"rules", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"variables1", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"variables", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"variableCase", "[", 
                  RowBox[{"x2", ",", "#"}], "]"}], "\[LessEqual]", "1"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"While", "[", 
             RowBox[{
              RowBox[{"variables1", "=!=", 
               RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"rules2", "=", 
                RowBox[{"Apply", "[", 
                 RowBox[{"Union", ",", 
                  RowBox[{"Map", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"variableRule", "[", 
                    RowBox[{"x2", ",", "#"}], "]"}], "&"}], ",", 
                    "variables1"}], "]"}]}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"AppendTo", "[", 
                RowBox[{"sequence", ",", "rules2"}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"x2", "=", 
                RowBox[{
                 RowBox[{
                  RowBox[{"DeleteCases", "[", 
                   RowBox[{
                    RowBox[{"x2", "//.", "rules2"}], ",", "True"}], "]"}], "/.", 
                  RowBox[{"False", "\[Rule]", "FALSE"}]}], "//", "sort"}]}], 
               ";", "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"x2", "=!=", 
                   RowBox[{"{", "}"}]}], "&&", 
                  RowBox[{"FreeQ", "[", 
                   RowBox[{"x2", ",", "FALSE"}], "]"}]}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"sequence", ",", "x2"}], "]"}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"variables", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"variables", ",", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"x2", ",", "#", ",", "3"}], "]"}], "&"}]}], 
                    "]"}]}], ";", "\[IndentingNewLine]", 
                  RowBox[{"variables1", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"variables", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"variableCase", "[", 
                    RowBox[{"x2", ",", "#"}], "]"}], "\[LessEqual]", "1"}], 
                    "&"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"variables1", "=", 
                  RowBox[{"{", "}"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "=!=", 
             RowBox[{"{", "}"}]}], "&&", 
            RowBox[{"FreeQ", "[", 
             RowBox[{"x2", ",", "FALSE"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xx", "=", 
             RowBox[{"generateResolvents", "[", 
              RowBox[{
              "x1", ",", "x2", ",", "x3", ",", "reduce", ",", "sort", ",", 
               "variables"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"xx", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"DeleteCases", "[", 
                RowBox[{
                 RowBox[{"xx", "/.", 
                  RowBox[{"False", "\[Rule]", "FALSE"}]}], ",", 
                 RowBox[{"OR", "[", 
                  RowBox[{"u_", ",", 
                   RowBox[{"NOT", "[", "u_", "]"}], ",", "___"}], "]"}]}], 
                "]"}], "//.", 
               RowBox[{
                RowBox[{"OR", "[", 
                 RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}], "//", 
              "sort"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"Join", "[", 
                 RowBox[{"x1", ",", "x3"}], "]"}], "//", "sort"}], ",", "xx", 
               ",", 
               RowBox[{
                RowBox[{"Join", "[", 
                 RowBox[{"x3", ",", "xx"}], "]"}], "//", "sort"}]}], "}"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"variables", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"variables", ",", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"x2", ",", "#", ",", 
                  RowBox[{"-", "1"}]}], "]"}], "&"}]}], "]"}]}]}]}], 
          "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x2", "===", 
          RowBox[{"{", "}"}]}], "||", 
         RowBox[{"MemberQ", "[", 
          RowBox[{"x2", ",", "FALSE"}], "]"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"sequence", ",", "x2"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sequence", "=", 
       RowBox[{"sequence", "/.", 
        RowBox[{"Reverse", "/@", "rules1"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sequence", "=", 
       RowBox[{"sequence", "/.", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", "booleanValues"}], 
          "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"print", "===", "False"}], ",", 
        RowBox[{"Column", "[", 
         RowBox[{"sequence", ",", 
          RowBox[{"Dividers", "\[Rule]", "All"}], ",", 
          RowBox[{"Spacings", "\[Rule]", "1"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"Print", "/@", 
          RowBox[{"Framed", "/@", "sequence"}]}], ";"}]}], "]"}]}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "FullResolutionSequence", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 TextJustification->1.,
 ExpressionUUID -> "43ead3da-76d1-490b-acf4-4dfffd6a2555"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "ResolutionDepth[x, options] characterizes the complexity of the list x of \
clauses by the triple depth={\[PlusMinus]n,r,t}, where n is the length of the \
list FullResolutionSequence[x,options], r is the total number of clauses in \
it, and t is the CPU time spent in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.  The sign is \[OpenCurlyDoubleQuote]+\[OpenCurlyDoubleQuote] if  \
the list x is satisfiable,  and \[OpenCurlyDoubleQuote]-\
\[OpenCurlyDoubleQuote] in the oppsite case.\nAlternatives for options \
(default value = the first alternative) : \n- Reduce -> True | False,\n- \
Rules -> True | False,\n- Sort -> DeleteDuplicates ",
 "| Union | False",
 ",\n- Trace -> True | False,\n- Variables -> All | List of logical variables."
}], "Text",
 CellMargins->{{18.6875, 10.}, {7., 7.}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"0012401d-ec45-442c-a845-cf628df839e1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ResolutionDepth", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "ResolutionDepth", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "ResolutionDepth", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ResolutionDepth", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Reduce", "\[Rule]", "True"}], ",", 
      RowBox[{"Rules", "\[Rule]", "True"}], ",", 
      RowBox[{"Sort", "\[Rule]", "False"}], ",", 
      RowBox[{"Trace", "\[Rule]", "True"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ResolutionDepth", "[", 
     RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
    RowBox[{"\"\<Failed, the first argument is not a list\>\"", "/;", 
     RowBox[{
      RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionDepth", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionDepth", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"case", ",", "depth", ",", 
       RowBox[{"n", "=", "0"}], ",", "reduce", ",", "rules", ",", "rules1", 
       ",", "sort", ",", "timing", ",", "totalDepth", ",", "trace", ",", 
       "variables", ",", "variables1", ",", "x1", ",", "x2", ",", "x3", ",", 
       "xx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "reduce", ",", "rules", ",", "sort", ",", "trace", ",", "variables"}],
         "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Reduce", ",", "Rules", ",", "Sort", ",", "Trace", ",", 
           "Variables"}], "}"}], "/.", 
         RowBox[{"{", "options", "}"}]}], "/.", 
        RowBox[{"Options", "[", "ResolutionDepth", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"sort", "===", "False"}], ",", 
        RowBox[{"sort", "=", "Identity"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"x", ",", 
         RowBox[{"OR", "[", 
          RowBox[{"u__", ",", 
           RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"xx", ",", 
         RowBox[{
          RowBox[{"OR", "[", 
           RowBox[{"u_", ",", "__"}], "]"}], "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"xx", ",", "u"}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, all members of the first argument are tautologies\>\"",
           "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"variables", "===", "All"}], ",", 
         RowBox[{"LVariableSet", "[", "xx", "]"}], ",", 
         RowBox[{"Select", "[", 
          RowBox[{"variables", ",", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"FreeQ", "[", 
              RowBox[{"xx", ",", "#"}], "]"}]}], "&"}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, the first argument does not depend on given \
variables\>\"", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variables1", "=", 
       RowBox[{"RemoveSubscript", "[", "variables", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rules1", "=", 
       RowBox[{"Thread", "[", 
        RowBox[{"Rule", "[", 
         RowBox[{"variables", ",", "variables1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", "variables1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"xx", "/.", "rules1"}], "//", "sort"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", "xx", ",", "xx"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"depth", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"Length", "[", "x2", "]"}], ",", "0"}], "}"}], "}"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x2", "\[NotEqual]", 
          RowBox[{"{", "}"}]}], "&&", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"x2", ",", "False"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"rules", ",", "\[IndentingNewLine]", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"timing", "=", "\[IndentingNewLine]", 
               RowBox[{"Timing", "[", 
                RowBox[{
                 RowBox[{"variables1", "=", 
                  RowBox[{"Select", "[", 
                   RowBox[{"variables", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"variableCase", "[", 
                    RowBox[{"x2", ",", "#"}], "]"}], "\[LessEqual]", "1"}], 
                    "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"variables1", "=!=", 
                    RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"rules1", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Union", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"variableRule", "[", 
                    RowBox[{"x2", ",", "#"}], "]"}], "&"}], ",", 
                    "variables1"}], "]"}]}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"x2", "=", 
                    RowBox[{
                    RowBox[{"DeleteCases", "[", 
                    RowBox[{
                    RowBox[{"x2", "//.", "rules1"}], ",", "True"}], "]"}], "//",
                     "sort"}]}], ";", "\[IndentingNewLine]", 
                    RowBox[{"variables", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"x2", "=!=", 
                    RowBox[{"{", "}"}]}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"x2", ",", "False"}], "]"}]}], ",", 
                    RowBox[{"Select", "[", 
                    RowBox[{"variables", ",", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"x2", ",", "#", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "&"}]}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}]}]}]}], "]"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"variables1", "=!=", 
               RowBox[{"{", "}"}]}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"x2", "=!=", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"depth", "=", 
                RowBox[{"Append", "[", 
                 RowBox[{"depth", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"x2", ",", "False"}], "]"}], ",", "1", ",", 
                    RowBox[{"-", "1"}]}], "]"}], 
                    RowBox[{"(", 
                    RowBox[{"n", "=", 
                    RowBox[{"n", "+", "1"}]}], ")"}]}], ",", 
                    RowBox[{"Length", "[", "x2", "]"}], ",", 
                    RowBox[{"timing", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
              "]"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "=!=", 
             RowBox[{"{", "}"}]}], "&&", 
            RowBox[{"FreeQ", "[", 
             RowBox[{"x2", ",", "False"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"timing", "=", 
             RowBox[{"Timing", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"x2", "=", 
                RowBox[{"generateResolvents", "[", 
                 RowBox[{
                 "x1", ",", "x2", ",", "x3", ",", "reduce", ",", "sort", ",", 
                  "variables"}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"x2", "=", 
                RowBox[{
                 RowBox[{
                  RowBox[{"DeleteCases", "[", 
                   RowBox[{"x2", ",", 
                    RowBox[{"OR", "[", 
                    RowBox[{"u__", ",", 
                    RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], 
                   "]"}], "/.", 
                  RowBox[{
                   RowBox[{"OR", "[", 
                    RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}], "//",
                  "sort"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Join", "[", 
                   RowBox[{"x1", ",", "x3"}], "]"}], ",", "x2", ",", 
                  RowBox[{"Join", "[", 
                   RowBox[{"x3", ",", "x2"}], "]"}]}], "}"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"variables", "=", 
                RowBox[{"Select", "[", 
                 RowBox[{"variables", ",", 
                  RowBox[{
                   RowBox[{"MemberQ", "[", 
                    RowBox[{"x2", ",", "#", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "&"}]}], "]"}]}]}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"x2", "=!=", 
               RowBox[{"{", "}"}]}], ",", 
              RowBox[{"depth", "=", 
               RowBox[{"Append", "[", 
                RowBox[{"depth", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"x2", ",", "False"}], "]"}], ",", "1", ",", 
                    RowBox[{"-", "1"}]}], "]"}], 
                    RowBox[{"(", 
                    RowBox[{"n", "=", 
                    RowBox[{"n", "+", "1"}]}], ")"}]}], ",", 
                   RowBox[{"Length", "[", "x2", "]"}], ",", 
                   RowBox[{"timing", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
             "]"}]}]}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x2", "===", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"depth", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"depth", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"n", "=", 
              RowBox[{"n", "+", "1"}]}], ",", "0", ",", 
             RowBox[{"timing", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"trace", ",", "depth", ",", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Rest", "/@", "depth"}], "//", "Total"}], ",", 
          RowBox[{"depth", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], "]"}]}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ResolutionDepth", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "084daf45-e58a-4733-8920-049e95e4a93a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ResolutionSequence[x_List, options] tests whether the list x of clauses is \
satisfiable or not and in the positive case with the option Rules ->True \
finds, in some cases, values of logical variables for which all clauses in x \
are true. The algorithm used can be roughly described as a successive \
elimination of logical variables.
Alternatives for options (default value = the first alternative) : 
- BooleanValues -> {False -> 0, True -> 1} | {False -> FalseSymbol, True -> \
TrueSymbol},
- ItemSize -> Automatic,
- Print -> False | True,
- Reduce -> True | False,
- Rules -> True | False,
- SelectionRule-> First | Last | Random,
- Sort -> DeleteDuplicates | Union | False,
- Spacings -> Automatic | Number,
- TableBreaks -> None  | integer > 1 | increasing list of integers > 1,      
- Variables ->  All | List of logical variables.\
\>", "Text",
 CellMargins->{{17.375, 10.}, {7., 7.}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"1fb4775d-3dbd-4651-981e-7a3738a58326"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ResolutionSequence", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "ResolutionSequence", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "ResolutionSequence", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ResolutionSequence", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BooleanValues", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"ItemSize", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"Print", "\[Rule]", "False"}], ",", 
      RowBox[{"Reduce", "\[Rule]", "True"}], ",", 
      RowBox[{"Rules", "\[Rule]", "True"}], ",", 
      RowBox[{"SelectionRule", "\[Rule]", "First"}], ",", 
      RowBox[{"Sort", "\[Rule]", "DeleteDuplicates"}], ",", 
      RowBox[{"Spacings", "\[Rule]", "1"}], ",", 
      RowBox[{"SequenceBreaks", "\[Rule]", "None"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionSequence", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, the first argument is not a list\>\"", "/;", 
    RowBox[{
     RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionSequence", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionSequence", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "booleanValues", ",", "case", ",", "itemSize", ",", "print", ",", 
       "reduce", ",", "row", ",", "rule", ",", "rules", ",", "rules1", ",", 
       RowBox[{"rules2", "=", 
        RowBox[{"{", "}"}]}], ",", "selectionRule", ",", 
       RowBox[{"sequence", "=", 
        RowBox[{"{", "}"}]}], ",", "sequenceBreaks", ",", "sequenceLength", 
       ",", "sequenceParts", ",", "sort", ",", "spacings", ",", "v", ",", 
       "variables", ",", "variables0", ",", "variables1", ",", "x0", ",", 
       "x1", ",", "x2", ",", "x3", ",", "x12", ",", "xx"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "booleanValues", ",", "itemSize", ",", "print", ",", "reduce", ",", 
         "rules", ",", "selectionRule", ",", "sequenceBreaks", ",", "sort", 
         ",", "spacings", ",", "variables"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "BooleanValues", ",", "ItemSize", ",", "Print", ",", "Reduce", ",",
             "Rules", ",", "SelectionRule", ",", "SequenceBreaks", ",", 
            "Sort", ",", "Spacings", ",", "Variables"}], "}"}], "/.", 
          RowBox[{"{", "options", "}"}]}], "/.", 
         RowBox[{"Options", "[", "ResolutionSequence", "]"}]}], "/.", 
        RowBox[{"Random", "\[Rule]", "RandomChoice"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"sort", "===", "False"}], ",", 
        RowBox[{"sort", "=", "Identity"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"x", ",", 
         RowBox[{"OR", "[", 
          RowBox[{"u__", ",", 
           RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"xx", ",", 
         RowBox[{
          RowBox[{"OR", "[", 
           RowBox[{"u_", ",", "__"}], "]"}], "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"xx", ",", "u"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, all members of the first argument are tautologies\>\"",
           "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"variables", "===", "All"}], ",", 
         RowBox[{"LVariableSet", "[", "xx", "]"}], ",", 
         RowBox[{"Select", "[", 
          RowBox[{"variables", ",", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{"xx", ",", "#", ",", "\[Infinity]"}], "]"}], "&"}]}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, the first argument does not depend on given \
variables\>\"", "]"}]}]}], "]"}], ";", 
      RowBox[{"variables1", "=", 
       RowBox[{"RemoveSubscript", "[", "variables", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rules1", "=", 
       RowBox[{"Thread", "[", 
        RowBox[{"Rule", "[", 
         RowBox[{"variables", ",", "variables1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"xx", "/.", "rules1"}], "//", "sort"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"variables0", ",", "x0"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{"variables1", ",", "xx"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Label", "[", "\"\<x0\>\"", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x0", "=!=", 
          RowBox[{"{", "}"}]}], "&&", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"x0", ",", "FALSE"}], "]"}], "&&", 
         RowBox[{"variables0", "=!=", 
          RowBox[{"{", "}"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"v", "=", 
          RowBox[{"selectionRule", "[", "variables0", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"sequence", ",", "variables"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Append", "[", 
             RowBox[{"sequence", ",", "x0"}], "]"}], ",", 
            RowBox[{"Append", "[", 
             RowBox[{"variables", ",", "v"}], "]"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "sequence", "]"}], "\[GreaterEqual]", 
             "3"}], "&&", 
            RowBox[{
             RowBox[{"sequence", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}], "===", 
             RowBox[{"sequence", "[", 
              RowBox[{"[", 
               RowBox[{"-", "3"}], "]"}], "]"}]}]}], ",", 
           RowBox[{"sequence", "=", 
            RowBox[{"Drop", "[", 
             RowBox[{"sequence", ",", 
              RowBox[{"-", "2"}]}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"case", "=", 
          RowBox[{"variableCase", "[", 
           RowBox[{"x0", ",", "v"}], "]"}]}], ";", "\[IndentingNewLine]", " ", 
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"case", "\[LessEqual]", "1"}], "&&", "rules"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"rule", "=", 
             RowBox[{"variableRule", "[", 
              RowBox[{"x0", ",", "v"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"sequence", ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"Global`\[Bullet]", ",", 
                 RowBox[{"rule", "//", "First"}], ",", "Global`\[Bullet]"}], 
                "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{
              RowBox[{"DeleteCases", "[", 
               RowBox[{
                RowBox[{"x0", "//.", "rule"}], ",", "True"}], "]"}], "//", 
              "sort"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"variables0", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"variables0", ",", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"x0", ",", "#", ",", "\[Infinity]"}], "]"}], "&"}]}],
               "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"rules2", "=", 
             RowBox[{"Join", "[", 
              RowBox[{"rules2", ",", "rule"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"x1", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x0", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "True"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x2", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x0", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "False"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x3", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x0", ",", 
               RowBox[{
                RowBox[{"FreeQ", "[", 
                 RowBox[{"#", ",", "v"}], "]"}], "&"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"x12", "=", 
             RowBox[{"Distribute", "[", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{
                 RowBox[{"x1", "/.", 
                  RowBox[{"v", "\[Rule]", "False"}]}], ",", 
                 RowBox[{"x2", "/.", 
                  RowBox[{
                   RowBox[{"NOT", "[", "v", "]"}], "\[Rule]", "False"}]}]}], 
                "]"}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x12", "=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{
               RowBox[{"x12", "/.", 
                RowBox[{"False", "\[Rule]", "FALSE"}]}], ",", 
               RowBox[{"OR", "[", 
                RowBox[{"u__", ",", 
                 RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x12", "=", 
             RowBox[{
              RowBox[{"x12", "//.", 
               RowBox[{
                RowBox[{"OR", "[", 
                 RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}], "//", 
              "sort"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"reduce", ",", "\[IndentingNewLine]", 
              RowBox[{"x12", "=", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{"x12", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"OR", "[", 
                    RowBox[{"u_", ",", "__"}], "]"}], "|", "u_"}], "/;", 
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"x3", ",", "u"}], "]"}]}]}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"x12", "=", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{"x12", ",", 
                 RowBox[{"u_", "/;", 
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"x3", ",", "u"}], "]"}]}]}], "]"}]}]}], "]"}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"sequence", ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\< \>\"", ",", "Global`\[Bullet]", ",", "v", ",", 
                 "Global`\[Bullet]"}], "}"}], "]"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"row", "=", 
             RowBox[{"Which", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"x1", "=!=", 
                 RowBox[{"{", "}"}]}], "&&", 
                RowBox[{"x2", "=!=", 
                 RowBox[{"{", "}"}]}], "&&", 
                RowBox[{"x3", "=!=", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x1", ",", "x2"}], "}"}], "\[Rule]", "x12"}], ",",
                    "x3"}], "}"}], ",", "\"\<, \>\""}], "}"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"x1", "=!=", 
                 RowBox[{"{", "}"}]}], "&&", 
                RowBox[{"x2", "=!=", 
                 RowBox[{"{", "}"}]}], "&&", 
                RowBox[{"x3", "===", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x1", ",", "x2"}], "}"}], "\[Rule]", "x12"}], 
                 "}"}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x1", "===", 
                   RowBox[{"{", "}"}]}], "||", 
                  RowBox[{"x2", "===", 
                   RowBox[{"{", "}"}]}]}], ")"}], "&&", 
                RowBox[{"x3", "=!=", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x1", "~", "Join", "~", "x2"}], "}"}], ",", 
                   "x3"}], "}"}], ",", "\"\<, \>\""}], "}"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x1", "===", 
                   RowBox[{"{", "}"}]}], "||", 
                  RowBox[{"x2", "===", 
                   RowBox[{"{", "}"}]}]}], ")"}], "&&", 
                RowBox[{"x3", "===", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"x1", "~", "Join", "~", "x2"}], "}"}], "}"}], "}"}],
                ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"x1", "===", 
                 RowBox[{"{", "}"}]}], "&&", 
                RowBox[{"x2", "===", 
                 RowBox[{"{", "}"}]}], "&&", 
                RowBox[{"x3", "=!=", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{"{", "x3", "}"}], "}"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"x1", "=!=", 
                  RowBox[{"{", "}"}]}], "&&", 
                 RowBox[{"x2", "=!=", 
                  RowBox[{"{", "}"}]}]}], ")"}], "||", 
               RowBox[{"x3", "=!=", 
                RowBox[{"{", "}"}]}]}], ",", 
              RowBox[{
               RowBox[{"AppendTo", "[", 
                RowBox[{"sequence", ",", 
                 RowBox[{"Row", "@@", "row"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"x0", "=", 
                RowBox[{
                 RowBox[{"Join", "[", 
                  RowBox[{"x12", ",", "x3"}], "]"}], "//", "sort"}]}]}]}], 
             "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"variables0", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"variables0", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{"x0", ",", "#", ",", "\[Infinity]"}], "]"}], "&&", 
                 RowBox[{"(", 
                  RowBox[{"#", "=!=", "v"}], ")"}]}], "&"}]}], "]"}]}]}]}], 
          "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"sequence", ",", "x0"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "sequence", "]"}], "\[GreaterEqual]", "3"}], 
         "&&", 
         RowBox[{
          RowBox[{"sequence", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}], "===", 
          RowBox[{"sequence", "[", 
           RowBox[{"[", 
            RowBox[{"-", "3"}], "]"}], "]"}]}]}], ",", 
        RowBox[{"sequence", "=", 
         RowBox[{"Drop", "[", 
          RowBox[{"sequence", ",", 
           RowBox[{"-", "2"}]}], "]"}]}]}], "]"}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"x0", ",", "FALSE"}], "]"}], "&&", 
         RowBox[{"rules2", "=!=", 
          RowBox[{"{", "}"}]}]}], ",", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"sequence", ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Global`\[Bullet]", ",", "Global`\[Bullet]", ",", 
              RowBox[{"rules2", "//", "sort"}], ",", "Global`\[Bullet]", ",", 
              "Global`\[Bullet]"}], "}"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"x0", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"xx", "//.", "rules2"}], "//", 
            RowBox[{
             RowBox[{"DeleteCases", "[", 
              RowBox[{"#", ",", "True"}], "]"}], "&"}]}], "//", "sort"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", "}"}], "=!=", "x0", "=!=", "xx"}], ",", 
           RowBox[{
            RowBox[{"xx", "=", "x0"}], ";", 
            RowBox[{"variables0", "=", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"variables1", ",", 
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{"x0", ",", "#", ",", "\[Infinity]"}], "]"}], 
                 "&"}]}], "]"}], "//", "Reverse"}]}], ";", 
            RowBox[{"Goto", "[", "\"\<x0\>\"", "]"}]}]}], "]"}]}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"sequence", "=", 
       RowBox[{
        RowBox[{"sequence", "/.", 
         RowBox[{"Reverse", "/@", "rules1"}]}], "//.", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", "booleanValues"}], 
          "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Formating", " ", "output"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"sequenceLength", "=", 
       RowBox[{"Length", "@", "sequence"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"sequenceBreaks", "~", "MatchQ", "~", "_Integer"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"sequenceBreaks", "=", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"sequenceBreaks", "+", "1"}], ",", 
           RowBox[{"sequenceLength", "-", "1"}], ",", " ", "sequenceBreaks"}],
           "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"sequenceBreaks", "~", "MatchQ", "~", 
         RowBox[{"{", "__Integer", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"sequenceBreaks", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"sequenceBreaks", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"#", "<", "sequenceLength"}], "&"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", "True", ",", 
        RowBox[{"sequenceBreaks", "=", 
         RowBox[{"{", "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"sequenceBreaks", "=", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "sequenceBreaks", ",", 
         RowBox[{"{", 
          RowBox[{"sequenceLength", "+", "1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sequenceParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sequenceBreaks", "[", 
            RowBox[{"[", "#", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"sequenceBreaks", "[", 
             RowBox[{"[", 
              RowBox[{"#", "+", "1"}], "]"}], "]"}], "-", "1"}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Length", "[", "sequenceBreaks", "]"}], "-", "1"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sequenceParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"sequence", ",", "#"}], "]"}], "&"}], "/@", 
        "sequenceParts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sequence", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Column", "[", 
          RowBox[{"#", ",", 
           RowBox[{"Dividers", "\[Rule]", "All"}], ",", 
           RowBox[{"ItemSize", "\[Rule]", "itemSize"}], ",", 
           RowBox[{"Spacings", "\[Rule]", "1"}]}], "]"}], "&"}], "/@", 
        "sequenceParts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"print", "===", "False"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "sequence"}], "\[Equal]", "1"}], ",", 
          RowBox[{"First", "@", "sequence"}], ",", "sequence"}], "]"}], ",", 
        RowBox[{
         RowBox[{"StylePrint", "/@", "sequence"}], ";"}]}], "]"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ResolutionSequence", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "d55c1d60-cea1-4144-971e-514ea59be916"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResolutionTable", "Subsubsection",
 CellMargins->{{18.375, 10.}, {7., 7.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.71163515180621*^9, 3.711635153166212*^9}, {
  3.711635553916773*^9, 3.711635564636788*^9}, {3.7126018152176027`*^9, 
  3.7126018278776207`*^9}},
 FontFamily->"Times New Roman",
 FontSize->14,ExpressionUUID->"7992ae6c-ae2b-411d-81b5-2df7d2fb1b1a"],

Cell["\<\
ResolutionTable[x_List, options] tests whether the list x of clauses is \
satisfiable or not. It uses almost the same algorithm as ResolutionSequence \
but the result is presented in the form of a table.
Alternatives for options (default value = the first alternative) : 
- BooleanValues -> {0, 1} | {False -> FalseSymbol, True -> TrueSymbol} | None,
- Dividers -> All | as for Grid,
- ItemSize -> Automatic | {{Automatic, {1.5}}, 1} | as for Grid,
- Print -> False | True,
- Reduce -> False | True,
- Rules -> False | True,
- SelectionRule -> First | Last | Random,
- Sort -> DeleteDuplicates | Union | False,
- TestResult -> False | True,
- TableBreaks -> None |integer > 1| increasing list of integers > 1,
- Transpose -> False | True,
- Variables -> All | List of logical variables.\
\>", "Text",
 CellMargins->{{18, 10}, {7, 7}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"83c92d1b-7325-4ef0-a639-abd21f1b3270"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ResolutionTable", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "ResolutionTable", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ResolutionTable", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BooleanValues", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"Dividers", "\[Rule]", "All"}], ",", 
      RowBox[{"ItemSize", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"Print", "\[Rule]", "False"}], ",", 
      RowBox[{"Reduce", "\[Rule]", "False"}], ",", 
      RowBox[{"Rules", "\[Rule]", "False"}], ",", 
      RowBox[{"SelectionRule", "\[Rule]", "First"}], ",", 
      RowBox[{"Sort", "\[Rule]", "DeleteDuplicates"}], ",", 
      RowBox[{"TableBreaks", "\[Rule]", "None"}], ",", 
      RowBox[{"TestResult", "\[Rule]", "False"}], ",", 
      RowBox[{"Transpose", "\[Rule]", "False"}], ",", 
      RowBox[{"Variables", "\[Rule]", "All"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionTable", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, the first argument is not a list of clauses\>\"", "/;", 
    RowBox[{
     RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionTable", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ResolutionTable", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "booleanValues", ",", "case", ",", "dividers", ",", "heading", ",", 
       "itemSize", ",", "print", ",", "reduce", ",", "result", ",", "rule", 
       ",", "rules", ",", 
       RowBox[{"rules0", "=", 
        RowBox[{"{", "}"}]}], ",", "rules1", ",", "selectionRule", ",", 
       "sort", ",", "table", ",", 
       RowBox[{"table0", "=", 
        RowBox[{"{", "}"}]}], ",", "table1", ",", "tableBreaks", ",", 
       "tableLength", ",", "tableParts", ",", "testResult", ",", "transpose", 
       ",", "v", ",", "variables", ",", "variables0", ",", "variables1", ",", 
       "x0", ",", "x1", ",", "x2", ",", 
       RowBox[{"x3", "=", 
        RowBox[{"{", "}"}]}], ",", "xx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "booleanValues", ",", "dividers", ",", "itemSize", ",", "print", ",", 
         "reduce", ",", "rules", ",", "selectionRule", ",", "sort", ",", 
         "tableBreaks", ",", "testResult", ",", "transpose", ",", 
         "variables"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "BooleanValues", ",", "Dividers", ",", "ItemSize", ",", "Print", 
            ",", "Reduce", ",", "Rules", ",", "SelectionRule", ",", "Sort", 
            ",", "TableBreaks", ",", "TestResult", ",", "Transpose", ",", 
            "Variables"}], "}"}], "/.", 
          RowBox[{"{", "options", "}"}]}], "/.", 
         RowBox[{"Options", "[", "ResolutionTable", "]"}]}], "/.", 
        RowBox[{"Random", "\[Rule]", "RandomChoice"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"sort", "===", "False"}], ",", 
        RowBox[{"sort", "=", "Identity"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"x", ",", 
         RowBox[{"OR", "[", 
          RowBox[{"u__", ",", 
           RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"xx", ",", 
         RowBox[{
          RowBox[{"OR", "[", 
           RowBox[{"u_", ",", "__"}], "]"}], "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"xx", ",", "u"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, all members of the first argument are tautologies\>\"",
           "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", "  ", 
      RowBox[{"variables", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"variables", "===", "All"}], ",", 
         RowBox[{"LVariableSet", "[", "xx", "]"}], ",", 
         RowBox[{"Select", "[", 
          RowBox[{"variables", ",", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"FreeQ", "[", 
              RowBox[{"xx", ",", "#"}], "]"}]}], "&"}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"variables", "===", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ClearAttributes", "[", 
          RowBox[{"OR", ",", 
           RowBox[{"{", 
            RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Return", "[", 
          "\"\<Failed, the first argument doesn't depend on given logical \
variables\>\"", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"variables1", "=", 
       RowBox[{"RemoveSubscript", "[", "variables", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rules1", "=", 
       RowBox[{"Thread", "[", 
        RowBox[{"Rule", "[", 
         RowBox[{"variables", ",", "variables1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"xx", "/.", "rules1"}], "//", "sort"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"variables0", ",", "x0"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{"variables1", ",", "xx"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"x0", ",", "FALSE"}], "]"}], "&&", 
         RowBox[{"variables0", "=!=", 
          RowBox[{"{", "}"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"v", "=", 
          RowBox[{"selectionRule", "[", "variables0", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"variables", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"variables", ",", "v"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"case", "=", 
          RowBox[{"variableCase", "[", 
           RowBox[{"x0", ",", "v"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"case", "\[LessEqual]", "1"}], "&&", "rules"}], ",", 
           RowBox[{
            RowBox[{"rule", "=", 
             RowBox[{"variableRule", "[", 
              RowBox[{"x0", ",", "v"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"xx", ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"Global`\[Bullet]", " ", ",", 
                 RowBox[{"rule", "//", "First"}], ",", "Global`\[Bullet]"}], 
                "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{
              RowBox[{"DeleteCases", "[", 
               RowBox[{
                RowBox[{"x0", "//.", "rule"}], ",", "True"}], "]"}], "//", 
              "sort"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"rules0", "=", 
             RowBox[{"Join", "[", 
              RowBox[{"rules0", ",", "rule"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xx", "=", 
             RowBox[{"Join", "[", 
              RowBox[{"xx", ",", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{"x0", ",", 
                 RowBox[{"u_", "/;", 
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"xx", ",", "u"}], "]"}]}]}], "]"}]}], "]"}]}]}], 
           ",", "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"x1", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x0", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "True"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x2", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x0", ",", 
               RowBox[{
                RowBox[{"SameQ", "[", 
                 RowBox[{
                  RowBox[{"#", "/.", 
                   RowBox[{"v", "\[Rule]", "False"}]}], ",", "True"}], "]"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x3", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"x0", ",", 
               RowBox[{
                RowBox[{"FreeQ", "[", 
                 RowBox[{"#", ",", "v"}], "]"}], "&"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{"Distribute", "[", 
              RowBox[{
               RowBox[{"OR", "[", 
                RowBox[{
                 RowBox[{"x1", "/.", 
                  RowBox[{"v", "\[Rule]", "False"}]}], ",", 
                 RowBox[{"x2", "/.", 
                  RowBox[{
                   RowBox[{"NOT", "[", "v", "]"}], "\[Rule]", "False"}]}]}], 
                "]"}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{
               RowBox[{"x0", "/.", 
                RowBox[{"False", "\[Rule]", "FALSE"}]}], ",", 
               RowBox[{"OR", "[", 
                RowBox[{"u__", ",", 
                 RowBox[{"NOT", "[", "u__", "]"}], ",", "___"}], "]"}]}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{
              RowBox[{"x0", "//.", 
               RowBox[{
                RowBox[{"OR", "[", 
                 RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}], "//", 
              "sort"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"reduce", ",", "\[IndentingNewLine]", 
              RowBox[{"x0", "=", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{"x0", ",", 
                 RowBox[{
                  RowBox[{"OR", "[", 
                   RowBox[{"u_", ",", "__"}], "]"}], "/;", 
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"x3", ",", "u"}], "]"}]}]}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"x0", "=", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{"x0", ",", 
                 RowBox[{"u_", "/;", 
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"x3", ",", "u"}], "]"}]}]}], "]"}]}]}], "]"}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"xx", ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\< \>\"", ",", "Global`\[Bullet]", ",", "v", ",", 
                 "Global`\[Bullet]"}], "}"}], "]"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"xx", "=", 
             RowBox[{"Join", "[", 
              RowBox[{"xx", ",", "x0"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{
              RowBox[{"Join", "[", 
               RowBox[{"x0", ",", "x3"}], "]"}], "//", "sort"}]}]}]}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"variables0", "=", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"testResult", ",", 
            RowBox[{
             RowBox[{"variables1", "=", 
              RowBox[{"Select", "[", 
               RowBox[{"variables1", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"#", "=!=", "v"}], ")"}], "&"}]}], "]"}]}], ";", 
             "variables1"}], ",", 
            RowBox[{"Select", "[", 
             RowBox[{"variables0", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"#", "=!=", "v"}], ")"}], "&"}]}], "]"}]}], 
           "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variables0", "=", 
       RowBox[{"Prepend", "[", 
        RowBox[{"variables", ",", "\[Infinity]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"heading", "=", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"variables", "/.", 
          RowBox[{"Reverse", "/@", "rules1"}]}], ",", 
         "Global`\[GraySquare]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"u", ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Intersection", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"variableRule", "[", 
                    RowBox[{"u", ",", "#"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "&"}], "/@", 
                  RowBox[{"Take", "[", 
                   RowBox[{"variables0", ",", 
                    RowBox[{"n", "-", "1"}]}], "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"False", ",", "True"}], "}"}]}], "]"}], "===", 
               RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"variableRule", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"variables0", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
              "Global`\[Bullet]"}], "]"}]}], "]"}], "/@", "xx"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "2", ",", 
           RowBox[{"Length", "[", "variables0", "]"}]}], "}"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{
        RowBox[{"Prepend", "[", 
         RowBox[{"table", ",", "xx"}], "]"}], "//", "Transpose"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"x0", ",", "FALSE"}], "]"}], "&&", "testResult"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"table", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"table", ",", 
            RowBox[{
             RowBox[{"variables0", "/.", 
              RowBox[{"\[Infinity]", "->", "Global`\[GraySquare]"}]}], "/.", 
             "rules0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"variables0", ",", "x0"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Prepend", "[", 
              RowBox[{"variables", ",", "Global`\[EmptySquare]"}], "]"}], "/.",
              "rules0"}], ",", 
            RowBox[{"Select", "[", 
             RowBox[{"xx", ",", 
              RowBox[{
               RowBox[{"ClauseQ", "[", "#", "]"}], "&"}]}], "]"}]}], "}"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"rules0", "=!=", 
            RowBox[{"{", "}"}]}], ",", 
           RowBox[{"x0", "=", 
            RowBox[{"DeleteCases", "[", 
             RowBox[{
              RowBox[{"x0", "/.", "rules0"}], ",", "True"}], "]"}]}]}], "]"}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"variables", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"variables", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"x0", ",", "#", ",", "\[Infinity]"}], "]"}], "&&", 
              RowBox[{"FreeQ", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"\[Infinity]", ",", "True", ",", "False"}], "}"}], 
                ",", "#"}], "]"}]}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x0", "=!=", 
             RowBox[{"{", "}"}]}], "&&", 
            RowBox[{"variables", "=!=", 
             RowBox[{"{", "}"}]}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"variables1", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"variables", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"variableCase", "[", 
                  RowBox[{"x0", ",", "#"}], "]"}], "\[LessEqual]", "1"}], 
                "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"variables1", "=!=", 
               RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"v", "=", 
                RowBox[{"selectionRule", "[", "variables1", "]"}]}], ";", 
               RowBox[{"rule", "=", 
                RowBox[{"First", "@", 
                 RowBox[{"variableRule", "[", 
                  RowBox[{"x0", ",", "v"}], "]"}]}]}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"v", "=", 
                RowBox[{"Last", "[", "variables", "]"}]}], ";", 
               RowBox[{"rule", "=", 
                RowBox[{"v", "->", "True"}]}]}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"rules0", ",", "rule"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"x0", "=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{
               RowBox[{"x0", "/.", "rule"}], ",", "True"}], "]"}]}], ";", 
            RowBox[{"variables0", "=", 
             RowBox[{"variables0", "/.", "rule"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"variables", "=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{"variables", ",", "v"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"table", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"table", ",", "variables0"}], "]"}]}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"result", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{"xx", ",", 
              RowBox[{
               RowBox[{"ClauseQ", "[", "#", "]"}], "&"}]}], "]"}], "/.", 
            "rules0"}], "//", 
           RowBox[{
            RowBox[{"AND", "@@", "#"}], "&"}]}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"testResult", "=", "False"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{
        RowBox[{"table", "/.", 
         RowBox[{"Reverse", "/@", "rules1"}]}], "//.", 
        RowBox[{"Thread", "[", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", "booleanValues"}], 
          "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"tableLength", "=", 
       RowBox[{"Length", "[", "table", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"tableBreaks", "~", "MatchQ", "~", "_Integer"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"tableBreaks", "+", "1"}], ",", 
           RowBox[{"tableLength", "-", "1"}], ",", " ", "tableBreaks"}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"tableBreaks", "~", "MatchQ", "~", 
         RowBox[{"{", "__Integer", "}"}]}], ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"tableBreaks", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"#", "<", "tableLength"}], "&"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", "True", ",", 
        RowBox[{"tableBreaks", "=", 
         RowBox[{"{", "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tableBreaks", "=", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "tableBreaks", ",", 
         RowBox[{"{", 
          RowBox[{"tableLength", "+", "1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tableBreaks", "[", 
            RowBox[{"[", "#", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"tableBreaks", "[", 
             RowBox[{"[", 
              RowBox[{"#", "+", "1"}], "]"}], "]"}], "-", "1"}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Length", "[", "tableBreaks", "]"}], "-", "1"}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"table", ",", "#"}], "]"}], "&"}], "/@", "tableParts"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"tableParts", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Prepend", "[", 
          RowBox[{"#", ",", "heading"}], "]"}], "&"}], "/@", "tableParts"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"transpose", ",", 
        RowBox[{"tableParts", "=", 
         RowBox[{"Transpose", "/@", "tableParts"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"table", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Grid", "[", 
          RowBox[{"#", ",", 
           RowBox[{"Dividers", "\[Rule]", "dividers"}], ",", 
           RowBox[{"ItemSize", "\[Rule]", "itemSize"}]}], "]"}], "&"}], "/@", 
        "tableParts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"testResult", ",", 
        RowBox[{"table", "=", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{"table", ",", 
           RowBox[{
            RowBox[{"-", "1"}], "->", 
            RowBox[{"Column", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"table", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "1"}], "]"}], "]"}], ",", "result"}], "}"}], 
              ",", "Center"}], "]"}]}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", " ", 
       RowBox[{
        RowBox[{"print", "===", "False"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "table"}], "\[Equal]", "1"}], ",", 
          RowBox[{"First", "@", "table"}], ",", "table"}], "]"}], ",", 
        RowBox[{
         RowBox[{"StylePrint", "/@", "table"}], ";"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ResolutionTable", "]"}], ";"}]}], "Input",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "bb919a74-f2f5-4fb5-98ed-2a6a04dd8b3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries for RefutationTree", "Subsubsection",
 CellMargins->{{18.8, 3.}, {8., 12.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.5410852540934*^9, 3.5410852540934*^9}, 
   3.5410852976642*^9},
 FontSize->14,ExpressionUUID->"413a0623-d9be-4139-9227-f619b24627d6"],

Cell["BTreeQ[x] tests whether x is a binary tree.", "Text",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.5410853973326*^9, 3.5410854146798*^9}, 
   3.5410854618698*^9, {3.713453633421754*^9, 3.713453641991766*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"060bd926-f93d-4ce7-88b8-799aba6a64d6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"BT", ",", "BTreeQ"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"BT", ",", "BTreeQ"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BTreeQ", "[", 
    RowBox[{"{", 
     RowBox[{"BT", "[", "x_", "]"}], "}"}], "]"}], ":=", "True"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BTreeQ", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BT", "[", "x_", "]"}], ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"BTreeQ", "[", "y", "]"}], ",", 
     RowBox[{"BTreeQ", "[", "z", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BTreeQ", "[", "x_", "]"}], ":=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TemplateBox[{
     RowBox[{"\[LeftDoubleBracket]", "x_", "\[RightDoubleBracket]"}]},
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TemplateBox[{RowBox[{"BT", "[", "x_", "]"}]},
     "NotationTemplateTag"]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"BT", ",", "BTreeQ"}], "]"}], ";"}]}], "Input",
 CellMargins->{{18.8, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.5410853445266*^9, 3.5410853445422*^9}, {
   3.7115999174108396`*^9, 3.711599920040843*^9}, {3.7115999545308914`*^9, 
   3.7116000087809677`*^9}, {3.715159374286228*^9, 3.7151593830662403`*^9}, {
   3.715167614809766*^9, 3.7151676645598354`*^9}, {3.7151677018698883`*^9, 
   3.7151677071898956`*^9}, 3.715168870621524*^9, {3.7151689035715704`*^9, 
   3.7151689382616186`*^9}, {3.7152571520357018`*^9, 3.715257174715734*^9}, {
   3.715285770863013*^9, 3.7152858149130745`*^9}, {3.7152859284832335`*^9, 
   3.715285943963255*^9}, {3.7154371737716045`*^9, 3.715437226961679*^9}},
 ExpressionUUID -> "28b2f4b2-4a28-4934-ac50-18f0bd2cc829"],

Cell["\<\
BTreeForm prints a binary tree as a table or a tree.
Alternatives for options (default value = the first alternative):
- Format ->  TreePlot | TableForm | List,
- RootPosition -> Right | Left | Top | Bottom,
- TableSpacing ->  {nonnegative integer, nonnegative integer},
- Format ->List |  TreePlot | TableForm.\
\>", "Text",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.5410853852581997`*^9, 3.5410854146954*^9}, {
   3.5410854654266*^9, 3.5410855505246*^9}, {3.707674232650509*^9, 
   3.7076742452205267`*^9}, 3.71156082107404*^9, {3.7115623943262424`*^9, 
   3.711562458176332*^9}, {3.711562494726383*^9, 3.7115624949363832`*^9}, {
   3.7115625471064568`*^9, 3.711562592916521*^9}, {3.7116270977149343`*^9, 
   3.7116271069049473`*^9}, {3.711732771055159*^9, 3.711732773375162*^9}, {
   3.7134536262517443`*^9, 3.7134536267517447`*^9}, {3.7134536630517955`*^9, 
   3.7134536974518437`*^9}, {3.715325565911327*^9, 3.715325569401332*^9}, {
   3.715325603321379*^9, 3.715325614871395*^9}, {3.7153300898276606`*^9, 
   3.7153301032776794`*^9}, {3.718739997750201*^9, 3.7187400130002227`*^9}, 
   3.718741395302158*^9, {3.718792506272318*^9, 3.7187925082923203`*^9}, {
   3.7196935832272882`*^9, 3.719693647187378*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"3f5d1147-68a7-49ef-a774-c8b12903be29"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "BTreeForm", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "BTreeForm", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "BTreeForm", "]"}], "=", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
      RowBox[{"Format", "\[Rule]", "TableForm"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", "All"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"500", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"PlotTheme", "\[Rule]", "\"\<ClassicLabeled\>\""}], ",", 
      RowBox[{"RootPosition", "\[Rule]", "Right"}], ",", 
      RowBox[{"TableSpacing", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BTreeForm", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{"!", 
      RowBox[{"BTreeQ", "[", "x", "]"}]}]}], ",", "opts___Rule"}], "]"}], 
  ":=", "\"\<Failed, the argument is not binary tree.\>\""}], "\
\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BTreeForm", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{"BTreeQ", "[", "x", "]"}]}], ",", "opts___Rule"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "bTree", ",", "bTreeDepth", ",", "format", ",", "frame", ",", 
       "function", ",", "nodes", ",", "options", ",", "plotTheme", ",", 
       "position", ",", "root", ",", "rootPosition", ",", "rules1", ",", 
       "rules2", ",", "rules3", ",", "spacing", ",", "xx"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "format", ",", "frame", ",", "rootPosition", ",", "root", ",", 
         "spacing"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Format", ",", "Frame", ",", "RootPosition", ",", "Root", ",", 
           "TableSpacing"}], "}"}], "/.", 
         RowBox[{"{", "opts", "}"}]}], "/.", 
        RowBox[{"Options", "[", "BTreeForm", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"options", "=", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{"{", "opts", "}"}], ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"Options", "[", "BTreeForm", "]"}], ",", 
           RowBox[{"Except", "[", 
            RowBox[{"{", "opts", "}"}], "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"options", "=", 
       RowBox[{"FilterRules", "[", 
        RowBox[{"options", ",", 
         RowBox[{"Options", "[", "TreePlot", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"root", "=", 
       RowBox[{"x", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"format", "===", "TableForm"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bTree", "=", 
            RowBox[{"bTreeForm", "[", 
             RowBox[{"x", ",", "rootPosition"}], "]"}]}], ",", 
           RowBox[{"bTreeDepth", "=", 
            RowBox[{"Depth", "[", "bTree", "]"}]}]}], "}"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"spacing", "=", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"spacing", ",", 
             RowBox[{"{", "bTreeDepth", "}"}]}], "]"}], "//", "Flatten"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"bTree", "=", 
          RowBox[{"TableForm", "[", 
           RowBox[{"bTree", ",", 
            RowBox[{"TableAlignments", "\[Rule]", 
             RowBox[{"Table", "[", 
              RowBox[{"rootPosition", ",", 
               RowBox[{"{", "bTreeDepth", "}"}]}], "]"}]}], ",", 
            RowBox[{"TableSpacing", "\[Rule]", "spacing"}]}], "]"}]}], ";", 
         RowBox[{"If", "[", 
          RowBox[{"frame", ",", 
           RowBox[{"Framed", "[", 
            RowBox[{"bTree", ",", 
             RowBox[{"FrameMargins", "\[Rule]", "10"}]}], "]"}], ",", 
           "bTree"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"format", "===", "List"}], "||", 
         RowBox[{"format", "===", "TreePlot"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"xx", "=", 
            RowBox[{"x", "//.", 
             RowBox[{"BT", "\[Rule]", "List"}]}]}], ",", 
           RowBox[{"nodes", "=", 
            RowBox[{"xx", "//", "Flatten"}]}]}], "}"}], ";", 
         RowBox[{"position", "=", 
          RowBox[{"Position", "[", 
           RowBox[{"xx", ",", 
            RowBox[{"{", "#", "}"}], ",", "\[Infinity]"}], "]"}]}], ";", 
         RowBox[{"function", "=", 
          RowBox[{"Function", "[", 
           RowBox[{"u", ",", 
            RowBox[{"Rule", "[", 
             RowBox[{"#", ",", "u"}], "]"}]}], "]"}]}], ";", 
         RowBox[{"rules1", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"position", "=", 
                    RowBox[{"Position", "[", 
                    RowBox[{"xx", ",", 
                    RowBox[{"{", "#", "}"}], ",", "\[Infinity]"}], "]"}]}], 
                   ",", 
                   RowBox[{"function", "=", 
                    RowBox[{"Function", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"#", ",", "u"}], "]"}]}], "]"}]}]}], "}"}], ";", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "position", "]"}], "\[Equal]", 
                    "1"}], ",", " ", 
                   RowBox[{"Rule", "[", 
                    RowBox[{"#", ",", "position"}], "]"}], ",", 
                   RowBox[{"function", "/@", "position"}]}], "]"}]}], ")"}], 
               "&"}], "/@", "nodes"}], "//.", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"{", "u__", "}"}], "}"}], "\[Rule]", 
              RowBox[{"{", "u", "}"}]}]}], "//", "Flatten"}], "//", 
           "Union"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"rules2", "=", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"Gather", "[", 
                RowBox[{"rules1", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                   RowBox[{"#2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", "#", "]"}], "==", "1"}], "&"}]}], 
              "]"}], ",", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MapIndexed", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Rule", "[", 
                    RowBox[{
                    SubscriptBox[
                    RowBox[{"{", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], 
                    RowBox[{"#2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]], ",", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], ",", 
                  "#"}], "]"}], "&"}], ",", 
               RowBox[{"Select", "[", 
                RowBox[{
                 RowBox[{"Gather", "[", 
                  RowBox[{"rules1", ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"#2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}]}], 
                "]"}]}], "]"}]}], "]"}], "//", "Flatten"}]}], ";", 
         RowBox[{"rules3", "=", 
          RowBox[{
           RowBox[{"Reverse", "/@", "rules2"}], "/.", 
           RowBox[{
            RowBox[{"Rule", "[", 
             RowBox[{"u_", ",", "v_"}], "]"}], "\[Rule]", 
            RowBox[{"Rule", "[", 
             RowBox[{"u", ",", 
              RowBox[{"{", "v", "}"}]}], "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{"xx", ",", "rules3"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{"xx", "//.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "u_", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "v1_", "}"}], ",", "w1___"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "v2_", "}"}], ",", "w2___"}], "}"}]}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Rule", "[", 
               RowBox[{"u", ",", "v1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "v1", "}"}], ",", "w1"}], "}"}], ",", 
              RowBox[{"Rule", "[", 
               RowBox[{"u", ",", "v2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "v2", "}"}], ",", "w2"}], "}"}]}], "}"}]}]}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"xx", "=", 
          RowBox[{
           RowBox[{"Cases", "[", 
            RowBox[{"xx", ",", "_Rule", ",", "\[Infinity]"}], "]"}], "/.", 
           RowBox[{
            RowBox[{"Rule", "[", 
             RowBox[{"u_", ",", "v_"}], "]"}], "\[Rule]", 
            RowBox[{"Rule", "[", 
             RowBox[{"v", ",", "u"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"format", "===", "List"}], ",", "xx", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TreePlot", "[", 
            RowBox[{"xx", ",", "rootPosition", ",", "root", ",", "options"}], 
            "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "BTreeForm", "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "bTreeForm", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "bTreeForm", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bTreeForm", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"BT", "[", "x_", "]"}], "}"}], ",", 
     RowBox[{"Left", "|", "Right", "|", "Top", "|", "Bottom"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"{", "x", "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bTreeForm", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"BT", "[", "x_", "]"}], ",", "y_", ",", "z_"}], "}"}], ",", 
     "Left"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\< \>\"", ",", 
       RowBox[{"bTreeForm", "[", 
        RowBox[{"y", ",", "Left"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SequenceForm", "[", 
        RowBox[{"\"\<\[Bullet]\>\"", ",", "x", ",", "\"\<\[Bullet] \>\""}], 
        "]"}], ",", "\"\< \>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\< \>\"", ",", 
       RowBox[{"bTreeForm", "[", 
        RowBox[{"z", ",", "Left"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bTreeForm", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"BT", "[", "x_", "]"}], ",", "y_", ",", "z_"}], "}"}], ",", 
     "Right"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bTreeForm", "[", 
        RowBox[{"y", ",", "Right"}], "]"}], ",", "\"\< \>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\< \>\"", ",", 
       RowBox[{"SequenceForm", "[", 
        RowBox[{"\"\< \[Bullet]\>\"", ",", "x", ",", "\"\<\[Bullet]\>\""}], 
        "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bTreeForm", "[", 
        RowBox[{"z", ",", "Right"}], "]"}], ",", "\"\< \>\""}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"bTreeForm", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"BT", "[", "x_", "]"}], ",", "y_", ",", "z_"}], "}"}], ",", 
     "Top"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\< \>\"", ",", 
       RowBox[{"SequenceForm", "[", 
        RowBox[{"\"\<\[Bullet]\>\"", ",", "x", ",", "\"\<\[Bullet]\>\""}], 
        "]"}], ",", "\"\< \>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bTreeForm", "[", 
        RowBox[{"y", ",", "Top"}], "]"}], ",", "\"\< \>\"", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"bTreeForm", "[", 
        RowBox[{"z", ",", "Top"}], "]"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"bTreeForm", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"BT", "[", "x_", "]"}], ",", "y_", ",", "z_"}], "}"}], ",", 
     "Bottom"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bTreeForm", "[", 
        RowBox[{"y", ",", "Bottom"}], "]"}], ",", "\"\< \>\"", ",", 
       RowBox[{"bTreeForm", "[", 
        RowBox[{"z", ",", "Bottom"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\< \>\"", ",", 
       RowBox[{"SequenceForm", "[", 
        RowBox[{"\"\<\[Bullet]\>\"", ",", "x", ",", "\"\<\[Bullet]\>\""}], 
        "]"}], ",", "\"\< \>\""}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "bTreeForm", "]"}], ";"}]}], "Input",
 CellMargins->{{17.2, 10.}, {5., 10.}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "b5234739-2eb5-46a8-848b-bddc92e2733c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Refutation Tree", "Subsubsection",
 CellMargins->{{18, 3}, {8, 12}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.5410860281186*^9, 3.541086045575*^9}},
 FontFamily->"Times New Roman",
 FontSize->14,ExpressionUUID->"1c08d6eb-bd98-4c37-be6c-17bf30782299"],

Cell[CellGroupData[{

Cell["\<\
RTree[x] decides whether the list x of clauses not containing commands is \
satisfiable or not, and in the latter case it finds a refutation tree by an \
algorithm described in Anthony Galton : Logic for Information Technology, \
John Wiley & Sons, 1990, pp.104 - 105.
Alternatives for Options (default value = the first alternative) : 
SelectionRule -> First | Last | Random\
\>", "Text",
 CellMargins->{{18.8, 10.}, {7., 7.}},
 PageBreakWithin->True,
 CellChangeTimes->{{3.5410862548334*^9, 3.5410863164846*^9}, {
  3.711733984886859*^9, 3.7117339883068633`*^9}, {3.711774365848488*^9, 
  3.7117743692484922`*^9}, {3.713453750001917*^9, 3.7134537675419416`*^9}, {
  3.7187924219521995`*^9, 3.718792423032201*^9}, {3.7187924563622475`*^9, 
  3.7187924658122606`*^9}, {3.7187926590125313`*^9, 3.718792677322557*^9}, {
  3.7188741153689427`*^9, 3.7188741203889503`*^9}},
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"8a8d34e2-1ede-4b81-9cbe-b029dd897e31"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "RTree", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "RTree", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "RTree", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"SelectionRule", "\[Rule]", "First"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"\"\<Failed, the first argument is not a list\>\"", "/;", 
    RowBox[{
     RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "options___Rule"}], "]"}], "=", "$Failed"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{
     RowBox[{"{", "FALSE", "}"}], ",", "___Rule"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"BT", "[", "FALSE", "]"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", "?", "ClauseQ"}], "}"}], ",", "options___Rule"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"BT", "[", "x", "]"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", 
       RowBox[{"NOT", "[", "x_", "]"}]}], "}"}], ",", "options___Rule"}], 
    "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"BT", "[", "FALSE", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"BT", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"BT", "[", 
       RowBox[{"NOT", "[", "x", "]"}], "]"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RTree", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"selectionRule", ",", "tree"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"selectionRule", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"SelectionRule", "/.", 
          RowBox[{"{", "options", "}"}]}], "/.", 
         RowBox[{"Options", "[", "RTree", "]"}]}], "/.", 
        RowBox[{"Random", "\[Rule]", "RandomChoice"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tree", "=", 
       RowBox[{"rTree", "[", 
        RowBox[{"x", ",", 
         RowBox[{"SelectionRule", "->", "selectionRule"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", " ", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", "tree"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "RTree", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "e624abd8-a27a-4a4a-9626-4188aacdda82"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "rTree", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "rTree", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "rTree", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"SelectionRule", "\[Rule]", "First"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rTree", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "options___Rule"}], "]"}], "=", "$Failed"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rTree", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", 
       RowBox[{"NOT", "[", "x_", "]"}]}], "}"}], ",", "options___Rule"}], 
    "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"BT", "[", "FALSE", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"BT", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"BT", "[", 
       RowBox[{"NOT", "[", "x", "]"}], "]"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rTree", "[", 
    RowBox[{"x_", ",", "options___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "clause", ",", "rule1", ",", "rule2", ",", "selectionRule", ",", "tree",
        ",", "tree1", ",", "u", ",", "v", ",", "w", ",", "w1", ",", "y", ",", 
       "y1", ",", "variables", ",", "xx"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"selectionRule", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"SelectionRule", "/.", 
          RowBox[{"{", "options", "}"}]}], "/.", 
         RowBox[{"Options", "[", "rTree", "]"}]}], "/.", 
        RowBox[{"Random", "\[Rule]", "RandomChoice"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rule1", ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"BT", "[", "u_", "]"}], "}"}], "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"x", ",", 
            RowBox[{"OR", "[", 
             RowBox[{"u", ",", 
              RowBox[{"NOT", "[", "v", "]"}]}], "]"}], ",", "Infinity"}], 
           "]"}]}], ")"}], "->", 
        RowBox[{"{", 
         RowBox[{"BT", "[", 
          RowBox[{"OR", "[", 
           RowBox[{"u", ",", 
            RowBox[{"NOT", "[", "v", "]"}]}], "]"}], "]"}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rule2", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"BT", "[", "u_", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"BT", "[", "w_", "]"}], ",", "w1___"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"BT", "[", "y_", "]"}], ",", "y1___"}], "}"}]}], "}"}],
            "/;", "\[IndentingNewLine]", 
           RowBox[{"And", "[", 
            RowBox[{
             RowBox[{"Not", "[", 
              RowBox[{"FreeQ", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"w", ",", "y"}], "}"}], ",", 
                RowBox[{"NOT", "[", "v", "]"}]}], "]"}], "]"}], ",", 
             RowBox[{"FreeQ", "[", 
              RowBox[{
               RowBox[{"{", "u", "}"}], ",", 
               RowBox[{"NOT", "[", "v", "]"}]}], "]"}]}], "]"}]}], ")"}], "->",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"BT", "[", 
            RowBox[{"OR", "[", 
             RowBox[{"u", ",", 
              RowBox[{"NOT", "[", "v", "]"}]}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"BT", "[", "w", "]"}], ",", "w1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"BT", "[", "y", "]"}], ",", "y1"}], "}"}]}], "}"}]}], "//.", 
        RowBox[{
         RowBox[{"OR", "[", 
          RowBox[{"u_", ",", "u_"}], "]"}], "\[Rule]", "u"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"variables", "=", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"LVariableSet", "[", "x", "]"}], ",", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{"x", ",", "#"}], "]"}], ",", 
            RowBox[{"MemberQ", "[", 
             RowBox[{"x", ",", 
              RowBox[{"NOT", "[", "#", "]"}]}], "]"}]}], "]"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Catch", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"variables", "=!=", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{
           RowBox[{"v", "=", 
            RowBox[{"selectionRule", "[", "variables", "]"}]}], ";", 
           RowBox[{"Throw", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"BT", "[", "FALSE", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"BT", "[", "v", "]"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"BT", "[", 
                RowBox[{"NOT", "[", "v", "]"}], "]"}], "}"}]}], "}"}], 
            "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"xx", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"x", ",", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"#", ",", "NOT"}], "]"}], "&"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{"xx", "===", 
             RowBox[{"{", "}"}]}], ",", 
            RowBox[{"xx", "===", "x"}]}], "]"}], ",", 
          RowBox[{"Throw", "[", "$Failed", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"clause", ",", "xx", ",", "tree", ",", "variables"}], "}"}],
          "=", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#", ",", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{"x", ",", "#"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"BT", "[", "#", "]"}], "}"}], ",", 
             RowBox[{"LVariableSet", "[", "#", "]"}]}], "}"}], "&"}], "[", 
          RowBox[{"selectionRule", "[", "xx", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"variables", "=!=", 
           RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"clause", ",", "v"}], "}"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"variables", "===", 
                   RowBox[{"{", "#", "}"}]}], ",", "FALSE", ",", 
                  RowBox[{"DeleteCases", "[", 
                   RowBox[{"clause", ",", "#"}], "]"}]}], "]"}], ",", "#"}], 
               "}"}], "&"}], "[", 
             RowBox[{"selectionRule", "[", "variables", "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"xx", ",", 
               RowBox[{"NOT", "[", "v", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"tree", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"BT", "[", "clause", "]"}], ",", "tree", ",", 
                RowBox[{"{", 
                 RowBox[{"BT", "[", 
                  RowBox[{"NOT", "[", "v", "]"}], "]"}], "}"}]}], "}"}]}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tree1", "=", 
               RowBox[{"rTree", "[", 
                RowBox[{
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"DeleteCases", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"NOT", "[", "v", "]"}]}], "]"}], "&"}], ",", 
                   "xx"}], "]"}], ",", "options"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"tree1", "=!=", "$Failed"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"tree1", "=", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"tree1", "//.", "rule1"}], "//.", "rule2"}], "//.", 
                   RowBox[{
                    RowBox[{"OR", "[", 
                    RowBox[{"FALSE", ",", "u__"}], "]"}], "\[Rule]", 
                    RowBox[{"OR", "[", "u", "]"}]}]}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Part", "[", 
                    RowBox[{"tree1", ",", "1"}], "]"}], "===", 
                    RowBox[{"BT", "[", "FALSE", "]"}]}], ",", 
                   RowBox[{"Throw", "[", 
                    RowBox[{"rTree", "[", 
                    RowBox[{"xx", ",", "options"}], "]"}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"tree", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"BT", "[", "clause", "]"}], ",", "tree", ",", 
                    "tree1"}], "}"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"Throw", "[", "$Failed", "]"}]}], "]"}]}]}], "]"}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"variables", "=", 
            RowBox[{"DeleteCases", "[", 
             RowBox[{"variables", ",", "v"}], "]"}]}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Throw", "[", "tree", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "rTree", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 CellChangeTimes->{{3.7117030688424144`*^9, 3.7117031218924885`*^9}, {
   3.711703289282723*^9, 3.711703291442726*^9}, {3.7117036100331717`*^9, 
   3.711703676563265*^9}, {3.711720510177994*^9, 3.7117205536980553`*^9}, {
   3.711720615888142*^9, 3.711720625118155*^9}, {3.711720701778262*^9, 
   3.7117207205082884`*^9}, {3.711720758128341*^9, 3.711720770248358*^9}, {
   3.7117208542984757`*^9, 3.7117209037785454`*^9}, {3.7117210124586973`*^9, 
   3.711721018538706*^9}, {3.7117210563887587`*^9, 3.7117210718387804`*^9}, {
   3.711721119498847*^9, 3.7117211512788916`*^9}, {3.7117212804290724`*^9, 
   3.7117212976290965`*^9}, {3.7117213697491975`*^9, 3.711721376229206*^9}, {
   3.7117215055193872`*^9, 3.7117215089493923`*^9}, {3.711723083021596*^9, 
   3.711723089291605*^9}, {3.7117233661819925`*^9, 3.711723397312036*^9}, {
   3.7117242403432164`*^9, 3.7117242617532463`*^9}, {3.7117266105065346`*^9, 
   3.711726638626574*^9}, {3.7117266894266453`*^9, 3.711726695886654*^9}, {
   3.7117268070868096`*^9, 3.7117268217768307`*^9}, {3.711727081647194*^9, 
   3.7117271001072197`*^9}, {3.7117272899574857`*^9, 3.71172729307749*^9}, {
   3.711727383387616*^9, 3.7117273864976206`*^9}, {3.7117274603377247`*^9, 
   3.711727463087728*^9}, {3.711727496317775*^9, 3.711727502907784*^9}, {
   3.7117278474382663`*^9, 3.7117279295783815`*^9}, {3.7117280660785723`*^9, 
   3.7117280738585835`*^9}, {3.7117282040287657`*^9, 3.7117283103989143`*^9}, 
   3.711728383109016*^9, {3.711728432119085*^9, 3.7117284738191433`*^9}, {
   3.7117285307692227`*^9, 3.7117285623392673`*^9}, 3.7117288512196712`*^9, 
   3.711728884879719*^9, {3.711728962309827*^9, 3.7117290191199064`*^9}, {
   3.711729067839975*^9, 3.711729082239995*^9}, {3.7117291185300455`*^9, 
   3.711729131000063*^9}, {3.7117291817501345`*^9, 3.7117291980501575`*^9}, {
   3.71172924316022*^9, 3.7117292776002684`*^9}, 3.7117293467503653`*^9, {
   3.7117295048405867`*^9, 3.7117295175906043`*^9}, {3.7117295770806875`*^9, 
   3.71172957856069*^9}, {3.711729614970741*^9, 3.7117296421407785`*^9}, {
   3.711729686370841*^9, 3.711729690070846*^9}, 3.711729730990903*^9, {
   3.711729780330972*^9, 3.71172979285099*^9}, {3.7117298351810493`*^9, 
   3.711729837321052*^9}, {3.7117298679510946`*^9, 3.711729893671131*^9}, {
   3.7117299445312023`*^9, 3.7117299584412217`*^9}, {3.7117299890812645`*^9, 
   3.7117300527613535`*^9}, {3.7117301006114206`*^9, 
   3.7117301027414236`*^9}, {3.7117301347914686`*^9, 3.711730188591544*^9}, {
   3.7117302560816383`*^9, 3.7117303585017815`*^9}, {3.7117305346620283`*^9, 
   3.7117305499620495`*^9}, {3.711730580792093*^9, 3.7117305924921093`*^9}, {
   3.711730626622157*^9, 3.711730668162215*^9}, {3.711730720712289*^9, 
   3.711730722892292*^9}, {3.711731005242687*^9, 3.7117310917928085`*^9}, {
   3.711731287223082*^9, 3.7117313154231215`*^9}, {3.7117313956532335`*^9, 
   3.711731410123254*^9}, {3.7117314537233152`*^9, 3.7117314599533234`*^9}, {
   3.711731504653386*^9, 3.7117315150734005`*^9}, {3.71173157862349*^9, 
   3.711731666763613*^9}, {3.7117317110436754`*^9, 3.711731713193678*^9}, {
   3.7117317486137276`*^9, 3.711731773583763*^9}, {3.711731810873815*^9, 
   3.711731832163845*^9}, {3.711735993507183*^9, 3.7117360296572337`*^9}, {
   3.7117360635272813`*^9, 3.711736153507407*^9}, {3.7117363405176687`*^9, 
   3.711736345757676*^9}, {3.711736432577798*^9, 3.711736440737809*^9}, {
   3.711736479307863*^9, 3.7117365265379295`*^9}, {3.71173662705807*^9, 
   3.711736661268118*^9}, {3.711736759088255*^9, 3.711736795938307*^9}, {
   3.7117368892284374`*^9, 3.7117369609385376`*^9}, {3.7117370176686172`*^9, 
   3.711737019028619*^9}, {3.711737175598838*^9, 3.711737242038931*^9}, {
   3.711737306769022*^9, 3.7117373783191223`*^9}, {3.711737421269182*^9, 
   3.7117374687992487`*^9}, {3.7117375144193125`*^9, 
   3.7117375457593565`*^9}, {3.711737696029567*^9, 3.7117376964295673`*^9}, {
   3.711737731239616*^9, 3.7117377557496505`*^9}, {3.711742194835387*^9, 
   3.71174219679539*^9}, {3.711742294985527*^9, 3.711742298195532*^9}, {
   3.711742419135701*^9, 3.7117424232057066`*^9}, {3.711742569145911*^9, 
   3.7117425696659117`*^9}, {3.711742601885957*^9, 3.7117426030659585`*^9}, {
   3.711742681366068*^9, 3.7117426872760763`*^9}, {3.711742912816392*^9, 
   3.711742915516396*^9}, {3.7117429597564583`*^9, 3.711743016186537*^9}, {
   3.711743208946807*^9, 3.711743219176821*^9}, {3.7117432657668867`*^9, 
   3.711743271966895*^9}, {3.711743330436977*^9, 3.7117433318069787`*^9}, {
   3.7117433718070345`*^9, 3.711743423557107*^9}, {3.711743457547155*^9, 
   3.7117434594171576`*^9}, {3.711743610627369*^9, 3.711743619867382*^9}, {
   3.7117437027774982`*^9, 3.711743778057604*^9}, 3.711743877547743*^9, {
   3.711744108628066*^9, 3.711744117888079*^9}, 3.7117768885220194`*^9, {
   3.7117769313620796`*^9, 3.7117769356120853`*^9}, {3.7117769735521383`*^9, 
   3.711776975172141*^9}, {3.7117770685622716`*^9, 3.711777070482274*^9}, {
   3.711777106702325*^9, 3.7117771077923265`*^9}, {3.7117771602623997`*^9, 
   3.711777216772479*^9}, {3.711777361842682*^9, 3.7117773708826947`*^9}, {
   3.711777465352827*^9, 3.711777466882829*^9}, {3.7117775066128845`*^9, 
   3.7117776463330803`*^9}, {3.711778723184588*^9, 3.7117787903446817`*^9}, 
   3.7117788276247344`*^9, 3.7117788606347804`*^9, {3.7117789214948654`*^9, 
   3.711778932474881*^9}, {3.7117790098649893`*^9, 3.7117790129049935`*^9}, {
   3.7117790561650543`*^9, 3.7117790587650576`*^9}, {3.711791438934752*^9, 
   3.711791441704756*^9}, {3.711791560714923*^9, 3.711791565444929*^9}, {
   3.711791673575081*^9, 3.711791677315086*^9}, {3.7117918543953333`*^9, 
   3.711791868085353*^9}, {3.711792103845683*^9, 3.7117921371757298`*^9}, {
   3.7117934379775505`*^9, 3.7117934428975573`*^9}, {3.711793518117663*^9, 
   3.711793562517725*^9}, {3.7117936161678*^9, 3.711793662217865*^9}, {
   3.711825692121065*^9, 3.711825693451067*^9}, 3.7118264571521363`*^9, 
   3.7118264965421915`*^9, {3.7145712503505163`*^9, 3.714571259910529*^9}, {
   3.71509127542773*^9, 3.715091292877754*^9}, {3.7150913404078207`*^9, 
   3.715091356387843*^9}, {3.715092006508754*^9, 3.7150920572788243`*^9}, {
   3.715092106918894*^9, 3.715092145968949*^9}, {3.7150923259492006`*^9, 
   3.715092377239272*^9}, {3.715092426009341*^9, 3.7150924403393607`*^9}, 
   3.7150925113594604`*^9, {3.7153283710852537`*^9, 3.7153283848652735`*^9}, {
   3.715328445685358*^9, 3.7153284624553823`*^9}, {3.7154374393519764`*^9, 
   3.7154374825620365`*^9}, {3.718791034430257*^9, 3.718791048890277*^9}, {
   3.718791098010346*^9, 3.7187911309303923`*^9}, {3.7187922712319884`*^9, 
   3.718792323502062*^9}, {3.7187951691460457`*^9, 3.718795175006054*^9}, {
   3.718795685196768*^9, 3.7187957132168074`*^9}, {3.7187957790868998`*^9, 
   3.7187957799169006`*^9}, {3.718796187967472*^9, 3.7187962064474974`*^9}, {
   3.7187962399175444`*^9, 3.7187962512675605`*^9}, {3.7187964012477703`*^9, 
   3.7187964062677774`*^9}, {3.7187964629778566`*^9, 3.718796466687862*^9}, {
   3.7187995349821577`*^9, 3.7187995407221656`*^9}, {3.718799651952321*^9, 
   3.718799663312337*^9}, {3.7188000471728745`*^9, 3.718800076072915*^9}, {
   3.71880011492297*^9, 3.718800139493004*^9}, {3.718800260103173*^9, 
   3.718800318383254*^9}, {3.718800546483574*^9, 3.718800576493616*^9}, {
   3.7188006292836895`*^9, 3.718800632323694*^9}, {3.7188006821737633`*^9, 
   3.7188007100538025`*^9}, {3.7188007402638454`*^9, 3.718800815823951*^9}, {
   3.7188008589340115`*^9, 3.7188008670740223`*^9}, {3.7188010653143*^9, 
   3.7188010667243023`*^9}, 3.718801114434369*^9, {3.718801359044711*^9, 
   3.7188013698047266`*^9}, {3.7188014060647774`*^9, 3.718801407344779*^9}, {
   3.718803448187636*^9, 3.7188034775576773`*^9}, {3.7188037054779963`*^9, 
   3.718803718788015*^9}, {3.7188037523380623`*^9, 3.718803835868179*^9}, {
   3.7188041271185865`*^9, 3.71880414367861*^9}, {3.718804238178742*^9, 
   3.718804271438789*^9}, 3.718807138712803*^9, {3.7188074254332047`*^9, 
   3.7188074406732254`*^9}, {3.718807703563594*^9, 3.718807706153597*^9}, {
   3.718808158654231*^9, 3.718808178214258*^9}, 3.718808227424327*^9, {
   3.7188083375844812`*^9, 3.7188085385247626`*^9}, {3.7188086057348566`*^9, 
   3.718808671774949*^9}, {3.7188087640850782`*^9, 3.718808792445118*^9}, {
   3.718809153005623*^9, 3.718809173655652*^9}, 3.718809353865904*^9, {
   3.718809472966071*^9, 3.7188094763460755`*^9}, {3.7188100354268584`*^9, 
   3.7188100440768704`*^9}, {3.7188101276269875`*^9, 3.71881012940699*^9}, {
   3.7188101662470417`*^9, 3.7188101874170713`*^9}, {3.7188211271136045`*^9, 
   3.718821128793607*^9}, {3.7188226362957177`*^9, 3.718822639595722*^9}, {
   3.718822682105782*^9, 3.7188226824357824`*^9}, {3.7188227522558804`*^9, 
   3.718822758625889*^9}, {3.718823079336338*^9, 3.718823082836343*^9}, 
   3.7188236057970753`*^9, 3.7188238154773684`*^9, {3.718823904007492*^9, 
   3.718823912997505*^9}, {3.7188245483783946`*^9, 3.7188245530684013`*^9}, {
   3.7188246029984713`*^9, 3.718824651248539*^9}, {3.7188247037486124`*^9, 
   3.718824739298662*^9}, 3.718824864978838*^9, {3.7188271689720635`*^9, 
   3.7188272598721905`*^9}, {3.7188273344722953`*^9, 
   3.7188273379223003`*^9}, {3.7188290805747395`*^9, 
   3.7188290816747413`*^9}, {3.7188295703754253`*^9, 3.718829594135459*^9}, 
   3.718829628195506*^9, {3.718829741465665*^9, 3.718829749405676*^9}, {
   3.718829784545725*^9, 3.7188297920157356`*^9}, {3.7188299294759283`*^9, 
   3.71882993054593*^9}, {3.7188299996160264`*^9, 3.718830005686035*^9}, {
   3.7188314547280636`*^9, 3.7188314950981197`*^9}, {3.7188318613386326`*^9, 
   3.718831880228659*^9}, {3.7188319103487015`*^9, 3.7188319174487114`*^9}, {
   3.7188715287153215`*^9, 3.7188715351453304`*^9}, 3.7188715969854174`*^9},
 ExpressionUUID -> "2a22bdbd-693b-4cba-8989-054a0c109e0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
RefutationTree[x] outputs RTree[x] in a convenient graphic form.
Alternatives for Options (default value = the first alternative):
- Format -> TreePlot | TableForm | List,
- RootPosition -> Right | Left | Top | Bottom,
- SelectionRule -> First | Last | RandomChoice,
- Sort -> DeleteDuplicates | Union,
- TableSpacing -> Automatic | {nonnegative integer, nonnegative integer}.\
\>", "Text",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold",ExpressionUUID->"a3920b0d-f750-466f-86ad-2ac387a098f5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "RefutationTree", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "RefutationTree", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "RefutationTree", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
      RowBox[{"Format", "\[Rule]", "TreePlot"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"500", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotTheme", "\[Rule]", "\"\<ClassicLabeled\>\""}], ",", 
      RowBox[{"RootPosition", "\[Rule]", "Right"}], ",", 
      RowBox[{"Root", "\[Rule]", "FALSE"}], ",", 
      RowBox[{"SelectionRule", "\[Rule]", "First"}], ",", 
      RowBox[{"Sort", "\[Rule]", "DeleteDuplicates"}], ",", 
      RowBox[{"TableSpacing", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RefutationTree", "[", 
    RowBox[{"x_", ",", "opts___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"\"\<Failed, the first argument is not a list\>\"", "/;", 
    RowBox[{
     RowBox[{"Head", "[", "x", "]"}], "=!=", "List"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RefutationTree", "[", 
    RowBox[{"x_", ",", "opts___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"\"\<Failed, a member of the first argument is not clause\>\"", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"ClauseQ", ",", "x"}], "]"}], ",", "False"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RefutationTree", "[", 
    RowBox[{"x_", ",", "opts___Rule"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"options", ",", "selectionRule", ",", "sort", ",", "xx"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"OR", ",", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"selectionRule", ",", "sort"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"SelectionRule", ",", "Sort"}], "}"}], "/.", 
         RowBox[{"{", "opts", "}"}]}], "/.", 
        RowBox[{"Options", "[", "RefutationTree", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"options", "=", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{"{", "opts", "}"}], ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"Options", "[", "RefutationTree", "]"}], ",", 
           RowBox[{"Except", "[", 
            RowBox[{"{", "opts", "}"}], "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"options", "=", 
       RowBox[{"FilterRules", "[", 
        RowBox[{"options", ",", 
         RowBox[{"Options", "[", "BTreeForm", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"x", ",", 
         RowBox[{"OR", "[", 
          RowBox[{"y_", ",", 
           RowBox[{"NOT", "[", "y_", "]"}], ",", "z___"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{
        RowBox[{"xx", "//.", 
         RowBox[{
          RowBox[{"OR", "[", 
           RowBox[{"y_", ",", "y_"}], "]"}], "\[Rule]", "y"}]}], "//", 
        "sort"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xx", "=", 
       RowBox[{"rTree", "[", 
        RowBox[{"xx", ",", 
         RowBox[{"SelectionRule", "->", "selectionRule"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"OR", ",", " ", 
        RowBox[{"{", 
         RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"NOT", ",", "OR"}], "}"}], ",", "HoldAll"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xx", "===", "$Failed"}], ",", 
        RowBox[{
        "Return", "[", "\"\<The set of clauses is satisfiable\>\"", "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"BTreeForm", "[", 
       RowBox[{"xx", ",", 
        RowBox[{"Sequence", "@@", "options"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "RefutationTree", "]"}], ";"}]}], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 PageBreakWithin->True,
 InitializationCell->True,
 ExpressionUUID -> "3d4fdd05-9e94-4e6f-816d-8b6c9f6275ad"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End Private Context", "Subsection",
 CellMargins->{{18.8, 3.}, {8., 12.}},
 PageBreakAbove->False,
 CellChangeTimes->{{3.7134443641257467`*^9, 3.7134443780657663`*^9}, {
  3.713444510265951*^9, 3.713444515235958*^9}, {3.7134490123782597`*^9, 
  3.7134490446583047`*^9}, {3.722112620949368*^9, 3.7221126298993807`*^9}},
 FontSize->16,ExpressionUUID->"07f7337c-928b-4fb8-bb2a-47e4185b1f85"],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 PageBreakBelow->False,
 InitializationCell->True,
 CellChangeTimes->{{3.713449050698313*^9, 3.7134490521083155`*^9}, 
   3.7138108491052647`*^9, {3.714667781158943*^9, 3.714667781928944*^9}},
 ExpressionUUID -> "b1685b5f-7151-4485-af85-66c156099bb0"]
}, Open  ]],

Cell["EndPackage", "Section",
 CellMargins->{{17.2, 10.}, {5., 10.}},
 PageBreakAbove->False,
 CellChangeTimes->{{3.713190917873905*^9, 3.7131909208039093`*^9}, {
   3.7131909552339573`*^9, 3.7131909588939624`*^9}, 3.7138940992487774`*^9},
 FontFamily->"Arial",
 FontSize->18,ExpressionUUID->"c2578ab0-9e38-4e89-86ba-9c0605c970f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 PageBreakAbove->False,
 InitializationCell->True,
 CellChangeTimes->{{3.713449050698313*^9, 3.7134490521083155`*^9}, 
   3.7138108491052647`*^9, {3.714667781158943*^9, 3.714667781928944*^9}, {
   3.722112598179336*^9, 3.7221126013193407`*^9}},
 ExpressionUUID -> "5ff7224d-ca4b-496b-aa1a-50f7ed1c8fb9"],

Cell["Connectives Palette", "Section",
 CellMargins->{{18.0625, 10.}, {5., 10.}},
 FontFamily->"Arial",
 FontSize->18,ExpressionUUID->"ad525dde-f308-4fbd-bed7-1de907c80b8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", "\[IndentingNewLine]", 
   RowBox[{"Notebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Cell", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"BoxData", "[", "\[IndentingNewLine]", 
         RowBox[{"GridBox", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ButtonBox", "[", "\"\<\[Not]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[And]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[Or]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[Implies]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[UpArrow]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[DownArrow]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[CirclePlus]\>\"", "]"}], ",", 
             RowBox[{"ButtonBox", "[", "\"\<\[Equivalent]\>\"", "]"}]}], 
            "}"}], "}"}], "]"}], "]"}], ",", "\"\<NotebookDefault\>\"", ",", 
        RowBox[{"PageBreakAbove", "\[Rule]", "True"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Courier\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}]}], "]"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"NotebookAutoSave", "\[Rule]", "True"}], ",", 
     RowBox[{"ClosingSaveDialog", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"Editable", "\[Rule]", "True"}], ",", 
     RowBox[{"Selectable", "\[Rule]", "False"}], ",", 
     RowBox[{"Clickable", "\[Rule]", "False"}], ",", 
     RowBox[{"WindowToolbars", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"Deletable", "\[Rule]", "True"}], ",", 
     RowBox[{"WindowSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Fit", ",", "Fit"}], "}"}]}], ",", 
     RowBox[{"WindowMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "140"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"WindowFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
     RowBox[{"WindowElements", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"WindowFrameElements", "\[Rule]", "\"\<CloseBox\>\""}], ",", 
     RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Connectives\>\""}], ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Enabled", "\[Rule]", "True"}], ",", 
     RowBox[{"CellOpen", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowCellLabel", "\[Rule]", "False"}], ",", 
     RowBox[{"ShowCellTags", "\[Rule]", "False"}], ",", 
     RowBox[{"Magnification", "\[Rule]", "1."}], ",", 
     RowBox[{
     "FrontEndVersion", "\[Rule]", 
      "\"\<8.0 for Microsoft Windows (32-bit) (October 6, 2011)\>\""}], ",", 
     RowBox[{"StyleDefinitions", "\[Rule]", "\"\<Palette.nb\>\""}]}], "]"}], 
   "]"}], ";"}]], "Input",
 CellMargins->{{19, 10}, {5, 10}},
 Evaluatable->False,
 PageBreakWithin->Automatic,
 CellChangeTimes->{
  3.800043328953781*^9, 3.8000437117645807`*^9, {3.800127084368438*^9, 
   3.800127088728058*^9}},ExpressionUUID->"7f544a7c-1438-4e50-af7c-\
6a2889f5055c"],

Cell["Names", "Section",
 CellMargins->{{18.0625, 10.}, {5., 10.}},
 CellChangeTimes->{{3.8001848646490965`*^9, 3.8001848688519325`*^9}},
 FontFamily->"Arial",
 FontSize->18,ExpressionUUID->"62da108d-d96d-4bf8-8936-2b23cea36fa3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<Notation`*\>\"", "]"}]], "Input",
 CellMargins->{{18, 10}, {5, 10}},
 CellChangeTimes->{{3.8001843827110176`*^9, 3.80018441066222*^9}},
 ExpressionUUID -> "824e3548-bf78-44ad-ac55-c3e2aaea8a85"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Action\"\>", ",", "\<\"ActiveInputAliases\"\>", 
   ",", "\<\"AddInputAlias\"\>", ",", "\<\"AutoLoadNotationPalette\"\>", 
   ",", "\<\"ClearNotations\"\>", ",", "\<\"CreateNotationRules\"\>", 
   ",", "\<\"InfixNotation\"\>", ",", "\<\"Notation\"\>", 
   ",", "\<\"NotationBoxTag\"\>", ",", "\<\"NotationMadeBoxesTag\"\>", 
   ",", "\<\"NotationMakeBoxes\"\>", ",", "\<\"NotationMakeExpression\"\>", 
   ",", "\<\"NotationPatternTag\"\>", ",", "\<\"ParsedBoxWrapper\"\>", 
   ",", "\<\"PrintNotationRules\"\>", ",", "\<\"RemoveInfixNotation\"\>", 
   ",", "\<\"RemoveNotation\"\>", ",", "\<\"RemoveNotationRules\"\>", 
   ",", "\<\"RemoveSymbolize\"\>", ",", "\<\"Symbolize\"\>", 
   ",", "\<\"SymbolizeRootName\"\>", ",", "\<\"WorkingForm\"\>"}], 
  "}"}]], "Output",
 CellMargins->{{17, 10}, {5, 10}},
 ExpressionUUID -> "2161404f-0d18-486d-8520-2c5510a9ac47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<PropositionalLogic`*\>\"", "]"}]], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 CellChangeTimes->{{3.800184114260705*^9, 3.8001841267442226`*^9}},
 ExpressionUUID -> "94ca8955-7234-405a-8812-0a6c1430b85e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AllFalse\"\>", ",", "\<\"AND\"\>", 
   ",", "\<\"BooleanValues\"\>", ",", "\<\"BT\"\>", ",", "\<\"BTreeForm\"\>", 
   ",", "\<\"BTreeQ\"\>", ",", "\<\"ClauseQ\"\>", ",", "\<\"CNF\"\>", 
   ",", "\<\"Connectives\"\>", ",", "\<\"ConvertFormula\"\>", 
   ",", "\<\"DNF\"\>", ",", "\<\"EmptyTruthTable\"\>", ",", "\<\"EQUIV\"\>", 
   ",", "\<\"FALSE\"\>", ",", "\<\"FullResolutionSequence\"\>", 
   ",", "\<\"HList\"\>", ",", "\<\"IMPLIES\"\>", ",", "\<\"Labels\"\>", 
   ",", "\<\"LastFalse\"\>", ",", "\<\"LastTrue\"\>", ",", "\<\"LAtomQ\"\>", 
   ",", "\<\"LEquivalentQ\"\>", ",", "\<\"LFormulaQ\"\>", 
   ",", "\<\"LiteralQ\"\>", ",", "\<\"LStringQ\"\>", 
   ",", "\<\"LTautologyQ\"\>", ",", "\<\"LVariableSet\"\>", 
   ",", "\<\"Mixed\"\>", ",", "\<\"NAND\"\>", ",", "\<\"NOR\"\>", 
   ",", "\<\"NormalizeLString\"\>", ",", "\<\"NOT\"\>", 
   ",", "\<\"OnlyLastFalse\"\>", ",", "\<\"OR\"\>", 
   ",", "\<\"PropositionalLogic\"\>", ",", "\<\"ReduceSpaces\"\>", 
   ",", "\<\"RefutationTree\"\>", ",", "\<\"ReleaseHE\"\>", 
   ",", "\<\"ResolutionDepth\"\>", ",", "\<\"ResolutionSequence\"\>", 
   ",", "\<\"ResolutionTable\"\>", ",", "\<\"Resolvents\"\>", 
   ",", "\<\"ReverseValues\"\>", ",", "\<\"RootPosition\"\>", 
   ",", "\<\"RTree\"\>", ",", "\<\"Rules\"\>", ",", "\<\"SelectionRule\"\>", 
   ",", "\<\"SelectValuations\"\>", ",", "\<\"SequenceBreaks\"\>", 
   ",", "\<\"TableBreaks\"\>", ",", "\<\"TestResult\"\>", 
   ",", "\<\"ToClauses\"\>", ",", "\<\"ToLFormula\"\>", 
   ",", "\<\"ToLString\"\>", ",", "\<\"TRUE\"\>", ",", "\<\"TruthTable\"\>", 
   ",", "\<\"x\"\>", ",", "\<\"XOR\"\>", ",", "\<\"y\"\>", 
   ",", "\<\"y$\"\>"}], "}"}]], "Output",
 CellMargins->{{17, 10}, {5, 10}},
 ExpressionUUID -> "7e8d9003-54cd-4a0e-b286-62265b1da605"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringDrop", "[", 
    RowBox[{"#", ",", "27"}], "]"}], "&"}], "/@", 
  RowBox[{
  "Names", "[", "\"\<PropositionalLogic`Private`*\>\"", "]"}]}]], "Input",
 CellMargins->{{17, 10}, {5, 10}},
 ExpressionUUID -> "5aff06b2-4c80-4799-b3cc-d897abdce29d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"alignment\"\>", ",", "\<\"alignment$\"\>", 
   ",", "\<\"booleanValues\"\>", ",", "\<\"booleanValues$\"\>", 
   ",", "\<\"bTree\"\>", ",", "\<\"bTreeDepth\"\>", 
   ",", "\<\"bTreeDepth$\"\>", ",", "\<\"bTreeForm\"\>", 
   ",", "\<\"bTree$\"\>", ",", "\<\"case\"\>", ",", "\<\"case$\"\>", 
   ",", "\<\"clause\"\>", ",", "\<\"clause$\"\>", ",", "\<\"Complete\"\>", 
   ",", "\<\"depth\"\>", ",", "\<\"depth$\"\>", ",", "\<\"dividers\"\>", 
   ",", "\<\"dividers$\"\>", ",", "\<\"f\"\>", ",", "\<\"form\"\>", 
   ",", "\<\"format\"\>", ",", "\<\"format$\"\>", ",", "\<\"frame\"\>", 
   ",", "\<\"frame$\"\>", ",", "\<\"function\"\>", ",", "\<\"function$\"\>", 
   ",", "\<\"generateResolvents\"\>", ",", "\<\"heading\"\>", 
   ",", "\<\"heading$\"\>", ",", "\<\"InfixConnectives\"\>", 
   ",", "\<\"InfixStrings\"\>", ",", "\<\"itemSize\"\>", 
   ",", "\<\"itemSize$\"\>", ",", "\<\"labels\"\>", ",", "\<\"labels$\"\>", 
   ",", "\<\"Minimal\"\>", ",", "\<\"n\"\>", ",", "\<\"nodes\"\>", 
   ",", "\<\"nodes$\"\>", ",", "\<\"NormalizeLString\"\>", ",", "\<\"n$\"\>", 
   ",", "\<\"options\"\>", ",", "\<\"options$\"\>", ",", "\<\"opts\"\>", 
   ",", "\<\"p\"\>", ",", "\<\"plotTheme\"\>", ",", "\<\"plotTheme$\"\>", 
   ",", "\<\"position\"\>", ",", "\<\"position0\"\>", 
   ",", "\<\"position0$\"\>", ",", "\<\"position1\"\>", 
   ",", "\<\"position1$\"\>", ",", "\<\"positions\"\>", 
   ",", "\<\"positions$\"\>", ",", "\<\"position$\"\>", 
   ",", "\<\"PrefixConnectives\"\>", ",", "\<\"PrefixStrings\"\>", 
   ",", "\<\"print\"\>", ",", "\<\"print$\"\>", ",", "\<\"p$\"\>", 
   ",", "\<\"reduce\"\>", ",", "\<\"reduce$\"\>", 
   ",", "\<\"RemoveSubscript\"\>", ",", "\<\"RestoreSubscript\"\>", 
   ",", "\<\"result\"\>", ",", "\<\"result$\"\>", 
   ",", "\<\"reverseValues\"\>", ",", "\<\"reverseValues$\"\>", 
   ",", "\<\"root\"\>", ",", "\<\"rootPosition\"\>", 
   ",", "\<\"rootPosition$\"\>", ",", "\<\"root$\"\>", ",", "\<\"row\"\>", 
   ",", "\<\"row$\"\>", ",", "\<\"rTree\"\>", ",", "\<\"rule\"\>", 
   ",", "\<\"rule1\"\>", ",", "\<\"rule1$\"\>", ",", "\<\"rule2\"\>", 
   ",", "\<\"rule2$\"\>", ",", "\<\"rules\"\>", ",", "\<\"rules0\"\>", 
   ",", "\<\"rules0$\"\>", ",", "\<\"rules1\"\>", ",", "\<\"rules1$\"\>", 
   ",", "\<\"rules2\"\>", ",", "\<\"rules2$\"\>", ",", "\<\"rules3\"\>", 
   ",", "\<\"rules3$\"\>", ",", "\<\"rules$\"\>", ",", "\<\"rule$\"\>", 
   ",", "\<\"s\"\>", ",", "\<\"selectionRule\"\>", 
   ",", "\<\"selectionRule$\"\>", ",", "\<\"selectValuations\"\>", 
   ",", "\<\"selectValuations$\"\>", ",", "\<\"sequence\"\>", 
   ",", "\<\"sequenceBreaks\"\>", ",", "\<\"sequenceBreaks$\"\>", 
   ",", "\<\"sequenceLength\"\>", ",", "\<\"sequenceLength$\"\>", 
   ",", "\<\"sequenceParts\"\>", ",", "\<\"sequenceParts$\"\>", 
   ",", "\<\"sequence$\"\>", ",", "\<\"sort\"\>", ",", "\<\"sort$\"\>", 
   ",", "\<\"spacing\"\>", ",", "\<\"spacings\"\>", ",", "\<\"spacings$\"\>", 
   ",", "\<\"spacing$\"\>", ",", "\<\"ss1\"\>", ",", "\<\"ss1$\"\>", 
   ",", "\<\"ss2\"\>", ",", "\<\"ss2$\"\>", ",", "\<\"ss3\"\>", 
   ",", "\<\"ss3$\"\>", ",", "\<\"ssVariables1\"\>", 
   ",", "\<\"ssVariables1$\"\>", ",", "\<\"ssVariables2\"\>", 
   ",", "\<\"ssVariables2$\"\>", ",", "\<\"string\"\>", 
   ",", "\<\"Strings\"\>", ",", "\<\"SubscriptBoxToString\"\>", 
   ",", "\<\"t\"\>", ",", "\<\"table\"\>", ",", "\<\"table0\"\>", 
   ",", "\<\"table0$\"\>", ",", "\<\"table1\"\>", ",", "\<\"table1$\"\>", 
   ",", "\<\"tableBreaks\"\>", ",", "\<\"tableBreaks$\"\>", 
   ",", "\<\"tableLength\"\>", ",", "\<\"tableLength$\"\>", 
   ",", "\<\"tableParts\"\>", ",", "\<\"tableParts$\"\>", 
   ",", "\<\"tableWidth\"\>", ",", "\<\"tableWidth$\"\>", 
   ",", "\<\"table$\"\>", ",", "\<\"testResult\"\>", 
   ",", "\<\"testResult$\"\>", ",", "\<\"timing\"\>", ",", "\<\"timing$\"\>", 
   ",", "\<\"ToLettersAndDigits\"\>", ",", "\<\"totalDepth\"\>", 
   ",", "\<\"totalDepth$\"\>", ",", "\<\"trace\"\>", ",", "\<\"trace$\"\>", 
   ",", "\<\"transpose\"\>", ",", "\<\"transpose$\"\>", ",", "\<\"tree\"\>", 
   ",", "\<\"tree1\"\>", ",", "\<\"tree1$\"\>", ",", "\<\"tree$\"\>", 
   ",", "\<\"tuples\"\>", ",", "\<\"tuples$\"\>", ",", "\<\"type\"\>", 
   ",", "\<\"type$\"\>", ",", "\<\"u\"\>", ",", "\<\"u$\"\>", 
   ",", "\<\"v\"\>", ",", "\<\"v1\"\>", ",", "\<\"v1$\"\>", ",", "\<\"v2\"\>",
    ",", "\<\"v2$\"\>", ",", "\<\"variableCase\"\>", 
   ",", "\<\"variableRule\"\>", ",", "\<\"variables\"\>", 
   ",", "\<\"variables0\"\>", ",", "\<\"variables0$\"\>", 
   ",", "\<\"variables1\"\>", ",", "\<\"variables1$\"\>", 
   ",", "\<\"variablesLength\"\>", ",", "\<\"variablesLength$\"\>", 
   ",", "\<\"variables$\"\>", ",", "\<\"varsnumber\"\>", 
   ",", "\<\"varsnumber$\"\>", ",", "\<\"v$\"\>", ",", "\<\"w\"\>", 
   ",", "\<\"w1\"\>", ",", "\<\"w1$\"\>", ",", "\<\"w2\"\>", 
   ",", "\<\"w2$\"\>", ",", "\<\"w$\"\>", ",", "\<\"x0\"\>", 
   ",", "\<\"x0$\"\>", ",", "\<\"x1\"\>", ",", "\<\"x10\"\>", 
   ",", "\<\"x10$\"\>", ",", "\<\"x11\"\>", ",", "\<\"x11$\"\>", 
   ",", "\<\"x12\"\>", ",", "\<\"x12$\"\>", ",", "\<\"x1$\"\>", 
   ",", "\<\"x2\"\>", ",", "\<\"x20\"\>", ",", "\<\"x20$\"\>", 
   ",", "\<\"x21\"\>", ",", "\<\"x21$\"\>", ",", "\<\"x22\"\>", 
   ",", "\<\"x22$\"\>", ",", "\<\"x2$\"\>", ",", "\<\"x3\"\>", 
   ",", "\<\"x3$\"\>", ",", "\<\"xx\"\>", ",", "\<\"xx1\"\>", 
   ",", "\<\"xx12\"\>", ",", "\<\"xx12$\"\>", ",", "\<\"xx1$\"\>", 
   ",", "\<\"xx21\"\>", ",", "\<\"xx21$\"\>", ",", "\<\"xx22\"\>", 
   ",", "\<\"xx22$\"\>", ",", "\<\"xxx\"\>", ",", "\<\"xxx$\"\>", 
   ",", "\<\"xx$\"\>", ",", "\<\"y1\"\>", ",", "\<\"y1$\"\>", 
   ",", "\<\"z\"\>"}], "}"}]], "Output",
 CellMargins->{{18, 10}, {5, 10}},
 ExpressionUUID -> "92563006-f9bd-49e3-98b0-05afc3793390"]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->{"RulerBar", "EditBar"},
CellGrouping->Manual,
WindowSize->{826, 1060},
WindowMargins->{{10, Automatic}, {Automatic, 6}},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{32000, 32000},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], " ", "|"}], "Header", 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, 
   Cell[
    TextData[
     ValueBox["FileName"]], "Header", 
    CellMargins -> {{Inherited, 0}, {Inherited, Inherited}}]}, {
   Cell[
    TextData[
     ValueBox["FileName"]], "Header", 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, 
   Cell[
    TextData[{" ", 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 0}, {Inherited, Inherited}}]}},
PageFooters->{{None, None, None}, {None, None, None}},
PageHeaderLines->{True, True},
PageFooterLines->{False, False},
PrintingOptions->{"FacingPages"->True,
"FirstPageFace"->Right,
"FirstPageFooter"->True,
"FirstPageHeader"->True,
"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.2755905511812, 841.8897637795276},
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{43.65354378, 72.00000078}, {72.00000078, 72.00000078}}},
CellMargins->{{7, 3}, {4, 4}},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
ShowCellLabel->False,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"], "Impl" -> 
  "\[Implies]", "Eqv" -> "\[Equivalent]", "Nand" -> "\[Nand]", "Nor" -> 
  "\[Nor]"},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    StyleData["Input"], CellMargins -> {{19, 10}, {5, 10}}], 
   Cell[
    StyleData["Subsection"], CellMargins -> {{19, 3}, {8, 12}}, FontFamily -> 
    "Arial", FontSize -> 16, FontWeight -> "Bold", FontSlant -> "Plain", 
    FontVariations -> {"StrikeThrough" -> False, "Underline" -> False}], 
   Cell[
    StyleData["Subsubsection"], CellMargins -> {{19, 3}, {2, 10}}, FontFamily -> 
    "Times New Roman", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
    "Plain", FontVariations -> {
     "StrikeThrough" -> False, "Underline" -> False}], 
   Cell[
    StyleData["Text"], CellMargins -> {{19, 10}, {7, 7}}]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
IgnoreSpellCheck -> True,
ExpressionUUID -> "0cd90cb1-d678-4d30-91c9-ccede97532ac"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[546, 20, 222, 4, 68, "Title"],
Cell[771, 26, 219, 3, 34, "Subtitle"],
Cell[993, 31, 218, 3, 28, "Subsubtitle"],
Cell[1214, 36, 2688, 59, 252, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[3927, 99, 257, 5, 41, "Section"],
Cell[4187, 106, 777, 19, 52, "Input",
 InitializationCell->True],
Cell[4967, 127, 196, 4, 39, "Subsection"]
}, Open  ]],
Cell[5178, 134, 1194, 20, 232, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[6397, 158, 356, 6, 29, "Subsubsection"],
Cell[6756, 166, 1902, 53, 212, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[8695, 224, 467, 9, 29, "Subsubsection"],
Cell[9165, 235, 445, 10, 31, "Input",
 InitializationCell->True],
Cell[9613, 247, 1018, 18, 31, "Input",
 InitializationCell->True],
Cell[10634, 267, 564, 12, 92, "Input",
 InitializationCell->True],
Cell[11201, 281, 385, 9, 72, "Input",
 InitializationCell->True],
Cell[11589, 292, 500, 10, 92, "Input",
 InitializationCell->True],
Cell[12092, 304, 1095, 18, 52, "Input",
 InitializationCell->True],
Cell[13190, 324, 1697, 27, 92, "Input",
 Evaluatable->True,
 InitializationCell->True],
Cell[14890, 353, 1468, 25, 92, "Input",
 Evaluatable->True,
 InitializationCell->True],
Cell[16361, 380, 1020, 18, 31, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[17418, 403, 293, 5, 29, "Subsubsection"],
Cell[17714, 410, 231, 4, 31, "Input"],
Cell[17948, 416, 937, 23, 192, "Input",
 PageBreakAbove->False,
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[18888, 441, 280, 7, 31, "Input",
 InitializationCell->True],
Cell[19171, 450, 549, 11, 112, "Input",
 InitializationCell->True],
Cell[19723, 463, 1009, 17, 212, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[20735, 482, 549, 11, 112, "Input",
 InitializationCell->True],
Cell[21287, 495, 873, 15, 232, "Input",
 InitializationCell->True],
Cell[22163, 512, 1252, 21, 332, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[23418, 535, 1057, 18, 52, "Input",
 InitializationCell->True],
Cell[24478, 555, 1279, 23, 112, "Input",
 InitializationCell->True],
Cell[25760, 580, 1036, 18, 52, "Input",
 InitializationCell->True],
Cell[26799, 600, 422, 9, 92, "Input"],
Cell[27224, 611, 314, 8, 31, "Input",
 InitializationCell->True],
Cell[27541, 621, 917, 17, 212, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[28461, 640, 524, 11, 52, "Input",
 InitializationCell->True],
Cell[28988, 653, 782, 15, 192, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[29773, 670, 1093, 19, 232, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[30869, 691, 951, 16, 272, "Input",
 InitializationCell->True],
Cell[31823, 709, 942, 17, 272, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[32768, 728, 1468, 23, 92, "Input",
 InitializationCell->True],
Cell[34239, 753, 1296, 21, 52, "Input",
 InitializationCell->True],
Cell[35538, 776, 1120, 19, 292, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[36695, 800, 351, 6, 29, "Subsubsection"],
Cell[37049, 808, 259, 5, 31, "Input"],
Cell[37311, 815, 5320, 114, 372, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[42668, 934, 189, 3, 34, "Subsection"],
Cell[42860, 939, 3878, 77, 229, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[46753, 1019, 1677, 52, 229, "Input",
 InitializationCell->True],
Cell[48433, 1073, 4365, 109, 371, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[52801, 1184, 5200, 147, 371, "Input",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[CellGroupData[{
Cell[58026, 1335, 303, 6, 39, "Subsection",
 PageBreakWithin->True],
Cell[58332, 1343, 237, 6, 31, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[CellGroupData[{
Cell[58594, 1353, 203, 4, 37, "Subsubsection",
 PageBreakWithin->True],
Cell[58800, 1359, 7719, 208, 932, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[66522, 1569, 1280, 36, 132, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[67805, 1607, 3089, 80, 252, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[70931, 1692, 220, 4, 32, "Subsubsection",
 PageBreakWithin->True],
Cell[71154, 1698, 2902, 81, 252, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[74059, 1781, 7569, 248, 972, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[81631, 2031, 2820, 64, 232, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[84488, 2100, 204, 3, 37, "Subsubsection",
 PageBreakWithin->True],
Cell[84695, 2105, 9199, 225, 646, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[93931, 2335, 274, 4, 37, "Subsubsection",
 PageBreakWithin->True],
Cell[CellGroupData[{
Cell[94230, 2343, 1129, 29, 47, "Text",
 PageBreakWithin->True],
Cell[95362, 2374, 4879, 134, 392, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[100278, 2513, 1193, 30, 134, "Text",
 PageBreakWithin->True],
Cell[101474, 2545, 9886, 265, 855, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[111387, 2814, 1023, 28, 106, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[CellGroupData[{
Cell[112435, 2846, 268, 4, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[CellGroupData[{
Cell[112728, 2854, 1013, 23, 132, "Text",
 PageBreakWithin->True],
Cell[113744, 2879, 12106, 325, 826, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[125887, 3209, 893, 22, 112, "Text",
 PageBreakWithin->True],
Cell[126783, 3233, 8835, 233, 674, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135667, 3472, 258, 5, 32, "Subsubsection",
 PageBreakWithin->True],
Cell[135928, 3479, 1097, 22, 292, "Text",
 PageBreakWithin->True],
Cell[137028, 3503, 23099, 587, 2013, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[160164, 4095, 286, 5, 31, "Subsubsection",
 PageBreakWithin->True],
Cell[160453, 4102, 2484, 39, 192, "Text",
 PageBreakWithin->True],
Cell[162940, 4143, 12730, 330, 1126, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[175707, 4478, 208, 3, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[175918, 4483, 708, 19, 53, "Text",
 PageBreakWithin->True],
Cell[176629, 4504, 3110, 84, 356, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[179742, 4590, 1090, 31, 60, "Text",
 PageBreakWithin->True],
Cell[180835, 4623, 1382, 35, 126, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[182254, 4663, 302, 6, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[CellGroupData[{
Cell[182581, 4673, 679, 13, 111, "Text",
 PageBreakWithin->True],
Cell[183263, 4688, 6606, 176, 607, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[189906, 4869, 1058, 17, 71, "Text",
 PageBreakWithin->True],
Cell[190967, 4888, 6608, 176, 607, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[197624, 5070, 1351, 45, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[198978, 5117, 1335, 28, 171, "Text",
 PageBreakWithin->True],
Cell[200316, 5147, 4701, 119, 509, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[205054, 5271, 480, 7, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[205537, 5280, 11827, 372, 1115, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[217401, 5657, 341, 6, 30, "Subsubsection",
 PageBreakWithin->True],
Cell[CellGroupData[{
Cell[217767, 5667, 713, 11, 31, "Text",
 PageBreakWithin->True],
Cell[218483, 5680, 8274, 206, 572, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[226794, 5891, 815, 15, 192, "Text",
 PageBreakWithin->True],
Cell[227612, 5908, 6970, 184, 781, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[234619, 6097, 1181, 21, 291, "Text",
 PageBreakWithin->True],
Cell[235803, 6120, 13756, 351, 1261, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[249596, 6476, 966, 18, 211, "Text",
 PageBreakWithin->True],
Cell[250565, 6496, 14551, 367, 1184, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[265153, 6868, 1039, 22, 311, "Text",
 PageBreakWithin->True],
Cell[266195, 6892, 24110, 602, 1995, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[290354, 7500, 374, 7, 30, "Subsubsection",
 PageBreakWithin->True],
Cell[290731, 7509, 976, 21, 311, "Text",
 PageBreakWithin->True],
Cell[291710, 7532, 25385, 632, 2302, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[317132, 8169, 276, 5, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[317411, 8176, 358, 6, 31, "Text",
 PageBreakWithin->True],
Cell[317772, 8184, 1960, 49, 178, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[319735, 8235, 1371, 23, 132, "Text",
 PageBreakWithin->True],
Cell[321109, 8260, 14588, 388, 1115, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[335734, 8653, 261, 5, 36, "Subsubsection",
 PageBreakWithin->True],
Cell[CellGroupData[{
Cell[336020, 8662, 987, 17, 111, "Text",
 PageBreakWithin->True],
Cell[337010, 8681, 3965, 116, 495, "Input",
 PageBreakWithin->True,
 InitializationCell->True],
Cell[340978, 8799, 19964, 399, 745, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[360979, 9203, 567, 12, 152, "Text",
 PageBreakWithin->True],
Cell[361549, 9217, 5170, 135, 548, "Input",
 PageBreakWithin->True,
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[366780, 9359, 394, 6, 39, "Subsection",
 PageBreakAbove->False],
Cell[367177, 9367, 356, 8, 47, "Input",
 PageBreakBelow->False,
 InitializationCell->True]
}, Open  ]],
Cell[367548, 9378, 331, 6, 41, "Section",
 PageBreakAbove->False],
Cell[367882, 9386, 415, 9, 41, "Input",
 PageBreakAbove->False,
 InitializationCell->True],
Cell[368300, 9397, 173, 3, 41, "Section"],
Cell[368476, 9402, 3444, 74, 286, "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic],
Cell[371923, 9478, 229, 4, 41, "Section"],
Cell[CellGroupData[{
Cell[372177, 9486, 236, 4, 25, "Input"],
Cell[372416, 9492, 907, 15, 92, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[373360, 9512, 247, 4, 31, "Input"],
Cell[373610, 9518, 1799, 29, 152, "Output"]
}, Open  ]],
Cell[375424, 9550, 296, 8, 31, "Input"],
Cell[375723, 9560, 5751, 89, 412, "Output"]
}
]
*)

