(* ::Package:: *)

(* :Context: Crystallica` *)
(* :Author: Bianca Eifert and Christian Heiliger, Theoretical Solid State Physics, Institute for Theoretical Physics, Justus Liebig University Giessen, Germany *)
(* :Summary: The Crystallica package contains manipulation and plot functions for crystal and molecular structures. *)
(* :Copyright: Copyright (c) 2016 Bianca Eifert and Christian Heiliger, distributed under the MIT license *)
(* :Package Version: 1.0.0 *)
(* :Mathematica Version: 10.0 *)


If[TrueQ[$VersionNumber<10],Print["Sorry, Crystallica only works with version 10+ of the Wolfram Language."];Abort[]];


BeginPackage["Crystallica`"];


(*auxiliary: *)
$CrystallicaVersion::usage="$CrystallicaVersion gives the version number of the Crystallica package.";
$CrystallicaDebugQ::usage="Setting $CrystallicaDebugQ=True results in debugging messages being printed during evaluations.";


(*functions: *)
CrystalChange::usage="CrystalChange[lattvec,coord,conf] has options to manipulate a crystal structure.";
CrystalPlot::usage="CrystalPlot[lattvec,coord,conf] plots a crystal structure.";


(*shared options of CrystalChange and CrystalPlot: *)
Acell::usage="Acell is an option of CrystalChange and CrystalPlot which determines the output format of lattice vectors.";
AddQ::usage="AddQ is an option of CrystalChange and CrystalPlot which determines whether periodically duplicate atoms are added at the cell edges.";
CenterAtOriginQ::usage="CenterAtOriginQ is an option of CrystalChange and CrystalPlot which moves the center of the cell to the origin.";
MoveOrigin::usage="MoveOrigin is an option of CrystalChange and CrystalPlot which changes the origin of the cell, but not its size or shape.";
NewbasisQ::usage="NewbasisQ is an option of CrystalChange and CrystalPlot which determines whether atom coordinates are projected into the supercell.";
Reshape::usage="Reshape is an option of CrystalChange and CrystalPlot which builds supercells that are not simple periodic repetitions.";
RetractQ::usage="RetractQ is an option of CrystalChange and CrystalPlot which determines whether atoms are to be pulled back into the unit cell if they lie outside of it.";
SortQ::usage="SortQ is an option of CrystalChange and CrystalPlot which states whether atoms are to be sorted by type.";
Sysdim::usage="Sysdim is an option of CrystalChange and CrystalPlot which states the periodic repetition of the unit cell.";


(*exclusive options of CrystalPlot: *)
AtomCol::usage="AtomCol is an option of CrystalPlot which provides a list of atom colours.";
AtomFunction::usage="AtomFunction is an option of CrystalPlot that allows you to use arbitrary Graphics3D objects as atoms.";
AtomRad::usage="AtomRad is an option of CrystalPlot which provides a list of atom radii.";
BondCol::usage="BondCol is an option of CrystalPlot which determines the colour of interatomic bonds.";
BondDist::usage="BondDist is an option of CrystalPlot which determines the maximum length of interatomic bonds.";
BondsExtendQ::usage="BondsExtendQ is an option of CrystalPlot which adds bonds to atoms outside the plot range.";
BondsFlatQ::usage="BondsFlatQ is an option of CrystalPlot that replaces the regular tube bonds with flat lines if desired.";
BondRad::usage="BondRad is an option of CrystalPlot which determines the thickenss of interatomic bonds.";
BondRadScaledQ::usage="BondRadScaledQ is an option of CrystalPlot which determines whether bond radii are scaled by bond length.";
BondStyle::usage="BondStyle is an option of CrystalPlot which determines the layout of interatomic bonds.";
ButtonQ::usage="ButtonQ is an option of CrystalPlot which states whether to show the \"Paste supercell data\" button.";
CellLineCol::usage="CellLineCol is an option of CrystalPlot which determines the colour of the cell outlines and arrows.";
CellLineRad::usage="CellLineRad is an option of CrystalPlot which determines the thickness of the cell outlines and arrows.";
CellLineStyle::usage="CellLineStyle is an option of CrystalPlot which determines the layout of the cell outlines and arrows.";
CellLinesAdd::usage="CellLinesAdd is an option of CrystalPlot which allows the addition of arbitrary additional cell outlines to the plot.";
CellLinesFlatQ::usage="CellLinesFlatQ is an option of CrystalPlot that replaces the regular tube cell outlines and arrows with flat lines if desired.";
ForceBonds::usage="ForceBonds is an option of CrystalPlot giving pairs of atoms to connect with bonds.";
ForceNoBonds::usage="ForceNoBonds is an option of CrystalPlot giving pairs of atoms or atom types to never connect with bonds.";
LatticePlanes::usage="LatticePlanes is an option of CrystalPlot which gives a list of lattice planes to include in the plot.";
PolyMode::usage="PolyMode[cornercount] is an option of CrystalPlot that defines the general mode of coordination polyhedra.";
PolyStyle::usage="PolyStyle[cornercount] is an option of CrystalPlot that defines the layout of coordination polyhedra.";
Pseudo3DQ::usage="Pseudo3DQ is an option of CrystalPlot which determines whether 2D structures are plotted in pseudo-3D or in true 2D.";


Begin["`Private`"];


$CrystallicaVersion=1.;
debug:=TrueQ[$CrystallicaDebugQ];


(*get code from all files in the PackageFiles directory (separate files are used to make it easier to find stuff);
they all inherit the context Crystallica`Private`, so that all files together form the actual package;
messages and option defaults can be found in the file of their respective parent function*)
Get/@FileNames["*.m",FileNameJoin[{DirectoryName[$InputFileName],"PackageFiles"}]];


End[];
EndPackage[];
