(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     28643,        863]
NotebookOptionsPosition[     26053,        780]
NotebookOutlinePosition[     27244,        816]
CellTagsIndexPosition[     27159,        811]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "AtomFunction (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"AtomFunction is an option of CrystalPlot that allows you to \
use arbitrary Graphics3D objects as atoms.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3576303277-8290120"],

Cell[TextData[{
 "AtomFunction is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other atom-related options are ",
 ButtonBox["AtomCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomCol"],
 " and ",
 ButtonBox["AtomRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomRad"],
 "."
}], "Item"],

Cell["\<\
AtomFunction gives a Graphics3D object as a function of its position and \
radius. This object is then used for all atoms. The explicit values of the \
position, radius etc. for each atom are inherited from the crystal structure \
and the other layout options.\
\>", "Item"],

Cell["\<\
AtomFunction can have more arguments than just atom position and radius. Slot \
3 is filled with the atom colour, slot 4 denotes the type of the atom \
(integer atom type as supplied in the input structure), and slot 5 is the \
atom index (integer running over all atoms as displayed on the tooltip).\
\>", "Item"],

Cell["Default: (Ball[#1,#2]&)", "Item"],

Cell["\<\
Please be aware that if you turn your atoms into buttons of any sort (e.g. \
with FlipView), you can still click and rotate the image, but only if you \
click in a place where no atom is displayed. This can be cumbersome for \
larger structures with many atoms.\
\>", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Use transparent cubes as atoms; the radius and colour are inherited from the \
other options:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".4", ",", ".4", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".8", ",", ".8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Opacity", "[", ".7", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{
          RowBox[{"#1", "-", 
           RowBox[{".5", "*", "#2"}]}], ",", 
          RowBox[{"#1", "+", 
           RowBox[{".5", "*", "#2"}]}]}], "]"}]}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"AtomRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".4", ",", "1.2", ",", ".7"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {0, 4, 0}, {0, 0, 0}}, {{0, 0,
       4}, {4, 0, 4}, {4, 4, 4}, {0, 4, 4}, {0, 0, 4}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{4, 0, 0}, {4, 0, 4}}, {{4, 4, 0}, {4, 
      4, 4}}, {{0, 4, 0}, {0, 4, 4}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {3.4203449301524227`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
       3.4203449301524227`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
       3.4203449301524227`}, {0, 0, 4}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.7], EdgeForm[
      Thickness[Large]], CuboidBox[{-0.2, -0.2, -0.2}, {0.2, 0.2, 0.2}]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.7], EdgeForm[
      Thickness[Large]], CuboidBox[{1., 1., 1.}, {2.2, 2.2, 2.2}]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Opacity[0.7], EdgeForm[
      Thickness[Large]], 
      CuboidBox[{2.85, 2.85, 2.85}, {3.5500000000000003`, 3.5500000000000003`,
        3.5500000000000003`}]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Ellipsoid atoms:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".4", ",", ".4", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".8", ",", ".8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Scale", "[", 
       RowBox[{
        RowBox[{"Sphere", "[", 
         RowBox[{"#1", ",", "#2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", ".5"}], "}"}]}], "]"}], "&"}], ")"}]}], 
   ",", 
   RowBox[{"AtomRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".4", ",", "1.2", ",", ".7"}], "}"}]}], ",", 
   RowBox[{"AtomCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Goldenrod\>\"", ",", "\"\<TerreVerte\>\"", ",", 
      "\"\<RoseMadder\>\""}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {0, 4, 0}, {0, 0, 0}}, {{0, 0,
       4}, {4, 0, 4}, {4, 4, 4}, {0, 4, 4}, {0, 0, 4}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{4, 0, 0}, {4, 0, 4}}, {{4, 4, 0}, {4, 
      4, 4}}, {{0, 4, 0}, {0, 4, 4}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {3.4203449301524227`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
       3.4203449301524227`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
       3.4203449301524227`}, {0, 0, 4}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.8549, 0.647099, 0.125507], 
      GeometricTransformation3DBox[
       SphereBox[{0, 0, 0}, 0.4], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
        0.5}}, Center}]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.219993, 0.370006, 0.059999], 
      GeometricTransformation3DBox[
       SphereBox[{1.6, 1.6, 1.6}, 1.2], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0.,
         0.5}}, Center}]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.889996, 0.209998, 0.219993], 
      GeometricTransformation3DBox[
       SphereBox[{3.2, 3.2, 3.2}, 0.7], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0.,
         0.5}}, Center}]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Atoms that display their cartesian coordinates on the tooltip:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"Sphere", "[", 
         RowBox[{"#", ",", "#2"}], "]"}], ",", "#"}], "]"}], "&"}], ")"}]}]}],
   "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[
       TooltipBox[SphereBox[{0, 0, 0}, 0.5],
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]],
       Annotation[#, {0, 0, 0}, "Tooltip"]& ]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[
       TooltipBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
        RowBox[{"{", 
          RowBox[{"1.5`", ",", "1.5`", ",", "1.5`"}], "}"}]],
       Annotation[#, {1.5, 1.5, 1.5}, "Tooltip"]& ]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  ImageSize->{253., Automatic},
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Create atoms that switch between their original colour and a lighter value \
whenever they are clicked:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Firebrick\>\"", ",", "\"\<DarkGreen\>\"", ",", "\"\<Indigo\>\""}], 
     "}"}]}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"FlipView", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#3", ",", 
           RowBox[{"Sphere", "[", 
            RowBox[{"#", ",", "#2"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Lighter", "[", "#3", "]"}], ",", 
           RowBox[{"Sphere", "[", 
            RowBox[{"#", ",", "#2"}], "]"}]}], "}"}]}], "}"}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {2, 2, 0}, {4, 2, 2}, {2, 0, 2}, {0, 0, 0}}, {{0, 2,
       2}, {2, 4, 2}, {4, 4, 4}, {2, 2, 4}, {0, 2, 2}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 2, 2}}, {{2, 2, 0}, {2, 4, 2}}, {{4, 2, 2}, {4, 
      4, 4}}, {{2, 0, 2}, {2, 2, 4}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {1.6553350333449308`, 1.6553350333449308`, 0.}, {
       1.6553350333449308`, 1.6553350333449308`, 0.}, {2, 2, 0}}, {
      0.021, 0.021, 0.12185746757961738`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {1.6553350333449308`, 0., 1.6553350333449308`}, {
       1.6553350333449308`, 0., 1.6553350333449308`}, {2, 0, 2}}, {
      0.021, 0.021, 0.12185746757961738`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 1.6553350333449308`, 1.6553350333449308`}, {0., 
       1.6553350333449308`, 1.6553350333449308`}, {0, 2, 2}}, {
      0.021, 0.021, 0.12185746757961738`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      DynamicModuleBox[{System`Dump`boxes$$ = {{
         RGBColor[0.698004, 0.133305, 0.133305], 
         SphereBox[{0, 0, 0}, 0.5]}, {
         RGBColor[0.7986693333333333, 0.4222033333333333, 0.4222033333333333], 
         SphereBox[{0, 0, 0}, 0.5]}}, System`Dump`index$$ = 1, 
       System`Dump`length$$ = 2}, 
       TagBox[
        DynamicBox[FEPrivate`Part[System`Dump`boxes$$, System`Dump`index$$],
         ImageSizeCache->{{45.19820146942867, 102.88493966008126`}, {
          46.489800671558726`, 110.84648142877491`}}],
        EventHandlerTag[{
         "MouseClicked" :> FEPrivate`Switch[System`Dump`index$$, 1, 
            FEPrivate`Set[System`Dump`index$$, 2], 2, 
            FEPrivate`Set[System`Dump`index$$, 1]], Method -> "Preemptive", 
          PassEventsDown -> Automatic, PassEventsUp -> True}]],
       DynamicModuleValues:>{}]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.392193, 0.], 
      DynamicModuleBox[{System`Dump`boxes$$ = {{
         RGBColor[0., 0.392193, 0.], 
         SphereBox[{2., 2., 2.}, 0.5]}, {
         RGBColor[0.3333333333333333, 0.5947953333333333, 0.3333333333333333], 
         SphereBox[{2., 2., 2.}, 0.5]}}, System`Dump`index$$ = 1, 
       System`Dump`length$$ = 2}, 
       TagBox[
        DynamicBox[FEPrivate`Part[System`Dump`boxes$$, System`Dump`index$$],
         ImageSizeCache->{{151.80726875821333`, 
          206.67804356901883`}, {-34.0430881368205, 29.95527440466043}}],
        EventHandlerTag[{
         "MouseClicked" :> FEPrivate`Switch[System`Dump`index$$, 1, 
            FEPrivate`Set[System`Dump`index$$, 2], 2, 
            FEPrivate`Set[System`Dump`index$$, 1]], Method -> "Preemptive", 
          PassEventsDown -> Automatic, PassEventsUp -> True}]],
       DynamicModuleValues:>{}]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.03, 0.179998, 0.329997], 
      DynamicModuleBox[{System`Dump`boxes$$ = {{
         RGBColor[0.03, 0.179998, 0.329997], 
         SphereBox[{4, 4, 4}, 0.5]}, {
         RGBColor[
         0.3533333333333333, 0.45333199999999996`, 0.5533313333333333], 
         SphereBox[{4, 4, 4}, 0.5]}}, System`Dump`index$$ = 1, 
       System`Dump`length$$ = 2}, 
       TagBox[
        DynamicBox[FEPrivate`Part[System`Dump`boxes$$, System`Dump`index$$],
         ImageSizeCache->{{262.2931200363429, 
          319.6526665006816}, {-119.51618894636687`, -56.04615839862524}}],
        EventHandlerTag[{
         "MouseClicked" :> FEPrivate`Switch[System`Dump`index$$, 1, 
            FEPrivate`Set[System`Dump`index$$, 2], 2, 
            FEPrivate`Set[System`Dump`index$$, 1]], Method -> "Preemptive", 
          PassEventsDown -> Automatic, PassEventsUp -> True}]],
       DynamicModuleValues:>{}]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Use normal spherical atoms, except for atoms of type 2 (compare to example \
below):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#4", "\[Equal]", "2"}], ",", 
        RowBox[{"Scale", "[", 
         RowBox[{
          RowBox[{"Sphere", "[", 
           RowBox[{"#1", ",", "#2"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", ".5"}], "}"}]}], "]"}], ",", 
        RowBox[{"Sphere", "[", 
         RowBox[{"#1", ",", "#2"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {0, 4, 0}, {0, 0, 0}}, {{0, 0,
       4}, {4, 0, 4}, {4, 4, 4}, {0, 4, 4}, {0, 0, 4}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{4, 0, 0}, {4, 0, 4}}, {{4, 4, 0}, {4, 
      4, 4}}, {{0, 4, 0}, {0, 4, 4}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {3.4203449301524227`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
       3.4203449301524227`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
       3.4203449301524227`}, {0, 0, 4}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], SphereBox[{0, 0, 0}, 1]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      GeometricTransformation3DBox[
       SphereBox[{2., 2., 2.}, 1], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
        0.5}}, Center}]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      GeometricTransformation3DBox[
       SphereBox[{4, 4, 4}, 1], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 0.5}}, 
        Center}]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Use normal spherical atoms, except for atom number 2 (compare to example \
above):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#5", "\[Equal]", "2"}], ",", 
        RowBox[{"Scale", "[", 
         RowBox[{
          RowBox[{"Sphere", "[", 
           RowBox[{"#1", ",", "#2"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", ".5"}], "}"}]}], "]"}], ",", 
        RowBox[{"Sphere", "[", 
         RowBox[{"#1", ",", "#2"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {0, 4, 0}, {0, 0, 0}}, {{0, 0,
       4}, {4, 0, 4}, {4, 4, 4}, {0, 4, 4}, {0, 0, 4}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{4, 0, 0}, {4, 0, 4}}, {{4, 4, 0}, {4, 
      4, 4}}, {{0, 4, 0}, {0, 4, 4}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {3.4203449301524227`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
       3.4203449301524227`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
       3.4203449301524227`}, {0, 0, 4}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], SphereBox[{0, 0, 0}, 1]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      GeometricTransformation3DBox[
       SphereBox[{2., 2., 2.}, 1], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
        0.5}}, Center}]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], SphereBox[{4, 4, 4}, 1]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Plot atoms with the atom index printed on top:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".4", ",", ".4", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".8", ",", ".8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", "#5", "]"}], ",", "Bold", ",", "16"}], 
           "]"}], ",", "#"}], "]"}], ",", "#3", ",", 
        RowBox[{"Sphere", "[", 
         RowBox[{"#", ",", "#2"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {0, 4, 0}, {0, 0, 0}}, {{0, 0,
       4}, {4, 0, 4}, {4, 4, 4}, {0, 4, 4}, {0, 0, 4}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{4, 0, 0}, {4, 0, 4}}, {{4, 4, 0}, {4, 
      4, 4}}, {{0, 4, 0}, {0, 4, 4}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {3.4203449301524227`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
       3.4203449301524227`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
       3.4203449301524227`}, {0, 0, 4}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[{
      {GrayLevel[0], Text3DBox[
        StyleBox["\<\"1\"\>",
         StripOnInput->False,
         FontSize->16,
         FontWeight->Bold], {0, 0, 0}]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], SphereBox[{0, 0, 0}, 0.5]}},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[{
      {GrayLevel[0], Text3DBox[
        StyleBox["\<\"2\"\>",
         StripOnInput->False,
         FontSize->16,
         FontWeight->Bold], {1.6, 1.6, 1.6}]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       SphereBox[{1.6, 1.6, 1.6}, 0.5]}},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[{
      {GrayLevel[0], Text3DBox[
        StyleBox["\<\"3\"\>",
         StripOnInput->False,
         FontSize->16,
         FontWeight->Bold], {3.2, 3.2, 3.2}]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       SphereBox[{3.2, 3.2, 3.2}, 0.5]}},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "AtomFunction is an option of CrystalPlot that allows you to use \
arbitrary Graphics3D objects as atoms.", "synonyms" -> {}, "title" -> 
    "AtomFunction", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/AtomFunction"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3576303277-8290120"->{
  Cell[754, 30, 210, 4, 40, "Print",
   CellTags->"Info3576303277-8290120"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3576303277-8290120", 27058, 805}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 172, 6, 70, "Section"],
Cell[754, 30, 210, 4, 40, "Print",
 CellTags->"Info3576303277-8290120"],
Cell[967, 36, 398, 14, 29, "Item"],
Cell[1368, 52, 284, 5, 45, "Item"],
Cell[1655, 59, 324, 5, 45, "Item"],
Cell[1982, 66, 39, 0, 29, "Item"],
Cell[2024, 68, 285, 5, 45, "Item"],
Cell[CellGroupData[{
Cell[2334, 77, 30, 0, 49, "Subsection"],
Cell[2367, 79, 33, 0, 30, "Text"],
Cell[2403, 81, 102, 2, 31, "Input"],
Cell[2508, 85, 117, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[2650, 92, 1243, 37, 52, "Input"],
Cell[3896, 131, 1723, 44, 375, "Output"]
}, Open  ]],
Cell[5634, 178, 32, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[5691, 182, 1270, 39, 52, "Input"],
Cell[6964, 223, 1793, 48, 375, "Output"]
}, Open  ]],
Cell[8772, 274, 86, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[8883, 280, 833, 27, 31, "Input"],
Cell[9719, 309, 1670, 45, 268, "Output"]
}, Open  ]],
Cell[11404, 357, 127, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[11556, 364, 1215, 37, 52, "Input"],
Cell[12774, 403, 4043, 89, 375, "Output"]
}, Open  ]],
Cell[16832, 495, 108, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[16965, 502, 1219, 36, 52, "Input"],
Cell[18187, 540, 1671, 45, 375, "Output"]
}, Open  ]],
Cell[19873, 588, 106, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[20004, 595, 1219, 36, 52, "Input"],
Cell[21226, 633, 1562, 42, 375, "Output"]
}, Open  ]],
Cell[22803, 678, 62, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[22890, 682, 1144, 35, 31, "Input"],
Cell[24037, 719, 1976, 56, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
