(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8128,        281]
NotebookOptionsPosition[      6429,        226]
NotebookOutlinePosition[      7574,        261]
CellTagsIndexPosition[      7490,        256]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "AtomRad (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"AtomRad is an option of CrystalPlot which provides a list of \
atom radii.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828939-3834481"],

Cell[TextData[{
 "AtomRad is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other atom-related options are ",
 ButtonBox["AtomCol ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomCol"],
 "and ",
 ButtonBox["AtomFunction.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomFunction"]
}], "Item"],

Cell["\<\
AtomRad provides a list of atom radii with one entry per chemical species. If \
you want all radii to be the same, you can simply enter a single value.\
\>", "Item"],

Cell["Default: 0.5", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Various radii:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "*", "a"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Range", "[", "5", "]"}], ",", 
   RowBox[{"AtomRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".3", ",", ".7", ",", ".4", ",", ".6", ",", ".8"}], "}"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], 
     TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.3],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2, 0, 0}, 0.7],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{4, 0, 0}, 0.4],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.922526, 0.385626, 0.209179], 
      TagBox[SphereBox[{6, 0, 0}, 0.6],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.528488, 0.470624, 0.701351], 
      TagBox[SphereBox[{8, 0, 0}, 0.8],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Set the radii to 0 for a bonds-only plot style:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"Range", "[", "4", "]"}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 1., 0.}}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{0, 2, 0}, {0., 1., 0.}}, 0.15]}}, {
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{0, 2, 0}, {0., 2., 1.}}, 0.15]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{0, 2, 2}, {0., 2., 1.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2, 0, 0}, 0],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{0, 2, 0}, 0],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.922526, 0.385626, 0.209179], 
      TagBox[SphereBox[{0, 2, 2}, 0],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  ImageSize->{211., Automatic},
  Lighting->"Neutral",
  SphericalRegion->True,
  ViewPoint->{1.662683887152648, -0.7970235694426108, 2.83729373191355},
  ViewVertical->{-0.3955190092635551, 0.31177441634221087`, 
   0.9234826597505825}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "AtomRad is an option of CrystalPlot which provides a list of atom \
radii.", "synonyms" -> {}, "title" -> "AtomRad", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/AtomRad"}, "SearchTextTranslated" -> "", "LinkTrails" -> 
  ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828939-3834481"->{
  Cell[749, 30, 178, 3, 40, "Print",
   CellTags->"Info3569828939-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828939-3834481", 7389, 250}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 167, 6, 70, "Section"],
Cell[749, 30, 178, 3, 40, "Print",
 CellTags->"Info3569828939-3834481"],
Cell[930, 35, 398, 13, 29, "Item"],
Cell[1331, 50, 175, 3, 29, "Item"],
Cell[1509, 55, 28, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1562, 59, 30, 0, 49, "Subsection"],
Cell[1595, 61, 33, 0, 30, "Text"],
Cell[1631, 63, 102, 2, 31, "Input"],
Cell[1736, 67, 30, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[1791, 71, 492, 15, 31, "Input"],
Cell[2286, 88, 1837, 58, 375, "Output"]
}, Open  ]],
Cell[4138, 149, 63, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[4226, 153, 512, 15, 31, "Input"],
Cell[4741, 170, 1648, 51, 259, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
