(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26083,        811]
NotebookOptionsPosition[     24136,        749]
NotebookOutlinePosition[     25295,        784]
CellTagsIndexPosition[     25210,        779]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondCol (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondCol is an option of CrystalPlot which determines the \
colour of interatomic bonds.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828918-3834481"],

Cell[TextData[{
 "BondCol is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ", ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 ", ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ", ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell[TextData[{
 "BondCol gives the colour for interatomic bonds; members of ColorData[\
\[OpenCurlyDoubleQuote]Legacy\[CloseCurlyDoubleQuote]] and chemical species \
are recognized. BondCol does not take effect if ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 " is 1, 2, or a user-defined function."
}], "Item"],

Cell["\<\
If BondStyle is 0, BondCol can be a function, resulting in gradiented bonds.\
\>", "Item"],

Cell["\<\
If BondStyle is 5, BondCol is a function specifying the bond colour as a \
function of normalized bond length.\
\>", "Item"],

Cell["Default:Gray", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Differently coloured bonds:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"BondStyle", "\[Rule]", "0"}], ",", 
     RowBox[{"BondCol", "\[Rule]", "col"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"col", ",", 
     RowBox[{"{", 
      RowBox[{"Gray", ",", "\"\<Firebrick\>\"", ",", "\"\<Pd\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     {GrayLevel[0.5], TubeBox[{{0, 0, 0}, {2, 0, 0}}, 0.15]}, 
     {GrayLevel[0.5], TubeBox[{{2, 0, 0}, {4, 0, 0}}, 0.15]}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TubeBox[{{0, 0, 0}, {2, 0, 0}}, 0.15]}, 
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TubeBox[{{2, 0, 0}, {4, 0, 0}}, 0.15]}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     {RGBColor[0., 0.420615, 0.525231], 
      TubeBox[{{0, 0, 0}, {2, 0, 0}}, 0.15]}, 
     {RGBColor[0., 0.420615, 0.525231], 
      TubeBox[{{2, 0, 0}, {4, 0, 0}}, 0.15]}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Play with built-in colour functions to obtain differenty gradiented bonds:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AtomRad", "\[Rule]", "0"}], ",", 
     RowBox[{"BondStyle", "\[Rule]", "0"}], ",", 
     RowBox[{"BondCol", "\[Rule]", "colfu"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"colfu", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ColorData", "[", 
          RowBox[{"\"\<AvocadoColors\>\"", ",", "#"}], "]"}], "&"}], ")"}], 
       ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ColorData", "[", 
          RowBox[{"\"\<AvocadoColors\>\"", ",", 
           RowBox[{"1", "-", "#"}]}], "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ColorData", "[", 
          RowBox[{"\"\<AvocadoColors\>\"", ",", 
           RowBox[{"1", "-", 
            RowBox[{".5", "*", "#"}]}]}], "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ColorData", "[", 
          RowBox[{"\"\<AvocadoColors\>\"", ",", 
           RowBox[{".5", "-", 
            RowBox[{".5", "*", "#"}]}]}], "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ColorData", "[", 
          RowBox[{"\"\<AvocadoColors\>\"", ",", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"2", "*", "#"}], "-", "1"}], "]"}]}], "]"}], "&"}], 
        ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ColorData", "[", 
          RowBox[{"\"\<AvocadoColors\>\"", ",", 
           RowBox[{"1", "-", 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"2", "*", "#"}], "-", "1"}], "]"}]}]}], "]"}], "&"}], 
        ")"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.1771436, 0.02997024]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542872, 0.05994048]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.057865200000000054`, 0.49130860000000004`, 0.08169228]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.6050564, 0.8017382, 0.13840380000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.6050563999999998, 0.8017382, 0.1384038]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.44719119999999996`, 0.7434225999999999, 0.1235814]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.1735955999999999, 0.5882078, 0.09522563999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.05786519999999993, 0.49130859999999993`, 0.08169227999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.17714359999999996`, 0.029970239999999992`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.9367977999999999, 0.9536792, 0.2134918]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8103933999999999, 0.8922876, 0.1796534]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.683989, 0.830896, 0.145815]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.6050563999999998, 0.8017382, 0.1384038]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.5261237999999998, 0.7725804, 0.1309926]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.44719119999999996`, 0.7434225999999999, 0.1235814]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.3682586000000001, 0.7142648, 0.1161702]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.23146080000000002`, 0.6366574, 0.10199232]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.11573039999999998`, 0.5397582, 0.08845895999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.05786519999999999, 0.4913086, 0.08169227999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.442859, 0.0749256]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.26571539999999993`, 0.044955359999999986`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.17714359999999996`, 0.029970239999999992`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.08857179999999998, 0.014985119999999996`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.44719119999999996`, 0.7434225999999999, 0.1235814]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.1735955999999999, 0.5882078, 0.09522563999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542872000000003, 0.059940480000000046`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.17359560000000018`, 0.5882078000000002, 0.09522564000000001]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.7471911999999997, 0.8615917999999999, 0.16273419999999994`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.4471911999999998, 0.7434225999999999, 0.12358139999999998`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.1735955999999999, 0.5882078, 0.09522563999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The first of the gradient examples above can also be obtained by simply \
giving the name of the colour gradient:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "0"}], ",", 
   RowBox[{"BondStyle", "\[Rule]", "0"}], ",", 
   RowBox[{"BondCol", "\[Rule]", "\"\<AvocadoColors\>\""}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001, 
    0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
    1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 0.}},
     0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0., 0., 0.]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0., 0.1771436, 0.02997024]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0., 0.3542872, 0.05994048]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.057865200000000054`, 0.49130860000000004`, 0.08169228]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.289326, 0.685107, 0.108759]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6050564, 0.8017382, 0.13840380000000002`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[1., 0.984375, 0.230411]}}], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2, 0, 0}, 0],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 2}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "BondCol is an option of CrystalPlot which determines the colour of \
interatomic bonds.", "synonyms" -> {}, "title" -> "BondCol", "type" -> 
    "Symbol", "uri" -> "Crystallica/ref/BondCol"}, "SearchTextTranslated" -> 
  "", "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828918-3834481"->{
  Cell[749, 30, 191, 3, 40, "Print",
   CellTags->"Info3569828918-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828918-3834481", 25109, 773}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 167, 6, 70, "Section"],
Cell[749, 30, 191, 3, 40, "Print",
 CellTags->"Info3569828918-3834481"],
Cell[943, 35, 1035, 37, 29, "Item"],
Cell[1981, 74, 366, 8, 29, "Item"],
Cell[2350, 84, 100, 2, 29, "Item"],
Cell[2453, 88, 134, 3, 29, "Item"],
Cell[2590, 93, 28, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[2643, 97, 30, 0, 49, "Subsection"],
Cell[2676, 99, 33, 0, 30, "Text"],
Cell[2712, 101, 102, 2, 31, "Input"],
Cell[2817, 105, 43, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2885, 109, 744, 22, 31, "Input"],
Cell[3632, 133, 2790, 96, 197, "Output"]
}, Open  ]],
Cell[6437, 232, 98, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[6560, 238, 2020, 59, 72, "Input"],
Cell[8583, 299, 12847, 360, 197, "Output"]
}, Open  ]],
Cell[21445, 662, 137, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[21607, 669, 496, 14, 31, "Input"],
Cell[22106, 685, 1990, 59, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
