(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8088,        285]
NotebookOptionsPosition[      6332,        229]
NotebookOutlinePosition[      7529,        265]
CellTagsIndexPosition[      7445,        260]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondRadScaledQ",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondRadScaledQ is an option of CrystalPlot which determines \
whether bond radii are scaled by bond length.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3583481313-9829502"],

Cell[TextData[{
 "BondRadScaledQ is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ButtonBox[",",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 " ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ", ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell[TextData[{
 "If BondRadScaledQ is set to True, bond thickness is scaled based on bond \
length. The minimum and maximum thickness is specified by setting the ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 " option to a list of two radii."
}], "Item"],

Cell["Default:False", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Make shorter bonds thicker:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BondRadScaledQ", "\[Rule]", "True"}], ",", 
   RowBox[{"BondRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".2", ",", ".1"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.75, 0., 0.}}, 0.2]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.5, 0., 0.}, {0.75, 0., 0.}}, 0.2]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.5, 0., 0.}, {2.5, 0., 0.}}, 0.1]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{3.5, 0., 0.}, {2.5, 0., 0.}}, 0.1]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 0., 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{3.5, 0., 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
You can also make shorter bonds thinner instead. This is usually \
counterintuitive, because shorter bonds tend to be stronger.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BondRadScaledQ", "\[Rule]", "True"}], ",", 
   RowBox[{"BondRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".1", ",", ".2"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.75, 0., 0.}}, 0.1]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.5, 0., 0.}, {0.75, 0., 0.}}, 0.1]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.5, 0., 0.}, {2.5, 0., 0.}}, 0.2]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{3.5, 0., 0.}, {2.5, 0., 0.}}, 0.2]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 0., 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{3.5, 0., 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 2}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "BondRadScaledQ is an option of CrystalPlot which determines whether bond \
radii are scaled by bond length.", "synonyms" -> {}, "title" -> 
    "BondRadScaledQ", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/BondRadScaledQ"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3583481313-9829502"->{
  Cell[761, 31, 213, 4, 40, "Print",
   CellTags->"Info3583481313-9829502"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3583481313-9829502", 7344, 254}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 179, 7, 70, "Section"],
Cell[761, 31, 213, 4, 40, "Print",
 CellTags->"Info3583481313-9829502"],
Cell[977, 37, 1116, 40, 29, "Item"],
Cell[2096, 79, 304, 7, 29, "Item"],
Cell[2403, 88, 29, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[2457, 92, 30, 0, 49, "Subsection"],
Cell[2490, 94, 33, 0, 30, "Text"],
Cell[2526, 96, 102, 2, 31, "Input"],
Cell[2631, 100, 43, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2699, 104, 578, 17, 31, "Input"],
Cell[3280, 123, 1120, 36, 375, "Output"]
}, Open  ]],
Cell[4415, 162, 151, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[4591, 169, 578, 17, 31, "Input"],
Cell[5172, 188, 1120, 36, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
