(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    122187,       2695]
NotebookOptionsPosition[    119220,       2601]
NotebookOutlinePosition[    120387,       2636]
CellTagsIndexPosition[    120300,       2631]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondStyle (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondStyle is an option of CrystalPlot which determines the \
layout of interatomic bonds.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828956-3834481"],

Cell[TextData[{
 "BondStyle is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 " ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ", ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell[CellGroupData[{

Cell["\<\
BondStyle specifies the overall layout of bonds; it can have one of the \
following values:\
\>", "Item"],

Cell[CellGroupData[{

Cell["0 \[Dash] single colour or gradient", "Subitem"],

Cell["1 \[Dash] atom colours", "Subitem"],

Cell["2 \[Dash] gradient of atom colours", "Subitem"],

Cell["3 \[Dash] atom colours via intermediate colour", "Subitem"],

Cell["4 \[Dash] gradient of atom colours via intermediate colour", "Subitem"],

Cell["5 \[Dash] colour code by bond length", "Subitem"]
}, Open  ]]
}, Open  ]],

Cell["\<\
To disable bonds altogether, use BondStyle->False or BondStyle->None.\
\>", "Item"],

Cell[TextData[{
 "Intermediate colours for modes 3 and 4 are given with the ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 " option."
}], "Item"],

Cell["\<\
BondStyle can also be set to a customized function which describes the bond \
shape as a function of the coordinates of the bound atoms and the atom \
colours. (See examples.) Other bond layout options will be ignored in this \
case.\
\>", "Item"],

Cell["Default: 1", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Different styles of bonds:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"AtomCol", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<Au\>\"", ",", 
        RowBox[{"Darker", "[", "Red", "]"}], ",", 
        "\"\<ChromeOxideGreen\>\""}], "}"}]}], ",", 
     RowBox[{"BondRad", "\[Rule]", ".25"}], ",", 
     RowBox[{"BondStyle", "\[Rule]", "style"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"style", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[1., 0.819608, 0.137255], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.400006, 0.5, 0.080004], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     {GrayLevel[0.5], TubeBox[{{0, 0, 0}, {2, 0, 0}}, 0.25]}, 
     {GrayLevel[0.5], TubeBox[{{2, 0, 0}, {4, 0, 0}}, 0.25]}, 
     TagBox[
      TooltipBox[
       {RGBColor[1., 0.819608, 0.137255], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.400006, 0.5, 0.080004], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[1., 0.819608, 0.137255], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.25]}, 
      {RGBColor[
        NCache[
         Rational[2, 3], 0.6666666666666666], 0, 0], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.25]}}, {
      {RGBColor[
        NCache[
         Rational[2, 3], 0.6666666666666666], 0, 0], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.25]}, 
      {RGBColor[0.400006, 0.5, 0.080004], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.25]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[1., 0.819608, 0.137255], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.400006, 0.5, 0.080004], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, TubeBox[{{0, 0, 0}, {2, 0, 0}}, 0.25,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.819608, 0.137255]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
          Rational[2, 3], 0, 0]}}], TubeBox[{{2, 0, 0}, {4, 0, 0}}, 0.25,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
          Rational[2, 3], 0, 0]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.400006, 0.5, 0.080004]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[1., 0.819608, 0.137255], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.400006, 0.5, 0.080004], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}, {1., 0., 0.}, {2, 0, 0}}, 0.25,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.819608, 0.137255]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.75, 0.6598040000000001, 0.3186275]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.5833333333333333, 0.25, 0.25]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
          Rational[2, 3], 0, 0]}}], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}, {3., 0., 0.}, {4, 0, 0}}, 0.25,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
          Rational[2, 3], 0, 0]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.5833333333333333, 0.25, 0.25]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.450003, 0.5, 0.290002]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.400006, 0.5, 0.080004]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[1., 0.819608, 0.137255], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.400006, 0.5, 0.080004], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, TubeBox[{{0, 0, 0}, {1., 0., 0.}, {2, 0, 0}}, 0.25,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.819608, 0.137255]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         GrayLevel[0.5]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
          Rational[2, 3], 0, 0]}}], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}, {4, 0, 0}}, 0.25,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
          Rational[2, 3], 0, 0]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         GrayLevel[0.5]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.400006, 0.5, 0.080004]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[1., 0.819608, 0.137255], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.400006, 0.5, 0.080004], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Colour-code the bonds by their length; scaling between the minimum and \
maximum bond length is done automatically:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "3"}], ",", 
   RowBox[{"BondStyle", "\[Rule]", "5"}], ",", 
   RowBox[{"BondCol", "\[Rule]", "\"\<SolarColors\>\""}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {RGBColor[0.468742, 0., 0.0158236], 
    TubeBox[{{0., 0., 0.}, {1.5, 0., 0.}}, 0.15]}, 
   {RGBColor[1., 0.820127, 0.126955], 
    TubeBox[{{1.5, 0., 0.}, {4., 0., 0.}}, 0.15]}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 0., 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Play with built-in colour functions to obtain differently gradiented bonds:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AtomRad", "\[Rule]", "0"}], ",", 
     RowBox[{"BondStyle", "\[Rule]", "0"}], ",", 
     RowBox[{"BondCol", "\[Rule]", "colfu"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"colfu", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<AvocadoColors\>\"", "]"}], "[", "#", 
          "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<AvocadoColors\>\"", "]"}], "[", 
          RowBox[{"1", "-", "#"}], "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<AvocadoColors\>\"", "]"}], "[", 
          RowBox[{"1", "-", 
           RowBox[{".5", "*", "#"}]}], "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<AvocadoColors\>\"", "]"}], "[", 
          RowBox[{".5", "-", 
           RowBox[{".5", "*", "#"}]}], "]"}], "&"}], ")"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<AvocadoColors\>\"", "]"}], "[", 
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"2", "*", "#"}], "-", "1"}], "]"}], "]"}], "&"}], ")"}], 
       ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<AvocadoColors\>\"", "]"}], "[", 
          RowBox[{"1", "-", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"2", "*", "#"}], "-", "1"}], "]"}]}], "]"}], "&"}], 
        ")"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.1771436, 0.02997024]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542872, 0.05994048]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.057865200000000054`, 0.49130860000000004`, 0.08169228]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.6050564, 0.8017382, 0.13840380000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.6050563999999998, 0.8017382, 0.1384038]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.44719119999999996`, 0.7434225999999999, 0.1235814]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.1735955999999999, 0.5882078, 0.09522563999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.05786519999999993, 0.49130859999999993`, 0.08169227999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.17714359999999996`, 0.029970239999999992`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.9367977999999999, 0.9536792, 0.2134918]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.8103933999999999, 0.8922876, 0.1796534]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.683989, 0.830896, 0.145815]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.6050563999999998, 0.8017382, 0.1384038]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.5261237999999998, 0.7725804, 0.1309926]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.44719119999999996`, 0.7434225999999999, 0.1235814]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.3682586000000001, 0.7142648, 0.1161702]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.289326, 0.685107, 0.108759]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.23146080000000002`, 0.6366574, 0.10199232]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.11573039999999998`, 0.5397582, 0.08845895999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.05786519999999999, 0.4913086, 0.08169227999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.442859, 0.0749256]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.26571539999999993`, 0.044955359999999986`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.17714359999999996`, 0.029970239999999992`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.08857179999999998, 0.014985119999999996`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.44719119999999996`, 0.7434225999999999, 0.1235814]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.1735955999999999, 0.5882078, 0.09522563999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542872000000003, 0.059940480000000046`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.17359560000000018`, 0.5882078000000002, 0.09522564000000001]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, 
     TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001,
       0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
      1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 
      0.}}, 0.15,
      VertexColors->{{
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[1., 0.984375, 0.230411]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.7471911999999997, 0.8615917999999999, 0.16273419999999994`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[
         0.4471911999999998, 0.7434225999999999, 0.12358139999999998`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0.1735955999999999, 0.5882078, 0.09522563999999999]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0.3542871999999999, 0.059940479999999983`]}, {
         Specularity[
          GrayLevel[0.5], 100], 
         RGBColor[0., 0., 0.]}}], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The first of the gradient examples above can also be obtained by simply \
giving the name of the colour gradient:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "0"}], ",", 
   RowBox[{"BondStyle", "\[Rule]", "0"}], ",", 
   RowBox[{"BondCol", "\[Rule]", "\"\<AvocadoColors\>\""}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   TubeBox[{{0., 0., 0.}, {0.2, 0., 0.}, {0.4, 0., 0.}, {0.6000000000000001, 
    0., 0.}, {0.8, 0., 0.}, {1., 0., 0.}, {1.2000000000000002`, 0., 0.}, {
    1.4000000000000001`, 0., 0.}, {1.6, 0., 0.}, {1.8, 0., 0.}, {2., 0., 0.}},
     0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0., 0., 0.]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0., 0.1771436, 0.02997024]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0., 0.3542872, 0.05994048]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.057865200000000054`, 0.49130860000000004`, 0.08169228]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.17359560000000004`, 0.5882078000000001, 0.09522564]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.289326, 0.685107, 0.108759]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.4471912000000001, 0.7434226, 0.12358140000000001`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6050564, 0.8017382, 0.13840380000000002`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.7471912, 0.8615918, 0.16273420000000002`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.8735956, 0.9229834, 0.19657260000000001`]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[1., 0.984375, 0.230411]}}], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2, 0, 0}, 0],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Construct your own bond function: The argument \[OpenCurlyQuote]bonds\
\[CloseCurlyQuote] is the list of bonds (pairs of cartesian coordinates). \
Crystallica will calculate this bond list for you.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "4", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "6"}], ",", 
   RowBox[{"BondStyle", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "bonds", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Sphere", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"ii", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "-", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ",", ".15"}], 
             "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"ii", ",", "0", ",", "1", ",", 
              RowBox[{"1", "/", "9"}]}], "}"}]}], "]"}], "&"}], "/@", 
         "bonds"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {GrayLevel[
    0.5], {{SphereBox[{0, 0, 0}, 0.15], 
      SphereBox[NCache[{Rational[5, 9], 0, 0}, {0.5555555555555556, 0, 0}], 
       0.15], SphereBox[
       NCache[{Rational[10, 9], 0, 0}, {1.1111111111111112`, 0, 0}], 0.15], 
      SphereBox[NCache[{Rational[5, 3], 0, 0}, {1.6666666666666667`, 0, 0}], 
       0.15], SphereBox[
       NCache[{Rational[20, 9], 0, 0}, {2.2222222222222223`, 0, 0}], 0.15], 
      SphereBox[NCache[{Rational[25, 9], 0, 0}, {2.7777777777777777`, 0, 0}], 
       0.15], SphereBox[
       NCache[{Rational[10, 3], 0, 0}, {3.3333333333333335`, 0, 0}], 0.15], 
      SphereBox[NCache[{Rational[35, 9], 0, 0}, {3.888888888888889, 0, 0}], 
       0.15], SphereBox[
       NCache[{Rational[40, 9], 0, 0}, {4.444444444444445, 0, 0}], 0.15], 
      SphereBox[{5, 0, 0}, 0.15]}, {SphereBox[{0., 0., 0.}, 0.15], 
      SphereBox[{0.2777777777777778, 0.4444444444444444, 0.}, 0.15], 
      SphereBox[{0.5555555555555556, 0.8888888888888888, 0.}, 0.15], 
      SphereBox[{0.8333333333333333, 1.3333333333333333`, 0.}, 0.15], 
      SphereBox[{1.1111111111111112`, 1.7777777777777777`, 0.}, 0.15], 
      SphereBox[{1.3888888888888888`, 2.2222222222222223`, 0.}, 0.15], 
      SphereBox[{1.6666666666666665`, 2.6666666666666665`, 0.}, 0.15], 
      SphereBox[{1.9444444444444444`, 3.111111111111111, 0.}, 0.15], 
      SphereBox[{2.2222222222222223`, 3.5555555555555554`, 0.}, 0.15], 
      SphereBox[{2.5, 4., 0.}, 0.15]}, {SphereBox[{5., 0., 0.}, 0.15], 
      SphereBox[{4.722222222222222, 0.4444444444444444, 0.}, 0.15], 
      SphereBox[{4.444444444444445, 0.8888888888888888, 0.}, 0.15], 
      SphereBox[{4.166666666666667, 1.3333333333333333`, 0.}, 0.15], 
      SphereBox[{3.888888888888889, 1.7777777777777777`, 0.}, 0.15], 
      SphereBox[{3.611111111111111, 2.2222222222222223`, 0.}, 0.15], 
      SphereBox[{3.3333333333333335`, 2.6666666666666665`, 0.}, 0.15], 
      SphereBox[{3.0555555555555554`, 3.111111111111111, 0.}, 0.15], 
      SphereBox[{2.7777777777777777`, 3.5555555555555554`, 0.}, 0.15], 
      SphereBox[{2.5, 4., 0.}, 0.15]}}, 
    TagBox[
     TooltipBox[
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TagBox[SphereBox[{0, 0, 0}, 0.5],
        "Ball"]},
      "1"],
     Annotation[#, 1, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TagBox[SphereBox[{5, 0, 0}, 0.5],
        "Ball"]},
      "2"],
     Annotation[#, 2, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TagBox[SphereBox[{2.5, 4., 0.}, 0.5],
        "Ball"]},
      "3"],
     Annotation[#, 3, "Tooltip"]& ]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
The BondStyle function can have a second argument, named \
\[OpenCurlyQuote]partcol\[CloseCurlyQuote] in this example, where \
partcol[x,y] will be replaced by the colour of the atom located at the y end \
of bond x, so that y is 1 or 2, and x runs over all bonds.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "4", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "6"}], ",", 
   RowBox[{"BondStyle", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"bonds", ",", "partcol"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ii", "<", ".5"}], ",", 
              RowBox[{"partcol", "[", 
               RowBox[{"#", ",", "1"}], "]"}], ",", 
              RowBox[{"partcol", "[", 
               RowBox[{"#", ",", "2"}], "]"}]}], "]"}], ",", 
            RowBox[{"Sphere", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"bonds", "[", 
                RowBox[{"[", 
                 RowBox[{"#", ",", "1"}], "]"}], "]"}], "+", 
               RowBox[{"ii", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"bonds", "[", 
                   RowBox[{"[", 
                    RowBox[{"#", ",", "2"}], "]"}], "]"}], "-", 
                  RowBox[{"bonds", "[", 
                   RowBox[{"[", 
                    RowBox[{"#", ",", "1"}], "]"}], "]"}]}], ")"}]}]}], ",", 
              ".15"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "0", ",", "1", ",", 
            RowBox[{"1", "/", "9"}]}], "}"}]}], "]"}], "&"}], "/@", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "bonds", "]"}], "]"}]}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], SphereBox[{0, 0, 0}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[NCache[{Rational[5, 9], 0, 0}, {0.5555555555555556, 0, 0}], 
      0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[NCache[{Rational[10, 9], 0, 0}, {1.1111111111111112`, 0, 0}], 
      0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[NCache[{Rational[5, 3], 0, 0}, {1.6666666666666667`, 0, 0}], 
      0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[NCache[{Rational[20, 9], 0, 0}, {2.2222222222222223`, 0, 0}], 
      0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[NCache[{Rational[25, 9], 0, 0}, {2.7777777777777777`, 0, 0}], 
      0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[NCache[{Rational[10, 3], 0, 0}, {3.3333333333333335`, 0, 0}], 
      0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[NCache[{Rational[35, 9], 0, 0}, {3.888888888888889, 0, 0}], 
      0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[NCache[{Rational[40, 9], 0, 0}, {4.444444444444445, 0, 0}], 
      0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], SphereBox[{5, 0, 0}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], SphereBox[{0., 0., 0.}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[{0.2777777777777778, 0.4444444444444444, 0.}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[{0.5555555555555556, 0.8888888888888888, 0.}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[{0.8333333333333333, 1.3333333333333333`, 0.}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     SphereBox[{1.1111111111111112`, 1.7777777777777777`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{1.3888888888888888`, 2.2222222222222223`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{1.6666666666666665`, 2.6666666666666665`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{1.9444444444444444`, 3.111111111111111, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{2.2222222222222223`, 3.5555555555555554`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{2.5, 4., 0.}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], SphereBox[{5., 0., 0.}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[{4.722222222222222, 0.4444444444444444, 0.}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[{4.444444444444445, 0.8888888888888888, 0.}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[{4.166666666666667, 1.3333333333333333`, 0.}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     SphereBox[{3.888888888888889, 1.7777777777777777`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{3.611111111111111, 2.2222222222222223`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{3.3333333333333335`, 2.6666666666666665`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{3.0555555555555554`, 3.111111111111111, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     SphereBox[{2.7777777777777777`, 3.5555555555555554`, 0.}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], SphereBox[{2.5, 4., 0.}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{5, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{2.5, 4., 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
You can also construct more complex bond shapes, such as spirals to visualize \
phonons:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "4", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "6"}], ",", "\[IndentingNewLine]", 
   RowBox[{"BondStyle", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"bonds", ",", "partcol"}], "}"}], ",", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"spiral", ",", "points", ",", 
          RowBox[{"rad", "=", ".05"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"spiral", "[", "atoms_", "]"}], ":=", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"scale", "=", ".5"}], ",", 
              RowBox[{"dist", "=", 
               RowBox[{
                RowBox[{"atoms", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "-", 
                RowBox[{"atoms", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ",", 
              RowBox[{"curls", "=", "60"}], ",", "normal", ",", "rot", ",", 
              "scaled"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"normal", "=", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"scale", "*", 
                   RowBox[{"Cos", "[", "ii", "]"}]}], ",", 
                  RowBox[{"scale", "*", 
                   RowBox[{"Sin", "[", "ii", "]"}]}], ",", 
                  RowBox[{".1", "*", "ii"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"ii", ",", "0", ",", "curls", ",", 
                  RowBox[{"\[Pi]", "/", "10"}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"scaled", "=", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", 
                  RowBox[{"10", "*", 
                   RowBox[{
                    RowBox[{"Norm", "[", "dist", "]"}], "/", "curls"}], "*", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
               "normal"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"rot", "=", 
              RowBox[{"scaled", ".", 
               RowBox[{"Quiet", "[", 
                RowBox[{"RotationMatrix", "[", 
                 RowBox[{"{", 
                  RowBox[{"dist", ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], 
                "]"}]}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"atoms", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"#", "+", 
                  RowBox[{"atoms", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
                RowBox[{"(", 
                 RowBox[{"rot", "[", 
                  RowBox[{"[", 
                   RowBox[{"25", ";;", 
                    RowBox[{"-", "25"}]}], "]"}], "]"}], ")"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"atoms", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "]"}]}]}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"points", "=", 
          RowBox[{"spiral", "/@", "bonds"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"partcol", "[", 
              RowBox[{"#", ",", "1"}], "]"}], ",", 
             RowBox[{"Tube", "[", 
              RowBox[{"BSplineCurve", "[", 
               RowBox[{
                RowBox[{"points", "[", 
                 RowBox[{"[", 
                  RowBox[{"#", ",", 
                   RowBox[{";;", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"points", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], "]"}], "/", "2"}], 
                    "]"}]}]}], "]"}], "]"}], ",", "rad"}], "]"}], "]"}], ",", 
             RowBox[{"partcol", "[", 
              RowBox[{"#", ",", "2"}], "]"}], ",", 
             RowBox[{"Tube", "[", 
              RowBox[{"BSplineCurve", "[", 
               RowBox[{
                RowBox[{"points", "[", 
                 RowBox[{"[", 
                  RowBox[{"#", ",", 
                   RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"points", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], "]"}], "/", "2"}], "]"}], 
                    ";;"}]}], "]"}], "]"}], ",", "rad"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"Length", "[", "bonds", "]"}], "]"}]}]}]}], 
       "\[IndentingNewLine]", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBSplineCurveBox[{{0, 0, 0}, {0.6283185307179585, 
       0.47552825814757677`, -0.15450849718747373`}, {0.6544984694978735, 0.5,
        0.}, {0.6806784082777885, 0.47552825814757677`, 
       0.15450849718747373`}, {0.7068583470577035, 0.4045084971874737, 
       0.29389262614623657`}, {0.7330382858376182, 0.29389262614623657`, 
       0.4045084971874737}, {0.7592182246175332, 0.15450849718747373`, 
       0.47552825814757677`}, {0.7853981633974483, 0., 0.5}, {
       0.8115781021773633, -0.15450849718747373`, 0.47552825814757677`}, {
       0.8377580409572781, -0.29389262614623657`, 0.4045084971874737}, {
       0.8639379797371931, -0.4045084971874737, 0.29389262614623657`}, {
       0.8901179185171081, -0.47552825814757677`, 0.15450849718747373`}, {
       0.916297857297023, -0.5, 0.}, {
       0.9424777960769379, -0.47552825814757677`, -0.15450849718747373`}, {
       0.9686577348568529, -0.4045084971874737, -0.29389262614623657`}, {
       0.9948376736367677, -0.29389262614623657`, -0.4045084971874737}, {
       1.0210176124166825`, -0.15450849718747373`, -0.47552825814757677`}, {
       1.0471975511965976`, 0., -0.5}, {1.0733774899765125`, 
       0.15450849718747373`, -0.47552825814757677`}, {1.0995574287564276`, 
       0.29389262614623657`, -0.4045084971874737}, {1.1257373675363425`, 
       0.4045084971874737, -0.29389262614623657`}, {1.1519173063162575`, 
       0.47552825814757677`, -0.15450849718747373`}, {1.1780972450961724`, 
       0.5, 0.}, {1.204277183876087, 0.47552825814757677`, 
       0.15450849718747373`}, {1.2304571226560024`, 0.4045084971874737, 
       0.29389262614623657`}, {1.256637061435917, 0.29389262614623657`, 
       0.4045084971874737}, {1.2828170002158321`, 0.15450849718747373`, 
       0.47552825814757677`}, {1.308996938995747, 0., 0.5}, {
       1.335176877775662, -0.15450849718747373`, 0.47552825814757677`}, {
       1.361356816555577, -0.29389262614623657`, 0.4045084971874737}, {
       1.387536755335492, -0.4045084971874737, 0.29389262614623657`}, {
       1.413716694115407, -0.47552825814757677`, 0.15450849718747373`}, {
       1.439896632895322, -0.5, 0.}, {
       1.4660765716752364`, -0.47552825814757677`, -0.15450849718747373`}, {
       1.4922565104551517`, -0.4045084971874737, -0.29389262614623657`}, {
       1.5184364492350664`, -0.29389262614623657`, -0.4045084971874737}, {
       1.5446163880149817`, -0.15450849718747373`, -0.47552825814757677`}, {
       1.5707963267948966`, 0., -0.5}, {1.5969762655748114`, 
       0.15450849718747373`, -0.47552825814757677`}, {1.6231562043547265`, 
       0.29389262614623657`, -0.4045084971874737}, {1.6493361431346412`, 
       0.4045084971874737, -0.29389262614623657`}, {1.6755160819145563`, 
       0.47552825814757677`, -0.15450849718747373`}, {1.7016960206944711`, 
       0.5, 0.}, {1.7278759594743862`, 0.47552825814757677`, 
       0.15450849718747373`}, {1.754055898254301, 0.4045084971874737, 
       0.29389262614623657`}, {1.7802358370342162`, 0.29389262614623657`, 
       0.4045084971874737}, {1.806415775814131, 0.15450849718747373`, 
       0.47552825814757677`}, {1.832595714594046, 0., 0.5}, {
       1.8587756533739606`, -0.15450849718747373`, 0.47552825814757677`}, {
       1.8849555921538759`, -0.29389262614623657`, 0.4045084971874737}, {
       1.9111355309337905`, -0.4045084971874737, 0.29389262614623657`}, {
       1.9373154697137058`, -0.47552825814757677`, 0.15450849718747373`}, {
       1.9634954084936205`, -0.5, 0.}, {
       1.9896753472735353`, -0.47552825814757677`, -0.15450849718747373`}, {
       2.0158552860534504`, -0.4045084971874737, -0.29389262614623657`}, {
       2.042035224833365, -0.29389262614623657`, -0.4045084971874737}, {
       2.0682151636132806`, -0.15450849718747373`, -0.47552825814757677`}, {
       2.0943951023931953`, 0., -0.5}, {2.1205750411731104`, 
       0.15450849718747373`, -0.47552825814757677`}, {2.146754979953025, 
       0.29389262614623657`, -0.4045084971874737}, {2.1729349187329405`, 
       0.4045084971874737, -0.29389262614623657`}, {2.199114857512855, 
       0.47552825814757677`, -0.15450849718747373`}, {2.2252947962927703`, 
       0.5, 0.}, {2.251474735072685, 0.47552825814757677`, 
       0.15450849718747373`}, {2.2776546738526, 0.4045084971874737, 
       0.29389262614623657`}, {2.303834612632515, 0.29389262614623657`, 
       0.4045084971874737}, {2.3300145514124297`, 0.15450849718747373`, 
       0.47552825814757677`}, {2.356194490192345, 0., 0.5}, {
       2.38237442897226, -0.15450849718747373`, 0.47552825814757677`}, {
       2.408554367752174, -0.29389262614623657`, 0.4045084971874737}, {
       2.4347343065320897`, -0.4045084971874737, 0.29389262614623657`}, {
       2.4609142453120048`, -0.47552825814757677`, 0.15450849718747373`}}, 
      0.05]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBSplineCurveBox[{{2.4609142453120048`, -0.47552825814757677`, 
       0.15450849718747373`}, {2.4870941840919194`, -0.5, 0.}, {
       2.513274122871834, -0.47552825814757677`, -0.15450849718747373`}, {
       2.539454061651749, -0.4045084971874737, -0.29389262614623657`}, {
       2.5656340004316642`, -0.29389262614623657`, -0.4045084971874737}, {
       2.5918139392115793`, -0.15450849718747373`, -0.47552825814757677`}, {
       2.617993877991494, 0., -0.5}, {2.6441738167714086`, 
       0.15450849718747373`, -0.47552825814757677`}, {2.670353755551324, 
       0.29389262614623657`, -0.4045084971874737}, {2.696533694331239, 
       0.4045084971874737, -0.29389262614623657`}, {2.722713633111154, 
       0.47552825814757677`, -0.15450849718747373`}, {2.7488935718910685`, 
       0.5, 0.}, {2.775073510670984, 0.47552825814757677`, 
       0.15450849718747373`}, {2.8012534494508987`, 0.4045084971874737, 
       0.29389262614623657`}, {2.827433388230814, 0.29389262614623657`, 
       0.4045084971874737}, {2.8536133270107285`, 0.15450849718747373`, 
       0.47552825814757677`}, {2.879793265790644, 0., 0.5}, {
       2.9059732045705586`, -0.15450849718747373`, 0.47552825814757677`}, {
       2.932153143350473, -0.29389262614623657`, 0.4045084971874737}, {
       2.9583330821303884`, -0.4045084971874737, 0.29389262614623657`}, {
       2.9845130209103035`, -0.47552825814757677`, 0.15450849718747373`}, {
       3.0106929596902186`, -0.5, 0.}, {
       3.0368728984701328`, -0.47552825814757677`, -0.15450849718747373`}, {
       3.063052837250048, -0.4045084971874737, -0.29389262614623657`}, {
       3.0892327760299634`, -0.29389262614623657`, -0.4045084971874737}, {
       3.1154127148098785`, -0.15450849718747373`, -0.47552825814757677`}, {
       3.141592653589793, 0., -0.5}, {3.1677725923697078`, 
       0.15450849718747373`, -0.47552825814757677`}, {3.193952531149623, 
       0.29389262614623657`, -0.4045084971874737}, {3.2201324699295384`, 
       0.4045084971874737, -0.29389262614623657`}, {3.246312408709453, 
       0.47552825814757677`, -0.15450849718747373`}, {3.2724923474893677`, 
       0.5, 0.}, {3.2986722862692823`, 0.47552825814757677`, 
       0.15450849718747373`}, {3.3248522250491974`, 0.4045084971874737, 
       0.29389262614623657`}, {3.3510321638291125`, 0.29389262614623657`, 
       0.4045084971874737}, {3.3772121026090276`, 0.15450849718747373`, 
       0.47552825814757677`}, {3.4033920413889422`, 0., 0.5}, {
       3.429571980168857, -0.15450849718747373`, 0.47552825814757677`}, {
       3.4557519189487724`, -0.29389262614623657`, 0.4045084971874737}, {
       3.4819318577286875`, -0.4045084971874737, 0.29389262614623657`}, {
       3.508111796508602, -0.47552825814757677`, 0.15450849718747373`}, {
       3.534291735288517, -0.5, 0.}, {
       3.5604716740684323`, -0.47552825814757677`, -0.15450849718747373`}, {
       3.5866516128483474`, -0.4045084971874737, -0.29389262614623657`}, {
       3.612831551628262, -0.29389262614623657`, -0.4045084971874737}, {
       3.6390114904081767`, -0.15450849718747373`, -0.47552825814757677`}, {
       3.665191429188092, 0., -0.5}, {3.6913713679680074`, 
       0.15450849718747373`, -0.47552825814757677`}, {3.717551306747921, 
       0.29389262614623657`, -0.4045084971874737}, {3.7437312455278366`, 
       0.4045084971874737, -0.29389262614623657`}, {3.7699111843077517`, 
       0.47552825814757677`, -0.15450849718747373`}, {3.7960911230876673`, 
       0.5, 0.}, {3.822271061867581, 0.47552825814757677`, 
       0.15450849718747373`}, {3.848451000647496, 0.4045084971874737, 
       0.29389262614623657`}, {3.8746309394274117`, 0.29389262614623657`, 
       0.4045084971874737}, {3.900810878207327, 0.15450849718747373`, 
       0.47552825814757677`}, {3.926990816987241, 0., 0.5}, {
       3.953170755767156, -0.15450849718747373`, 0.47552825814757677`}, {
       3.9793506945470707`, -0.29389262614623657`, 0.4045084971874737}, {
       4.005530633326986, -0.4045084971874737, 0.29389262614623657`}, {
       4.031710572106901, -0.47552825814757677`, 0.15450849718747373`}, {
       4.057890510886816, -0.5, 0.}, {
       4.08407044966673, -0.47552825814757677`, -0.15450849718747373`}, {
       4.110250388446646, -0.4045084971874737, -0.29389262614623657`}, {
       4.136430327226561, -0.29389262614623657`, -0.4045084971874737}, {
       4.162610266006475, -0.15450849718747373`, -0.47552825814757677`}, {
       4.1887902047863905`, 0., -0.5}, {4.214970143566306, 
       0.15450849718747373`, -0.47552825814757677`}, {4.241150082346221, 
       0.29389262614623657`, -0.4045084971874737}, {4.267330021126136, 
       0.4045084971874737, -0.29389262614623657`}, {4.29350995990605, 
       0.47552825814757677`, -0.15450849718747373`}, {4.319689898685965, 0.5, 
       0.}, {4.345869837465881, 0.47552825814757677`, 0.15450849718747373`}, {
       5, 0, 0}}, 0.05]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBSplineCurveBox[CompressedData["
1:eJx10f071Xccx/HDoSK6QZJmHYfV1Y2mHK3OwfvQhilycqg026EYmtlRWWdp
ucmZaKk1s0smilVXdxrdrFlfxFHp5qhWKgeHw7m/v3fE9sv389te1/X6A57X
wzctd2u6PYFAiP7vRML/L7ugVap27wXN1DkZyW8EQkQROo7LEJZ5iLc2G+7A
1T+WOY/AGBQe6k96TH6Lsb7rK2R3VcLICuZyokIMw5lhLNLJF5gXOZH6jtmI
EY8xvbYbpXCOra0gWXqw5oKQt3biy1hj9c/BjRvkQDE2m7L/acD4bW4KamQ9
BpagLwwX5RByjXMleuIuxKd0d7yy1EPiUdapBZvl8E1cVFK7kQ+tizmxEXM7
oJ355BSRKoPU3WujVSX9sN7cfzioiQ+K/QpeyhkJ5El8o3ouCeC4WsbM63gN
WW9i3ck3xoH+d0vAIsUQNKymOZdxhUCLybrp1SbCe+GrFLnrnDdj4PGh22iB
aQTvhUregIDFkcKBLW7zihqEeC9MhPr2bPBQgJYblsNQD+O9QDjVy+rbqwSR
+8raFfZCvBdSX+4LDylUgnDT7bvTEiHei71PCcrojFDA7oTbL4l1o3gvlk7+
sc4kksIJ0rdk2sxxvBfzfFzT0Xh5HN5Vl9JmWFEvFt185fdJwwh4PoqnfUlV
4L1Y3fWZATGbBmHQkCqqKlcj3063oa5VjFcQ+0JXdClBi3zXTwd17cf6IGPe
0fltF3XI9+O6bt/0nEdgojsdzbiqR771PRXW0eiHcD/yYvWxeAPyrf0o6cYC
9mPwNB+43FpmQL5zl2QE5gw/g3qojOzeYUC+dDvZ5/ro15D4AS+yja9HvluC
iQMRLcOgCE5kZRH1yPfgmmORaeFjsFJSyt00R4d8EyWMpWvEUvCod+/nzdci
X9JC+xW3qCoodMtUWVZrkK9vu3XSQamBtE/4TqZZauT70naazabqYKBgMoOX
pEK+yUvZYaEyHTx1kladyVIhX+f73VfzNDp4Ep5/e1+8GvnKTP4dNxg6uOBP
y2wr1iBfFxVD8JSshbAK7znbb2mR70PudUGsqxqMvIaa0EDUi9myujqbEuVg
l/qDt4pvQL7FP9WsjeOKId04N9eRY0K+Hhu534OTCDY+7ZtKn2lBvvF/Bk7t
ogshZXbm8fwUK/Iti5j3wMEyCAqaxNE3bQL5UrfpKV1jArgbXuYR5WBDvpTK
fjcBZwhcdNuW54bYkC/1waetQ3wh/EL9+t5hVxvy3XqnopfsOAYxpKZ7+Ucm
kK+9epFF7i4FYSBF4HfLinwD5GfTZp9VAml0N3FGpwX5OjAovko/LTif1jGL
us3INzvTxa85Vg/5rlF7WkZMyHfiPceKHT5GOO/TUxS83oR8m7efn+7ONsGu
DSnNPkNG5EspKXh00tsMg4efR5VLjMhX5N8X0kMyg2Cx92vDThPy7UwI3OJc
bIK6Jd5j+evMyFcck7LHP8EIwVxrudseC/INJYkKbDf1IO0oXGgZRb1Y/8mc
3GVvtWDZmVF94YgN+a7bfD3OPK6GZI1Kjq16h3wfTNbWSLIUQH3YfJD01xTy
td8b5e3aIIXlJedKf51FoOO+1jd1hZcGxJB3eleHspxAx30Z6SfWVSSIYWdd
y33CAIGO+8bZlTRV+0igKH/xcw8LgY77aopZ/LI1MuDVLCX9Nkyg474z9p0V
96Yrod41ot6rlkDHfZOZXuUxdzQgr3IKyA0m0HFf9rPPINlOD56DGwvb908j
X8EVuBbONMJUVV8fjTOFfP8FzsR31Q==
      "], 0.05]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBSplineCurveBox[CompressedData["
1:eJw90X0w1HkcwPF9tGs9VHQSPWmLTOekWadZ8vleTkQpPUg0omlVHrLS04bt
ZHuuI7LRkWsqD1cee3Cn8msqI8rRULe1KA93loRdFmufrrnb/X5mPvP5+/15
OexO2MyjkEikgK9L/bqdZVDxw1Yl6HLevPEU6MCrb41CYP4R1tTPqaIJJyGW
6SiLF2vhp1RJSPNiKbQLZs4t36CCfNsi3chnDXza5x256HI7nH9Qfcnul2kI
43i5SLI0cDNRfmHRVANYfjoT9k+AGtqPV7/4MV8DHGXlRMzbG1CX1tFkH6yG
NhvVtooZWvCqEJT5T9cR+ZWenRHV05Blp4pyG9QCP8gv5KmylSCK96mOpavA
OU3CaF6gh6g9K/2H0yWEbeoIa1P/JPC7XAPeB5LQQZmDX8OdTqJq+Jg22WwC
jtxZfN5tHhmhJ/dc5g59JMYpe9xb2eNQoozmrB4lI0Mv4S3dIfXnKeBqj19K
fA0FGXqJnTau9lKSHG6TrF8c3k1Fhl4ipCks6LcFozBk26Zv6qMiQy9BX1i8
mXN/BN7Zsxld7jRk6CXSOl9HLoJR0Iydn6UIpiFDLwRf95ywXSeHH2zFEce5
NGTohU5xRxq3VwHzLlR1KZVUZOgFThXbtnBwHHjWgtj1GVRjLwS47msud5uE
03GXhU9mU429UMMKXC0WqSDZP9QpWUwx9sKCxWzYUa6GqrSTK2cvxb1Q9s6+
mCLUQuO5Z6vftpCNvbDHqs4+4ZUOiq9abFt3k2zsBZlXtoybrIe/a1/+qi8m
G3sht6s/lJ+mhz5m3MD9brKxlzhq4Rd7r0cH9ay4EWUQxdhL5NEOnWm+p4WZ
deHPfAYoxl5C/n4699YcDXwOLzz78DbuJS4Fii60ek7D2LKsl5ZHaNi3ZVfC
8yVbp4Cd9O6gXQAd+9qs4u0vyJkAq8ia2oBZJtiXk8QtdXVTwkLhScqWxybY
d4VTdIcuaBz2itd4l3gzsO/OoYiaA6xxCM7L8n2UwcC+YVzJ8KGEcTiSOL2x
5Q4D+y5XrxXFC5TwOIdesP0KA/s+HOufkWE9CWKmw/y2jQzsa2npWjRmp4Lu
TFmp84AJ9l1yMSmculsN5EHSk2sHTLBv5t6QV4P3taCsb+CFjuJemBB+11zW
pYflejlfLqRj3xd52deW/0VCvoyVKdXOdOxbWNPX3p1KRuxvUrMdtTTs+2n9
xkcNb8koctWqjx1kOvb9vUCQ1CMho4jTUqcsTzr2XeZeqkk/R0ZwVurSVkLH
vrWVBGuWgoQuer4iOfiYYF+efXq2hk1CvPeWDdl63EvwSjLmLo3TQXwRmTHU
wsC+xY+PBwtEGigY9a2avMnEvoor/El5/TRkdDqqnGJNsa9lq6+HKEoF19Ry
tMKGhX2ZosSYLSemoNu6OuVULgv7fr8uxvc5dwpe21BEuQMs7Ot+tTelsXAK
FMP7f75LN8O+tNDNVs9KVeBhfVjKGWZh38xNYwW9PmqwOp0ZXlnKwr79MVyO
f6AWwi1DZSY+LOyrkwkHtmfpIWUvX330pSn25fRU3i38+je+j8ct9wBT7Cv7
ku+SxqCgopSoij8lTOy7wj+ve9sIBRGiG7UZ6UzsaxY9aG8upqLrWUNvqNuZ
2HeDeitF8YWKpA+K59eGM7Gv4/oTteZyKvpADYxOyGFi3yu95T7lN6iolh4Y
V0kxxb5Ou+qDPVlUZPIHF3T5pti3rfHsB0cvCuoJEdITd+BeovBkc5tXEBnJ
2Im+jc5m2Pep+fOR6DASmnPgwUi71gz7NsmTT62d0AEzXOxBrzfHvgPfBtdL
LmvBRhB1woJvgX1J/w0N/X9nGi6J9C+W21/r
      "], 0.05]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBSplineCurveBox[CompressedData["
1:eJxd0Ws01Hkcx3Fpk2aM+c8MXSxLylrbQenmSP7fKNOqtOQuxZqhpVNiq4NW
VFvbdnFZ5XZSkXs0ZqJF/DXEWUUTWjOLpkxmEbPGoDGTsZ7M78F+z/k9+T17
f15rfzjpzdbV0dHZu/iW6mjPCHT+d/aMzdXjJCPwyLAeHMyU4u+OuYRapPcS
JOkWf90sBlRxrUlD+DCe/LPQr9Oyn9j0rul2ugEDrmYJtrknSHDnD65T8QZi
ws+mrb7vLB2Cl4+LnFPe49DIs10zLiYEK053MqQ0qOrL3a9rJ8ZjR9Yy2ysG
CSc3SYkTiwZ6Jn3cWmU/HsZy2Cu7KCRWLVPv5s5j8JbD5WX0ivAYT6Zf84yA
kPjcNd/SgIF+D9n0zWoR7vwovnKvqokIX/Isfeo+Bi6ZHidPz4nwLTOc2ag3
9/HVAt28lTwMLlR0lFEuDOCFp+TXLJTtuIlke1fBRwyGaodbgj3eaXtx70xX
l6bdNDCyp0vOzQ5pe3H46rlR6GMadA/d0nVhSLW9uH1gh94+OzrkkEsqjoeP
anvxPz9bk6CIDtV4bEXng3FtLx7HbNvjsbib2ZPk1uzb/2p78fIVDU1LAxhg
xTfXH1mY1Pbiip3rVNzzDJA+NzeK+luu7cUvGxvmWyUxYDgsoqj3wJS2l5B2
CMsdvBlwtHTAeZf/lLaXUO7g3OjT0MG0NTbaRiNHvr2G3M0Tv9HhQO9USsUh
OfJV6TvHndOhQ507M3swZhL5mnu7ZfGjabBnvqynekSGfHMdpso0Igz4YWSL
MxrUS3xxPPSSVQAGkxdsDgnCPyJffvCkq5OECoGeWYeavMaQb5DaUbnzCBVO
iFuuiBWjyDfI59xA/QYqkCG82p41hnxb5QsyXU8qVO0r7Eos/Yh821dF+X5J
UKHrYWGjoHoC+Zo2EiZljhgk04/JlHaTyJfEdJV7lGJwZNwmKbBRjnznUpiS
rZY04Cdzu2PYCuT7u1WR9NscGnSZZHuv1ZtBvjtj3Cy3Lu72i5+5WO/8LPL9
ycExT7Zvcf9GzaUC3ifk+zTi3l934ugw0KxJW39TiXy/d7mWgMUu/h/eY5m6
ZA75PlL4XjFzp4NvYUOdmjSHfPks2yj+FA3ohNeIpFqJfPO322PCJBq4vXqt
YS9XIt/WTXUHI6cx4Oz62jh7/SfkO5rQHFd5FIPsOV4E45tZ5NtW+9agJ48K
wooP12ccUC+RZ9PwzCLbEE48jSsuYE8jX9/KMTX1BQUsC8qLcwYUyHdi/+Zq
hjsFHo41Q3mlAvlOFJ25lcaggCo3zbd7WIF8A9xUJcKtFHh5byNLeWUa+Qb9
yDKUF1Mg5DWnv+D6DPJ98SJeZh1oCGcozGje0CzyLREn5UU7UsHnH30145QS
+baUtxIWKzF4kph+cMMaFfI97GnZYnwDg1bjs6/669TIVy+nWWO+uFuilyb4
mcM88nUJrjkrwmmA/TG4JCRSg3wvp5rxfo2kQU/DIEW8awH5mkTq+6vZNBD4
r7/7Xc0C8o037QnXd6LB/vzcbbVNC8j32o1y90opBsvrN7Lz2QvINzL04Tg/
FgOnDk6iRYMG+ZrWHA94IKBCkfOyDG/hPPJlMRPvbSwxhNTpDEln/2fkG6Qv
el56kQKviltWcKSol7BLrEmYPW8ArCfe60LWqJHviObD42EuGUzuXF3nk6ZC
vsn5tlGjtmQoHL7byApTId+UTzGeEWoSTN462X09R4V8xzKnQ6vMyMDPo77n
7lAjX1n9kfa2m2TwepkaEAKfke9/Fslc+Q==
      "], 0.05]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBSplineCurveBox[CompressedData["
1:eJw90Xs0lHkYwPGXubzvO/POuCcqUdJFumBDDe/TpCGxiGSyDSJErl1ELXJJ
5WxWFxVbua0RYm1bbFvNsLm0LkdE2pSkpdqhqJbIWmfL73fOc55znn9+53s+
BjvDt+xSxjDMYXoY0zN0U1Jfd5ILrk3pnjvgE/0syMZHP+MB7T1vn3QSKAgh
jF6GZk7SCd92eTQveEyvXR3jvl6fB5ueD0S3GE7RghfCkRiqh54tTbLU1uTD
tnWW/VEBGMDtayY6ih7acciGVlJWgR2EsVHjGiWIemlgV1/yhM5JOnRDq1UF
LAvDFNbvlMDX39R+KKmLxpNN3e+aqUKSWCJL+04ZIr6285B/aKVdqrLS93qp
gr+XpLZpXBkE5TFX7cfv0H3pKWb9YlXwu6LETzRngPmHn/4J7siVCTe6wDsT
VchpuiW2tGJAfuRwmv5Yvax4j7No1XUViP8TjyylGPClV+ar7nbKq5kP557b
HQ6tVIYvvbIydqBabBUPWuZEpbJF0/9+7pWNnd8vZqdTUDNquepuvdJMr0wh
bo+LC+FCn4vrhq+cUK+suqncrCmQAysezW5N68dmemWHXXpCf8siAXc0d8Hz
sJlemcbbxQtlWiQ4RtAX009gM70yzU0huKCPgCh7qTS/EJvppeP6h3SSWSR8
s3m07MYoNtNLJ1DihB8OkFDgV/maG6s000sPh4X5tC/hQMWRRFPNRaiXbknc
y9MmuJAT5hdrq0C9dOnYt8OKCS7cr5IausgZyPcpbTXW+YqCrpQs/6LvmcjX
tGN/+N+VPPhl4dNlc5xYyDdH7O0rcebDVGfzZNAAC/ma1qzsunWJD0+7mhnF
7mzkuz2SpZ+XPX03inT0PslGvtrdWVa3NvBhnsPy81qn2chXcGfTFOsiD8a3
RZcfD2Aj3w9+TptXX6dA3afypoMaG/kKPX3/cM7hgv2F3tq+yyzkm/Y6XL37
AAes9xeF5RqwkG9CSbOFuxsJkhb5EXUp6pW56xUrcp0JKPI4xt8NTOTLz3tk
lJGIQ+K9/JMvJhjIt3D9gu4zk2xoGCx7vOcFA/lKs3bJ1RrZMFQ7qz8BYyJf
NctXbeJBNjxsCBg87cpEvpoSN6soCQ56vUZLX7UzkW+KPEjniioBxlPDEcNx
LOTr8yC0TvGGgLmKtioDERv52jgcLK7pI8FpjbafiS6OfKMyzCpK73PAjcHJ
T3mNI986o4gl1Ze5sCLXafdYIYF8zUvEuuYWFMS4WwtE60nke1djWcapoxRs
97AWppaRyHewZqorOokCz4JnJwQvSeRbYnJ2JMOYgnP12Z0jChL5tqrYVj1O
5sK+jv7BADmJfFOv2zHxixxIf2L0cXEIiXw7rnglLTpGwu+zXJnVHwnkO18Q
3FghIaByRPtq3CEC+WpM1r9dug6HR5tXyd9gBPIdCC/4MdqCDYYPRh1FWTjy
zXvX3hMQzIJJkUZz9VYc+a49Pfds8F9MEIbo6TrY4Mh3rcI7ZuBnJgRtOGoo
2Y4j34LjfWkrO5iwRdRpHFmCI9+icqcROxELLkgyA+tMCOQ7W92vLW6MBYWH
fctbugjk+35RUHzNQzZk7haO/nuZRL5t2VF+5xtxaLh2NJezj4N8WX0mwYm/
EtCSENO705aLfMUHg3szU0ko0rst7cAo5Nvwya2dnM+B9/dLYxdmU8jXc5eh
Q1AYBzrbSxP8CR7yjdccz3AK4UCHgcs9HSEP+drEp5cEanBAfSNXq1XEQ77+
vjaRFXtIGNrisdxWl4d85+DC293JBBBemRasWgr5Bk1sFUyE40CfkQsvuVHI
F/v/MeHzVv2yMew/B4YhQw==
      "], 0.05]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{5, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{2.5, 4., 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output",ImageCache->GraphicsData[\
"CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1843, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "BondStyle is an option of CrystalPlot which determines the layout of \
interatomic bonds.", "synonyms" -> {}, "title" -> "BondStyle", "type" -> 
    "Symbol", "uri" -> "Crystallica/ref/BondStyle"}, "SearchTextTranslated" -> 
  "", "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828956-3834481"->{
  Cell[751, 30, 193, 3, 40, "Print",
   CellTags->"Info3569828956-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828956-3834481", 120199, 2625}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 169, 6, 70, "Section"],
Cell[751, 30, 193, 3, 40, "Print",
 CellTags->"Info3569828956-3834481"],
Cell[947, 35, 1033, 37, 29, "Item"],
Cell[CellGroupData[{
Cell[2005, 76, 115, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[2145, 83, 54, 0, 25, "Subitem"],
Cell[2202, 85, 41, 0, 25, "Subitem"],
Cell[2246, 87, 53, 0, 25, "Subitem"],
Cell[2302, 89, 65, 0, 25, "Subitem"],
Cell[2370, 91, 77, 0, 25, "Subitem"],
Cell[2450, 93, 55, 0, 25, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[2532, 97, 93, 2, 29, "Item"],
Cell[2628, 101, 194, 6, 29, "Item"],
Cell[2825, 109, 257, 5, 29, "Item"],
Cell[3085, 116, 26, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[3136, 120, 30, 0, 49, "Subsection"],
Cell[3169, 122, 33, 0, 30, "Text"],
Cell[3205, 124, 102, 2, 31, "Input"],
Cell[3310, 128, 42, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[3377, 132, 948, 27, 31, "Input"],
Cell[4328, 161, 7657, 265, 197, "Output"]
}, Open  ]],
Cell[12000, 429, 139, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[12164, 436, 580, 16, 31, "Input"],
Cell[12747, 454, 898, 32, 375, "Output"]
}, Open  ]],
Cell[13660, 489, 99, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[13784, 495, 2040, 59, 72, "Input"],
Cell[15827, 556, 12847, 360, 197, "Output"]
}, Open  ]],
Cell[28689, 919, 137, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[28851, 926, 496, 14, 31, "Input"],
Cell[29350, 942, 1990, 59, 375, "Output"]
}, Open  ]],
Cell[31355, 1004, 221, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[31601, 1012, 1418, 41, 31, "Input"],
Cell[33022, 1055, 2822, 61, 375, "Output"]
}, Open  ]],
Cell[35859, 1119, 288, 5, 30, "Text"],
Cell[CellGroupData[{
Cell[36172, 1128, 1929, 54, 52, "Input"],
Cell[38104, 1184, 4163, 91, 375, "Output"]
}, Open  ]],
Cell[42282, 1278, 112, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[42419, 1285, 5598, 138, 212, "Input"],
Cell[48020, 1425, 71160, 1171, 408, 18280, 303, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
