(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10709,        357]
NotebookOptionsPosition[      8967,        302]
NotebookOutlinePosition[     10149,        337]
CellTagsIndexPosition[     10065,        332]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondsFlatQ (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondsFlatQ is an option of CrystalPlot that replaces the \
regular tube bonds with flat lines if desired.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3583658560-5983654"],

Cell[TextData[{
 "BondsFlatQ is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ButtonBox[",",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 " ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["ForceBonds,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 " ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and",
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ButtonBox["BondRadScaledQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"]
}], "Item"],

Cell["\<\
If BondsFlatQ is set to True, two-dimensional lines are used as bonds even if \
the plot is in 3D.\
\>", "Item"],

Cell["Default:False", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["3D and flat bonds:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"BondsFlatQ", "\[Rule]", "flat"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"flat", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       {Thickness[0.075], CapForm[None], 
        Line3DBox[{{0, 0, 0}, {1., 0., 0.}}]}}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       {Thickness[0.075], CapForm[None], 
        Line3DBox[{{2, 0, 0}, {1., 0., 0.}}]}}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Combine flat bonds with flat cell lines and 2D atoms using ",
 ButtonBox["CellLinesFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"],
 " and ",
 ButtonBox["AtomFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomFunction"],
 " - the plot itself remains a Graphics3D object. The 2D effect is even \
stronger without cell lines."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"CellLinesFlatQ", "\[Rule]", "True"}], ",", 
     RowBox[{"BondsFlatQ", "\[Rule]", "True"}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", "lines"}], ",", 
     RowBox[{"AtomFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", 
           RowBox[{".5", "*", "#2"}], "]"}], ",", 
          RowBox[{"Point", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"lines", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], Thickness[0.01], 
       Line3DBox[{{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {0, 0, 0}}, {{
        0, 0, 2}, {2, 0, 2}, {2, 2, 2}, {0, 2, 2}, {0, 0, 2}}}]}, 
      {GrayLevel[0], Thickness[0.01], 
       Line3DBox[{{{0, 0, 0}, {0, 0, 2}}, {{2, 0, 0}, {2, 0, 2}}, {{2, 2, 
        0}, {2, 2, 2}}, {{0, 2, 0}, {0, 2, 2}}}]}}, {
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}]}, 
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}]}, 
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       Arrow3DBox[{{0, 0, 0}, {0, 0, 2}}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       {Thickness[0.075], CapForm[None], 
        Line3DBox[{{0., 0., 0.}, {0.5, 0.5, 0.}}]}}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       {Thickness[0.075], CapForm[None], 
        Line3DBox[{{1., 1., 0.}, {0.5, 0.5, 0.}}]}}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.25], 
        Point3DBox[{0, 0, 0}]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.25], 
        Point3DBox[{1., 1., 0.}]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       {Thickness[0.075], CapForm[None], 
        Line3DBox[{{0., 0., 0.}, {0.5, 0.5, 0.}}]}}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       {Thickness[0.075], CapForm[None], 
        Line3DBox[{{1., 1., 0.}, {0.5, 0.5, 0.}}]}}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.25], 
        Point3DBox[{0, 0, 0}]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.25], 
        Point3DBox[{1., 1., 0.}]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 2}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "BondsFlatQ is an option of CrystalPlot that replaces the regular tube \
bonds with flat lines if desired.", "synonyms" -> {}, "title" -> "BondsFlatQ",
     "type" -> "Symbol", "uri" -> "Crystallica/ref/BondsFlatQ"}, 
  "SearchTextTranslated" -> "", "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3583658560-5983654"->{
  Cell[752, 30, 211, 4, 40, "Print",
   CellTags->"Info3583658560-5983654"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3583658560-5983654", 9964, 326}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 170, 6, 70, "Section"],
Cell[752, 30, 211, 4, 40, "Print",
 CellTags->"Info3583658560-5983654"],
Cell[966, 36, 1210, 43, 29, "Item"],
Cell[2179, 81, 122, 3, 29, "Item"],
Cell[2304, 86, 29, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[2358, 90, 30, 0, 49, "Subsection"],
Cell[2391, 92, 33, 0, 30, "Text"],
Cell[2427, 94, 102, 2, 31, "Input"],
Cell[2532, 98, 34, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2591, 102, 576, 18, 31, "Input"],
Cell[3170, 122, 1645, 54, 197, "Output"]
}, Open  ]],
Cell[4830, 179, 413, 11, 30, "Text"],
Cell[CellGroupData[{
Cell[5268, 194, 1253, 37, 52, "Input"],
Cell[6524, 233, 2403, 64, 230, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
