(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     12114,        369]
NotebookOptionsPosition[     10188,        308]
NotebookOutlinePosition[     11407,        344]
CellTagsIndexPosition[     11322,        339]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CellLinesFlatQ",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CellLinesFlatQ is an option of CrystalPlot that replaces the \
regular tube cell outlines and arrows with flat lines if desired.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3583658885-5983654"],

Cell[TextData[{
 "CellLinesFlatQ",
 " is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other cell-related options are ",
 ButtonBox["CellLineStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineStyle"],
 ", ",
 ButtonBox["CellLineCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineCol"],
 ", and ",
 ButtonBox["CellLineRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineRad"],
 "."
}], "Item"],

Cell["\<\
If CellLinesFlatQ is set to True, two-dimensional lines are used as cell \
outlines even if the plot is in 3D.\
\>", "Item"],

Cell["Default:False", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["3D and flat cell lines:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"CellLineCol", "\[Rule]", "\"\<Firebrick\>\""}], ",", 
     RowBox[{"CellLineRad", "\[Rule]", ".04"}], ",", 
     RowBox[{"CellLinesFlatQ", "\[Rule]", "flat"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"flat", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {RGBColor[0.698004, 0.133305, 0.133305], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.04]}, 
      {RGBColor[0.698004, 0.133305, 0.133305], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.04]}}, {
      {RGBColor[0.698004, 0.133305, 0.133305], 
       TubeBox[{{0, 0, 0}, {2.2985728833299928`, 0., 0.}, {
         2.2985728833299928`, 0., 0.}, {3, 0, 0}}, {
        0.041, 0.041, 0.1753567791675018, 0}]}, 
      {RGBColor[0.698004, 0.133305, 0.133305], 
       TubeBox[{{0, 0, 0}, {0., 2.2985728833299928`, 0.}, {0., 
         2.2985728833299928`, 0.}, {0, 3, 0}}, {
        0.041, 0.041, 0.1753567791675018, 0}]}, 
      {RGBColor[0.698004, 0.133305, 0.133305], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.2985728833299928`}, {0., 0., 
         2.2985728833299928`}, {0, 0, 3}}, {
        0.041, 0.041, 0.1753567791675018, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], 
       Line3DBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{
        0, 0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}]}, 
      {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], 
       Line3DBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 
        0}, {3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}]}}, {
      {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], Arrowheads[
       0.20500000000000002`], Arrow3DBox[{{0, 0, 0}, {3, 0, 0}}]}, 
      {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], Arrowheads[
       0.20500000000000002`], Arrow3DBox[{{0, 0, 0}, {0, 3, 0}}]}, 
      {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], Arrowheads[
       0.20500000000000002`], Arrow3DBox[{{0, 0, 0}, {0, 0, 3}}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Combine flat cell lines with flat bonds and 2D atoms using ",
 ButtonBox["BondsFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 " and ",
 ButtonBox["AtomFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomFunction"],
 " - the plot itself remains a Graphics3D object:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"CellLinesFlatQ", "\[Rule]", "True"}], ",", 
   RowBox[{"BondsFlatQ", "\[Rule]", "True"}], ",", 
   RowBox[{"AtomFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", 
         RowBox[{".5", "*", "#2"}], "]"}], ",", 
        RowBox[{"Point", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], Thickness[0.01], 
     Line3DBox[{{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {0, 0, 0}}, {{0, 
      0, 2}, {2, 0, 2}, {2, 2, 2}, {0, 2, 2}, {0, 0, 2}}}]}, 
    {GrayLevel[0], Thickness[0.01], 
     Line3DBox[{{{0, 0, 0}, {0, 0, 2}}, {{2, 0, 0}, {2, 0, 2}}, {{2, 2, 0}, {
      2, 2, 2}}, {{0, 2, 0}, {0, 2, 2}}}]}}, {
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}]}, 
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}]}, 
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     Arrow3DBox[{{0, 0, 0}, {0, 0, 2}}]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     {Thickness[0.075], CapForm[None], 
      Line3DBox[{{0., 0., 0.}, {0.5, 0.5, 0.5}}]}}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      Line3DBox[{{1., 1., 1.}, {0.5, 0.5, 0.5}}]}}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.25], 
      Point3DBox[{0, 0, 0}]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.25], 
      Point3DBox[{1., 1., 1.}]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Give two separate values for lines and arrows:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"CellLinesFlatQ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"CellLineCol", "\[Rule]", "\"\<Firebrick\>\""}], ",", 
   RowBox[{"CellLineRad", "\[Rule]", ".04"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], 
     Line3DBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
      0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], Thickness[0.02], 
     Line3DBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
      3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{0, 0, 0}, {2.2985728833299928`, 0., 0.}, {2.2985728833299928`, 
       0., 0.}, {3, 0, 0}}, {0.041, 0.041, 0.1753567791675018, 0}]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{0, 0, 0}, {0., 2.2985728833299928`, 0.}, {0., 
       2.2985728833299928`, 0.}, {0, 3, 0}}, {
      0.041, 0.041, 0.1753567791675018, 0}]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.2985728833299928`}, {0., 0., 
       2.2985728833299928`}, {0, 0, 3}}, {
      0.041, 0.041, 0.1753567791675018, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 2}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "CellLinesFlatQ is an option of CrystalPlot that replaces the regular \
tube cell outlines and arrows with flat lines if desired.", "synonyms" -> {}, 
    "title" -> "CellLinesFlatQ", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/CellLinesFlatQ"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3583658885-5983654"->{
  Cell[761, 31, 235, 4, 40, "Print",
   CellTags->"Info3583658885-5983654"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3583658885-5983654", 11221, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 179, 7, 70, "Section"],
Cell[761, 31, 235, 4, 40, "Print",
 CellTags->"Info3583658885-5983654"],
Cell[999, 37, 533, 19, 29, "Item"],
Cell[1535, 58, 134, 3, 29, "Item"],
Cell[1672, 63, 29, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1726, 67, 30, 0, 49, "Subsection"],
Cell[1759, 69, 33, 0, 30, "Text"],
Cell[1795, 71, 102, 2, 31, "Input"],
Cell[1900, 75, 39, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[1964, 79, 716, 20, 31, "Input"],
Cell[2683, 101, 2607, 60, 197, "Output"]
}, Open  ]],
Cell[5305, 164, 352, 10, 30, "Text"],
Cell[CellGroupData[{
Cell[5682, 178, 972, 30, 31, "Input"],
Cell[6657, 210, 1471, 37, 375, "Output"]
}, Open  ]],
Cell[8143, 250, 62, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[8230, 254, 579, 16, 31, "Input"],
Cell[8812, 272, 1336, 31, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
