(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     38912,       1187]
NotebookOptionsPosition[     34806,       1062]
NotebookOutlinePosition[     35973,       1097]
CellTagsIndexPosition[     35887,       1092]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CrystalChange (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package function)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CrystalChange[lattvec,coord,conf] has options to manipulate a \
crystal structure.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828997-3834481"],

Cell[CellGroupData[{

Cell["Meaning of the arguments:", "Item"],

Cell[CellGroupData[{

Cell["\<\
'lattvec' contains the lattice vectors as a 3x3 array, or as a list of the \
format {lengths, directions}, or {lengths, angles}.\
\>", "Subitem"],

Cell["\<\
\[OpenCurlyQuote]coord\[CloseCurlyQuote] is a list of atom positions given in \
reduced coordinates (in the basis of \[OpenCurlyQuote]lattvec\
\[CloseCurlyQuote]).\
\>", "Subitem"],

Cell["\<\
\[OpenCurlyQuote]conf\[CloseCurlyQuote] is a list of positive non-zero \
integers denoting the atom types, with one entry per atom. (Atoms of type 0 \
are automatically deleted from the structure, negative signs are simply \
dropped.)\
\>", "Subitem"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other input varieties:", "Item"],

Cell["\<\
CrystalChange[lattvec] can be used to change only the lattice vectors.\
\>", "Subitem"]
}, Open  ]],

Cell["\<\
CrystalChange returns {lattvec,coord,conf} after applying changes to the \
respective input values as specified via optional arguments (see list of \
options below).\
\>", "Item"],

Cell["\<\
CrystalChange automatically recognizes two-dimensional structures. Some \
options only work for 3D structures.\
\>", "Item"],

Cell["\<\
Numbers in cartesian coordinates (lattice vectors, atom coordinates in \
molecules, distances in options, etc.) are always assumed to be in Angstrom, \
never in Bohr or pm.\
\>", "Item"],

Cell[TextData[{
 "CrystalChange accepts the following options:\n",
 ButtonBox["Acell",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Acell"],
 " \[Dash] ",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"],
 " \[Dash] ",
 ButtonBox["CenterAtOriginQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CenterAtOriginQ"],
 " \[Dash] ",
 ButtonBox["MoveOrigin",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/MoveOrigin"],
 " \[Dash] ",
 ButtonBox["NewbasisQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/NewbasisQ"],
 " \[Dash] ",
 ButtonBox["Reshape",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Reshape"],
 " \[Dash] ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " \[Dash] ",
 ButtonBox["SortQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/SortQ"],
 " \[Dash] ",
 ButtonBox["Sysdim",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"]
}], "Item"],

Cell["\<\
Printed debugging notes are available by setting $CrystallicaDebugQ=True \
before evaluating CrystalChange, re-loading of the package is not necessary.\
\>", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Use CrystalChange to convert lattice vectors from lengths and angles to the \
standard notation:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalChange", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"60", ",", "60", ",", "90"}], "}"}]}], "}"}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.`", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2.`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.9999999999999996`", ",", "1.9999999999999993`", ",", 
     "2.8284271247461907`"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Build a 2x2x2 supercell:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"Sysdim", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "6", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.25`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.25`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.5`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.75`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.75`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.25`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.25`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.75`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.75`", ",", "0.75`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2",
      ",", "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", "1", 
     ",", "2"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Delete atoms by setting their type to 0:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5.4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "5.4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".24", ",", ".24", ",", ".24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".24", ",", ".76", ",", ".76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".76", ",", ".24", ",", ".76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".76", ",", ".76", ",", ".24"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "2", ",", "0", ",", "3", ",", "0", ",", "3", ",", 
     "3"}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.4`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5.4`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "5.4`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.5`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.24`", ",", "0.24`", ",", "0.24`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.76`", ",", "0.24`", ",", "0.76`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.76`", ",", "0.76`", ",", "0.24`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Build a 2x2x2 supercell and sort the atoms by type for convenience:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"Sysdim", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], ",", 
   RowBox[{"SortQ", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "6", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.5`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.25`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.25`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.75`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.75`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.25`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.25`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.75`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.75`", ",", "0.75`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
     ",", "2"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Build a 2x2 supercell in 2D:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"Sysdim", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.25`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "0.75`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", 
     "2"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
For troubleshooting or just out of curiosity: Watch the inner workings of \
CrystalChange with the $CrystallicaDebugQ switch:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CrystallicaDebugQ", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CrystalChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", ".3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".7", ",", ".7", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".2", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".8", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"SortQ", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CrystallicaDebugQ", "=", "False"}], ";"}]}], "Input",
 CellContext->"Global`"],

Cell[CellGroupData[{

Cell[BoxData["\<\"CrystalChange :: Entering function \
CrystalChange[rawlattvec,coord,conf,rawoptions] with the following input \
values:\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\trawlattvec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: \trawlattvec = ", {{4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\tcoord = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: \tcoord = ", {{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {
    0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\tconf = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["CrystalChange :: \tconf = ", {1, 1, 2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\trawoptions = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"SortQ", "\[Rule]", "True"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: \trawoptions = ", {
   Crystallica`AddQ -> True, Crystallica`SortQ -> True}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom coordinates after length matching safety \
net are \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom coordinates after length matching safety net are ", \
{{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {
    0.2, 0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom types after length matching safety net \
are \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom types after length matching safety net are ", {1, 1, 
   2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom coordinates after type-zero deletion are \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom coordinates after type-zero deletion are ", {{0, 0, 
    0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 
    0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom types after type-zero deletion are \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom types after type-zero deletion are ", {1, 1, 2, 2, 2,
    2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Lattice vectors converted to standard \
notation \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Lattice vectors converted to standard notation ", {{
    4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Check for 2D structure yielded \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm["CrystalChange :: Check for 2D structure yielded ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for Sysdim resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for Sysdim resolved to ", {1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for MoveOrigin resolved to \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for MoveOrigin resolved to ", {0, 0, 0}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for Reshape resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for Reshape resolved to ", {{1, 0, 0}, {0, 1,
    0}, {0, 0, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Forced switch-ON for RetractQ option is \"\>",
    "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Forced switch-ON for RetractQ option is ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for RetractQ resolved to \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value for RetractQ resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option Sysdim changed atom coordinates to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option Sysdim changed atom coordinates to ", {{0, 0, 0}, {
    0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 
    0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option Sysdim changed atom types to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option Sysdim changed atom types to ", {1, 1, 2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for CenterAtOriginQ resolved to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for CenterAtOriginQ resolved to ", {
   False, False, False}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value AddQ->\\\"hexa\\\" resolved to \
\"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value AddQ->\"hexa\" resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value AddQ->\\\"surfacecut\\\" \
resolved to \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value AddQ->\"surfacecut\" resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Forced switch-OFF for AddQ option is \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Forced switch-OFF for AddQ option is ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for AddQ resolved to \"\>", 
   "\[InvisibleSpace]", "True"}],
  SequenceForm["CrystalChange :: Option value for AddQ resolved to ", True],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for AddQ resolved to addition \
tolerances \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.1`", ",", "0.1`", ",", "0.1`"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for AddQ resolved to addition tolerances ", {
   0.1, 0.1, 0.1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option AddQ changed atom coordinates to \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option AddQ changed atom coordinates to ", {{0, 0, 0}, {
    0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 
    0.5}, {1, 0, 0}, {0, 1, 0}, {1, 1, 0}, {0, 0, 1}, {0.3, 0.3, 1}, {
    0.7, 0.7, 1}, {1, 0, 1}, {0, 1, 1}, {1, 1, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option AddQ changed atom types to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1"}], 
    "}"}]}],
  SequenceForm[
  "CrystalChange :: Option AddQ changed atom types to ", {1, 1, 2, 2, 2, 2, 1,
    1, 1, 1, 2, 2, 1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for NewbasisQ resolved to \"\>", 
   "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "CrystalChange :: Option value for NewbasisQ resolved to ", True],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option NewbasisQ changed lattice vectors to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option NewbasisQ changed lattice vectors to ", {{
    4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option NewbasisQ changed atom coordinates to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7000000000000001`", ",", "0.7000000000000001`", ",", "0.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7000000000000001`", ",", "0.7000000000000001`", ",", "1.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option NewbasisQ changed atom coordinates to ", \
CompressedData["
1:eJxTTMoPSmViYGDgB2JmBkLggT06bQwGl+E0TGV6Ggg8s4fRMPFZM0HgpT2E
Pgk3B8aHyaPa8wGuHztAl/9AtD7s7v9gj939uMwlZD8mDQDM5EHf
   "]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for Acell resolved to \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["CrystalChange :: Option value for Acell resolved to ", 0],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for SortQ resolved to \"\>", 
   "\[InvisibleSpace]", "True"}],
  SequenceForm["CrystalChange :: Option value for SortQ resolved to ", True],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option SortQ changed atom coordinates to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7000000000000001`", ",", "0.7000000000000001`", ",", "0.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7000000000000001`", ",", "0.7000000000000001`", ",", "1.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option SortQ changed atom coordinates to ", \
CompressedData["
1:eJxTTMoPSmViYGDgB2JmBlLBB3v8fHRxGP0AB01IPy7zCMvPmgkCJ6H0S7i9
xmBwGU7DTMAu/sE+PQ0EnsFpmHrs4h/g9sHsh9kLAPPHQd8=
   "]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option SortQ changed atom types to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2"}], 
    "}"}]}],
  SequenceForm[
  "CrystalChange :: Option SortQ changed atom types to ", {1, 1, 1, 1, 1, 1, 
   1, 1, 1, 2, 2, 2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CrystalChange :: Exiting function CrystalChange and \
returning to calling function or to user.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7000000000000001`", ",", "0.7000000000000001`", ",", "0.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7000000000000001`", ",", "0.7000000000000001`", ",", "1.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2"}], 
    "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1520, 805},
WindowMargins->{{6, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "CrystalChange[lattvec,coord,conf] has options to manipulate a crystal \
structure.", "synonyms" -> {}, "title" -> "CrystalChange", "type" -> "Symbol",
     "uri" -> "Crystallica/ref/CrystalChange"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828997-3834481"->{
  Cell[757, 30, 186, 3, 40, "Print",
   CellTags->"Info3569828997-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828997-3834481", 35786, 1086}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 175, 6, 70, "Section"],
Cell[757, 30, 186, 3, 40, "Print",
 CellTags->"Info3569828997-3834481"],
Cell[CellGroupData[{
Cell[968, 37, 41, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1034, 41, 155, 3, 25, "Subitem"],
Cell[1192, 46, 190, 4, 25, "Subitem"],
Cell[1385, 52, 261, 5, 25, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[1695, 63, 38, 0, 29, "Item"],
Cell[1736, 65, 97, 2, 25, "Subitem"]
}, Open  ]],
Cell[1848, 70, 189, 4, 29, "Item"],
Cell[2040, 76, 134, 3, 29, "Item"],
Cell[2177, 81, 196, 4, 29, "Item"],
Cell[2376, 87, 1029, 37, 45, "Item"],
Cell[3408, 126, 175, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[3608, 133, 30, 0, 49, "Subsection"],
Cell[3641, 135, 33, 0, 30, "Text"],
Cell[3677, 137, 102, 2, 31, "Input"],
Cell[3782, 141, 120, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[3927, 148, 263, 8, 31, "Input"],
Cell[4193, 158, 329, 10, 31, "Output"]
}, Open  ]],
Cell[4537, 171, 40, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[4602, 175, 700, 22, 31, "Input"],
Cell[5305, 199, 1890, 49, 72, "Output"]
}, Open  ]],
Cell[7210, 251, 56, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[7291, 255, 1138, 33, 52, "Input"],
Cell[8432, 290, 955, 27, 31, "Output"]
}, Open  ]],
Cell[9402, 320, 91, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[9518, 326, 747, 23, 31, "Input"],
Cell[10268, 351, 1890, 49, 72, "Output"]
}, Open  ]],
Cell[12173, 403, 44, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[12242, 407, 576, 20, 31, "Input"],
Cell[12821, 429, 943, 30, 31, "Output"]
}, Open  ]],
Cell[13779, 462, 149, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[13953, 469, 1221, 34, 72, "Input"],
Cell[CellGroupData[{
Cell[15199, 507, 153, 2, 23, "Print"],
Cell[15355, 511, 494, 13, 23, "Print"],
Cell[15852, 526, 796, 20, 23, "Print"],
Cell[16651, 548, 295, 6, 23, "Print"],
Cell[16949, 556, 386, 10, 23, "Print"],
Cell[17338, 568, 887, 22, 23, "Print"],
Cell[18228, 592, 381, 9, 23, "Print"],
Cell[18612, 603, 874, 22, 23, "Print"],
Cell[19489, 627, 367, 9, 23, "Print"],
Cell[19859, 638, 564, 15, 23, "Print"],
Cell[20426, 655, 244, 5, 23, "Print"],
Cell[20673, 662, 316, 8, 23, "Print"],
Cell[20992, 672, 324, 8, 23, "Print"],
Cell[21319, 682, 535, 15, 23, "Print"],
Cell[21857, 699, 265, 6, 23, "Print"],
Cell[22125, 707, 261, 6, 23, "Print"],
Cell[22389, 715, 866, 22, 23, "Print"],
Cell[23258, 739, 355, 8, 23, "Print"],
Cell[23616, 749, 360, 9, 23, "Print"],
Cell[23979, 760, 267, 6, 23, "Print"],
Cell[24249, 768, 279, 6, 23, "Print"],
Cell[24531, 776, 259, 6, 23, "Print"],
Cell[24793, 784, 248, 5, 23, "Print"],
Cell[25044, 791, 369, 9, 23, "Print"],
Cell[25416, 802, 1645, 41, 43, "Print"],
Cell[27064, 845, 488, 12, 23, "Print"],
Cell[27555, 859, 261, 6, 23, "Print"],
Cell[27819, 867, 558, 15, 23, "Print"],
Cell[28380, 884, 1709, 44, 43, "Print"],
Cell[30092, 930, 244, 5, 23, "Print"],
Cell[30339, 937, 250, 5, 23, "Print"],
Cell[30592, 944, 1697, 44, 43, "Print"],
Cell[32292, 990, 490, 12, 23, "Print"],
Cell[32785, 1004, 129, 1, 23, "Print"]
}, Open  ]],
Cell[32929, 1008, 1837, 49, 109, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
