(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    259485,       5996]
NotebookOptionsPosition[    251770,       5773]
NotebookOutlinePosition[    252915,       5808]
CellTagsIndexPosition[    252828,       5803]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CrystalPlot (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package function)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CrystalPlot[lattvec,coord,conf] plots a crystal \
structure.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828984-3834481"],

Cell[CellGroupData[{

Cell["Meaning of the arguments:", "Item"],

Cell[CellGroupData[{

Cell["\<\
'lattvec' contains the lattice vectors as a 3x3 array, or as a list of the \
format {lengths, directions}, or {lengths, angles}.\
\>", "Subitem"],

Cell["\<\
\[OpenCurlyQuote]coord\[CloseCurlyQuote] is a list of atom positions given in \
reduced coordinates (in the basis of \[OpenCurlyQuote]lattvec\
\[CloseCurlyQuote]).\
\>", "Subitem"],

Cell["\<\
\[OpenCurlyQuote]conf\[CloseCurlyQuote] is a list of  positive non-zero \
integers denoting the atom types, with one entry per atom. (Atoms of type 0 \
are automatically deleted from the structure, negative signs are simply \
dropped.)\
\>", "Subitem"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other input varieties:", "Item"],

Cell[CellGroupData[{

Cell["\<\
CrystalPlot[lattvec] plots the cell outlines, but no atoms (atom-related \
options will be ignored in this case).\
\>", "Subitem"],

Cell["\<\
CrystalPlot[coord,conf] assumes that \[OpenCurlyQuote]coord\[CloseCurlyQuote] \
are cartesian; this version can be used for molecules (lattice-related \
options will be ignored in this case).\
\>", "Subitem"]
}, Open  ]]
}, Open  ]],

Cell["\<\
CrystalPlot returns a Graphics3D object which can be combined with other \
plots using Show.\
\>", "Item"],

Cell["\<\
CrystalPlot automatically recognizes two-dimensional structures and returns a \
Graphics object. Some options only work for 3D structures.\
\>", "Item"],

Cell["\<\
Numbers in cartesian coordinates (lattice vectors, atom coordinates in \
molecules, distances in options, etc.) are always assumed to be in Angstrom, \
never in Bohr or pm.\
\>", "Item"],

Cell["\<\
Printed debugging notes are available by setting $CrystallicaDebugQ=True \
before evaluating CrystalPlot, re-loading of the package is not necessary.\
\>", "Item"],

Cell[CellGroupData[{

Cell["Options", "Subsection"],

Cell[TextData[{
 "CrystalPlot accepts all options of Graphics3D. Unless otherwise specified \
by the user, the following options are set differently from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s default:\n\
{Boxed\[Rule]False,SphericalRegion\[Rule]True,Lighting\[Rule]\
\[CloseCurlyDoubleQuote]Neutral\[CloseCurlyDoubleQuote],BaseStyle\[Rule]{\
Specularity[Gray,100]}"
}], "Item"],

Cell[CellGroupData[{

Cell["Additionally, the following options are supported:", "Item"],

Cell[CellGroupData[{

Cell["Basic options:", "Subitem"],

Cell[CellGroupData[{

Cell[TextData[{
 "Cell manipualtion:\n",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"],
 " \[Dash] ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " \[Dash] ",
 ButtonBox["SortQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/SortQ"],
 " \[Dash] ",
 ButtonBox["Sysdim",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"]
}], "Subsubitem"],

Cell[TextData[{
 "Layout:\n",
 ButtonBox["AtomCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomCol"],
 " \[Dash] ",
 ButtonBox["AtomRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomRad"],
 " \[Dash] ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 " \[Dash] ",
 ButtonBox["BondDist ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 "\[Dash] ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 " \[Dash] ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 " \[Dash] ",
 ButtonBox["CellLineCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineCol"],
 " \[Dash] ",
 ButtonBox["CellLineRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineRad"],
 " \[Dash] ",
 ButtonBox["CellLineStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineStyle"]
}], "Subsubitem"]
}, Open  ]],

Cell["Advanced options:", "Subitem"],

Cell[CellGroupData[{

Cell[TextData[{
 "Cell manipualtion:\n",
 ButtonBox["Acell",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Acell"],
 " \[Dash] ",
 ButtonBox["ButtonQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ButtonQ"],
 " \[Dash] ",
 ButtonBox["CenterAtOriginQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CenterAtOriginQ"],
 " \[Dash] ",
 ButtonBox["MoveOrigin",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/MoveOrigin"],
 " \[Dash] ",
 ButtonBox["NewbasisQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/NewbasisQ"],
 " \[Dash] ",
 ButtonBox["Reshape",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Reshape"]
}], "Subsubitem"],

Cell[TextData[{
 "Layout:\[LineSeparator]",
 ButtonBox["AtomFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomFunction"],
 " \[Dash] ",
 ButtonBox["BondRadScaledQ ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 "\[Dash] ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 " \[Dash] ",
 ButtonBox["BondsFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 " \[Dash] ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 " \[Dash] ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 " \[Dash] ",
 ButtonBox["CellLinesAdd",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesAdd"],
 " \[Dash] ",
 ButtonBox["CellLinesFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"],
 " \[Dash] ",
 ButtonBox["LatticePlanes",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/LatticePlanes"],
 " \[Dash] ",
 ButtonBox["PolyMode",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/PolyMode"],
 " \[Dash] ",
 ButtonBox["PolyStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/PolyStyle"],
 " \[Dash] ",
 ButtonBox["Pseudo3DQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Pseudo3DQ"]
}], "Subsubitem"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
When option values contain colours, the following types of input are \
supported:\
\>", "Item"],

Cell[CellGroupData[{

Cell[TextData[{
 "anything that always works in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", e.g. Red, Green, RGBColor[1,0,0], CMYKColor[1,0,1], Hue[0.7], and so forth"
}], "Subitem"],

Cell["\<\
members of ColorData[\"Legacy\"] can be given by name only, e.g. \
\[OpenCurlyDoubleQuote]TerreVerte\[CloseCurlyDoubleQuote]\
\>", "Subitem"],

Cell["symbols for chemical species, e.g. \[OpenCurlyDoubleQuote]Fe\
\[CloseCurlyDoubleQuote]", "Subitem"],

Cell["\<\
Some options also recognize colour schemes from ColorData[\"Gradients\"] or \
ColorData[\[OpenCurlyDoubleQuote]Indexed\[CloseCurlyDoubleQuote]] and \
interpret them in a suitable way.\
\>", "Subitem"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Plot a crystal structure:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", ".3", ",", ".3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", ".6", ",", ".6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 3, 3}, {3, 3, 6}, {3, 0, 3}, {0, 0, 0}}, {{3, 3,
       0}, {3, 6, 3}, {6, 6, 6}, {6, 3, 3}, {3, 3, 0}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 3, 0}}, {{0, 3, 3}, {3, 6, 3}}, {{3, 3, 6}, {6, 
      6, 6}}, {{3, 0, 3}, {6, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.577873349740851, 2.577873349740851}, {0., 
       2.577873349740851, 2.577873349740851}, {0, 3, 3}}, {
      0.021, 0.021, 0.1492443084589032, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.577873349740851, 0., 2.577873349740851}, {
       2.577873349740851, 0., 2.577873349740851}, {3, 0, 3}}, {
      0.021, 0.021, 0.1492443084589032, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.577873349740851, 2.577873349740851, 0.}, {
       2.577873349740851, 2.577873349740851, 0.}, {3, 3, 0}}, {
      0.021, 0.021, 0.1492443084589032, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[
       SphereBox[{1.7999999999999998`, 1.7999999999999998`, 
        1.7999999999999998`}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[
       SphereBox[{3.5999999999999996`, 3.5999999999999996`, 
        3.5999999999999996`}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Add some custom options:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", ".3", ",", ".3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", ".6", ",", ".6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"AtomCol", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Pd\>\"", ",", "\"\<O\>\""}], "}"}]}], ",", 
   RowBox[{"AtomRad", "->", 
    RowBox[{"{", 
     RowBox[{".4", ",", ".6"}], "}"}]}], ",", 
   RowBox[{"BondStyle", "\[Rule]", "0"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "3.5"}], ",", 
   RowBox[{"BondCol", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".7", "]"}]}], ",", 
   RowBox[{"AddQ", "->", "True"}], ",", 
   RowBox[{"CellLineCol", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".2", "]"}]}], ",", 
   RowBox[{"CellLineRad", "\[Rule]", ".04"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0.2], 
     TubeBox[{{{0, 0, 0}, {0, 3, 3}, {3, 3, 6}, {3, 0, 3}, {0, 0, 0}}, {{3, 3,
       0}, {3, 6, 3}, {6, 6, 6}, {6, 3, 3}, {3, 3, 0}}}, 0.04]}, 
    {GrayLevel[0.2], 
     TubeBox[{{{0, 0, 0}, {3, 3, 0}}, {{0, 3, 3}, {3, 6, 3}}, {{3, 3, 6}, {6, 
      6, 6}}, {{3, 0, 3}, {6, 3, 3}}}, 0.04]}}, {
    {GrayLevel[0.2], 
     TubeBox[{{0, 0, 0}, {0., 2.4101724520304417`, 2.4101724520304417`}, {0., 
       2.4101724520304417`, 2.4101724520304417`}, {0, 3, 3}}, {
      0.041, 0.041, 0.2085355294499541, 0}]}, 
    {GrayLevel[0.2], 
     TubeBox[{{0, 0, 0}, {2.4101724520304417`, 0., 2.4101724520304417`}, {
       2.4101724520304417`, 0., 2.4101724520304417`}, {3, 0, 3}}, {
      0.041, 0.041, 0.2085355294499541, 0}]}, 
    {GrayLevel[0.2], 
     TubeBox[{{0, 0, 0}, {2.4101724520304417`, 2.4101724520304417`, 0.}, {
       2.4101724520304417`, 2.4101724520304417`, 0.}, {3, 3, 0}}, {
      0.041, 0.041, 0.2085355294499541, 0}]}}, 
   {GrayLevel[0.7], 
    TubeBox[{{0., 0., 0.}, {1.7999999999999998`, 1.7999999999999998`, 
     1.7999999999999998`}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{1.7999999999999998`, 1.7999999999999998`, 
     1.7999999999999998`}, {3.5999999999999996`, 3.5999999999999996`, 
     3.5999999999999996`}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{1.7999999999999998`, 1.7999999999999998`, 
     1.7999999999999998`}, {0., 3., 3.}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{1.7999999999999998`, 1.7999999999999998`, 
     1.7999999999999998`}, {3., 0., 3.}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{1.7999999999999998`, 1.7999999999999998`, 
     1.7999999999999998`}, {3., 3., 0.}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{3.5999999999999996`, 3.5999999999999996`, 
     3.5999999999999996`}, {3., 3., 6.}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{3.5999999999999996`, 3.5999999999999996`, 
     3.5999999999999996`}, {3., 6., 3.}}, 0.15]}, 
   {GrayLevel[0.7], 
    TubeBox[{{3.5999999999999996`, 3.5999999999999996`, 
     3.5999999999999996`}, {6., 3., 3.}}, 0.15]}, 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{0, 0, 0}, 0.4],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[
       SphereBox[{1.7999999999999998`, 1.7999999999999998`, 
        1.7999999999999998`}, 0.6],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[
       SphereBox[{3.5999999999999996`, 3.5999999999999996`, 
        3.5999999999999996`}, 0.6],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{0, 3, 3}, 0.4],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{3, 0, 3}, 0.4],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{3, 3, 6}, 0.4],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{3, 3, 0}, 0.4],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{3, 6, 3}, 0.4],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{6, 3, 3}, 0.4],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0., 0.420615, 0.525231], 
      TagBox[SphereBox[{6, 6, 6}, 0.4],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Bonds-only style with some fancy options:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5.4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "5.4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".24", ",", ".24", ",", ".24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".24", ",", ".76", ",", ".76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".76", ",", ".24", ",", ".76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".76", ",", ".76", ",", ".24"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", 
     "3"}], "}"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<YellowGreen\>\"", ",", "White", ",", "\"\<Firebrick\>\""}], 
     "}"}]}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "0"}], ",", 
   RowBox[{"BondStyle", "\[Rule]", "2"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "3"}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "False"}], ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "}"}]}], 
   ",", 
   RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, TubeBox[{{0., 0., 0.}, {0., 0., 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 0., 0.}, {0., 2.7, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 0., 0.}, {2.7, 0., 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 0., 0.}, {1.296, 1.296, 1.296}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}}], 
   TubeBox[{{0., 0., 2.7}, {1.296, 1.296, 1.296}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}}], 
   TubeBox[{{0., 0., 2.7}, {0., 0., 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{0., 2.7, 0.}, {1.296, 1.296, 1.296}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}}], 
   TubeBox[{{0., 2.7, 0.}, {0., 5.4, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{2.7, 0., 0.}, {1.296, 1.296, 1.296}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}}], 
   TubeBox[{{2.7, 0., 0.}, {5.4, 0., 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{1.296, 4.104, 4.104}, {0., 5.4, 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{1.296, 4.104, 4.104}, {0., 2.7, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{1.296, 4.104, 4.104}, {0., 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{1.296, 4.104, 4.104}, {2.7, 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{4.104, 1.296, 4.104}, {5.4, 0., 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{4.104, 1.296, 4.104}, {2.7, 0., 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{4.104, 1.296, 4.104}, {5.4, 0., 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{4.104, 1.296, 4.104}, {5.4, 2.7, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{4.104, 4.104, 1.296}, {5.4, 2.7, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{4.104, 4.104, 1.296}, {2.7, 5.4, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{4.104, 4.104, 1.296}, {5.4, 5.4, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{4.104, 4.104, 1.296}, {5.4, 5.4, 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.698004, 0.133305, 0.133305]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{5.4, 0., 0.}, {5.4, 0., 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{5.4, 0., 0.}, {5.4, 2.7, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{5.4, 0., 2.7}, {5.4, 0., 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{5.4, 2.7, 0.}, {5.4, 5.4, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{0., 5.4, 0.}, {0., 5.4, 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 5.4, 0.}, {2.7, 5.4, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 5.4, 2.7}, {0., 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{2.7, 5.4, 0.}, {5.4, 5.4, 0.}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{5.4, 5.4, 0.}, {5.4, 5.4, 2.7}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{5.4, 5.4, 2.7}, {5.4, 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{0., 0., 5.4}, {0., 2.7, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 0., 5.4}, {2.7, 0., 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{0., 2.7, 5.4}, {0., 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{2.7, 0., 5.4}, {5.4, 0., 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{5.4, 0., 5.4}, {5.4, 2.7, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{5.4, 2.7, 5.4}, {5.4, 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TubeBox[{{0., 5.4, 5.4}, {2.7, 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}}], TubeBox[{{2.7, 5.4, 5.4}, {5.4, 5.4, 5.4}}, 0.15,
    VertexColors->{{
       Specularity[
        GrayLevel[0.5], 100], 
       GrayLevel[1]}, {
       Specularity[
        GrayLevel[0.5], 100], 
       RGBColor[0.6039, 0.803903, 0.196097]}}], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{0., 0., 0.}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{0., 0., 2.7}, 0],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{0., 2.7, 0.}, 0],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{2.7, 0., 0.}, 0],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{1.296, 1.296, 1.296}, 0],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{1.296, 4.104, 4.104}, 0],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4.104, 1.296, 4.104}, 0],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4.104, 4.104, 1.296}, 0],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{5.4, 0., 0.}, 0],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{5.4, 0., 2.7}, 0],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{5.4, 2.7, 0.}, 0],
       "Ball"]},
     "11"],
    Annotation[#, 11, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{0., 5.4, 0.}, 0],
       "Ball"]},
     "12"],
    Annotation[#, 12, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{0., 5.4, 2.7}, 0],
       "Ball"]},
     "13"],
    Annotation[#, 13, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{2.7, 5.4, 0.}, 0],
       "Ball"]},
     "14"],
    Annotation[#, 14, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{5.4, 5.4, 0.}, 0],
       "Ball"]},
     "15"],
    Annotation[#, 15, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{5.4, 5.4, 2.7}, 0],
       "Ball"]},
     "16"],
    Annotation[#, 16, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{0., 0., 5.4}, 0],
       "Ball"]},
     "17"],
    Annotation[#, 17, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{0., 2.7, 5.4}, 0],
       "Ball"]},
     "18"],
    Annotation[#, 18, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{2.7, 0., 5.4}, 0],
       "Ball"]},
     "19"],
    Annotation[#, 19, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{5.4, 0., 5.4}, 0],
       "Ball"]},
     "20"],
    Annotation[#, 20, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{5.4, 2.7, 5.4}, 0],
       "Ball"]},
     "21"],
    Annotation[#, 21, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{0., 5.4, 5.4}, 0],
       "Ball"]},
     "22"],
    Annotation[#, 22, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[1], 
      TagBox[SphereBox[{2.7, 5.4, 5.4}, 0],
       "Ball"]},
     "23"],
    Annotation[#, 23, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6039, 0.803903, 0.196097], 
      TagBox[SphereBox[{5.4, 5.4, 5.4}, 0],
       "Ball"]},
     "24"],
    Annotation[#, 24, "Tooltip"]& ]},
  Background->GrayLevel[0],
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->{{"Directional", 
     GrayLevel[1], 
     ImageScaled[{0, 0, 1}]}},
  SphericalRegion->True]], "Output",ImageCache->GraphicsData[\
"CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Specify the lattice vectors in alternative formats:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "60", ",", "90"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], "}"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 2, 0}, {0, 2, 0}, {0, 0, 0}}, {{0, 
        0, 4}, {3, 0, 4}, {3, 2, 4}, {0, 2, 4}, {0, 0, 4}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{3, 0, 0}, {3, 0, 4}}, {{3, 2, 0}, {
        3, 2, 4}}, {{0, 2, 0}, {0, 2, 4}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 1.4980039840795547`, 0.}, {0., 
         1.4980039840795547`, 0.}, {0, 2, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 3.4980039840795545`}, {0., 0., 
         3.4980039840795545`}, {0, 0, 4}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {3., 0., 0.}, {3., 2., 0.}, {0., 2., 0.}, {0., 
        0., 0.}}, {{1.9999999999999996`, 1.9999999999999993`, 
        2.8284271247461907`}, {5., 1.9999999999999993`, 
        2.8284271247461907`}, {5., 3.999999999999999, 2.8284271247461907`}, {
        1.9999999999999996`, 3.999999999999999, 2.8284271247461907`}, {
        1.9999999999999996`, 1.9999999999999993`, 2.8284271247461907`}}}, 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {1.9999999999999996`, 1.9999999999999993`, 
        2.8284271247461907`}}, {{3., 0., 0.}, {5., 1.9999999999999993`, 
        2.8284271247461907`}}, {{3., 2., 0.}, {5., 3.999999999999999, 
        2.8284271247461907`}}, {{0., 2., 0.}, {1.9999999999999996`, 
        3.999999999999999, 2.8284271247461907`}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3., 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 1.4980039840795547`, 0.}, {0., 
         1.4980039840795547`, 0.}, {0, 2., 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.749001992039777, 1.7490019920397768`, 
         2.4734623377602136`}, {1.749001992039777, 1.7490019920397768`, 
         2.4734623377602136`}, {1.9999999999999996`, 1.9999999999999993`, 
         2.8284271247461907`}}, {0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Plot a molecule by omitting the lattice vector argument and specifying \
cartesian atom coordinates instead:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".69", ",", ".13", ",", 
       RowBox[{"-", ".29"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".69"}], ",", 
       RowBox[{"-", ".13"}], ",", ".29"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.46", ",", 
       RowBox[{"-", ".41"}], ",", ".31"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".72", ",", 
       RowBox[{"-", ".23"}], ",", 
       RowBox[{"-", "1.35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".91", ",", "1.22", ",", 
       RowBox[{"-", ".26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.46"}], ",", ".41", ",", 
       RowBox[{"-", ".30"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".72"}], ",", ".23", ",", "1.35"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".91"}], ",", 
       RowBox[{"-", "1.22"}], ",", ".26"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"AtomRad", "->", ".4"}], ",", 
   RowBox[{"BondDist", "\[Rule]", "1.7"}], ",", 
   RowBox[{"AtomCol", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<C\>\"", ",", "\"\<H\>\""}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{0.69, 0.13, -0.29}, {0., 0., 0.}}, 0.15]}, 
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{-0.69, -0.13, 0.29}, {0., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{0.69, 0.13, -0.29}, {1.075, -0.13999999999999999`, 
      0.010000000000000009`}}, 0.15]}, 
    {RGBColor[0.65, 0.7, 0.7], 
     TubeBox[{{1.46, -0.41, 0.31}, {1.075, -0.13999999999999999`, 
      0.010000000000000009`}}, 0.15]}}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{0.69, 0.13, -0.29}, {0.705, -0.05, -0.8200000000000001}}, 
      0.15]}, 
    {RGBColor[0.65, 0.7, 0.7], 
     TubeBox[{{0.72, -0.23, -1.35}, {0.705, -0.05, -0.8200000000000001}}, 
      0.15]}}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{0.69, 0.13, -0.29}, {0.8, 0.675, -0.275}}, 0.15]}, 
    {RGBColor[0.65, 0.7, 0.7], 
     TubeBox[{{0.91, 1.22, -0.26}, {0.8, 0.675, -0.275}}, 0.15]}}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{-0.69, -0.13, 0.29}, {-1.075, 
      0.13999999999999999`, -0.0050000000000000044`}}, 0.15]}, 
    {RGBColor[0.65, 0.7, 0.7], 
     TubeBox[{{-1.46, 0.41, -0.3}, {-1.075, 
      0.13999999999999999`, -0.0050000000000000044`}}, 0.15]}}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{-0.69, -0.13, 0.29}, {-0.705, 0.05, 0.8200000000000001}}, 
      0.15]}, 
    {RGBColor[0.65, 0.7, 0.7], 
     TubeBox[{{-0.72, 0.23, 1.35}, {-0.705, 0.05, 0.8200000000000001}}, 
      0.15]}}, {
    {RGBColor[0.4, 0.4, 0.4], 
     TubeBox[{{-0.69, -0.13, 0.29}, {-0.8, -0.675, 0.275}}, 0.15]}, 
    {RGBColor[0.65, 0.7, 0.7], 
     TubeBox[{{-0.91, -1.22, 0.26}, {-0.8, -0.675, 0.275}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.4, 0.4, 0.4], 
      TagBox[SphereBox[{0.69, 0.13, -0.29}, 0.4],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.4, 0.4, 0.4], 
      TagBox[SphereBox[{-0.69, -0.13, 0.29}, 0.4],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.65, 0.7, 0.7], 
      TagBox[SphereBox[{1.46, -0.41, 0.31}, 0.4],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.65, 0.7, 0.7], 
      TagBox[SphereBox[{0.72, -0.23, -1.35}, 0.4],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.65, 0.7, 0.7], 
      TagBox[SphereBox[{0.91, 1.22, -0.26}, 0.4],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.65, 0.7, 0.7], 
      TagBox[SphereBox[{-1.46, 0.41, -0.3}, 0.4],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.65, 0.7, 0.7], 
      TagBox[SphereBox[{-0.72, 0.23, 1.35}, 0.4],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.65, 0.7, 0.7], 
      TagBox[SphereBox[{-0.91, -1.22, 0.26}, 0.4],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
CrystalPlot can also display the lattice vectors only; here is an fcc cell \
and its reciprocal space counterpart:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"cell", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "2"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CrystalPlot", "[", "cell", "]"}], ",", 
     RowBox[{"CrystalPlot", "[", 
      RowBox[{"2", "*", "Pi", "*", 
       RowBox[{"Inverse", "[", 
        RowBox[{"cell", "\[Transpose]"}], "]"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {2, 2, 0}, {4, 2, 2}, {2, 0, 2}, {0, 0, 0}}, {{0, 
        2, 2}, {2, 4, 2}, {4, 4, 4}, {2, 2, 4}, {0, 2, 2}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 2, 2}}, {{2, 2, 0}, {2, 4, 2}}, {{4, 2, 2}, {
        4, 4, 4}}, {{2, 0, 2}, {2, 2, 4}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.6553350333449308`, 1.6553350333449308`, 0.}, {
         1.6553350333449308`, 1.6553350333449308`, 0.}, {2, 2, 0}}, {
        0.021, 0.021, 0.12185746757961738`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.6553350333449308`, 0., 1.6553350333449308`}, {
         1.6553350333449308`, 0., 1.6553350333449308`}, {2, 0, 2}}, {
        0.021, 0.021, 0.12185746757961738`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 1.6553350333449308`, 1.6553350333449308`}, {
         0., 1.6553350333449308`, 1.6553350333449308`}, {0, 2, 2}}, {
        0.021, 0.021, 0.12185746757961738`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[NCache[{{{0, 0, 0}, {
           Rational[1, 2] Pi, Rational[1, 2] Pi, Rational[-1, 2] Pi}, {
           Pi, 0, 0}, {
           Rational[1, 2] Pi, Rational[-1, 2] Pi, Rational[1, 2] Pi}, {0, 0, 
           0}}, {{Rational[-1, 2] Pi, Rational[1, 2] Pi, Rational[1, 2] Pi}, {
           0, Pi, 0}, {
           Rational[1, 2] Pi, Rational[1, 2] Pi, Rational[1, 2] Pi}, {
           0, 0, Pi}, {
           Rational[-1, 2] Pi, Rational[1, 2] Pi, Rational[1, 2] Pi}}}, {{{0, 
           0, 0}, {1.5707963267948966`, 
           1.5707963267948966`, -1.5707963267948966`}, {
           3.141592653589793, 0, 0}, {
           1.5707963267948966`, -1.5707963267948966`, 1.5707963267948966`}, {
           0, 0, 0}}, {{-1.5707963267948966`, 1.5707963267948966`, 
           1.5707963267948966`}, {0, 3.141592653589793, 0}, {
           1.5707963267948966`, 1.5707963267948966`, 1.5707963267948966`}, {
           0, 0, 3.141592653589793}, {-1.5707963267948966`, 
           1.5707963267948966`, 1.5707963267948966`}}}], 0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{0, 0, 0}, {
           Rational[-1, 2] Pi, Rational[1, 2] Pi, Rational[1, 2] Pi}}, {{
           Rational[1, 2] Pi, Rational[1, 2] Pi, Rational[-1, 2] Pi}, {
           0, Pi, 0}}, {{Pi, 0, 0}, {
           Rational[1, 2] Pi, Rational[1, 2] Pi, Rational[1, 2] Pi}}, {{
           Rational[1, 2] Pi, Rational[-1, 2] Pi, Rational[1, 2] Pi}, {
           0, 0, Pi}}}, {{{0, 0, 0}, {-1.5707963267948966`, 
           1.5707963267948966`, 1.5707963267948966`}}, {{1.5707963267948966`, 
           1.5707963267948966`, -1.5707963267948966`}, {
           0, 3.141592653589793, 0}}, {{3.141592653589793, 0, 0}, {
           1.5707963267948966`, 1.5707963267948966`, 1.5707963267948966`}}, {{
           1.5707963267948966`, -1.5707963267948966`, 1.5707963267948966`}, {
           0, 0, 3.141592653589793}}}], 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {1.2947898535051616`, 
          1.2947898535051616`, -1.2947898535051616`}, {1.2947898535051616`, 
          1.2947898535051616`, -1.2947898535051616`}, {
          Rational[1, 2] Pi, Rational[1, 2] Pi, Rational[-1, 2] Pi}}, {{0, 0, 
          0}, {1.2947898535051616`, 
          1.2947898535051616`, -1.2947898535051616`}, {1.2947898535051616`, 
          1.2947898535051616`, -1.2947898535051616`}, {1.5707963267948966`, 
          1.5707963267948966`, -1.5707963267948966`}}], {
        0.021, 0.021, 0.11951430873893078`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {1.2947898535051616`, -1.2947898535051616`, 
          1.2947898535051616`}, {1.2947898535051616`, -1.2947898535051616`, 
          1.2947898535051616`}, {
          Rational[1, 2] Pi, Rational[-1, 2] Pi, Rational[1, 2] Pi}}, {{0, 0, 
          0}, {1.2947898535051616`, -1.2947898535051616`, 
          1.2947898535051616`}, {1.2947898535051616`, -1.2947898535051616`, 
          1.2947898535051616`}, {1.5707963267948966`, -1.5707963267948966`, 
          1.5707963267948966`}}], {0.021, 0.021, 0.11951430873893078`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {-1.2947898535051616`, 1.2947898535051616`, 
          1.2947898535051616`}, {-1.2947898535051616`, 1.2947898535051616`, 
          1.2947898535051616`}, {
          Rational[-1, 2] Pi, Rational[1, 2] Pi, Rational[1, 2] Pi}}, {{0, 0, 
          0}, {-1.2947898535051616`, 1.2947898535051616`, 
          1.2947898535051616`}, {-1.2947898535051616`, 1.2947898535051616`, 
          1.2947898535051616`}, {-1.5707963267948966`, 1.5707963267948966`, 
          1.5707963267948966`}}], {0.021, 0.021, 0.11951430873893078`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Use the Epilog option to add a label:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"3", "*", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<test structure\>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Center", ",", "Top"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Center", ",", "Top"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Epilog->InsetBox[
    BoxData[
     FormBox[
      StyleBox["\"test structure\"", Bold, 16, StripOnInput -> False], 
      TraditionalForm]], {Center, Top}, {Center, Top}],
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["CrystalPlot can also handle 2D structures:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], Thickness[0.01], 
    LineBox[{{0, 0}, {3, 3}, {3, 6}, {0, 3}, {0, 0}}]}, {
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     ArrowBox[{{0, 0}, {3, 3}}]}, 
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     ArrowBox[{{0, 0}, {0, 3}}]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{0., 0.}, {0.30000000000000004`, 0.9000000000000001}}]}}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{0.6000000000000001, 1.8000000000000003`}, {
       0.30000000000000004`, 0.9000000000000001}}]}}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{0.6000000000000001, 1.8000000000000003`}, {1.2, 2.55}}]}}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{1.7999999999999998`, 3.3}, {1.2, 2.55}}]}}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[DiskBox[{0.6000000000000001, 1.8000000000000003`}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[DiskBox[{1.7999999999999998`, 3.3}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]}]], "Output"]
}, Open  ]],

Cell["\<\
For troubleshooting or just out of curiosity: Watch the inner workings of \
CrystalPlot with the $CrystallicaDebugQ switch:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CrystallicaDebugQ", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", ".3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".7", ",", ".7", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".2", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".8", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Ti\>\"", ",", "\"\<O\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CrystallicaDebugQ", "=", "False"}], ";"}]}], "Input",
 CellContext->"Global`"],

Cell[CellGroupData[{

Cell[BoxData["\<\"CrystalPlot :: Entering function \
CrystalPlot[lattvec,coord,conf,rawoptions] with the following input values:\"\
\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: \\tlattvec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: \tlattvec = ", {{4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: \\tcoord = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: \tcoord = ", {{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {
    0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: \\tconf = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["CrystalPlot :: \tconf = ", {1, 1, 2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: \\trawoptions = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\<\"Ti\"\>", ",", "\<\"O\"\>"}], "}"}]}]}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: \trawoptions = ", {
   Crystallica`AddQ -> True, Crystallica`AtomCol -> {"Ti", "O"}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Colour parsing led to refined options \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.74902, 0.760784, 0.780392], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.4993466666666667, 0.5071893333333334, 0.5202613333333334],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None],
           "RGBColor[0.74902, 0.760784, 0.780392]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.74902, 0.760784, 0.780392]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.74902, 0.760784, 0.780392],
         Editable->False,
         Selectable->False], ",", 
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.800498, 0.201504, 0.192061], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.5336653333333334, 0.134336, 0.1280406666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None],
           "RGBColor[0.800498, 0.201504, 0.192061]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.800498, 0.201504, 0.192061]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.800498, 0.201504, 0.192061],
         Editable->False,
         Selectable->False]}], "}"}]}]}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: Colour parsing led to refined options ", {
   Crystallica`AddQ -> True, Crystallica`AtomCol -> {
      RGBColor[0.74902, 0.760784, 0.780392], 
      RGBColor[0.800498, 0.201504, 0.192061]}}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CrystalPlot :: Calling function CrystalChange.\"\>"], \
"Print"],

Cell[BoxData["\<\"CrystalChange :: Entering function \
CrystalChange[rawlattvec,coord,conf,rawoptions] with the following input \
values:\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\trawlattvec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: \trawlattvec = ", {{4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\tcoord = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: \tcoord = ", {{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {
    0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\tconf = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["CrystalChange :: \tconf = ", {1, 1, 2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: \\trawoptions = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Acell", "\[Rule]", "0"}], ",", 
     RowBox[{"NewbasisQ", "\[Rule]", "False"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "False"}], ",", 
     RowBox[{"CenterAtOriginQ", "\[Rule]", "False"}], ",", 
     RowBox[{"MoveOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"RetractQ", "\[Rule]", "False"}], ",", 
     RowBox[{"SortQ", "\[Rule]", "False"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"Reshape", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: \trawoptions = ", {
   Crystallica`Acell -> 0, Crystallica`NewbasisQ -> False, Crystallica`AddQ -> 
    True, Crystallica`AddQ -> False, Crystallica`CenterAtOriginQ -> False, 
    Crystallica`MoveOrigin -> {0, 0, 0}, Crystallica`RetractQ -> False, 
    Crystallica`SortQ -> False, Crystallica`Sysdim -> {1, 1, 1}, 
    Crystallica`Reshape -> {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom coordinates after length matching safety \
net are \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom coordinates after length matching safety net are ", \
{{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {
    0.2, 0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom types after length matching safety net \
are \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom types after length matching safety net are ", {1, 1, 
   2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom coordinates after type-zero deletion are \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom coordinates after type-zero deletion are ", {{0, 0, 
    0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 
    0.8, 0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Atom types after type-zero deletion are \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Atom types after type-zero deletion are ", {1, 1, 2, 2, 2,
    2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Lattice vectors converted to standard \
notation \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Lattice vectors converted to standard notation ", {{
    4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Check for 2D structure yielded \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm["CrystalChange :: Check for 2D structure yielded ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for Sysdim resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for Sysdim resolved to ", {1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for MoveOrigin resolved to \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for MoveOrigin resolved to ", {0, 0, 0}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for Reshape resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for Reshape resolved to ", {{1, 0, 0}, {0, 1,
    0}, {0, 0, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Forced switch-ON for RetractQ option is \"\>",
    "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Forced switch-ON for RetractQ option is ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for RetractQ resolved to \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value for RetractQ resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option Sysdim changed atom coordinates to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option Sysdim changed atom coordinates to ", {{0, 0, 0}, {
    0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 
    0.5}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option Sysdim changed atom types to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option Sysdim changed atom types to ", {1, 1, 2, 2, 2, 2}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for CenterAtOriginQ resolved to \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for CenterAtOriginQ resolved to ", {
   False, False, False}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value AddQ->\\\"hexa\\\" resolved to \
\"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value AddQ->\"hexa\" resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value AddQ->\\\"surfacecut\\\" \
resolved to \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value AddQ->\"surfacecut\" resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Forced switch-OFF for AddQ option is \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Forced switch-OFF for AddQ option is ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for AddQ resolved to \"\>", 
   "\[InvisibleSpace]", "True"}],
  SequenceForm["CrystalChange :: Option value for AddQ resolved to ", True],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for AddQ resolved to addition \
tolerances \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.1`", ",", "0.1`", ",", "0.1`"}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option value for AddQ resolved to addition tolerances ", {
   0.1, 0.1, 0.1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option AddQ changed atom coordinates to \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalChange :: Option AddQ changed atom coordinates to ", {{0, 0, 0}, {
    0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 
    0.5}, {1, 0, 0}, {0, 1, 0}, {1, 1, 0}, {0, 0, 1}, {0.3, 0.3, 1}, {
    0.7, 0.7, 1}, {1, 0, 1}, {0, 1, 1}, {1, 1, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option AddQ changed atom types to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1"}], 
    "}"}]}],
  SequenceForm[
  "CrystalChange :: Option AddQ changed atom types to ", {1, 1, 2, 2, 2, 2, 1,
    1, 1, 1, 2, 2, 1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for NewbasisQ resolved to \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "CrystalChange :: Option value for NewbasisQ resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for Acell resolved to \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["CrystalChange :: Option value for Acell resolved to ", 0],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalChange :: Option value for SortQ resolved to \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm["CrystalChange :: Option value for SortQ resolved to ", False],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CrystalChange :: Exiting function CrystalChange and \
returning to calling function or to user.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: CrystalChange returned structure \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3`", ",", "0.3`", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7`", ",", "0.7`", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", 
       "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: CrystalChange returned structure ", {{{4.6, 0, 0}, {
     0, 4.6, 0}, {0, 0, 3}}, {{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {
     0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 0.5}, {1, 0, 0}, {0, 1, 0}, {1,
      1, 0}, {0, 0, 1}, {0.3, 0.3, 1}, {0.7, 0.7, 1}, {1, 0, 1}, {0, 1, 1}, {
     1, 1, 1}}, {1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Check for 2D structure yielded \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm["CrystalPlot :: Check for 2D structure yielded ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Option value for Sysdim resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: Option value for Sysdim resolved to ", {1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Option value for AtomCol resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.74902, 0.760784, 0.780392], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.4993466666666667, 0.5071893333333334, 0.5202613333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None],
        "RGBColor[0.74902, 0.760784, 0.780392]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.74902, 0.760784, 0.780392]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.74902, 0.760784, 0.780392],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.800498, 0.201504, 0.192061], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.5336653333333334, 0.134336, 0.1280406666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None],
        "RGBColor[0.800498, 0.201504, 0.192061]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.800498, 0.201504, 0.192061]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.800498, 0.201504, 0.192061],
      Editable->False,
      Selectable->False]}], "}"}]}],
  SequenceForm["CrystalPlot :: Option value for AtomCol resolved to ", {
    RGBColor[0.74902, 0.760784, 0.780392], 
    RGBColor[0.800498, 0.201504, 0.192061]}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Option value for AtomRad resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.5`"}], "}"}]}],
  SequenceForm[
  "CrystalPlot :: Option value for AtomRad resolved to ", {0.5, 0.5}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Plot specularity determined as \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Specularity", "[", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->GrayLevel[0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None,
         ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIOwAgOI/R/IhBLc
DP//A1lc/0NDQxkhbAZmEOd/Q0MDCDOwgUjGESUPosFqgJiBHVmKEQA40JWK
\
\>"]],
        "GrayLevel[0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["GrayLevelColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      GrayLevel[0.5],
      Editable->False,
      Selectable->False], ",", "100"}], "]"}]}],
  SequenceForm["CrystalPlot :: Plot specularity determined as ", 
   Specularity[
    GrayLevel[0.5], 100]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CrystalPlot :: Option value for AtomFunction resolved to \"\>",
    "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"Ball", "[", 
     RowBox[{"#1", ",", "#2"}], "]"}], "&"}]}],
  SequenceForm[
  "CrystalPlot :: Option value for AtomFunction resolved to ", Ball[#, #2]& ],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CrystalPlot :: Calling function LinePlot.\"\>"], "Print"],

Cell[BoxData["\<\"LinePlot :: Entering function \
LinePlot[lattvecP,d2Q,p3dQ,sysdim,rawoptions] with the following input \
values:\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: \\tlattvecP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "LinePlot :: \tlattvecP = ", {{4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: \\td2Q = \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm["LinePlot :: \td2Q = ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: \\tp3dQ = \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm["LinePlot :: \tp3dQ = ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: \\tsysdim = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["LinePlot :: \tsysdim = ", {1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: \\trawoptions = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.74902, 0.760784, 0.780392], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.4993466666666667, 0.5071893333333334, 0.5202613333333334],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None,
            ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIOwAgOI/R/IhBLc
DP//A1lc/+sbWxkhbAZmEOf//kPHQZiBDUQyjih5EA1WA8QM7MhSjADiMbLC
\
\>"]],
           "RGBColor[0.74902, 0.760784, 0.780392]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.74902, 0.760784, 0.780392]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.74902, 0.760784, 0.780392],
         Editable->False,
         Selectable->False], ",", 
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.800498, 0.201504, 0.192061], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.5336653333333334, 0.134336, 0.1280406666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None,
            ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIOwAgOI/R/IhBLc
DP//A1lc/zuUFBghbAZmEOf/GWNDEGZgA5GMI0oeRIPVADEDO7IUIwBFNInm
\
\>"]],
           "RGBColor[0.800498, 0.201504, 0.192061]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.800498, 0.201504, 0.192061]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.800498, 0.201504, 0.192061],
         Editable->False,
         Selectable->False]}], "}"}]}]}], "}"}]}],
  SequenceForm[
  "LinePlot :: \trawoptions = ", {
   Crystallica`AddQ -> True, Crystallica`AtomCol -> {
      RGBColor[0.74902, 0.760784, 0.780392], 
      RGBColor[0.800498, 0.201504, 0.192061]}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: Option value for CellLineStyle resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm[
  "LinePlot :: Option value for CellLineStyle resolved to ", {1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: Option value for CellLineCol resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->GrayLevel[0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None,
         ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIOwAgOI/R/IhBLc
DP//A1lcIB4jfdgMzCD6P8wJ7MhSjABFUz2+\
\>"]],
        "GrayLevel[0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["GrayLevelColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      GrayLevel[0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->GrayLevel[0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None,
         ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIOwAgOI/R/IhBLc
DP//A1lcIB4jfdgMzCD6P8wJ7MhSjABFUz2+\
\>"]],
        "GrayLevel[0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["GrayLevelColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      GrayLevel[0],
      Editable->False,
      Selectable->False]}], "}"}]}],
  SequenceForm["LinePlot :: Option value for CellLineCol resolved to ", {
    GrayLevel[0], 
    GrayLevel[0]}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: Option value for CellLineRad resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.02`", ",", "0.021`"}], "}"}]}],
  SequenceForm[
  "LinePlot :: Option value for CellLineRad resolved to ", {0.02, 0.021}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LinePlot :: Option value for CellLinesFlatQ resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}]}],
  SequenceForm[
  "LinePlot :: Option value for CellLinesFlatQ resolved to ", {False, False}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"LinePlot :: Exiting function LinePlot and returning to \
calling function.\"\>"], "Print"],

Cell[BoxData["\<\"CrystalPlot :: Calling function BondPlot.\"\>"], "Print"],

Cell[BoxData["\<\"BondPlot :: Entering function \
BondPlot[lattvecP,coordP,confP,d2Q,spec,atomcol,options] with the following \
input values:\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\tlattvecP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondPlot :: \tlattvecP = ", {{4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\tcoordP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondPlot :: \tcoordP = ", {{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {
    0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 0.5}, {1, 0, 0}, {0, 1, 0}, {1, 
    1, 0}, {0, 0, 1}, {0.3, 0.3, 1}, {0.7, 0.7, 1}, {1, 0, 1}, {0, 1, 1}, {1, 
    1, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\tconfP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1"}], 
    "}"}]}],
  SequenceForm[
  "BondPlot :: \tconfP = ", {1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\td2Q = \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm["BondPlot :: \td2Q = ", False],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\tspec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"Specularity", "[", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->GrayLevel[0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None],
        "GrayLevel[0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["GrayLevelColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      GrayLevel[0.5],
      Editable->False,
      Selectable->False], ",", "100"}], "]"}]}],
  SequenceForm["BondPlot :: \tspec = ", 
   Specularity[
    GrayLevel[0.5], 100]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\tatomcol = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.74902, 0.760784, 0.780392], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.4993466666666667, 0.5071893333333334, 0.5202613333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None],
        "RGBColor[0.74902, 0.760784, 0.780392]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.74902, 0.760784, 0.780392]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.74902, 0.760784, 0.780392],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.800498, 0.201504, 0.192061], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.5336653333333334, 0.134336, 0.1280406666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification]}],
         PlotRangePadding->None],
        "RGBColor[0.800498, 0.201504, 0.192061]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.800498, 0.201504, 0.192061]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.800498, 0.201504, 0.192061],
      Editable->False,
      Selectable->False]}], "}"}]}],
  SequenceForm["BondPlot :: \tatomcol = ", {
    RGBColor[0.74902, 0.760784, 0.780392], 
    RGBColor[0.800498, 0.201504, 0.192061]}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: \\toptions = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.74902, 0.760784, 0.780392], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.4993466666666667, 0.5071893333333334, 0.5202613333333334],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None],
           "RGBColor[0.74902, 0.760784, 0.780392]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.74902, 0.760784, 0.780392]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.74902, 0.760784, 0.780392],
         Editable->False,
         Selectable->False], ",", 
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.800498, 0.201504, 0.192061], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.5336653333333334, 0.134336, 0.1280406666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None],
           "RGBColor[0.800498, 0.201504, 0.192061]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.800498, 0.201504, 0.192061]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.800498, 0.201504, 0.192061],
         Editable->False,
         Selectable->False]}], "}"}]}]}], "}"}]}],
  SequenceForm[
  "BondPlot :: \toptions = ", {Crystallica`AddQ -> True, Crystallica`AtomCol -> {
      RGBColor[0.74902, 0.760784, 0.780392], 
      RGBColor[0.800498, 0.201504, 0.192061]}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: Option value for BondStyle resolved to \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["BondPlot :: Option value for BondStyle resolved to ", 1],
  Editable->False]], "Print"],

Cell[BoxData["\<\"BondPlot :: Calling function BondTuples.\"\>"], "Print"],

Cell[BoxData["\<\"BondTuples :: Entering function \
BondTuples[lattvecP,coordP,confP,options] with the following input \
values:\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: \\tlattvecP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.6`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4.6`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondTuples :: \tlattvecP = ", {{4.6, 0, 0}, {0, 4.6, 0}, {0, 0, 3}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: \\tcoordP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8`", ",", "0.2`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "0.8`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.3`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7`", ",", "0.7`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondTuples :: \tcoordP = ", {{0, 0, 0}, {0.5, 0.5, 0.5}, {0.3, 0.3, 0}, {
    0.7, 0.7, 0}, {0.8, 0.2, 0.5}, {0.2, 0.8, 0.5}, {1, 0, 0}, {0, 1, 0}, {1, 
    1, 0}, {0, 0, 1}, {0.3, 0.3, 1}, {0.7, 0.7, 1}, {1, 0, 1}, {0, 1, 1}, {1, 
    1, 1}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: \\tconfP = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1"}], 
    "}"}]}],
  SequenceForm[
  "BondTuples :: \tconfP = ", {1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: \\toptions = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.74902, 0.760784, 0.780392], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.4993466666666667, 0.5071893333333334, 0.5202613333333334],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None],
           "RGBColor[0.74902, 0.760784, 0.780392]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.74902, 0.760784, 0.780392]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.74902, 0.760784, 0.780392],
         Editable->False,
         Selectable->False], ",", 
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.800498, 0.201504, 0.192061], 
              RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.5336653333333334, 0.134336, 0.1280406666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 1.35 CurrentValue["FontCapHeight"]/
               AbsoluteCurrentValue[Magnification]}],
            PlotRangePadding->None],
           "RGBColor[0.800498, 0.201504, 0.192061]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.800498, 0.201504, 0.192061]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.800498, 0.201504, 0.192061],
         Editable->False,
         Selectable->False]}], "}"}]}]}], "}"}]}],
  SequenceForm[
  "BondTuples :: \toptions = ", {
   Crystallica`AddQ -> True, Crystallica`AtomCol -> {
      RGBColor[0.74902, 0.760784, 0.780392], 
      RGBColor[0.800498, 0.201504, 0.192061]}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Option value for BondDist resolved to \"\>", 
   "\[InvisibleSpace]", "2.1`"}],
  SequenceForm["BondTuples :: Option value for BondDist resolved to ", 2.1],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Automatic bond generation returned bonds \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "15"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondTuples :: Automatic bond generation returned bonds ", {{1, 3}, {2, 
   3}, {2, 4}, {2, 5}, {2, 6}, {2, 11}, {2, 12}, {4, 9}, {5, 7}, {5, 13}, {6, 
   8}, {6, 14}, {10, 11}, {12, 15}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Atom-specific forced non-bonding found for atom \
pairs \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
  "BondTuples :: Atom-specific forced non-bonding found for atom pairs ", {}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Type-specific forced non-bonding found for type \
pairs \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
  "BondTuples :: Type-specific forced non-bonding found for type pairs ", {}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Forced non-bonding changed bond list to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "15"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondTuples :: Forced non-bonding changed bond list to ", {{1, 3}, {2, 3}, {
   2, 4}, {2, 5}, {2, 6}, {2, 11}, {2, 12}, {4, 9}, {5, 7}, {5, 13}, {6, 8}, {
   6, 14}, {10, 11}, {12, 15}}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Weak atom-specific forced bonding found for atom \
pairs \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
  "BondTuples :: Weak atom-specific forced bonding found for atom pairs ", {}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Strong atom-specific forced bonding found for \
atom pairs \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
  "BondTuples :: Strong atom-specific forced bonding found for atom pairs ", \
{}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Weak type-specific forced bonding found for atom \
pairs \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
  "BondTuples :: Weak type-specific forced bonding found for atom pairs ", {}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Strong type-specific forced bonding found for \
atom pairs \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
  "BondTuples :: Strong type-specific forced bonding found for atom pairs ", \
{}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondTuples :: Forced bonding changed bond list to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "15"}], "}"}]}], "}"}]}],
  SequenceForm[
  "BondTuples :: Forced bonding changed bond list to ", {{1, 3}, {2, 3}, {2, 
   4}, {2, 5}, {2, 6}, {2, 11}, {2, 12}, {4, 9}, {5, 7}, {5, 13}, {6, 8}, {6, 
   14}, {10, 11}, {12, 15}}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"BondTuples :: Exiting function BondTuples and returning to \
calling function.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: Option value for BondCol resolved to \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->GrayLevel[0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
          Magnification]}],
       PlotRangePadding->None],
      "GrayLevel[0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["GrayLevelColorValueSelector"], {
           0, {Left, Bottom}}, {Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    GrayLevel[0.5],
    Editable->False,
    Selectable->False]}],
  SequenceForm["BondPlot :: Option value for BondCol resolved to ", 
   GrayLevel[0.5]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"BondPlot :: Option value for BondRad resolved to \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.15`", ",", "0.15`", ",", "0.15`"}], "}"}]}],
  SequenceForm[
  "BondPlot :: Option value for BondRad resolved to ", {0.15, 0.15, 0.15}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CrystalPlot :: Exiting function CrystalPlot and returning \
to calling function or to user.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0., 0., 0.}, {4.6, 0., 0.}, {4.6, 4.6, 0.}, {0., 4.6, 0.}, {
      0., 0., 0.}}, {{0., 0., 3.}, {4.6, 0., 3.}, {4.6, 4.6, 3.}, {0., 4.6, 
      3.}, {0., 0., 3.}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0., 0., 0.}, {0., 0., 3.}}, {{4.6, 0., 0.}, {4.6, 0., 3.}}, {{
      4.6, 4.6, 0.}, {4.6, 4.6, 3.}}, {{0., 4.6, 0.}, {0., 4.6, 3.}}}, 
      0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {4.0155344321519015`, 0., 0.}, {4.0155344321519015`, 
       0., 0.}, {4.6, 0, 0}}, {0.021, 0.021, 0.14611639196202458`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 4.0155344321519015`, 0.}, {0., 
       4.0155344321519015`, 0.}, {0, 4.6, 0}}, {
      0.021, 0.021, 0.14611639196202458`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.415534432151902}, {0., 0., 
       2.415534432151902}, {0, 0, 3}}, {
      0.021, 0.021, 0.14611639196202458`, 0}]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{0., 0., 0.}, {0.69, 0.69, 0.}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{1.38, 1.38, 0.}, {0.69, 0.69, 0.}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{2.3, 2.3, 1.5}, {1.8399999999999999`, 1.8399999999999999`, 
      0.75}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{1.38, 1.38, 0.}, {1.8399999999999999`, 1.8399999999999999`, 
      0.75}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{2.3, 2.3, 1.5}, {2.76, 2.76, 0.75}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.2199999999999998`, 3.2199999999999998`, 0.}, {2.76, 2.76, 
      0.75}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{2.3, 2.3, 1.5}, {2.9899999999999998`, 1.6099999999999999`, 
      1.5}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.6799999999999997`, 0.9199999999999999, 1.5}, {
      2.9899999999999998`, 1.6099999999999999`, 1.5}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{2.3, 2.3, 1.5}, {1.6099999999999999`, 2.9899999999999998`, 
      1.5}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{0.9199999999999999, 3.6799999999999997`, 1.5}, {
      1.6099999999999999`, 2.9899999999999998`, 1.5}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{2.3, 2.3, 1.5}, {1.8399999999999999`, 1.8399999999999999`, 
      2.25}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{1.38, 1.38, 3.}, {1.8399999999999999`, 1.8399999999999999`, 
      2.25}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{2.3, 2.3, 1.5}, {2.76, 2.76, 2.25}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.2199999999999998`, 3.2199999999999998`, 3.}, {2.76, 2.76, 
      2.25}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.2199999999999998`, 3.2199999999999998`, 0.}, {
      3.9099999999999997`, 3.9099999999999997`, 0.}}, 0.15]}, 
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{4.6, 4.6, 0.}, {3.9099999999999997`, 3.9099999999999997`, 0.}},
       0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.6799999999999997`, 0.9199999999999999, 1.5}, {4.14, 
      0.45999999999999996`, 0.75}}, 0.15]}, 
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{4.6, 0., 0.}, {4.14, 0.45999999999999996`, 0.75}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.6799999999999997`, 0.9199999999999999, 1.5}, {4.14, 
      0.45999999999999996`, 2.25}}, 0.15]}, 
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{4.6, 0., 3.}, {4.14, 0.45999999999999996`, 2.25}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{0.9199999999999999, 3.6799999999999997`, 1.5}, {
      0.45999999999999996`, 4.14, 0.75}}, 0.15]}, 
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{0., 4.6, 0.}, {0.45999999999999996`, 4.14, 0.75}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{0.9199999999999999, 3.6799999999999997`, 1.5}, {
      0.45999999999999996`, 4.14, 2.25}}, 0.15]}, 
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{0., 4.6, 3.}, {0.45999999999999996`, 4.14, 2.25}}, 0.15]}}, {
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{0., 0., 3.}, {0.69, 0.69, 3.}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{1.38, 1.38, 3.}, {0.69, 0.69, 3.}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3.2199999999999998`, 3.2199999999999998`, 3.}, {
      3.9099999999999997`, 3.9099999999999997`, 3.}}, 0.15]}, 
    {RGBColor[0.74902, 0.760784, 0.780392], 
     TubeBox[{{4.6, 4.6, 3.}, {3.9099999999999997`, 3.9099999999999997`, 3.}},
       0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{0., 0., 0.}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{2.3, 2.3, 1.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{1.38, 1.38, 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{3.2199999999999998`, 3.2199999999999998`, 0.}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{3.6799999999999997`, 0.9199999999999999, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{0.9199999999999999, 3.6799999999999997`, 1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{4.6, 0., 0.}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{0., 4.6, 0.}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{4.6, 4.6, 0.}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{0., 0., 3.}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{1.38, 1.38, 3.}, 0.5],
       "Ball"]},
     "11"],
    Annotation[#, 11, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{3.2199999999999998`, 3.2199999999999998`, 3.}, 0.5],
       "Ball"]},
     "12"],
    Annotation[#, 12, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{4.6, 0., 3.}, 0.5],
       "Ball"]},
     "13"],
    Annotation[#, 13, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{0., 4.6, 3.}, 0.5],
       "Ball"]},
     "14"],
    Annotation[#, 14, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.74902, 0.760784, 0.780392], 
      TagBox[SphereBox[{4.6, 4.6, 3.}, 0.5],
       "Ball"]},
     "15"],
    Annotation[#, 15, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "CrystalPlot[lattvec,coord,conf] plots a crystal structure.", 
    "synonyms" -> {}, "title" -> "CrystalPlot", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/CrystalPlot"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828984-3834481"->{
  Cell[755, 30, 164, 3, 40, "Print",
   CellTags->"Info3569828984-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828984-3834481", 252727, 5797}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 173, 6, 70, "Section"],
Cell[755, 30, 164, 3, 40, "Print",
 CellTags->"Info3569828984-3834481"],
Cell[CellGroupData[{
Cell[944, 37, 41, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1010, 41, 155, 3, 25, "Subitem"],
Cell[1168, 46, 190, 4, 25, "Subitem"],
Cell[1361, 52, 262, 5, 25, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[1672, 63, 38, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1735, 67, 140, 3, 25, "Subitem"],
Cell[1878, 72, 218, 4, 25, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[2123, 80, 116, 3, 29, "Item"],
Cell[2242, 85, 162, 3, 29, "Item"],
Cell[2407, 90, 196, 4, 29, "Item"],
Cell[2606, 96, 173, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[2804, 103, 29, 0, 49, "Subsection"],
Cell[2836, 105, 413, 9, 45, "Item"],
Cell[CellGroupData[{
Cell[3274, 118, 66, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[3365, 122, 33, 0, 25, "Subitem"],
Cell[CellGroupData[{
Cell[3423, 126, 457, 17, 41, "Subsubitem"],
Cell[3883, 145, 1020, 37, 41, "Subsubitem"]
}, Open  ]],
Cell[4918, 185, 36, 0, 25, "Subitem"],
Cell[CellGroupData[{
Cell[4979, 189, 701, 25, 41, "Subsubitem"],
Cell[5683, 216, 1420, 49, 41, "Subsubitem"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7164, 272, 105, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[7294, 279, 194, 5, 25, "Subitem"],
Cell[7491, 286, 151, 3, 25, "Subitem"],
Cell[7645, 291, 105, 1, 25, "Subitem"],
Cell[7753, 294, 210, 4, 25, "Subitem"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8024, 305, 30, 0, 49, "Subsection"],
Cell[8057, 307, 33, 0, 30, "Text"],
Cell[8093, 309, 102, 2, 31, "Input"],
Cell[8198, 313, 41, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[8264, 317, 683, 21, 31, "Input"],
Cell[8950, 340, 1767, 50, 375, "Output"]
}, Open  ]],
Cell[10732, 393, 40, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[10797, 397, 1250, 35, 52, "Input"],
Cell[12050, 434, 4097, 124, 375, "Output"]
}, Open  ]],
Cell[16162, 561, 57, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[16244, 565, 1856, 51, 72, "Input"],
Cell[18103, 618, 135869, 2469, 375, 14372, 476, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[153987, 3090, 67, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[154079, 3094, 1069, 33, 31, "Input"],
Cell[155151, 3129, 3178, 75, 197, "Output"]
}, Open  ]],
Cell[158344, 3207, 132, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[158501, 3214, 1374, 42, 52, "Input"],
Cell[159878, 3258, 3209, 99, 375, "Output"]
}, Open  ]],
Cell[163102, 3360, 138, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[163265, 3367, 673, 21, 31, "Input"],
Cell[163941, 3390, 5424, 109, 197, "Output"]
}, Open  ]],
Cell[169380, 3502, 53, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[169458, 3506, 636, 18, 31, "Input"],
Cell[170097, 3526, 1363, 36, 375, "Output"]
}, Open  ]],
Cell[171475, 3565, 58, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[171558, 3569, 558, 19, 31, "Input"],
Cell[172119, 3590, 1598, 41, 447, "Output"]
}, Open  ]],
Cell[173732, 3634, 147, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[173904, 3641, 1289, 37, 72, "Input"],
Cell[CellGroupData[{
Cell[175218, 3682, 146, 2, 23, "Print"],
Cell[175367, 3686, 484, 13, 23, "Print"],
Cell[175854, 3701, 792, 20, 23, "Print"],
Cell[176649, 3723, 291, 6, 23, "Print"],
Cell[176943, 3731, 462, 12, 23, "Print"],
Cell[177408, 3745, 4214, 105, 23, "Print"],
Cell[181625, 3852, 82, 1, 23, "Print"],
Cell[181710, 3855, 153, 2, 23, "Print"],
Cell[181866, 3859, 494, 13, 23, "Print"],
Cell[182363, 3874, 796, 20, 23, "Print"],
Cell[183162, 3896, 295, 6, 23, "Print"],
Cell[183460, 3904, 1498, 34, 43, "Print"],
Cell[184961, 3940, 887, 22, 23, "Print"],
Cell[185851, 3964, 381, 9, 23, "Print"],
Cell[186235, 3975, 874, 22, 23, "Print"],
Cell[187112, 3999, 367, 9, 23, "Print"],
Cell[187482, 4010, 564, 15, 23, "Print"],
Cell[188049, 4027, 244, 5, 23, "Print"],
Cell[188296, 4034, 316, 8, 23, "Print"],
Cell[188615, 4044, 324, 8, 23, "Print"],
Cell[188942, 4054, 535, 15, 23, "Print"],
Cell[189480, 4071, 265, 6, 23, "Print"],
Cell[189748, 4079, 261, 6, 23, "Print"],
Cell[190012, 4087, 866, 22, 23, "Print"],
Cell[190881, 4111, 355, 8, 23, "Print"],
Cell[191239, 4121, 360, 9, 23, "Print"],
Cell[191602, 4132, 267, 6, 23, "Print"],
Cell[191872, 4140, 279, 6, 23, "Print"],
Cell[192154, 4148, 259, 6, 23, "Print"],
Cell[192416, 4156, 248, 5, 23, "Print"],
Cell[192667, 4163, 369, 9, 23, "Print"],
Cell[193039, 4174, 1645, 41, 43, "Print"],
Cell[194687, 4217, 488, 12, 23, "Print"],
Cell[195178, 4231, 263, 6, 23, "Print"],
Cell[195444, 4239, 244, 5, 23, "Print"],
Cell[195691, 4246, 252, 5, 23, "Print"],
Cell[195946, 4253, 129, 1, 23, "Print"],
Cell[196078, 4256, 2323, 57, 43, "Print"],
Cell[198404, 4315, 240, 5, 23, "Print"],
Cell[198647, 4322, 312, 8, 23, "Print"],
Cell[198962, 4332, 3709, 95, 23, "Print"],
Cell[202674, 4429, 311, 8, 23, "Print"],
Cell[202988, 4439, 2036, 54, 23, "Print"],
Cell[205027, 4495, 349, 9, 23, "Print"],
Cell[205379, 4506, 75, 0, 23, "Print"],
Cell[205457, 4508, 146, 2, 23, "Print"],
Cell[205606, 4512, 480, 13, 23, "Print"],
Cell[206089, 4527, 185, 4, 23, "Print"],
Cell[206277, 4533, 187, 4, 23, "Print"],
Cell[206467, 4539, 250, 6, 23, "Print"],
Cell[206720, 4547, 4543, 114, 23, "Print"],
Cell[211266, 4663, 307, 8, 23, "Print"],
Cell[211576, 4673, 3626, 97, 23, "Print"],
Cell[215205, 4772, 319, 8, 23, "Print"],
Cell[215527, 4782, 325, 8, 23, "Print"],
Cell[215855, 4792, 108, 1, 23, "Print"],
Cell[215966, 4795, 75, 0, 23, "Print"],
Cell[216044, 4797, 157, 2, 23, "Print"],
Cell[216204, 4801, 480, 13, 23, "Print"],
Cell[216687, 4816, 1574, 40, 23, "Print"],
Cell[218264, 4858, 423, 10, 23, "Print"],
Cell[218690, 4870, 185, 4, 23, "Print"],
Cell[218878, 4876, 1794, 48, 23, "Print"],
Cell[220675, 4926, 3650, 94, 23, "Print"],
Cell[224328, 5022, 4149, 103, 23, "Print"],
Cell[228480, 5127, 242, 5, 23, "Print"],
Cell[228725, 5134, 74, 0, 23, "Print"],
Cell[228802, 5136, 144, 2, 23, "Print"],
Cell[228949, 5140, 484, 13, 23, "Print"],
Cell[229436, 5155, 1578, 40, 23, "Print"],
Cell[231017, 5197, 427, 10, 23, "Print"],
Cell[231447, 5209, 4157, 104, 23, "Print"],
Cell[235607, 5315, 249, 5, 23, "Print"],
Cell[235859, 5322, 1299, 38, 23, "Print"],
Cell[237161, 5362, 297, 7, 23, "Print"],
Cell[237461, 5371, 297, 7, 23, "Print"],
Cell[237761, 5380, 1297, 38, 23, "Print"],
Cell[239061, 5420, 299, 7, 23, "Print"],
Cell[239363, 5429, 305, 8, 23, "Print"],
Cell[239671, 5439, 299, 7, 23, "Print"],
Cell[239973, 5448, 305, 8, 23, "Print"],
Cell[240281, 5458, 1289, 38, 23, "Print"],
Cell[241573, 5498, 112, 1, 23, "Print"],
Cell[241688, 5501, 1684, 46, 23, "Print"],
Cell[243375, 5549, 329, 8, 23, "Print"],
Cell[243707, 5559, 125, 1, 23, "Print"]
}, Open  ]],
Cell[243847, 5563, 7883, 205, 375, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
