(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     17798,        589]
NotebookOptionsPosition[     15615,        519]
NotebookOutlinePosition[     16778,        554]
CellTagsIndexPosition[     16693,        549]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "ForceBonds",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"ForceBonds is an option of CrystalPlot giving pairs of atoms \
to connect with bonds.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3578137551-7922898"],

Cell[TextData[{
 "ForceBonds is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ", ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell["\<\
ForceBonds gives pairs of atoms and atom types that are to be connected with \
bonds in addition to (or instead of) the automatically generated bonds.\
\>", "Item"],

Cell[TextData[{
 "Enter ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 " as a negative number to disable automatic bond generation and plot only \
bonds specified by ForceBonds."
}], "Item"],

Cell[CellGroupData[{

Cell["\<\
The value of ForceBonds is itself a list of options with option names in \
string format. Possible options: \[OpenCurlyDoubleQuote]AtomsWeak\
\[CloseCurlyDoubleQuote], \[CloseCurlyDoubleQuote]AtomsStrong\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]TypesWeak\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]TypesStrong\
\[CloseCurlyDoubleQuote].\
\>", "Item"],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]Atoms...\[CloseCurlyDoubleQuote] options expect a list \
of pairs of atom indices, such as: \[OpenCurlyDoubleQuote]AtomsWeak\
\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{1,3}}. If a single atom is given \
instead of a pair, all bonds from or to this atom are drawn. These two modes \
can be mixed, so that this: \[OpenCurlyDoubleQuote]AtomsWeak\
\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{3}} means: Draw bond between atoms 1 \
and 2, and all bonds from or to atom 3.\
\>", "Subitem"],

Cell["\<\
\[OpenCurlyDoubleQuote]Types...\[CloseCurlyDoubleQuote] options expect a list \
of pairs of atom types, such as: \[OpenCurlyDoubleQuote]TypesWeak\
\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{1,3}}. If a single type is given \
instead of a pair, bonds are drawn between atoms which are both (!) of that \
type. These two modes can be mixed, so that this: \
\[OpenCurlyDoubleQuote]TypesWeak\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{3}} \
means: Draw bonds between atoms of type 1 and atoms of type 2, and between \
atoms that are both of type 3.\
\>", "Subitem"],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]...Weak\[CloseCurlyDoubleQuote] options respect the ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 " option. In case of conflict, ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 " takes precedence over the \[OpenCurlyDoubleQuote]...Weak\
\[CloseCurlyDoubleQuote] options."
}], "Subitem"],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]...Strong\[CloseCurlyDoubleQuote] options ignore ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 " and ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 "."
}], "Subitem"]
}, Open  ]]
}, Open  ]],

Cell["Default: {}", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Use a negative BondDist setting to see only manual bonds, and draw bonds that \
respect or disregard BondDist:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"BondDist", "\[Rule]", 
      RowBox[{"-", "2.5"}]}], ",", 
     RowBox[{"ForceBonds", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"mode", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mode", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<AtomsWeak\>\"", ",", "\"\<AtomsStrong\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {2.5, 1.5, 0.}}, 0.15]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{3, 3, 0}, {2.5, 1.5, 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Draw all bonds between atom types 1 and 2, but not between atoms 1 and 5:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3"}],
     "}"}], ",", 
   RowBox[{"BondDist", "\[Rule]", 
    RowBox[{"-", "2.5"}]}], ",", 
   RowBox[{"ForceBonds", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<TypesWeak\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ForceNoBonds", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Atoms\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {-1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-2, 0, 0}, {-1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 1., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 2, 0}, {0., 1., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 0., -1.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 0, -2}, {0., 0., -1.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., -1., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, -2, 0}, {0., -1., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-2, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 2, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, -2}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, 2}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, -2, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
In this structure, two atoms are outside the reach of BondDist; use \
automatically generated bonds for the other atoms, but also add a long bond \
to one of these remote atoms:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2"}],
     "}"}], ",", 
   RowBox[{"ForceBonds", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<AtomsStrong\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "6"}], "}"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {-1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-2, 0, 0}, {-1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 0., -1.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 0, -2}, {0., 0., -1.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 0., 1.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 0, 2}, {0., 0., 1.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., -2.5, 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, -5, 0}, {0., -2.5, 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-2, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 5, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, -2}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, 2}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, -5, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "ForceBonds is an option of CrystalPlot giving pairs of atoms to connect \
with bonds.", "synonyms" -> {}, "title" -> "ForceBonds", "type" -> "Symbol", 
    "uri" -> "Crystallica/ref/ForceBonds"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3578137551-7922898"->{
  Cell[757, 31, 189, 3, 40, "Print",
   CellTags->"Info3578137551-7922898"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3578137551-7922898", 16592, 543}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 175, 7, 70, "Section"],
Cell[757, 31, 189, 3, 40, "Print",
 CellTags->"Info3578137551-7922898"],
Cell[949, 36, 1032, 37, 29, "Item"],
Cell[1984, 75, 174, 3, 29, "Item"],
Cell[2161, 80, 241, 7, 29, "Item"],
Cell[CellGroupData[{
Cell[2427, 91, 376, 7, 29, "Item"],
Cell[CellGroupData[{
Cell[2828, 102, 508, 8, 41, "Subitem"],
Cell[3339, 112, 562, 9, 41, "Subitem"],
Cell[3904, 123, 437, 11, 25, "Subitem"],
Cell[4344, 136, 318, 10, 25, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[4689, 150, 27, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[4741, 154, 30, 0, 49, "Subsection"],
Cell[4774, 156, 33, 0, 30, "Text"],
Cell[4810, 158, 102, 2, 31, "Input"],
Cell[4915, 162, 134, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[5074, 169, 1014, 31, 31, "Input"],
Cell[6091, 202, 2155, 70, 197, "Output"]
}, Open  ]],
Cell[8261, 275, 97, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[8383, 281, 1304, 39, 52, "Input"],
Cell[9690, 322, 2207, 72, 375, "Output"]
}, Open  ]],
Cell[11912, 397, 201, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[12138, 405, 1033, 31, 31, "Input"],
Cell[13174, 438, 2401, 76, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
