(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     13406,        445]
NotebookOptionsPosition[     11429,        381]
NotebookOutlinePosition[     12623,        417]
CellTagsIndexPosition[     12538,        412]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "ForceNoBonds",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"ForceNoBonds is an option of CrystalPlot giving pairs of atoms \
or atom types to never connect with bonds.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3578138796-7922898"],

Cell[TextData[{
 "ForceNoBonds is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ", ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ", ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell["\<\
ForceNoBonds gives pairs of atoms and atom types that are NOT to be connected \
with bonds.\
\>", "Item"],

Cell[CellGroupData[{

Cell["\<\
The value of ForceNoBonds is itself a list of options with option names in \
string format. Possible options: \[OpenCurlyDoubleQuote]Atoms\
\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Types\[CloseCurlyDoubleQuote].\
\>", "Item"],

Cell[CellGroupData[{

Cell["\<\
The \[OpenCurlyDoubleQuote]Atoms\[CloseCurlyDoubleQuote] option expects a \
list of pairs of atom indices, such as: \[OpenCurlyDoubleQuote]Atoms\
\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{1,3}}. If a single atom is given \
instead of a pair, no bonds from or to this atoms are drawn at all. These two \
modes can be mixed, so that this: \[OpenCurlyDoubleQuote]Atoms\
\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{3}} means: Draw no bond between atoms \
1 and 2, and no bonds at all from or to atom 3.\
\>", "Subitem"],

Cell["\<\
The \[OpenCurlyDoubleQuote]Types\[CloseCurlyDoubleQuote] option expects a \
list of pairs of atom types, such as: \[OpenCurlyDoubleQuote]Types\
\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{1,3}}. If a single type is given \
instead of a pair, no bonds are drawn between atoms which are both (!) of \
that type. These two modes can be mixed, so that this: \
\[OpenCurlyDoubleQuote]Types\[CloseCurlyDoubleQuote]\[Rule]{{1,2},{3}} means: \
Draw no bonds between atoms of type 1 and atoms of type 2, or between atoms \
that are both of type 3.\
\>", "Subitem"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "ForceNoBonds removes bonds resulting from automatic bond generation as well \
as those given with the \
\[OpenCurlyDoubleQuote]...Weak\[CloseCurlyDoubleQuote] variety of the options \
in ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ". It does not remove bonds given by \[OpenCurlyDoubleQuote]...Strong\
\[CloseCurlyDoubleQuote] options in ForceBonds."
}], "Item"],

Cell["Default: {}", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Use automatic bonds, but disable bonds between atom types 1 and 3:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3"}],
     "}"}], ",", 
   RowBox[{"ForceNoBonds", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Types\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {-1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-2, 0, 0}, {-1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 1., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 2, 0}, {0., 1., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 0., -1.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 0, -2}, {0., 0., -1.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 0., 1.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 0, 2}, {0., 0., 1.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., -1., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, -2, 0}, {0., -1., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-2, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 2, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, -2}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, 2}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, -2, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Draw all bonds between atom types 1 and 2, but not between atoms 1 and 5:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3"}],
     "}"}], ",", 
   RowBox[{"BondDist", "\[Rule]", 
    RowBox[{"-", "2.5"}]}], ",", 
   RowBox[{"ForceBonds", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<TypesWeak\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ForceNoBonds", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Atoms\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {-1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-2, 0, 0}, {-1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 1., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 2, 0}, {0., 1., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., 0., -1.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, 0, -2}, {0., 0., -1.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0., -1., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0, -2, 0}, {0., -1., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-2, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 2, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, -2}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, 2}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, -2, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "ForceNoBonds is an option of CrystalPlot giving pairs of atoms or atom \
types to never connect with bonds.", "synonyms" -> {}, "title" -> 
    "ForceNoBonds", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/ForceNoBonds"}, "SearchTextTranslated" -> "", 
  "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3578138796-7922898"->{
  Cell[759, 31, 213, 4, 40, "Print",
   CellTags->"Info3578138796-7922898"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3578138796-7922898", 12437, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 177, 7, 70, "Section"],
Cell[759, 31, 213, 4, 40, "Print",
 CellTags->"Info3578138796-7922898"],
Cell[975, 37, 1030, 37, 29, "Item"],
Cell[2008, 76, 115, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[2148, 83, 245, 5, 29, "Item"],
Cell[CellGroupData[{
Cell[2418, 92, 517, 8, 41, "Subitem"],
Cell[2938, 102, 560, 9, 41, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[3525, 115, 438, 10, 29, "Item"],
Cell[3966, 127, 27, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[4018, 131, 30, 0, 49, "Subsection"],
Cell[4051, 133, 33, 0, 30, "Text"],
Cell[4087, 135, 102, 2, 31, "Input"],
Cell[4192, 139, 90, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[4307, 145, 1029, 31, 31, "Input"],
Cell[5339, 178, 2399, 76, 375, "Output"]
}, Open  ]],
Cell[7753, 257, 97, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[7875, 263, 1304, 39, 52, "Input"],
Cell[9182, 304, 2207, 72, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
