(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      6292,        214]
NotebookOptionsPosition[      4639,        162]
NotebookOutlinePosition[      5852,        198]
CellTagsIndexPosition[      5768,        193]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NewbasisQ (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"NewbasisQ is an option of CrystalChange and CrystalPlot which \
determines whether atom coordinates are projected into the supercell.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828979-3834481"],

Cell[TextData[{
 "NewbasisQ is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 ".\nIn CrystalPlot, NewbasisQ only takes effect if ",
 ButtonBox["ButtonQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ButtonQ"],
 "->True."
}], "Item"],

Cell[TextData[{
 "When building a supercell with ",
 ButtonBox["Sysdim",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"],
 ", NewbasisQ states whether the atoms are to be projected into the basis of \
the supercell. If NewbasisQ is set to False, the lattice vectors of the input \
cell are used instead. The physical cell is the same in either case."
}], "Item"],

Cell["\<\
NewbasisQ does not affect the ouput for any cell-reshaping options other than \
Sysdim.\
\>", "Item"],

Cell["Default: True", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Effect of the NewbasisQ option:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"CrystalChange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"Sysdim", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], ",", 
      RowBox[{"NewbasisQ", "\[Rule]", "newbasis"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"newbasis", ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "NewbasisQ is an option of CrystalChange and CrystalPlot which determines \
whether atom coordinates are projected into the supercell.", "synonyms" -> {},
     "title" -> "NewbasisQ", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/NewbasisQ"}, "SearchTextTranslated" -> "", "LinkTrails" -> 
  ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828979-3834481"->{
  Cell[751, 30, 240, 4, 40, "Print",
   CellTags->"Info3569828979-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828979-3834481", 5667, 187}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 169, 6, 70, "Section"],
Cell[751, 30, 240, 4, 40, "Print",
 CellTags->"Info3569828979-3834481"],
Cell[994, 36, 430, 14, 45, "Item"],
Cell[1427, 52, 382, 8, 45, "Item"],
Cell[1812, 62, 111, 3, 29, "Item"],
Cell[1926, 67, 29, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1980, 71, 30, 0, 49, "Subsection"],
Cell[2013, 73, 33, 0, 30, "Text"],
Cell[2049, 75, 102, 2, 31, "Input"],
Cell[2154, 79, 47, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2226, 83, 907, 27, 31, "Input"],
Cell[3136, 112, 1463, 45, 85, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
