(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     49202,       1495]
NotebookOptionsPosition[     46385,       1405]
NotebookOutlinePosition[     47569,       1440]
CellTagsIndexPosition[     47483,       1435]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "PolyMode",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"PolyMode[cornercount] is an option of CrystalPlot that defines \
the general mode of coordination polyhedra.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3577702899-2097078"],

Cell[TextData[{
 "PolyMode is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 "."
}], "Item"],

Cell[CellGroupData[{

Cell["\<\
PolyMode[corners] gives the mode of coordination polyhedra with corner count \
\[OpenCurlyQuote]corners\[CloseCurlyQuote]; it can have the following values:\
\>", "Item"],

Cell[CellGroupData[{

Cell["\<\
False, None, or 0 for no polyhedra of this corner count (equivalent to simply \
not giving the option at all)\
\>", "Subitem"],

Cell["\<\
True or All for polyhedra with a default distance cut-off and tolerance for \
deviation from ideal polyhedron\
\>", "Subitem"],

Cell["\<\
List of the options \[OpenCurlyDoubleQuote]Show\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]AllowMixed\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Distance\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]Tolerance\[CloseCurlyDoubleQuote] as illustrated in \
the examples below\
\>", "Subitem"]
}, Open  ]]
}, Open  ]],

Cell["\<\
By default, this option is not given, resulting in no polyhedra.\
\>", "Item"],

Cell[TextData[{
 "Layout is specified via the ",
 ButtonBox["PolyStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/PolyStyle"],
 " option."
}], "Item"],

Cell["Polyhedra are not available in 2D.", "Item"],

Cell["\<\
Polyhedra with corners outside the displayed structure are not shown.\
\>", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Display coordination tetrahedra with default settings; a tetrahedron has 4 \
corners, therefore the correct option to use in this example is PolyMode[4]:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", 
       RowBox[{"-", "1.5"}], ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", "1.5", ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7", ",", "0", ",", 
       RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 1.8}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
    GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
     1.5, -0.6}, {1.7, 
     0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
      Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Display coordination tetrahedra, but only test specific atoms; Crystallica \
only finds a tetrahedron at atom 1:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".9"}], ",", 
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", ".6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".9"}], ",", "1.5", ",", 
         RowBox[{"-", ".6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7", ",", "0", ",", 
         RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Show\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Atoms\>\"", ",", 
          RowBox[{"{", "atoms", "}"}]}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"atoms", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
      GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
       1.5, -0.6}, {1.7, 
       0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
        Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], {}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], {}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], {}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], {}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Display coordination tetrahedra, but only test specific atom types; \
Crystallica only finds a tetrahedron at atoms of type 1:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".9"}], ",", 
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", ".6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".9"}], ",", "1.5", ",", 
         RowBox[{"-", ".6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7", ",", "0", ",", 
         RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Show\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Types\>\"", ",", 
          RowBox[{"{", "types", "}"}]}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"types", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
      GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
       1.5, -0.6}, {1.7, 
       0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
        Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], {}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Test atom type 1, and also specify the maximum distance between the central \
atoms and the tetrahedron corners, and the maximum allowed deviation from the \
ideal tetrahedron. The \
\[OpenCurlyDoubleQuote]Distance\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]Tolerance\[CloseCurlyDoubleQuote] values given here \
represent the default:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", 
       RowBox[{"-", "1.5"}], ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", "1.5", ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7", ",", "0", ",", 
       RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Show\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Types\>\"", ",", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"\"\<Distance\>\"", "\[Rule]", "2."}], ",", 
      RowBox[{"\"\<Tolerance\>\"", "\[Rule]", ".56"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 1.8}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
    GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
     1.5, -0.6}, {1.7, 
     0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
      Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
By default, the corners of a polyhedron have to be of the same atom type; you \
can change this behaviour with the option \[OpenCurlyDoubleQuote]AllowMixed\
\[CloseCurlyDoubleQuote]:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".9"}], ",", 
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", ".6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".9"}], ",", "1.5", ",", 
         RowBox[{"-", ".6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7", ",", "0", ",", 
         RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{
      RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<Show\>\"", "\[Rule]", "All"}], ",", 
        RowBox[{"\"\<AllowMixed\>\"", "\[Rule]", "mixed"}]}], "}"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mixed", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
      GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
       1.5, -0.6}, {1.7, 
       0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
        Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 1.8}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], {}},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
For some geometries, the \[OpenCurlyDoubleQuote]AllowMixed\
\[CloseCurlyDoubleQuote] option can make polyhedra detectable or \
undetectable, depending on the number of corners you search for:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"CrystalPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".9"}], ",", 
           RowBox[{"-", "1.5"}], ",", 
           RowBox[{"-", ".6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".9"}], ",", "1.5", ",", 
           RowBox[{"-", ".6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.7", ",", "0", ",", 
           RowBox[{"-", ".6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".8", ",", ".8", ",", ".8"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3"}], 
        "}"}], ",", 
       RowBox[{"BondStyle", "\[Rule]", "False"}], ",", 
       RowBox[{
        RowBox[{"PolyMode", "[", "corners", "]"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<Show\>\"", "\[Rule]", "All"}], ",", 
          RowBox[{"\"\<AllowMixed\>\"", "\[Rule]", "mixed"}]}], "}"}]}], ",", 
       RowBox[{
        RowBox[{"PolyStyle", "[", "corners", "]"}], "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Opacity", "[", ".5", "]"}], ",", 
          RowBox[{"EdgeForm", "[", "Thick", "]"}]}], "]"}]}], ",", 
       RowBox[{"PlotLabel", "->", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"corners", ",", "\"\< corners, \>\"", ",", 
           RowBox[{"If", "[", 
            RowBox[{"mixed", ",", "\"\<\>\"", ",", "\"\<no\>\""}], "]"}], 
           ",", "\"\< mixed corners\>\""}], "}"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"mixed", ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"corners", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "Center"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[{{}, {}, 
       TagBox[
        TooltipBox[
         {RGBColor[0.368417, 0.506779, 0.709798], 
          TagBox[SphereBox[{0, 0, 0}, 0.5],
           "Ball"]},
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{0., 0., 1.8}, 0.5],
           "Ball"]},
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
           "Ball"]},
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
           "Ball"]},
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
           "Ball"]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.560181, 0.691569, 0.194885], 
          TagBox[SphereBox[{0.8, 0.8, 0.8}, 0.5],
           "Ball"]},
         "6"],
        Annotation[#, 6, "Tooltip"]& ], {}},
      BaseStyle->{
        Specularity[
         GrayLevel[0.5], 100]},
      Boxed->False,
      Lighting->"Neutral",
      PlotLabel->FormBox[
        TemplateBox[{"4", "\" corners, \"", "\"\"", "\" mixed corners\""}, 
         "RowDefault"], TraditionalForm],
      SphericalRegion->True], 
     Graphics3DBox[{{}, {}, 
       TagBox[
        TooltipBox[
         {RGBColor[0.368417, 0.506779, 0.709798], 
          TagBox[SphereBox[{0, 0, 0}, 0.5],
           "Ball"]},
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{0., 0., 1.8}, 0.5],
           "Ball"]},
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
           "Ball"]},
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
           "Ball"]},
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
           "Ball"]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.560181, 0.691569, 0.194885], 
          TagBox[SphereBox[{0.8, 0.8, 0.8}, 0.5],
           "Ball"]},
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[
        Thickness[Large]], 
        GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
         1.5, -0.6}, {1.7, 0., -0.6}, {0.8, 0.8, 
         0.8}}, {Polygon3DBox[{2, 3, 4}], Polygon3DBox[{3, 5, 4}], 
          Polygon3DBox[{4, 5, 1}], Polygon3DBox[{5, 3, 1}], 
          Polygon3DBox[{3, 2, 1}], Polygon3DBox[{2, 4, 1}]}]}},
      BaseStyle->{
        Specularity[
         GrayLevel[0.5], 100]},
      Boxed->False,
      Lighting->"Neutral",
      PlotLabel->FormBox[
        TemplateBox[{"5", "\" corners, \"", "\"\"", "\" mixed corners\""}, 
         "RowDefault"], TraditionalForm],
      SphericalRegion->True]},
    {
     Graphics3DBox[{{}, {}, 
       TagBox[
        TooltipBox[
         {RGBColor[0.368417, 0.506779, 0.709798], 
          TagBox[SphereBox[{0, 0, 0}, 0.5],
           "Ball"]},
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{0., 0., 1.8}, 0.5],
           "Ball"]},
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
           "Ball"]},
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
           "Ball"]},
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
           "Ball"]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.560181, 0.691569, 0.194885], 
          TagBox[SphereBox[{0.8, 0.8, 0.8}, 0.5],
           "Ball"]},
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[
        Thickness[Large]], 
        GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
         1.5, -0.6}, {1.7, 
         0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
          Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
      BaseStyle->{
        Specularity[
         GrayLevel[0.5], 100]},
      Boxed->False,
      Lighting->"Neutral",
      PlotLabel->FormBox[
        TemplateBox[{"4", "\" corners, \"", "\"no\"", "\" mixed corners\""}, 
         "RowDefault"], TraditionalForm],
      SphericalRegion->True], 
     Graphics3DBox[{{}, {}, 
       TagBox[
        TooltipBox[
         {RGBColor[0.368417, 0.506779, 0.709798], 
          TagBox[SphereBox[{0, 0, 0}, 0.5],
           "Ball"]},
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{0., 0., 1.8}, 0.5],
           "Ball"]},
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
           "Ball"]},
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
           "Ball"]},
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.880722, 0.611041, 0.142051], 
          TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
           "Ball"]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {RGBColor[0.560181, 0.691569, 0.194885], 
          TagBox[SphereBox[{0.8, 0.8, 0.8}, 0.5],
           "Ball"]},
         "6"],
        Annotation[#, 6, "Tooltip"]& ], {}},
      BaseStyle->{
        Specularity[
         GrayLevel[0.5], 100]},
      Boxed->False,
      Lighting->"Neutral",
      PlotLabel->FormBox[
        TemplateBox[{"5", "\" corners, \"", "\"no\"", "\" mixed corners\""}, 
         "RowDefault"], TraditionalForm],
      SphericalRegion->True]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "Rows" -> {False, {True}, False}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output"]
}, Open  ]],

Cell["\<\
In default mode, polyhedron construction is rather susceptible to false \
positives in order to avoid false negatives:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "1.3", ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", 
       RowBox[{"-", "1.3"}], ",", "1.5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0., 0., 0.}, {0.75, 0., 0.}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{1.5, 0., 0.}, {0.75, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{1.5, 0., 0.}, {2.25, 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3., 0., 0.}, {2.25, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{1.5, 0., 0.}, {1.5, 0.65, 0.75}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.5, 1.3, 1.5}, {1.5, 0.65, 0.75}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{1.5, 0., 0.}, {1.5, -0.65, 0.75}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.5, -1.3, 1.5}, {1.5, -0.65, 0.75}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 0., 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.3, 1.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, -1.3, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
    GraphicsComplex3DBox[{{0., 0., 0.}, {3., 0., 0.}, {1.5, 1.3, 1.5}, {
     1.5, -1.3, 
     1.5}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
      Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1659, 917},
WindowMargins->{{2, Automatic}, {Automatic, -1}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "PolyMode[cornercount] is an option of CrystalPlot that defines the \
general mode of coordination polyhedra.", "synonyms" -> {}, "title" -> 
    "PolyMode", "type" -> "Symbol", "uri" -> "Crystallica/ref/PolyMode"}, 
  "SearchTextTranslated" -> "", "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3577702899-2097078"->{
  Cell[755, 31, 214, 4, 40, "Print",
   CellTags->"Info3577702899-2097078"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3577702899-2097078", 47382, 1429}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 173, 7, 70, "Section"],
Cell[755, 31, 214, 4, 40, "Print",
 CellTags->"Info3577702899-2097078"],
Cell[972, 37, 162, 6, 29, "Item"],
Cell[CellGroupData[{
Cell[1159, 47, 180, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[1364, 54, 136, 3, 25, "Subitem"],
Cell[1503, 59, 136, 3, 25, "Subitem"],
Cell[1642, 64, 321, 6, 25, "Subitem"]
}, Open  ]]
}, Open  ]],
Cell[1990, 74, 88, 2, 29, "Item"],
Cell[2081, 78, 168, 6, 29, "Item"],
Cell[2252, 86, 50, 0, 29, "Item"],
Cell[2305, 88, 93, 2, 29, "Item"],
Cell[CellGroupData[{
Cell[2423, 94, 30, 0, 49, "Subsection"],
Cell[2456, 96, 33, 0, 30, "Text"],
Cell[2492, 98, 102, 2, 31, "Input"],
Cell[2597, 102, 177, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[2799, 109, 819, 26, 31, "Input"],
Cell[3621, 137, 2240, 63, 375, "Output"]
}, Open  ]],
Cell[5876, 203, 136, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[6037, 210, 1232, 37, 31, "Input"],
Cell[7272, 249, 10581, 297, 197, "Output"]
}, Open  ]],
Cell[17868, 549, 150, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[18043, 556, 1199, 36, 31, "Input"],
Cell[19245, 594, 4446, 123, 197, "Output"]
}, Open  ]],
Cell[23706, 720, 368, 7, 49, "Text"],
Cell[CellGroupData[{
Cell[24099, 731, 1120, 34, 31, "Input"],
Cell[25222, 767, 2240, 63, 375, "Output"]
}, Open  ]],
Cell[27477, 833, 206, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[27708, 841, 1192, 36, 52, "Input"],
Cell[28903, 879, 4446, 123, 197, "Output"]
}, Open  ]],
Cell[33364, 1005, 215, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[33604, 1013, 2216, 59, 72, "Input"],
Cell[35823, 1074, 7424, 230, 413, "Output"]
}, Open  ]],
Cell[43262, 1307, 142, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[43429, 1314, 705, 21, 31, "Input"],
Cell[44137, 1337, 2208, 63, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
