(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      6321,        220]
NotebookOptionsPosition[      4681,        168]
NotebookOutlinePosition[      5880,        204]
CellTagsIndexPosition[      5796,        199]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Pseudo3DQ",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"Pseudo3DQ is an option of CrystalPlot which determines whether \
2D structures are plotted in pseudo-3D or in true 2D.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3576909172-7396936"],

Cell[TextData[{
 "Pseudo3DQ is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 "."
}], "Item"],

Cell["\<\
If Pseudo3DQ is set to True and the structure is two-dimensional, a \
Graphics3D plot of the structure will be returned. Pseudo3DQ has no effect on \
three-dimensional structures.\
\>", "Item"],

Cell[TextData[{
 "If you want some plot elements to retain their 2D look, use ",
 ButtonBox["BondsFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 ", ",
 ButtonBox["CellLinesFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"],
 " and/or ",
 ButtonBox["AtomFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomFunction"],
 " in conjunction with Pseudo3DQ."
}], "Item"],

Cell["Default: False", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["True 2D layout, and pseudo-3D:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"Pseudo3DQ", "\[Rule]", "p3d"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p3d", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {GrayLevel[0], Thickness[0.01], 
      LineBox[{{0, 0}, {3, 0}, {3, 3}, {0, 3}, {0, 0}}]}, {
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       ArrowBox[{{0, 0}, {3, 0}}]}, 
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       ArrowBox[{{0, 0}, {0, 3}}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[DiskBox[{0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[DiskBox[{1.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]}], ",", 
   Graphics3DBox[{
     {GrayLevel[0], 
      TubeBox[{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, 
       0.02]}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.557281127576427, 0., 0.}, {2.557281127576427, 
         0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.11067971810589329`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.557281127576427, 0.}, {0., 
         2.557281127576427, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.11067971810589329`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 0.}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1659, 917},
WindowMargins->{{2, Automatic}, {Automatic, -1}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "Pseudo3DQ is an option of CrystalPlot which determines whether 2D \
structures are plotted in pseudo-3D or in true 2D.", "synonyms" -> {}, 
    "title" -> "Pseudo3DQ", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/Pseudo3DQ"}, "SearchTextTranslated" -> "", "LinkTrails" -> 
  ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3576909172-7396936"->{
  Cell[756, 31, 224, 4, 40, "Print",
   CellTags->"Info3576909172-7396936"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3576909172-7396936", 5695, 193}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 174, 7, 70, "Section"],
Cell[756, 31, 224, 4, 40, "Print",
 CellTags->"Info3576909172-7396936"],
Cell[983, 37, 163, 6, 29, "Item"],
Cell[1149, 45, 203, 4, 29, "Item"],
Cell[1355, 51, 453, 14, 29, "Item"],
Cell[1811, 67, 30, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1866, 71, 30, 0, 49, "Subsection"],
Cell[1899, 73, 33, 0, 30, "Text"],
Cell[1935, 75, 102, 2, 31, "Input"],
Cell[2040, 79, 46, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2111, 83, 732, 24, 31, "Input"],
Cell[2846, 109, 1795, 54, 230, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
