(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     34022,       1037]
NotebookOptionsPosition[     31313,        951]
NotebookOutlinePosition[     32511,        987]
CellTagsIndexPosition[     32426,        982]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Reshape",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"Reshape is an option of CrystalChange and CrystalPlot which \
builds supercells that are not simple periodic repetitions.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3635234266-5960497"],

Cell[TextData[{
 "Reshape",
 " is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 "."
}], "Item"],

Cell["\<\
Reshape constructs a supercell which is not a simple periodic repetition of \
the unit cell, but a more complex linear combination of the original lattice \
vectors.\
\>", "Item"],

Cell["\<\
The new lattice vectors are given as (new lattice) = (Reshape option value) . \
(old lattice)\
\>", "Item"],

Cell[TextData[{
 "If a reshaped cell is constructed, ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " is automatically reset to True if it was previously False. Stronger \
numerical values of RetractQ may still take effect. ",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"],
 " works as always."
}], "Item"],

Cell[TextData[{
 "Reshape is applied before and independently of ",
 ButtonBox["Sysdim.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"],
 " This means that Sysdim can be used to construct a supercell of the new \
reshaped cell, and options like ",
 ButtonBox["CellLineStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineStyle"],
 " regard the reshaped cell as the unit cell."
}], "Item"],

Cell["\<\
The Reshape option value must be a 3x3 matrix of integers, or a 2x2 matrix \
for two-dimensional structures.\
\>", "Item"],

Cell["\<\
The Reshape option also understands the following named values: \
\[OpenCurlyDoubleQuote]fcc\[CloseCurlyDoubleQuote]; \
\[OpenCurlyDoubleQuote]bcc\[CloseCurlyDoubleQuote]. If any of these values \
are given, Reshape is internally set to the matrix that would transform a \
primitive cell of that type to its conventional counterpart. Note that \
Crystallica does NOT test whether the original cell is actually the correct \
type of primitive cell!\
\>", "Item"],

Cell["Default: {{1,0,0},{0,1,0},{0,0,1}}", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Build a supercell from a linear combination of the original lattice vectors:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Reshape", "\[Rule]", "reshape"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"reshape", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "3", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 6, 0}, {3, 12, 0}, {0, 6, 0}, {0, 0, 0}}, {{0,
         0, 3}, {3, 6, 3}, {3, 12, 3}, {0, 6, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 6, 0}, {3, 6, 3}}, {{3, 12, 0}, {
        3, 12, 3}}, {{0, 6, 0}, {0, 6, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.703409470781691, 5.406818941563382, 0.}, {
         2.703409470781691, 5.406818941563382, 0.}, {3, 6, 0}}, {
        0.021, 0.021, 0.165799146203694, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 5.336803415185224, 0.}, {0., 
         5.336803415185224, 0.}, {0, 6, 0}}, {
        0.021, 0.021, 0.165799146203694, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.336803415185224}, {0., 0., 
         2.336803415185224}, {0, 0, 3}}, {
        0.021, 0.021, 0.165799146203694, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 7.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Reshape also works for two-dimensional structures:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Reshape", "\[Rule]", "reshape"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"reshape", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "2", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {GrayLevel[0], Thickness[0.01], 
      LineBox[{{0, 0}, {3, 0}, {3, 3}, {0, 3}, {0, 0}}]}, {
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       ArrowBox[{{0, 0}, {3, 0}}]}, 
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       ArrowBox[{{0, 0}, {0, 3}}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[DiskBox[{1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]}], ",", 
   GraphicsBox[{
     {GrayLevel[0], Thickness[0.01], 
      LineBox[{{0, 0}, {3, 6}, {3, 12}, {0, 6}, {0, 0}}]}, {
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       ArrowBox[{{0, 0}, {3, 6}}]}, 
      {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
       ArrowBox[{{0, 0}, {0, 6}}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[DiskBox[{1.5, 4.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[DiskBox[{1.5, 7.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
You can still also add simple periodic repetitions on top of Reshape:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Reshape", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Sysdim", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 12, 0}, {0, 12, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 6, 0}, {3, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 12, 0}, {3, 12, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 18, 0}, {3, 18, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 12, 0}, {6, 12, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 18, 0}, {6, 18, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 24, 0}, {6, 24, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {6, 12, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {6, 12, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {6, 18, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 3}, {6, 18, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 12, 0}, {6, 24, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 12, 3}, {6, 24, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 12, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 6, 0}, {3, 18, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 12, 0}, {6, 24, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 12, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 6, 3}, {3, 18, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 12, 3}, {6, 24, 3}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.703409470781691, 5.406818941563382, 0.}, {
       2.703409470781691, 5.406818941563382, 0.}, {3, 6, 0}}, {
      0.021, 0.021, 0.165799146203694, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 5.336803415185224, 0.}, {0., 5.336803415185224, 
       0.}, {0, 6, 0}}, {0.021, 0.021, 0.165799146203694, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.336803415185224}, {0., 0., 
       2.336803415185224}, {0, 0, 3}}, {
      0.021, 0.021, 0.165799146203694, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 7.5, 1.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 10.5, 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 13.5, 1.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 10.5, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 13.5, 1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 16.5, 1.5}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 19.5, 1.5}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Consider this example, using Sysdim twice:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"step1", "=", 
     RowBox[{"CrystalChange", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"Sysdim", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "1"}], "}"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"Sequence", "@@", "step1"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", "2"}]}], "]"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 0, 0}, {12, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 3, 0}, {12, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 6, 0}, {12, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {12, 0, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {12, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 0}, {12, 3, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 3}, {12, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {12, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 3}, {12, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 0, 0}, {12, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 0, 3}, {12, 6, 3}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {5.420344930152423, 0., 0.}, {5.420344930152423, 0., 
       0.}, {6, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4203449301524227`, 0.}, {0., 
       2.4203449301524227`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4203449301524227`}, {0., 0., 
       2.4203449301524227`}, {0, 0, 3}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{7.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{10.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{7.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{10.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
The same result can be achieve in a single step with a combination of Reshape \
and Sysdim:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Reshape", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Sysdim", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 0, 0}, {12, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 3, 0}, {12, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 6, 0}, {12, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {12, 0, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {12, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 0}, {12, 3, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 3}, {12, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {12, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 3}, {12, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 0, 0}, {12, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{12, 0, 3}, {12, 6, 3}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {5.420344930152423, 0., 0.}, {5.420344930152423, 0., 
       0.}, {6, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4203449301524227`, 0.}, {0., 
       2.4203449301524227`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4203449301524227`}, {0., 0., 
       2.4203449301524227`}, {0, 0, 3}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{10.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{7.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{10.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{7.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["A primitive fcc cell and its conventional counterpart:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Reshape", "\[Rule]", "reshape"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"reshape", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "\"\<fcc\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {2, 2, 0}, {4, 2, 2}, {2, 0, 2}, {0, 0, 0}}, {{0, 
        2, 2}, {2, 4, 2}, {4, 4, 4}, {2, 2, 4}, {0, 2, 2}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 2, 2}}, {{2, 2, 0}, {2, 4, 2}}, {{4, 2, 2}, {
        4, 4, 4}}, {{2, 0, 2}, {2, 2, 4}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.6553350333449308`, 1.6553350333449308`, 0.}, {
         1.6553350333449308`, 1.6553350333449308`, 0.}, {2, 2, 0}}, {
        0.021, 0.021, 0.12185746757961738`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.6553350333449308`, 0., 1.6553350333449308`}, {
         1.6553350333449308`, 0., 1.6553350333449308`}, {2, 0, 2}}, {
        0.021, 0.021, 0.12185746757961738`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 1.6553350333449308`, 1.6553350333449308`}, {
         0., 1.6553350333449308`, 1.6553350333449308`}, {0, 2, 2}}, {
        0.021, 0.021, 0.12185746757961738`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {0, 4, 0}, {0, 0, 0}}, {{0, 
        0, 4}, {4, 0, 4}, {4, 4, 4}, {0, 4, 4}, {0, 0, 4}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 4}}, {{4, 0, 0}, {4, 0, 4}}, {{4, 4, 0}, {
        4, 4, 4}}, {{0, 4, 0}, {0, 4, 4}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {
         3.4203449301524227`, 0., 0.}, {4, 0, 0}}, {
        0.021, 0.021, 0.14491376746189438`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
         3.4203449301524227`, 0.}, {0, 4, 0}}, {
        0.021, 0.021, 0.14491376746189438`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
         3.4203449301524227`}, {0, 0, 4}}, {
        0.021, 0.021, 0.14491376746189438`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 2, 2}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{2, 0, 2}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{2, 2, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Sysdim",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"],
 " produces a supercell of the conventional cell, not a conventional cell of \
the supercell:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Reshape", "\[Rule]", "\"\<fcc\>\""}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "2"}], ",", 
   RowBox[{"Sysdim", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 4, 0}, {0, 4, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{4, 0, 0}, {4, 0, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{4, 4, 0}, {4, 4, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{8, 0, 0}, {8, 0, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{8, 4, 0}, {8, 4, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {8, 0, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 4}, {8, 0, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 4, 0}, {8, 4, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 4, 4}, {8, 4, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 4, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{4, 0, 0}, {4, 4, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{8, 0, 0}, {8, 4, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 4}, {0, 4, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{4, 0, 4}, {4, 4, 4}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{8, 0, 4}, {8, 4, 4}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4203449301524227`, 0., 0.}, {3.4203449301524227`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4203449301524227`, 0.}, {0., 
       3.4203449301524227`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 3.4203449301524227`}, {0., 0., 
       3.4203449301524227`}, {0, 0, 4}}, {
      0.021, 0.021, 0.14491376746189438`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 2, 2}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{2, 0, 2}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{2, 2, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4, 2, 2}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 0, 2}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 2, 0}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "Reshape is an option of CrystalChange and CrystalPlot which builds \
supercells that are not simple periodic repetitions.", "synonyms" -> {}, 
    "title" -> "Reshape", "type" -> "Symbol", "uri" -> 
    "Crystallica/ref/Reshape"}, "SearchTextTranslated" -> "", "LinkTrails" -> 
  ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3635234266-5960497"->{
  Cell[754, 31, 228, 4, 40, "Print",
   CellTags->"Info3635234266-5960497"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3635234266-5960497", 32325, 976}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 172, 7, 70, "Section"],
Cell[754, 31, 228, 4, 40, "Print",
 CellTags->"Info3635234266-5960497"],
Cell[985, 37, 280, 11, 29, "Item"],
Cell[1268, 50, 189, 4, 29, "Item"],
Cell[1460, 56, 117, 3, 29, "Item"],
Cell[1580, 61, 396, 11, 29, "Item"],
Cell[1979, 74, 432, 11, 29, "Item"],
Cell[2414, 87, 132, 3, 29, "Item"],
Cell[2549, 92, 471, 8, 45, "Item"],
Cell[3023, 102, 50, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[3098, 106, 30, 0, 49, "Subsection"],
Cell[3131, 108, 33, 0, 30, "Text"],
Cell[3167, 110, 102, 2, 31, "Input"],
Cell[3272, 114, 100, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[3397, 120, 1057, 32, 31, "Input"],
Cell[4457, 154, 2759, 73, 197, "Output"]
}, Open  ]],
Cell[7231, 230, 66, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[7322, 234, 846, 28, 31, "Input"],
Cell[8171, 264, 1316, 37, 233, "Output"]
}, Open  ]],
Cell[9502, 304, 93, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[9620, 310, 942, 28, 31, "Input"],
Cell[10565, 340, 3480, 95, 375, "Output"]
}, Open  ]],
Cell[14060, 438, 58, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[14143, 442, 1022, 29, 31, "Input"],
Cell[15168, 473, 3451, 95, 375, "Output"]
}, Open  ]],
Cell[18634, 571, 115, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[18774, 578, 942, 28, 31, "Input"],
Cell[19719, 608, 3451, 95, 375, "Output"]
}, Open  ]],
Cell[23185, 706, 70, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[23280, 710, 737, 22, 31, "Input"],
Cell[24020, 734, 3216, 87, 197, "Output"]
}, Open  ]],
Cell[27251, 824, 212, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[27488, 834, 693, 20, 31, "Input"],
Cell[28184, 856, 3089, 90, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
