(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9849,        317]
NotebookOptionsPosition[      8086,        261]
NotebookOutlinePosition[      9259,        296]
CellTagsIndexPosition[      9175,        291]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "SortQ (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"SortQ is an option of CrystalChange and CrystalPlot which \
states whether atoms are to be sorted by type.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3569828974-3834481"],

Cell[TextData[{
 "SortQ is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 ".\nIn CrystalPlot, SortQ is most relevant if ",
 ButtonBox["ButtonQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ButtonQ"],
 "->True, but also influences atom numbering and the colour direction of \
colour gradient bonds."
}], "Item"],

Cell["\<\
SortQ determines whether atoms are sorted by type when CrystalChange is \
called. If SortQ is True, atoms will also be sorted by position if they have \
the same type.\
\>", "Item"],

Cell["\<\
SortQ can also be set to \[OpenCurlyDoubleQuote]weak\[CloseCurlyDoubleQuote] \
to sort by types, but leave the ordering of atoms within one type untouched.\
\>", "Item"],

Cell["Default: False", "Item"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Effect of the SortQ option:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"CrystalChange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"Sysdim", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], ",", 
      RowBox[{"SortQ", "\[Rule]", "sort"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"sort", ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.25`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.75`"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.25`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "0.5`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.75`"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}]}], "}"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output"]
}, Open  ]],

Cell["The difference between sorting and weak sorting:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"CrystalChange", "[", 
     RowBox[{
      RowBox[{"3", "*", 
       RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".7", ",", ".7", ",", ".7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".2", ",", ".2", ",", ".2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"SortQ", "\[Rule]", "sort"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"sort", ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "\"\<weak\>\""}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.6999999999999998`", ",", "0.6999999999999998`", ",", 
           "0.6999999999999998`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2`", ",", "0.2`", ",", "0.2`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.6999999999999998`", ",", "0.6999999999999998`", ",", 
           "0.6999999999999998`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2`", ",", "0.2`", ",", "0.2`"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "context" -> "Crystallica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Crystallica Package Symbol", "language" -> "en", "paclet" -> 
    "Crystallica Package", "status" -> "", "summary" -> 
    "SortQ is an option of CrystalChange and CrystalPlot which states whether \
atoms are to be sorted by type.", "synonyms" -> {}, "title" -> "SortQ", 
    "type" -> "Symbol", "uri" -> "Crystallica/ref/SortQ"}, 
  "SearchTextTranslated" -> "", "LinkTrails" -> ""},
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828974-3834481"->{
  Cell[747, 30, 212, 4, 40, "Print",
   CellTags->"Info3569828974-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828974-3834481", 9074, 285}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 165, 6, 70, "Section"],
Cell[747, 30, 212, 4, 40, "Print",
 CellTags->"Info3569828974-3834481"],
Cell[962, 36, 509, 15, 45, "Item"],
Cell[1474, 53, 191, 4, 29, "Item"],
Cell[1668, 59, 179, 3, 29, "Item"],
Cell[1850, 64, 30, 0, 29, "Item"],
Cell[CellGroupData[{
Cell[1905, 68, 30, 0, 49, "Subsection"],
Cell[1938, 70, 33, 0, 30, "Text"],
Cell[1974, 72, 102, 2, 31, "Input"],
Cell[2079, 76, 43, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2147, 80, 1025, 31, 31, "Input"],
Cell[3175, 113, 1863, 52, 42, "Output"]
}, Open  ]],
Cell[5053, 168, 64, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[5142, 172, 902, 26, 31, "Input"],
Cell[6047, 200, 1999, 56, 75, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
