(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      4627,        159]
NotebookOptionsPosition[      3794,        125]
NotebookOutlinePosition[      4191,        142]
CellTagsIndexPosition[      4148,        139]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Crystallica Package", "Section"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Crystallica package contains functions to plot and manipulate crystal \
and molecular structures. Please click the function names below for more \
information and examples:\n",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " - enter the raw data of a crystal or molecular structure and get a plot in \
return\n",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 " - manipulate a crystal structure and get the raw data of the new structure"
}], "Item"],

Cell["\<\
Crystallica package version: 1.0.0 (also accessible by evaluating \
$CrystallicaVersion )\
\>", "Item"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version compatibility:"
}], "Item"],

Cell[CellGroupData[{

Cell["9.x and below: not supported", "Subitem"],

Cell["10.x: supported", "Subitem"],

Cell["\<\
11.x and above: the authors find it unexpectedly difficult to predict the \
future\
\>", "Subitem"]
}, Open  ]],

Cell["\<\
Crystallica can be loaded from any notebook with Needs or Get:\
\>", "Item"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell[CellGroupData[{

Cell["\<\
Printed debugging notes are available by setting $CrystallicaDebugQ=True \
before evaluating a function from the Crystallica package.\
\>", "Item"],

Cell[TextData[{
 "These Demonstrations at the Wolfram Demonstrations Project also use \
modified bits and pieces from Crystallica:\n",
 ButtonBox["Some Representative Crystal Structures",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
SomeRepresentativeCrystalStructures/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/SomeRepresentativeCrystalStructures/"],
 "\n",
 ButtonBox["Organic Molecule Explorer\[LineSeparator]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/OrganicMoleculeExplorer/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/OrganicMoleculeExplorer/"],
 ButtonBox["Cubic Crystal Lattices",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CubicCrystalLattices/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/CubicCrystalLattices/"],
 "\[LineSeparator]",
 ButtonBox["Crystal Lattices in Reciprocal Space",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrystalLatticesInReciprocalSpace/"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrystalLatticesInReciprocalSpace/"]
}], "Item"],

Cell[TextData[{
 "The Crystallica application is provided under the terms of ",
 ButtonBox["the MIT license",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://opensource.org/licenses/MIT"], None},
  ButtonNote->"https://opensource.org/licenses/MIT"],
 " (a copy of the license text is included with the application).\
\[LineSeparator]Copyright (c) 2016 Bianca Eifert and Christian Heiliger\
\[LineSeparator]Institute for Theoretical Physics, JLU Giessen, Germany"
}], "Item"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1660, 914},
WindowMargins->{{-4, Automatic}, {-2, Automatic}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 38, 0, 70, "Section"],
Cell[CellGroupData[{
Cell[642, 26, 584, 13, 62, "Item"],
Cell[1229, 41, 113, 3, 29, "Item"],
Cell[1345, 46, 103, 4, 29, "Item"],
Cell[CellGroupData[{
Cell[1473, 54, 47, 0, 25, "Subitem"],
Cell[1523, 56, 34, 0, 25, "Subitem"],
Cell[1560, 58, 109, 3, 25, "Subitem"]
}, Open  ]],
Cell[1684, 64, 86, 2, 29, "Item"]
}, Open  ]],
Cell[1785, 69, 102, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[1912, 75, 157, 3, 29, "Item"],
Cell[2072, 80, 1206, 29, 96, "Item"],
Cell[3281, 111, 485, 10, 62, "Item"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
