(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      5223,        193]
NotebookOptionsPosition[      4206,        152]
NotebookOutlinePosition[      4750,        175]
CellTagsIndexPosition[      4666,        170]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Acell (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"Acell is an option of CrystalChange and CrystalPlot which \
determines the output format of lattice vectors.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3569828945-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "Acell is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 ".\nIn CrystalPlot, Acell only takes effect if ",
 ButtonBox["ButtonQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ButtonQ"],
 "->True."
}], "Item"],

Cell["\<\
Acell changes the format of the crystal structure data output in the \
following way:
Acell->0      {lattice vectors, atom positions, atom types}
Acell->1      {{lattice constants, normalized lattice vectors}, atom \
positions, atom types}
Acell->2      {{lattice constants, angles between lattice vectors}, atom \
positions, atom types}
This option is independent of the initial input format.\
\>", "Item"],

Cell["\<\
If CrystalPlot or CrystalChange are used with only the lattice vectors as an \
input argument, then only the lattice vector part of the output listed above \
will be returned.\
\>", "Item"],

Cell["Default: 0", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Effect of the Acell option, shown here for lattice vectors only:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"CrystalChange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"Acell", "\[Rule]", "acell"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"acell", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3.`", ",", "3.`", ",", "3.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3.`", ",", "3.`", ",", "3.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"90.`", ",", "90.`", ",", "90.`"}], "}"}]}], "}"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1657, 916},
WindowMargins->{{2, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828945-3834481"->{
  Cell[747, 30, 214, 4, 40, "Print",
   CellTags->"Info3569828945-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828945-3834481", 4565, 164}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 165, 6, 70, "Section"],
Cell[747, 30, 214, 4, 40, "Print",
 CellTags->"Info3569828945-3834481"],
Cell[CellGroupData[{
Cell[986, 38, 422, 14, 45, "Item"],
Cell[1411, 54, 417, 9, 96, "Item"],
Cell[1831, 65, 199, 4, 29, "Item"],
Cell[2033, 71, 26, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2096, 76, 30, 0, 49, "Subsection"],
Cell[2129, 78, 33, 0, 30, "Text"],
Cell[2165, 80, 102, 2, 31, "Input"],
Cell[2270, 84, 88, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[2383, 90, 644, 20, 31, "Input"],
Cell[3030, 112, 1136, 35, 90, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
