(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     85283,       2451]
NotebookOptionsPosition[     83476,       2385]
NotebookOutlinePosition[     84022,       2408]
CellTagsIndexPosition[     83936,       2403]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "AddQ (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"AddQ is an option of CrystalChange and CrystalPlot which \
determines whether periodically duplicate atoms are added at the cell \
edges.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3583500317-6077157"],

Cell[CellGroupData[{

Cell[TextData[{
 "AddQ",
 " is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 "."
}], "Item"],

Cell["\<\
If AddQ is set to True, periodic duplicates of all atoms close to the cell \
edges are added.\
\>", "Item"],

Cell["\<\
In addition to just True and False, AddQ can also be set to the following \
values (all cases are covered by the examples below):\
\>", "Item"],

Cell[CellGroupData[{

Cell["\<\
Numerical value; this effectively sets AddQ to True, but uses the \
user-defined numerical value as a tolerance defining what \
\[OpenCurlyDoubleQuote]close to the cell edges\[CloseCurlyDoubleQuote] \
actually means. Can also be a list of values for the different lattice \
directions.\
\>", "Subitem"],

Cell[TextData[{
 "AddQ->\[OpenCurlyDoubleQuote]hexa\[CloseCurlyDoubleQuote] \[Dash] If the \
structure is a hexagonal cell, atoms will be added to the cell to form a \
conventional cell. The regular behaviour of AddQ->True is added on top, so \
that duplicate atoms at the cell edges are also added. The lattice vectors \
are not changed, so this setting does not create a supercell in any sense. If \
",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " is also used, it is applied only to the original cell. Works only in 3D. \
For conventional fcc and bcc cells, see ",
 ButtonBox["Reshape",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Reshape"],
 "."
}], "Subitem"],

Cell[TextData[{
 "AddQ->\[CloseCurlyDoubleQuote]surfacecut\[CloseCurlyDoubleQuote] \[Dash] If \
the structure is recognized as a surface, all atoms above the vacuum region \
are removed and the lattice vectors are shortened to include only the \
remaining slab. Works best if the vacuum region is located in the middle of \
the cell. This setting is intended for illustration purposes only, the \
resulting cell is not an actual unit cell of the system! The regular \
behavious of AddQ->True is applied to the two non-surface directions. If ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " is also used, it is applied only to the original cell. Works only in 3D."
}], "Subitem"]
}, Open  ]],

Cell["Default: False", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Effect of the AddQ option:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "add"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"add", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 0.}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 0.}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 3.}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Atoms added by ",
 "AddQ",
 " are not removed by ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " so that these two options can be used in conjunction:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".5"}], ",", ".5", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"RetractQ", "\[Rule]", "True"}], ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.5, 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 3, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 3, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 3}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.5, 3.}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 0, 3}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 3, 3}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 3, 3}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
If AddQ is a real or integer number, this number is used as a tolerance value \
for the distance from atoms to the cell boundaries; this tolerance determines \
if an atom is duplicated or not. The default is 0.1, and the value is taken \
to be in reduced coordinates if it is positive, and cartesian (Angstrom) if \
negative. The tolerance can also be given as a list of three values for the \
three lattice directions (or two for two-dimensional structures).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".04", ",", ".04"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".09", ",", ".5", ",", ".09"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".19", ",", ".19", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"BondStyle", "\[Rule]", "False"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "add"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"add", ",", 
     RowBox[{"{", 
      RowBox[{
      "False", ",", "True", ",", "0", ",", ".05", ",", ".1", ",", ".2"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 0.12}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 0.27}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 0.12}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 0.27}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3.2700000000000005`, 1.5, 0.27}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 0.12}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 3.12}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 3.2700000000000005`}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3.2700000000000005`, 1.5, 3.2700000000000005`}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 3.12}, 0.5],
         "Ball"]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 0.12}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 0.27}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 0.12}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 0.27}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 0.12}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 3.12}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 3.12}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 0.12}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 0.27}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3.2700000000000005`, 1.5, 0.27}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 0.12}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 3.12}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 3.2700000000000005`}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3.2700000000000005`, 1.5, 3.2700000000000005`}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 3.12}, 0.5],
         "Ball"]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 0.12}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 0.27}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3.2700000000000005`, 1.5, 0.27}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{3.57, 0.5700000000000001, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 0.12}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{0.5700000000000001, 3.57, 1.5}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.922526, 0.385626, 0.209179], 
        TagBox[SphereBox[{3.57, 3.57, 1.5}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 0.12, 3.12}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{0.27, 1.5, 3.2700000000000005`}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3.2700000000000005`, 1.5, 3.2700000000000005`}, 0.5],
         "Ball"]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "18"],
      Annotation[#, 18, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 3.12, 3.12}, 0.5],
         "Ball"]},
       "19"],
      Annotation[#, 19, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "20"],
      Annotation[#, 20, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["A primitive hexagonal cell and its conventional counterpart:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"structure", "=", 
     RowBox[{"Sequence", "@@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1.8", ",", 
            RowBox[{"-", "3.1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.8", ",", "3.1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "5"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CrystalPlot", "[", "structure", "]"}], ",", 
     RowBox[{"CrystalPlot", "[", 
      RowBox[{"structure", ",", 
       RowBox[{"AddQ", "\[Rule]", "\"\<hexa\>\""}], ",", 
       RowBox[{"CellLineStyle", "\[Rule]", 
        RowBox[{"-", "2"}]}]}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {1.8, -3.1, 0.}, {3.6, 0., 0.}, {1.8, 3.1, 
        0.}, {0., 0., 0.}}, {{0., 0., 5.}, {1.8, -3.1, 5.}, {3.6, 0., 5.}, {
        1.8, 3.1, 5.}, {0., 0., 5.}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {0., 0., 5.}}, {{1.8, -3.1, 0.}, {1.8, -3.1, 
        5.}}, {{3.6, 0., 0.}, {3.6, 0., 5.}}, {{1.8, 3.1, 0.}, {1.8, 3.1, 
        5.}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.5068876136232023`, -2.595195334573293, 0.}, {
         1.5068876136232023`, -2.595195334573293, 0.}, {1.8, -3.1, 0}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.5068876136232023`, 2.595195334573293, 0.}, {
         1.5068876136232023`, 2.595195334573293, 0.}, {1.8, 3.1, 0}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 4.416268365356073}, {0., 0., 
         4.416268365356073}, {0, 0, 5}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.8, 0., 2.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{1.8, -3.1, 0.}, {3.6, 0., 0.}, {1.8, 3.1, 0.}, {-1.8, 3.1, 
        0.}, {-3.6, 0., 0.}, {-1.8, -3.1, 0.}, {1.8, -3.1, 0.}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{1.8, -3.1, 5.}, {3.6, 0., 5.}, {1.8, 3.1, 5.}, {-1.8, 3.1, 
        5.}, {-3.6, 0., 5.}, {-1.8, -3.1, 5.}, {1.8, -3.1, 5.}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {1.8, -3.1, 0.}}, {{0., 0., 0.}, {1.8, 3.1, 
        0.}}, {{0., 0., 0.}, {-3.6, 0., 0.}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 5.}, {1.8, -3.1, 5.}}, {{0., 0., 5.}, {1.8, 3.1, 
        5.}}, {{0., 0., 5.}, {-3.6, 0., 5.}}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0., 0., 0.}, {0., 0., 5.}}, 0.02]}, 
      {GrayLevel[0], TubeBox[CompressedData["
1:eJxTTMoPSmVmYGBgB2ImIAaxz54BgT/2EJrjAAMUYBcXcYDweRwY0AB2cZh6
uDkOqOrRxeHq9+NQvx+7eh64u9HcgyaOYT66f/dj9y/x4QMAlmGNKw==
        "], 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.5068876136232023`, -2.595195334573293, 0.}, {
         1.5068876136232023`, -2.595195334573293, 0.}, {1.8, -3.1, 0}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {1.5068876136232023`, 2.595195334573293, 0.}, {
         1.5068876136232023`, 2.595195334573293, 0.}, {1.8, 3.1, 0}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {-3.000948894334928, 0.007405286759156441, 
         0.}, {-3.000948894334928, 0.007405286759156441, 
         0.}, {-3.5846787517317598`, 0.008845726811989474, 0.}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 4.416268365356073}, {0., 0., 
         4.416268365356073}, {0, 0, 5}}, {
        0.021, 0.021, 0.14593290866098177`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-3.6, 0., 0.}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.8, 0., 2.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.8, 3.1, 0.}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 3.1, 2.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.8, -3.1, 0.}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., -3.1, 2.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.8, 0., 2.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.8, -3.1, 0.}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.8, 3.1, 0.}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.6, 0., 0.}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-3.6, 0., 5.}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.8, 3.1, 5.}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.8, -3.1, 5.}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 5.}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.8, -3.1, 5.}, 0.5],
         "Ball"]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.8, 3.1, 5.}, 0.5],
         "Ball"]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.6, 0., 5.}, 0.5],
         "Ball"]},
       "18"],
      Annotation[#, 18, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["A surface and its cut-off version:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"structure", "=", 
     RowBox[{"Sequence", "@@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"6.4", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3.1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "38.4"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".16"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", ".17"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", "0", ",", ".08"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".08"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".92"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", "0", ",", ".92"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", ".83"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".84"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".31", ",", "0", ",", ".17"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".69", ",", "0", ",", ".17"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".14"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".11"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".19", ",", "0", ",", ".08"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".81", ",", "0", ",", ".08"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".05"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".03"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".31", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".69", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".97"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".95"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".19", ",", "0", ",", ".92"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".81", ",", "0", ",", ".92"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5", ",", ".89"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".86"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".31", ",", "0", ",", ".83"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".69", ",", "0", ",", ".83"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5", ",", ".80"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
           "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", 
          ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
          "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
          ",", "2", ",", "2", ",", "2"}], "}"}]}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CrystalPlot", "[", "structure", "]"}], ",", 
     RowBox[{"CrystalPlot", "[", 
      RowBox[{"structure", ",", 
       RowBox[{"AddQ", "\[Rule]", "\"\<surfacecut\>\""}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {6.4, 0., 0.}, {6.4, 3.1, 0.}, {0., 3.1, 0.}, {
        0., 0., 0.}}, {{0., 0., 38.4}, {6.4, 0., 38.4}, {6.4, 3.1, 38.4}, {0.,
         3.1, 38.4}, {0., 0., 38.4}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {0., 0., 38.4}}, {{6.4, 0., 0.}, {6.4, 0., 
        38.4}}, {{6.4, 3.1, 0.}, {6.4, 3.1, 38.4}}, {{0., 3.1, 0.}, {0., 3.1, 
        38.4}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {5.241898104655727, 0., 0.}, {5.241898104655727, 
         0., 0.}, {6.4, 0, 0}}, {0.021, 0.021, 0.2895254738360685, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 1.941898104655726, 0.}, {0., 
         1.941898104655726, 0.}, {0, 3.1, 0}}, {
        0.021, 0.021, 0.2895254738360685, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 37.241898104655725`}, {0., 0., 
         37.241898104655725`}, {0, 0, 38.4}}, {
        0.021, 0.021, 0.2895254738360685, 0}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {2.592, 0.775, 6.336}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 6.5280000000000005`}, {2.592, 0.775, 6.336}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {3.808, 0.775, 6.336}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.4159999999999995`, 0., 6.5280000000000005`}, {3.808, 0.775,
         6.336}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {3.2, 1.55, 5.184}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 4.224}, {3.2, 1.55, 5.184}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 6.5280000000000005`}, {0., 0.775, 7.104}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 7.68}, {0., 0.775, 7.104}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 6.5280000000000005`}, {0.992, 0., 
        6.5280000000000005`}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 6.5280000000000005`}, {0.992, 0., 
        6.5280000000000005`}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 6.5280000000000005`}, {0., 0.775, 5.952}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 5.376}, {0., 0.775, 5.952}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {3.2, 0.775, 3.648}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 4.224}, {3.2, 0.775, 3.648}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {2.208, 0., 3.072}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 0., 3.072}, {2.208, 0., 3.072}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {4.192, 0., 3.072}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{5.184000000000001, 0., 3.072}, {4.192, 0., 3.072}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {3.2, 0.775, 2.496}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 1.92}, {3.2, 0.775, 2.496}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 3.072}, {0.6080000000000001, 0.775, 3.072}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 0., 3.072}, {0.6080000000000001, 0.775, 
        3.072}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 3.072}, {0., 1.55, 2.112}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 1.152}, {0., 1.55, 2.112}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {3.2, 1.55, 0.96}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 1.92}, {3.2, 1.55, 0.96}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {2.592, 0.775, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 0.}, {2.592, 0.775, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {3.808, 0.775, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.4159999999999995`, 0., 0.}, {3.808, 0.775, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0.775, 0.576}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 1.152}, {0., 0.775, 0.576}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.992, 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 0.}, {0.992, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 35.328}, {0., 1.55, 36.288}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 37.248}, {0., 1.55, 36.288}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 35.328}, {0.6080000000000001, 0.775, 35.328}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 0., 35.328}, {0.6080000000000001, 0.775,
         35.328}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 35.328}, {3.2, 0.775, 35.903999999999996`}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 36.48}, {3.2, 0.775, 35.903999999999996`}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 35.328}, {2.208, 0., 35.328}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 0., 35.328}, {2.208, 0., 35.328}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 35.328}, {4.192, 0., 35.328}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{5.184000000000001, 0., 35.328}, {4.192, 0., 35.328}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 35.328}, {3.2, 0.775, 34.752}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 34.176}, {3.2, 0.775, 34.752}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 31.871999999999996`}, {0., 0.775, 32.448}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 33.024}, {0., 0.775, 32.448}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 31.871999999999996`}, {0.992, 0., 
        31.871999999999996`}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 31.871999999999996`}, {0.992, 0., 
        31.871999999999996`}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 31.871999999999996`}, {0., 0.775, 31.296}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 30.72}, {0., 0.775, 31.296}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 32.256}, {3.2, 1.55, 33.216}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 34.176}, {3.2, 1.55, 33.216}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 32.256}, {2.592, 0.775, 32.064}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 31.871999999999996`}, {2.592, 0.775, 32.064}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 32.256}, {3.808, 0.775, 32.064}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.4159999999999995`, 0., 31.871999999999996`}, {3.808, 0.775,
         32.064}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 1.55, 6.144}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 6.5280000000000005`}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 0., 3.072}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 1.55, 3.072}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 1.55, 0.}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 1.55, 35.328}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 0., 35.328}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 31.871999999999996`}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 1.55, 32.256}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 7.68}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 0., 6.5280000000000005`}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.4159999999999995`, 0., 6.5280000000000005`}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 5.376}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 1.55, 4.224}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2160000000000002`, 0., 3.072}, 0.5],
         "Ball"]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{5.184000000000001, 0., 3.072}, 0.5],
         "Ball"]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 1.55, 1.92}, 0.5],
         "Ball"]},
       "18"],
      Annotation[#, 18, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 1.152}, 0.5],
         "Ball"]},
       "19"],
      Annotation[#, 19, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 0., 0.}, 0.5],
         "Ball"]},
       "20"],
      Annotation[#, 20, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.4159999999999995`, 0., 0.}, 0.5],
         "Ball"]},
       "21"],
      Annotation[#, 21, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 37.248}, 0.5],
         "Ball"]},
       "22"],
      Annotation[#, 22, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 1.55, 36.48}, 0.5],
         "Ball"]},
       "23"],
      Annotation[#, 23, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2160000000000002`, 0., 35.328}, 0.5],
         "Ball"]},
       "24"],
      Annotation[#, 24, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{5.184000000000001, 0., 35.328}, 0.5],
         "Ball"]},
       "25"],
      Annotation[#, 25, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 1.55, 34.176}, 0.5],
         "Ball"]},
       "26"],
      Annotation[#, 26, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 33.024}, 0.5],
         "Ball"]},
       "27"],
      Annotation[#, 27, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 0., 31.871999999999996`}, 0.5],
         "Ball"]},
       "28"],
      Annotation[#, 28, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.4159999999999995`, 0., 31.871999999999996`}, 0.5],
         "Ball"]},
       "29"],
      Annotation[#, 29, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 30.72}, 0.5],
         "Ball"]},
       "30"],
      Annotation[#, 30, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {6.4, 0., 0.}, {6.4, 3.1, 0.}, {0., 3.1, 0.}, {
        0., 0., 0.}}, {{0., 0., 7.68}, {6.4, 0., 7.68}, {6.4, 3.1, 7.68}, {0.,
         3.1, 7.68}, {0., 0., 7.68}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {0., 0., 7.68}}, {{6.4, 0., 0.}, {6.4, 0., 
        7.68}}, {{6.4, 3.1, 0.}, {6.4, 3.1, 7.68}}, {{0., 3.1, 0.}, {0., 3.1, 
        7.68}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {5.706429527733483, 0., 0.}, {5.706429527733483, 
         0., 0.}, {6.4, 0, 0.}}, {0.021, 0.021, 0.17339261806662937`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.406429527733483, 0.}, {0., 
         2.406429527733483, 0.}, {0, 3.1, 0.}}, {
        0.021, 0.021, 0.17339261806662937`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 6.986429527733482}, {0., 0., 
         6.986429527733482}, {0, 0, 7.68}}, {
        0.021, 0.021, 0.17339261806662937`, 0}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {2.592, 0.775, 6.336}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 6.528}, {2.592, 0.775, 6.336}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {3.8080000000000003`, 0.775, 6.336}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 0., 6.528}, {3.8080000000000003`, 0.775, 6.336}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {3.2, 1.55, 5.184}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 4.224}, {3.2, 1.55, 5.184}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {2.592, 2.325, 6.336}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 3.1, 6.528}, {2.592, 2.325, 6.336}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 6.144}, {3.8080000000000003`, 2.325, 6.336}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 3.1, 6.528}, {3.8080000000000003`, 2.325, 6.336}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 6.528}, {0., 0.775, 7.103999999999999}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 7.68}, {0., 0.775, 7.103999999999999}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 6.528}, {0.992, 0., 6.528}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 6.528}, {0.992, 0., 6.528}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 6.528}, {0., 0.775, 5.952}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 5.376}, {0., 0.775, 5.952}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {3.2, 0.775, 3.648}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 4.224}, {3.2, 0.775, 3.648}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {2.208, 0., 3.072}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 0., 3.072}, {2.208, 0., 3.072}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {4.192, 0., 3.072}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{5.184000000000001, 0., 3.072}, {4.192, 0., 3.072}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 0., 3.072}, {3.2, 0.775, 2.496}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 1.92}, {3.2, 0.775, 2.496}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 3.072}, {0.6080000000000001, 0.775, 3.072}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 0., 3.072}, {0.6080000000000001, 0.775, 
        3.072}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 3.072}, {0., 1.55, 2.112}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 1.152}, {0., 1.55, 2.112}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 1.55, 3.072}, {0.6080000000000001, 2.325, 3.072}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 3.1, 3.072}, {0.6080000000000001, 2.325,
         3.072}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {3.2, 1.55, 0.96}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 1.92}, {3.2, 1.55, 0.96}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {2.592, 0.775, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 0.}, {2.592, 0.775, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {3.8080000000000003`, 0.775, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 0., 0.}, {3.8080000000000003`, 0.775, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {2.592, 2.325, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 3.1, 0.}, {2.592, 2.325, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 1.55, 0.}, {3.8080000000000003`, 2.325, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 3.1, 0.}, {3.8080000000000003`, 2.325, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0., 0.775, 0.576}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 1.152}, {0., 0.775, 0.576}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.992, 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 0., 0.}, {0.992, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 7.68}, {0., 2.325, 7.103999999999999}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 3.1, 6.528}, {0., 2.325, 7.103999999999999}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 0., 6.528}, {5.408, 0., 6.528}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 0., 6.528}, {5.408, 0., 6.528}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 5.376}, {0., 2.325, 5.952}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 3.1, 6.528}, {0., 2.325, 5.952}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 4.224}, {3.2, 2.325, 3.648}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 3.1, 3.072}, {3.2, 2.325, 3.648}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{5.184000000000001, 0., 3.072}, {5.792000000000001, 0.775, 
        3.072}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 1.55, 3.072}, {5.792000000000001, 0.775, 3.072}}, 
        0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 1.55, 1.92}, {3.2, 2.325, 2.496}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 3.1, 3.072}, {3.2, 2.325, 2.496}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0., 1.55, 1.152}, {0., 2.325, 0.576}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 3.1, 0.}, {0., 2.325, 0.576}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 0., 0.}, {5.408, 0., 0.}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 0., 0.}, {5.408, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 0., 6.528}, {6.4, 0.775, 7.103999999999999}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 7.68}, {6.4, 0.775, 7.103999999999999}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 0., 6.528}, {6.4, 0.775, 5.952}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 5.376}, {6.4, 0.775, 5.952}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 1.55, 3.072}, {6.4, 1.55, 2.112}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 1.152}, {6.4, 1.55, 2.112}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 1.55, 3.072}, {5.792000000000001, 2.325, 3.072}}, 
        0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{5.184000000000001, 3.1, 3.072}, {5.792000000000001, 2.325, 
        3.072}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 0., 0.}, {6.4, 0.775, 0.576}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 1.152}, {6.4, 0.775, 0.576}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 7.68}, {6.4, 2.325, 7.103999999999999}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 3.1, 6.528}, {6.4, 2.325, 7.103999999999999}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 5.376}, {6.4, 2.325, 5.952}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 3.1, 6.528}, {6.4, 2.325, 5.952}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{6.4, 1.55, 1.152}, {6.4, 2.325, 0.576}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 3.1, 0.}, {6.4, 2.325, 0.576}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 3.1, 6.528}, {0.992, 3.1, 6.528}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 3.1, 6.528}, {0.992, 3.1, 6.528}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 3.1, 3.072}, {2.208, 3.1, 3.072}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2160000000000002`, 3.1, 3.072}, {2.208, 3.1, 3.072}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{3.2, 3.1, 3.072}, {4.192, 3.1, 3.072}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{5.184000000000001, 3.1, 3.072}, {4.192, 3.1, 3.072}}, 
        0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 3.1, 0.}, {0.992, 3.1, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.984, 3.1, 0.}, {0.992, 3.1, 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 3.1, 6.528}, {5.408, 3.1, 6.528}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 3.1, 6.528}, {5.408, 3.1, 6.528}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{4.416, 3.1, 0.}, {5.408, 3.1, 0.}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{6.4, 3.1, 0.}, {5.408, 3.1, 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 1.55, 6.144}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 6.528}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 0., 3.072}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 1.55, 3.072}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 1.55, 0.}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 7.68}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 0., 6.528}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.416, 0., 6.528}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 5.376}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 1.55, 4.224}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2160000000000002`, 0., 3.072}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{5.184000000000001, 0., 3.072}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 1.55, 1.92}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 1.55, 1.152}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 0., 0.}, 0.5],
         "Ball"]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.416, 0., 0.}, 0.5],
         "Ball"]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{6.4, 0., 6.528}, 0.5],
         "Ball"]},
       "18"],
      Annotation[#, 18, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{6.4, 1.55, 3.072}, 0.5],
         "Ball"]},
       "19"],
      Annotation[#, 19, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{6.4, 0., 0.}, 0.5],
         "Ball"]},
       "20"],
      Annotation[#, 20, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{6.4, 1.55, 7.68}, 0.5],
         "Ball"]},
       "21"],
      Annotation[#, 21, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{6.4, 1.55, 5.376}, 0.5],
         "Ball"]},
       "22"],
      Annotation[#, 22, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{6.4, 1.55, 1.152}, 0.5],
         "Ball"]},
       "23"],
      Annotation[#, 23, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 3.1, 6.528}, 0.5],
         "Ball"]},
       "24"],
      Annotation[#, 24, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3.2, 3.1, 3.072}, 0.5],
         "Ball"]},
       "25"],
      Annotation[#, 25, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 3.1, 0.}, 0.5],
         "Ball"]},
       "26"],
      Annotation[#, 26, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 3.1, 6.528}, 0.5],
         "Ball"]},
       "27"],
      Annotation[#, 27, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.416, 3.1, 6.528}, 0.5],
         "Ball"]},
       "28"],
      Annotation[#, 28, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2160000000000002`, 3.1, 3.072}, 0.5],
         "Ball"]},
       "29"],
      Annotation[#, 29, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{5.184000000000001, 3.1, 3.072}, 0.5],
         "Ball"]},
       "30"],
      Annotation[#, 30, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.984, 3.1, 0.}, 0.5],
         "Ball"]},
       "31"],
      Annotation[#, 31, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{4.416, 3.1, 0.}, 0.5],
         "Ball"]},
       "32"],
      Annotation[#, 32, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{6.4, 3.1, 6.528}, 0.5],
         "Ball"]},
       "33"],
      Annotation[#, 33, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{6.4, 3.1, 0.}, 0.5],
         "Ball"]},
       "34"],
      Annotation[#, 34, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3583500317-6077157"->{
  Cell[746, 30, 241, 4, 40, "Print",
   CellTags->"Info3583500317-6077157"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3583500317-6077157", 83835, 2397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 164, 6, 70, "Section"],
Cell[746, 30, 241, 4, 40, "Print",
 CellTags->"Info3583500317-6077157"],
Cell[CellGroupData[{
Cell[1012, 38, 277, 11, 29, "Item"],
Cell[1292, 51, 117, 3, 29, "Item"],
Cell[1412, 56, 153, 3, 29, "Item"],
Cell[CellGroupData[{
Cell[1590, 63, 312, 6, 25, "Subitem"],
Cell[1905, 71, 731, 16, 41, "Subitem"],
Cell[2639, 89, 729, 12, 58, "Subitem"]
}, Open  ]],
Cell[3383, 104, 30, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3450, 109, 30, 0, 49, "Subsection"],
Cell[3483, 111, 33, 0, 30, "Text"],
Cell[3519, 113, 102, 2, 31, "Input"],
Cell[3624, 117, 42, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[3691, 121, 844, 26, 31, "Input"],
Cell[4538, 149, 4482, 136, 197, "Output"]
}, Open  ]],
Cell[9035, 288, 233, 8, 30, "Text"],
Cell[CellGroupData[{
Cell[9293, 300, 798, 24, 31, "Input"],
Cell[10094, 326, 2811, 94, 375, "Output"]
}, Open  ]],
Cell[12920, 423, 483, 7, 49, "Text"],
Cell[CellGroupData[{
Cell[13428, 434, 1143, 33, 52, "Input"],
Cell[14574, 469, 23140, 733, 197, "Output"]
}, Open  ]],
Cell[37729, 1205, 76, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[37830, 1209, 1154, 33, 31, "Input"],
Cell[38987, 1244, 7213, 210, 197, "Output"]
}, Open  ]],
Cell[46215, 1457, 50, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[46290, 1461, 3805, 92, 132, "Input"],
Cell[50098, 1555, 33338, 825, 197, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
