(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     59047,       1595]
NotebookOptionsPosition[     57252,       1529]
NotebookOutlinePosition[     57798,       1552]
CellTagsIndexPosition[     57712,       1547]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "AtomCol (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"AtomCol is an option of CrystalPlot which provides a list of \
atom colours.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828925-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "AtomCol is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other atom-related options are ",
 ButtonBox["AtomFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomFunction"],
 " and ",
 ButtonBox["AtomRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AtomRad"],
 "."
}], "Item"],

Cell["\<\
AtomCol provides a list of atom colours to be used, with one colour per \
chemical species. The list may contain explicit colours, chemical atom types, \
members of ColorData[\[CloseCurlyDoubleQuote]Legacy\[CloseCurlyDoubleQuote]], \
or a mix of these.\
\>", "Item"],

Cell["\<\
Alternatively, AtomCol can be set to a member of ColorData[\"Gradients\"] or \
ColorData[\[OpenCurlyDoubleQuote]Indexed\[CloseCurlyDoubleQuote]], in which \
case CrystalPlot will select colours from the respective colour scheme.\
\>", "Item"],

Cell["Default: 97", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Chemical elements, explicit colours, and legacy colours:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Ag\>\"", ",", "\"\<Au\>\"", ",", "\"\<Ru\>\"", ",", "\"\<O\>\"", 
      ",", "\"\<N\>\"", ",", "Black", ",", "Red", ",", 
      RowBox[{"Darker", "[", "Blue", "]"}], ",", "\"\<TerreVerte\>\"", ",", 
      "\"\<BlueViolet\>\""}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.752941, 0.752941, 0.752941], 
     TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
    {RGBColor[1., 0.819608, 0.137255], 
     TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.752941, 0.752941, 0.752941], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.157459, 0.586546, 0.638209], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[1., 0.819608, 0.137255], 
     TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.157459, 0.586546, 0.638209], 
     TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[1., 0.819608, 0.137255], 
     TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.157459, 0.586546, 0.638209], 
     TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.157459, 0.586546, 0.638209], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
    {RGBColor[0.291989, 0.437977, 0.888609], 
     TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.291989, 0.437977, 0.888609], 
     TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.800498, 0.201504, 0.192061], 
     TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
    {GrayLevel[0], TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.291989, 0.437977, 0.888609], 
     TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
    {GrayLevel[0], TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.291989, 0.437977, 0.888609], 
     TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
    {RGBColor[1, 0, 0], TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
    {GrayLevel[0], TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
    {RGBColor[1, 0, 0], TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
    {GrayLevel[0], TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
    {RGBColor[0, 0, 
      NCache[
       Rational[2, 3], 0.6666666666666666]], 
     TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
    {RGBColor[1, 0, 0], TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0, 0, 
      NCache[
       Rational[2, 3], 0.6666666666666666]], 
     TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[1, 0, 0], TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
    {RGBColor[0.219993, 0.370006, 0.059999], 
     TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
    {RGBColor[0, 0, 
      NCache[
       Rational[2, 3], 0.6666666666666666]], 
     TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.219993, 0.370006, 0.059999], 
     TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0, 0, 
      NCache[
       Rational[2, 3], 0.6666666666666666]], 
     TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
    {RGBColor[0.5412, 0.1686, 0.886303], 
     TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.219993, 0.370006, 0.059999], 
     TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.5412, 0.1686, 0.886303], 
     TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.752941, 0.752941, 0.752941], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[1., 0.819608, 0.137255], 
      TagBox[SphereBox[{1, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.157459, 0.586546, 0.638209], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.800498, 0.201504, 0.192061], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.291989, 0.437977, 0.888609], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {GrayLevel[0], 
      TagBox[SphereBox[{5, 0, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[1, 0, 0], 
      TagBox[SphereBox[{6, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0, 0, 
       NCache[
        Rational[2, 3], 0.6666666666666666]], 
      TagBox[SphereBox[{7, 0, 0}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.219993, 0.370006, 0.059999], 
      TagBox[SphereBox[{8, 0, 0}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.5412, 0.1686, 0.886303], 
      TagBox[SphereBox[{9, 0, 0}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Crystllica also knows about binary and ternary oxides and offers reasonable \
colour schemes:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", "\"\<Oxide\>\""}]}], "]"}], ",", 
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", "\"\<ReverseOxide\>\""}]}], "]"}], ",", 
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", "\"\<TernaryOxide\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.4, 0.45, 0.45], TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8, 0.2, 0.2], TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.4, 0.45, 0.45], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.8, 0.2, 0.2], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.8, 0.2, 0.2], TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.4, 0.45, 0.45], TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.8, 0.2, 0.2], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.4, 0.45, 0.45], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.4, 0.4, 0.4], TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8, 0.2, 0.2], TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.15, 0.6, 0.6], TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8, 0.2, 0.2], TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.4, 0.4, 0.4], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.15, 0.6, 0.6], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.8, 0.2, 0.2], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Pre-defined gradient colour scheme:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", "\"\<SouthwestColors\>\""}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.5903749, 0.28462950000000004`, 0.15513149999999998`], 
     TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.817882, 0.7260905, 0.426991], 
     TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.5903749, 0.28462950000000004`, 0.15513149999999998`], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.5383754999999999, 0.6729875, 0.49908170000000024`], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.817882, 0.7260905, 0.426991], 
     TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.5383754999999999, 0.6729875, 0.49908170000000024`], 
     TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.817882, 0.7260905, 0.426991], 
     TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
    {RGBColor[0.7107918000000001, 0.4905029000000001, 0.2686893000000001], 
     TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.5383754999999999, 0.6729875, 0.49908170000000024`], 
     TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.7107918000000001, 0.4905029000000001, 0.2686893000000001], 
     TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.5383754999999999, 0.6729875, 0.49908170000000024`], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
    {RGBColor[0.7998088, 0.7938813, 0.3432391999999999], 
     TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7107918000000001, 0.4905029000000001, 0.2686893000000001], 
     TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.7998088, 0.7938813, 0.3432391999999999], 
     TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7107918000000001, 0.4905029000000001, 0.2686893000000001], 
     TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
    {RGBColor[0.396811, 0.31014, 0.204105], 
     TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7998088, 0.7938813, 0.3432391999999999], 
     TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.396811, 0.31014, 0.204105], 
     TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7998088, 0.7938813, 0.3432391999999999], 
     TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
    {RGBColor[0.7652346000000001, 0.6211898, 0.386211], 
     TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.396811, 0.31014, 0.204105], 
     TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.7652346000000001, 0.6211898, 0.386211], 
     TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.396811, 0.31014, 0.204105], 
     TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
    {RGBColor[0.6916669999999999, 0.7403298, 0.31124540000000006`], 
     TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7652346000000001, 0.6211898, 0.386211], 
     TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.6916669999999999, 0.7403298, 0.31124540000000006`], 
     TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7652346000000001, 0.6211898, 0.386211], 
     TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
    {RGBColor[0.6612548, 0.3598462, 0.15670679999999998`], 
     TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6916669999999999, 0.7403298, 0.31124540000000006`], 
     TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.6612548, 0.3598462, 0.15670679999999998`], 
     TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6916669999999999, 0.7403298, 0.31124540000000006`], 
     TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
    {RGBColor[0.8397022, 0.7895904, 0.40169179999999993`], 
     TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6612548, 0.3598462, 0.15670679999999998`], 
     TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.8397022, 0.7895904, 0.40169179999999993`], 
     TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.5903749, 0.28462950000000004`, 0.15513149999999998`], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.817882, 0.7260905, 0.426991], 
      TagBox[SphereBox[{1, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.5383754999999999, 0.6729875, 0.49908170000000024`], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.7107918000000001, 0.4905029000000001, 0.2686893000000001], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.7998088, 0.7938813, 0.3432391999999999], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.396811, 0.31014, 0.204105], 
      TagBox[SphereBox[{5, 0, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.7652346000000001, 0.6211898, 0.386211], 
      TagBox[SphereBox[{6, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6916669999999999, 0.7403298, 0.31124540000000006`], 
      TagBox[SphereBox[{7, 0, 0}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6612548, 0.3598462, 0.15670679999999998`], 
      TagBox[SphereBox[{8, 0, 0}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.8397022, 0.7895904, 0.40169179999999993`], 
      TagBox[SphereBox[{9, 0, 0}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Pre-defined indexed colour scheme:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", "38"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.5686274509803921, 0.2980392156862745, 0.1450980392156863], 
     TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.7058823529411765, 0.6980392156862745, 0.4980392156862745], 
     TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.5686274509803921, 0.2980392156862745, 0.1450980392156863], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.6509803921568628, 0.7607843137254902, 0.22745098039215686`], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7058823529411765, 0.6980392156862745, 0.4980392156862745], 
     TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.6509803921568628, 0.7607843137254902, 0.22745098039215686`], 
     TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.7058823529411765, 0.6980392156862745, 0.4980392156862745], 
     TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
    {RGBColor[0.39215686274509803`, 0.7294117647058823, 0.5843137254901961], 
     TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6509803921568628, 0.7607843137254902, 0.22745098039215686`], 
     TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.39215686274509803`, 0.7294117647058823, 0.5843137254901961], 
     TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6509803921568628, 0.7607843137254902, 0.22745098039215686`], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
    {RGBColor[0.8235294117647058, 0.8941176470588236, 0.9490196078431372], 
     TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.39215686274509803`, 0.7294117647058823, 0.5843137254901961], 
     TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.8235294117647058, 0.8941176470588236, 0.9490196078431372], 
     TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.39215686274509803`, 0.7294117647058823, 0.5843137254901961], 
     TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
    {RGBColor[0.22745098039215686`, 0.19215686274509805`, 0.4], 
     TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.8235294117647058, 0.8941176470588236, 0.9490196078431372], 
     TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.22745098039215686`, 0.19215686274509805`, 0.4], 
     TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.8235294117647058, 0.8941176470588236, 0.9490196078431372], 
     TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
    {RGBColor[0.5019607843137255, 0.23921568627450981`, 0.4470588235294118], 
     TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.22745098039215686`, 0.19215686274509805`, 0.4], 
     TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.5019607843137255, 0.23921568627450981`, 0.4470588235294118], 
     TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.22745098039215686`, 0.19215686274509805`, 0.4], 
     TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.5019607843137255, 0.23921568627450981`, 0.4470588235294118], 
     TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.5019607843137255, 0.23921568627450981`, 0.4470588235294118], 
     TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`],
      TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.5686274509803921, 0.2980392156862745, 0.1450980392156863], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.7058823529411765, 0.6980392156862745, 0.4980392156862745], 
      TagBox[SphereBox[{1, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.6509803921568628, 0.7607843137254902, 0.22745098039215686`], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.39215686274509803`, 0.7294117647058823, 0.5843137254901961], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.8235294117647058, 0.8941176470588236, 0.9490196078431372], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.22745098039215686`, 0.19215686274509805`, 0.4], 
      TagBox[SphereBox[{5, 0, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.5019607843137255, 0.23921568627450981`, 0.4470588235294118], 
      TagBox[SphereBox[{6, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[
      0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`], 
      TagBox[SphereBox[{7, 0, 0}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[
      0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`], 
      TagBox[SphereBox[{8, 0, 0}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[
      0.6705882352941176, 0.12941176470588237`, 0.22745098039215686`], 
      TagBox[SphereBox[{9, 0, 0}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
By default, CrystalPlot uses Lighting->\[CloseCurlyDoubleQuote]Neutral\
\[CloseCurlyDoubleQuote]; try a different style of  lighting for colourful \
effects:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"AtomCol", "\[Rule]", "\"\<WatermelonColors\>\""}], ",", 
     RowBox[{"Lighting", "\[Rule]", "light"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"light", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Neutral\>\"", ",", "Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Directional\>\"", ",", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Blue", ",", ".7"}], "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", "Yellow", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "2"}], ",", "10"}], "}"}]}], "}"}], "}"}]}], "}"}]}],
     "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
        TagBox[SphereBox[{1, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.8559815, 0.8635813, 0.7633037], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.1, 0.1, 0.1], 
        TagBox[SphereBox[{5, 0, 0}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
        TagBox[SphereBox[{6, 0, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
        TagBox[SphereBox[{7, 0, 0}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
        TagBox[SphereBox[{8, 0, 0}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
        TagBox[SphereBox[{9, 0, 0}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
        TagBox[SphereBox[{1, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.8559815, 0.8635813, 0.7633037], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.1, 0.1, 0.1], 
        TagBox[SphereBox[{5, 0, 0}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
        TagBox[SphereBox[{6, 0, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
        TagBox[SphereBox[{7, 0, 0}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
        TagBox[SphereBox[{8, 0, 0}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
        TagBox[SphereBox[{9, 0, 0}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->Automatic,
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
        TagBox[SphereBox[{1, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.8559815, 0.8635813, 0.7633037], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.1, 0.1, 0.1], 
        TagBox[SphereBox[{5, 0, 0}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
        TagBox[SphereBox[{6, 0, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
        TagBox[SphereBox[{7, 0, 0}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
        TagBox[SphereBox[{8, 0, 0}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
        TagBox[SphereBox[{9, 0, 0}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->{{"Directional", 
       RGBColor[0.7, 0.7, 1.], 
       ImageScaled[{0, 0, 1}]}},
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
       TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[
       0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
       TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.8559815, 0.8635813, 0.7633037], 
       TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.1, 0.1, 0.1], TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
       TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
      {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
       TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
       TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
      {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
       TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.23053600000000002`, 0.29023129999999997`, 0.17996520000000002`], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.6508915000000001, 0.8019735, 0.5769935], 
        TagBox[SphereBox[{1, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9297466, 0.6157826999999998, 0.6160553999999999], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
        0.44494740000000005`, 0.6014822000000001, 0.35307410000000006`], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.8559815, 0.8635813, 0.7633037], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.1, 0.1, 0.1], 
        TagBox[SphereBox[{5, 0, 0}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.5454352000000001, 0.7168086, 0.4621138], 
        TagBox[SphereBox[{6, 0, 0}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.9179882, 0.7811853999999999, 0.7453332], 
        TagBox[SphereBox[{7, 0, 0}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.3441248, 0.4570582000000001, 0.2635404], 
        TagBox[SphereBox[{8, 0, 0}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.7561580000000001, 0.8562753999999999, 0.6835156], 
        TagBox[SphereBox[{9, 0, 0}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->{{"Point", 
       RGBColor[1, 1, 0], {-2, -2, 10}}},
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["The default atom colours:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", "97"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {0.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1, 0, 0}, {0.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1, 0, 0}, {1.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{2, 0, 0}, {1.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1, 0, 0}, {2., 0., 0.}}, 0.15]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{3, 0, 0}, {2., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{2, 0, 0}, {2.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{3, 0, 0}, {2.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.560181, 0.691569, 0.194885], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.15]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], 
     TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{3, 0, 0}, {3.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], 
     TubeBox[{{4, 0, 0}, {3.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.922526, 0.385626, 0.209179], 
     TubeBox[{{3, 0, 0}, {4., 0., 0.}}, 0.15]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], 
     TubeBox[{{5, 0, 0}, {4., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.528488, 0.470624, 0.701351], 
     TubeBox[{{4, 0, 0}, {4.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], 
     TubeBox[{{5, 0, 0}, {4.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.528488, 0.470624, 0.701351], 
     TubeBox[{{4, 0, 0}, {5., 0., 0.}}, 0.15]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], 
     TubeBox[{{6, 0, 0}, {5., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.772079, 0.431554, 0.102387], 
     TubeBox[{{5, 0, 0}, {5.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], 
     TubeBox[{{6, 0, 0}, {5.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.772079, 0.431554, 0.102387], 
     TubeBox[{{5, 0, 0}, {6., 0., 0.}}, 0.15]}, 
    {RGBColor[1, 0.75, 0], TubeBox[{{7, 0, 0}, {6., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.363898, 0.618501, 0.782349], 
     TubeBox[{{6, 0, 0}, {6.5, 0., 0.}}, 0.15]}, 
    {RGBColor[1, 0.75, 0], TubeBox[{{7, 0, 0}, {6.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[0.363898, 0.618501, 0.782349], 
     TubeBox[{{6, 0, 0}, {7., 0., 0.}}, 0.15]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], 
     TubeBox[{{8, 0, 0}, {7., 0., 0.}}, 0.15]}}, {
    {RGBColor[1, 0.75, 0], TubeBox[{{7, 0, 0}, {7.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], 
     TubeBox[{{8, 0, 0}, {7.5, 0., 0.}}, 0.15]}}, {
    {RGBColor[1, 0.75, 0], TubeBox[{{7, 0, 0}, {8., 0., 0.}}, 0.15]}, 
    {RGBColor[0.571589, 0.586483, 0.], 
     TubeBox[{{9, 0, 0}, {8., 0., 0.}}, 0.15]}}, {
    {RGBColor[0.647624, 0.37816, 0.614037], 
     TubeBox[{{8, 0, 0}, {8.5, 0., 0.}}, 0.15]}, 
    {RGBColor[0.571589, 0.586483, 0.], 
     TubeBox[{{9, 0, 0}, {8.5, 0., 0.}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.560181, 0.691569, 0.194885], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.922526, 0.385626, 0.209179], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.528488, 0.470624, 0.701351], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.772079, 0.431554, 0.102387], 
      TagBox[SphereBox[{5, 0, 0}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.363898, 0.618501, 0.782349], 
      TagBox[SphereBox[{6, 0, 0}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[1, 0.75, 0], 
      TagBox[SphereBox[{7, 0, 0}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.647624, 0.37816, 0.614037], 
      TagBox[SphereBox[{8, 0, 0}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.571589, 0.586483, 0.], 
      TagBox[SphereBox[{9, 0, 0}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1553, 837},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828925-3834481"->{
  Cell[749, 30, 180, 3, 40, "Print",
   CellTags->"Info3569828925-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828925-3834481", 57611, 1541}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 167, 6, 70, "Section"],
Cell[749, 30, 180, 3, 40, "Print",
 CellTags->"Info3569828925-3834481"],
Cell[CellGroupData[{
Cell[954, 37, 403, 14, 29, "Item"],
Cell[1360, 53, 276, 5, 29, "Item"],
Cell[1639, 60, 252, 4, 29, "Item"],
Cell[1894, 66, 27, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1958, 71, 30, 0, 49, "Subsection"],
Cell[1991, 73, 33, 0, 30, "Text"],
Cell[2027, 75, 102, 2, 31, "Input"],
Cell[2132, 79, 72, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2229, 83, 650, 17, 31, "Input"],
Cell[2882, 102, 5106, 147, 375, "Output"]
}, Open  ]],
Cell[8003, 252, 117, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[8145, 259, 1303, 39, 52, "Input"],
Cell[9451, 300, 2435, 80, 197, "Output"]
}, Open  ]],
Cell[11901, 383, 51, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[11977, 387, 401, 12, 31, "Input"],
Cell[12381, 401, 5915, 145, 375, "Output"]
}, Open  ]],
Cell[18311, 549, 50, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[18386, 553, 377, 11, 31, "Input"],
Cell[18766, 566, 6612, 148, 375, "Output"]
}, Open  ]],
Cell[25393, 717, 181, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[25599, 725, 1245, 35, 52, "Input"],
Cell[26847, 762, 24792, 601, 197, "Output"]
}, Open  ]],
Cell[51654, 1366, 41, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[51720, 1370, 377, 11, 31, "Input"],
Cell[52100, 1383, 5112, 141, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
