(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8836,        318]
NotebookOptionsPosition[      7813,        277]
NotebookOutlinePosition[      8357,        300]
CellTagsIndexPosition[      8273,        295]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondDist (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondDist is an option of CrystalPlot which determines the \
maximum length of interatomic bonds.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828931-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "BondDist is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ", ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ", ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell["\<\
BondDist determines the maximum distance that two atoms may have in order to \
still be connected by a bond.\
\>", "Item"],

Cell[TextData[{
 "To plot only manually specified bonds, give BondDist a negative value. (See \
",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 " for explanation.)"
}], "Item"],

Cell["Default: 2.1", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
This option usually has a \[OpenCurlyDoubleQuote]most sensible\
\[CloseCurlyDoubleQuote] value which is determined by the chemical properties \
of the system:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"BondDist", "\[Rule]", "dist"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"dist", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2.5", ",", "3.5", ",", "5.5"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {2.5, 1.5, 0.}}, 0.15]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{3, 3, 0}, {2.5, 1.5, 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1.5, 1.5, 0.}}, 0.15]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{3, 3, 0}, {1.5, 1.5, 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {2.5, 1.5, 0.}}, 0.15]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{3, 3, 0}, {2.5, 1.5, 0.}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828931-3834481"->{
  Cell[750, 30, 200, 3, 40, "Print",
   CellTags->"Info3569828931-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828931-3834481", 8172, 289}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 168, 6, 70, "Section"],
Cell[750, 30, 200, 3, 40, "Print",
 CellTags->"Info3569828931-3834481"],
Cell[CellGroupData[{
Cell[975, 37, 1034, 37, 29, "Item"],
Cell[2012, 76, 132, 3, 29, "Item"],
Cell[2147, 81, 230, 7, 29, "Item"],
Cell[2380, 90, 28, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2445, 95, 30, 0, 49, "Subsection"],
Cell[2478, 97, 33, 0, 30, "Text"],
Cell[2514, 99, 102, 2, 31, "Input"],
Cell[2619, 103, 182, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[2826, 111, 683, 21, 31, "Input"],
Cell[3512, 134, 4261, 138, 230, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
