(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10559,        362]
NotebookOptionsPosition[      9386,        316]
NotebookOutlinePosition[      9930,        339]
CellTagsIndexPosition[      9846,        334]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondRad (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondRad is an option of CrystalPlot which determines the \
thickenss of interatomic bonds.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828908-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "BondRad is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 " ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ", ",
 ButtonBox["ForceBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 ", ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 ", ",
 ButtonBox["BondsExtendQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsExtendQ"],
 ", and ",
 ButtonBox["BondsFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"]
}], "Item"],

Cell["BondRad provides the thickness of interatomic bonds.", "Item"],

Cell[TextData[{
 "For some bond types (see ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 " and the example below), you can give a list of two radii. Giving the wrong \
number of radii will, however, not result in errors: Superfluous radii are \
ignored, missing radii are set to the same value as the specified radii."
}], "Item"],

Cell["Default: 0.15", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Different radii:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"BondRad", "\[Rule]", "rad"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"rad", ",", 
     RowBox[{"{", 
      RowBox[{".1", ",", ".2", ",", ".4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.1]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.1]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.1]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.1]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.2]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.2]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.2]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.2]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.4]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.4]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.4]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], 
       TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.4]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2, 0, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.560181, 0.691569, 0.194885], 
        TagBox[SphereBox[{4, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "BondRad can be set to a list of two different radii; this is used for the ",
 ButtonBox["BondRadScaledQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"],
 " option as explained in that option\[CloseCurlyQuote]s help menu article. \
However, if BondRadScaledQ->False and two different radii are given, the \
first radius will be used for bonds between atoms of different species and \
the second for atoms of the same species. As a simple example, this can be \
useful to show intermetallic bonds in compound materials (e.g. oxides, \
nitrides, ...) without over-emphasizing them. For more complicated cases \
(where more radii may be needed), just create several separate plots and \
combine them using Show."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"BondRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".2", ",", ".1"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0, 0, 0}, {1., 0., 0.}}, 0.1]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2, 0, 0}, {1., 0., 0.}}, 0.1]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2, 0, 0}, {3., 0., 0.}}, 0.2]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{4, 0, 0}, {3., 0., 0.}}, 0.2]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{2, 0, 0}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{4, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828908-3834481"->{
  Cell[749, 30, 194, 3, 40, "Print",
   CellTags->"Info3569828908-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828908-3834481", 9745, 328}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 167, 6, 70, "Section"],
Cell[749, 30, 194, 3, 40, "Print",
 CellTags->"Info3569828908-3834481"],
Cell[CellGroupData[{
Cell[968, 37, 1035, 37, 29, "Item"],
Cell[2006, 76, 68, 0, 29, "Item"],
Cell[2077, 78, 394, 8, 45, "Item"],
Cell[2474, 88, 29, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2540, 93, 30, 0, 49, "Subsection"],
Cell[2573, 95, 33, 0, 30, "Text"],
Cell[2609, 97, 102, 2, 31, "Input"],
Cell[2714, 101, 32, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2771, 105, 664, 20, 31, "Input"],
Cell[3438, 127, 3488, 110, 197, "Output"]
}, Open  ]],
Cell[6941, 240, 768, 13, 68, "Text"],
Cell[CellGroupData[{
Cell[7734, 257, 518, 16, 31, "Input"],
Cell[8255, 275, 1091, 36, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
