(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     48820,       1266]
NotebookOptionsPosition[     47513,       1216]
NotebookOutlinePosition[     48060,       1239]
CellTagsIndexPosition[     47974,       1234]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "BondsExtendQ",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"BondsExtendQ is an option of CrystalPlot which adds bonds to \
atoms outside the plot range.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3611841223-9460348"],

Cell[CellGroupData[{

Cell[TextData[{
 "BondsExtendQ",
 " is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other bond-related options are ",
 ButtonBox["BondStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondStyle"],
 ButtonBox[",",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 " ",
 ButtonBox["BondCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondCol"],
 ", ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 ", ",
 ButtonBox["BondRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRad"],
 ", ",
 ButtonBox["ForceBonds,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceBonds"],
 " ",
 ButtonBox["ForceNoBonds",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ", ",
 ButtonBox["BondsFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondsFlatQ"],
 ", and",
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ForceNoBonds"],
 ButtonBox["BondRadScaledQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondRadScaledQ"]
}], "Item"],

Cell[TextData[{
 "If BondsExtendQ is set to True, half a bond will be added to any atom that \
is outside the actual plot range, but within reach of bonds as determined by \
the ",
 ButtonBox["BondDist",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/BondDist"],
 " option. (BondsExtendQ is not supported for cartesian coordinates because \
it relies on periodic images of atoms.)"
}], "Item"],

Cell["Default:False", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell[TextData[{
 "Plot extended bonds; they usually look better with ",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ef/AddQ"],
 "->True:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2.5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".3", ",", ".3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".7", ",", ".7", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".2", ",", ".8", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".8", ",", ".2", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], 
     ",", 
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"BondsExtendQ", "\[Rule]", "extend"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"extend", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {4., 0., 0.}, {4., 4., 0.}, {0., 4., 0.}, {0., 
        0., 0.}}, {{0., 0., 2.5}, {4., 0., 2.5}, {4., 4., 2.5}, {0., 4., 
        2.5}, {0., 0., 2.5}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {0., 0., 2.5}}, {{4., 0., 0.}, {4., 0., 
        2.5}}, {{4., 4., 0.}, {4., 4., 2.5}}, {{0., 4., 0.}, {0., 4., 2.5}}}, 
        0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {3.4577823315309617`, 0., 0.}, {
         3.4577823315309617`, 0., 0.}, {4, 0, 0}}, {
        0.021, 0.021, 0.1355544171172596, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 3.4577823315309617`, 0.}, {0., 
         3.4577823315309617`, 0.}, {0, 4, 0}}, {
        0.021, 0.021, 0.1355544171172596, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 1.9577823315309617`}, {0., 0., 
         1.9577823315309617`}, {0, 0, 2.5}}, {
        0.021, 0.021, 0.1355544171172596, 0}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.6, 0.6, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 0.}, {0.6, 0.6, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {1.6, 1.6, 0.625}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 0.}, {1.6, 1.6, 0.625}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {2.4, 2.4, 0.625}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 0.}, {2.4, 2.4, 0.625}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {1.4, 2.6, 1.25}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0.8, 3.2, 1.25}, {1.4, 2.6, 1.25}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {2.6, 1.4, 1.25}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 0.8, 1.25}, {2.6, 1.4, 1.25}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {1.6, 1.6, 1.875}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 2.5}, {1.6, 1.6, 1.875}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {2.4, 2.4, 1.875}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 2.5}, {2.4, 2.4, 1.875}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 0.}, {3.4, 3.4, 0.}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 4., 0.}, {3.4, 3.4, 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0.8, 3.2, 1.25}, {0.4, 3.6, 0.625}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 4., 0.}, {0.4, 3.6, 0.625}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0.8, 3.2, 1.25}, {0.4, 3.6, 1.875}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 4., 2.5}, {0.4, 3.6, 1.875}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 0.8, 1.25}, {3.6, 0.4, 0.625}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 0., 0.}, {3.6, 0.4, 0.625}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 0.8, 1.25}, {3.6, 0.4, 1.875}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 0., 2.5}, {3.6, 0.4, 1.875}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 2.5}, {0.6, 0.6, 2.5}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 2.5}, {0.6, 0.6, 2.5}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 2.5}, {3.4, 3.4, 2.5}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 4., 2.5}, {3.4, 3.4, 2.5}}, 0.15]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{2., 2., 1.25}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2, 1.2, 0.}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2.8, 2.8, 0.}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0.8, 3.2, 1.25}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 0.8, 1.25}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 0., 0.}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 4., 0.}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 4., 0.}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 2.5}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2, 1.2, 2.5}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2.8, 2.8, 2.5}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 0., 2.5}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 4., 2.5}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 4., 2.5}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {4., 0., 0.}, {4., 4., 0.}, {0., 4., 0.}, {0., 
        0., 0.}}, {{0., 0., 2.5}, {4., 0., 2.5}, {4., 4., 2.5}, {0., 4., 
        2.5}, {0., 0., 2.5}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0., 0., 0.}, {0., 0., 2.5}}, {{4., 0., 0.}, {4., 0., 
        2.5}}, {{4., 4., 0.}, {4., 4., 2.5}}, {{0., 4., 0.}, {0., 4., 2.5}}}, 
        0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {3.4577823315309617`, 0., 0.}, {
         3.4577823315309617`, 0., 0.}, {4, 0, 0}}, {
        0.021, 0.021, 0.1355544171172596, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 3.4577823315309617`, 0.}, {0., 
         3.4577823315309617`, 0.}, {0, 4, 0}}, {
        0.021, 0.021, 0.1355544171172596, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 1.9577823315309617`}, {0., 0., 
         1.9577823315309617`}, {0, 0, 2.5}}, {
        0.021, 0.021, 0.1355544171172596, 0}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 0.}, {0.6, 0.6, 0.}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 0.}, {0.6, 0.6, 0.}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {1.6, 1.6, 0.625}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 0.}, {1.6, 1.6, 0.625}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {2.4, 2.4, 0.625}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 0.}, {2.4, 2.4, 0.625}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {1.4, 2.6, 1.25}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0.8, 3.2, 1.25}, {1.4, 2.6, 1.25}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {2.6, 1.4, 1.25}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 0.8, 1.25}, {2.6, 1.4, 1.25}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {1.6, 1.6, 1.875}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 2.5}, {1.6, 1.6, 1.875}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{2., 2., 1.25}, {2.4, 2.4, 1.875}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 2.5}, {2.4, 2.4, 1.875}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 0.}, {3.4, 3.4, 0.}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 4., 0.}, {3.4, 3.4, 0.}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0.8, 3.2, 1.25}, {0.4, 3.6, 0.625}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 4., 0.}, {0.4, 3.6, 0.625}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{0.8, 3.2, 1.25}, {0.4, 3.6, 1.875}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 4., 2.5}, {0.4, 3.6, 1.875}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 0.8, 1.25}, {3.6, 0.4, 0.625}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 0., 0.}, {3.6, 0.4, 0.625}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{3.2, 0.8, 1.25}, {3.6, 0.4, 1.875}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 0., 2.5}, {3.6, 0.4, 1.875}}, 0.15]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{0., 0., 2.5}, {0.6, 0.6, 2.5}}, 0.15]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{1.2, 1.2, 2.5}, {0.6, 0.6, 2.5}}, 0.15]}}, {
      {RGBColor[0.880722, 0.611041, 0.142051], 
       TubeBox[{{2.8, 2.8, 2.5}, {3.4, 3.4, 2.5}}, 0.15]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       TubeBox[{{4., 4., 2.5}, {3.4, 3.4, 2.5}}, 0.15]}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 0.}, {-0.6000000000000001, -0.6000000000000001, 0.}}, 
       0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 0.}, {-0.3999999999999999, 0.4, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 0.}, {-0.3999999999999999, 0.4, 0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 0.}, {0.4, -0.3999999999999999, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 0.}, {0.4, -0.3999999999999999, 0.625}}, 0.15]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TubeBox[{{1.2, 1.2, 0.}, {1.6, 1.6, -0.625}}, 0.15]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TubeBox[{{2.8, 2.8, 0.}, {2.4, 2.4, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 0.}, {3.4, -0.6000000000000001, 0.}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 0.}, {3.6, 0.4, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 0.}, {4.4, -0.3999999999999999, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 0.}, {4.4, -0.3999999999999999, 0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 0.}, {4.6, 0.6, 0.}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 0.}, {-0.6000000000000001, 3.4, 0.}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 0.}, {-0.3999999999999999, 4.4, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 0.}, {-0.3999999999999999, 4.4, 0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 0.}, {0.4, 3.6, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 0.}, {0.6, 4.6, 0.}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 0.}, {3.6, 4.4, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 0.}, {3.6, 4.4, 0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 0.}, {4.4, 3.6, -0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 0.}, {4.4, 3.6, 0.625}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 0.}, {4.6, 4.6, 0.}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 2.5}, {-0.6000000000000001, -0.6000000000000001, 
       2.5}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 2.5}, {-0.3999999999999999, 0.4, 1.875}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 2.5}, {-0.3999999999999999, 0.4, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 2.5}, {0.4, -0.3999999999999999, 1.875}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 0., 2.5}, {0.4, -0.3999999999999999, 3.125}}, 0.15]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TubeBox[{{1.2, 1.2, 2.5}, {1.6, 1.6, 3.125}}, 0.15]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TubeBox[{{2.8, 2.8, 2.5}, {2.4, 2.4, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 2.5}, {3.4, -0.6000000000000001, 2.5}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 2.5}, {3.6, 0.4, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 2.5}, {4.4, -0.3999999999999999, 1.875}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 2.5}, {4.4, -0.3999999999999999, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 0., 2.5}, {4.6, 0.6, 2.5}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 2.5}, {-0.6000000000000001, 3.4, 2.5}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 2.5}, {-0.3999999999999999, 4.4, 1.875}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 2.5}, {-0.3999999999999999, 4.4, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 2.5}, {0.4, 3.6, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{0., 4., 2.5}, {0.6, 4.6, 2.5}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 2.5}, {3.6, 4.4, 1.875}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 2.5}, {3.6, 4.4, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 2.5}, {4.4, 3.6, 1.875}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 2.5}, {4.4, 3.6, 3.125}}, 0.15]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TubeBox[{{4., 4., 2.5}, {4.6, 4.6, 2.5}}, 0.15]}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{2., 2., 1.25}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2, 1.2, 0.}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2.8, 2.8, 0.}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0.8, 3.2, 1.25}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{3.2, 0.8, 1.25}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 0., 0.}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 4., 0.}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 4., 0.}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 0., 2.5}, 0.5],
         "Ball"]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.2, 1.2, 2.5}, 0.5],
         "Ball"]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{2.8, 2.8, 2.5}, 0.5],
         "Ball"]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 0., 2.5}, 0.5],
         "Ball"]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0., 4., 2.5}, 0.5],
         "Ball"]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4., 4., 2.5}, 0.5],
         "Ball"]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["BondsExtendQ works with supercells as well:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2.5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", ".3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".7", ",", ".7", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".8", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".2", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"BondsExtendQ", "\[Rule]", "True"}], ",", 
   RowBox[{"Sysdim", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0., 0., 0.}, {4., 0., 0.}, {4., 4., 0.}, {0., 4., 0.}, {0., 
      0., 0.}}, {{0., 0., 2.5}, {4., 0., 2.5}, {4., 4., 2.5}, {0., 4., 2.5}, {
      0., 0., 2.5}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0., 0., 0.}, {0., 0., 2.5}}, {{4., 0., 0.}, {4., 0., 2.5}}, {{
      4., 4., 0.}, {4., 4., 2.5}}, {{0., 4., 0.}, {0., 4., 2.5}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {3.4577823315309617`, 0., 0.}, {3.4577823315309617`, 
       0., 0.}, {4, 0, 0}}, {0.021, 0.021, 0.1355544171172596, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 3.4577823315309617`, 0.}, {0., 
       3.4577823315309617`, 0.}, {0, 4, 0}}, {
      0.021, 0.021, 0.1355544171172596, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 1.9577823315309617`}, {0., 0., 
       1.9577823315309617`}, {0, 0, 2.5}}, {
      0.021, 0.021, 0.1355544171172596, 0}]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.6, 0.6, 0.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 0.}, {0.6, 0.6, 0.}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 1.25}, {1.6, 1.6, 0.625}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 0.}, {1.6, 1.6, 0.625}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 1.25}, {2.4, 2.4, 0.625}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 0.}, {2.4, 2.4, 0.625}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 1.25}, {1.4, 2.6, 1.25}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0.8, 3.2, 1.25}, {1.4, 2.6, 1.25}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 1.25}, {2.6, 1.4, 1.25}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3.2, 0.8, 1.25}, {2.6, 1.4, 1.25}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 1.25}, {1.6, 1.6, 1.875}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 2.5}, {1.6, 1.6, 1.875}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 1.25}, {2.4, 2.4, 1.875}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 2.5}, {2.4, 2.4, 1.875}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 0.}, {3.4, 3.4, 0.}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 4., 0.}, {3.4, 3.4, 0.}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0.8, 3.2, 1.25}, {0.4, 3.6, 0.625}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 4., 0.}, {0.4, 3.6, 0.625}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0.8, 3.2, 1.25}, {0.4, 3.6, 1.875}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 4., 2.5}, {0.4, 3.6, 1.875}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3.2, 0.8, 1.25}, {3.6, 0.4, 0.625}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 0., 0.}, {3.6, 0.4, 0.625}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3.2, 0.8, 1.25}, {3.6, 0.4, 1.875}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 0., 2.5}, {3.6, 0.4, 1.875}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 2.5}, {0.6, 0.6, 2.5}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 2.5}, {0.6, 0.6, 2.5}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 3.75}, {1.6, 1.6, 3.125}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 2.5}, {1.6, 1.6, 3.125}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 3.75}, {2.4, 2.4, 3.125}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 2.5}, {2.4, 2.4, 3.125}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 3.75}, {1.4, 2.6, 3.75}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0.8, 3.2, 3.75}, {1.4, 2.6, 3.75}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 3.75}, {2.6, 1.4, 3.75}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3.2, 0.8, 3.75}, {2.6, 1.4, 3.75}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 3.75}, {1.6, 1.6, 4.375}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 5.}, {1.6, 1.6, 4.375}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{2., 2., 3.75}, {2.4, 2.4, 4.375}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 5.}, {2.4, 2.4, 4.375}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 2.5}, {3.4, 3.4, 2.5}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 4., 2.5}, {3.4, 3.4, 2.5}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0.8, 3.2, 3.75}, {0.4, 3.6, 3.125}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 4., 2.5}, {0.4, 3.6, 3.125}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0.8, 3.2, 3.75}, {0.4, 3.6, 4.375}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 4., 5.}, {0.4, 3.6, 4.375}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3.2, 0.8, 3.75}, {3.6, 0.4, 3.125}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 0., 2.5}, {3.6, 0.4, 3.125}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{3.2, 0.8, 3.75}, {3.6, 0.4, 4.375}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 0., 5.}, {3.6, 0.4, 4.375}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 5.}, {0.6, 0.6, 5.}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.2, 1.2, 5.}, {0.6, 0.6, 5.}}, 0.15]}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{2.8, 2.8, 5.}, {3.4, 3.4, 5.}}, 0.15]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{4., 4., 5.}, {3.4, 3.4, 5.}}, 0.15]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 0.}, {-0.6000000000000001, -0.6000000000000001, 0.}}, 
     0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 0.}, {-0.3999999999999999, 0.4, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 0.}, {-0.3999999999999999, 0.4, 0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 0.}, {0.4, -0.3999999999999999, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 0.}, {0.4, -0.3999999999999999, 0.625}}, 0.15]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], 
    TubeBox[{{1.2, 1.2, 0.}, {1.6, 1.6, -0.625}}, 0.15]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], 
    TubeBox[{{2.8, 2.8, 0.}, {2.4, 2.4, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 2.5}, {-0.6000000000000001, -0.6000000000000001, 2.5}}, 
     0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 2.5}, {-0.3999999999999999, 0.4, 1.875}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 2.5}, {-0.3999999999999999, 0.4, 3.125}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 2.5}, {0.4, -0.3999999999999999, 1.875}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 2.5}, {0.4, -0.3999999999999999, 3.125}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 0.}, {3.4, -0.6000000000000001, 0.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 0.}, {3.6, 0.4, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 0.}, {4.4, -0.3999999999999999, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 0.}, {4.4, -0.3999999999999999, 0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 0.}, {4.6, 0.6, 0.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 2.5}, {3.4, -0.6000000000000001, 2.5}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 2.5}, {4.4, -0.3999999999999999, 1.875}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 2.5}, {4.4, -0.3999999999999999, 3.125}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 2.5}, {4.6, 0.6, 2.5}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 0.}, {-0.6000000000000001, 3.4, 0.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 0.}, {-0.3999999999999999, 4.4, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 0.}, {-0.3999999999999999, 4.4, 0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 0.}, {0.4, 3.6, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 0.}, {0.6, 4.6, 0.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 2.5}, {-0.6000000000000001, 3.4, 2.5}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 2.5}, {-0.3999999999999999, 4.4, 1.875}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 2.5}, {-0.3999999999999999, 4.4, 3.125}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 2.5}, {0.6, 4.6, 2.5}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 0.}, {3.6, 4.4, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 0.}, {3.6, 4.4, 0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 0.}, {4.4, 3.6, -0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 0.}, {4.4, 3.6, 0.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 0.}, {4.6, 4.6, 0.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 2.5}, {3.6, 4.4, 1.875}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 2.5}, {3.6, 4.4, 3.125}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 2.5}, {4.4, 3.6, 1.875}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 2.5}, {4.4, 3.6, 3.125}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 2.5}, {4.6, 4.6, 2.5}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 5.}, {-0.6000000000000001, -0.6000000000000001, 5.}}, 
     0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 5.}, {-0.3999999999999999, 0.4, 4.375}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 5.}, {-0.3999999999999999, 0.4, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 5.}, {0.4, -0.3999999999999999, 4.375}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 0., 5.}, {0.4, -0.3999999999999999, 5.625}}, 0.15]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], 
    TubeBox[{{1.2, 1.2, 5.}, {1.6, 1.6, 5.625}}, 0.15]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], 
    TubeBox[{{2.8, 2.8, 5.}, {2.4, 2.4, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 5.}, {3.4, -0.6000000000000001, 5.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 5.}, {3.6, 0.4, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 5.}, {4.4, -0.3999999999999999, 4.375}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 5.}, {4.4, -0.3999999999999999, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 0., 5.}, {4.6, 0.6, 5.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 5.}, {-0.6000000000000001, 3.4, 5.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 5.}, {-0.3999999999999999, 4.4, 4.375}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 5.}, {-0.3999999999999999, 4.4, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 5.}, {0.4, 3.6, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{0., 4., 5.}, {0.6, 4.6, 5.}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 5.}, {3.6, 4.4, 4.375}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 5.}, {3.6, 4.4, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 5.}, {4.4, 3.6, 4.375}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 5.}, {4.4, 3.6, 5.625}}, 0.15]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    TubeBox[{{4., 4., 5.}, {4.6, 4.6, 5.}}, 0.15]}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 0., 0.}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{2., 2., 1.25}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.2, 1.2, 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2.8, 2.8, 0.}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0.8, 3.2, 1.25}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3.2, 0.8, 1.25}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 0., 2.5}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{2., 2., 3.75}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.2, 1.2, 2.5}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2.8, 2.8, 2.5}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0.8, 3.2, 3.75}, 0.5],
       "Ball"]},
     "11"],
    Annotation[#, 11, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3.2, 0.8, 3.75}, 0.5],
       "Ball"]},
     "12"],
    Annotation[#, 12, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4., 0., 0.}, 0.5],
       "Ball"]},
     "13"],
    Annotation[#, 13, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4., 0., 2.5}, 0.5],
       "Ball"]},
     "14"],
    Annotation[#, 14, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 4., 0.}, 0.5],
       "Ball"]},
     "15"],
    Annotation[#, 15, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 4., 2.5}, 0.5],
       "Ball"]},
     "16"],
    Annotation[#, 16, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4., 4., 0.}, 0.5],
       "Ball"]},
     "17"],
    Annotation[#, 17, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4., 4., 2.5}, 0.5],
       "Ball"]},
     "18"],
    Annotation[#, 18, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 0., 5.}, 0.5],
       "Ball"]},
     "19"],
    Annotation[#, 19, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.2, 1.2, 5.}, 0.5],
       "Ball"]},
     "20"],
    Annotation[#, 20, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{2.8, 2.8, 5.}, 0.5],
       "Ball"]},
     "21"],
    Annotation[#, 21, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4., 0., 5.}, 0.5],
       "Ball"]},
     "22"],
    Annotation[#, 22, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 4., 5.}, 0.5],
       "Ball"]},
     "23"],
    Annotation[#, 23, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4., 4., 5.}, 0.5],
       "Ball"]},
     "24"],
    Annotation[#, 24, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["BondsExtendQ also works in 2D:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2.2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"BondsExtendQ", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], Thickness[0.01], 
    LineBox[{{0., 0.}, {2.2, 0.}, {2.2, 2.2}, {0., 2.2}, {0., 0.}}]}, {
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     ArrowBox[{{0, 0}, {2.2, 0}}]}, 
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     ArrowBox[{{0, 0}, {0, 2.2}}]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     {Thickness[0.075], CapForm[None], LineBox[{{0., 0.}, {0.55, 0.55}}]}}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{1.1, 1.1}, {0.55, 0.55}}]}}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{1.1, 1.1}, {1.6500000000000001`, 0.55}}]}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{2.2, 0.}, {1.6500000000000001`, 0.55}}]}}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{1.1, 1.1}, {0.55, 1.6500000000000001`}}]}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{0., 2.2}, {0.55, 1.6500000000000001`}}]}}}, {
    {RGBColor[0.880722, 0.611041, 0.142051], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{1.1, 1.1}, {1.6500000000000001`, 1.6500000000000001`}}]}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     {Thickness[0.075], CapForm[None], 
      LineBox[{{2.2, 2.2}, {1.6500000000000001`, 1.6500000000000001`}}]}}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{0., 0.}, {-0.55, -0.55}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{0., 0.}, {-0.55, 0.55}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{0., 0.}, {0.55, -0.55}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], 
     LineBox[{{2.2, 0.}, {1.6500000000000001`, -0.55}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{2.2, 0.}, {2.75, -0.55}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{2.2, 0.}, {2.75, 0.55}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], 
     LineBox[{{0., 2.2}, {-0.55, 1.6500000000000001`}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{0., 2.2}, {-0.55, 2.75}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{0., 2.2}, {0.55, 2.75}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], 
     LineBox[{{2.2, 2.2}, {1.6500000000000001`, 2.75}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], 
     LineBox[{{2.2, 2.2}, {2.75, 1.6500000000000001`}}]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], 
    {Thickness[0.075], CapForm[None], LineBox[{{2.2, 2.2}, {2.75, 2.75}}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{0., 0.}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[DiskBox[{1.1, 1.1}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{2.2, 0.}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{0., 2.2}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{2.2, 2.2}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ]}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1661, 916},
WindowMargins->{{-4, Automatic}, {Automatic, 3}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3611841223-9460348"->{
  Cell[759, 31, 196, 3, 40, "Print",
   CellTags->"Info3611841223-9460348"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3611841223-9460348", 47873, 1228}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 177, 7, 70, "Section"],
Cell[759, 31, 196, 3, 40, "Print",
 CellTags->"Info3611841223-9460348"],
Cell[CellGroupData[{
Cell[980, 38, 1213, 44, 29, "Item"],
Cell[2196, 84, 405, 9, 45, "Item"],
Cell[2604, 95, 29, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2670, 100, 30, 0, 49, "Subsection"],
Cell[2703, 102, 33, 0, 30, "Text"],
Cell[2739, 104, 102, 2, 31, "Input"],
Cell[2844, 108, 179, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[3048, 118, 1273, 36, 52, "Input"],
Cell[4324, 156, 19405, 468, 197, "Output"]
}, Open  ]],
Cell[23744, 627, 59, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[23828, 631, 1151, 33, 52, "Input"],
Cell[24982, 666, 17835, 424, 375, "Output"]
}, Open  ]],
Cell[42832, 1093, 46, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[42903, 1097, 587, 19, 31, "Input"],
Cell[43493, 1118, 3980, 93, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
