(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8966,        281]
NotebookOptionsPosition[      7982,        241]
NotebookOutlinePosition[      8527,        264]
CellTagsIndexPosition[      8443,        259]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "ButtonQ (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"ButtonQ is an option of CrystalPlot which states whether to \
show the \\\"Paste supercell data\\\" button.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3569829021-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "ButtonQ is an option of ",
 ButtonBox["CrystalPlot.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"]
}], "Item"],

Cell[TextData[{
 "If ButtonQ is set to True, a button is shown beneath the plot; click it to \
paste the structural data of your cell as seen in the plot. The output is \
determined by any options you give to CrystalPlot that are also options of ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 "."
}], "Item"],

Cell["Default: False", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Effect of ButtonQ (you have to evaluate the input in order to use the buttons \
in the output):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"ButtonQ", "\[Rule]", "True"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", "sysdim"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"sysdim", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Epilog->{{}, 
      InsetBox[
       BoxData[
        FormBox[
         TagBox[
          ButtonBox[
          "\"Paste supercell data\"", ButtonFunction :> {}, Evaluator -> None,
            ImageSize -> All, 
           FrameMargins -> {{20, 20}, {Automatic, Automatic}}, Background -> 
           RGBColor[0.862697, 0.862697, 0.862697], Appearance -> Automatic, 
           Method -> "Preemptive"], 
          EventHandlerTag[{"MouseClicked" :> (SelectionMove[
               ButtonNotebook[], After, ButtonCell]; NotebookWrite[
               ButtonNotebook[], 
               ToBoxes[
                
                Crystallica`CrystalChange[{{3, 0, 0}, {0, 3, 0}, {0, 0, 
                 3}}, {{0, 0, 0}}, {1}, 
                 FilterRules[Crystallica`Private`options$16672, 
                  Options[Crystallica`CrystalChange]]]]]), PassEventsDown -> 
            Automatic, PassEventsUp -> True, Method -> "Preemptive"}]], 
         TraditionalForm]], {Center, Bottom}, {Center, Bottom}]},
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Epilog->{{}, 
      InsetBox[
       BoxData[
        FormBox[
         TagBox[
          ButtonBox[
          "\"Paste supercell data\"", ButtonFunction :> {}, Evaluator -> None,
            ImageSize -> All, 
           FrameMargins -> {{20, 20}, {Automatic, Automatic}}, Background -> 
           RGBColor[0.862697, 0.862697, 0.862697], Appearance -> Automatic, 
           Method -> "Preemptive"], 
          EventHandlerTag[{"MouseClicked" :> (SelectionMove[
               ButtonNotebook[], After, ButtonCell]; NotebookWrite[
               ButtonNotebook[], 
               ToBoxes[
                
                Crystallica`CrystalChange[{{3, 0, 0}, {0, 3, 0}, {0, 0, 
                 3}}, {{0, 0, 0}}, {1}, 
                 FilterRules[Crystallica`Private`options$16682, 
                  Options[Crystallica`CrystalChange]]]]]), PassEventsDown -> 
            Automatic, PassEventsUp -> True, Method -> "Preemptive"}]], 
         TraditionalForm]], {Center, Bottom}, {Center, Bottom}]},
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{-1, Automatic}, {Automatic, 1}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569829021-3834481"->{
  Cell[749, 30, 213, 4, 40, "Print",
   CellTags->"Info3569829021-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569829021-3834481", 8342, 253}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 167, 6, 70, "Section"],
Cell[749, 30, 213, 4, 40, "Print",
 CellTags->"Info3569829021-3834481"],
Cell[CellGroupData[{
Cell[987, 38, 156, 5, 29, "Item"],
Cell[1146, 45, 369, 8, 29, "Item"],
Cell[1518, 55, 30, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1585, 60, 30, 0, 49, "Subsection"],
Cell[1618, 62, 33, 0, 30, "Text"],
Cell[1654, 64, 102, 2, 31, "Input"],
Cell[1759, 68, 119, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[1903, 75, 908, 28, 31, "Input"],
Cell[2814, 105, 5128, 131, 230, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
