(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9783,        310]
NotebookOptionsPosition[      8651,        265]
NotebookOutlinePosition[      9195,        288]
CellTagsIndexPosition[      9111,        283]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CellLineCol (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CellLineCol is an option of CrystalPlot which determines the \
colour of the cell outlines and arrows.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569829007-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "CellLineCol is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other cell line-related options are ",
 ButtonBox["CellLineRad,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineRad"],
 " ",
 ButtonBox["CellLineStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineStyle"],
 ", and ",
 ButtonBox["CellLinesFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"],
 "."
}], "Item"],

Cell["\<\
CellLineCol gives the colour for cell outlines and arrows; you can give a \
list of two colours to use different colours for lines and arrows.\
\>", "Item"],

Cell["Default: Black", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Different colours:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"CellLineCol", "\[Rule]", "col"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"col", ",", 
     RowBox[{"{", 
      RowBox[{"Black", ",", "Red", ",", "\"\<YellowGreen\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {RGBColor[1, 0, 0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {RGBColor[0.6039, 0.803903, 0.196097], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {RGBColor[0.6039, 0.803903, 0.196097], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {RGBColor[0.6039, 0.803903, 0.196097], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {RGBColor[0.6039, 0.803903, 0.196097], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {RGBColor[0.6039, 0.803903, 0.196097], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["You can give two separate colours for the lines and arrows:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"CellLineCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {RGBColor[1, 0, 0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {RGBColor[1, 0, 0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {RGBColor[1, 0, 0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1663, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569829007-3834481"->{
  Cell[753, 30, 206, 3, 40, "Print",
   CellTags->"Info3569829007-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569829007-3834481", 9010, 277}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 171, 6, 70, "Section"],
Cell[753, 30, 206, 3, 40, "Print",
 CellTags->"Info3569829007-3834481"],
Cell[CellGroupData[{
Cell[984, 37, 536, 18, 29, "Item"],
Cell[1523, 57, 166, 3, 29, "Item"],
Cell[1692, 62, 30, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1759, 67, 30, 0, 49, "Subsection"],
Cell[1792, 69, 33, 0, 30, "Text"],
Cell[1828, 71, 102, 2, 31, "Input"],
Cell[1933, 75, 34, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[1992, 79, 761, 23, 31, "Input"],
Cell[2756, 104, 3939, 98, 197, "Output"]
}, Open  ]],
Cell[6710, 205, 75, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[6810, 209, 589, 18, 31, "Input"],
Cell[7402, 229, 1209, 31, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
