(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9689,        313]
NotebookOptionsPosition[      8557,        268]
NotebookOutlinePosition[      9101,        291]
CellTagsIndexPosition[      9017,        286]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CellLineRad (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CellLineRad is an option of CrystalPlot which determines the \
thickness of the cell outlines and arrows.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3569829015-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "CellLineRad is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other cell line-related options are ",
 ButtonBox["CellLineCol,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineCol"],
 " ",
 ButtonBox["CellLineStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineStyle"],
 ", and ",
 ButtonBox["CellLinesFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"]
}], "Item"],

Cell["CellLineRad gives the thickness of cell outlines and arrows.", "Item"],

Cell["Default: 0.02", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Different thicknesses; note that the best-looking thickness will depend on \
the overall size of the cell.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"CellLineRad", "\[Rule]", "rad"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"rad", ",", 
     RowBox[{"{", 
      RowBox[{".01", ",", ".02", ",", ".04"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.01]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.01]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.636681957508301, 0., 0.}, {2.636681957508301, 
         0., 0.}, {3, 0, 0}}, {0.011, 0.011, 0.09082951062292476, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.636681957508301, 0.}, {0., 
         2.636681957508301, 0.}, {0, 3, 0}}, {
        0.011, 0.011, 0.09082951062292476, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.636681957508301}, {0., 0., 
         2.636681957508301}, {0, 0, 3}}, {
        0.011, 0.011, 0.09082951062292476, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.04]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.04]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.2985728833299928`, 0., 0.}, {
         2.2985728833299928`, 0., 0.}, {3, 0, 0}}, {
        0.041, 0.041, 0.1753567791675018, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.2985728833299928`, 0.}, {0., 
         2.2985728833299928`, 0.}, {0, 3, 0}}, {
        0.041, 0.041, 0.1753567791675018, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.2985728833299928`}, {0., 0., 
         2.2985728833299928`}, {0, 0, 3}}, {
        0.041, 0.041, 0.1753567791675018, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["You can give two separate radii for the lines and arrows:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"CellLineRad", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".02", ",", ".05"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.217695711375682, 0., 0.}, {2.217695711375682, 0., 
       0.}, {3, 0, 0}}, {
      0.051000000000000004`, 0.051000000000000004`, 0.19557607215607947`, 
       0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.217695711375682, 0.}, {0., 2.217695711375682, 
       0.}, {0, 3, 0}}, {
      0.051000000000000004`, 0.051000000000000004`, 0.19557607215607947`, 
       0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.217695711375682}, {0., 0., 
       2.217695711375682}, {0, 0, 3}}, {
      0.051000000000000004`, 0.051000000000000004`, 0.19557607215607947`, 
       0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1663, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569829015-3834481"->{
  Cell[753, 30, 211, 4, 40, "Print",
   CellTags->"Info3569829015-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569829015-3834481", 8916, 280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 171, 6, 70, "Section"],
Cell[753, 30, 211, 4, 40, "Print",
 CellTags->"Info3569829015-3834481"],
Cell[CellGroupData[{
Cell[989, 38, 531, 17, 29, "Item"],
Cell[1523, 57, 76, 0, 29, "Item"],
Cell[1602, 59, 29, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1668, 64, 30, 0, 49, "Subsection"],
Cell[1701, 66, 33, 0, 30, "Text"],
Cell[1737, 68, 102, 2, 31, "Input"],
Cell[1842, 72, 130, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[1997, 79, 741, 23, 31, "Input"],
Cell[2741, 104, 3764, 97, 197, "Output"]
}, Open  ]],
Cell[6520, 204, 73, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[6618, 208, 587, 18, 31, "Input"],
Cell[7208, 228, 1309, 35, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
