(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     48420,       1429]
NotebookOptionsPosition[     46704,       1366]
NotebookOutlinePosition[     47251,       1389]
CellTagsIndexPosition[     47165,       1384]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CellLineStyle (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CellLineStyle is an option of CrystalPlot which determines the \
layout of the cell outlines and arrows.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3569828990-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "CellLineStyle is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 ". Other cell line-related options are ",
 ButtonBox["CellLineCol,",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineCol"],
 " ",
 ButtonBox["CellLineRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineRad"],
 ", and ",
 ButtonBox["CellLinesFlatQ.",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"]
}], "Item"],

Cell["\<\
CellLineStyle provides the overall layout of the cell lines and arrows; it \
can have one of the following values:
0 \[Dash] no lines/arrows
1 \[Dash] unit cell
2 \[Dash] periodic repetition
3 \[Dash] supercell\[LineSeparator]-2 \[Dash] specialty mode for conventional \
hexagonal cells\
\>", "Item"],

Cell["\<\
CellLineStyle can have two entries to treat cell lines and arrows differently.\
\>", "Item"],

Cell["\<\
To disable cell outlines altogether, you can also use CellLineStyle->False or \
CellLineStyle->None.\
\>", "Item"],

Cell["\<\
Please note that the hexagonal mode (-2) does not check that the cell is \
actually hexagonal; you can plot nonsense with this setting.\
\>", "Item"],

Cell["Default: 1", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Different layout varieties:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", "mode"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mode", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 3, 0}, {3, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 6, 0}, {3, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {6, 0, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {6, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {6, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 3}, {6, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 6}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {6, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 3}, {6, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 6}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 3}, {3, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {0, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 6}, {3, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 6}, {6, 6, 6}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {6, 0, 0}, {6, 6, 0}, {0, 6, 0}, {0, 0, 0}}, 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 6}, {6, 0, 6}, {6, 6, 6}, {0, 6, 6}, {0, 0, 6}}, 
        0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {5.4980039840795545`, 0., 0.}, {
         5.4980039840795545`, 0., 0.}, {6, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 5.4980039840795545`, 0.}, {0., 
         5.4980039840795545`, 0.}, {0, 6, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 5.4980039840795545`}, {0., 0., 
         5.4980039840795545`}, {0, 0, 6}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Layouts without arrows:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"mode", ",", "0"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mode", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 3, 0}, {3, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 6, 0}, {3, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {6, 0, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {6, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {6, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 3}, {6, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 6}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {6, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 3}, {6, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 6}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 3}, {3, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {0, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 6}, {3, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 6}, {6, 6, 6}}, 0.02]}}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {6, 0, 0}, {6, 6, 0}, {0, 6, 0}, {0, 0, 0}}, 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 6}, {6, 0, 6}, {6, 6, 6}, {0, 6, 6}, {0, 0, 6}}, 
        0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Layouts without \[OpenCurlyDoubleQuote]wrong\[CloseCurlyDoubleQuote] \
arrows:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", "mode"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mode", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 3, 0}, {3, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 6, 0}, {3, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {6, 0, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {6, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {6, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 3}, {6, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 6}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {6, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 3}, {6, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 6}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 6, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 3}, {3, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 6, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {0, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 6}, {3, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 6}, {6, 6, 6}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {5.4980039840795545`, 0., 0.}, {
         5.4980039840795545`, 0., 0.}, {6, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 5.4980039840795545`, 0.}, {0., 
         5.4980039840795545`, 0.}, {0, 6, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 5.4980039840795545`}, {0., 0., 
         5.4980039840795545`}, {0, 0, 6}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {6, 0, 0}, {6, 6, 0}, {0, 6, 0}, {0, 0, 0}}, 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 6}, {6, 0, 6}, {6, 6, 6}, {0, 6, 6}, {0, 0, 6}}, 
        0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Layouts without cell lines:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "mode"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mode", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {5.4980039840795545`, 0., 0.}, {
         5.4980039840795545`, 0., 0.}, {6, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 5.4980039840795545`, 0.}, {0., 
         5.4980039840795545`, 0.}, {0, 6, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 5.4980039840795545`}, {0., 0., 
         5.4980039840795545`}, {0, 0, 6}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Hexagonal cells in conventional layout; this mode only works if the third \
lattice vector is the hexagonal c-axis, other orientations of the cell are \
not supported.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", 
          RowBox[{"Sqrt", "[", "3", "]"}]}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"Sqrt", "[", "3", "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", "mode"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mode", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[NCache[{{1, -3^Rational[1, 2], 0}, {2, 0, 0}, {
          1, 3^Rational[1, 2], 0}, {-1, 3^Rational[1, 2], 0}, {-2, 0, 
          0}, {-1, -3^Rational[1, 2], 0}, {1, -3^Rational[1, 2], 0}}, {{
          1, -1.7320508075688772`, 0}, {2, 0, 0}, {
          1, 1.7320508075688772`, 0}, {-1, 1.7320508075688772`, 0}, {-2, 0, 
          0}, {-1, -1.7320508075688772`, 0}, {1, -1.7320508075688772`, 0}}], 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{1, -3^Rational[1, 2], 4}, {2, 0, 4}, {
          1, 3^Rational[1, 2], 4}, {-1, 3^Rational[1, 2], 4}, {-2, 0, 
          4}, {-1, -3^Rational[1, 2], 4}, {1, -3^Rational[1, 2], 4}}, {{
          1, -1.7320508075688772`, 4}, {2, 0, 4}, {
          1, 1.7320508075688772`, 4}, {-1, 1.7320508075688772`, 4}, {-2, 0, 
          4}, {-1, -1.7320508075688772`, 4}, {1, -1.7320508075688772`, 4}}], 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{0, 0, 0}, {1, -3^Rational[1, 2], 0}}, {{0, 0, 0}, {
           1, 3^Rational[1, 2], 0}}, {{0, 0, 0}, {-2, 0, 
          0}}}, {{{0, 0, 0}, {1, -1.7320508075688772`, 0}}, {{0, 0, 0}, {
           1, 1.7320508075688772`, 0}}, {{0, 0, 0}, {-2, 0, 0}}}], 0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{0, 0, 4}, {1, -3^Rational[1, 2], 4}}, {{0, 0, 4}, {
           1, 3^Rational[1, 2], 4}}, {{0, 0, 4}, {-2, 0, 
          4}}}, {{{0, 0, 4}, {1, -1.7320508075688772`, 4}}, {{0, 0, 4}, {
           1, 1.7320508075688772`, 4}}, {{0, 0, 4}, {-2, 0, 4}}}], 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 4}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{1, -3^Rational[1, 2], 0}, {
           1, -3^Rational[1, 2], 4}}, {{2, 0, 0}, {2, 0, 
          4}}, {{1, 3^Rational[1, 2], 0}, {
           1, 3^Rational[1, 2], 4}}, {{-1, 3^Rational[1, 2], 0}, {-1, 3^
            Rational[1, 2], 4}}, {{-2, 0, 0}, {-2, 0, 
          4}}, {{-1, -3^Rational[1, 2], 0}, {-1, -3^Rational[1, 2], 4}}, {{
           1, -3^Rational[1, 2], 0}, {1, -3^Rational[1, 2], 4}}}, {{{
           1, -1.7320508075688772`, 0}, {1, -1.7320508075688772`, 4}}, {{2, 0,
           0}, {2, 0, 
          4}}, {{1, 1.7320508075688772`, 0}, {
           1, 1.7320508075688772`, 4}}, {{-1, 1.7320508075688772`, 0}, {-1, 
            1.7320508075688772`, 4}}, {{-2, 0, 0}, {-2, 0, 
          4}}, {{-1, -1.7320508075688772`, 0}, {-1, -1.7320508075688772`, 
            4}}, {{1, -1.7320508075688772`, 0}, {
           1, -1.7320508075688772`, 4}}}], 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {0.7633568086760154, -1.3221727769304934`, 
          0.}, {0.7633568086760154, -1.3221727769304934`, 0.}, {
          1, -3^Rational[1, 2], 0}}, {{0, 0, 0}, {
          0.7633568086760154, -1.3221727769304934`, 0.}, {
          0.7633568086760154, -1.3221727769304934`, 0.}, {
          1, -1.7320508075688772`, 0}}], {
        0.021, 0.021, 0.11832159566199232`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {0.7633568086760154, 1.3221727769304934`, 
          0.}, {0.7633568086760154, 1.3221727769304934`, 0.}, {
          1, 3^Rational[1, 2], 0}}, {{0, 0, 0}, {0.7633568086760154, 
          1.3221727769304934`, 0.}, {0.7633568086760154, 1.3221727769304934`, 
          0.}, {1, 1.7320508075688772`, 0}}], {
        0.021, 0.021, 0.11832159566199232`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {-1.5267136173520308`, 0., 
         0.}, {-1.5267136173520308`, 0., 0.}, {-2, 0, 0}}, {
        0.021, 0.021, 0.11832159566199232`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 3.526713617352031}, {0., 0., 
         3.526713617352031}, {0, 0, 4}}, {
        0.021, 0.021, 0.11832159566199232`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[NCache[{{1, -3^Rational[1, 2], 0}, {2, 0, 0}, {
          1, 3^Rational[1, 2], 0}, {-1, 3^Rational[1, 2], 0}, {-2, 0, 
          0}, {-1, -3^Rational[1, 2], 0}, {1, -3^Rational[1, 2], 0}}, {{
          1, -1.7320508075688772`, 0}, {2, 0, 0}, {
          1, 1.7320508075688772`, 0}, {-1, 1.7320508075688772`, 0}, {-2, 0, 
          0}, {-1, -1.7320508075688772`, 0}, {1, -1.7320508075688772`, 0}}], 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{1, -3^Rational[1, 2], 4}, {2, 0, 4}, {
          1, 3^Rational[1, 2], 4}, {-1, 3^Rational[1, 2], 4}, {-2, 0, 
          4}, {-1, -3^Rational[1, 2], 4}, {1, -3^Rational[1, 2], 4}}, {{
          1, -1.7320508075688772`, 4}, {2, 0, 4}, {
          1, 1.7320508075688772`, 4}, {-1, 1.7320508075688772`, 4}, {-2, 0, 
          4}, {-1, -1.7320508075688772`, 4}, {1, -1.7320508075688772`, 4}}], 
        0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{0, 0, 0}, {1, -3^Rational[1, 2], 0}}, {{0, 0, 0}, {
           1, 3^Rational[1, 2], 0}}, {{0, 0, 0}, {-2, 0, 
          0}}}, {{{0, 0, 0}, {1, -1.7320508075688772`, 0}}, {{0, 0, 0}, {
           1, 1.7320508075688772`, 0}}, {{0, 0, 0}, {-2, 0, 0}}}], 0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{0, 0, 4}, {1, -3^Rational[1, 2], 4}}, {{0, 0, 4}, {
           1, 3^Rational[1, 2], 4}}, {{0, 0, 4}, {-2, 0, 
          4}}}, {{{0, 0, 4}, {1, -1.7320508075688772`, 4}}, {{0, 0, 4}, {
           1, 1.7320508075688772`, 4}}, {{0, 0, 4}, {-2, 0, 4}}}], 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 4}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{{1, -3^Rational[1, 2], 0}, {
           1, -3^Rational[1, 2], 4}}, {{2, 0, 0}, {2, 0, 
          4}}, {{1, 3^Rational[1, 2], 0}, {
           1, 3^Rational[1, 2], 4}}, {{-1, 3^Rational[1, 2], 0}, {-1, 3^
            Rational[1, 2], 4}}, {{-2, 0, 0}, {-2, 0, 
          4}}, {{-1, -3^Rational[1, 2], 0}, {-1, -3^Rational[1, 2], 4}}, {{
           1, -3^Rational[1, 2], 0}, {1, -3^Rational[1, 2], 4}}}, {{{
           1, -1.7320508075688772`, 0}, {1, -1.7320508075688772`, 4}}, {{2, 0,
           0}, {2, 0, 
          4}}, {{1, 1.7320508075688772`, 0}, {
           1, 1.7320508075688772`, 4}}, {{-1, 1.7320508075688772`, 0}, {-1, 
            1.7320508075688772`, 4}}, {{-2, 0, 0}, {-2, 0, 
          4}}, {{-1, -1.7320508075688772`, 0}, {-1, -1.7320508075688772`, 
            4}}, {{1, -1.7320508075688772`, 0}, {
           1, -1.7320508075688772`, 4}}}], 0.02]}}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{}, {
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {0.7633568086760154, -1.3221727769304934`, 
          0.}, {0.7633568086760154, -1.3221727769304934`, 0.}, {
          1, -3^Rational[1, 2], 0}}, {{0, 0, 0}, {
          0.7633568086760154, -1.3221727769304934`, 0.}, {
          0.7633568086760154, -1.3221727769304934`, 0.}, {
          1, -1.7320508075688772`, 0}}], {
        0.021, 0.021, 0.11832159566199232`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[NCache[{{0, 0, 0}, {0.7633568086760154, 1.3221727769304934`, 
          0.}, {0.7633568086760154, 1.3221727769304934`, 0.}, {
          1, 3^Rational[1, 2], 0}}, {{0, 0, 0}, {0.7633568086760154, 
          1.3221727769304934`, 0.}, {0.7633568086760154, 1.3221727769304934`, 
          0.}, {1, 1.7320508075688772`, 0}}], {
        0.021, 0.021, 0.11832159566199232`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {-1.5267136173520308`, 0., 
         0.}, {-1.5267136173520308`, 0., 0.}, {-2, 0, 0}}, {
        0.021, 0.021, 0.11832159566199232`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 3.526713617352031}, {0., 0., 
         3.526713617352031}, {0, 0, 4}}, {
        0.021, 0.021, 0.11832159566199232`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1663, 933},
WindowMargins->{{-2, Automatic}, {Automatic, 8}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569828990-3834481"->{
  Cell[755, 30, 208, 3, 40, "Print",
   CellTags->"Info3569828990-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569828990-3834481", 47064, 1378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 173, 6, 70, "Section"],
Cell[755, 30, 208, 3, 40, "Print",
 CellTags->"Info3569828990-3834481"],
Cell[CellGroupData[{
Cell[988, 37, 529, 17, 29, "Item"],
Cell[1520, 56, 310, 8, 113, "Item"],
Cell[1833, 66, 102, 2, 29, "Item"],
Cell[1938, 70, 124, 3, 29, "Item"],
Cell[2065, 75, 159, 3, 29, "Item"],
Cell[2227, 80, 26, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2290, 85, 30, 0, 49, "Subsection"],
Cell[2323, 87, 33, 0, 30, "Text"],
Cell[2359, 89, 102, 2, 31, "Input"],
Cell[2464, 93, 43, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2532, 97, 861, 26, 31, "Input"],
Cell[3396, 125, 11233, 333, 197, "Output"]
}, Open  ]],
Cell[14644, 461, 39, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[14708, 465, 903, 27, 31, "Input"],
Cell[15614, 494, 7803, 234, 197, "Output"]
}, Open  ]],
Cell[23432, 731, 94, 1, 30, "Text"],
Cell[CellGroupData[{
Cell[23551, 736, 952, 29, 31, "Input"],
Cell[24506, 767, 6831, 189, 197, "Output"]
}, Open  ]],
Cell[31352, 959, 43, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[31420, 963, 893, 27, 31, "Input"],
Cell[32316, 992, 4689, 152, 197, "Output"]
}, Open  ]],
Cell[37020, 1147, 191, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[37236, 1155, 885, 28, 31, "Input"],
Cell[38124, 1185, 8540, 176, 230, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
