(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     31529,       1041]
NotebookOptionsPosition[     29931,        982]
NotebookOutlinePosition[     30476,       1005]
CellTagsIndexPosition[     30391,       1000]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CellLinesAdd",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CellLinesAdd is an option of CrystalPlot which allows the \
addition of arbitrary additional cell outlines to the plot.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3605451550-7692834"],

Cell[CellGroupData[{

Cell[TextData[{
 "CellLinesAdd is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " which allows the addition of an arbitrary cell outline to the plot. The \
added cell outline is completely independent of the cell outline of the cell \
that is actually plotted."
}], "Item"],

Cell["\<\
The option value of CellLinesAdd is a list containing the lattice vectors \
corresponding to the additional cell outlines, the origin of the additional \
cell, and options.\
\>", "Item"],

Cell["\<\
The origin of the additional cell can be given as a list of 3 numbers (2 in \
2D) denoting the position of the origin in reduced coordinates (that is, in \
the basis of the main cell). If the origin is omitted, it is set to {0,0,0} \
(or {0,0} in 2D). The origin can also be a single integer, in which case it \
will be located at the coordinates of the atom with that index.\
\>", "Item"],

Cell[TextData[{
 "The option value can also contain the options ",
 ButtonBox["CellLineStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineStyle"],
 ", ",
 ButtonBox["CellLineCol",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineCol"],
 ", ",
 ButtonBox["CellLineRad",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLineRad"],
 ", and ",
 ButtonBox["CellLinesFlatQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CellLinesFlatQ"],
 " to specify the display and layout of the additional cell outlines \
indepently of the main cell outlines. The option ",
 ButtonBox["Sysdim",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"],
 " can also be given in CellLinesAdd, and defaults to the Sysdim of the rest \
of the plot if not given. Cell layout options that are not given explicitly \
default to their usual default values, NOT to the values set for the main \
cell outlines of the plot."
}], "Item"],

Cell["\<\
To add more than one additional cell outline, use CellLinesAdd->{\
\[OpenCurlyDoubleQuote]multi\[CloseCurlyDoubleQuote],{lattice1,origin1,\
options1},{lattice2,origin2,options2},...}.\
\>", "Item"],

Cell["\<\
The lattice vectors for the additional cell outlines can be specified in any \
of the formats CrystalChange and CrystalPlot accept.\
\>", "Item"],

Cell["Default: {}", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["\<\
Plot a cubic fcc cell and add the primitive cell; the origin specification is \
omitted in this example because it coincides with the origin of the cubic \
cell:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"CellLinesAdd", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1.5", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.5", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "0", ",", "1.5"}], "}"}]}], "}"}], ",", 
      RowBox[{"CellLineCol", "\[Rule]", "Red"}]}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   GeometricTransformation3DBox[{{
      {RGBColor[1, 0, 0], 
       TubeBox[{{{0., 0., 0.}, {1.5, 1.5, 0.}, {1.5, 3., 1.5}, {0., 1.5, 
        1.5}, {0., 0., 0.}}, {{1.5, 0., 1.5}, {3., 1.5, 1.5}, {3., 3., 3.}, {
        1.5, 1.5, 3.}, {1.5, 0., 1.5}}}, 0.02]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{{0., 0., 0.}, {1.5, 0., 1.5}}, {{1.5, 1.5, 0.}, {3., 1.5, 
        1.5}}, {{1.5, 3., 1.5}, {3., 3., 3.}}, {{0., 1.5, 1.5}, {1.5, 1.5, 
        3.}}}, 0.02]}}, {
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {1.2015113830821935`, 1.2015113830821935`, 0.}, {
         1.2015113830821935`, 1.2015113830821935`, 0.}, {1.5, 1.5, 0}}, {
        0.021, 0.021, 0.10553166256478728`, 0}]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {0., 1.2015113830821935`, 1.2015113830821935`}, {
         0., 1.2015113830821935`, 1.2015113830821935`}, {0, 1.5, 1.5}}, {
        0.021, 0.021, 0.10553166256478728`, 0}]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {1.2015113830821935`, 0., 1.2015113830821935`}, {
         1.2015113830821935`, 0., 1.2015113830821935`}, {1.5, 0, 1.5}}, {
        0.021, 0.021, 0.10553166256478728`, 0}]}}}, {0, 0, 0}], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Put arbitrary sets of arrows on atoms:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", "0", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"CellLinesAdd", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<multi\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "2", ",", 
        RowBox[{"CellLineStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], ",", 
        RowBox[{"CellLineCol", "\[Rule]", "Red"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "3", ",", 
        RowBox[{"CellLineStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], ",", 
        RowBox[{"CellLineCol", "\[Rule]", "Green"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   GeometricTransformation3DBox[{{}, {
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {0.7562850648407653, 0.7562850648407653, 0.}, {
         0.7562850648407653, 0.7562850648407653, 0.}, {1, 1, 0}}, {
        0.021, 0.021, 0.08616624166376731, 0}]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {0., 0.7562850648407653, 0.7562850648407653}, {0., 
         0.7562850648407653, 0.7562850648407653}, {0, 1, 1}}, {
        0.021, 0.021, 0.08616624166376731, 0}]}, 
      {RGBColor[1, 0, 0], 
       TubeBox[{{0, 0, 0}, {0.7562850648407653, 0., 0.7562850648407653}, {
         0.7562850648407653, 0., 0.7562850648407653}, {1, 0, 1}}, {
        0.021, 0.021, 0.08616624166376731, 0}]}}}, {1.5, 1.5, 0.}], 
   GeometricTransformation3DBox[{{}, {
      {RGBColor[0, 1, 0], 
       TubeBox[{{0, 0, 0}, {0.7562850648407653, 0.7562850648407653, 0.}, {
         0.7562850648407653, 0.7562850648407653, 0.}, {1, 1, 0}}, {
        0.021, 0.021, 0.08616624166376731, 0}]}, 
      {RGBColor[0, 1, 0], 
       TubeBox[{{0, 0, 0}, {0., 0.7562850648407653, 0.7562850648407653}, {0., 
         0.7562850648407653, 0.7562850648407653}, {0, 1, 1}}, {
        0.021, 0.021, 0.08616624166376731, 0}]}, 
      {RGBColor[0, 1, 0], 
       TubeBox[{{0, 0, 0}, {0.7562850648407653, 0., 0.7562850648407653}, {
         0.7562850648407653, 0., 0.7562850648407653}, {1, 0, 1}}, {
        0.021, 0.021, 0.08616624166376731, 0}]}}}, {1.5, 0., 1.5}], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 0., 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0., 1.5, 1.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Do not plot the main cell outlines, and instead use CellLinesAdd to \
superimpose a different set of cell outlines. This gives the impression of a \
shifted lattice origin without actually changing the crystal data:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"Sysdim", "\[Rule]", "2"}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "False"}], ",", 
   RowBox[{"CellLinesAdd", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, GeometricTransformation3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}}, {1.5, 1.5, 1.5}], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 3}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 3, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 3, 3}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 0, 3}, 0.5],
       "Ball"]},
     "11"],
    Annotation[#, 11, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "12"],
    Annotation[#, 12, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 3, 0}, 0.5],
       "Ball"]},
     "13"],
    Annotation[#, 13, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "14"],
    Annotation[#, 14, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 3, 3}, 0.5],
       "Ball"]},
     "15"],
    Annotation[#, 15, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "16"],
    Annotation[#, 16, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 0, 0}, 0.5],
       "Ball"]},
     "17"],
    Annotation[#, 17, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 0, 3}, 0.5],
       "Ball"]},
     "18"],
    Annotation[#, 18, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 3, 0}, 0.5],
       "Ball"]},
     "19"],
    Annotation[#, 19, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 3, 3}, 0.5],
       "Ball"]},
     "20"],
    Annotation[#, 20, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 6, 0}, 0.5],
       "Ball"]},
     "21"],
    Annotation[#, 21, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 6, 3}, 0.5],
       "Ball"]},
     "22"],
    Annotation[#, 22, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 6, 0}, 0.5],
       "Ball"]},
     "23"],
    Annotation[#, 23, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 6, 3}, 0.5],
       "Ball"]},
     "24"],
    Annotation[#, 24, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 6, 0}, 0.5],
       "Ball"]},
     "25"],
    Annotation[#, 25, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 6, 3}, 0.5],
       "Ball"]},
     "26"],
    Annotation[#, 26, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 6}, 0.5],
       "Ball"]},
     "27"],
    Annotation[#, 27, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 3, 6}, 0.5],
       "Ball"]},
     "28"],
    Annotation[#, 28, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 0, 6}, 0.5],
       "Ball"]},
     "29"],
    Annotation[#, 29, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 3, 6}, 0.5],
       "Ball"]},
     "30"],
    Annotation[#, 30, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 0, 6}, 0.5],
       "Ball"]},
     "31"],
    Annotation[#, 31, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 3, 6}, 0.5],
       "Ball"]},
     "32"],
    Annotation[#, 32, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 6, 6}, 0.5],
       "Ball"]},
     "33"],
    Annotation[#, 33, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 6, 6}, 0.5],
       "Ball"]},
     "34"],
    Annotation[#, 34, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{6, 6, 6}, 0.5],
       "Ball"]},
     "35"],
    Annotation[#, 35, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The plot in the previous example can also be achieved using ",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"],
 " and ",
 ButtonBox["MoveOrigin",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/MoveOrigin"],
 "; note that this approach changes the cell, which is relevant if the raw \
data is going to be re-used (e.g. via ",
 ButtonBox["ButtonQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/ButtonQ"],
 "):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AddQ", "\[Rule]", ".5"}], ",", 
   RowBox[{"MoveOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 0.}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3., 0., 0.}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 3., 0.}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3., 3., 0.}, 0.5],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, -1.5, 1.5}, 0.5],
       "Ball"]},
     "11"],
    Annotation[#, 11, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, -1.5, 1.5}, 0.5],
       "Ball"]},
     "12"],
    Annotation[#, 12, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, -1.5, 1.5}, 0.5],
       "Ball"]},
     "13"],
    Annotation[#, 13, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "14"],
    Annotation[#, 14, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 3.}, 0.5],
       "Ball"]},
     "15"],
    Annotation[#, 15, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "16"],
    Annotation[#, 16, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3., 0., 3.}, 0.5],
       "Ball"]},
     "17"],
    Annotation[#, 17, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "18"],
    Annotation[#, 18, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "19"],
    Annotation[#, 19, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 3., 3.}, 0.5],
       "Ball"]},
     "20"],
    Annotation[#, 20, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "21"],
    Annotation[#, 21, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{3., 3., 3.}, 0.5],
       "Ball"]},
     "22"],
    Annotation[#, 22, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "23"],
    Annotation[#, 23, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, -1.5, 4.5}, 0.5],
       "Ball"]},
     "24"],
    Annotation[#, 24, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, -1.5, 4.5}, 0.5],
       "Ball"]},
     "25"],
    Annotation[#, 25, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, -1.5, 4.5}, 0.5],
       "Ball"]},
     "26"],
    Annotation[#, 26, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
       "Ball"]},
     "27"],
    Annotation[#, 27, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, -1.5}, 0.5],
       "Ball"]},
     "28"],
    Annotation[#, 28, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, 1.5, -1.5}, 0.5],
       "Ball"]},
     "29"],
    Annotation[#, 29, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, -1.5}, 0.5],
       "Ball"]},
     "30"],
    Annotation[#, 30, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, -1.5}, 0.5],
       "Ball"]},
     "31"],
    Annotation[#, 31, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, 4.5, -1.5}, 0.5],
       "Ball"]},
     "32"],
    Annotation[#, 32, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, -1.5, -1.5}, 0.5],
       "Ball"]},
     "33"],
    Annotation[#, 33, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, -1.5, -1.5}, 0.5],
       "Ball"]},
     "34"],
    Annotation[#, 34, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{-1.5, -1.5, -1.5}, 0.5],
       "Ball"]},
     "35"],
    Annotation[#, 35, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1658, 912},
WindowMargins->{{2, Automatic}, {Automatic, 1}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3605451550-7692834"->{
  Cell[759, 31, 226, 4, 40, "Print",
   CellTags->"Info3605451550-7692834"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3605451550-7692834", 30290, 994}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 177, 7, 70, "Section"],
Cell[759, 31, 226, 4, 40, "Print",
 CellTags->"Info3605451550-7692834"],
Cell[CellGroupData[{
Cell[1010, 39, 344, 8, 29, "Item"],
Cell[1357, 49, 196, 4, 29, "Item"],
Cell[1556, 55, 399, 6, 45, "Item"],
Cell[1958, 63, 987, 26, 45, "Item"],
Cell[2948, 91, 207, 4, 29, "Item"],
Cell[3158, 97, 155, 3, 29, "Item"],
Cell[3316, 102, 27, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3380, 107, 30, 0, 49, "Subsection"],
Cell[3413, 109, 33, 0, 30, "Text"],
Cell[3449, 111, 102, 2, 31, "Input"],
Cell[3554, 115, 185, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[3764, 123, 781, 23, 31, "Input"],
Cell[4548, 148, 2356, 52, 375, "Output"]
}, Open  ]],
Cell[6919, 203, 54, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[6998, 207, 1931, 55, 52, "Input"],
Cell[8932, 264, 3176, 78, 375, "Output"]
}, Open  ]],
Cell[12123, 345, 239, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[12387, 353, 1189, 36, 31, "Input"],
Cell[13579, 391, 7474, 270, 375, "Output"]
}, Open  ]],
Cell[21068, 664, 502, 15, 30, "Text"],
Cell[CellGroupData[{
Cell[21595, 683, 754, 23, 31, "Input"],
Cell[22352, 708, 7539, 269, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
