(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20873,        695]
NotebookOptionsPosition[     19434,        641]
NotebookOutlinePosition[     19979,        664]
CellTagsIndexPosition[     19894,        659]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "CenterAtOriginQ",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"CenterAtOriginQ is an option of CrystalChange and CrystalPlot \
which moves the center of the cell to the origin.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3617170727-8125852"],

Cell[CellGroupData[{

Cell[TextData[{
 "CenterAtOriginQ",
 " is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 "."
}], "Item"],

Cell["\<\
If CenterAtOriginQ is set to True, atoms will be moved to periodic images so \
that the cell is centered at the origin, i.e. the reduced coordinates no \
longer range from 0 to 1, but from -0.5 to 0.5.\
\>", "Item"],

Cell[TextData[{
 "Atom positions changed by CenterAtOriginQ are not changed again by ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 ", but",
 ButtonBox[" AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"],
 " works on the already-shifted cell as expected."
}], "Item"],

Cell["\<\
The effect of CenterAtOriginQ is not visible unless there are atoms with \
reduced coordinates larger than 0.5.\
\>", "Item"],

Cell[TextData[{
 "If a supercell is generated via ",
 ButtonBox["Sysdim",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/Sysdim"],
 ", CenterAtOriginQ centers the original cell, not the supercell."
}], "Item"],

Cell["\<\
CenterAtOriginQ can be used anisotropically, i.e. with one value for each \
direction (see last example).\
\>", "Item"],

Cell["Default: False", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Effect of the CenterAtOriginQ option:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"CenterAtOriginQ", "\[Rule]", "center"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"center", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 0}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 0}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 0}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 3}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 0, 3}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 3, 3}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{3, 3, 3}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "CenterAtOriginQ->True is generally not equivalent to ",
 ButtonBox["MoveOrigin",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/MoveOrigin"],
 "->{.5,.5,.5}, but the two options often make sense in conjunction:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"CenterAtOriginQ", "\[Rule]", "True"}], ",", 
     RowBox[{"MoveOrigin", "\[Rule]", "move"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"move", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["Move the cell origin, but only for the z direction:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"CenterAtOriginQ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 0,
       3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
    {GrayLevel[0], 
     TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {3, 
      3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 0, 0}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 3, 0}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{3, 3, 0}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3617170727-8125852"->{
  Cell[762, 31, 219, 4, 40, "Print",
   CellTags->"Info3617170727-8125852"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3617170727-8125852", 19793, 653}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 180, 7, 70, "Section"],
Cell[762, 31, 219, 4, 40, "Print",
 CellTags->"Info3617170727-8125852"],
Cell[CellGroupData[{
Cell[1006, 39, 288, 11, 29, "Item"],
Cell[1297, 52, 225, 4, 29, "Item"],
Cell[1525, 58, 341, 10, 29, "Item"],
Cell[1869, 70, 135, 3, 29, "Item"],
Cell[2007, 75, 221, 6, 29, "Item"],
Cell[2231, 83, 129, 3, 29, "Item"],
Cell[2363, 88, 30, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2430, 93, 30, 0, 49, "Subsection"],
Cell[2463, 95, 33, 0, 30, "Text"],
Cell[2499, 97, 102, 2, 31, "Input"],
Cell[2604, 101, 53, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2682, 105, 910, 27, 31, "Input"],
Cell[3595, 134, 5689, 178, 197, "Output"]
}, Open  ]],
Cell[9299, 315, 253, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[9577, 325, 1093, 33, 31, "Input"],
Cell[10673, 360, 5746, 178, 197, "Output"]
}, Open  ]],
Cell[16434, 541, 67, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[16526, 545, 769, 23, 31, "Input"],
Cell[17298, 570, 2096, 66, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
