(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     17942,        562]
NotebookOptionsPosition[     16766,        516]
NotebookOutlinePosition[     17311,        539]
CellTagsIndexPosition[     17226,        534]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "MoveOrigin",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"MoveOrigin is an option of CrystalChange and CrystalPlot which \
changes the origin of the cell, but not its size or shape.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3605854330-8968633"],

Cell[CellGroupData[{

Cell[TextData[{
 "MoveOrigin is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 "."
}], "Item"],

Cell["\<\
With MoveOrigin, you can change the cell\[CloseCurlyQuote]s origin to a \
different position. Give a single integer to move the origin to the atom \
denoted by that index, to a set of three (two in 2D) positive numbers for a \
shift in reduced coordinates, and to a set of three (two in 2D) negative \
numbers for a shift in Angstrom. Note that this means that you cannot use the \
sign to denote the direction of the shift! (But since the cells have periodic \
boundary conditions, this won\[CloseCurlyQuote]t be necessary anyway.) You \
cannot mix reduced and cartesian coordinates in the shift specification.\
\>", "Item"],

Cell[TextData[{
 "If MoveOrigin is used, ",
 ButtonBox["RetractQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/RetractQ"],
 " is automatically reset to True if it was previously False. Stronger \
numerical values of RetractQ may still take effect. ",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"],
 " works as always."
}], "Item"],

Cell["Default: {0,0,0}", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["A cell with origins moved to different posititions:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"3", "*", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"MoveOrigin", "\[Rule]", "move"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"move", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{".25", ",", ".25", ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", 
         RowBox[{"-", "1.2"}], ",", 
         RowBox[{"-", "1.2"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{2.25, 2.25, 2.25}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0.75, 0.75, 0.75}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[
         SphereBox[{1.8000000000000003`, 1.8000000000000003`, 
          1.8000000000000003`}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[
         SphereBox[{0.3000000000000001, 0.3000000000000001, 
          0.3000000000000001}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "MoveOrigin->{.5,.5,.5} is generally not equivalent to ",
 ButtonBox["CenterAtOriginQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CenterAtOriginQ"],
 "->True, but the two options often make sense in conjunction:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
     RowBox[{"CenterAtOriginQ", "\[Rule]", "True"}], ",", 
     RowBox[{"MoveOrigin", "\[Rule]", "move"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"move", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{0, 0, 0}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{-1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {3, 0, 0}, {3, 3, 0}, {0, 3, 0}, {0, 0, 0}}, {{0, 
        0, 3}, {3, 0, 3}, {3, 3, 3}, {0, 3, 3}, {0, 0, 3}}}, 0.02]}, 
      {GrayLevel[0], 
       TubeBox[{{{0, 0, 0}, {0, 0, 3}}, {{3, 0, 0}, {3, 0, 3}}, {{3, 3, 0}, {
        3, 3, 3}}, {{0, 3, 0}, {0, 3, 3}}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.880722, 0.611041, 0.142051], 
        TagBox[SphereBox[{0., 0., 0.}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, -1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, 1.5, -1.5}, 0.5],
         "Ball"]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{-1.5, -1.5, -1.5}, 0.5],
         "Ball"]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3605854330-8968633"->{
  Cell[757, 31, 230, 4, 40, "Print",
   CellTags->"Info3605854330-8968633"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3605854330-8968633", 17125, 528}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 175, 7, 70, "Section"],
Cell[757, 31, 230, 4, 40, "Print",
 CellTags->"Info3605854330-8968633"],
Cell[CellGroupData[{
Cell[1012, 39, 278, 10, 29, "Item"],
Cell[1293, 51, 635, 9, 62, "Item"],
Cell[1931, 62, 384, 11, 29, "Item"],
Cell[2318, 75, 32, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2387, 80, 30, 0, 49, "Subsection"],
Cell[2420, 82, 33, 0, 30, "Text"],
Cell[2456, 84, 102, 2, 31, "Input"],
Cell[2561, 88, 67, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2653, 92, 961, 29, 31, "Input"],
Cell[3617, 123, 5969, 162, 197, "Output"]
}, Open  ]],
Cell[9601, 288, 258, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[9884, 298, 1093, 33, 31, "Input"],
Cell[10980, 333, 5746, 178, 230, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
