(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     62433,       1675]
NotebookOptionsPosition[     60918,       1618]
NotebookOutlinePosition[     61465,       1641]
CellTagsIndexPosition[     61379,       1636]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "PolyStyle",
 " (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"PolyStyle[cornercount] is an option of CrystalPlot that \
defines the layout of coordination polyhedra.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3577703799-2097078"],

Cell[CellGroupData[{

Cell[TextData[{
 "PolyStyle",
 " is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 "."
}], "Item"],

Cell["\<\
PolyStyle[corners] gives layout options for polyhedra and must be given as a \
Directive (see default and examples), unless it consists of only one \
directive; lists are not accepted.\
\>", "Item"],

Cell["\<\
Default: PolyStyle[corners]->Directive[Opacity[.5],EdgeForm[None]].\
\>", "Item"],

Cell[TextData[{
 "Which polyhedra are displayed at all is determined by the option ",
 ButtonBox["PolyMode",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/PolyMode"],
 "."
}], "Item"],

Cell["Polyhedra are not available in 2D.", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Default layout:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", 
       RowBox[{"-", "1.5"}], ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", "1.5", ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7", ",", "0", ",", 
       RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 1.8}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.5], EdgeForm[None], 
    GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
     1.5, -0.6}, {1.7, 
     0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
      Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["Change the opacity and edge style:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", 
       RowBox[{"-", "1.5"}], ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", "1.5", ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7", ",", "0", ",", 
       RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", "True"}], ",", 
   RowBox[{
    RowBox[{"PolyStyle", "[", "4", "]"}], "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", ".3", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Thick", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 1.8}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.3], EdgeForm[Thickness[
    Large]], 
    GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
     1.5, -0.6}, {1.7, 
     0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
      Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
The default colour is the colour of the central atom; use a different colour:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", 
       RowBox[{"-", "1.5"}], ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".9"}], ",", "1.5", ",", 
       RowBox[{"-", ".6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7", ",", "0", ",", 
       RowBox[{"-", ".6"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", "True"}], ",", 
   RowBox[{
    RowBox[{"PolyStyle", "[", "4", "]"}], "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", ".5", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "None", "]"}], ",", "\"\<Firebrick\>\""}], 
     "]"}]}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0., 0., 0.9}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{0., 0., 1.8}, {0., 0., 0.9}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, -0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, -1.5, -0.6}, {-0.45, -0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {-0.45, 0.75, -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{-0.9, 1.5, -0.6}, {-0.45, 0.75, -0.3}}, 0.15]}}, {
    {RGBColor[0.368417, 0.506779, 0.709798], 
     TubeBox[{{0., 0., 0.}, {0.85, 0., -0.3}}, 0.15]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], 
     TubeBox[{{1.7, 0., -0.6}, {0.85, 0., -0.3}}, 0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{0, 0, 0}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{0., 0., 1.8}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, -1.5, -0.6}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{-0.9, 1.5, -0.6}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.880722, 0.611041, 0.142051], 
      TagBox[SphereBox[{1.7, 0., -0.6}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   {RGBColor[0.698004, 0.133305, 0.133305], Opacity[0.5], EdgeForm[None], 
    GraphicsComplex3DBox[{{0., 0., 1.8}, {-0.9, -1.5, -0.6}, {-0.9, 
     1.5, -0.6}, {1.7, 
     0., -0.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
      Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
Show a quartz structure with only bonds and opaque polyhedra:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.5", ",", 
       RowBox[{"-", "4.3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "4.3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "5.5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", ".7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", ".5", ",", ".3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".4", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", ".8", ",", ".2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".8", ",", ".8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".6", ",", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".4", ",", ".2", ",", ".2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".2", ",", ".8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2",
      ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolyMode", "[", "4", "]"}], "\[Rule]", "True"}], ",", 
   RowBox[{
    RowBox[{"PolyStyle", "[", "4", "]"}], "\[Rule]", 
    RowBox[{"EdgeForm", "[", "None", "]"}]}], ",", 
   RowBox[{"AddQ", "\[Rule]", "True"}], ",", 
   RowBox[{"Sysdim", "\[Rule]", "2"}], ",", 
   RowBox[{"AtomRad", "\[Rule]", "0"}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "False"}], ",", 
   RowBox[{"AtomCol", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SlateGray\>\"", ",", "\"\<Firebrick\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, -2.15, 0.}, {1.375, -1.505, 0.55}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, -0.86, 1.1}, {1.375, -1.505, 0.55}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, 2.15, 3.8499999999999996`}, {1.375, 1.505, 3.3}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, 0.86, 2.75}, {1.375, 1.505, 3.3}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, 2.15, 3.8499999999999996`}, {1.875, 2.365, 4.125}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, 2.58, 4.4}, {1.875, 2.365, 4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 1.65}, {2., 0.43, 2.2}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, 0.86, 2.75}, {2., 0.43, 2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 1.65}, {3., 0.43000000000000016`, 1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, 0.8600000000000003, 1.1}, {3., 0.43000000000000016`, 
      1.375}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 1.65}, {3., -0.43000000000000016`, 2.2}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, -0.8600000000000003, 2.75}, {3., -0.43000000000000016`, 
      2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 1.65}, {2., -0.43, 1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, -0.86, 1.1}, {2., -0.43, 1.375}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, 0.8600000000000003, 1.1}, {3.625, 1.5050000000000001`, 
      0.55}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 0.}, {3.625, 1.5050000000000001`, 0.55}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, 2.58, 4.4}, {3.125, 2.365, 4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 5.5}, {3.125, 2.365, 4.95}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, -0.8600000000000003, 2.75}, {3.625, -1.5050000000000001`, 
      3.3}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 3.8499999999999996`}, {
      3.625, -1.5050000000000001`, 3.3}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, -2.58, 4.4}, {1.875, -2.365, 4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, -2.15, 5.5}, {1.875, -2.365, 4.95}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, -2.58, 4.4}, {3.125, -2.365, 4.125}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 3.8499999999999996`}, {3.125, -2.365, 4.125}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, -2.15, 5.5}, {1.375, -1.505, 6.05}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, -0.86, 6.6}, {1.375, -1.505, 6.05}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, 2.15, 9.35}, {1.375, 1.505, 8.8}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, 0.86, 8.25}, {1.375, 1.505, 8.8}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, 2.15, 9.35}, {1.875, 2.365, 9.625}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, 2.58, 9.9}, {1.875, 2.365, 9.625}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 7.15}, {2., 0.43, 7.7}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, 0.86, 8.25}, {2., 0.43, 7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 7.15}, {3., 0.43000000000000016`, 6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, 0.8600000000000003, 6.6}, {3., 0.43000000000000016`, 
      6.875}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 7.15}, {3., -0.43000000000000016`, 7.7}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, -0.8600000000000003, 8.25}, {3., -0.43000000000000016`, 
      7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{2.5, 0., 7.15}, {2., -0.43, 6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{1.5, -0.86, 6.6}, {2., -0.43, 6.875}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, 0.8600000000000003, 6.6}, {3.625, 1.5050000000000001`, 
      6.05}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 5.5}, {3.625, 1.5050000000000001`, 6.05}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, 2.58, 9.9}, {3.125, 2.365, 10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 11.}, {3.125, 2.365, 10.45}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{3.5, -0.8600000000000003, 8.25}, {3.625, -1.5050000000000001`, 
      8.8}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 9.35}, {3.625, -1.5050000000000001`, 8.8}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, -2.58, 9.9}, {3.125, -2.365, 9.625}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 9.35}, {3.125, -2.365, 9.625}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{2.5, -2.58, 9.9}, {1.875, -2.365, 10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{1.25, -2.15, 11.}, {1.875, -2.365, 10.45}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 0.}, {3.875, 2.795, 0.55}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 3.4399999999999995`, 1.1}, {3.875, 2.795, 0.55}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 6.449999999999999, 3.8499999999999996`}, {3.875, 5.805, 
      3.3}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 5.159999999999999, 2.75}, {3.875, 5.805, 3.3}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 6.449999999999999, 3.8499999999999996`}, {4.375, 
      6.664999999999999, 4.125}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 6.88, 4.4}, {4.375, 6.664999999999999, 4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 1.65}, {4.5, 4.729999999999999, 2.2}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 5.159999999999999, 2.75}, {4.5, 4.729999999999999, 2.2}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 1.65}, {5.5, 4.7299999999999995`, 
      1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 5.16, 1.1}, {5.5, 4.7299999999999995`, 1.375}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 1.65}, {5.5, 3.869999999999999, 2.2}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 3.44, 2.75}, {5.5, 3.869999999999999, 2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 1.65}, {4.5, 3.869999999999999, 1.375}},
       0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 3.4399999999999995`, 1.1}, {4.5, 3.869999999999999, 
      1.375}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 5.16, 1.1}, {6.125, 5.805, 0.55}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 6.449999999999999, 0.}, {6.125, 5.805, 0.55}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 6.88, 4.4}, {5.625, 6.664999999999999, 4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 6.449999999999999, 5.5}, {5.625, 6.664999999999999, 
      4.95}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 3.44, 2.75}, {6.125, 2.795, 3.3}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 3.8499999999999996`}, {6.125, 2.795,
       3.3}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 1.7199999999999993`, 4.4}, {4.375, 1.9349999999999996`, 
      4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 5.5}, {4.375, 1.9349999999999996`, 4.95}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 1.7199999999999993`, 4.4}, {5.625, 1.9349999999999994`, 
      4.125}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 3.8499999999999996`}, {5.625, 
      1.9349999999999994`, 4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 5.5}, {3.875, 2.795, 6.05}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 3.4399999999999995`, 6.6}, {3.875, 2.795, 6.05}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 6.449999999999999, 9.35}, {3.875, 5.805, 8.8}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 5.159999999999999, 8.25}, {3.875, 5.805, 8.8}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 6.449999999999999, 9.35}, {4.375, 6.664999999999999, 
      9.625}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 6.88, 9.9}, {4.375, 6.664999999999999, 9.625}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 7.15}, {4.5, 4.729999999999999, 7.7}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 5.159999999999999, 8.25}, {4.5, 4.729999999999999, 7.7}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 7.15}, {5.5, 4.7299999999999995`, 
      6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 5.16, 6.6}, {5.5, 4.7299999999999995`, 6.875}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 7.15}, {5.5, 3.869999999999999, 7.7}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 3.44, 8.25}, {5.5, 3.869999999999999, 7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., 4.299999999999999, 7.15}, {4.5, 3.869999999999999, 6.875}},
       0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., 3.4399999999999995`, 6.6}, {4.5, 3.869999999999999, 
      6.875}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 5.16, 6.6}, {6.125, 5.805, 6.05}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 6.449999999999999, 5.5}, {6.125, 5.805, 6.05}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 6.88, 9.9}, {5.625, 6.664999999999999, 10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 6.449999999999999, 11.}, {5.625, 6.664999999999999, 
      10.45}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., 3.44, 8.25}, {6.125, 2.795, 8.8}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 9.35}, {6.125, 2.795, 8.8}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 1.7199999999999993`, 9.9}, {5.625, 1.9349999999999994`, 
      9.625}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 9.35}, {5.625, 1.9349999999999994`, 
      9.625}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., 1.7199999999999993`, 9.9}, {4.375, 1.9349999999999996`, 
      10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, 2.15, 11.}, {4.375, 1.9349999999999996`, 10.45}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -6.449999999999999, 0.}, {3.875, -5.805, 0.55}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -5.159999999999999, 1.1}, {3.875, -5.805, 0.55}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 3.8499999999999996`}, {3.875, -2.795, 3.3}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -3.4399999999999995`, 2.75}, {3.875, -2.795, 3.3}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 3.8499999999999996`}, {
      4.375, -1.9349999999999996`, 4.125}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -1.7199999999999993`, 4.4}, {4.375, -1.9349999999999996`, 
      4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 1.65}, {4.5, -3.869999999999999, 2.2}},
       0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -3.4399999999999995`, 2.75}, {4.5, -3.869999999999999, 
      2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 1.65}, {5.5, -3.869999999999999, 
      1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -3.44, 1.1}, {5.5, -3.869999999999999, 1.375}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 1.65}, {5.5, -4.7299999999999995`, 
      2.2}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -5.16, 2.75}, {5.5, -4.7299999999999995`, 2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 1.65}, {4.5, -4.729999999999999, 
      1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -5.159999999999999, 1.1}, {4.5, -4.729999999999999, 
      1.375}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -3.44, 1.1}, {6.125, -2.795, 0.55}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 0.}, {6.125, -2.795, 0.55}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -1.7199999999999993`, 4.4}, {5.625, -1.9349999999999994`, 
      4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 5.5}, {5.625, -1.9349999999999994`,
       4.95}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -5.16, 2.75}, {6.125, -5.805, 3.3}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -6.449999999999999, 3.8499999999999996`}, {6.125, -5.805,
       3.3}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -6.88, 4.4}, {4.375, -6.664999999999999, 4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -6.449999999999999, 5.5}, {4.375, -6.664999999999999, 
      4.95}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -6.88, 4.4}, {5.625, -6.664999999999999, 4.125}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -6.449999999999999, 3.8499999999999996`}, {
      5.625, -6.664999999999999, 4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -6.449999999999999, 5.5}, {3.875, -5.805, 6.05}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -5.159999999999999, 6.6}, {3.875, -5.805, 6.05}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 9.35}, {3.875, -2.795, 8.8}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -3.4399999999999995`, 8.25}, {3.875, -2.795, 8.8}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -2.15, 9.35}, {4.375, -1.9349999999999996`, 9.625}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -1.7199999999999993`, 9.9}, {4.375, -1.9349999999999996`, 
      9.625}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 7.15}, {4.5, -3.869999999999999, 7.7}},
       0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -3.4399999999999995`, 8.25}, {4.5, -3.869999999999999, 
      7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 7.15}, {5.5, -3.869999999999999, 
      6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -3.44, 6.6}, {5.5, -3.869999999999999, 6.875}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 7.15}, {5.5, -4.7299999999999995`, 
      7.7}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -5.16, 8.25}, {5.5, -4.7299999999999995`, 7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{5., -4.299999999999999, 7.15}, {4.5, -4.729999999999999, 
      6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{4., -5.159999999999999, 6.6}, {4.5, -4.729999999999999, 
      6.875}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -3.44, 6.6}, {6.125, -2.795, 6.05}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 5.5}, {6.125, -2.795, 6.05}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -1.7199999999999993`, 9.9}, {5.625, -1.9349999999999994`, 
      10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 11.}, {5.625, -1.9349999999999994`,
       10.45}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6., -5.16, 8.25}, {6.125, -5.805, 8.8}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -6.449999999999999, 9.35}, {6.125, -5.805, 8.8}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -6.88, 9.9}, {5.625, -6.664999999999999, 9.625}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -6.449999999999999, 9.35}, {5.625, -6.664999999999999, 
      9.625}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{5., -6.88, 9.9}, {4.375, -6.664999999999999, 10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{3.75, -6.449999999999999, 11.}, {4.375, -6.664999999999999, 
      10.45}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 0.}, {6.375, -1.505, 0.55}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, -0.8600000000000003, 1.1}, {6.375, -1.505, 0.55}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 3.8499999999999996`}, {6.375, 1.505,
       3.3}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, 0.8600000000000003, 2.75}, {6.375, 1.505, 3.3}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 3.8499999999999996`}, {6.875, 2.365,
       4.125}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, 2.580000000000001, 4.4}, {6.875, 2.365, 4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 1.65}, {7., 0.43000000000000016`, 2.2}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, 0.8600000000000003, 2.75}, {7., 0.43000000000000016`, 
      2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 1.65}, {8., 0.43000000000000016`, 1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, 0.8600000000000003, 1.1}, {8., 0.43000000000000016`, 
      1.375}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 1.65}, {8., -0.43000000000000016`, 2.2}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, -0.8600000000000003, 2.75}, {8., -0.43000000000000016`, 
      2.2}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 1.65}, {7., -0.43000000000000016`, 1.375}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, -0.8600000000000003, 1.1}, {7., -0.43000000000000016`, 
      1.375}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, 0.8600000000000003, 1.1}, {8.625, 1.5050000000000003`, 
      0.55}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, 2.1500000000000004`, 0.}, {8.625, 1.5050000000000003`, 
      0.55}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, 2.580000000000001, 4.4}, {8.125, 2.3650000000000007`, 
      4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, 2.1500000000000004`, 5.5}, {8.125, 2.3650000000000007`, 
      4.95}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, -0.8600000000000003, 2.75}, {8.625, -1.5050000000000003`, 
      3.3}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, -2.1500000000000004`, 3.8499999999999996`}, {
      8.625, -1.5050000000000003`, 3.3}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, -2.580000000000001, 4.4}, {6.875, -2.365, 4.95}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 5.5}, {6.875, -2.365, 4.95}}, 
      0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, -2.580000000000001, 4.4}, {8.125, -2.3650000000000007`, 
      4.125}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, -2.1500000000000004`, 3.8499999999999996`}, {
      8.125, -2.3650000000000007`, 4.125}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 5.5}, {6.375, -1.505, 6.05}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, -0.8600000000000003, 6.6}, {6.375, -1.505, 6.05}}, 
      0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 9.35}, {6.375, 1.505, 8.8}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, 0.8600000000000003, 8.25}, {6.375, 1.505, 8.8}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, 2.1499999999999995`, 9.35}, {6.875, 2.365, 9.625}}, 
      0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, 2.580000000000001, 9.9}, {6.875, 2.365, 9.625}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 7.15}, {7., 0.43000000000000016`, 7.7}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, 0.8600000000000003, 8.25}, {7., 0.43000000000000016`, 
      7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 7.15}, {8., 0.43000000000000016`, 6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, 0.8600000000000003, 6.6}, {8., 0.43000000000000016`, 
      6.875}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 7.15}, {8., -0.43000000000000016`, 7.7}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, -0.8600000000000003, 8.25}, {8., -0.43000000000000016`, 
      7.7}}, 0.15]}}, {
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{7.5, 0., 7.15}, {7., -0.43000000000000016`, 6.875}}, 0.15]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{6.5, -0.8600000000000003, 6.6}, {7., -0.43000000000000016`, 
      6.875}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, 0.8600000000000003, 6.6}, {8.625, 1.5050000000000003`, 
      6.05}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, 2.1500000000000004`, 5.5}, {8.625, 1.5050000000000003`, 
      6.05}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, 2.580000000000001, 9.9}, {8.125, 2.3650000000000007`, 
      10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, 2.1500000000000004`, 11.}, {8.125, 2.3650000000000007`, 
      10.45}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{8.5, -0.8600000000000003, 8.25}, {8.625, -1.5050000000000003`, 
      8.8}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, -2.1500000000000004`, 9.35}, {
      8.625, -1.5050000000000003`, 8.8}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, -2.580000000000001, 9.9}, {8.125, -2.3650000000000007`, 
      9.625}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{8.75, -2.1500000000000004`, 9.35}, {
      8.125, -2.3650000000000007`, 9.625}}, 0.15]}}, {
    {RGBColor[0.698004, 0.133305, 0.133305], 
     TubeBox[{{7.5, -2.580000000000001, 9.9}, {6.875, -2.365, 10.45}}, 0.15]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], 
     TubeBox[{{6.25, -2.1499999999999995`, 11.}, {6.875, -2.365, 10.45}}, 
      0.15]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{1.25, -2.15, 0.}, 0],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{1.25, 2.15, 3.8499999999999996`}, 0],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{2.5, 0., 1.65}, 0],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{1.5, 0.86, 2.75}, 0],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{3.5, 0.8600000000000003, 1.1}, 0],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{2.5, 2.58, 4.4}, 0],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{3.5, -0.8600000000000003, 2.75}, 0],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{1.5, -0.86, 1.1}, 0],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{2.5, -2.58, 4.4}, 0],
       "Ball"]},
     "9"],
    Annotation[#, 9, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{1.25, -2.15, 5.5}, 0],
       "Ball"]},
     "10"],
    Annotation[#, 10, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{1.25, 2.15, 9.35}, 0],
       "Ball"]},
     "11"],
    Annotation[#, 11, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{2.5, 0., 7.15}, 0],
       "Ball"]},
     "12"],
    Annotation[#, 12, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{1.5, 0.86, 8.25}, 0],
       "Ball"]},
     "13"],
    Annotation[#, 13, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{3.5, 0.8600000000000003, 6.6}, 0],
       "Ball"]},
     "14"],
    Annotation[#, 14, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{2.5, 2.58, 9.9}, 0],
       "Ball"]},
     "15"],
    Annotation[#, 15, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{3.5, -0.8600000000000003, 8.25}, 0],
       "Ball"]},
     "16"],
    Annotation[#, 16, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{1.5, -0.86, 6.6}, 0],
       "Ball"]},
     "17"],
    Annotation[#, 17, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{2.5, -2.58, 9.9}, 0],
       "Ball"]},
     "18"],
    Annotation[#, 18, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, 2.15, 0.}, 0],
       "Ball"]},
     "19"],
    Annotation[#, 19, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, 6.449999999999999, 3.8499999999999996`}, 0],
       "Ball"]},
     "20"],
    Annotation[#, 20, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{5., 4.299999999999999, 1.65}, 0],
       "Ball"]},
     "21"],
    Annotation[#, 21, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., 5.159999999999999, 2.75}, 0],
       "Ball"]},
     "22"],
    Annotation[#, 22, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., 5.16, 1.1}, 0],
       "Ball"]},
     "23"],
    Annotation[#, 23, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., 6.88, 4.4}, 0],
       "Ball"]},
     "24"],
    Annotation[#, 24, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., 3.44, 2.75}, 0],
       "Ball"]},
     "25"],
    Annotation[#, 25, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., 3.4399999999999995`, 1.1}, 0],
       "Ball"]},
     "26"],
    Annotation[#, 26, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., 1.7199999999999993`, 4.4}, 0],
       "Ball"]},
     "27"],
    Annotation[#, 27, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, 2.15, 5.5}, 0],
       "Ball"]},
     "28"],
    Annotation[#, 28, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, 6.449999999999999, 9.35}, 0],
       "Ball"]},
     "29"],
    Annotation[#, 29, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{5., 4.299999999999999, 7.15}, 0],
       "Ball"]},
     "30"],
    Annotation[#, 30, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., 5.159999999999999, 8.25}, 0],
       "Ball"]},
     "31"],
    Annotation[#, 31, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., 5.16, 6.6}, 0],
       "Ball"]},
     "32"],
    Annotation[#, 32, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., 6.88, 9.9}, 0],
       "Ball"]},
     "33"],
    Annotation[#, 33, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., 3.44, 8.25}, 0],
       "Ball"]},
     "34"],
    Annotation[#, 34, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., 3.4399999999999995`, 6.6}, 0],
       "Ball"]},
     "35"],
    Annotation[#, 35, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., 1.7199999999999993`, 9.9}, 0],
       "Ball"]},
     "36"],
    Annotation[#, 36, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, -6.449999999999999, 0.}, 0],
       "Ball"]},
     "37"],
    Annotation[#, 37, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, -2.15, 3.8499999999999996`}, 0],
       "Ball"]},
     "38"],
    Annotation[#, 38, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{5., -4.299999999999999, 1.65}, 0],
       "Ball"]},
     "39"],
    Annotation[#, 39, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., -3.4399999999999995`, 2.75}, 0],
       "Ball"]},
     "40"],
    Annotation[#, 40, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., -3.44, 1.1}, 0],
       "Ball"]},
     "41"],
    Annotation[#, 41, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., -1.7199999999999993`, 4.4}, 0],
       "Ball"]},
     "42"],
    Annotation[#, 42, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., -5.16, 2.75}, 0],
       "Ball"]},
     "43"],
    Annotation[#, 43, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., -5.159999999999999, 1.1}, 0],
       "Ball"]},
     "44"],
    Annotation[#, 44, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., -6.88, 4.4}, 0],
       "Ball"]},
     "45"],
    Annotation[#, 45, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, -6.449999999999999, 5.5}, 0],
       "Ball"]},
     "46"],
    Annotation[#, 46, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, -2.15, 9.35}, 0],
       "Ball"]},
     "47"],
    Annotation[#, 47, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{5., -4.299999999999999, 7.15}, 0],
       "Ball"]},
     "48"],
    Annotation[#, 48, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., -3.4399999999999995`, 8.25}, 0],
       "Ball"]},
     "49"],
    Annotation[#, 49, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., -3.44, 6.6}, 0],
       "Ball"]},
     "50"],
    Annotation[#, 50, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., -1.7199999999999993`, 9.9}, 0],
       "Ball"]},
     "51"],
    Annotation[#, 51, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6., -5.16, 8.25}, 0],
       "Ball"]},
     "52"],
    Annotation[#, 52, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{4., -5.159999999999999, 6.6}, 0],
       "Ball"]},
     "53"],
    Annotation[#, 53, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{5., -6.88, 9.9}, 0],
       "Ball"]},
     "54"],
    Annotation[#, 54, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, -2.1499999999999995`, 0.}, 0],
       "Ball"]},
     "55"],
    Annotation[#, 55, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, 2.1499999999999995`, 3.8499999999999996`}, 0],
       "Ball"]},
     "56"],
    Annotation[#, 56, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{7.5, 0., 1.65}, 0],
       "Ball"]},
     "57"],
    Annotation[#, 57, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6.5, 0.8600000000000003, 2.75}, 0],
       "Ball"]},
     "58"],
    Annotation[#, 58, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{8.5, 0.8600000000000003, 1.1}, 0],
       "Ball"]},
     "59"],
    Annotation[#, 59, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{7.5, 2.580000000000001, 4.4}, 0],
       "Ball"]},
     "60"],
    Annotation[#, 60, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{8.5, -0.8600000000000003, 2.75}, 0],
       "Ball"]},
     "61"],
    Annotation[#, 61, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6.5, -0.8600000000000003, 1.1}, 0],
       "Ball"]},
     "62"],
    Annotation[#, 62, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{7.5, -2.580000000000001, 4.4}, 0],
       "Ball"]},
     "63"],
    Annotation[#, 63, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, -2.1499999999999995`, 5.5}, 0],
       "Ball"]},
     "64"],
    Annotation[#, 64, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, 2.1499999999999995`, 9.35}, 0],
       "Ball"]},
     "65"],
    Annotation[#, 65, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{7.5, 0., 7.15}, 0],
       "Ball"]},
     "66"],
    Annotation[#, 66, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6.5, 0.8600000000000003, 8.25}, 0],
       "Ball"]},
     "67"],
    Annotation[#, 67, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{8.5, 0.8600000000000003, 6.6}, 0],
       "Ball"]},
     "68"],
    Annotation[#, 68, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{7.5, 2.580000000000001, 9.9}, 0],
       "Ball"]},
     "69"],
    Annotation[#, 69, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{8.5, -0.8600000000000003, 8.25}, 0],
       "Ball"]},
     "70"],
    Annotation[#, 70, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{6.5, -0.8600000000000003, 6.6}, 0],
       "Ball"]},
     "71"],
    Annotation[#, 71, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.698004, 0.133305, 0.133305], 
      TagBox[SphereBox[{7.5, -2.580000000000001, 9.9}, 0],
       "Ball"]},
     "72"],
    Annotation[#, 72, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, -6.449999999999999, 3.8499999999999996`}, 0],
       "Ball"]},
     "73"],
    Annotation[#, 73, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, -6.449999999999999, 9.35}, 0],
       "Ball"]},
     "74"],
    Annotation[#, 74, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{8.75, -2.1500000000000004`, 3.8499999999999996`}, 0],
       "Ball"]},
     "75"],
    Annotation[#, 75, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{8.75, -2.1500000000000004`, 9.35}, 0],
       "Ball"]},
     "76"],
    Annotation[#, 76, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, 6.449999999999999, 0.}, 0],
       "Ball"]},
     "77"],
    Annotation[#, 77, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, 6.449999999999999, 5.5}, 0],
       "Ball"]},
     "78"],
    Annotation[#, 78, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{8.75, 2.1500000000000004`, 0.}, 0],
       "Ball"]},
     "79"],
    Annotation[#, 79, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{8.75, 2.1500000000000004`, 5.5}, 0],
       "Ball"]},
     "80"],
    Annotation[#, 80, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{1.25, -2.15, 11.}, 0],
       "Ball"]},
     "81"],
    Annotation[#, 81, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, 2.15, 11.}, 0],
       "Ball"]},
     "82"],
    Annotation[#, 82, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{3.75, -6.449999999999999, 11.}, 0],
       "Ball"]},
     "83"],
    Annotation[#, 83, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, -2.1499999999999995`, 11.}, 0],
       "Ball"]},
     "84"],
    Annotation[#, 84, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{6.25, 6.449999999999999, 11.}, 0],
       "Ball"]},
     "85"],
    Annotation[#, 85, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.439207, 0.501999, 0.564699], 
      TagBox[SphereBox[{8.75, 2.1500000000000004`, 11.}, 0],
       "Ball"]},
     "86"],
    Annotation[#, 86, "Tooltip"]& ], {
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{1.5, 0.86, 2.75}, {3.5, 0.8600000000000003, 
      1.1}, {3.5, -0.8600000000000003, 2.75}, {1.5, -0.86, 
      1.1}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{1.5, 0.86, 8.25}, {3.5, 0.8600000000000003, 
      6.6}, {3.5, -0.8600000000000003, 8.25}, {1.5, -0.86, 
      6.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{4., 5.159999999999999, 2.75}, {6., 5.16, 1.1}, {
      6., 3.44, 2.75}, {4., 3.4399999999999995`, 
      1.1}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{2.5, 2.58, 4.4}, {3.5, 0.8600000000000003, 6.6}, {
      5., 1.7199999999999993`, 4.4}, {4., 3.4399999999999995`, 
      6.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{4., 5.159999999999999, 8.25}, {6., 5.16, 6.6}, {
      6., 3.44, 8.25}, {4., 3.4399999999999995`, 
      6.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{3.5, -0.8600000000000003, 2.75}, {2.5, -2.58, 
      4.4}, {4., -3.4399999999999995`, 2.75}, {5., -1.7199999999999993`, 
      4.4}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{4., -3.4399999999999995`, 2.75}, {6., -3.44, 
      1.1}, {6., -5.16, 2.75}, {4., -5.159999999999999, 
      1.1}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{3.5, -0.8600000000000003, 8.25}, {2.5, -2.58, 
      9.9}, {4., -3.4399999999999995`, 8.25}, {5., -1.7199999999999993`, 
      9.9}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{4., -3.4399999999999995`, 8.25}, {6., -3.44, 
      6.6}, {6., -5.16, 8.25}, {4., -5.159999999999999, 
      6.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{6., 3.44, 2.75}, {5., 1.7199999999999993`, 4.4}, {
      6.5, 0.8600000000000003, 2.75}, {7.5, 2.580000000000001, 
      4.4}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{6.5, 0.8600000000000003, 2.75}, {8.5, 
      0.8600000000000003, 1.1}, {8.5, -0.8600000000000003, 2.75}, {
      6.5, -0.8600000000000003, 
      1.1}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{5., -1.7199999999999993`, 4.4}, {6., -3.44, 
      6.6}, {7.5, -2.580000000000001, 4.4}, {6.5, -0.8600000000000003, 
      6.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{6., 3.44, 8.25}, {5., 1.7199999999999993`, 9.9}, {
      6.5, 0.8600000000000003, 8.25}, {7.5, 2.580000000000001, 
      9.9}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}, 
    {RGBColor[0.439207, 0.501999, 0.564699], EdgeForm[None], 
     GraphicsComplex3DBox[{{6.5, 0.8600000000000003, 8.25}, {8.5, 
      0.8600000000000003, 6.6}, {8.5, -0.8600000000000003, 8.25}, {
      6.5, -0.8600000000000003, 
      6.6}}, {Polygon3DBox[{1, 3, 2}], Polygon3DBox[{2, 3, 4}], 
       Polygon3DBox[{3, 1, 4}], Polygon3DBox[{1, 2, 4}]}]}}},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1659, 917},
WindowMargins->{{2, Automatic}, {Automatic, -1}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3577703799-2097078"->{
  Cell[756, 31, 209, 4, 40, "Print",
   CellTags->"Info3577703799-2097078"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3577703799-2097078", 61278, 1630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 174, 7, 70, "Section"],
Cell[756, 31, 209, 4, 40, "Print",
 CellTags->"Info3577703799-2097078"],
Cell[CellGroupData[{
Cell[990, 39, 168, 7, 29, "Item"],
Cell[1161, 48, 208, 4, 29, "Item"],
Cell[1372, 54, 91, 2, 29, "Item"],
Cell[1466, 58, 196, 6, 29, "Item"],
Cell[1665, 66, 50, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1752, 71, 30, 0, 49, "Subsection"],
Cell[1785, 73, 33, 0, 30, "Text"],
Cell[1821, 75, 102, 2, 31, "Input"],
Cell[1926, 79, 31, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[1982, 83, 819, 26, 31, "Input"],
Cell[2804, 111, 2240, 63, 375, "Output"]
}, Open  ]],
Cell[5059, 177, 50, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[5134, 181, 1040, 31, 31, "Input"],
Cell[6177, 214, 2257, 64, 375, "Output"]
}, Open  ]],
Cell[8449, 281, 101, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[8575, 287, 1071, 32, 31, "Input"],
Cell[9649, 321, 2240, 63, 375, "Output"]
}, Open  ]],
Cell[11904, 387, 85, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[12014, 393, 1766, 49, 52, "Input"],
Cell[13783, 444, 47095, 1169, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
