(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16642,        513]
NotebookOptionsPosition[     15280,        461]
NotebookOutlinePosition[     15825,        484]
CellTagsIndexPosition[     15740,        479]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Sysdim (",
 ButtonBox["Crystallica",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " package option)"
}], "Section"],

Cell[BoxData[
 StyleBox["\<\"Sysdim is an option of CrystalChange and CrystalPlot which \
states the periodic repetion of the unit cell.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3569829026-3834481"],

Cell[CellGroupData[{

Cell[TextData[{
 "Sysdim is an option of ",
 ButtonBox["CrystalPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalPlot"],
 " and ",
 ButtonBox["CrystalChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/CrystalChange"],
 "."
}], "Item"],

Cell["\<\
Sysdim gives the number of periodic repetitions of the cell as a list of 3 \
positive integers.\
\>", "Item"],

Cell[TextData[{
 "For irregular supercells, see also ",
 ButtonBox["Reshape",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica\\ref\\Reshape"]
}], "Item"],

Cell[TextData[{
 "For addition of atoms without changes to the cell shape and size, see also ",
 ButtonBox["AddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/ref/AddQ"]
}], "Item"],

Cell["Default: {1,1,1}", "Item"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["Load Crystallica:", "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Crystallica`\>\"", "]"}]], "Input",
 CellContext->"Global`"],

Cell["Effect of the Sysdim option:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CrystalPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"Sysdim", "\[Rule]", "sysdim"}], ",", 
     RowBox[{"CellLineStyle", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"sysdim", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 3, 0}, {3, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {3, 0, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {3, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {3, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 3}, {3, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 3}, {3, 3, 3}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True], ",", 
   Graphics3DBox[{{
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 3, 0}, {3, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{9, 0, 0}, {9, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{9, 3, 0}, {9, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {9, 0, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {9, 0, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {9, 0, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 0}, {9, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 3}, {9, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 3, 6}, {9, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{9, 0, 0}, {9, 3, 0}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 3}, {3, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{9, 0, 3}, {9, 3, 3}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{0, 0, 6}, {0, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{3, 0, 6}, {3, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{6, 0, 6}, {6, 3, 6}}, 0.02]}, 
      {GrayLevel[0], TubeBox[{{9, 0, 6}, {9, 3, 6}}, 0.02]}}, {
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {
         2.4980039840795545`, 0., 0.}, {3, 0, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
         2.4980039840795545`, 0.}, {0, 3, 0}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}, 
      {GrayLevel[0], 
       TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
         2.4980039840795545`}, {0, 0, 3}}, {
        0.021, 0.021, 0.12549900398011132`, 0}]}}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{7.5, 1.5, 1.5}, 0.5],
         "Ball"]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], 
        TagBox[SphereBox[{7.5, 1.5, 4.5}, 0.5],
         "Ball"]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ]},
    BaseStyle->{
      Specularity[
       GrayLevel[0.5], 100]},
    Boxed->False,
    Lighting->"Neutral",
    SphericalRegion->True]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
If you specify only one number, it is assumed that you want to use the same \
supercell size in each direction:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5", ",", ".5"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Sysdim", "\[Rule]", "2"}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 0, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 0}, {0, 3, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {0, 6, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 0, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 3, 0}, {3, 3, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 6, 0}, {3, 6, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 0, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 3, 0}, {6, 3, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 6, 0}, {6, 6, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {6, 0, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {6, 0, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 6}, {6, 0, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 0}, {6, 3, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 3}, {6, 3, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 3, 6}, {6, 3, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 0}, {6, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 3}, {6, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 6, 6}, {6, 6, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 0}, {0, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 0, 0}, {3, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 0}, {6, 6, 0}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 3}, {0, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 0, 3}, {3, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 3}, {6, 6, 3}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{0, 0, 6}, {0, 6, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{3, 0, 6}, {3, 6, 6}}, 0.02]}, 
    {GrayLevel[0], TubeBox[{{6, 0, 6}, {6, 6, 6}}, 0.02]}}, {
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {2.4980039840795545`, 0., 0.}, {2.4980039840795545`, 
       0., 0.}, {3, 0, 0}}, {0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 2.4980039840795545`, 0.}, {0., 
       2.4980039840795545`, 0.}, {0, 3, 0}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}, 
    {GrayLevel[0], 
     TubeBox[{{0, 0, 0}, {0., 0., 2.4980039840795545`}, {0., 0., 
       2.4980039840795545`}, {0, 0, 3}}, {
      0.021, 0.021, 0.12549900398011132`, 0}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{1.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 1.5, 4.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, 1.5}, 0.5],
       "Ball"]},
     "7"],
    Annotation[#, 7, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[SphereBox[{4.5, 4.5, 4.5}, 0.5],
       "Ball"]},
     "8"],
    Annotation[#, 8, "Tooltip"]& ]},
  BaseStyle->{
    Specularity[
     GrayLevel[0.5], 100]},
  Boxed->False,
  Lighting->"Neutral",
  SphericalRegion->True]], "Output"]
}, Open  ]],

Cell["\<\
For 2D structures, Sysdim can have two entries; a third number, if given, \
will be ignored.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrystalPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{".5", ",", ".5"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Sysdim", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}], ",", 
   RowBox[{"CellLineStyle", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellContext->"Global`"],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.01], LineBox[{{0, 0}, {9, 0}}]}, 
    {GrayLevel[0], Thickness[0.01], LineBox[{{0, 3}, {9, 3}}]}, 
    {GrayLevel[0], Thickness[0.01], LineBox[{{0, 6}, {9, 6}}]}, 
    {GrayLevel[0], Thickness[0.01], LineBox[{{0, 0}, {0, 6}}]}, 
    {GrayLevel[0], Thickness[0.01], LineBox[{{3, 0}, {3, 6}}]}, 
    {GrayLevel[0], Thickness[0.01], LineBox[{{6, 0}, {6, 6}}]}, 
    {GrayLevel[0], Thickness[0.01], LineBox[{{9, 0}, {9, 6}}]}}, {
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     ArrowBox[{{0, 0}, {3, 0}}]}, 
    {GrayLevel[0], Thickness[0.01], Arrowheads[0.10500000000000001`], 
     ArrowBox[{{0, 0}, {0, 3}}]}}, 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{1.5, 1.5}, 0.5],
       "Ball"]},
     "1"],
    Annotation[#, 1, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{1.5, 4.5}, 0.5],
       "Ball"]},
     "2"],
    Annotation[#, 2, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{4.5, 1.5}, 0.5],
       "Ball"]},
     "3"],
    Annotation[#, 3, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{4.5, 4.5}, 0.5],
       "Ball"]},
     "4"],
    Annotation[#, 4, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{7.5, 1.5}, 0.5],
       "Ball"]},
     "5"],
    Annotation[#, 5, "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     {RGBColor[0.368417, 0.506779, 0.709798], 
      TagBox[DiskBox[{7.5, 4.5}, 0.5],
       "Ball"]},
     "6"],
    Annotation[#, 6, "Tooltip"]& ]}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1664, 915},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569829026-3834481"->{
  Cell[748, 30, 213, 4, 40, "Print",
   CellTags->"Info3569829026-3834481"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569829026-3834481", 15639, 473}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 166, 6, 70, "Section"],
Cell[748, 30, 213, 4, 40, "Print",
 CellTags->"Info3569829026-3834481"],
Cell[CellGroupData[{
Cell[986, 38, 274, 10, 29, "Item"],
Cell[1263, 50, 119, 3, 29, "Item"],
Cell[1385, 55, 160, 5, 29, "Item"],
Cell[1548, 62, 192, 5, 29, "Item"],
Cell[1743, 69, 32, 0, 29, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1812, 74, 30, 0, 49, "Subsection"],
Cell[1845, 76, 33, 0, 30, "Text"],
Cell[1881, 78, 102, 2, 31, "Input"],
Cell[1986, 82, 44, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[2055, 86, 914, 28, 31, "Input"],
Cell[2972, 116, 5250, 127, 197, "Output"]
}, Open  ]],
Cell[8237, 246, 135, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[8397, 253, 579, 17, 31, "Input"],
Cell[8979, 272, 3797, 101, 375, "Output"]
}, Open  ]],
Cell[12791, 376, 116, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[12932, 383, 526, 17, 31, "Input"],
Cell[13461, 402, 1779, 54, 293, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
