(* ::Package:: *)

(*
Copyright (c) 2016 Bianca Eifert and Christian Heiliger, distributed under the MIT license
This file is part of Crystallica, do NOT load it separately.
Information about the Crystallica application can be found one level up from here.
*)
If[!TrueQ[$Context=="Crystallica`Private`"],Print["This package needs to be called from within Crystallica, aborting."];Abort[]];


BondPlot[lattvecP_,coordP_,confP_,d2Q_,spec_,atomcol_,options_]:=
Catch[Module[{style,colin,colpre,col,rad,tuples,bonds,distrange,partcol,bondobj,fullbondplot,halfcoord,halfconf,halftuples,halfbonds,halfpartcol,halfbondplot,halfdistrange,halfbondobj},

(*debugging: *)
If[debug,Print["BondPlot :: Entering function BondPlot[lattvecP,coordP,confP,d2Q,spec,atomcol,options] with the following input values:"]];
If[debug,Print["BondPlot :: \tlattvecP = ",lattvecP]];
If[debug,Print["BondPlot :: \tcoordP = ",coordP]];
If[debug,Print["BondPlot :: \tconfP = ",confP]];
If[debug,Print["BondPlot :: \td2Q = ",d2Q]];
If[debug,Print["BondPlot :: \tspec = ",spec]];
If[debug,Print["BondPlot :: \tatomcol = ",atomcol]];
If[debug,Print["BondPlot :: \toptions = ",options]];

(*check for valid values of the BondStyle option: *)
style=(BondStyle/.options/.Options[CrystalPlot])/.{True->1,False|None->-1};
If[!MatchQ[style,_Integer|_Function],style=0];
If[debug,Print["BondPlot :: Option value for BondStyle resolved to ",style]];
If[TrueQ[Sign[style]==-1],Throw[{}]];

(*bond tuples generation: *)
If[debug,Print["BondPlot :: Calling function BondTuples."]];
tuples=BondTuples[lattvecP,coordP,confP,options];
If[TrueQ[tuples=={}],Throw[{}]];
bonds=coordP[[#]].lattvecP&/@tuples;

(*colour: *)
partcol[bond_,atom_]:=atomcol[[confP[[tuples[[bond,atom]]]]]];

(*if the user defined a custom bond shape function, we're done here; also, be advised that BondsExtendQ is not applicable in this case: *)
If[MatchQ[style,_Function],If[debug,Print["BondPlot :: BondStyle is a user-defined function, throwing BondStyle[(bound atom pairs),(atom colours)] and exiting."]];Throw[style[bonds,partcol]]];

(*continue for normal tube bonds; more colour stuff: *)
colin=BondCol/.options/.Options[CrystalPlot];
colpre=If[MemberQ[ColorData["Gradients"],colin],ColorData[colin,#]&,colin];
col=Which[
MatchQ[colpre,_Function]&&!MemberQ[{0,5},style],colpre[0],
TrueQ[style==5]&&!MatchQ[colpre,_Function],Blend[{colpre,colpre},#]&,
True,colpre];
If[debug,Print["BondPlot :: Option value for BondCol resolved to ",col]];
(*radius: *)
rad=(BondRad/.options/.Options[CrystalPlot]/.x_/;!(NumericQ[x]||And@@(NumericQ/@x)):>.15);
rad=Switch[rad,{_,_,__},rad,{_,_},Join[rad,{Mean[rad]}],{_},{rad[[1]],rad[[1]],rad[[1]]},_,{rad,rad,rad}];
If[debug,Print["BondPlot :: Option value for BondRad resolved to ",rad]];
(*create bonds: *)
distrange=With[{alldist=Norm[Subtract@@#]&/@bonds},{Min[alldist],Max[alldist]}];
bondobj[index_,pos_,rad_,other___]:=With[{scaledrad=If[TrueQ[BondRadScaledQ/.options/.Options[CrystalPlot]],Rescale[Norm[Subtract@@bonds[[index]]],distrange,rad[[1;;2]]],rad[[-1-Length[Union[confP[[tuples[[index]]]]]]]]]},
If[d2Q||TrueQ[BondsFlatQ/.options/.Options[CrystalPlot]],{Thickness[.5*scaledrad],CapForm[None],Line[pos,other]},Tube[pos,scaledrad,other]]];
(*plot normal bonds: *)
fullbondplot=Switch[style,
1,(*atom colours*)Table[{partcol[#,ii],bondobj[#,{bonds[[#,ii]],Total[bonds[[#]]]*.5},rad]},{ii,1,2}],
2,(*atom colour gradient*)bondobj[#,bonds[[#]],rad,VertexColors->Table[{spec,partcol[#,ii]},{ii,1,2}]],
3,(*atom colours via intermediate colour*)bondobj[#,{bonds[[#,1]],.5*Total[bonds[[#]]],.5*Total[bonds[[#]]],bonds[[#,2]]},rad,VertexColors->{{spec,partcol[#,1]},{spec,Blend[{partcol[#,1],col}]},{spec,Blend[{partcol[#,2],col}]},{spec,partcol[#,2]}}],
4,(*atom colour gradient via intermediate colour*)bondobj[#,{bonds[[#,1]],.5*Total[bonds[[#]]],bonds[[#,2]]},rad,VertexColors->{{spec,partcol[#,1]},{spec,col},{spec,partcol[#,2]}}],
5,(*colour-code by bond length*){col[Rescale[Norm[Subtract@@bonds[[#]]],distrange]],bondobj[#,bonds[[#]],rad]},
_,(*single colour or gradient*)If[MatchQ[col,_Function],bondobj[#,Table[bonds[[#,1]]+ii*(bonds[[#,2]]-bonds[[#,1]]),{ii,0,1,.1}],rad,VertexColors->({spec,col[#]}&/@Range[0,1,.1])],{col,bondobj[#,bonds[[#]],rad]}]
]&/@Range[Length[bonds]];

(*extended half-bonds; sorry, this is really not elegant at all: *)
If[!TrueQ[BondsExtendQ/.options/.BondsExtendQ->False],Throw[fullbondplot]];
If[debug,Print["BondPlot :: Constructing out-of-cell half bonds."]];
If[debug,Print["BondPlot :: Calling function CrystalChange."]];
{halfcoord,halfconf}=CrystalChange[lattvecP,coordP,confP,RetractQ->True,AddQ->-(Abs[BondDist/.options/.Options[CrystalPlot]]),FilterRules[options,{Sysdim,CenterAtOriginQ}],NewbasisQ->False][[2;;3]];
With[{new=Complement[Transpose[{halfcoord,halfconf}],Transpose[{coordP,confP}]]},{halfcoord,halfconf}=Transpose[Join[Transpose[{coordP,confP}],new]]];
(*bond tuples generation: *)
If[debug,Print["BondPlot :: Calling function BondTuples."]];
halftuples=BondTuples[lattvecP,halfcoord,halfconf,options];
halftuples=Complement[halftuples,tuples];
halftuples=Select[halftuples,TrueQ[Length[Intersection[Range[Length[confP]],#]]==1]&];
halfbonds=halfcoord[[#]].lattvecP&/@halftuples;
halfpartcol[bond_,atom_]:=atomcol[[halfconf[[halftuples[[bond,atom]]]]]];
(*create bonds: *)
halfdistrange=With[{alldist=Norm[Subtract@@#]&/@halfbonds},{Min[alldist],Max[alldist]}];
halfbondobj[index_,pos_,rad_,other___]:=With[{scaledrad=If[TrueQ[BondRadScaledQ/.options/.Options[CrystalPlot]],Rescale[Norm[Subtract@@halfbonds[[index]]],halfdistrange,rad[[1;;2]]],rad[[-1-Length[Union[halfconf[[halftuples[[index]]]]]]]]]},
If[d2Q||TrueQ[BondsFlatQ/.options/.Options[CrystalPlot]],{Thickness[.5*scaledrad],CapForm[None],Line[pos,other]},Tube[pos,scaledrad,other]]];
halfbondplot=Switch[style,
1,(*atom colours*){halfpartcol[#,1],halfbondobj[#,{halfbonds[[#,1]],Total[halfbonds[[#]]]*.5},rad]},
2,(*atom colour gradient*)halfbondobj[#,{halfbonds[[#,1]],.5*Total[halfbonds[[#]]]},rad,VertexColors->{{spec,halfpartcol[#,1]},{spec,Blend[{halfpartcol[#,1],halfpartcol[#,2]}]}}],
3,(*atom colours via intermediate colour*)halfbondobj[#,{halfbonds[[#,1]],.5*Total[halfbonds[[#]]],.5*Total[halfbonds[[#]]]},rad,VertexColors->{{spec,halfpartcol[#,1]},{spec,Blend[{halfpartcol[#,1],col}]},{spec,Blend[{halfpartcol[#,2],col}]}}],
4,(*atom colour gradient via intermediate colour*)halfbondobj[#,{halfbonds[[#,1]],.5*Total[halfbonds[[#]]]},rad,VertexColors->{{spec,halfpartcol[#,1]},{spec,col}}],
5,(*colour-code by bond length*){col[Rescale[Norm[Subtract@@halfbonds[[#]]],halfdistrange]],halfbondobj[#,{halfbonds[[#,1]],.5*Total[halfbonds[[#]]]},rad]},
_,(*single colour or gradient*)If[MatchQ[col,_Function],halfbondobj[#,Table[halfbonds[[#,1]]+ii*(halfbonds[[#,2]]-halfbonds[[#,1]]),{ii,0,.5,.1}],rad,VertexColors->Table[{spec,col[jj]},{jj,If[halfconf[[halftuples[[#,1]]]]>halfconf[[halftuples[[#,2]]]],Range[1,.5,-.1],Range[0,.5,.1]]}]],{col,halfbondobj[#,{halfbonds[[#,1]],.5*Total[halfbonds[[#]]]},rad]}]
]&/@Range[Length[halfbonds]];

(*return all bond plots: *)
If[debug,Print["BondPlot :: Exiting function BondPlot and returning to calling function."]];
Join[fullbondplot,halfbondplot]
]];
