(* ::Package:: *)

(*
Copyright (c) 2016 Bianca Eifert and Christian Heiliger, distributed under the MIT license
This file is part of Crystallica, do NOT load it separately.
Information about the Crystallica application can be found one level up from here.
*)
If[!TrueQ[$Context=="Crystallica`Private`"],Print["This package needs to be called from within Crystallica, aborting."];Abort[]];


BondTuples[lattvecP_,coordP_,confP_,options_]:=
Module[{cart,cartwithinQ,maxdist,tuples,forcenone,noneatoms,nonetypes,force,weakatoms,strongatoms,weaktypes,strongtypes},

(*debugging: *)
If[debug,Print["BondTuples :: Entering function BondTuples[lattvecP,coordP,confP,options] with the following input values:"]];
If[debug,Print["BondTuples :: \tlattvecP = ",lattvecP]];
If[debug,Print["BondTuples :: \tcoordP = ",coordP]];
If[debug,Print["BondTuples :: \tconfP = ",confP]];
If[debug,Print["BondTuples :: \toptions = ",options]];

(*check whether an atom pair is close enough to be bound: *)
cart=coordP.lattvecP;
cartwithinQ[tuple_]:=(Norm[cart[[tuple[[1]]]]-cart[[tuple[[2]]]]]<maxdist);

(*cut-off distance: *)
maxdist=(BondDist/.options/.Options[CrystalPlot]/.x_/;!NumericQ[x]:>2.1);
(*if BondDist has a positive sign, find all pairs of atoms within the cut-off distance from each other (automatic bond generation);
if the sign is negative, the user wants only manually defined bonds, and 'tuples' is simply initialized to an empty list for now: *)
tuples=If[TrueQ[Sign[maxdist]==-1],{},Select[Subsets[Range[Length[confP]],{2}],cartwithinQ]];
(*drop the sign: *)
maxdist=Abs[maxdist];
If[debug,Print["BondTuples :: Option value for BondDist resolved to ",maxdist]];
If[debug,Print["BondTuples :: Automatic bond generation returned bonds ",tuples]];

(*forced non-bonds: *)
forcenone=Flatten[{ForceNoBonds/.options/.ForceNoBonds->Options[CrystalPlot]}];
(*... between specific atoms: *)
noneatoms="Atoms"/.forcenone/."Atoms"->{};If[!MatchQ[noneatoms,_List],noneatoms={noneatoms}];
noneatoms=Sort/@Flatten[DeleteCases[Switch[Length[#],2,{#},1,Table[{#[[1]],ii},{ii,Range[Length[confP]]}],0,Table[{#,ii},{ii,Range[Length[confP]]}],_,{}]&/@noneatoms,{}],1];
If[debug,Print["BondTuples :: Atom-specific forced non-bonding found for atom pairs ",noneatoms]];
(*... between specific types: *)
nonetypes="Types"/.forcenone/."Types"->{};If[!MatchQ[nonetypes,_List],nonetypes={nonetypes}];
nonetypes=Sort/@DeleteCases[Switch[Length[#],2,#,1,Flatten[{#,#}],0,{#,#},_,{}]&/@nonetypes,{}];
If[debug,Print["BondTuples :: Type-specific forced non-bonding found for type pairs ",nonetypes]];
(*remove forced non-bonds from automatically generated tuples: *)
tuples=Select[tuples,(!MemberQ[noneatoms,#]&&!MemberQ[nonetypes,Sort[confP[[#]]]])&];
If[debug,Print["BondTuples :: Forced non-bonding changed bond list to ",tuples]];

(*forced bonds: *)
force=Flatten[{ForceBonds/.options/.ForceBonds->Options[CrystalPlot]}];
(*... between atoms, weak version: *)
weakatoms="AtomsWeak"/.force/."AtomsWeak"->{};If[!MatchQ[weakatoms,_List],weakatoms={weakatoms}];
weakatoms=Sort/@Flatten[DeleteCases[Switch[Length[#],2,{#},1,Table[{#[[1]],ii},{ii,Range[Length[confP]]}],0,Table[{#,ii},{ii,Range[Length[confP]]}],_,{}]&/@weakatoms,{}],1];
weakatoms=Select[weakatoms,TrueQ[Complement[#,Range[Length[confP]]]=={}]&];
weakatoms=Select[weakatoms,(cartwithinQ[#]&&!MemberQ[noneatoms,#]&&!MemberQ[nonetypes,confP[[#]]])&];
If[debug,Print["BondTuples :: Weak atom-specific forced bonding found for atom pairs ",weakatoms]];
(*... between atoms, strong version: *)
strongatoms="AtomsStrong"/.force/."AtomsStrong"->{};If[!MatchQ[strongatoms,_List],strongatoms={strongatoms}];
strongatoms=Sort/@Flatten[DeleteCases[Switch[Length[#],2,{#},1,Table[{#[[1]],ii},{ii,Range[Length[confP]]}],0,Table[{#,ii},{ii,Range[Length[confP]]}],_,{}]&/@strongatoms,{}],1];
strongatoms=Select[strongatoms,TrueQ[Complement[#,Range[Length[confP]]]=={}]&];
If[debug,Print["BondTuples :: Strong atom-specific forced bonding found for atom pairs ",strongatoms]];
(*... between types, weak version: *)
weaktypes="TypesWeak"/.force/."TypesWeak"->{};If[!MatchQ[weaktypes,_List],weaktypes={weaktypes}];
weaktypes=Sort/@Flatten[DeleteCases[Switch[Length[#],2,{#},1,{{#[[1]],#[[1]]}},0,{{#,#}},_,{}]&/@weaktypes,{}],1];
weaktypes=Select[Subsets[Range[Length[confP]],{2}],MemberQ[weaktypes,confP[[#]]]&];
weaktypes=Select[weaktypes,(cartwithinQ[#]&&!MemberQ[noneatoms,#]&&!MemberQ[nonetypes,confP[[#]]])&];
If[debug,Print["BondTuples :: Weak type-specific forced bonding found for atom pairs ",weaktypes]];
(*... between types, strong version: *)
strongtypes="TypesStrong"/.force/."TypesStrong"->{};If[!MatchQ[strongtypes,_List],strongtypes={strongtypes}];
strongtypes=Sort/@Flatten[DeleteCases[Switch[Length[#],2,{#},1,{{#[[1]],#[[1]]}},0,{{#,#}},_,{}]&/@strongtypes,{}],1];
strongtypes=Select[Subsets[Range[Length[confP]],{2}],MemberQ[strongtypes,confP[[#]]]&];
If[debug,Print["BondTuples :: Strong type-specific forced bonding found for atom pairs ",strongtypes]];
(*join forced bonds with automatically generated tuples: *)
tuples=DeleteDuplicates[Sort/@Join[tuples,weakatoms,strongatoms,weaktypes,strongtypes]];
If[debug,Print["BondTuples :: Forced bonding changed bond list to ",tuples]];

(*return all bond tuples; result is a list of pairs of atom indices for further use by the BondPlot function: *)
If[debug,Print["BondTuples :: Exiting function BondTuples and returning to calling function."]];
tuples
];
