(* ::Package:: *)

(*
Copyright (c) 2016 Bianca Eifert and Christian Heiliger, distributed under the MIT license
This file is part of Crystallica, do NOT load it separately.
Information about the Crystallica application can be found one level up from here.
*)
If[!TrueQ[$Context=="Crystallica`Private`"],Print["This package needs to be called from within Crystallica, aborting."];Abort[]];


(*default values for options: *)
Options[CrystalPlot]=Join[Options[CrystalChange],{
AtomCol->97,
AtomFunction->(Ball[#,#2]&),
AtomRad->0.5,
BondCol->Gray,
BondDist->2.1,
BondRad->0.15,
BondRadScaledQ->False,
BondStyle->1,
BondsExtendQ->False,
BondsFlatQ->False,
ButtonQ->False,
CellLineCol->Black,
CellLineRad->0.02,
CellLineStyle->1,
CellLinesAdd->{},
CellLinesFlatQ->False,
ForceBonds->{},
ForceNoBonds->{},
LatticePlanes->{},
Pseudo3DQ->False
}];


CrystalPlot[lattvec_List,coord_/;MatchQ[coord,{_List..}],conf_/;MatchQ[conf,{_Integer..}],rawoptions___]:=
Catch[Module[{options,changed,lattvecP,coordP,confP,d2Q,p3dQ,sysdim,atomcol,radii,spec,atomfunc,atoms,oneplane,planes,polys,addlines,addlineorigin,supercell,lines,bonds,content,theplot},

(*debugging: *)
If[debug,Print["CrystalPlot :: Entering function CrystalPlot[lattvec,coord,conf,rawoptions] with the following input values:"]];
If[debug,Print["CrystalPlot :: \tlattvec = ",lattvec]];
If[debug,Print["CrystalPlot :: \tcoord = ",coord]];
If[debug,Print["CrystalPlot :: \tconf = ",conf]];
If[debug,Print["CrystalPlot :: \trawoptions = ",Flatten[{rawoptions}]]];

(*options processing: *)
options=Select[Flatten[{rawoptions}],MatchQ[#,_Rule]&];
(*some important named colours:*)
options=options/.{"D"|"T"->"H","Wat"|"O-H"->"O","Vac"->White};
(*Elephantica's old colour scheme, in case anyone wants to use it: *)
options=options/."darkphant"|"DarkPhant"|"Darkphant"->{"Indigo","Raspberry","TerreVerte","CadmiumYellow","ColdGray","BurntSienna","SeaGreen","DarkOrchid","Peacock","Firebrick"};
(*default colours for chemical species and recognition of legacy colours: *)
options=options/.ColorData["Atoms","ColorRules"]/.ColorData["Legacy","ColorRules"];
If[debug,Print["CrystalPlot :: Colour parsing led to refined options ",options]];

(*run structure through CrystalChange: *)
If[debug,Print["CrystalPlot :: Calling function CrystalChange."]];
changed=CrystalChange[lattvec,coord,conf,Acell->0,NewbasisQ->False,FilterRules[#,{Sysdim,Reshape,AddQ,RetractQ,SortQ,MoveOrigin,CenterAtOriginQ}]&/@{options,Options[CrystalPlot]}];
If[TrueQ[changed==$Failed],Throw[$Failed],{lattvecP,coordP,confP}=changed];
If[debug,Print["CrystalPlot :: CrystalChange returned structure ",changed]];

(*disambiguate different cases of 3D/2D: *)
d2Q=TrueQ[Length[lattvecP]==2&&Length/@lattvecP=={2,2}];
p3dQ=d2Q&&TrueQ[Pseudo3DQ/.options/.Options[CrystalPlot]];
If[debug&&d2Q,Print["CrystalPlot :: Check for pseudo-3D structure yielded ",p3dQ]];
If[p3dQ,lattvecP=Join[Join[#,{0}]&/@lattvecP,{{0,0,1}}];coordP=Join[#,{0}]&/@coordP;d2Q=False;If[debug,Print["CrystalPlot :: Pseudo-3D lattice vectors are ",lattvecP]];If[debug,Print["CrystalPlot :: Pseudo-3D atom coordinates are ",coordP]]];
If[debug,Print["CrystalPlot :: Check for 2D structure yielded ",d2Q]];

(*system dimensions / periodic repetitions: *)
sysdim=Sysdim/.options/.Options[CrystalPlot];
sysdim=Switch[sysdim,{_Integer,_Integer,_Integer},Abs[sysdim],{_Integer,_Integer},Abs[Join[sysdim,{1}]],{_Integer}|_Integer,Flatten[Abs[{sysdim,sysdim,sysdim}]],_,{1,1,1}];
If[debug,Print["CrystalPlot :: Option value for Sysdim resolved to ",sysdim]];

(*atom colours: *)
atomcol=Flatten[{AtomCol/.options/.Options[CrystalPlot]}];
(*recognize gradient colour schemes: *)
atomcol=Flatten[atomcol/.(#->ColorData[#]/@Round[Mod[Range[.1,4,.4],1.05],.1]&/@ColorData["Gradients"])];
(*recognize indexed colour schemes: *)
If[MatchQ[atomcol,{_Integer}],atomcol=Flatten[atomcol/.(#->ColorData[#,"ColorList"]&/@ColorData["Indexed"])]];
(*recognize special named colour schemes: *)
atomcol=Flatten[atomcol/."ReverseOxide"->Quiet[Reverse["Oxide"]]/.{"Oxide"|"oxide"->{RGBColor[.4,.45,.45],RGBColor[.8,.2,.2]},"TernaryOxide"->{RGBColor[.4,.4,.4],RGBColor[.15,.6,.6],RGBColor[.8,.2,.2]}}];
(*safety net: *)
atomcol=Select[atomcol,(ColorQ[#]||MatchQ[#,_Directive]&)];If[TrueQ[atomcol=={}],atomcol={White}];
(*make sure the list is long enough: *)
If[Length[atomcol]<Max[confP],atomcol=PadRight[atomcol,Max[confP],atomcol[[-1]]]];
If[debug,Print["CrystalPlot :: Option value for AtomCol resolved to ",atomcol]];

(*atomic radii: *)
radii=Select[Flatten[{AtomRad/.options/.Options[CrystalPlot]}],NumericQ];
If[TrueQ[radii=={}],radii={.5}];
If[Length[radii]<Max[confP],radii=PadRight[radii,Max[confP],radii[[-1]]]];
If[debug,Print["CrystalPlot :: Option value for AtomRad resolved to ",radii]];

(*specularity setting: *)
spec=With[{bs=Cases[BaseStyle/.options/.BaseStyle->{Specularity[Gray,100]},Specularity[__],Infinity]},If[TrueQ[bs=={}],Specularity[Gray,100],bs[[1]]]];
If[debug,Print["CrystalPlot :: Plot specularity determined as ",spec]];

(*atoms: *)
atomfunc=AtomFunction/.options/.Options[CrystalPlot];
If[!MatchQ[atomfunc,_Function],atomfunc=(Ball[#,#2]&)];
If[debug,Print["CrystalPlot :: Option value for AtomFunction resolved to ",atomfunc]];
atoms=Tooltip[Flatten[{atomcol[[confP[[#]]]],atomfunc[coordP[[#]].lattvecP,radii[[confP[[#]]]],atomcol[[confP[[#]]]],confP[[#]],#]}],#]&/@Range[Length[confP]];

(*lattice planes: *)
If[p3dQ||d2Q,
oneplane[{h_,k_,l___},dist_]:=Cases[ContourPlot[{h,k}.{x,y}==dist,{x,0,sysdim[[1]]},{y,0,sysdim[[2]]},
Evaluate[Sequence@@Join[FilterRules[options,Options[ContourPlot]],{Mesh->False,ContourLabels->False,ContourStyle->{Thick,Red}}]]],GraphicsComplex[x_,y__]:>GraphicsComplex[If[p3dQ,Join[#,{0}]&/@(x.lattvec[[{1,2},{1,2}]]),x.lattvec],y]],
oneplane[{h_,k_,l_},dist_]:=Cases[ContourPlot3D[{h,k,l}.{x,y,z}==dist,{x,0,sysdim[[1]]},{y,0,sysdim[[2]]},{z,0,sysdim[[3]]},
Evaluate[Sequence@@Join[FilterRules[options,Options[ContourPlot3D]],{Mesh->False,BoundaryStyle->None,ContourStyle->{Red,Opacity[.5]}}]]],GraphicsComplex[x_,y__]:>GraphicsComplex[x.lattvec,y]]
];
planes=oneplane@@@(LatticePlanes/.options/.Options[CrystalPlot]);

(*polyhedra: *)
polys=FilterRules[options,PolyMode[_]];
polys=If[TrueQ[polys=={}],{},polys[[All,1,1]]];
polys=If[d2Q||TrueQ[polys=={}],{},(If[debug,Print["CrystalPlot :: Calling function PolyPlot."]];PolyPlot[coordP.lattvec,confP,#,atomcol,options])&/@polys];

(*additional cell outlines: *)
addlines=CellLinesAdd/.options/.FilterRules[Options[CrystalPlot],CellLinesAdd];
If[!TrueQ[addlines=={}],
addlines=If[TrueQ[addlines[[1]]=="multi"],addlines[[2;;]],{addlines}];
If[TrueQ[Length[addlines[[#]]]==1]||MatchQ[addlines[[#,2]],_Rule],addlines[[#]]=Insert[addlines[[#]],If[d2Q,{0,0},{0,0,0}],2]]&/@Range[Length[addlines]];
addlineorigin=If[MatchQ[#,_Integer]&&#<=Length[confP],coordP[[#]].lattvec,#.lattvec]&/@addlines[[All,2]];
If[debug,Print["CrystalPlot :: Calling function LinePlot."]];
addlines=Translate[LinePlot[CrystalChange[addlines[[#,1]],Acell->0],d2Q,p3dQ,Sysdim/.addlines[[#,3;;]]/.Sysdim->sysdim,addlines[[#,3;;]]],addlineorigin[[#]]]&/@Range[Length[addlines]];
];

(*paste button: *)
supercell=If[TrueQ[ButtonQ/.options/.Options[CrystalPlot]],Epilog->{Epilog/.options/.Epilog->{},
Inset[EventHandler[Button["Paste supercell data",ImageSize->All,FrameMargins->{{20,20},{Automatic,Automatic}},Background->ColorData["Legacy","Gainsboro"]],
"MouseClicked":>(SelectionMove[ButtonNotebook[],After,ButtonCell];NotebookWrite[ButtonNotebook[],ToBoxes[CrystalChange[lattvec,coord,conf,FilterRules[options,Options[CrystalChange]]]]]),
PassEventsDown->Automatic,PassEventsUp->True],{Center,Bottom},{Center,Bottom}]},{}];

(*return the plot: *)
If[debug,Print["CrystalPlot :: Calling function LinePlot."]];
lines=LinePlot[lattvecP,d2Q,p3dQ,sysdim,options];
If[debug,Print["CrystalPlot :: Calling function BondPlot."]];
bonds=BondPlot[lattvecP,coordP,confP,d2Q,spec,atomcol,options];
content=Join[lines,addlines,planes,bonds,atoms,polys];
theplot=If[d2Q,Graphics[content,supercell,FilterRules[options,Options[Graphics]]],
Graphics3D[content,supercell,BaseStyle->Join[{spec},Flatten[{BaseStyle/.options/.BaseStyle->{}}]],FilterRules[options,Options[Graphics3D]],Boxed->False,SphericalRegion->True,Lighting->"Neutral"]];

If[debug,Print["CrystalPlot :: Exiting function CrystalPlot and returning to calling function or to user."]];
theplot
]];


(*molecules can be plotted, but lattice-related options have to be reset: *)
CrystalPlot[coord_/;MatchQ[coord,{_List..}],conf_/;MatchQ[conf,{_Integer..}],options___]:=Module[{plot},
If[debug,Print["CrystalPlot :: Entering function CrystalPlot[coord,conf,options] with the following input values:"]];
If[debug,Print["CrystalPlot :: \tcoord = ",coord]];
If[debug,Print["CrystalPlot :: \tconf = ",conf]];
If[debug,Print["CrystalPlot :: \toptions = ",Flatten[{options}]]];
If[debug,Print["CrystalPlot :: Calling new instance of function CrystalPlot with different input."]];
plot=CrystalPlot[IdentityMatrix[Length[coord[[1]]]],coord,conf,
{Reshape->IdentityMatrix[3],Sysdim->{1,1,1},CenterAtOriginQ->False,BondsExtendQ->False,MoveOrigin->False,CellLineStyle->False,AddQ->False,RetractQ->False,ButtonQ->False,options}];
If[debug,Print["CrystalPlot :: Exiting function CrystalPlot and returning to calling function or to user."]];
plot
];


(*lattice vectors (cell without atoms) can also be used, but require a dummy atom of radius 0 and disabling of bonds: *)
CrystalPlot[lattvec_List,options___]:=Module[{plot},
If[debug,Print["CrystalPlot :: Entering function CrystalPlot[lattvec,options] with the following input values:"]];
If[debug,Print["CrystalPlot :: \tlattvec = ",lattvec]];
If[debug,Print["CrystalPlot :: \toptions = ",Flatten[{options}]]];
If[debug,Print["CrystalPlot :: Calling new instance of function CrystalPlot with different input."]];
plot=CrystalPlot[lattvec,{If[MatchQ[lattvec,{{_,_},{_,_}}|{{_,_},{{_,_},{_,_}}}|{{_,_},{_}}],{0,0},{0,0,0}]},{1},BondStyle->False,AtomRad->0,options];
If[debug,Print["CrystalPlot :: Exiting function CrystalPlot and returning to calling function or to user."]];
plot
];
