(* ::Package:: *)

(*
Copyright (c) 2016 Bianca Eifert and Christian Heiliger, distributed under the MIT license
This file is part of Crystallica, do NOT load it separately.
Information about the Crystallica application can be found one level up from here.
*)
If[!TrueQ[$Context=="Crystallica`Private`"],Print["This package needs to be called from within Crystallica, aborting."];Abort[]];


LinePlot[lattvecP_,d2Q_,p3dQ_,sysdim_,rawoptions___]:=
Module[{options,style,col,rad,base,rot,flatq,lineobj,tubearrow,arrowobj,lineplot,arrowplot},

(*debugging: *)
If[debug,Print["LinePlot :: Entering function LinePlot[lattvecP,d2Q,p3dQ,sysdim,rawoptions] with the following input values:"]];
If[debug,Print["LinePlot :: \tlattvecP = ",lattvecP]];
If[debug,Print["LinePlot :: \td2Q = ",d2Q]];
If[debug,Print["LinePlot :: \tp3dQ = ",p3dQ]];
If[debug,Print["LinePlot :: \tsysdim = ",sysdim]];
If[debug,Print["LinePlot :: \trawoptions = ",rawoptions]];

options=Flatten[{rawoptions}];

(*parsing layout options: *)
(*overall style: *)
style=(CellLineStyle/.options/.Options[CrystalPlot])/.True->1/.False|None->0;
If[MatchQ[style,_Integer],style={style,style}];
If[!MatchQ[style,{_Integer,_Integer}],style={0,0}];
If[debug,Print["LinePlot :: Option value for CellLineStyle resolved to ",style]];
(*colours: *)
col=CellLineCol/.options/.Options[CrystalPlot];
col=Switch[col,{_,_},col,{_},{col[[1]],col[[1]]},_,{col,col}];
If[debug,Print["LinePlot :: Option value for CellLineCol resolved to ",col]];
(*radii: *)
rad=CellLineRad/.options/.Options[CrystalPlot];
rad=Switch[rad,{_,_},rad,{_},{rad[[1]],rad[[1]]},_,{rad,rad}];
If[!MemberQ[{0,0.},rad[[2]]],rad[[2]]=rad[[2]]+.001];
If[debug,Print["LinePlot :: Option value for CellLineRad resolved to ",rad]];

(*geometry and objects to use as lines and arrows: *)
base={{1,0,0},{1,1,0},{0,1,0},{-1,0,0},{-1,-1,0},{0,-1,0},{1,0,0}};
rot=RotationMatrix[120Degree,{0,0,1}];
flatq=CellLinesFlatQ/.options/.Options[CrystalPlot];
flatq=TrueQ/@Switch[flatq,{_,_},flatq,{_},{flatq[[1]],flatq[[1]]},_,{flatq,flatq}];
If[debug,Print["LinePlot :: Option value for CellLinesFlatQ resolved to ",flatq]];
lineobj[pos_]:=If[d2Q||flatq[[1]],{col[[1]],Thickness[.5*rad[[1]]],Line[pos]},{col[[1]],Tube[pos,rad[[1]]]}];
tubearrow[{tail_,head_}]:=With[{scale=.5*Sqrt[Mean[Norm/@lattvecP]*rad[[2]]]},Tube[{tail,head-4*scale*Normalize[head-tail],head-4*scale*Normalize[head-tail],head},{rad[[2]],rad[[2]],scale,0}]];
arrowobj[pos_]:=If[d2Q||flatq[[2]],{col[[2]],Thickness[.5*rad[[1]]],Arrowheads[5*rad[[2]]],Arrow[pos]},{col[[2]],tubearrow[pos]}];

(*cell outlines: *)
lineplot=Which[p3dQ,Switch[style[[1]],
(*hexagonal*)-2,lineobj[base.lattvecP],
(*unit cell*)1,lineobj[{{0,0,0},{1,0,0},{1,1,0},{0,1,0},{0,0,0}}.lattvecP],
(*periodic*)2,lineobj[#.lattvecP]&/@Join[{{0,#,0},{sysdim[[1]],#,0}}&/@Range[0,sysdim[[2]]],{{#,0,0},{#,sysdim[[2]],0}}&/@Range[0,sysdim[[1]]]],
(*supercell*)3,lineobj[{{0,0,0},{sysdim[[1]],0,0},{sysdim[[1]],sysdim[[2]],0},{0,sysdim[[2]],0},{0,0,0}}.lattvecP],
_,{}],d2Q,Switch[style[[1]],
(*hexagonal*)-2,lineobj[base[[All,1;;2]].lattvecP],
(*unit cell*)1,lineobj[{{0,0},{1,0},{1,1},{0,1},{0,0}}.lattvecP],
(*periodic*)2,lineobj[#.lattvecP]&/@Join[{{0,#},{sysdim[[1]],#}}&/@Range[0,sysdim[[2]]],{{#,0},{#,sysdim[[2]]}}&/@Range[0,sysdim[[1]]]],
(*supercell*)3,lineobj[{{0,0},{sysdim[[1]],0},{sysdim[[1]],sysdim[[2]]},{0,sysdim[[2]]},{0,0}}.lattvecP],
_,{}],True,Switch[style[[1]],
(*hexagonal*)-2,lineobj[#.lattvecP]&/@{base,#+{0,0,1}&/@base,{{0,0,0},#}&/@{{1,0,0},{0,1,0},{-1,-1,0}},{{0,0,1},#}&/@{{1,0,1},{0,1,1},{-1,-1,1}},{{0,0,0},{0,0,1}},{#,#+{0,0,1}}&/@base},
(*unit cell*)1,lineobj[#.lattvecP]&/@{{{0,0,#},{1,0,#},{1,1,#},{0,1,#},{0,0,#}}&/@{0,1},{{0,0,#}&/@{0,1},{1,0,#}&/@{0,1},{1,1,#}&/@{0,1},{0,1,#}&/@{0,1}}},
(*periodic*)2,lineobj[#.lattvecP]&/@Flatten[{Table[{x,y,z},{x,0,sysdim[[1]]},{y,0,sysdim[[2]]},{z,{0,sysdim[[3]]}}],Table[{x,y,z},{y,0,sysdim[[2]]},{z,0,sysdim[[3]]},{x,{0,sysdim[[1]]}}],Table[{x,y,z},{z,0,sysdim[[3]]},{x,0,sysdim[[1]]},{y,{0,sysdim[[2]]}}]},2],
(*supercell*)3,lineobj[#.lattvecP]&/@(#.(sysdim*IdentityMatrix[3])&/@Join[{{0,0,#},{1,0,#},{1,1,#},{0,1,#},{0,0,#}}&/@{0,1},{{0,0,#}&/@{0,1},{1,0,#}&/@{0,1},{1,1,#}&/@{0,1},{0,1,#}&/@{0,1}}]),
_,{}]];

(*arrows indicating the lattice vectors: *)
arrowplot=Which[p3dQ,Switch[style[[2]],
(*hexagonal*)-2,arrowobj[{{0,0,0},#}]&/@{lattvecP[[1]],lattvecP[[2]],rot.lattvecP[[2]]},
(*unit cell*)1|2,arrowobj[{{0,0,0},#}]&/@lattvecP[[{1,2}]],
(*supercell*)3,arrowobj[{{0,0,0},#}]&/@(lattvecP[[{1,2}]]*sysdim[[1;;2]]),
_,{}],d2Q,Switch[style[[2]],
(*hexagonal*)-2,arrowobj[{{0,0},#}]&/@{lattvecP[[1]],lattvecP[[2]],(rot.Join[lattvecP[[2]],{0}])[[1;;2]]},
(*unit cell*)1|2,arrowobj[{{0,0},#}]&/@lattvecP,
(*supercell*)3,arrowobj[{{0,0},#}]&/@(lattvecP*sysdim[[1;;2]]),
_,{}],True,Switch[style[[2]],
(*hexagonal*)-2,arrowobj[{{0,0,0},#}]&/@{lattvecP[[1]],lattvecP[[2]],rot.lattvecP[[2]],lattvecP[[3]]},
(*unit cell*)1|2,arrowobj[{{0,0,0},#}]&/@lattvecP,
(*supercell*)3,arrowobj[{{0,0,0},#}]&/@(lattvecP*sysdim),
_,{}]];

If[debug,Print["LinePlot :: Exiting function LinePlot and returning to calling function."]];
{lineplot,arrowplot}
];
