(* ::Package:: *)

(*
Copyright (c) 2016 Bianca Eifert and Christian Heiliger, distributed under the MIT license
This file is part of Crystallica, do NOT load it separately.
Information about the Crystallica application can be found one level up from here.
*)
If[!TrueQ[$Context=="Crystallica`Private`"],Print["This package needs to be called from within Crystallica, aborting."];Abort[]];


PolyPlot[cartP_,confP_,cornercount_,atomcol_,options_]:=
Catch[Module[{modeoption,showmode,runrange,polyfind,poly,out,styledpolyplot},

(*debugging: *)
If[debug,Print["PolyPlot :: Entering function PolyPlot[cartP,confP,cornercount,atomcol,options] with the following input values:"]];
If[debug,Print["PolyPlot :: \tcartP = ",cartP]];
If[debug,Print["PolyPlot :: \tconfP = ",confP]];
If[debug,Print["PolyPlot :: \tcornercount = ",cornercount]];
If[debug,Print["PolyPlot :: \tatomcol = ",atomcol]];

(*unravel the various implicit defaults of the PolyMode option: *)
modeoption=Flatten[{PolyMode[cornercount]/.options/.PolyMode[cornercount]->{"Show"->False,"Tolerance"->.56,"Distance"->2.,"AllowMixed"->False}}];
modeoption=Switch[modeoption,{None}|{False}|{0},{"Show"->False},{True}|{All},{"Show"->All},_,modeoption];
If[debug,Print["PolyPlot :: Option value for PolyMode resolved to ",modeoption]];
showmode=("Show"/.modeoption/."Show"->False)/.None|0->False;
If[TrueQ[showmode==False],Throw[{}]];

(*atoms to be considered as potential centers of polyhedra: *)
runrange=Switch[showmode,
{"Types",{_Integer..}},Select[Range[Length[confP]],MemberQ[showmode[[2]],confP[[#]]]&],
{"Atoms",{_Integer..}},Select[showmode[[2]],#<=Length[confP]&],
_,Range[Length[confP]]];
If[debug,Print["PolyPlot :: Testing for polyhedra at atoms ",runrange]];

(*find corners of polyhedra centered at a given atom: *)
polyfind[index_]:=Module[{distances,bylength,cut,corners},
(*sort neighbours by distance: *)
distances={#,N[Norm[cartP[[index]]-cartP[[#]]]]}&/@Range[Length[cartP]];
(*find distances that have the correct number of neighbours for the polyhedron: *)
bylength=Gather[distances,Norm[#1[[2]]-#2[[2]]]<=("Tolerance"/.modeoption/."Tolerance"->.56)&];
If[!TrueQ["AllowMixed"/.modeoption/."AllowMixed"->False],Do[(bylength[[ii]]=Gather[bylength[[ii]],(confP[[#1[[1]]]]==confP[[#2[[1]]]])&];),{ii,1,Length[bylength]}];bylength=Flatten[bylength,1]];
bylength=Select[bylength,Length[#]==cornercount&];
(*apply distance cut-off, i.e. maximum size of polyhedron: *)
cut=Select[bylength,Max[Transpose[#][[2]]]<=("Distance"/.modeoption/."Distance"->2.)&];
corners=Table[#[[1]]&/@cut[[ii]],{ii,1,Length[cut]}];
Flatten[Select[corners,(And@@Table[#[[ii]]<=Length[cartP],{ii,1,cornercount}])&],1]];

(*auxiliary function to construct the actual polyhedra from their corners: *)
poly[corners_]:=With[{construct=ConvexHullMesh[corners,Graphics`Mesh`FlatFaces->False]},GraphicsComplex[MeshCoordinates[construct],MeshCells[construct,2]]];

(*gather results and add styling: *)
out=Select[{#,polyfind[#]}&/@runrange,!TrueQ[#[[2]]=={}]&];
If[debug,Print["PolyPlot :: Found polyhedra ",out]];
styledpolyplot={atomcol[[confP[[#[[1]]]]]],PolyStyle[cornercount]/.options/.PolyStyle[cornercount]->Directive[Opacity[.5],EdgeForm[None]],poly[cartP[[#[[2]]]]]}&/@out;
If[debug,Print["PolyPlot :: Exiting function PolyPlot and returning to calling function."]];
styledpolyplot
]];
