(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14820,        380]
NotebookOptionsPosition[     13908,        343]
NotebookOutlinePosition[     14303,        360]
CellTagsIndexPosition[     14260,        357]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The Crystallica application", "Section"],

Cell[CellGroupData[{

Cell["Author and license", "Subsection"],

Cell[CellGroupData[{

Cell["Copyright (c) 2016 Bianca Eifert and Christian Heiliger", "Item"],

Cell["\<\
Crystallica was developed within the research group of Prof. Heiliger \
(Theoretical Solid State Physics, Institute for Theoretical Physics, Justus \
Liebig University Giessen, Germany).\
\>", "Item"],

Cell[TextData[{
 "This application is distributed under ",
 ButtonBox["the MIT license",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://opensource.org/licenses/MIT"], None},
  ButtonNote->"https://opensource.org/licenses/MIT"],
 ". You can find the license text in License.txt, which you should have \
received along with the rest of the application."
}], "Item"],

Cell["\<\
The Crystallica application is no longer in active development by the \
original authors. Please feel free to set up your own project on a software \
collaboration site of your choice.\
\>", "Item"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installation and finding help", "Subsection"],

Cell["1. Evaluate this to open the installation directory:", "Text"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"$UserBaseDirectory", ",", "\"\<Applications\>\""}], "}"}], "]"}],
   "]"}]], "Input"],

Cell[TextData[{
 "2. Move or copy the entire \[OpenCurlyDoubleQuote]Crystallica\
\[CloseCurlyDoubleQuote] folder into the directory you just opened.\n3. \
Re-start the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel.\n4a. Read the Documentation by ",
 ButtonBox["clicking here",
  BaseStyle->"Link",
  ButtonData->"paclet:Crystallica/guides/Crystallica"],
 " (link only works after you\[CloseCurlyQuote]ve completed steps 2 and 3).\n\
4b. You can also open the Documentation Center via F1 and enter Crystallica \
(or a function or option from Crystallica) as a search term."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["For developers: Building the Documentation", "Subsection"],

Cell[TextData[{
 "Since standardized Documentation building is not exactly straight-forward \
yet, here is a quick outline of the method used for the present version of \
Crystallica. (It may break a few conventions. Sorry.)\n\nThe procedure and \
code were taken from jmlopez\[CloseCurlyQuote] excellent work in this SO \
thread: ",
 ButtonBox["http://stackoverflow.com/questions/6574710/integrating-notebooks-\
to-mathematicas-documentation-center",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://stackoverflow.com/questions/6574710/integrating-notebooks-to-\
mathematicas-documentation-center"], None},
  ButtonNote->
   "http://stackoverflow.com/questions/6574710/integrating-notebooks-to-\
mathematicas-documentation-center"],
 "\n\nThe editable version of the Documentation notebooks can be found in \
\[OpenCurlyDoubleQuote]Documentation_Source\[CloseCurlyDoubleQuote]. After \
you\[CloseCurlyQuote]ve made changes to these notebooks, delete the \
\[OpenCurlyDoubleQuote]Documentation\[CloseCurlyDoubleQuote] folder and \
convert the new documentation by loading the definition below and then \
evaluating makedoc[]."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makedoc", "[", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rootpath", ",", "appname", ",", "refsourcepath", ",", 
       "guidesourcepath", ",", "refpath", ",", "guidepath", ",", 
       "RefPageConvert", ",", "GuidePageConvert", ",", "ind"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"rootpath", "=", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "$UserBaseDirectory", ",", "\"\<Applications\>\"", ",", 
          "\"\<Crystallica\>\""}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"appname", "=", "\"\<Crystallica\>\""}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Needs", "[", 
       RowBox[{"appname", "<>", "\"\<`\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"refsourcepath", "=", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "rootpath", ",", "\"\<DocumentationSource\>\"", ",", 
          "\"\<English\>\"", ",", "\"\<ReferencePages\>\"", ",", 
          "\"\<Symbols\>\""}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"guidesourcepath", "=", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "rootpath", ",", "\"\<DocumentationSource\>\"", ",", 
          "\"\<English\>\"", ",", "\"\<Guides\>\""}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"refpath", "=", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "rootpath", ",", "\"\<Documentation\>\"", ",", "\"\<English\>\"", 
          ",", "\"\<ReferencePages\>\"", ",", "\"\<Symbols\>\""}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"guidepath", "=", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "rootpath", ",", "\"\<Documentation\>\"", ",", "\"\<English\>\"", 
          ",", "\"\<Guides\>\""}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"rootpath", ",", "\"\<Documentation\>\""}], "}"}], "]"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "rootpath", ",", "\"\<Documentation\>\"", ",", "\"\<English\>\""}], 
         "}"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", "guidepath", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
         "rootpath", ",", "\"\<Documentation\>\"", ",", "\"\<English\>\"", 
          ",", "\"\<ReferencePages\>\""}], "}"}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", "refpath", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"RefPageConvert", "[", "symbol_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", "=", 
           RowBox[{"NotebookOpen", "[", 
            RowBox[{"FileNameJoin", "[", 
             RowBox[{"{", 
              RowBox[{"refsourcepath", ",", 
               RowBox[{"symbol", "<>", "\"\<.nb\>\""}]}], "}"}], "]"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"NotebookSave", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"FileNameJoin", "[", 
             RowBox[{"{", 
              RowBox[{"refpath", ",", 
               RowBox[{"symbol", "<>", "\"\<.nb\>\""}]}], "}"}], "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"SetOptions", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"TaggingRules", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<ModificationHighlight\>\"", "->", "False"}], ",", 
               RowBox[{"\"\<Metadata\>\"", "->", 
                RowBox[{"{", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"\"\<context\>\"", "\[Rule]", 
                   RowBox[{"appname", "<>", "\"\<`\>\""}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<keywords\>\"", "->", 
                   RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<index\>\"", "->", "True"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<label\>\"", "->", 
                   RowBox[{"appname", "<>", "\"\< Package Symbol\>\""}]}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<language\>\"", "->", "\"\<en\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<paclet\>\"", "->", 
                   RowBox[{"appname", "<>", "\"\< Package\>\""}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<status\>\"", "->", "\"\<\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<summary\>\"", "->", 
                   RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"Symbol", "[", "symbol", "]"}], "]"}], "::", 
                    "usage"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<synonyms\>\"", "->", 
                   RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<title\>\"", "->", "symbol"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<type\>\"", "->", "\"\<Symbol\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<uri\>\"", "->", 
                   RowBox[{
                   "appname", "<>", "\"\</ref/\>\"", "<>", "symbol"}]}]}], 
                 "\[IndentingNewLine]", "}"}]}], ",", 
               RowBox[{"\"\<SearchTextTranslated\>\"", "->", "\"\<\>\""}]}], 
              "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"SetOptions", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"Saveable", "->", "False"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SetOptions", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"StyleDefinitions", "->", 
             RowBox[{"FrontEnd`FileName", "[", 
              RowBox[{
               RowBox[{"{", "\"\<Wolfram\>\"", "}"}], ",", 
               "\"\<Reference.nb\>\""}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"NotebookSave", "[", "nb", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"NotebookClose", "[", "nb", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"RefPageConvert", "/@", 
       RowBox[{"FileBaseName", "/@", 
        RowBox[{"FileNames", "[", 
         RowBox[{"\"\<*.nb\>\"", ",", "refsourcepath"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"GuidePageConvert", "[", "name_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", "=", 
           RowBox[{"NotebookOpen", "[", 
            RowBox[{"FileNameJoin", "[", 
             RowBox[{"{", 
              RowBox[{"guidesourcepath", ",", 
               RowBox[{"name", "<>", "\"\<.nb\>\""}]}], "}"}], "]"}], "]"}]}],
           "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"NotebookSave", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"FileNameJoin", "[", 
             RowBox[{"{", 
              RowBox[{"guidepath", ",", 
               RowBox[{"name", "<>", "\"\<.nb\>\""}]}], "}"}], "]"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"SetOptions", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"Saveable", "->", "False"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SetOptions", "[", 
           RowBox[{"nb", ",", 
            RowBox[{"StyleDefinitions", "->", 
             RowBox[{"FrontEnd`FileName", "[", 
              RowBox[{
               RowBox[{"{", "\"\<Wolfram\>\"", "}"}], ",", 
               "\"\<Reference.nb\>\""}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"NotebookSave", "[", "nb", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"NotebookClose", "[", "nb", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"GuidePageConvert", "/@", 
       RowBox[{"FileBaseName", "/@", 
        RowBox[{"FileNames", "[", 
         RowBox[{"\"\<*.nb\>\"", ",", "guidesourcepath"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Get", "[", "\"\<DocumentationSearch`\>\"", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ind", "=", 
       RowBox[{"DocumentationSearch`NewDocumentationNotebookIndexer", "[", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{
          "rootpath", ",", "\"\<Documentation\>\"", ",", "\"\<English\>\"", 
           ",", "\"\<Index\>\""}], "}"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"DocumentationSearch`AddDocumentationNotebook", "[", 
         RowBox[{"ind", ",", "#"}], "]"}], "&"}], "/@", 
       RowBox[{"FileNames", "[", 
        RowBox[{"\"\<*.nb\>\"", ",", "guidepath"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"DocumentationSearch`AddDocumentationNotebook", "[", 
         RowBox[{"ind", ",", "#"}], "]"}], "&"}], "/@", 
       RowBox[{"FileNames", "[", 
        RowBox[{"\"\<*.nb\>\"", ",", "refpath"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
      "DocumentationSearch`CloseDocumentationNotebookIndexer", "[", "ind", 
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1903, 979},
WindowMargins->{{Automatic, 0}, {Automatic, 1}},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 46, 0, 70, "Section"],
Cell[CellGroupData[{
Cell[650, 26, 40, 0, 49, "Subsection"],
Cell[CellGroupData[{
Cell[715, 30, 71, 0, 29, "Item"],
Cell[789, 32, 210, 4, 29, "Item"],
Cell[1002, 38, 375, 9, 29, "Item"],
Cell[1380, 49, 208, 4, 29, "Item"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[1637, 59, 51, 0, 49, "Subsection"],
Cell[1691, 61, 68, 0, 30, "Text"],
Cell[1762, 63, 190, 5, 31, "Input"],
Cell[1955, 70, 600, 13, 87, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2592, 88, 64, 0, 49, "Subsection"],
Cell[2659, 90, 1147, 21, 106, "Text"],
Cell[3809, 113, 10071, 226, 1125, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
