(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    241979,       4438]
NotebookOptionsPosition[    236737,       4346]
NotebookOutlinePosition[    237136,       4361]
CellTagsIndexPosition[    237093,       4358]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"omega1", "=", "0.5"}], "\[IndentingNewLine]", 
 RowBox[{"omega2", "=", "0.7"}], "\[IndentingNewLine]", 
 RowBox[{"omega3", "=", "1"}], "\[IndentingNewLine]", 
 RowBox[{"omega4", "=", "1.2"}], "\[IndentingNewLine]", 
 RowBox[{"m", "=", "1."}], "\[IndentingNewLine]", 
 RowBox[{"t2", "=", "15."}]}], "Input",
 CellChangeTimes->{{3.802081594224756*^9, 3.8020816432228966`*^9}, {
  3.802081741489421*^9, 3.802081749664852*^9}, {3.8021606371910124`*^9, 
  3.802160641647972*^9}, {3.8021615565032682`*^9, 3.8021615577140737`*^9}, {
  3.8021899267505665`*^9, 3.8021899486024866`*^9}, {3.8021902032283764`*^9, 
  3.802190204984538*^9}},ExpressionUUID->"380dde66-1fb3-42e2-bfb6-\
a4db595e4041"],

Cell[BoxData["0.5`"], "Output",
 CellChangeTimes->{
  3.802082358405611*^9, {3.802160632740058*^9, 3.8021606444578395`*^9}, 
   3.8021613201465063`*^9, 3.8021614361175823`*^9, 3.802161558811801*^9, 
   3.8021633658853025`*^9, 3.802189951827626*^9, 3.802190206979864*^9, 
   3.802279094823258*^9, 
   3.811931360006013*^9},ExpressionUUID->"ede01f33-aa0f-49f9-8d88-\
4696cfe84f5d"],

Cell[BoxData["0.7`"], "Output",
 CellChangeTimes->{
  3.802082358405611*^9, {3.802160632740058*^9, 3.8021606444578395`*^9}, 
   3.8021613201465063`*^9, 3.8021614361175823`*^9, 3.802161558811801*^9, 
   3.8021633658853025`*^9, 3.802189951827626*^9, 3.802190206979864*^9, 
   3.802279094823258*^9, 
   3.8119313600080147`*^9},ExpressionUUID->"b57b775d-2a9f-4529-beab-\
1b8b3607d769"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.802082358405611*^9, {3.802160632740058*^9, 3.8021606444578395`*^9}, 
   3.8021613201465063`*^9, 3.8021614361175823`*^9, 3.802161558811801*^9, 
   3.8021633658853025`*^9, 3.802189951827626*^9, 3.802190206979864*^9, 
   3.802279094823258*^9, 
   3.8119313600100155`*^9},ExpressionUUID->"db5a4e46-f0e8-48ec-b6bf-\
fb91caeae026"],

Cell[BoxData["1.2`"], "Output",
 CellChangeTimes->{
  3.802082358405611*^9, {3.802160632740058*^9, 3.8021606444578395`*^9}, 
   3.8021613201465063`*^9, 3.8021614361175823`*^9, 3.802161558811801*^9, 
   3.8021633658853025`*^9, 3.802189951827626*^9, 3.802190206979864*^9, 
   3.802279094823258*^9, 
   3.8119313600120163`*^9},ExpressionUUID->"adbf0ac6-d2fa-415b-9382-\
2d3b5eaebe54"],

Cell[BoxData["1.`"], "Output",
 CellChangeTimes->{
  3.802082358405611*^9, {3.802160632740058*^9, 3.8021606444578395`*^9}, 
   3.8021613201465063`*^9, 3.8021614361175823`*^9, 3.802161558811801*^9, 
   3.8021633658853025`*^9, 3.802189951827626*^9, 3.802190206979864*^9, 
   3.802279094823258*^9, 
   3.811931360014018*^9},ExpressionUUID->"17cec57c-9818-459c-a2a6-\
5829661105ad"],

Cell[BoxData["15.`"], "Output",
 CellChangeTimes->{
  3.802082358405611*^9, {3.802160632740058*^9, 3.8021606444578395`*^9}, 
   3.8021613201465063`*^9, 3.8021614361175823`*^9, 3.802161558811801*^9, 
   3.8021633658853025`*^9, 3.802189951827626*^9, 3.802190206979864*^9, 
   3.802279094823258*^9, 
   3.8119313600150185`*^9},ExpressionUUID->"977ced0a-840a-4047-848f-\
b4e070549e6b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Om1", "=", 
  RowBox[{"omega1", "+", 
   RowBox[{
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"t2", "-", "x"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"omega2", "-", "omega1"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Om2", "=", 
  RowBox[{"omega3", "+", 
   RowBox[{
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"t2", "-", "x"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"omega4", "-", "omega3"}], ")"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.8020817736067324`*^9, 3.8020817874941816`*^9}, {
  3.802081872291095*^9, 3.8020819739133196`*^9}, {3.802082189976367*^9, 
  3.802082191300245*^9}},ExpressionUUID->"5355d054-f71b-4e13-af48-\
bfb25b7ba46d"],

Cell[BoxData[
 RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.19999999999999996`", " ", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"15.`", "\[VeryThinSpace]", "-", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.802190208263715*^9, 3.8022790964233212`*^9, 
  3.811931360956649*^9},ExpressionUUID->"761379d8-60dc-4dc1-ad72-\
7c3084d70681"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"0.19999999999999996`", " ", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"15.`", "\[VeryThinSpace]", "-", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.802190208263715*^9, 3.8022790964233212`*^9, 
  3.811931360959651*^9},ExpressionUUID->"54a1a006-d97d-4e5d-9908-\
1a6f985a3dbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Om1", "^", "2"}], ",", 
     RowBox[{"Om2", "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.802190117203292*^9, 3.802190136337989*^9}, {
  3.802190168207135*^9, 
  3.802190173041345*^9}},ExpressionUUID->"4bedbbb8-82fb-4e82-8612-\
57e167c3b6f7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQPbcuic0wZbVddP+hrxox9+3Zbz9Sfyt/0x7GX3hq
fuFr+Zdw/rr1nbdz9H7B+en2F2e+KWJ2gPHznmo+3rKOE87nUmxRv28hAOf3
CZzWWpggDOcn3Q7Zz3xGDM4vPNqSlK8uBedvLOAJlvCUhfMXVme/MghXgPOb
5v8J/PJGEc5nuPzAYU+VMpyvVpJWEaKlCuc/+To9jHuvGpzv9TSrdlKhBpzv
92SCtpycFpz/6nBSw4m12nB+T5bM+dY2HThfT/CarHO8LkL9t0i3axMR/KV3
7uZlHkHwm87LM2++i+AnHEqc/ucbgu938LRmxU8EHwD8oM0G
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQB2IQvcnO5Fo7m54DAxhcsG+zmHzsMyeCb7d1sbabAIK/
dt2Rr69kEHyZFU/392si+JOL3wps60Pwuey/Jt75jOCf6QnVEDyvD+e7v436
rhRqAOffOJTCGKVjCOdv7TgSp/AVwU9jLX1w7pwRnJ9cVL2VZ5YxnK+frn3O
J9EEzj8vpMNdamkK5+9e1zRbh9kMzq9m1Ao4cxfB57pT5ZG3xRzOf7pMccr8
Ggs4f4qGJMvOUEs4f8KstOOJClZwftSU2HM8zxH8Hy5Lf87fZw3nP37qVHGo
3QbOX2RrKH020RYRvq2lgum6dnB+e2iyN/NXBN/0zsKV7Wft4fwZmrPXnvV2
gPPrD/TO8N6J4PtKhy49peII5zvmHY8W7ETw58skqZz5iuCrHF4+zS/aCeE/
3UNal/Yh+GmfWS6e1HKG85M2flLo7EfwJ1zi6T1yHMHf91nt5///CD4Ao2Wx
5g==
      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQPbcuic0wZbUd1/XFBbZc3+3Zbz9Sfyt/0x7GX3hq
fuFr+Zdw/rr1nbdz9H7B+en2F2e+KWJ2gPHznmo+3rKOE87nUmxRv28hAOf3
CZzWWpggDOcn3Q7Zz3xGDM4vPNqSlK8uBedvLOAJlvCUhfMXVme/MghXgPOb
5v8J/PJGEc5nuPzAYU+VMpyvVpJWEaKlCuc/+To9jHuvGpzv9TSrdlKhBpzv
92SCtpycFpz/6nBSw4m12nB+T5bM+dY2HThfT/CarHO8LkL9t0i3axMR/KV3
7uZlHkHwm87LM2++i+AnHEqc/ucbgu938LRmxU8EHwDhX7ey
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQB2IQvcnO5Fo7m54DAxh8sG+zmHzsMyeCb7d1sbabAIK/
dt2Rr69kEHyZFU/392si+JOL3wps60Pwuey/Jt75jOCf6QnVEDyvD+e7v436
rhRqAOffOJTCGKVjCOdv7TgSp/AVwU9jLX1w7pwRnJ9cVL2VZ5YxnK+frn3O
J9EEzj8vpMNdamkK5+9e1zRbh9kMzq9m1Ao4cxfB57pT5ZG3xRzOf7pMccr8
Ggs4f4qGJMvOUEs4f8KstOOJClZwftSU2HM8zxH8Hy5Lf87fZw3nP37qVHGo
3QbOX2RrKH020RYRvq2lgum6dnB+e2iyN/NXBN/0zsKV7Wft4fwZmrPXnvV2
gPPrD/TO8N6J4PtKhy49peII5zvmHY8W7ETw58skqZz5iuCrHF4+zS/aCeE/
3UNal/Yh+GmfWS6e1HKG85M2flLo7EfwJ1zi6T1yHMHf91nt5///CD4Ad3+2
xg==
      "]]}, {}}, {{}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.25},
  PlotRange->{{0, 40}, {0.25, 1.44}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.8020823597615175`*^9, 3.802160645956832*^9, 
  3.8021614371372595`*^9, 3.8021615602497587`*^9, 3.8021633669710236`*^9, 
  3.802189953558775*^9, 3.8021901372896223`*^9, 3.8021901742271285`*^9, 
  3.802190209526552*^9, 3.802279098053401*^9, 
  3.811931362605756*^9},ExpressionUUID->"0daaa6db-6754-4e8b-9d15-\
8ec3a711c006"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DOm1", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"DiracDelta", "[", 
     RowBox[{"t2", "-", "x"}], "]"}]}], "*", 
   RowBox[{"(", 
    RowBox[{"omega2", "-", "omega1"}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"DOm2", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"DiracDelta", "[", 
     RowBox[{"t2", "-", "x"}], "]"}]}], "*", 
   RowBox[{"(", 
    RowBox[{"omega4", "-", "omega3"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.802082050065943*^9, 3.8020821336894298`*^9}, {
  3.802082193035396*^9, 
  3.802082194117114*^9}},ExpressionUUID->"c34aac98-f835-4838-b4dc-\
2d138f529531"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.19999999999999996`"}], " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{"15.`", "\[VeryThinSpace]", "-", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{3.8020823620680437`*^9, 3.802160647840083*^9, 
  3.802161438027852*^9, 3.802161561025267*^9, 3.8021633677435365`*^9, 
  3.80218995546904*^9, 3.8021902125805793`*^9, 3.8022790993172398`*^9, 
  3.8119313643088937`*^9},ExpressionUUID->"e9b820d9-bb7e-43c7-b41c-\
85375354fc51"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.19999999999999996`"}], " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{"15.`", "\[VeryThinSpace]", "-", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{3.8020823620680437`*^9, 3.802160647840083*^9, 
  3.802161438027852*^9, 3.802161561025267*^9, 3.8021633677435365`*^9, 
  3.80218995546904*^9, 3.8021902125805793`*^9, 3.8022790993172398`*^9, 
  3.8119313643119016`*^9},ExpressionUUID->"8b635b23-9bf6-40da-8578-\
d48be07fa0f0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "y", "]"}]], "Input",
 CellChangeTimes->{{3.802082559421054*^9, 
  3.8020825646805468`*^9}},ExpressionUUID->"19ee5ad5-b020-4e2a-a9a4-\
609fb92e257c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PUsolution01", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "x", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"omega1", "+", 
              RowBox[{
               RowBox[{"HeavisideTheta", "[", 
                RowBox[{"t2", "-", "x"}], "]"}], "*", 
               RowBox[{"(", 
                RowBox[{"omega2", "-", "omega1"}], ")"}]}]}], ")"}], "^", 
            "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"omega3", "+", 
              RowBox[{
               RowBox[{"HeavisideTheta", "[", 
                RowBox[{"t2", "-", "x"}], "]"}], "*", 
               RowBox[{"(", 
                RowBox[{"omega4", "-", "omega3"}], ")"}]}]}], ")"}], "^", 
            "2"}]}], ")"}]}], "+", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"omega1", "+", 
              RowBox[{
               RowBox[{"HeavisideTheta", "[", 
                RowBox[{"t2", "-", "x"}], "]"}], "*", 
               RowBox[{"(", 
                RowBox[{"omega2", "-", "omega1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"DiracDelta", "[", 
                RowBox[{"t2", "-", "x"}], "]"}]}], "*", 
              RowBox[{"(", 
               RowBox[{"omega2", "-", "omega1"}], ")"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"omega3", "+", 
              RowBox[{
               RowBox[{"HeavisideTheta", "[", 
                RowBox[{"t2", "-", "x"}], "]"}], "*", 
               RowBox[{"(", 
                RowBox[{"omega4", "-", "omega3"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"DiracDelta", "[", 
                RowBox[{"t2", "-", "x"}], "]"}]}], "*", 
              RowBox[{"(", 
               RowBox[{"omega4", "-", "omega3"}], ")"}]}], ")"}]}]}], ")"}], 
         "*", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"omega1", "+", 
            RowBox[{
             RowBox[{"HeavisideTheta", "[", 
              RowBox[{"t2", "-", "x"}], "]"}], "*", 
             RowBox[{"(", 
              RowBox[{"omega2", "-", "omega1"}], ")"}]}]}], ")"}], "^", "2"}],
          "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"omega3", "+", 
            RowBox[{
             RowBox[{"HeavisideTheta", "[", 
              RowBox[{"t2", "-", "x"}], "]"}], "*", 
             RowBox[{"(", 
              RowBox[{"omega4", "-", "omega3"}], ")"}]}]}], ")"}], "^", "2"}],
          "*", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0."}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'''"}], "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "0", "]"}], "\[Equal]", "0."}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "2."}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.802081695689034*^9, 3.802081719423781*^9}, {
   3.8020819819993505`*^9, 3.802082045954213*^9}, {3.802082141050316*^9, 
   3.8020821778793397`*^9}, {3.802082212965623*^9, 3.8020822430826054`*^9}, {
   3.8020822809951715`*^9, 3.8020823808234863`*^9}, 3.802082432237254*^9, {
   3.8020824879532237`*^9, 3.8020825447433157`*^9}, {3.8020826051684113`*^9, 
   3.8020826089869432`*^9}, 3.8020826572327857`*^9, {3.8021606949283237`*^9, 
   3.8021607161804285`*^9}, {3.8021607521751175`*^9, 3.802160785349129*^9}, {
   3.8021608531060905`*^9, 3.8021609317131343`*^9}, 3.802161517423338*^9, {
   3.802161582914793*^9, 3.8021615952870016`*^9}, {3.8021900679676867`*^9, 
   3.8021900840253477`*^9}},ExpressionUUID->"2046a797-3d4e-4687-b00a-\
786bcdcc018f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.80208236756569*^9, 3.802082381819149*^9}, 
   3.8020824343556647`*^9, {3.8020824893971825`*^9, 3.802082512416218*^9}, {
   3.802082584019376*^9, 3.8020826098975477`*^9}, 3.802082659850524*^9, 
   3.80216065456454*^9, {3.8021606989379854`*^9, 3.8021607171810913`*^9}, 
   3.8021609360129857`*^9, 3.802161442023502*^9, 3.8021615184560213`*^9, {
   3.8021615679778805`*^9, 3.802161596594869*^9}, 3.802163379926621*^9, 
   3.8021899585741014`*^9, 3.802190087279503*^9, 3.8021902157166586`*^9, 
   3.802279101843917*^9, 
   3.8119313664353137`*^9},ExpressionUUID->"7fde07fb-4ba3-4cd5-92b3-\
a41d77c72338"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "PUsolution01"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", "\"\<Angle,rad\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.802082587418632*^9, 3.8020826413602524`*^9}, {
   3.802161445933097*^9, 3.80216146709814*^9}, 3.802161520558416*^9, {
   3.8021615866622825`*^9, 3.802161598866378*^9}, {3.8022791660925484`*^9, 
   3.8022792389699073`*^9}, {3.8022792934957314`*^9, 
   3.8022793212641554`*^9}},ExpressionUUID->"e683ab89-3d7a-4a11-a109-\
bcca49c02494"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUV3k8VN8btu87M2bG2HfZtzGM7kvIlpClkIRkD5UUSUhFIktElKJFQtJC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox["\"Angle,rad\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{5, 10, 15, 20, 25, 30, 35, 40}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{779., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{{{5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {25, 
      FormBox["25", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {35, 
      FormBox["35", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{{3.8022792306233683`*^9, 3.802279239931544*^9}, 
   3.802279323084367*^9, 
   3.8119313679683523`*^9},ExpressionUUID->"d4e8a996-9169-480d-be0f-\
dfa22cb4ae42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "PUsolution01"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "14.5", ",", "15.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.802162891500265*^9, 
  3.8021628990342646`*^9}},ExpressionUUID->"1f717058-c77c-4c60-b3a4-\
d4c12bbe287d"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0ms41HkUB3BGiXEbM2Pmz5KHEqr/L6MUcjkNbepBFrUUKoynbdalos2z
tYts2rSqpdtG61K6UNJ2WTHt2a10mVk1a2flUqMWk9ktRJP77H9fnPN9Pq/O
i+9xSkyPlLAMDAzCmPk/Z4XXMZuG14rNQ70yNi7pvrPYjXGypfnRf35hY+KO
lpQIxsaB7xcN/crGO8ffKMoZN2m+kE7eZ+Mu9YJTKwxpWHh24hm3hY19GRdE
+1g08Mv7CgNfsLG5uCLReCYNJqIjcHKajd+0F98zZ9NgP1+R8HGgGW6oqBsc
4tOgNpbr0+VmaJAXt2q2I3M/akkPHW6OZ7uUBUJ3Gvb5dPiLWszxx51fefQv
piHj4uyy1hgLlM5pMmIFMJ4cyBlut8AiK1HgcAgN2zSusUUSS6zLSkuuj6Ih
1spA5/vWEstH/K7fjKdhxVnRzuhUK+yvE39espUGZfDCNZd1VsjKbw9v2EHD
8G3bV4uXc9D2D++PavbQcHrqTWNRNgcL4p6szSqgIT48ukTTxMFmve7K/qM0
mK7XHkub4GCcet2ujFIavp0RG9YWYI2D3ntdXc/TkD6q1JflWGN0jZeRSz0N
o7JCuxKZNXI2uKyaaKQh6Ux0H+itsdSp+gbVTEPZk83J9n5czHFJOGSppGGT
Kndl4V4ubql6EarspCFlzbZD/jIu8nwHl3X20jD9SdbGeaNctLfwKZQN0rCI
7M9PW8ZD3SjXVDNOQ3/To+cD23n4e8KNjOczCOhtgzobLvFw0uAw1FoRuLou
uKlGw8OJxjHf32wJoH/2Z72OfIz86XTZ1bkEDquT3W3j+Fg911grXUQgoMH5
YOpxPsqvGG5J8yEgci/ocFDwcVXWElgdTOCZeOvFgpk2WBI9uloaTqAy0/Pn
9b42qL6c778hhkBqvfRdTKoN5gaFnHJKIvDoWvV9ZZUNjgyVOnqkEnCyM0uR
q2zwTpebpXA3gR3BgmszzAQY273SdWUeAcNzT2MVywU4FL9gPhwi0FwXeLtp
mwC7hSHHeCcIZLu4tFaWCrBc+34+qSDg57n9se9jAd4a63BzqiVgUaTpLBwX
oCLvAOflTQInc8C0w02I1+Y+cH6NBLiOg8VGUUIcYPmXPZATuCSZFJd8LcSp
sSDxWxUBa8MkOf+CEE2kPOVLNYHzu5MiGluEKKXsHl7WEujaODiS9UGIZ17U
9+MIAZun57+MsKfw31iTvjeMz4gc97xj7KNKeGX3noCqgZVS4kDhn3KzzkzG
bZGzdG2zKWQ3SBRuOgLp/n8ZJzhRmFVsW3fkA4E5XBOtZB6FoSG5mZvHCeRG
11xK9qDwh7ttGd8x7ulaqzISUagJIKm3GXekuvdXMs7z6pTwJwhIWjIV3Z4U
3nL2+vQh49Hv/XI3elHoPPXax2OK6UvNqQz1pTBjd+DSeMYOBd6btIxlw8c8
DzI+0J4988ByCmO04gU9jLfUii3u+lFY1FZqf3Ka+Y8wmal3IIVdkcPUfcbn
ivKsVIzdW1bbvGNc9SxqejtQeO+eziJUT6DhFu9EzQoKrSGMnc34Qe80hIgp
TGisMq5mnBg+0NrDuHbpOKuVcVzA32tzgygcq4/Q6xlXsNqvOwRT+B8A7zSj

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{14.600000000000001`, -6.1000000000000005`},
  PlotRange->{{14.5, 15.5}, {-6.066519571061378, -3.342723737494101}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.8021628998578105`*^9, 3.80216338367811*^9, 
  3.8021899714416375`*^9, 3.8021900913502035`*^9, 3.8021902249107623`*^9, 
  3.8119313707822256`*^9},ExpressionUUID->"fca1c638-147c-4c98-8089-\
102dc4629279"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "y", "]"}]], "Input",
 CellChangeTimes->{{3.8021631920481606`*^9, 
  3.8021631960728335`*^9}},ExpressionUUID->"ca45d97b-cb5f-45e3-845a-\
aa87839fed2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "PUsolution01"}]}]], "Input",
 CellChangeTimes->{
  3.802162965797161*^9},ExpressionUUID->"0c696d48-cbe1-427d-8a0b-\
55dc97b0081e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.802162968460928*^9, 3.802163199800305*^9, 
  3.802163387244477*^9, 3.802189977959964*^9, 3.802190093694759*^9, 
  3.802190230400403*^9, 3.80227934316769*^9, 
  3.8119313730567446`*^9},ExpressionUUID->"ffa5b875-e17a-4493-a4a0-\
d924b7a73834"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSol", ",", "x"}], "]"}]}]], "Input",ExpressionUUID->"305f62ca-\
22b6-41ae-bc10-3013a662dc29"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.802162969963925*^9, 3.8021632009991045`*^9, 
  3.8021633884732924`*^9, 3.8021899789966526`*^9, 3.8021900943461905`*^9, 
  3.8021902311839314`*^9, 3.802279344577626*^9, 
  3.811931374056411*^9},ExpressionUUID->"a76a8aa8-3a26-42b1-bf46-\
8dd191ec508f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "DirSol1", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "14.95", ",", "15.05"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.8021629885422535`*^9, {3.8021630454930425`*^9, 3.80216305213445*^9}, 
   3.8021631725892506`*^9, 3.8021632084140205`*^9, {3.8021633059575386`*^9, 
   3.8021633377166157`*^9}, {3.8021900278240533`*^9, 
   3.8021900328393817`*^9}},ExpressionUUID->"afba83cf-c388-4924-ac23-\
1c5fcbbb20f0"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0H1UzGkUB/BKnh8hpkxNUmjZ1e48TzYpycsTRycxZWpVMgeNvMxspLV6
ozkphKxqkd7G2MLuak3tiTatuCpHQ227ztLxks1bkprSi/KS2euPe+75nHvu
Ofd+pyljgjdamJmZybA+9dnG+E2b2ihvb5LPHa8QQG139Fs1+kC5h/HtGgGK
Fuq3b0PvHlNe/Axtk/ksKQ49YJ86rgrd6ybP3I++r1M9jEKXxX5ZeRatkK/d
XBUhgHTg4egX6Mzolq83rhbg8w++5ze/wLmrNO9SqAAuWaJcTTvlykcV5h0r
BWi45yKkvaQ8L6g+OG65AEsMkRGpHZQv8vu1xt5PgNqFZ+UnXlEemeNYuoAL
8FolbczrpPyqf5IJ5gkw07Gy8/cuyq2gdP8NDwG++i62p85IeYr+wm9PmAAt
muiE692Uq+ronwpXAXJFW08/6KF8V1WQOvwzAcwjSr/57zXl1+em15c7CeDl
P+VlSy/lprBnwTMkAuy8fGxabx/lgTdD++1sBFC2LX/U1495vRJXq8YKEJ4z
atGYN5Sv0svCfIgAkzp705wGKT9/00vrYiZAxqCzzGmIcoe04RPR7whYHlxZ
5f6W8uzELQ2z+wlI/64tmfOOcvnYkMS1RgIK7XzfwPeUr5PbSEa2E1g94WlV
5AfKxeKmwWuPcd/7VqVymPLBBT73nj4gUPmiMiLxI+Uj1EHilDsEHFe0pySb
KM+58nZSahOBgNClGbvNGG88uPVpgYFAatvP3tnmjPt7KNNZLYEt0hXRRy0Y
Z9biuJnVBMKGBhaXjGB8h+X6rrwKArbqxuFqS8aVRywuu5QRSM5um39lJOPh
mfciJ54j0LNw5NR/CeNXddXDu4oJiIo2pjcLjLt3j/GRaQmYzvXdvjOK8Qpv
aZTXCQJvvNNrXo5mfJQy/v3xLAIFGoXnKyvG7U4eu7juEIFly7wCLcYyflGR
W1CYRuCMIaSDjGM8QT6wbWkygb+6tWpizXifakm9EE/ArLDriON4xr8Xxdb5
bCfQOqzxcp7AeJNn5KwWFQHDc/FeTxHjxlrdB6OSgGbH/QvLbBj3vnvwroOC
wJOKVlWALeOF+zNKylcRCErprFk/kfEtzWErLwcSUJu8T0WJGV+z58wlD38C
wdMvRm6wYzyleF/tDV8Ci5vm3Ii3Zzw5QLCvn0fgsdtQWaKEcbdtw3pvD8w3
Jn+WBn21wStiMrpHP78sFW2Y129pmo33sz2lGWitX194HdpZaqXXol/PsHof
iFbMnFxyDS31L/giyp1A81R+ZrQD4/2+MpcjswisXf9kujU6wPVm9XZ0m27v
aRt0l6shPAT9xtlQ7IhWJsh+kKAnOgUXUXROcExPkRv+4xClk3/yIonuD0bg
fjiZEore0Frhno9W5v5yMgIdpmu+vhsda9+l3YA2Jug6fNFZ4rjCnWhxsT9r
oAQkqySTk9BJC4aq9WjdsaoCDTpmyFWWjdbbmvLT0dP/sVWHoj1Dfpp0GJ3Y
fWtwLvrKj0vys9CH3Mg+R7Tf7ecOx9GnsmtEH6UEGkUH8vLQ1nbmJ1vR/wNi
ZBQr
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{14.96, -2.92},
  PlotRange->{{14.95, 15.05}, {-2.919950904843052, -2.7719127983170955`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.802162990413494*^9, 3.8021630533322444`*^9, {3.8021631738791056`*^9, 
   3.802163209909013*^9}, {3.8021633080109015`*^9, 3.8021633386252155`*^9}, 
   3.8021633895520077`*^9, 3.8021899803915763`*^9, 3.802190034082204*^9, 
   3.802190095223777*^9, 3.802190232254635*^9, 
   3.8119313746518116`*^9},ExpressionUUID->"23744997-134c-4aef-824b-\
d3757a8aa74f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Evaluate", "[", "DirSol1", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", "\"\<Angular speed,rad/s\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8021634643722906`*^9, 3.802163467525384*^9}, {
  3.8021635056016493`*^9, 3.802163511263406*^9}, {3.8022793500392513`*^9, 
  3.8022793999053373`*^9}},ExpressionUUID->"7d532c66-e188-4d0f-9f6f-\
3a5f058bf5a4"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUV3k4lG8XtpuxbzNTyL7v21iGvIdUlIpCVEqULSSljVJSlihJ2cqSFhLh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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox["\"Angular speed,rad/s\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{5, 10, 15, 20, 25, 30, 35, 40}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{766., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{{{5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {25, 
      FormBox["25", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {35, 
      FormBox["35", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{
  3.8021634680997653`*^9, 3.8021635124431896`*^9, 3.8021899834966373`*^9, 
   3.80219009687287*^9, 3.802190235684914*^9, {3.8022793514822083`*^9, 
   3.80227940177458*^9}, 
   3.8119313759837017`*^9},ExpressionUUID->"fa1af6da-8b4c-4509-b0d5-\
49c1d0e773bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir2Sol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSol1", ",", "x"}], "]"}]}]], "Input",ExpressionUUID->"87ff98c0-\
b335-4c54-ba18-daf7a8bb4828"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.8021634208607826`*^9, 3.8021899910646615`*^9, 
  3.8021900982517834`*^9, 3.8021902379354024`*^9, 3.8022794845929976`*^9, 
  3.802280102433241*^9, 
  3.8119313781563587`*^9},ExpressionUUID->"2baa9a67-98b5-45aa-9217-\
e3767adce29a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "Dir2Sol1", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "14.5", ",", "15.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.80216342940245*^9, 
  3.802163439687274*^9}},ExpressionUUID->"6539a65f-a124-4030-93d9-\
dcaecd0eea8a"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3s81Xccx/HjnPx+pYki1yitcv1+O7mUS/p+kEVDJslRTkspS5mHsNrU
QmENtam11rEyZT0iB+3oglNyXMqJpB4m9y5uxc7pcJxD2K8/3q/342kR8W1Q
JJvFYvkz+/R0gJApAufvU0LE4cXEsVfsYMW4Ie21zENcTCLimvYFMqa4+gVS
cyER/zYivcL41f1VuyZ6hCSxx/aihwYCrZ79s4GlJaQ/9vqaVDaC+kuNVdcc
y0hdTl4EpYngzFnl4XF3ETnVniP5TAtB1cCv2kY7KkhYnlAm10eQPfbuxGSk
hLBSdm4yX4rAROHtSz96TK52tqQbWiPQMD0/bJfzlFw+fJw75IBAnGaX7b34
OYn+vJLD3oBAwOZRyVFtJFtnDVH4IDCqfVfZq9tBhAkxe0u3IgiKFbjeEXWT
K2Pr/ykPRxBT2CKp1esjQ0LPg+eiENSKO3V1Va8I+2R7wN04BHTq6riG6jfE
+JmzaWESgrJrQ45p6f0kfWfzloR0BI8H3O67HB0kdbPK4rRfEEhM+UVHAobJ
zp5tibECBNKSn2qtA98TmfMxS8u/EZQ0vVvi5z9KggudOCtLEYTdISpDAxnR
DVu5aaoCQUZI4qrXpnIisCgQGdUhaG6/4WGy6AM5sZKfuaAFwT7yA/euuYLs
zu/2a+lA0H7zhsjdaozoucrWdbxFcLt15HmoxThZou3yc5UMwbpl6opnXCVR
qhbNG5hE8NeHh4tPrZ4gT/ii2K45GAwC8xXj1irykXUGinQwmPaXBdc7q8lU
hdr1oTGGpLHN+f6OkyTo1qXckhUYRKVe/se9pkjBCmo4ejWG7RGZ1XZ+H0lj
scbuGBcMqmT9yiyPabIpwRF8N2KQV9fHD/rOkHPBKt/oAAzxzbz+0Q2zpOfm
SfewUAyXeDtsbxmwINnL56LFHgx5MxIHnQssGJMLlnIPYdj2UJTbqK0B4k6r
BYZHMNjrWJbzsjSA1+tt6Z2C4d8X1oKtHDbIw21tIBOD1sLdqq4ENvQa+pzX
u4Bh3uUSzSYZG64Mj9vgPAwthfl7PCI4cFv90sqiCEOfILW8uoMD0pQM3b5y
DD8qCiozvpoDZSvqlw8+wPDNyDK3mao58B/bPbe+EYPnCchl22vCtNrLc/QF
ButmOdUg0IS50XotfT0Y6vJsq9UcCqKNTBpuDmOovb631TWOgj+7S4cejGG4
xi+/mthGwXve3P4RxhPGF1nr2ilwecF/ZTKOwTu1xm3iJQXPG+d3xDMOkT/b
8l03BVp3I6VWSgygaTSa8JaChBxj4dkJDGYHAqYPKijw80mO/3oSQ355uJun
Dg1/1LTFZjHe/PHJ4RldGgY24EP3GHNsHp2+t4iGFKeOSP0pDD4xW4LtDWi4
vdxpewNjObLbtsyMhuXTgy7caQz+Unq+0oaG2CNkbThjUXOUTYkdDVWK8/an
GXdxza0OYBpChz1t3zC+r58k7lpDQ3abYMnvMxj2qmtCapxp6AxSGNUyTpOm
RSW50mDd5Lv4A+OsY5mhTutpkEiU2n6zGNKjeK0FhIaF4K91lPG8ADP+Lg8a
+BX5VAHjjP1m9YZeNBStnWS3Mv5yfeiCpxtpUJcGzs4yttsndcj4gob/AZ/X
Jyo=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{14.600000000000001`, 0},
  PlotRange->{{14.5, 15.5}, {0., 2.90943947284247}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.8021634320712214`*^9, 3.8021634407319684`*^9}, 
   3.8021899933251657`*^9, 3.802190098902216*^9, 3.802190238930063*^9, 
   3.811931379084979*^9},ExpressionUUID->"5dd39055-af88-4866-9c10-\
5d7cf0e12b5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Evaluate", "[", "Dir2Sol1", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", 
      RowBox[{"\"\<Angular acceleration,rad/\>\"", 
       RowBox[{
        RowBox[{"Text", "[", "s", "]"}], "^", "2"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.802163541579522*^9, {3.8022794255538225`*^9, 
   3.802279468805521*^9}},ExpressionUUID->"2438bbb5-051a-49b6-9368-\
6c87b1f2906a"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUWnk4VP8XHmMdzJIt29fO2A1jG0v3RFqkQpFKKpQkUlIIKYqyJiIiStFC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox[
     RowBox[{"\"Angular acceleration,rad/\"", " ", 
       SuperscriptBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox["s", TraditionalForm]], "Text", "TR"], 
         Text[$CellContext`s]], "2"]}], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{5, 10, 15, 20, 25, 30, 35, 40}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{800., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{{{5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {25, 
      FormBox["25", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {35, 
      FormBox["35", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{
  3.8021635430615053`*^9, 3.8021899972677765`*^9, 3.8021901001240263`*^9, 
   3.802190241687895*^9, {3.8022794704906387`*^9, 3.8022794875489583`*^9}, 
   3.802280103977268*^9, 
   3.8119313805969896`*^9},ExpressionUUID->"b55a9004-a116-43c7-9f8b-\
a92314cc1d12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir3Sol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"Dir2Sol1", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.802280059739912*^9, 3.80228006131696*^9}, 
   3.80228020943416*^9},ExpressionUUID->"dc3e36d5-020a-45b0-8cab-\
99785b5e964b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.802280062235569*^9, 3.802280110377513*^9, 
  3.8022802110682435`*^9, 
  3.811931382818477*^9},ExpressionUUID->"5473bb37-811c-4c9d-bb7b-\
b6d518e74319"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Evaluate", "[", "Dir3Sol1", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", 
      RowBox[{"\"\<Third derivative,rad/\>\"", 
       RowBox[{
        RowBox[{"Text", "[", "s", "]"}], "^", "3"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.802280071499715*^9, 3.8022800830263653`*^9}, {
  3.8022801173071117`*^9, 3.8022801339871783`*^9}, {3.802280234942086*^9, 
  3.802280235388382*^9}},ExpressionUUID->"84effe7d-a2a1-4013-b2fd-\
cd80b9cec581"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUV3k4lG8XZhZmxj5jKdn3nbEOg/e0qJQoUfJTSRKSpSRJEirJloiQCIVs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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox[
     RowBox[{"\"Third derivative,rad/\"", " ", 
       SuperscriptBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox["s", TraditionalForm]], "Text", "TR"], 
         Text[$CellContext`s]], "3"]}], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{5, 10, 15, 20, 25, 30, 35, 40}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{819., Automatic},
  PlotRange->{{0, 40}, {-4.795075366315638, 4.890467363205675}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {25, 
      FormBox["25", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {35, 
      FormBox["35", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{{3.8022800756624784`*^9, 3.8022800844963408`*^9}, {
   3.802280118935191*^9, 3.8022801378277273`*^9}, {3.8022802119658413`*^9, 
   3.8022802365531554`*^9}, 
   3.811931383440895*^9},ExpressionUUID->"7229254a-3bf8-47b0-ae69-\
a471b23a3dce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir4Sol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"Dir3Sol1", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8022801873234873`*^9, 3.802280191848491*^9}, {
   3.802280245311967*^9, 3.8022802471972165`*^9}, 
   3.8022803023658237`*^9},ExpressionUUID->"c96d1b5a-a610-4b0c-99a3-\
9b234264be18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.802280248341979*^9, 3.8022803034685555`*^9, 
  3.8119313860876627`*^9},ExpressionUUID->"167a9cf7-bbbb-4e84-bf96-\
181bc2feba16"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Evaluate", "[", "Dir4Sol1", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "0.1"}], "]"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "5", ",", "10", ",", "15", ",", "20", ",", "25", ",", "30", ",", "35", 
        ",", "40"}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", 
      RowBox[{"\"\<Fourth derivative,rad/\>\"", 
       RowBox[{
        RowBox[{"Text", "[", "s", "]"}], "^", "4"}]}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6"}], ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8022802635930986`*^9, 3.8022802937300997`*^9}, {
  3.802280374494418*^9, 3.8022804190589848`*^9}, {3.811931496919071*^9, 
  3.8119315217965746`*^9}, {3.8119315977042294`*^9, 3.8119315987319164`*^9}, {
  3.811931706879245*^9, 
  3.8119317183549004`*^9}},ExpressionUUID->"be31588d-353a-4ddf-a134-\
c1d5b896bea0"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwdV3k4VO/7Zmbs22DsEmM3Q1IhqfMUSUSWPiUVQlK2RKQkJCklpCzJFrKk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      "]], LineBox[CompressedData["
1:eJwkV3k4lO/3tsxmRoqPJERJEWIYZgwz5gySSruESpKEZEsqZUlkSbY2IpUk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      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox[
     RowBox[{"\"Fourth derivative,rad/\"", " ", 
       SuperscriptBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox["s", TraditionalForm]], "Text", "TR"], 
         Text[$CellContext`s]], "4"]}], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{5, 10, 15, 20, 25, 30, 35, 40}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImagePadding->{{61.367347, 44.}, {10.5, 29.}},
  ImageSize->{1247., Automatic},
  PlotRange->{{-0.8333333333333335, 40.833333333333336`}, {-6., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  Ticks->{{{5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {25, 
      FormBox["25", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {35, 
      FormBox["35", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, Automatic}]], "Input",
 CellChangeTimes->{{3.811931730830248*^9, 
  3.811931741252409*^9}},ExpressionUUID->"702dfc43-add3-4deb-9469-\
e9acdab60a57"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVV3k4VP8XZmbs22DsEmM3Q1IhqXuKJEWWviUVQlK2RKQkJCklpCzJFrKk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      "]], LineBox[CompressedData["
1:eJwsV3k4lO/3tsxmRoqPJESkCDEMM4YZcwZJ0i6hkiQh2ZJKWRJZkq2NSCVJ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      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox[
     RowBox[{"\"Fourth derivative,rad/\"", " ", 
       SuperscriptBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox["s", TraditionalForm]], "Text", "TR"], 
         Text[$CellContext`s]], "4"]}], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{5, 10, 15, 20, 25, 30, 35, 40}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImagePadding->{{61.265306, 44.}, {1.1, 29.}},
  ImageSize->{792., Automatic},
  PlotRange->{{-0.8333333333333335, 40.833333333333336`}, {-5.545457478303092,
    11.32979508442919}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  Ticks->{{{5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}, {25, 
      FormBox["25", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {35, 
      FormBox["35", TraditionalForm]}, {40, 
      FormBox["40", TraditionalForm]}}, Automatic}]], "Input",
 CellChangeTimes->{{3.811931633820521*^9, 
  3.8119316750359883`*^9}},ExpressionUUID->"65598824-ee21-4d0e-bcb3-\
06ce9632cf7a"]
},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f6b3dd4e-cd06-4962-9180-e533e8d45ef8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 710, 12, 136, "Input",ExpressionUUID->"380dde66-1fb3-42e2-bfb6-a4db595e4041"],
Cell[1292, 36, 379, 7, 34, "Output",ExpressionUUID->"ede01f33-aa0f-49f9-8d88-4696cfe84f5d"],
Cell[1674, 45, 381, 7, 34, "Output",ExpressionUUID->"b57b775d-2a9f-4529-beab-1b8b3607d769"],
Cell[2058, 54, 378, 7, 34, "Output",ExpressionUUID->"db5a4e46-f0e8-48ec-b6bf-fb91caeae026"],
Cell[2439, 63, 381, 7, 34, "Output",ExpressionUUID->"adbf0ac6-d2fa-415b-9382-2d3b5eaebe54"],
Cell[2823, 72, 378, 7, 34, "Output",ExpressionUUID->"17cec57c-9818-459c-a2a6-5829661105ad"],
Cell[3204, 81, 381, 7, 34, "Output",ExpressionUUID->"977ced0a-840a-4047-848f-b4e070549e6b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3622, 93, 698, 18, 52, "Input",ExpressionUUID->"5355d054-f71b-4e13-af48-bfb25b7ba46d"],
Cell[4323, 113, 353, 7, 34, "Output",ExpressionUUID->"761379d8-60dc-4dc1-ad72-7c3084d70681"],
Cell[4679, 122, 330, 7, 34, "Output",ExpressionUUID->"54a1a006-d97d-4e5d-9908-1a6f985a3dbf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5046, 134, 420, 12, 30, "Input",ExpressionUUID->"4bedbbb8-82fb-4e82-8612-57e167c3b6f7"],
Cell[5469, 148, 2556, 51, 246, "Output",ExpressionUUID->"0daaa6db-6754-4e8b-9d15-8ec3a711c006"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8062, 204, 618, 18, 52, "Input",ExpressionUUID->"c34aac98-f835-4838-b4dc-2d138f529531"],
Cell[8683, 224, 464, 9, 34, "Output",ExpressionUUID->"e9b820d9-bb7e-43c7-b41c-85375354fc51"],
Cell[9150, 235, 464, 9, 34, "Output",ExpressionUUID->"8b635b23-9bf6-40da-8578-d48be07fa0f0"]
}, Open  ]],
Cell[9629, 247, 186, 4, 30, "Input",ExpressionUUID->"19ee5ad5-b020-4e2a-a9a4-609fb92e257c"],
Cell[CellGroupData[{
Cell[9840, 255, 4391, 113, 220, "Input",ExpressionUUID->"2046a797-3d4e-4687-b00a-786bcdcc018f"],
Cell[14234, 370, 1028, 24, 34, "Output",ExpressionUUID->"7fde07fb-4ba3-4cd5-92b3-a41d77c72338"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15299, 399, 1623, 41, 94, "Input",ExpressionUUID->"e683ab89-3d7a-4a11-a109-bcca49c02494"],
Cell[16925, 442, 26989, 455, 482, "Output",ExpressionUUID->"d4e8a996-9169-480d-be0f-dfa22cb4ae42"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43951, 902, 377, 10, 30, "Input",ExpressionUUID->"1f717058-c77c-4c60-b3a4-d4c12bbe287d"],
Cell[44331, 914, 2276, 43, 254, "Output",ExpressionUUID->"fca1c638-147c-4c98-8089-102dc4629279"]
}, Open  ]],
Cell[46622, 960, 188, 4, 30, "Input",ExpressionUUID->"ca45d97b-cb5f-45e3-845a-aa87839fed2f"],
Cell[CellGroupData[{
Cell[46835, 968, 220, 6, 30, "Input",ExpressionUUID->"0c696d48-cbe1-427d-8a0b-55dc97b0081e"],
Cell[47058, 976, 559, 15, 34, "Output",ExpressionUUID->"ffa5b875-e17a-4493-a4a0-d924b7a73834"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47654, 996, 169, 4, 30, "Input",ExpressionUUID->"305f62ca-22b6-41ae-bc10-3013a662dc29"],
Cell[47826, 1002, 568, 15, 34, "Output",ExpressionUUID->"a76a8aa8-3a26-42b1-bf46-8dd191ec508f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48431, 1022, 500, 11, 30, "Input",ExpressionUUID->"afba83cf-c388-4924-ac23-1c5fcbbb20f0"],
Cell[48934, 1035, 2348, 45, 251, "Output",ExpressionUUID->"23744997-134c-4aef-824b-d3757a8aa74f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51319, 1085, 1472, 38, 94, "Input",ExpressionUUID->"7d532c66-e188-4d0f-9f6f-3a5f058bf5a4"],
Cell[52794, 1125, 30697, 516, 451, "Output",ExpressionUUID->"fa1af6da-8b4c-4509-b0d5-49c1d0e773bf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83528, 1646, 171, 4, 30, "Input",ExpressionUUID->"87ff98c0-b335-4c54-ba18-daf7a8bb4828"],
Cell[83702, 1652, 548, 15, 34, "Output",ExpressionUUID->"2baa9a67-98b5-45aa-9217-e3767adce29a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84287, 1672, 313, 8, 30, "Input",ExpressionUUID->"6539a65f-a124-4030-93d9-dcaecd0eea8a"],
Cell[84603, 1682, 2244, 43, 251, "Output",ExpressionUUID->"5dd39055-af88-4866-9c10-5d7cf0e12b5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86884, 1730, 1488, 41, 94, "Input",ExpressionUUID->"2438bbb5-051a-49b6-9368-6c87b1f2906a"],
Cell[88375, 1773, 31248, 529, 460, "Output",ExpressionUUID->"b55a9004-a116-43c7-9f8b-a92314cc1d12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119660, 2307, 262, 6, 30, "Input",ExpressionUUID->"dc3e36d5-020a-45b0-8cab-99785b5e964b"],
Cell[119925, 2315, 469, 14, 34, "Output",ExpressionUUID->"5473bb37-811c-4c9d-bb7b-b6d518e74319"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120431, 2334, 1507, 40, 94, "Input",ExpressionUUID->"84effe7d-a2a1-4013-b2fd-cd80b9cec581"],
Cell[121941, 2376, 30772, 521, 484, "Output",ExpressionUUID->"7229254a-3bf8-47b0-ae69-a471b23a3dce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152750, 2902, 320, 7, 30, "Input",ExpressionUUID->"c96d1b5a-a610-4b0c-99a3-9b234264be18"],
Cell[153073, 2911, 446, 13, 34, "Output",ExpressionUUID->"167a9cf7-bbbb-4e84-bf96-181bc2feba16"]
}, Open  ]],
Cell[153534, 2927, 1843, 48, 115, "Input",ExpressionUUID->"be31588d-353a-4ddf-a134-c1d5b896bea0"],
Cell[155380, 2977, 40660, 682, 758, "Input",ExpressionUUID->"702dfc43-add3-4deb-9469-e9acdab60a57"],
Cell[196043, 3661, 40690, 683, 468, "Input",ExpressionUUID->"65598824-ee21-4d0e-bcb3-06ce9632cf7a"]
}
]
*)

