(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    389218,       7296]
NotebookOptionsPosition[    377821,       7105]
NotebookOutlinePosition[    378220,       7120]
CellTagsIndexPosition[    378177,       7117]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"ScaleFactor", "=", "400."}]], "Input",
 CellChangeTimes->{{3.7733845587561502`*^9, 3.773384565900963*^9}, 
   3.77338522475252*^9},ExpressionUUID->"039a1c71-029b-437b-821b-\
66579699fc34"],

Cell[BoxData["400.`"], "Output",
 CellChangeTimes->{3.773384619939458*^9, 3.773385225750922*^9, 
  3.773487189946087*^9, 3.7735473234853263`*^9, 3.7741087131398096`*^9, 
  3.7890321709946756`*^9, 3.7891961849870424`*^9, 3.789266168087796*^9, 
  3.7896457029376245`*^9, 3.789900447262336*^9, 3.796969823542148*^9, 
  3.802074537804344*^9, 3.8022465345392165`*^9, 
  3.8022744851246843`*^9},ExpressionUUID->"c9bcac64-d804-4f20-8ca6-\
777fbf4dde0b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"HeaviApprox", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.7978845608028653`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3.`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
         "ScaleFactor"}], "]"}]}], 
      RowBox[{"z", "*", "ScaleFactor"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.7978845608028653`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4.`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
         "ScaleFactor"}], "]"}]}], 
      RowBox[{"z", "*", "ScaleFactor"}]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"SinIntegral", "[", 
       RowBox[{"3.`", " ", "z", "*", "ScaleFactor"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"SinIntegral", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
        "ScaleFactor"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"SinIntegral", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
        "ScaleFactor"}], "]"}]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.773032013893078*^9, 3.773032023955654*^9}, {
  3.773032115954916*^9, 3.7730321183460526`*^9}, {3.773384573248576*^9, 
  3.77338460969024*^9}},ExpressionUUID->"9e15467b-45e7-48c3-8875-\
0a66c045170b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Heavi1", "=", 
  RowBox[{"HeaviApprox", "[", 
   RowBox[{
    RowBox[{"\[Pi]", "/", "40"}], "+", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.77304391436182*^9, 3.7730439427382703`*^9}, {
   3.77338322637341*^9, 3.773383245015443*^9}, {3.7733833091627555`*^9, 
   3.773383310909959*^9}, {3.7733846258518686`*^9, 3.7733846266162696`*^9}, 
   3.7734871986845865`*^9, 3.7734876582558727`*^9, 3.7734877161711845`*^9, {
   3.7734887209986577`*^9, 3.773488724781874*^9}, {3.773488786388398*^9, 
   3.7734888249856057`*^9}, 3.77354931253762*^9, {3.7741087455226617`*^9, 
   3.7741087456076665`*^9}, {3.7741087784155436`*^9, 3.774108781353711*^9}, {
   3.774109214137465*^9, 3.774109217075633*^9}, {3.7741101641118*^9, 
   3.774110171501223*^9}, {3.8020770209940214`*^9, 
   3.8020770245944085`*^9}},ExpressionUUID->"c8c13827-db90-4a21-814c-\
cc8f86e44f6e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["\[Pi]", "40"], "+", "x"}], ")"}]}], "]"}]}], 
     RowBox[{
      FractionBox["\[Pi]", "40"], "+", "x"}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["\[Pi]", "40"], "+", "x"}], ")"}]}], "]"}]}], 
     RowBox[{
      FractionBox["\[Pi]", "40"], "+", "x"}]], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"1200.`", " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Pi]", "40"], "+", "x"}], ")"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Pi]", "40"], "+", "x"}], ")"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Pi]", "40"], "+", "x"}], ")"}]}], "]"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.7734872100382357`*^9, 3.773487659390937*^9, 3.773487717765276*^9, 
   3.7734887340164022`*^9, {3.773488790248619*^9, 3.7734888260186644`*^9}, {
   3.7735492899175806`*^9, 3.7735493168432274`*^9}, {3.774108710327649*^9, 
   3.7741087152389297`*^9}, 3.7741087507559614`*^9, 3.774108791569296*^9, 
   3.7741092204248247`*^9, {3.7741101676670036`*^9, 3.7741101725592833`*^9}, 
   3.7890321735068192`*^9, 3.7891961876234474`*^9, 3.789266176418211*^9, 
   3.7896457066287966`*^9, 3.7899004497724795`*^9, 3.796969825547263*^9, 
   3.802074540996464*^9, 3.802077035468624*^9, 3.802246536692646*^9, 
   3.8022744870049334`*^9},ExpressionUUID->"fa244a4b-d28d-48d6-a113-\
f4e2c0908352"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Heavi2", "=", 
  RowBox[{"-", 
   RowBox[{"HeaviApprox", "[", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Pi]"}], "/", "40"}], "+", "x"}], ")"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7734876867525024`*^9, 3.773487691396768*^9}, {
   3.7734877961857615`*^9, 3.773487796880801*^9}, 3.7734878282325945`*^9, {
   3.7734887286720967`*^9, 3.7734887316402664`*^9}, 3.773488852846199*^9, 
   3.773488915949808*^9, 3.773549314752824*^9, {3.7741087484368286`*^9, 
   3.7741087485098324`*^9}, {3.7741087837528486`*^9, 
   3.7741087868890276`*^9}, {3.7741092350756626`*^9, 
   3.7741092392399006`*^9}, {3.77410927663704*^9, 3.774109302209502*^9}, {
   3.8020770302401557`*^9, 
   3.8020770325416813`*^9}},ExpressionUUID->"6f1c0553-fc1b-4b06-ba06-\
bc3f129b7f7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "0.3989438184180913`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["\[Pi]", "40"]}], "+", "x"}], ")"}]}], "]"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "40"]}], "+", "x"}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["\[Pi]", "40"]}], "+", "x"}], ")"}]}], "]"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "40"]}], "+", "x"}]], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"1200.`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["\[Pi]", "40"]}], "+", "x"}], ")"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["\[Pi]", "40"]}], "+", "x"}], ")"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["\[Pi]", "40"]}], "+", "x"}], ")"}]}], "]"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.773487692025804*^9, 3.7734877202054157`*^9}, 
   3.773487798029867*^9, 3.773487829449664*^9, 3.7734887353134766`*^9, {
   3.7734888553023396`*^9, 3.7734888702641954`*^9}, 3.7734889171478767`*^9, {
   3.7735492912435827`*^9, 3.77354931806003*^9}, 3.7741087166940126`*^9, 
   3.774108752379054*^9, 3.7741087927383623`*^9, {3.7741092505805492`*^9, 
   3.7741093041666145`*^9}, 3.7741101736093435`*^9, 3.7890321759259577`*^9, 
   3.789196188621849*^9, 3.7892661785554147`*^9, 3.7896457076598125`*^9, 
   3.7899004510535526`*^9, 3.79696982637131*^9, 3.802074542057167*^9, 
   3.8020770368995743`*^9, 3.8022465381436143`*^9, 
   3.802274490156025*^9},ExpressionUUID->"65d9a61d-81c5-44bd-bdef-\
bb84c9298360"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Heavi1", "+", "Heavi2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7741086969358826`*^9, 3.774108970708542*^9, {3.7741090987188635`*^9, 
   3.7741091025290813`*^9}, {3.774109245151239*^9, 3.7741092465923214`*^9}, {
   3.774109324087754*^9, 3.77410932472479*^9}, {3.8020770479559097`*^9, 
   3.802077052406866*^9}},ExpressionUUID->"22e50478-5e59-448a-be5c-\
604308efaede"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3k81F8XTokoS0QqlbQplJDKci2hRZZEUiJSoRIqSYulwq+QbEUq2UOS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  ImageSize->{600., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.774108729613752*^9, 3.774108764446744*^9, 3.7741088043860283`*^9, 
   3.77410898257022*^9, 3.774109120850129*^9, 3.774109261852194*^9, {
   3.7741092928019643`*^9, 3.77410933608444*^9}, 3.7741101852180076`*^9, 
   3.789032353953126*^9, 3.789196194518659*^9, 3.7892661847184258`*^9, 
   3.78964571310933*^9, 3.7899004565578675`*^9, 3.796969831698615*^9, 
   3.8020745470514803`*^9, {3.802077041731779*^9, 3.802077057543271*^9}, 
   3.802246543683284*^9, 
   3.8022745057053404`*^9},ExpressionUUID->"c51ec81d-7247-4c53-9e17-\
f6bdf9ccba31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"L1", "=", "0.4"}], "\[IndentingNewLine]", 
 RowBox[{"L2", "=", "0.2"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", "9.8"}], "\[IndentingNewLine]", 
 RowBox[{"y0", "=", 
  RowBox[{"\[Pi]", "/", "40"}]}], "\[IndentingNewLine]", 
 RowBox[{"y1", "=", 
  RowBox[{"\[Pi]", "/", "20"}]}], "\[IndentingNewLine]", 
 RowBox[{"ybeta1", "=", "y0"}], "\[IndentingNewLine]", 
 RowBox[{"ybeta2", "=", "y1"}], "\[IndentingNewLine]", 
 RowBox[{"xmax", "=", 
  RowBox[{"8", "*", "\[Pi]"}]}]}], "Input",
 CellChangeTimes->{{3.7670292211348114`*^9, 3.7670292249880314`*^9}, {
   3.7670292647323046`*^9, 3.7670293213325424`*^9}, 3.767029353043356*^9, {
   3.7670294132287984`*^9, 3.7670295256472282`*^9}, {3.767029600400504*^9, 
   3.7670296181225176`*^9}, 3.7671181484933496`*^9, {3.7671182081007586`*^9, 
   3.7671182413646617`*^9}, 3.7687538867245865`*^9, {3.773032009581832*^9, 
   3.773032011393935*^9}, 3.77338631179663*^9, {3.77338655113225*^9, 
   3.7733865592442646`*^9}, {3.773395209210688*^9, 3.773395235387534*^9}, {
   3.7733954246938667`*^9, 3.773395425801469*^9}, {3.773488095706893*^9, 
   3.7734881023462725`*^9}, {3.7734892882961054`*^9, 3.773489288797134*^9}, {
   3.773489530095936*^9, 3.773489542689656*^9}, {3.773490352736988*^9, 
   3.773490364816679*^9}, 
   3.773490851121494*^9},ExpressionUUID->"fcc9d6eb-8887-43b1-9e74-\
a0eb4c3f6e86"],

Cell[BoxData["0.4`"], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.8022745074334884`*^9},ExpressionUUID->"556137f3-1a0c-497e-9f9b-\
297c7d550188"],

Cell[BoxData["0.2`"], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.8022745074354897`*^9},ExpressionUUID->"1fd4f7af-ad83-493f-a8dc-\
4b59c6b14b13"],

Cell[BoxData["9.8`"], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.802274507436489*^9},ExpressionUUID->"828f8134-4b3d-4ce4-a871-\
96be80777ca3"],

Cell[BoxData[
 FractionBox["\[Pi]", "40"]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.80227450743849*^9},ExpressionUUID->"5e6f596e-1e66-413d-bfcb-4829c59b38dc"],

Cell[BoxData[
 FractionBox["\[Pi]", "20"]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.8022745074394913`*^9},ExpressionUUID->"71641ba4-f9bb-4c30-9f52-\
c75a39e5fb0f"],

Cell[BoxData[
 FractionBox["\[Pi]", "40"]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.8022745074404917`*^9},ExpressionUUID->"b346e512-a256-4623-a7e2-\
8df7bcfbad5d"],

Cell[BoxData[
 FractionBox["\[Pi]", "20"]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.8022745074424925`*^9},ExpressionUUID->"cbc5239e-ad5d-48d0-81e6-\
f70bcf923716"],

Cell[BoxData[
 RowBox[{"8", " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.7734872467473354`*^9, 
  3.773488105804471*^9, 3.7734892901212096`*^9, 3.7734895441807413`*^9, 
  3.773489719447766*^9, 3.773490429140358*^9, 3.7734908524865723`*^9, 
  3.7735473287737355`*^9, 3.774110090061565*^9, 3.7890323583773785`*^9, 
  3.7891961945810595`*^9, 3.7892661887900324`*^9, 3.7896457226617937`*^9, 
  3.789900458889001*^9, 3.796969831769619*^9, 3.8020745494971037`*^9, 
  3.802246545933672*^9, 
  3.8022745074434934`*^9},ExpressionUUID->"dc710c16-b409-46fe-b11b-\
bf7aaa29dfe6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"omega", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"g", "/", 
    RowBox[{"(", 
     RowBox[{"L1", "+", "L2"}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733954287030735`*^9, 
  3.7733954524931154`*^9}},ExpressionUUID->"a31318f1-6f08-407b-8838-\
744ad29edc6f"],

Cell[BoxData["4.041451884327381`"], "Output",
 CellChangeTimes->{3.7733954535851173`*^9, 3.773487249958519*^9, 
  3.773489292326336*^9, 3.773490855790761*^9, 3.7735473310513396`*^9, 
  3.7741100927077165`*^9, 3.7890323630796475`*^9, 3.7891961946434593`*^9, 
  3.789266191878838*^9, 3.7896457261215305`*^9, 3.789900460877115*^9, 
  3.7969698318376226`*^9, 3.802074551691559*^9, 3.802246547844943*^9, 
  3.802274509675976*^9},ExpressionUUID->"7deaaa6e-b666-4051-a8f1-\
2f19ec63749f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"beta1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"0.01", "/", "2"}], "/", "\[Pi]"}], "*", 
   "omega"}]}], "\[IndentingNewLine]", 
 RowBox[{"beta2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"0.6", "/", "2"}], "/", "\[Pi]"}], "*", "omega"}]}]}], "Input",
 CellChangeTimes->{{3.773395455769121*^9, 3.773395470323947*^9}, {
   3.773395518403231*^9, 3.773395555266096*^9}, 3.773395745503042*^9, 
   3.7734885978006115`*^9, {3.789267781053629*^9, 
   3.7892677819896307`*^9}},ExpressionUUID->"6561d86c-04b9-45fa-8792-\
829b6ed1e86e"],

Cell[BoxData["0.006432170446587575`"], "Output",
 CellChangeTimes->{3.773395556389298*^9, 3.773395746641844*^9, 
  3.7734872508565702`*^9, 3.7734885995557117`*^9, 3.7734892929193697`*^9, 
  3.773490856462799*^9, 3.7735473320497417`*^9, 3.774110093488761*^9, 
  3.7890323657658014`*^9, 3.789196196203462*^9, 3.7892661947180433`*^9, 
  3.7892677833936334`*^9, 3.7896457288437676`*^9, 3.7899004616541595`*^9, 
  3.796969831892626*^9, 3.8020745526411915`*^9, 3.802246548603443*^9, 
  3.8022745104164705`*^9},ExpressionUUID->"72d0a372-96be-4057-a975-\
39f38ca2d0e5"],

Cell[BoxData["0.3859302267952545`"], "Output",
 CellChangeTimes->{3.773395556389298*^9, 3.773395746641844*^9, 
  3.7734872508565702`*^9, 3.7734885995557117`*^9, 3.7734892929193697`*^9, 
  3.773490856462799*^9, 3.7735473320497417`*^9, 3.774110093488761*^9, 
  3.7890323657658014`*^9, 3.789196196203462*^9, 3.7892661947180433`*^9, 
  3.7892677833936334`*^9, 3.7896457288437676`*^9, 3.7899004616541595`*^9, 
  3.796969831892626*^9, 3.8020745526411915`*^9, 3.802246548603443*^9, 
  3.8022745104184675`*^9},ExpressionUUID->"25475740-5ca6-44e2-8e66-\
d865c705b13b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBeta1", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}], "*", "2", "*", "beta1"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "xmax"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733869761393967`*^9, 3.7733869835182095`*^9}, {
   3.7733874910131626`*^9, 3.7733874949287696`*^9}, {3.7733952668371897`*^9, 
   3.773395268833993*^9}, {3.773395576482133*^9, 3.773395603641781*^9}, {
   3.7733956825951276`*^9, 3.773395682735528*^9}, 3.7733957254726067`*^9, 
   3.773488142096546*^9, 3.773490333206871*^9, 
   3.773490452746708*^9},ExpressionUUID->"c4bdbce6-2c3f-4c9f-be34-\
3fd06da9aa20"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7733870713151636`*^9, 3.773387503134384*^9, 3.7733956111453943`*^9, 
   3.77339568374953*^9, {3.7733957321962185`*^9, 3.773395748357847*^9}, {
   3.773488137735297*^9, 3.7734881459577675`*^9}, 3.773488601905846*^9, 
   3.7734892948764815`*^9, 3.773490474762967*^9, 3.773490857395853*^9, 
   3.7735473356221476`*^9, 3.7735576159324427`*^9, 3.774110099122083*^9, 
   3.7890323688859797`*^9, 3.789266202533657*^9, 3.789645731903451*^9, 
   3.7899004643103113`*^9, 3.7969698342917633`*^9, 3.802074577655789*^9, 
   3.8022465505757513`*^9, 
   3.802274513337407*^9},ExpressionUUID->"35066469-0b29-4229-93eb-\
5f5022231674"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBeta2", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}], "*", "2", "*", "beta2"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "xmax"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.773387270901914*^9, 3.773387273351118*^9}, {
   3.773387337342431*^9, 3.773387343473242*^9}, {3.773395274590403*^9, 
   3.7733953049636564`*^9}, {3.7733955865441513`*^9, 3.7733955885409546`*^9}, 
   3.7733957288266125`*^9, 3.7734881439516525`*^9, 3.7734903346699543`*^9, 
   3.773490454691819*^9},ExpressionUUID->"0c5cf978-0541-4de5-8b0e-\
5be85aaae4ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.773387275675523*^9, 3.773387344736844*^9, 
  3.7733956148738008`*^9, 3.773395686557534*^9, 3.7733957333506203`*^9, 
  3.7734881478428755`*^9, 3.7734886028739014`*^9, 3.7734892962185583`*^9, 
  3.7734904756680193`*^9, 3.773490857984886*^9, 3.7735473376657515`*^9, 
  3.773557616977644*^9, 3.7741101007361755`*^9, 3.789032371306118*^9, 
  3.7892662054196615`*^9, 3.7892677872312403`*^9, 3.7896457346086054`*^9, 
  3.7899004654043736`*^9, 3.7969698352098155`*^9, 3.8020745794029484`*^9, 
  3.802246551610442*^9, 
  3.802274513833734*^9},ExpressionUUID->"bf02a6e6-35da-4919-b80f-\
f84bf4eb9519"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBeta1vary40", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}], "*", "2", "*", 
         RowBox[{"(", 
          RowBox[{"beta1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"beta2", "-", "beta1"}], ")"}], "*", 
            RowBox[{"HeaviApprox", "[", 
             RowBox[{
              RowBox[{"-", "ybeta1"}], "+", 
              RowBox[{"Abs", "[", 
               RowBox[{"y", "[", "x", "]"}], "]"}]}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "xmax"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7734879333376064`*^9, 3.7734879637503457`*^9}, {
   3.773487998482332*^9, 3.773488090452593*^9}, 3.7734881778485913`*^9, {
   3.7734883962710843`*^9, 3.773488396355089*^9}, 3.7734903386951847`*^9, 
   3.773490459164075*^9, {3.7741102164067917`*^9, 3.7741102487116394`*^9}, {
   3.802074788059089*^9, 3.802074835575595*^9}, {3.802074919308093*^9, 
   3.802074941307691*^9}},ExpressionUUID->"351e3f8f-c901-44fe-84ed-\
0eebb9591b3d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "mxst"}], "MessageName"], ":", 
  " ", "\<\"Maximum number of \[NoBreak]\\!\\(10000\\)\[NoBreak] steps \
reached at the point \[NoBreak]\\!\\(x\\)\[NoBreak] == \
\[NoBreak]\\!\\(17.70428083255622`\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/mxst\\\", ButtonNote -> \
\\\"NDSolve::mxst\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.802076002295826*^9, 
  3.8022465740965924`*^9},ExpressionUUID->"6e8bb97c-cd83-4c3b-9e5e-\
a28c34c355ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "17.70428083255622`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.773488297884457*^9, 3.773488438472498*^9, 
  3.773488645131318*^9, 3.773489328080381*^9, 3.77348971933976*^9, 
  3.7734905559926133`*^9, 3.773490952059267*^9, 3.7735474228263006`*^9, 
  3.7735566811164007`*^9, 3.77411039104578*^9, 3.7890324074471855`*^9, 
  3.789266237883319*^9, 3.789267807214875*^9, 3.789645752883917*^9, 
  3.7899004830903854`*^9, 3.7969698519037704`*^9, 3.8020760022978272`*^9, 
  3.802246574099596*^9},ExpressionUUID->"876efcd9-833d-43fa-8037-\
1390218f85a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBeta1vary40", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}], "*", "2", "*", 
         RowBox[{"(", 
          RowBox[{"beta1", "+", 
           RowBox[{"beta2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"HeaviApprox", "[", 
                RowBox[{
                 RowBox[{"-", "ybeta1"}], "+", 
                 RowBox[{"y", "[", "x", "]"}]}], "]"}]}], "+", 
              RowBox[{"HeaviApprox", "[", 
               RowBox[{"ybeta1", "+", 
                RowBox[{"y", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], ")"}]}], 
        "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "xmax"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8020761134912434`*^9, 3.802076122361128*^9}, {
  3.802077088845044*^9, 
  3.802077096750287*^9}},ExpressionUUID->"a19c7e75-008d-42ab-9476-\
6060b3c8b86c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.802076138902388*^9, 3.802077112979998*^9, 
  3.8022467430401974`*^9, 
  3.802274530973107*^9},ExpressionUUID->"88b15e2c-9bf1-44c3-93cb-\
afced771fed5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBeta1vary20", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}], "*", "2", "*", 
         RowBox[{"(", 
          RowBox[{"beta1", "+", 
           RowBox[{"beta2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"HeaviApprox", "[", 
                RowBox[{
                 RowBox[{"-", "ybeta2"}], "+", 
                 RowBox[{"y", "[", "x", "]"}]}], "]"}]}], "+", 
              RowBox[{"HeaviApprox", "[", 
               RowBox[{"ybeta2", "+", 
                RowBox[{"y", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], ")"}]}], 
        "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "xmax"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7734895539503*^9, 3.7734895590455914`*^9}, 
   3.773490340118266*^9, 3.773490462290254*^9, {3.774110272117978*^9, 
   3.7741102813835077`*^9}, {3.8020760340335197`*^9, 
   3.8020760470241413`*^9}, {3.802077122328201*^9, 
   3.8020771296380577`*^9}},ExpressionUUID->"28308c69-14c7-4c6f-922e-\
184b2b38984b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.7734895913424387`*^9, 3.773490592698713*^9, 
  3.773490989296397*^9, 3.773547456069959*^9, 3.773556714063658*^9, 
  3.774110433328199*^9, 3.7890324204729304`*^9, 3.7892662497237396`*^9, 
  3.7892678143284874`*^9, 3.789645763393121*^9, 3.7899004906628184`*^9, 
  3.7969698591631856`*^9, 3.8020760555708113`*^9, 3.80207713884116*^9, 
  3.802246922633647*^9, 
  3.802274537650541*^9},ExpressionUUID->"b4ac6bb0-6c95-4035-96ed-\
d6d25210d258"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1vary20"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1vary40"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"3", "*", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}], 
   ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", "\"\<Angle,rad\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7735477499900756`*^9, 3.773547766666505*^9}, {
  3.7735618863487186`*^9, 3.7735618876435213`*^9}, {3.802246760068071*^9, 
  3.802246766415719*^9}, {3.802246857974068*^9, 3.8022469037033997`*^9}, {
  3.802246953037466*^9, 3.8022469806998253`*^9}, {3.802274524044511*^9, 
  3.8022745268373632`*^9}},ExpressionUUID->"9e3a6ae7-b491-455f-98d9-\
f3a62d1688cf"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUV3c81d8bl5U9r3VRkSghNL/Cc8gokpIkpJIQJUkoIzKy17XJnsmeWUdW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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwUV3c8lt8btvd48fJab1RSJJmVkvs0CBWSpJIiDSmEklCRLSN77703GR17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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox["\"Angle,rad\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{752., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.773547756698087*^9, 3.773547769209309*^9}, 
   3.7735567142820587`*^9, 3.7735618888135233`*^9, 3.7741104336022143`*^9, 
   3.7890324205569353`*^9, 3.7892662498017397`*^9, 3.7892678143908877`*^9, 
   3.7896457654666233`*^9, 3.789900490749823*^9, 3.796969859253191*^9, 
   3.80207618087151*^9, {3.802246905311465*^9, 3.802246928400473*^9}, {
   3.80224696262783*^9, 3.8022469816014194`*^9}, 
   3.802275187619422*^9},ExpressionUUID->"66d3e600-e593-4512-a8ea-\
33cf5a5c5af6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1vary40"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"3", "*", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{
  3.7735623058863735`*^9, {3.789266309191044*^9, 3.7892663097370453`*^9}, {
   3.78926677931347*^9, 
   3.789266779843871*^9}},ExpressionUUID->"70cdc4ba-840e-4464-af45-\
bea3d66be0af"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUV3c8lt8btvd48fJar6QiooyUBvdRUlK2EtLyTUkSIlmZGRnZM15b9t4d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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwUl3c81d8bwO29XesaKaUUlYpCeQ5FSbZSaFAqKiqVZCQys1dkRsjeMxyy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{623., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7735623077115765`*^9, 3.7741109912591105`*^9, 
  3.789032420623939*^9, 3.789266310813447*^9, 3.789266782386675*^9, 
  3.789267814453288*^9, 3.7892678669161797`*^9, 3.7896457693968477`*^9, 
  3.7899004908228273`*^9, 3.796969859322195*^9, 
  3.8020762072790337`*^9},ExpressionUUID->"84170a63-a12b-41d2-8cd9-\
f1cd4364fc7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"x2min", "=", "0"}], "\[IndentingNewLine]", 
 RowBox[{"x2max", "=", 
  RowBox[{"3", "*", "\[Pi]"}]}], "\[IndentingNewLine]", 
 RowBox[{"N2", "=", "300"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x2min", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x2max", "-", "x2min"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"N2", "-", "1"}], ")"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"i", "-", "1"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.789272505397127*^9, 
  3.7892725072067304`*^9}},ExpressionUUID->"e951641a-84cd-47bf-9876-\
c096dbda7e0e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.789272699336668*^9, 3.7896457970015936`*^9, 
  3.796969859366197*^9},ExpressionUUID->"c0b7ec2b-3676-40fb-bc93-\
36abae46a937"],

Cell[BoxData[
 RowBox[{"3", " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{3.789272699336668*^9, 3.7896457970015936`*^9, 
  3.7969698593681974`*^9},ExpressionUUID->"4496f600-b627-4a19-ae0d-\
1db986a78c3c"],

Cell[BoxData["300"], "Output",
 CellChangeTimes->{3.789272699336668*^9, 3.7896457970015936`*^9, 
  3.7969698593701973`*^9},ExpressionUUID->"b9cc6b29-855b-4ce0-9ba9-\
42092b664d1a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sbetavary40data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1vary40"}], "]"}], "/.", 
       RowBox[{"x", "->", 
        RowBox[{"x2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sbeta1data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1"}], "]"}], "/.", 
       RowBox[{"x", "->", 
        RowBox[{"x2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.789272624924537*^9, 
  3.7892726589013968`*^9}},ExpressionUUID->"e6d16ac7-7995-40bf-ab4b-\
ae0229254934"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Solution_Comparison_Gen_beta.xls\>\"", ",", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"x2", ",", "Sbetavary40data", ",", "Sbeta1data"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7892726695250154`*^9, 
  3.7892726959046617`*^9}},ExpressionUUID->"1b1cf263-55c4-4b74-b9b9-\
06ce70902553"],

Cell[BoxData["\<\"Solution_Comparison_Gen_beta.xls\"\>"], "Output",
 CellChangeTimes->{
  3.7892727060914793`*^9},ExpressionUUID->"0bcdb296-ff20-4974-b19d-\
e04b1258015e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Pi]", "/", "40."}]], "Input",
 CellChangeTimes->{
  3.789267983557585*^9},ExpressionUUID->"8e620571-fd71-419b-b390-\
99a0fa60dcd5"],

Cell[BoxData["0.07853981633974483`"], "Output",
 CellChangeTimes->{
  3.789267984665187*^9},ExpressionUUID->"336b4c37-dcf1-4e22-9b3a-\
5cb272e8d5d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"x2min", "=", "0.0"}], "\[IndentingNewLine]", 
 RowBox[{"x2max", "=", "0.08"}], "\[IndentingNewLine]", 
 RowBox[{"N2", "=", "300"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x2min", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x2max", "-", "x2min"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"N2", "-", "1"}], ")"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"i", "-", "1"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.7892702862464294`*^9},ExpressionUUID->"e8830886-0d10-4933-82e4-\
f4800d70f848"],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.789270277728814*^9, 3.7892702879624324`*^9}, 
   3.796969859433201*^9},ExpressionUUID->"91d97b1f-312e-486d-814b-\
4d2b97b915b8"],

Cell[BoxData["0.08`"], "Output",
 CellChangeTimes->{{3.789270277728814*^9, 3.7892702879624324`*^9}, 
   3.796969859435201*^9},ExpressionUUID->"78056c9b-08d9-4d23-8440-\
8c263763a36a"],

Cell[BoxData["300"], "Output",
 CellChangeTimes->{{3.789270277728814*^9, 3.7892702879624324`*^9}, 
   3.796969859436201*^9},ExpressionUUID->"896d6260-d81b-41ef-9411-\
b90cbd20d970"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1vary40"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.017", ",", "0.02"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.77339564980387*^9, 3.7733956690075035`*^9}, {
   3.7733957012995605`*^9, 3.7733957025943627`*^9}, 3.773488123605489*^9, {
   3.773488454353407*^9, 3.7734884781107655`*^9}, {3.773489577576651*^9, 
   3.7734895967307467`*^9}, 3.7734903420163746`*^9, 3.7734904663644867`*^9, {
   3.7734908335084867`*^9, 3.773490837112693*^9}, {3.7734910178190284`*^9, 
   3.7734910589753823`*^9}, {3.7735475179864683`*^9, 
   3.7735475239612784`*^9}, {3.7735476464682937`*^9, 3.773547721145625*^9}, 
   3.7735563392574*^9, 3.789267760601993*^9, {3.7892679422487125`*^9, 
   3.7892679444327164`*^9}, {3.7892694603809786`*^9, 3.78926946091138*^9}, {
   3.789269690013382*^9, 
   3.7892697329290576`*^9}},ExpressionUUID->"9e7d6433-8aff-48ac-85ec-\
ab224db65c51"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwV0X1UzFkYB/DBLjtzorVaGdlTKdueMN6WbUf1XdHqhUzjELNKi+hFehGl
F0Wlctpy7/1RFDq2UpTCOk3UslklmbLLUF5S07A6UU1nZSaH9u4f9zzn88f3
uc9zr+2WCGXQWJFItJqf/6ubWHYxOpjA31uzfPNKAsc2RFZz5w2HmxVyTznq
O6+f++FVibadW2+zpzIkhECZ47Rd6UGQ7lRXHhhK8CIwKNPdk+D2Dq8zPjsJ
Ui6Ouzvbm8CncTtzjCQ48UqpMPoQ/JR6eo8ulkA0IF9N1hOELb1bdCqTYNKx
DHfJDoI7tkF613yC3FR9RtheAtXLjqojZwkqrJwVyekE3a/EOpma+/rou46j
BDXS0jkXmwis9SnGGSUEaZkfniW3E8j0V1tKrxAc1M63FPUSHH/QY91zi6BN
cS94m5HgSufTJxO0fD/JbNsvxRSxldWq3S8ISgwGQ/k0Ct1hkWfTvwQhNYLX
oANFo2Vek2Ychf21IXGqE8XgaJppugWF7E1dt2klhQ+pKFfYcfu72dRvoJBW
hIo0iygCz//6ckEIxda2AN375RTdDlG3DsdRjNtU7TtlLcVGnUkyP4tiRXy5
X9RWCuuW/uDafApt5W9DNdEUTw2n5uaWU/g7ZVm6p1K0DDvGT71KMaZ7kSaN
UXzmaPf8QDPF31VLHCrPUDgXPDz3/WOKZd4DI1aXKa7Lh3O0vRQuKxvjdzdQ
xKgNIzNNFP3nRk8k/cXviynT1IkZ9tp8N6u1m88d0KKWSxkU7xJDJxgoJIfK
JZ86MlTaac0yxjDMzd6qT5EznNy1y6t2MsOpG1kPuzwZzAPClQ9sGMYvCpv3
i4ph1Ed1dvEChvr76qKvQhmiHie0Jv/AUKLUHd+8j8HHPbEocQ1DmnmT6U0W
Q/bQmarrmxkujVhGBx5ncCv8eLpvF8MjO3tf63MMwbkZN/yTGbwTCj0aahks
Jn59R53DMFg92DS1mcHwuSqt8STvYy+6UNPBkFjWFjD9AkNsY0KFcy/P2yct
8Ktn2Fh6afKkET5HwzrLxxqGndtufTwiEQA7WmbeydCqWPGJUSqgdPTIMtkb
BoeE/ZHnHQWYp/z8jH5gaLtv/9ZNLkCb/yyzy0xAmeTsmGxPAb0Hcwe6rATE
JetjbFUCahdaejrMEZA3M0dUECLghSnxj/VLBawKL5V2cee8dsk9wS1S/75w
VqiA9kbTpk7u0NUD26q4sXCLMchZgGucovlmmABNz1vZHhcBLzVf0NfhAmoq
vylgELBkX56da7SAOdeuRdxbLqDvZpVzKnddfoezxQoBRZNur7vNvc5/SLyB
W1JszFDuFpBdYFH8nLuzdePr7TECDvVZtfe782o/40ruXgHJ2sWY6CFgacS3
rQ+4fW3HmvlyD9au+kcay3Nrm9sFbtWaJGkx97Rwj+gZ/B1k8Z1J6jiejxCX
zPYS0PPn8LEP3CWDFVER3Pnm5tVu+wQEbvB2vcw9tgS6u9wHnsQ9knvzvQb8
3k+O5/2HJxTv594pj7Tw4643ksgGbpv0zLmF3NO6p7qMX8X/oa3ox27uvqpj
Yi/u/wAkr06M
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwVz3tUzGkYB/CRcsxEHV1kzi66zIq2ppTFTvHdk1xyaZO1SJbWDDVdVDO2
CEkht+r3vu+iE2m7oKxUK03CIsRGLZpa1tjKsG6lSCpi3/3jPc/5vOd5zvN9
HH5cF6QyEYlEC/j7v/qK5WVxYQLCzZ9Xa5UCXBoQU8pt8J0WVM5t/fNC9w7u
IlXG01fcRvv1J8PDBUyK8rCNUAnYPvVc0Sq1gMoUVXToGgHX187NC4gU4F2X
bR/A5wKuraEuMQLyiqemOvP/5SlH1rfFC3hv8JxzXyMgwvtmbk6agLib6fP2
pAr4w0FlnH5QgLBgjJUDExD85N6pzGN83kKfEpYvoPWpuE2uE/BLhWvY+9/4
XulR17JaAQ+mnLTW1AhITRswJP0loIOMk09uFLBN72EneiZgtavr62KjgIbA
P8OUvQLcrbTJpt38PsmXDrZiAkm+bWKRKUFhV1dX0SgC65zhvl42BOGVbG6n
M4Hd46oz0U4EsurX4pSpBN6bvIS3XgTy9nOtfbMJ/D5ZTQudwb3C1/78UgKN
j8m8Ud8RrDqR/2RiOMFl0WCzZCVBq3Ps1d0JBB8GDrN6DcGytj6Jxy4C0+b0
5LWpBGPrOsKqDhJkVnvPekwJHnTluGUUEVS+iFSWFBDU9bhsHHmWIOuDhceE
CoKhLk7/JN8gKFfqmtOuEPhkNxV/fZ8gytu60UtP8LuiJ13/jOBNe15JjZFA
q+vqd+wjcA35qDDr5vu0x2+dE1N0hs63I6YU0h/qdAopRbLasmmwDYVkR5HE
zIXi4oCh5aKMwm3vauNWBcUD7dVs968oci7uamrxp5hinjYtxY9iiFeE+75g
ihUlYeMcF1Ocv6vLHa2mWFmwsrdQSVEY1Ja1cgNFdOXjLX9rKFIta/vad1F8
Iy+bHZJKUd5vF7cqiyLTvH3gEqVodpItHFtMkd0f+zqugGJe4qE5l6soNONL
moae5rlLO2tH3qBYdqY/JrCGYq9MVFJ5jyLR7Yjfo7sU8dcSf/V5RqHfHTFs
+SPed7R8hEU/BWKTxGO6KSKVVz9mShjGG1rOElOG+kA/014pw6U3g1QvrRmc
E7fEnHBhKMv3hyBjaLgre+urYJidVGjz2SSG45Jjg/b6M0w8/S7v+xkMCUlG
rUMww6YsVYhhEcMBx3RRdjiDw8Q4W//VDPOjjkpbuEd05Xfu4xbpLnh+oWbY
Mbqx7g63esEr5Snu59Xu20KUDNMTAm/URDCILRo71qkYntyyIi+jeN7Bt2v3
r2WYvOGA0/Q4htHDDyUYed+LmlM+KdxnF2UvmhDJkGtxffF17ilDsuTR3JKC
3p1BGn5fSYbxHffD+mUv12gZtg5XB5pH8xyyzysyfmLwGLjj7BnD4L1uUn0j
d/wnnUk8d2fV/H+l8QwBUYcN1dzB326WFnDTPaF0ZiyDfOPDzboEhu7bTR+X
8r2PrvTsH+Ae51F67zD3QUvLUt8NDBf6dp5u4zYpRNtN7mENnupInqvy1ZL3
Izbyet9sZhl3pCLGZgl3xcLmsT3c9tvT3A5xf/I61q/gufUNubNauYXk9fok
7v8ASfJJSA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.017, 0.016900000000000002`},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{643., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7741109962783976`*^9, 3.789032420673942*^9, 3.789267945821119*^9, 
   3.7892694620345817`*^9, {3.789269691698185*^9, 3.789269733943059*^9}, 
   3.796969859478204*^9},ExpressionUUID->"5140093e-ba51-481a-a164-\
595698f93c43"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sbetavary40data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1vary40"}], "]"}], "/.", 
       RowBox[{"x", "->", 
        RowBox[{"x2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sbeta1data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1"}], "]"}], "/.", 
       RowBox[{"x", "->", 
        RowBox[{"x2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Difference", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sbetavary40data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "-", 
      RowBox[{"Sbeta1data", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7892703182108855`*^9, 3.789270319162487*^9}, {
  3.7892715194753957`*^9, 
  3.789271585057911*^9}},ExpressionUUID->"c13c14fe-b0bb-48db-b446-\
f65b40f0ffb6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Re", "[", "Difference", "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",ExpressionUUID->\
"9b3c9abf-33ff-4a7b-ac8a-ca0faf5295b4"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxV1nlYjXkfBvCfyoRCkqU0HCQpkZ1SvlGylJIUrY/2VYul8BoPWbINMiox
HISypMkylqEHKdsQETXxnsrUiDFExDS837nc/7z94/pc9+9+7uc5nZPTNzje
M0xLCDG4jRD//vv15/UE8f8/JJTP+yxGBV36ynZs/ydG+t/BBiTKfO9klm6F
jUiQz+FflR/hniQKhJ3DmMOwKQmLDr+YnCqAVSRyCo2zzp2B+/H1T+9uf+wi
bEbCqE9SwbUrsDmJ1YG/l1qVwhYkNBetnNrdhi1J2FbrbzleBg8mEZ7sODC9
HB5CwqnZvOGnCtiG73do51v6VfAwEl6tx+/sfwIPJ/HL7eb35zTwCBL1W9MN
lVp4JInrbsvO1j2DR5F4MEWrwawBHk2itiJ4d+pzeAyJbwYdqvjyAh7Lz2O0
fvvOV/A4Ei6TfCNzX8O2JA6Xdy4xbILtSGRsqKvZ+BYeT+J47/vnuzbD9iTy
/B65H3kPO5AYWPZqr3sLPIFfj2VGR7Q/wcT3s8w5ruTvr5bZ87sm/5H5D3JH
EkfiY01SviBn35skVp4URV/ziSTc803cC9t8tczOvqKXfFYL+SQS40o9Wq5p
I2c/LnC/X6WD3InEqQhvnQ9tkbNzv1zebKKL3JmEsGqNc26HnJ2XuCAnuT3y
ySQuH86w+akDcrZJaFmXJj3kLvx+e7HKxbYjcnafBUb31ndCPoVExfnm45rO
yKeQnDblxvy9BsinkjiRkjfUswtytrTWfWc7Q+TTSOieTjx6BZbZts9Kw+Su
yKeTvLr6Y6mjEXJ2F/PCe990Q+5K4qrf4VV3YZkt39xetas7cjeSl9QOrozp
gZy9ONfkuwk9kc8g0f5D8/XuxsjZVnHSuTewcOff/zIt9zIT5Oyg+LXrC3sh
9yDRcCYjMsv0q4lt3rv6xcpvcZ69x7TVML73VyvsnT9kPwnqg/5MkneMOjHA
UoX+TBKRVz5YH4JlzpNNl+ma9UWf87NpHQsPwMKT5H7OqdYD+qHPtptVsCQX
ltnOpREZ1v3RZ5cELE89BYtZJJuYlZC9Gfrs4zd63CmFZbb/CxcrrwHos5cG
WM2phYUXyTrn56UkmaPP3tvP00lnIPrsY/39azJhxYvEIv0SN2sL9GeTXNh8
Ym0xTLP59d+ktTVgEPrsjv0yIlpghc9rP5qot8MSfW+S3Qa1XTHCCn32BbfW
onJYZlenOd5eNBh9b37/567LMbZG34d/v17K1CKY2CVPvS+GD0Hfh+Tvy20+
dx6KPnviq0K9C7CYQ+QQ+1vTCBv02ckZ2pM3wvIcUqYPtF5RByvs5nLbPeOH
oT+XFK/LBgcyYJpLwkxr8+Y3sMz5/U7bAtyGoz+XZHl0q+ERWPjy5//nguO6
I9D3JcWpMss6HJZ9iXI02enXYMWX5PJV2dUDRqLvx3/P81fprYPJj+igrX2f
57DsR8qfD0/2cB2FPufFaXffnYCFP1HGmQVnjEaj709Ki/Ma/6Ww7E/C8vjL
eg2scL7Qc+PsKWPQDyA5z4NyC2AKIPEw/tVT47Hoc575n5SPqbDC+fYNRR9e
wSKQ5IZ9Byt9x6EfSKJ8jv7eUljm/Bk9dBlliz776r7a8gOwCCLR86rRpK52
6AeRbOkwY0cqLLPPDEm8+Q5W2K36/rXh49GXSMRve1VdCavYrn+1O+9mj+ux
I95tXHIFltgHgkaajnXA9SWSXQJX7c+H1exL33XvYD4Be+yhn70998Aaiah0
4p+X9Aj780iuOv/y2hRYxc5VhP1amOaRkllz3KwYlthV/kHLtRyxP49I13Xm
ZEdYzf2OziNlGVb4fHcp2lKBNXx+1lzhLCZiP5jfLznDywhWBZOS99751kqY
2B2ONY2+Ckt83jcy3bDtJOxz3hqmCnSB1ey397uYbIAV9lLfNc6/wppgEuvH
Dq8xcMJ+CClbDhW99IJV7DKpPGInTOwHE6bOegpLISTXjRyf398Z+2zNzaUp
UbCaXVqSVngCVkJIXLr7zO89rOF805PGhfaTsR9KlDu00z+rYVUof5/RKXh3
G6ZQkgcfc/Dr5oJ9zs19pg0LhGXux8w3WXwYVrOPVt8Z9AZW2G1WHnO1m4L9
UFL2H/7jyRpYhJF87rvJT8tgVRjRJ8tRbqZTsc+26JNjGQlLYaRs62mTfAqW
Oe9vWDWszTTs8/VeFrT6zoAVPr/OtLlpF6zh8/mxJS3PYRFOyp2wb+LGTsc+
u6Xyqvs6mMKJMk/2UFfAUjiJ0PqyQHNX7HO+5Un5xsWwmvP0vF7mpbDCvlQR
MKSnG/bZxXYPc6JgEUFK45CYtAuwij3LfFNlxxnYj+DPWy8lS4KlCJLrzd8X
n4RldvKYyYG67tiPIJrQsDjMD1Y433dra+UJWMPX0422CtDywH4k//8tHHSs
YVUkaZZX7KnxgYk9IvSH5lWwFEk0tLhhQj4sR5KS7ZelVMLqSFJP6FaS3HYm
9tlOWX3DhsGaSFJtjWpKC4BFFMndPjXWrodVUaTuFTxywRmYokgZ/PuBcXWw
xLkIchxt4In9KP7+tKw50h5Wcx5y+/C9aFiJIs2W/IiELFgTRVLRpRanElhE
E9VEhLu/g1XRJNXM/n5Lv1nYjyaVKm1N25mwFE3qG6ctfloBy9H8fV0/NT0f
VkeTZkb5/LwnsMLn2x363Kzvhf1okpsGuKeMh0UMiVcad5tYWBVDKvWnD9/u
himGNPlDyfE2LMWQ9MpEld0KyzGkPK9fZ2E9G/vcX/Up4mUArPD1L6w/+vv3
sCaG5J3pDkYKLGJJ/q1eL+UNrIolxfHxF4P+3tiPJXoS1OG/XrDE+Tg9k9q1
sMz9sTsHmpyD1bGk+fnvgetewArnhx71HNTbB/uxpLI7+v6LByziSP1wS5He
algVR5Kzd5LrzzCxQ/7Uu9IIS3y++7i1sb3nYD+OxLXq36Z7wmrOryd8CVoL
K3FEt07V556HNXGkaB7L5n/BYj6/3m5Fj/vPxf58UndpTC+aA9N8krPtXlZt
hiU+7/HDBcursMz5P+/e5bfAana7Dpsihvhifz5/X3BZ6BUKa9i9vt2/KBsW
8SR8enW4VQar4kl+euRHL10/7LONq10NHWCJz58Kbq+zCJbjSdGZqQw6Bqv5
fF97KbUOVthLqioNevljn/sfh/W+7wmLBFK0jfuXboANEogSv/zx1xVYxfms
nATXv2Eb9vYHSvWIANwfu9y7Th0Le3C/LqE26yAscV42uLT4KZzAdjqYbtYz
EPefwH/fnB3PzoS3cn7kzOUVG2F1Ask1a5qWXoML2M13C/O+wAr3rbre1bMN
+uoy3u9u22nfQljD+cWYUVEn4NecP2vTMbQRFokk1+qfum4o4fkTSbNz9Y4U
G1iVSOrqG4ccZ8A2iUSX6t/0j4UpkaQSs9Q+G2APzpOSlozMhaVEEo+M3waX
wAn/5qY9jj6DZfa2wbodtefh+fn8rjfVaX1hNe+HLTjYm+CCRFJqlwTdCYQV
7k9v/zZzOVzGz3Ps86hlu2EN35/b6RfJF+DXfL2yVTc3V8EiieQWkfrLR9gg
idTnGq5pGwfj+dkJF9xCxsI2SaRamNRY5QNTElGfSWuik2EPzvc+sDDMhCXu
G1t2u38GTuDzsUUbj1TAMu9rRzTueg9v5fONXYoPdQ/B8/P1Cp7vuzUaLuDz
DtO09XxgJYk/X3nTwpJDiv4HI6m5rg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.789271628191986*^9},ExpressionUUID->"96b52b64-fb9f-41ef-b3c3-\
fd54f3ae2e7a"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7741110031287894`*^9, 
  3.7741110031587915`*^9}},ExpressionUUID->"108ff028-c201-4457-93af-\
668ede7aef29"],

Cell[CellGroupData[{

Cell["Conclusion : there is the difference but very small", "Subsection",
 CellChangeTimes->{{3.7735480995106897`*^9, 3.773548120024726*^9}, 
   3.773548200037266*^9},ExpressionUUID->"8eb4542b-c7a4-42e7-ba24-\
f7122aa1c3f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBeta40detailed", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}], "*", "2", "*", 
         RowBox[{"(", 
          RowBox[{"beta1", "+", 
           RowBox[{"beta2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"HeaviApprox", "[", 
                RowBox[{
                 RowBox[{"-", "ybeta1"}], "+", 
                 RowBox[{"y", "[", "x", "]"}]}], "]"}]}], "+", 
              RowBox[{"HeaviApprox", "[", 
               RowBox[{"ybeta1", "+", 
                RowBox[{"y", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], ")"}]}], 
        "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3.5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733880192423024`*^9, 3.7733880613795843`*^9}, {
   3.7733882174266586`*^9, 3.773388223027068*^9}, {3.773389441958849*^9, 
   3.77338944292605*^9}, {3.77338965369424*^9, 3.773389660885853*^9}, {
   3.773548212517288*^9, 3.773548252047757*^9}, {3.7735483711383667`*^9, 
   3.7735483800615826`*^9}, {3.7735484899481754`*^9, 
   3.7735484919293785`*^9}, {3.773548746662226*^9, 3.773548751857035*^9}, {
   3.7735488519312115`*^9, 3.7735488552072167`*^9}, {3.773549505650359*^9, 
   3.773549511266369*^9}, {3.773549556662449*^9, 3.7735495879093037`*^9}, {
   3.7735496787950635`*^9, 3.773549681135068*^9}, 3.7735498844814243`*^9, {
   3.773549945477532*^9, 3.773549980156393*^9}, 3.773557711888211*^9, 
   3.774111041718997*^9, {3.7899006067424574`*^9, 3.789900637590222*^9}, {
   3.7899014926946826`*^9, 3.789901494159766*^9}, {3.8020763393582053`*^9, 
   3.802076343654057*^9}, {3.802077281241592*^9, 3.8020772995327144`*^9}, {
   3.8020773692872653`*^9, 3.8020773716078024`*^9}, 
   3.802077503339714*^9},ExpressionUUID->"27131c67-b0f2-4644-8776-\
3c1dd2cdfc47"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "3.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7733880533681664`*^9, 3.773388163200963*^9, 3.773388317906435*^9, 
   3.7733894461864557`*^9, 3.7733896635534573`*^9, 3.773548260939773*^9, 
   3.77354840725243*^9, 3.773548513941017*^9, 3.7735487716690702`*^9, 
   3.7735488766260543`*^9, 3.773549515259976*^9, {3.773549565960065*^9, 
   3.7735495912477093`*^9}, 3.773549684239473*^9, 3.773549888194231*^9, 
   3.77354996142076*^9, 3.773557724539833*^9, 3.774111055909808*^9, 
   3.789032877276058*^9, 3.789900502441492*^9, 3.789900644830636*^9, 
   3.789901496566904*^9, 3.796969860581267*^9, 3.8020763470132866`*^9, 
   3.802077304953315*^9, 3.8020773770974426`*^9, 3.8020775138216696`*^9, 
   3.8022515234203773`*^9, 
   3.8022752482233086`*^9},ExpressionUUID->"ea4192d9-0364-4ac4-97af-\
60bda29878e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Vary40", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1"}]}], "\[IndentingNewLine]", 
 RowBox[{"Vary20", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sBeta2"}]}]}], "Input",
 CellChangeTimes->{{3.7735564706096306`*^9, 3.77355647599164*^9}, {
  3.7735569102652025`*^9, 3.773556915865613*^9}, {3.773557008857376*^9, 
  3.773557068808281*^9}, {3.773557345069166*^9, 
  3.7735573507163763`*^9}},ExpressionUUID->"e6476642-3678-4f3e-9a94-\
3b94ff08d1f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7735564773956423`*^9, 3.7735567768537683`*^9, 
  3.7735569164272137`*^9, 3.7735571312863913`*^9, 3.7735573546943836`*^9, 
  3.773557622968055*^9, 3.774111163939987*^9, 3.7890328773720636`*^9, 
  3.7899006776245117`*^9, 3.7899014983020034`*^9, 3.7969698606412697`*^9, 
  3.802076372570244*^9, 3.802077308155436*^9, 
  3.802077384697486*^9},ExpressionUUID->"75badad4-18f5-46f4-84f0-\
b0498eac5286"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7735564773956423`*^9, 3.7735567768537683`*^9, 
  3.7735569164272137`*^9, 3.7735571312863913`*^9, 3.7735573546943836`*^9, 
  3.773557622968055*^9, 3.774111163939987*^9, 3.7890328773720636`*^9, 
  3.7899006776245117`*^9, 3.7899014983020034`*^9, 3.7969698606412697`*^9, 
  3.802076372570244*^9, 3.802077308155436*^9, 
  3.802077384700487*^9},ExpressionUUID->"d4d5632f-7b8a-4b8f-ba7d-\
b4e8e560aea0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DirVary40f", "=", 
  RowBox[{"D", "[", 
   RowBox[{"Vary40", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"DirVary20f", "=", 
  RowBox[{"D", "[", 
   RowBox[{"Vary20", ",", "x"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7735569641944976`*^9, 3.7735569747869163`*^9}, {
  3.7735570386690283`*^9, 
  3.773557081615904*^9}},ExpressionUUID->"0c973755-3c32-44b7-9058-\
67cff6f5dfde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.773557132908794*^9, 3.7735573558175855`*^9, 
  3.773557624231657*^9, 3.7741111666681433`*^9, 3.789032879159166*^9, 
  3.7899006788215804`*^9, 3.7899014989510403`*^9, 3.796969860730275*^9, 
  3.80207637417531*^9, 3.8020773098435564`*^9, 
  3.8020773853208995`*^9},ExpressionUUID->"db7cfdf3-f11c-437b-aca9-\
2488e84ed1dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.773557132908794*^9, 3.7735573558175855`*^9, 
  3.773557624231657*^9, 3.7741111666681433`*^9, 3.789032879159166*^9, 
  3.7899006788215804`*^9, 3.7899014989510403`*^9, 3.796969860730275*^9, 
  3.80207637417531*^9, 3.8020773098435564`*^9, 
  3.8020773853239007`*^9},ExpressionUUID->"f01cb91d-b844-429f-860f-\
e11b09ecdf13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "DirVary40f", "]"}], ",", 
     RowBox[{"Evaluate", "[", "DirVary20f", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.1", ",", "0.55"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.773556536301346*^9, 3.7735565888578386`*^9}, {
   3.7735568052770185`*^9, 3.7735568714055347`*^9}, {3.773557097200331*^9, 
   3.7735571292895875`*^9}, {3.7735571599124413`*^9, 3.773557275711445*^9}, {
   3.7735573641168003`*^9, 3.7735573689528084`*^9}, {3.7735574373589287`*^9, 
   3.773557480321404*^9}, 
   3.7735576717961407`*^9},ExpressionUUID->"6d5527fd-a4ab-43ca-b515-\
0d1d64795ffc"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVjms01HkAht2SsdmWVFRaxoaWLmjRZL2STtgkNVolZXXRhe0+km2qJS2n
i1zW/VZpi1wWpcnhR3aEzDBpZJgZ/v9pUphka1IS2354z3OeL895LUIPbdqj
paGh4ftl/5Oy/qohI4OHguUlbzNCVQgvXORWeI0HZx8dz8chKrxnuteUF/Mw
paP+9GmHCjMWnrj7qJaHliVt14KCVHAy7rutpnhosj0kmMVW4aJGZZL/9w/w
qD4qL2ytCi6SbbsZNQ+Q67WTm2OtwpWEoulR0hqs5K7b5zk4jIGz1dsYG+uQ
kv/7b67Bw1DmCfM1fetxmFXg1d4+BM607HUIb4Bie/yAk+sQpCvyj4uvP0Rw
h8Byc9Ig4poTD+Y3NeKFEkvbB19B1+r+y0ZNPiY/t4obbV+hkMEytXFuwlVx
qrZ870vE+9+a1fDzIwTKXpV9+9cAPHb5plQkNuODosS1XPgC7hK5vLuqBXeH
zP4cmlAiWNwqRWcr1CeZlptslPDLUoVMMdqArkUudqzniONPlL61FUBT7Pav
W4ACSTyPGPe9Qhip2ZvNt9Coc1ToCzPbka7v1TPOpjCX4bLUK7gDV1/WZsfu
7AdLZpoZ8LEDh/VWOk3mynFGMXrgc4IIVmtSVZoZUpRtUHJFNk/gt0FbuD+4
ByMT54f5jU8Q+qHKO43ZDX/ZAsJmd2LrYWHict0u5DLbn84c7UQMnzl+uqoT
BpmRfntinkLaOFuSFSPCRbbAstdIjOdzn5gllwuhPua26nSpGLr2Q78Yjbbg
HL+wmocu2K78xmf9KT7Gom0imbIurGBWmazIrsfpE4GJxZHPYD51K0uZU41F
Bdyv26d3w25w5rI8jxLct69vX3ijG0YGxxaf5yQj4t2YWs9JgpvPGFyhzlXi
MC49MYsvQbAsL2IspIjQu2UuPiE9aDM4KA6X3SNVmk9D5o/2IEoyzCBSQo5o
v3hscrkXnJEeMtr8D9no/Dqr3FyKydS29xY+LQSl1/n7yqXY35OWkHtHQEwS
jjv4rpdhaKQ2oMFeRIzTV+m0yWSIbu7e4rizk4zrLzSNjJbjNp87taRKTN7U
l1zwmNOHjqjZnavfPyN6tx2Dbt3sQ41nKbIZPUQ3etAlx6IfiUXla4PcpSSD
dY9TeaAf1nnTyPA6OanKCqS2VvSjY/BjQJdZP/Es+yNijgYF+9qTWo7WFFH2
Otrle1E456eXY2JKE+MHYsPn3hTObCcVa8xo4pkeOWb9E4XW1erNv1rQ5Aa7
5mGZL4VR0yMuDxfTJFTgsZVsopDgVBG3m0WT/jr/OPl2ClZX7pgnB9Gkt+BQ
/4IjFGr1Ci6l5dBE/6xhU8hRCl3VEnllAU1YOyqLbxyj0HjS4X57IU0y541x
7DhfnCHR0i2lSWAy18A1mgJzdIY6vI4mXbGXWEHnKbyW3Pnhuz6a6O5aZp4X
9+WfMnjCRUETp9WiaYoLX/qusd6+AzRJ/WwsOpBAwfsNn3N8hCZsTnbYqSsU
2kT282qnaBLLdvOtS6TAzSkwFGorSKVDv4NWEgWbH/++LJ+uIEYjlpPxKRQ+
cNaaTs5UEA8BXyFIpeDcnWJlYKwgR4vDWgzTKBRlmfLmmyjItXhGWUA6hRo7
XsfiBQoiCitOycig8O5jYISzuYL8B0QJjJY=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwVk2k4FHgAh0chtPSQx7EhR86UJyyi/DSbLbXjanLFrhxZItuBSrWiiFjW
anO0OaJVhAfJUfNPGpIYY4xMY5h/jES7bW2y3dt+eJ/36/vlNQqL941cxGAw
WJ/539R8aWdRURtuWs6kKa2ZQ2yVqWtVRRvWJ348mWc1h9fGbh0NNW0IyNSX
17GYwxcGCdd7brVhpX9HganJHBw0J67M0zakHg566qw7h2xGU76PVTtid26N
91SYg5MoKEK5ox1Hp/L36EpmkZt1dcmRsQ54r6y9wzw7iycpN4KUvTmYKTz2
ap/gKWSlA2VyrNtInhEHmRk+RaLChS2I7YR6Zuya1OgZjNmXHRJeugPr46U7
5C88Qfq9vL1l3V2YdC+5Wy6chqJZ60yXHBe1Lp8C+xZkqFJ21rVw7IZIpHT4
oLYMmT7Vyzv9e3BkE52tdpsCM5xV0Jh3D48LW9V1fSfhJhofH23uhdu8+bLY
fY8RIrw/BsF95Dh6bJzKovAq+TP0k/IDOB7yi83KlSKd+77un9X9iJhI9/Bg
TiC/jZnmtmcAu/cufcL7SgKO3aTKQDEPkd/sLv6wWgxtZae1W0MGMTcdFiqE
CM4S3eKdbwahH6hlP7TqIX6afBHzIYuPt8zwu+mWQtR7yk7wLYZgpH/2vBpD
gOfvTz/jdg2BLVjvXy0ZhI9Ej7DZAghfdvMkHf24aMwbXvZCgNf6LpuSwnuh
WpzkFZk2DPfgpqzaHVxks/tNxBpCVKsp+B0L6MT8QVeX43VCaEab+C9Wb8dJ
btWNNowgTz/gU6RKIxaSLZKMJSNgW6+PkHVW4HhCQF5N0kPMRLp6DeTGwbT8
hBpvySga33XMMytKSOu62zyDylEYeppnWl2tI3GvFuaVHEQ4a5p6imdwg9i+
HUtYzhVByWnvLz21HPI4QuK0LfQRGh0GeNNhXaRZbjh0xYtHWPJsxTG+Xg/Z
v3i6T+dnMVqkVlc2aPcRb8e/ShoMx+BR3lvtxRkgqLvE/aFhDD9t6YnONOIT
naxDtqxvJRg1FjVnMAREs9BF/oFEgtJFTB2dlmHyVsVANyl5HArhaSkBp0fI
37evZTC1JrA5PljvjNsoUbpit6v68gTG/mjR0hSIiGLyrNPvRlLc1Iv6zSZZ
TIqcWxKbYqR4o527W/XdGGkuCaCBjVKwZA78S1HjZHP9mTgtBoV1g9m/F2UT
RCa2sy7bSqGqof8g4aKUaLYL1ac8KBo9kRtZLiWbC5MWzLdTqGd9PciulJJK
dsedehZFz2Bz37qrUhLWzwwkvhTGZrmXZdelRMrxSR8PpojZNjRu3y8l4vJ4
qd5+irtizvMf30mJSop6d+gBCu044uP9UUqcv2uqqTxIsVGN2NjIUVL85UKi
dSIFkU/5fk6RkoBfT6huSKbwNorODtGgZORUjvOu0xTKFtNqlpaUKIbbGJam
U7x2n7ZkWFPisImvMJlBYbDsDRlZS8m5D5r8mM9f+DH0QlLtKWEnXog6mkuR
U30rUABKTrFdWZw8iuu+bdsvMylpspXaLsqnONnu23rYnRKN5yYfMwsoMrJX
yeltp4TZz53sP0fxchKSZyxKDtRE9aqfp4gWcOxueVNSkalcv7OQYkGUL5+z
gxJ+VE1BUdHn3qPXvIL9KPkPN5x3IA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.1, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{804., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.773556574895814*^9, 3.773556592087044*^9}, {
   3.7735567855741835`*^9, 3.7735568172578397`*^9}, {3.7735568485670943`*^9, 
   3.7735568739327393`*^9}, 3.7735569368944497`*^9, {3.773557134187996*^9, 
   3.7735572760702453`*^9}, {3.7735573589375906`*^9, 
   3.7735573699356103`*^9}, {3.7735574444413414`*^9, 3.773557481413406*^9}, 
   3.7735576256512594`*^9, 3.773557672607342*^9, 3.7741111694203005`*^9, 
   3.789032880393236*^9, 3.789900680452674*^9, 3.7899014997590866`*^9, 
   3.796969860794279*^9, 3.8020763759925175`*^9, 3.8020773864866753`*^9, 
   3.8020775179414034`*^9},ExpressionUUID->"8bd5e5c8-d524-4a37-abff-\
a5cd7fba7bce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "DirVary40f", "]"}], ",", 
     RowBox[{"Evaluate", "[", "DirVary20f", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.773557570817163*^9, 
  3.773557574155569*^9}},ExpressionUUID->"d5d96d78-667a-406f-b8a4-\
63a939741d35"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVV3k8lO8XZYYopOx7JSlJJSUS900rEpU9UbIVqURRyhIKkT3JWiQp2bIl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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwVl3k4lN8bxs1YJiVKlqJUCKmU+BaR5ySJKCp7kiQhUUIqQpGQUqHFViJJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{785., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7735575650139527`*^9, 3.7735575749979706`*^9}, 
   3.7735576290208654`*^9, 3.7741111749746184`*^9, 3.7890328838454337`*^9, 
   3.7899006892551775`*^9, 3.7899015019592123`*^9, 3.7969698608402815`*^9, 
   3.8020763795198545`*^9, 
   3.8020773921864543`*^9},ExpressionUUID->"d3d450d9-380a-44bd-9cc8-\
937bb98653a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sBeta40detailed"}]}]], "Input",
 CellChangeTimes->{{3.7730476058673477`*^9, 3.773047617879365*^9}, 
   3.773389239193473*^9, 3.7735487269281917`*^9, 
   3.789900704328039*^9},ExpressionUUID->"923ee2f6-f0b2-4fc4-853b-\
18493ebd4c99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "3.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7730476207493687`*^9, 3.7733892406910753`*^9, 
  3.773389457558876*^9, 3.7733896782798834`*^9, 3.773548728909395*^9, 
  3.773548784180292*^9, 3.773548876813255*^9, 3.7735496283289747`*^9, 
  3.7735497187467337`*^9, 3.7735499025306563`*^9, 3.7735500063956385`*^9, 
  3.7735577427918653`*^9, 3.77411118025292*^9, 3.789900706842183*^9, 
  3.7899015039783278`*^9, 3.7969698608812838`*^9, 3.802076263919834*^9, 
  3.8020763818894296`*^9, 3.8020773302911263`*^9, 3.802077394386916*^9, 
  3.802077520604171*^9, 3.80225153033597*^9, 3.8022752313210945`*^9, 
  3.8022752964112835`*^9},ExpressionUUID->"ad4a80a3-9446-41d2-b73d-\
4e67430c3ff0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSol", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.773047626360377*^9, 3.7730476323713856`*^9}, {
  3.7730476687554364`*^9, 
  3.773047677876449*^9}},ExpressionUUID->"0661bc52-27ae-402e-b1e1-\
b7259d724920"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "3.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.773047678917451*^9, 3.7733892507218933`*^9, 
  3.773389460366881*^9, 3.7733896795122857`*^9, 3.773548732045*^9, 
  3.773548787019497*^9, 3.7735488769068546`*^9, 3.773549630091778*^9, 
  3.7735497199479356`*^9, 3.773549903997059*^9, 3.773550008345642*^9, 
  3.773557743930667*^9, 3.7741111827510633`*^9, 3.789900709847355*^9, 
  3.789901505522416*^9, 3.796969860936287*^9, 3.8020762718704257`*^9, 
  3.8020763833443923`*^9, 3.802077331207732*^9, 3.802077395112398*^9, 
  3.8020775215387897`*^9, 3.80225153136565*^9, 
  3.802275297577057*^9},ExpressionUUID->"a2f210b4-6c03-420d-a9ca-\
a6b327623fe5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSolL2L1", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sBeta1"}]}]], "Input",
 CellChangeTimes->{{3.773389526972002*^9, 3.773389573172287*^9}, 
   3.773548908902511*^9, {3.7899007759811373`*^9, 
   3.7899007761341467`*^9}},ExpressionUUID->"4abfadde-a44a-4561-922c-\
a916f25eabb1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.773389575293891*^9, 3.773389680853888*^9, 
  3.7735489119913163`*^9, 3.7735496375953913`*^9, 3.7735497209931374`*^9, 
  3.77354990482386*^9, 3.7735500094688444`*^9, 3.7735577458650703`*^9, 
  3.77411118549022*^9, 3.789900726039281*^9, 3.789900777181206*^9, 
  3.789901506238457*^9, 3.79696986098929*^9, 3.8020762743570757`*^9, 
  3.8020763847823477`*^9, 3.802077332208396*^9, 3.8020773961861105`*^9, 
  3.802077522141189*^9, 3.8022515325644455`*^9, 
  3.802275298358577*^9},ExpressionUUID->"248da0fd-592a-4914-852c-\
fb202bcfb264"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol2", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSolL2L1", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.773389585177312*^9, 
  3.773389591472727*^9}},ExpressionUUID->"82b98fab-3589-48c4-86d3-\
58274154a50f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7733895965895357`*^9, 3.7733896818678894`*^9, 
  3.773548913239319*^9, 3.773549639826195*^9, 3.773549722007139*^9, 
  3.773549905603862*^9, 3.773550011777648*^9, 3.773557747315873*^9, 
  3.7741111879983635`*^9, 3.789900731927618*^9, 3.7899007797043505`*^9, 
  3.789901507894552*^9, 3.796969861042293*^9, 3.802076277127915*^9, 
  3.802077334001586*^9, 3.8020773974709625`*^9, 3.8020775230057645`*^9, 
  3.802251534128484*^9, 
  3.8022752995173454`*^9},ExpressionUUID->"be0d36f5-e75e-4daa-9724-\
d130296edd98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "DirSol1", "]"}], ",", 
     RowBox[{"Evaluate", "[", "DirSol2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.", ",", "1.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", "\"\<Anglular speed,rad/s\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.773548800638321*^9, 3.773548811870341*^9}, {
   3.773548875970853*^9, 3.773548882694465*^9}, 3.7735489289641466`*^9, {
   3.773549042610346*^9, 3.773549066556388*^9}, {3.773549647704209*^9, 
   3.773549656237424*^9}, {3.7735497256263456`*^9, 3.773549728512351*^9}, {
   3.773549760492407*^9, 3.7735497990088744`*^9}, 3.77354991039307*^9, {
   3.7735500153188543`*^9, 3.773550019530862*^9}, {3.7899015230944214`*^9, 
   3.789901523711457*^9}, 3.802077338140332*^9, 3.802077402307176*^9, {
   3.8020774742163925`*^9, 3.802077474674693*^9}, {3.802077525409361*^9, 
   3.8020775446181045`*^9}, {3.802251486202687*^9, 3.802251496258356*^9}, {
   3.8022515956242924`*^9, 3.802251595885462*^9}, {3.802251632847988*^9, 
   3.802251670985419*^9}, {3.8022524423986998`*^9, 3.8022524453466563`*^9}, 
   3.8022752773036084`*^9},ExpressionUUID->"d1f31508-ee64-4a3a-b0ad-\
680c573e069e"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVl3k4VO/7x0mWqCiFkOwVlUhKyS352oWIQtaoRITKXtayL0m2bH0kqShF
JI+lLCnRhoosM3POzBxLZE5Efuf311yva871nOfe3vf7yLn7HfNcwcXFZcjN
xfX/v3/MLtyx8nPVjTAlZ5aXpyD+9NZtH5R1wd5l60n+pSl4P0nzTlE+Cs+v
pOL8C1MwXXMk2UfZGQ7zG7XNzk5BtNistJPyBdgjtMc+GJuC7g5Tuo1yJNAd
+dbsfT8FfsWXuyyVU0E31Vwx/uYU7H82rhwtngZHJh6JP0mbAq7T2/QdVqbD
DeOHpl+SpqDryq2i5Ll00LiR6L8qdgocivwcfvVnQmbexQjZoCkIn1TobSjI
BsuHsz6CNlPQkpz80kK5EOIfjfh9F5qCJtbgO6GKQniRG7K1m28KGo23Dnep
FgFPb4FEDfcUOK5w47orUQx5eYdmz5OTcLzpr/wWmRJQkF2yjhqbBFMt9bPi
2+/CcLPj0IG6SdijXDDDD+XwTmxP+5LDJPDyBfAzvaugRxvEIXkCTK66xT23
qwOVl6eL30ywQSOtxbAkqA5c3eoHwnE2SBfJCaRk1oEStj586zgbpptGE0/3
1MGzn1X5zgNsyP7nli5q+AKMeboSb7aygRbhnn9xbz3IXbMKnL/FhmvhHk92
bngJkhUOHKn9bKgL8Rwq62uC40bpyc7eLLine75fcqYJCvN27PrrzoJsnot9
aesRyHVoCmU4suBySvibEBsEmk2+pvfNWaBVcvORxRcExtu3l8bsYoEjbaQp
1KcZwt9Im85MM+GbkHCavH8L0BbXMNv9mTDocF4t4EobGLztHW1wwmGdUYpX
i14HDDddCugTY4DIZ8+n+xy7YcW2zppOw3Eqjz4Vce4f4ECyistPzRHYP+Tb
fTizD8RF1o2v1v4GLQvXzD/nfwLuOTv9V1Kf4Czq7GyK/gLmG/bo5Lh2Qq5H
ueRG134Y6T4Z3cR5BjtPjHL+eQ5CbeSjva5/StHwrGWPnsl32MJVtUpztBXN
/Ny0W+z4ENTdi0n4MNOL0itDz9jb/4TuT3rBpasHkLKwgEVw/ghcGJXlbbUd
RrX+1ypTi0YhOdK3697xMfRZ6Sa/deYYlddd1q58dKQY82nbqdxxkKqYndDK
w9CJpzzqXnfGwU+9mCfnLoaSR/do+5WMQ1uA5yniIYbmIMskqmIcdvTsXkpA
GGpftPUuqx8H3i00uUs0DJ27/LVyYnAcKt2VZZR34ujxucFdkZI06K7+LjNe
jyNtq5+aRfk02HV3Lwg1M1EjzjvhXkSDmt2vfU07mEg3akeZ8l0atO+rYsb0
MJHB05CNjx/Q4JOP8V/6DyY6umEDp7GeBt8civm85pnIfcC47ls/DWLdDcqN
1VkoyfWpttgGOuSGhSyWFLDQ2vmBX4PidFhWjeco3mWh9IzlijtSdDiVqryr
tIKFslvNJZUU6NBkZGSdVMtCxYrYwh4NOoxt0dwq2stCz3CpRmsrOsRLXZJc
5majIf843ZRkOqgpKngZubERV3Pz5tJ0OmxY9FaPOcNGisKLi7VZdOhJ/POw
zpeNvB8FvBwpoEPv+IiaYCgb/WG67Nd8RAdNicAg20w2Wu9xQOP7ezpsRnmc
7BY20np6ad10Hx0a7tS32naw0UnuJ9Mrv9LhS/+RkDXv2ai4aGvVrmE6CDnu
+hc2wEY7f2zYET1Jh/pxhweKU2xkpWoldHuGDkcWAzTKf7NRUGgSq5JDB4sf
k9kbF9ioQWJFxZd/dJDgPcj9cSWBjI9PKW0XZsCVfTqfOyUJdP4/FV5dUQZY
XSt4clSWQKmznrRj4gzo7im0v69EoKf6JW1npBiw1L0z/okKgb5k/CgN38IA
jbt2rcZqBPozIh6docCAogzLErs9BJLebeN2bysDzI4c8fmkRSC4mqr3UpX6
/6Hy5k5tArn3dG3pVWNAUGz2BgsdAsVv5l2m7WHAwqkku1hdAlX46A3P72OA
N+a2MVOPQNOCdQUKegz4LTjw664BgSKM/tt0xYoB/F8SPDwtCFSc/fNPki0D
VGK1DRMsCfSaLjlQfIIBEy+2tNy2JpBgbEb2W1cGvP3g1xt6nEA5zZGiMhcZ
oPvcd/20ExWf9sk1bzIYMD9mU1TjTSDFmcSCrFsMyKhXOKfqQ6BbDxpVT+cy
QD3vh2KhL4GCpWRNeUoYEDMmGRbgTyDdJUb84WoGiEYJanVeIlD1cwmxdc8Y
cLHwmOzqKwSSu2BaNlLHAL+1j51Mggm08uejtquIAYv/NGOqQgnU3RzE1dTD
AIOqqx7brhJIJ+ReWspH6nltJ0OtawR6rD4gc+orA84PJG7XjSJQZunBQ4tD
DPicca79YAx1nqPvu+5RBqRN+vbtjiXQJdEix3w6Vb8k92qZOAKdiF0RemCC
uj9r+1paPIHe6miuEvzFAObnyaKX1wl0cM4zZ/A3A459WOOefINAMl5dtcGL
DDjs1kdKJhKIZpQ+WyuEwSCqWDGVTCA7rtboeGEMRhLWat9MIVDHi9l1dqIY
eG6f1dmdSqAH2+13z0lisF7HkmWbRvXD2A30WgaDXt81f39QnJLXcDRLHoMg
n7k7zukE8heS8d2jgkGkvnjr0QwCjbVZLq7YhYF0Ta72K4ptwqOSPqpjIH+5
4ZBSJlVfzRrJ0r0YbJscvxpPsdYEreKiNgaqom3rRym+XyamffgQBjT9uR+a
Nwkk6WzcKXKYOr+jJy+S4mSxUPsRAwwO5gSLvKZ4qaeSUWWMwcr2g7r8WQS6
cH3o0lVzDKZTQmMPUjwCwryWVhisNvMJD6T42B+9LBlbDJIUz8jkUfy6OkBh
0p6K31X8UCvFWuf+e/rKkbq/yPqTIxSXy309nOKCQfyWzgMLFEt84+9z8sDA
z9dhROAWgRIztV13nKHyOWi5T4ziRdPzU3+9MeD9o/xLgmJfnjuR3RcwOBTa
YS1O8fDLnjX5ARho3OcIiFBsFcR1x/syBuZ+fxeWqfNbd2jsOBCKgS5z2Run
eA/d4+WqSAyaBXgZ3RT/d+eW6WAUBrZWTN4KisXsOgbvx2Fwz+R9QgTFhjr/
6XkmYHDNUlvZguIr8lHlcikYuHxfuC9O8X0B57XD6RgYJN/e/4PK38DkgUt5
WRh8Nx69eZviVV/Ef9jlYLChWP2TJcUHXv7WFy3AoOaig8AKir1L+io+FGFw
4mpxdSVVr/zrj0WS72JQVd5Zf5Tid75JV4zLKbZNHSGo+i/anB1eWYnB7Ucf
mDEUO8vKP4x4ikFokY5rMdU/qXzL6w/UYjDV3jQjRzEivodw6jHQNDWRLqX6
Tbb+lpFfCwYNJr9Ukqn+tCoKeKz6BgOzNevqZ6j+jYqz3Ih3UmxSLOxE8Zj1
qnHXXgzI3DhiHdXvovsZJps/U/3y0X7eNYlABjJt1YP9GOjkufWUUfNRxgqP
PPYTgy0SDH/NBAJ97T1JXzuOwauCtBOnqXniq9My72ZQ92sa3ZpDzdvZmOlN
BpMY4Buvx01S86kiffr53iUMLOYaMZNoAjmsOCw9w4VDxpclFStq3pPwzTGP
V+LwTMsu4hilB8Szfqutq3HIHqCVH44kUJWFGSEhhYPaqvf6H0Ooft2zzeaL
DA7CFtZtZZTeiEjyNmTI40Bu6jsZROlRAKPpuqAKDnm27/4tBhFI86qGwuJ+
HOrF9Rfe+hHI01M48YUODnj3CdlzFwiUbUZMB+nhYNB88JkgpX+k+L2mCSMc
RLbd/KdG6WVD9SaHn3Y4pOdX47tPU3o/xpXRGoTDwNwDu4321Puvzsj0BuPw
UF9NW43S3zEp2sOhcBxSVLayDtsQKPZ4R+efWByeDA9kW1P6/bYzhUvtFg68
FvwJkkaU3lRJ+uc/x6GvZmns2F4CbTNf/e9+PQ5ZRnFP5zUINI8vJdW+wiE1
t9UldzeBCuRHy/ve4NARxjBqUyXQ6K3yn/xfcYjEnM1a5AjkE65pGcTBYeGn
6Pazqyn93qQ8FLWAQ1XDoa13VhFIuFb8fNo/HPaFyol081H7YWoh/gEfEzpv
yFev46bid29pGhFjAv8M1znTOTaKNjm6y2IfEwje4RHvH2yUK3Z2jXIwEw6G
lCwFlLHRC2krs8kwJgR+f13MX8pGA/L7E2qvMqFEwfFAdiEbSagJ8BpdZ0Jm
tVdmyW02yja6v3gmmwkvHPZ3+iewUVYwzq54xgSzUJlfv86zUeq3s293/mLC
KaFTfAk72OjxiJUA5zcTso6tnHHdxkbvGfsNm/4w4cOMk766IhutnhVoPcrF
AtMU5+Q3UmyUJFRR7yfMAuvR3fN3Bdnohg7z/pOdLHjj03nLDGOh6MJz1/dS
vtsSK0xzpvyUvqMXcfQCC2TjnM+L32YhHgkP67MBLPC0bPJ6m8FCsRlOUvmh
LNCTl9m/6ToLxcdaVnElseDFkHb0mYsslOC9t7+7kgUy+q+zPhhQfkyLe6v7
BAsuof51bxlMdKcnpz3Vnw1yknl/JsWZKOLCzenNAQSgyudd+8IwZNqqPjR8
iYAa+gqb5ksYkhDr7SoKISBHX3f+f/4YevZq9V25KAIUtciy/3liiLU6/rhS
OgEKnfF13JaUv60MbtjxmIDxg1/czslhSBM/FXuQRYBJeI7N2VYGYrttkzjp
PgEr73lq6c3RkYPPd9XzXhPgbe/sNTtBR52XUyHCewKcVCP6ixl0VJb026sk
YALSxdcms/rpyOV583Nm9ASM207WaTfQ0SeBkzahdydA+Los7U0EHb2sSkjN
p02AoH+h6AMuOkpaYq0c9pqEWzD2XYIzjhoIo6m1DlNwmO+VYtz7UfRVaf/Y
AcVpSK2RlFYeG0Znt3uo3SybBo8TOrE3TAZRi51j2GGZX5CoyQgKrPmE9pxg
VWwo+QVWGS67LB6/RT4xhv2HpGbAd3ekwsu+RnTDS2CB++YMvHUIyz16JQO9
2uy2zNowC3Ni3CPrNGuh/l88j0rqLPRWrtbssuuAnpojrJR1v6HhZYjmbumP
8EbWqz058zfUC/+KE1McgNi64yWjgnPw7r42d9z5IXCS/+HsmDIHvH0WyV12
o/C3Vk1KlZ8D5uOYbXTCOOwq4LwRWMUB/c2CQjkZ4+Aa9cqfIcih/Lns8UfU
d8hrM7P2krUcwBo2HWqhvjOSR7wuSohxQFPjzrGarnGQFizs4FXiwNcFSfY7
ARronFodNKLPAfWjOuH/xdAgnIf57lYkB258Mm26e54O/44cECq4xgHjnJdy
OwPpEBWbZFIazYHUsrU/qkMpX8+7q/1xPAeObhxrK0+gQxp/IOpI5QAn5Fmp
TTkdSoWWnswXcoB4cHNHwSgdukTX3T6FOHAk9pMI3ZoB5rbuXzxaqPiGRKpr
KZ/Zk1Uj6t3GAdenfAIxLgz4uNEu/XIHB0I7PAsEfRnwQzw/Ie0DBzwklt/2
X2fAtJRSeMtPDlQurz9r38gAMUVtNyUuEvT+rOkZkcVALzeOFFhBgt/1gLgU
ZQzOrf2YQvCQkKLh9lRzBwaNf7wbavhJ6JARFgvch4H7+wJRfWESMod+5b2w
wODxZa52ZxkS1HXeyRwIwWCAbe6kL0vCzpZ7y0mUD+B2y51RkieBR/Ky27cY
ygeYaWyZUCKhMd1aOiAVg4Utp4PDdpKwJ7BLOYnay4ZdHSo5OiTcbk3LW/MO
A3/dDS1huiSsOPQoX6IPg9waV3sXPRL2Xl8hpfYVA+LOfIyyAQksGeky/xEM
xEQNJQUNSeCfnyRv0DGAG5nVE0YkHAv8EHCDhUFmgOrQMzMSXBSfV3Nmqfiw
K4E5FiQc4ducZ/AHA7rT61XhliSc3OKYpbOIwdqPIsUu1iSMsJf6B5Yx2G90
SuuIDQlRnsGB0jw4uDdWvFM+ToLZ8LWMtXw4JKlz3AXtSRiT1NB8JYDDsFRa
Wp8DCTIrtmhnrcFBIOO70nMnEsIEAhV/CuOgzretMceZhLdyjgbb1uMQO92M
u7hT+e76GP1RDAeVNzOHJ8+RIPlNwSdCFocrF+x+C4aQsBBGc9HUwEFa63Sn
chgJ1zyGNdI0cWheuligH0GCxX++I7gWDoIpKQahUSTwDurJZxzEobDydRYz
gYTttID/hRrg0I5r7O3MI+GWYfCbr7Y4nK/WW0UrIGFWgjbymtqzIsFHh5YL
Sbju+ty/8gQODvzecfvuklAsrWvm7oTDhFLJl3uVJBiy83lCPXDY4CF8Oa6R
qnemLr+tP7XnVTabljSR8CJNc3XfRRycZ1RkXjWTMLdfv8QwEIf7UYbtv1+T
UGMZUCB5GYeDxRFip9+ToMud2Hg2DIeRM0msqx9I8DyRHFlJ7fFYtdym/D4S
1l8o7sUicOhpeub16QsJb7gLisyvUfUYYtfqD5Pw00aotona8/xl84nOI1T9
fJ2TO+MoX+DD7xI6RsLBviSL7ngcOH/l+Z8ySKB7fVVsvIFDftvu7+9xEpIX
Vvo9SMBBL0m3ismi7qt/ZjojEYdESQd7uSkSSouwVebJlA8aO6N66Bc1D3GB
52RScPhccWn5xCwJkwknKpkUy2hnlKeTJPzAGL3eaTi0cRWFPZwnob1720fZ
dBzOdj607PxLgmMXu+MDxavTGxRoSySEz2s3XMmgfIp9J7m8TILC17AMiUwc
/g+kOcnQ
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwV13k4Ft8XAHCRaKPFEolv1hDSruSgQsgupRJCQlmSKJGyZF9T9mxJyhKR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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox["\"Anglular speed,rad/s\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->Automatic,
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{847., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.773548812494342*^9, 3.7735488837240667`*^9, 3.773548930368149*^9, {
   3.773549046432353*^9, 3.7735490675547895`*^9}, 3.7735496572358255`*^9, 
   3.7735497294795523`*^9, {3.7735497616156087`*^9, 3.7735498001632767`*^9}, {
   3.773549906898664*^9, 3.7735499113602715`*^9}, 3.7735500204044633`*^9, 
   3.7735577482050743`*^9, 3.774111190609513*^9, 3.7899007329236746`*^9, 
   3.7899007806974072`*^9, {3.7899015092316284`*^9, 3.78990152464651*^9}, 
   3.796969861094296*^9, 3.8020762803260355`*^9, 3.8020763863848553`*^9, {
   3.802077335161358*^9, 3.802077339075954*^9}, 3.8020774031357217`*^9, 
   3.8020774756313286`*^9, {3.802077526220897*^9, 3.802077545522704*^9}, 
   3.802251499518518*^9, 3.802251534971044*^9, 3.802251596890128*^9, 
   3.802251634073802*^9, {3.802251665469757*^9, 3.8022516718209705`*^9}, 
   3.8022524482755985`*^9, 
   3.802275300300866*^9},ExpressionUUID->"6f525f56-57e3-4bfe-80d7-\
d0faad9d20a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "DirSol1", "]"}], "-", 
     RowBox[{"Evaluate", "[", "DirSol2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.06", ",", "0.11"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", " ", "False"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.802251891245812*^9, 3.802252044024853*^9}, 
   3.8022752860093822`*^9},ExpressionUUID->"c8a27fdf-1d8b-4008-9c0b-\
456060fb83ca"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwV13k8VVsUB3BFCslUqSQylAxRKEq2ypgKZUghSTIVFS9DIb0ipVAKyZwh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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, False},
  AxesOrigin->{0.06, -0.059500000000000004`},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->Automatic,
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8022518926847672`*^9, {3.8022519255455723`*^9, 3.802251951489787*^9}, {
   3.802251985947651*^9, 3.8022520447313223`*^9}, 
   3.8022753094709506`*^9},ExpressionUUID->"7ccec6f8-a7cf-4cb8-9c1f-\
83ee44c32cac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir2Sol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSol1", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8020777451515913`*^9, 
  3.802077749740636*^9}},ExpressionUUID->"6b7c4d65-ce08-427d-8b3b-\
a762d00f6a6b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "3.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.802077756536145*^9, 3.8022517311183205`*^9, 
  3.80227532442087*^9},ExpressionUUID->"11b93c04-5404-436b-836a-0c7e8a39a94d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir2Sol2", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSol2", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.802077769828967*^9, 
  3.802077781284567*^9}},ExpressionUUID->"5ef09eb3-cf80-4eb8-9436-\
91c35cabc548"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "25.132741228718345`"}], "}"}], "}"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.8020777833639474`*^9, 3.802251732213044*^9, 
  3.8022753284745593`*^9},ExpressionUUID->"74436583-d68d-4426-8c3c-\
a980597489f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "Dir2Sol1", "]"}], ",", 
     RowBox[{"Evaluate", "[", "Dir2Sol2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.", ",", "3.4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", 
      RowBox[{"\"\<Anglular acceleration,\>\"", "\"\<rad/\>\"", 
       RowBox[{
        RowBox[{"Text", "[", "s", "]"}], "^", "2"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.802077800746481*^9, 3.8020778023985786`*^9}, {
   3.80225210795928*^9, 3.802252132381483*^9}, {3.8022521933689137`*^9, 
   3.8022522228700438`*^9}, {3.802252347847974*^9, 3.8022523491198196`*^9}, {
   3.8022523801574106`*^9, 3.802252382945264*^9}, 
   3.8022752914629993`*^9},ExpressionUUID->"2c782abf-ebc0-49a5-9276-\
82a3f75b2edd"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwUl3k4VV8Xx+9sVgiVIkJSiTJWrF0/SsgUMjQICVEqKXOlJFJIpUmSIkSo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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwVmHk4VV8Xxy/uwJ1OxihSklBJKSS1NyGRkDEqVEQplJRkqkgJSakUEb9C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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox[
     RowBox[{"\"Anglular acceleration,\"", " ", "\"rad/\"", " ", 
       SuperscriptBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox["s", TraditionalForm]], "Text", "TR"], 
         Text[$CellContext`s]], "2"]}], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->Automatic,
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{916., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8020778038795605`*^9, 3.8022517410739236`*^9, {3.802252110780151*^9, 
   3.802252119369849*^9}, {3.8022522046686525`*^9, 3.80225222440306*^9}, 
   3.80225235192868*^9, 3.80225238418108*^9, 
   3.8022753291600156`*^9},ExpressionUUID->"ef59e495-1990-48cd-97a3-\
7e19c14ebe05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Evaluate", "[", "Dir2Sol1", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.06", ",", "0.11"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", 
      RowBox[{"\"\<Anglular acceleration,\>\"", "\"\<rad/\>\"", 
       RowBox[{
        RowBox[{"Text", "[", "s", "]"}], "^", "2"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.802251759363061*^9, 3.8022518304552355`*^9}, {
   3.8022552299804277`*^9, 3.8022552304707537`*^9}, 3.8022753397740602`*^9, {
   3.802276252372795*^9, 
   3.802276289455619*^9}},ExpressionUUID->"4fb43b69-e9ef-4231-a9bb-\
87d063fdac47"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVl3k8lG8XxlVSSYXIvku2SkWy5FCR7Amh0mJJC1EpRchSIkKRIil+CWWZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, False},
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox[
     RowBox[{"\"Anglular acceleration,\"", " ", "\"rad/\"", " ", 
       SuperscriptBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox["s", TraditionalForm]], "Text", "TR"], 
         Text[$CellContext`s]], "2"]}], TraditionalForm]},
  AxesOrigin->{0.06, -2.},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->Automatic,
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.802251774845332*^9, 3.8022518313338146`*^9}, 
   3.8022552313043065`*^9, 3.802275340779725*^9, {3.802276265397434*^9, 
   3.8022762908595505`*^9}},ExpressionUUID->"629d18eb-bc03-4dad-a20f-\
03aec025fc6b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"x2min", "=", "0.082"}], "\[IndentingNewLine]", 
 RowBox[{"x2max", "=", "0.095"}], "\[IndentingNewLine]", 
 RowBox[{"N2", "=", "300"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x2min", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x2max", "-", "x2min"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"N2", "-", "1"}], ")"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"i", "-", "1"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.7899009719733477`*^9, {3.789901356029028*^9, 3.789901358098146*^9}, {
   3.789901421091668*^9, 3.789901421634699*^9}, {3.789901539696371*^9, 
   3.7899015436105947`*^9}, {3.7899016426411*^9, 
   3.789901703521497*^9}},ExpressionUUID->"a727733e-0199-489d-bd66-\
e1a8ebfbda35"],

Cell[BoxData["0.082`"], "Output",
 CellChangeTimes->{
  3.7899008940998936`*^9, 3.7899009730924115`*^9, 3.789901359412221*^9, 
   3.7899014230737815`*^9, 3.789901546196743*^9, {3.7899016440161653`*^9, 
   3.789901704678563*^9}, 3.7969698645014906`*^9, 3.8020762901155334`*^9, 
   3.8020763888121967`*^9},ExpressionUUID->"82eb2e4e-5984-435b-9404-\
574fa87fa8dc"],

Cell[BoxData["0.095`"], "Output",
 CellChangeTimes->{
  3.7899008940998936`*^9, 3.7899009730924115`*^9, 3.789901359412221*^9, 
   3.7899014230737815`*^9, 3.789901546196743*^9, {3.7899016440161653`*^9, 
   3.789901704678563*^9}, 3.7969698645014906`*^9, 3.8020762901155334`*^9, 
   3.802076388814198*^9},ExpressionUUID->"cd19dcfa-920b-4906-9f17-\
e2574810feeb"],

Cell[BoxData["300"], "Output",
 CellChangeTimes->{
  3.7899008940998936`*^9, 3.7899009730924115`*^9, 3.789901359412221*^9, 
   3.7899014230737815`*^9, 3.789901546196743*^9, {3.7899016440161653`*^9, 
   3.789901704678563*^9}, 3.7969698645014906`*^9, 3.8020762901155334`*^9, 
   3.8020763888161983`*^9},ExpressionUUID->"3252234f-6e77-4d08-a422-\
d6794fd58e03"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DirSbetavary40data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"DirSol1", "/.", 
       RowBox[{"x", "->", 
        RowBox[{"x2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.78990097882574*^9, {3.789901030245681*^9, 3.7899010451385326`*^9}, 
   3.789901462528008*^9},ExpressionUUID->"2128b7b4-50cf-4fbc-b5df-\
748dc04147d6"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DirSbeta1data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"First", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", "DirSol2", "]"}], "/.", 
        RowBox[{"x", "->", 
         RowBox[{"x2", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7899008688644505`*^9, 3.7899009602186756`*^9}, 
   3.7899010609024343`*^9, {3.7899013682527266`*^9, 
   3.7899013691067753`*^9}},ExpressionUUID->"2b1d7fa3-9432-444c-850d-\
2d2356733245"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DifferenceDir", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DirSbetavary40data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "-", 
      RowBox[{"DirSbeta1data", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "N2"}], "}"}]}], "]"}]}], ";"}]], "Input",Ex\
pressionUUID->"277aae87-a40c-46d2-b2c3-bb6b0b5ade18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "DifferenceDir", "]"}], "+", "0.0592"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"3", "*", "\[Pi]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7899012314821453`*^9, {3.789901760581708*^9, 3.789901768332117*^9}, {
   3.796969792961399*^9, 3.7969697938984528`*^9}, {3.7969698767891936`*^9, 
   3.796969917580527*^9}},ExpressionUUID->"a18d67b2-c2ca-4735-bf52-\
cd7d642b4c61"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJw92Hk8VVv7APBdpkiGiIRMB8d0jjlU5zmJkqSiDOXtSpokpVTquqI0SNMV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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{553., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7899012330312343`*^9, 3.7899013727449436`*^9, 3.789901429884141*^9, 
   3.7899015499779296`*^9, {3.789901647165345*^9, 3.78990166786946*^9}, 
   3.7899017081477613`*^9, 3.789901770162222*^9, 3.7969697967116137`*^9, {
   3.7969698701588144`*^9, 3.796969879331339*^9}, {3.7969699112491646`*^9, 
   3.7969699184105744`*^9}, 
   3.80207639960112*^9},ExpressionUUID->"c2014e13-5729-4242-85a0-\
e4be8835175c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Osc_in_Solution_Derivative_beta.xls\>\"", ",", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"x2", ",", 
      RowBox[{"Re", "[", "DifferenceDir", "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.789901920319618*^9, 
  3.78990195717667*^9}},ExpressionUUID->"27a86eda-d1ac-4d21-84b4-\
fa2e7eee7099"],

Cell[BoxData["\<\"Osc_in_Solution_Derivative_beta.xls\"\>"], "Output",
 CellChangeTimes->{
  3.789901961525919*^9},ExpressionUUID->"f3f33d39-ebde-4b43-990c-\
177fcd5dfb56"]
}, Open  ]]
}, Open  ]]
},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e033e763-2ddc-49f4-a3a5-19cab9de37d4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 212, 4, 30, "Input",ExpressionUUID->"039a1c71-029b-437b-821b-66579699fc34"],
Cell[794, 28, 446, 7, 34, "Output",ExpressionUUID->"c9bcac64-d804-4f20-8ca6-777fbf4dde0b"]
}, Open  ]],
Cell[1255, 38, 2607, 65, 287, "Input",ExpressionUUID->"9e15467b-45e7-48c3-8875-0a66c045170b"],
Cell[CellGroupData[{
Cell[3887, 107, 876, 15, 30, "Input",ExpressionUUID->"c8c13827-db90-4a21-814c-cc8f86e44f6e"],
Cell[4766, 124, 3352, 84, 290, "Output",ExpressionUUID->"fa244a4b-d28d-48d6-a113-f4e2c0908352"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8155, 213, 812, 18, 30, "Input",ExpressionUUID->"6f1c0553-fc1b-4b06-ba06-bc3f129b7f7e"],
Cell[8970, 233, 3555, 92, 290, "Output",ExpressionUUID->"65d9a61d-81c5-44bd-bdef-bb84c9298360"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12562, 330, 719, 17, 52, "Input",ExpressionUUID->"22e50478-5e59-448a-be5c-604308efaede"],
Cell[13284, 349, 61862, 1021, 389, "Output",ExpressionUUID->"c51ec81d-7247-4c53-9e17-f6bdf9ccba31"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75183, 1375, 1366, 24, 178, "Input",ExpressionUUID->"fcc9d6eb-8887-43b1-9e74-a0eb4c3f6e86"],
Cell[76552, 1401, 936, 14, 34, "Output",ExpressionUUID->"556137f3-1a0c-497e-9f9b-297c7d550188"],
Cell[77491, 1417, 936, 14, 34, "Output",ExpressionUUID->"1fd4f7af-ad83-493f-a8dc-4b59c6b14b13"],
Cell[78430, 1433, 934, 14, 34, "Output",ExpressionUUID->"828f8134-4b3d-4ce4-a871-96be80777ca3"],
Cell[79367, 1449, 953, 14, 47, "Output",ExpressionUUID->"5e6f596e-1e66-413d-bfcb-4829c59b38dc"],
Cell[80323, 1465, 958, 15, 47, "Output",ExpressionUUID->"71641ba4-f9bb-4c30-9f52-c75a39e5fb0f"],
Cell[81284, 1482, 958, 15, 47, "Output",ExpressionUUID->"b346e512-a256-4623-a7e2-8df7bcfbad5d"],
Cell[82245, 1499, 958, 15, 47, "Output",ExpressionUUID->"cbc5239e-ad5d-48d0-81e6-f70bcf923716"],
Cell[83206, 1516, 959, 15, 34, "Output",ExpressionUUID->"dc710c16-b409-46fe-b11b-bf7aaa29dfe6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84202, 1536, 291, 8, 30, "Input",ExpressionUUID->"a31318f1-6f08-407b-8838-744ad29edc6f"],
Cell[84496, 1546, 481, 7, 34, "Output",ExpressionUUID->"7deaaa6e-b666-4051-a8f1-2f19ec63749f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85014, 1558, 553, 14, 52, "Input",ExpressionUUID->"6561d86c-04b9-45fa-8792-829b6ed1e86e"],
Cell[85570, 1574, 561, 8, 34, "Output",ExpressionUUID->"72d0a372-96be-4057-a975-39f38ca2d0e5"],
Cell[86134, 1584, 559, 8, 34, "Output",ExpressionUUID->"25475740-5ca6-44e2-8e66-d865c705b13b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86730, 1597, 1292, 33, 73, "Input",ExpressionUUID->"c4bdbce6-2c3f-4c9f-be34-3fd06da9aa20"],
Cell[88025, 1632, 1064, 25, 34, "Output",ExpressionUUID->"35066469-0b29-4229-93eb-5f5022231674"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89126, 1662, 1240, 32, 73, "Input",ExpressionUUID->"0c5cf978-0541-4de5-8b0e-5be85aaae4ca"],
Cell[90369, 1696, 1034, 24, 34, "Output",ExpressionUUID->"bf02a6e6-35da-4919-b80f-f84bf4eb9519"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91440, 1725, 1690, 43, 157, "Input",ExpressionUUID->"351e3f8f-c901-44fe-84ed-0eebb9591b3d"],
Cell[93133, 1770, 617, 12, 41, "Message",ExpressionUUID->"6e8bb97c-cd83-4c3b-9e5e-a28c34c355ea"],
Cell[93753, 1784, 923, 22, 34, "Output",ExpressionUUID->"876efcd9-833d-43fa-8037-1390218f85a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94713, 1811, 1551, 44, 178, "Input",ExpressionUUID->"a19c7e75-008d-42ab-9476-6060b3c8b86c"],
Cell[96267, 1857, 594, 18, 34, "Output",ExpressionUUID->"88b15e2c-9bf1-44c3-93cb-afced771fed5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96898, 1880, 1703, 46, 178, "Input",ExpressionUUID->"28308c69-14c7-4c6f-922e-184b2b38984b"],
Cell[98604, 1928, 881, 22, 34, "Output",ExpressionUUID->"b4ac6bb0-6c95-4035-96ed-d6d25210d258"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99522, 1955, 1614, 41, 157, "Input",ExpressionUUID->"9e3a6ae7-b491-455f-98d9-f3a62d1688cf"],
Cell[101139, 1998, 56092, 931, 465, "Output",ExpressionUUID->"66d3e600-e593-4512-a8ea-33cf5a5c5af6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157268, 2934, 1170, 32, 94, "Input",ExpressionUUID->"70cdc4ba-840e-4464-af45-bea3d66be0af"],
Cell[158441, 2968, 55675, 922, 389, "Output",ExpressionUUID->"84170a63-a12b-41d2-8cd9-f1cd4364fc7e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214153, 3895, 777, 22, 94, "Input",ExpressionUUID->"e951641a-84cd-47bf-9876-c096dbda7e0e"],
Cell[214933, 3919, 176, 3, 34, "Output",ExpressionUUID->"c0b7ec2b-3676-40fb-bc93-36abae46a937"],
Cell[215112, 3924, 204, 4, 34, "Output",ExpressionUUID->"4496f600-b627-4a19-ae0d-1db986a78c3c"],
Cell[215319, 3930, 180, 3, 34, "Output",ExpressionUUID->"b9cc6b29-855b-4ce0-9ba9-42092b664d1a"]
}, Open  ]],
Cell[215514, 3936, 1075, 32, 115, "Input",ExpressionUUID->"e6d16ac7-7995-40bf-ab4b-ae0229254934"],
Cell[CellGroupData[{
Cell[216614, 3972, 378, 9, 52, "Input",ExpressionUUID->"1b1cf263-55c4-4b74-b9b9-06ce70902553"],
Cell[216995, 3983, 171, 3, 34, "Output",ExpressionUUID->"0bcdb296-ff20-4974-b19d-e04b1258015e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217203, 3991, 157, 4, 30, "Input",ExpressionUUID->"8e620571-fd71-419b-b390-99a0fa60dcd5"],
Cell[217363, 3997, 149, 3, 34, "Output",ExpressionUUID->"336b4c37-dcf1-4e22-9b3a-5cb272e8d5d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217549, 4005, 731, 21, 94, "Input",ExpressionUUID->"e8830886-0d10-4933-82e4-f4800d70f848"],
Cell[218283, 4028, 181, 3, 34, "Output",ExpressionUUID->"91d97b1f-312e-486d-814b-4d2b97b915b8"],
Cell[218467, 4033, 183, 3, 34, "Output",ExpressionUUID->"78056c9b-08d9-4d23-8440-8c263763a36a"],
Cell[218653, 4038, 181, 3, 34, "Output",ExpressionUUID->"896d6260-d81b-41ef-9411-b90cbd20d970"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218871, 4046, 1705, 38, 115, "Input",ExpressionUUID->"9e7d6433-8aff-48ac-85ec-ab224db65c51"],
Cell[220579, 4086, 4043, 76, 389, "Output",ExpressionUUID->"5140093e-ba51-481a-a164-595698f93c43"]
}, Open  ]],
Cell[224637, 4165, 1497, 45, 136, "Input",ExpressionUUID->"c13c14fe-b0bb-48db-b446-f65b40f0ffb6"],
Cell[CellGroupData[{
Cell[226159, 4214, 268, 6, 30, "Input",ExpressionUUID->"9b3c9abf-33ff-4a7b-ac8a-ca0faf5295b4"],
Cell[226430, 4222, 4161, 74, 219, "Output",ExpressionUUID->"96b52b64-fb9f-41ef-b3c3-fd54f3ae2e7a"]
}, Open  ]],
Cell[230606, 4299, 156, 3, 30, "Input",ExpressionUUID->"108ff028-c201-4457-93af-668ede7aef29"],
Cell[CellGroupData[{
Cell[230787, 4306, 224, 3, 54, "Subsection",ExpressionUUID->"8eb4542b-c7a4-42e7-ba24-f7122aa1c3f4"],
Cell[CellGroupData[{
Cell[231036, 4313, 2459, 56, 178, "Input",ExpressionUUID->"27131c67-b0f2-4644-8776-3c1dd2cdfc47"],
Cell[233498, 4371, 1185, 27, 34, "Output",ExpressionUUID->"ea4192d9-0364-4ac4-97af-60bda29878e3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[234720, 4403, 502, 11, 52, "Input",ExpressionUUID->"e6476642-3678-4f3e-9a94-3b94ff08d1f6"],
Cell[235225, 4416, 736, 18, 34, "Output",ExpressionUUID->"75badad4-18f5-46f4-84f0-b0498eac5286"],
Cell[235964, 4436, 736, 18, 34, "Output",ExpressionUUID->"d4d5632f-7b8a-4b8f-ba7d-b4e8e560aea0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[236737, 4459, 414, 10, 52, "Input",ExpressionUUID->"0c973755-3c32-44b7-9058-67cff6f5dfde"],
Cell[237154, 4471, 660, 17, 34, "Output",ExpressionUUID->"db7cfdf3-f11c-437b-aca9-2488e84ed1dc"],
Cell[237817, 4490, 660, 17, 34, "Output",ExpressionUUID->"f01cb91d-b844-429f-860f-e11b09ecdf13"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238514, 4512, 1200, 28, 94, "Input",ExpressionUUID->"6d5527fd-a4ab-43ca-b515-0d1d64795ffc"],
Cell[239717, 4542, 4596, 83, 500, "Output",ExpressionUUID->"8bd5e5c8-d524-4a37-abff-a5cd7fba7bce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[244350, 4630, 908, 24, 92, "Input",ExpressionUUID->"d5d96d78-667a-406f-b8a4-63a939741d35"],
Cell[245261, 4656, 26305, 440, 489, "Output",ExpressionUUID->"d3d450d9-380a-44bd-9cc8-937bb98653a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[271603, 5101, 322, 7, 31, "Input",ExpressionUUID->"923ee2f6-f0b2-4fc4-853b-18493ebd4c99"],
Cell[271928, 5110, 951, 20, 30, "Output",ExpressionUUID->"ad4a80a3-9446-41d2-b73d-4e67430c3ff0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[272916, 5135, 291, 7, 31, "Input",ExpressionUUID->"0661bc52-27ae-402e-b1e1-b7259d724920"],
Cell[273210, 5144, 915, 20, 30, "Output",ExpressionUUID->"a2f210b4-6c03-420d-a9ca-a6b327623fe5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274162, 5169, 319, 7, 31, "Input",ExpressionUUID->"4abfadde-a44a-4561-922c-a916f25eabb1"],
Cell[274484, 5178, 871, 20, 30, "Output",ExpressionUUID->"248da0fd-592a-4914-852c-fb202bcfb264"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275392, 5203, 242, 6, 31, "Input",ExpressionUUID->"82b98fab-3589-48c4-86d3-58274154a50f"],
Cell[275637, 5211, 848, 20, 30, "Output",ExpressionUUID->"be0d36f5-e75e-4daa-9724-d130296edd98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276522, 5236, 1720, 34, 112, "Input",ExpressionUUID->"d1f31508-ee64-4a3a-b0ad-680c573e069e"],
Cell[278245, 5272, 15444, 264, 507, "Output",ExpressionUUID->"6f525f56-57e3-4bfe-80d7-d0faad9d20a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[293726, 5541, 939, 23, 92, "Input",ExpressionUUID->"c8a27fdf-1d8b-4008-9c0b-456060fb83ca"],
Cell[294668, 5566, 6461, 114, 245, "Output",ExpressionUUID->"7ccec6f8-a7cf-4cb8-9c1f-83ee44c32cac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301166, 5685, 242, 6, 31, "Input",ExpressionUUID->"6b7c4d65-ce08-427d-8b3b-a762d00f6a6b"],
Cell[301411, 5693, 441, 12, 30, "Output",ExpressionUUID->"11b93c04-5404-436b-836a-0c7e8a39a94d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301889, 5710, 240, 6, 31, "Input",ExpressionUUID->"5ef09eb3-cf80-4eb8-9436-91c35cabc548"],
Cell[302132, 5718, 468, 14, 30, "Output",ExpressionUUID->"74436583-d68d-4426-8c3c-a980597489f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[302637, 5737, 1284, 30, 112, "Input",ExpressionUUID->"2c782abf-ebc0-49a5-9276-82a3f75b2edd"],
Cell[303924, 5769, 41594, 698, 539, "Output",ExpressionUUID->"ef59e495-1990-48cd-97a3-7e19c14ebe05"]
}, Open  ]],
Cell[CellGroupData[{
Cell[345555, 6472, 1218, 30, 92, "Input",ExpressionUUID->"4fb43b69-e9ef-4231-a9bb-87d063fdac47"],
Cell[346776, 6504, 19674, 335, 222, "Output",ExpressionUUID->"629d18eb-bc03-4dad-a20f-03aec025fc6b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[366487, 6844, 930, 24, 92, "Input",ExpressionUUID->"a727733e-0199-489d-bd66-e1a8ebfbda35"],
Cell[367420, 6870, 361, 6, 30, "Output",ExpressionUUID->"82eb2e4e-5984-435b-9404-574fa87fa8dc"],
Cell[367784, 6878, 359, 6, 30, "Output",ExpressionUUID->"cd19dcfa-920b-4906-9f17-e2574810feeb"],
Cell[368146, 6886, 358, 6, 30, "Output",ExpressionUUID->"3252234f-6e77-4d08-a422-d6794fd58e03"]
}, Open  ]],
Cell[368519, 6895, 544, 15, 31, "Input",ExpressionUUID->"2128b7b4-50cf-4fbc-b5df-748dc04147d6"],
Cell[369066, 6912, 660, 17, 52, "Input",ExpressionUUID->"2b1d7fa3-9432-444c-850d-2d2356733245"],
Cell[369729, 6931, 433, 12, 52, "Input",ExpressionUUID->"277aae87-a40c-46d2-b2c3-bb6b0b5ade18"],
Cell[CellGroupData[{
Cell[370187, 6947, 1078, 27, 92, "Input",ExpressionUUID->"a18d67b2-c2ca-4735-bf52-cd7d642b4c61"],
Cell[371268, 6976, 5927, 105, 328, "Output",ExpressionUUID->"c2014e13-5729-4242-85a0-e4be8835175c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[377232, 7086, 386, 10, 52, "Input",ExpressionUUID->"27a86eda-d1ac-4d21-84b4-fa2e7eee7099"],
Cell[377621, 7098, 172, 3, 30, "Output",ExpressionUUID->"f3f33d39-ebde-4b43-990c-177fcd5dfb56"]
}, Open  ]]
}, Open  ]]
}
]
*)

