(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    508661,       9542]
NotebookOptionsPosition[    496175,       9325]
NotebookOutlinePosition[    496574,       9340]
CellTagsIndexPosition[    496531,       9337]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"ScaleFactor", "=", "100."}]], "Input",
 CellChangeTimes->{{3.7733845587561502`*^9, 3.773384565900963*^9}, 
   3.77338522475252*^9, 3.794461070756691*^9, {3.7944611174513617`*^9, 
   3.7944611181464014`*^9}, {3.7944614608340025`*^9, 
   3.7944614618910627`*^9}, {3.794461509419781*^9, 3.7944615252506866`*^9}, {
   3.7944616357110043`*^9, 
   3.794461649181775*^9}},ExpressionUUID->"0b14b5d0-37a6-4a04-a5b0-\
531dac71859e"],

Cell[BoxData["100.`"], "Output",
 CellChangeTimes->{
  3.773384619939458*^9, 3.773385225750922*^9, 3.794373257985564*^9, 
   3.7944597444218388`*^9, 3.794461071905757*^9, 3.794461118921446*^9, 
   3.7944614629021206`*^9, {3.7944615104468403`*^9, 3.7944615265327597`*^9}, {
   3.794461638151144*^9, 3.7944616501988335`*^9}, 3.7953350801623363`*^9, 
   3.795438406995057*^9, 3.802072549209191*^9, 
   3.80227296203535*^9},ExpressionUUID->"e9db1e3c-b6be-40a0-9395-\
1cb2f08a24c3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"HeaviApprox", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.7978845608028653`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3.`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
         "ScaleFactor"}], "]"}]}], 
      RowBox[{"z", "*", "ScaleFactor"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.7978845608028653`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4.`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
         "ScaleFactor"}], "]"}]}], 
      RowBox[{"z", "*", "ScaleFactor"}]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"SinIntegral", "[", 
       RowBox[{"3.`", " ", "z", "*", "ScaleFactor"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"SinIntegral", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
        "ScaleFactor"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"SinIntegral", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z", "*", 
        "ScaleFactor"}], "]"}]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.773032013893078*^9, 3.773032023955654*^9}, {
   3.773032115954916*^9, 3.7730321183460526`*^9}, {3.773384573248576*^9, 
   3.77338460969024*^9}, 3.7944612637767315`*^9, {3.794461393636159*^9, 
   3.794461417807541*^9}, 
   3.7944614971530795`*^9},ExpressionUUID->"38e630ab-310c-44c1-969e-\
8f16fdabcd36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Heavi1", "=", 
  RowBox[{"HeaviApprox", "[", "x", "]"}]}]], "Input",
 CellChangeTimes->{{3.77304391436182*^9, 3.7730439427382703`*^9}, {
  3.77338322637341*^9, 3.773383245015443*^9}, {3.7733833091627555`*^9, 
  3.773383310909959*^9}, {3.7733846258518686`*^9, 
  3.7733846266162696`*^9}},ExpressionUUID->"6d975f67-cc5f-4c9d-ae34-\
eccda3b39f2a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}],
      "x"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}],
      "x"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"300.`", " ", "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"300.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
    "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"400.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
      "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.7730439451250744`*^9, 3.773379607824647*^9, {3.773383228432614*^9, 
   3.773383246169845*^9}, 3.7733833117991605`*^9, 3.773384627411871*^9, 
   3.7733852290113277`*^9, 3.7943732603346987`*^9, 3.794459747980042*^9, 
   3.7944610751309414`*^9, 3.7944612739523134`*^9, 3.794461421735766*^9, 
   3.7944614658082867`*^9, {3.7944615010873046`*^9, 3.79446152844687*^9}, {
   3.794461640641287*^9, 3.794461654271066*^9}, 3.7953350820444436`*^9, 
   3.795438409810218*^9, 3.8020725511614857`*^9, 
   3.802272965662759*^9},ExpressionUUID->"76fb4f67-850b-4624-baac-\
4a67884829cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"Heavi1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7730439485882807`*^9, 3.773043982050339*^9}, {
  3.7733828332059193`*^9, 3.773382835670724*^9}, {3.7733832795383034`*^9, 
  3.7733832868703165`*^9}, {3.773391333438402*^9, 3.773391334748805*^9}, {
  3.7944612934304276`*^9, 3.794461298744731*^9}, {3.7944614352405386`*^9, 
  3.794461442071929*^9}, {3.794461476100876*^9, 
  3.794461476426894*^9}},ExpressionUUID->"cca90053-1f6b-4be0-9123-\
464d5bd36457"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c8198XVkRlU/bMHtl7fK4dslf2ziaJZEQUGRUZJaHsvff6HNvHSBkV
oWWEyuYro36f31/v13k9997nOc857zs4nW+YXD9NQEBAc46A4P9fnlHquBcv
hiDQvjhO4RoHWKet+qSlD0Ha6aUMwuuc8MS22zjp6RAY2+r733W7BD3cL2QS
Hg9Bup408zUbLtj/5c8cEz8EobnGzNrq3CDYqE1wL2YIRq9Lh1Ox8YD9XY6l
0KghmB5V/37nJw8MkL+r8g/B80WhiGA7Pjh8X5zqHTQEqcq94sOn+EEkJ/KO
280hwN5rnZPO4Adnt2t2Tr5DEKzXqVzFIQDPRETVbD2HwJtq9qnoSwEY3ifm
u3Z9CAb3RO9iSQThL/YzqYnTEBR81l13dxMEiYdNm3p2QyDy2+tYpVkQ3Ayf
vL9iNQSLNvVdboeCkEnv1qZmPgTa928L/hUVgrEvyq+UjYdAUbVjTNJSCE6X
XHwgp4/Pj4qvXvGWEMj4//aQ1BmCbkP7C8ZRQuAl168voon3K1yMvylaCHII
siUEVIdgwCJ5tj5YCCZwgfTcykNQXlby6IWjEJA81Ttmk8frGRHv7lAWAiUr
7m+M0kOwS4dm7lAKgT/ncf8F8SGIOujGinwQhILVyTLKy0NwlLn1VCNFEKZr
y5POCwzBavhnEx4NQSALvR94hmcILiw7x6n8EgAVNRsrAs4hSGxqXjyXKACB
5yUxRyx4fzE/fxzg/SuZOM+1z4Cvj3vIvbgqfpjL/E6ydQHvX7d2mYwUP1C5
tP36STUEb/aNyB7U8cGdHc+mb2eHYKp+nu78S17QuTCk8+YAB9S5Lhq3Bbkh
Yu61CG4XB9GXym5i73NBXcEd2t5NHKhdFGKZm7kETNL88y0r+PFkIW/qIjhh
zfyhf8E0DvTP6z9wDGAFNjYH81dTOPgtAxIXKVnAZFlGIfMdDnLLcL3BlUzQ
dnuZMBmHgz8ug+bT2/SQ+FzzeVgLDtL8KHL5m2mgy4E1/HYDDqJGzmxl36GG
Xb49x5s1OOBrir11oEoFti0Fgu4lOOjl6Gd1nyeF5HvhlM4FOND65dqtXnQO
+rTNdm1f40B05mE4x30SEJ4hxJpk4CB0TEntVDghKMf30/yXigOlytfXB26e
AgP5h+4vk3Dwy/z7K2+if1jHVe0OlIiDcyE0Frk2R9ibL85TL8bi4B8XeeGP
1f+w0Tqj1+OiceAb01lVXb2LTfvzuE04AgftXc91LlVuYZusqF2DgnDwgo9F
MT5rBTt4brKF8SY+bhWI7P+2gJ1uTSPH+uBAlb4uQZD7C3bV08LZ2QMHOYvl
A1wWH7GHjAzNxK748b5DwQWm77CkwzOk5Q44WC8lVWwX6sOyhL50NLTBgW4F
6bK4WR1WRNCucccCB6/y5rZ7Or0x6BPb+QwTHKROTp9luF6LMUr4aq9kgAOR
15OuOC/AOCvk1X/VwUEzuzLd6ON+zK01l7MxmjioVWC4+sB0GPMgk8dOQBUH
V7zH/hSyj2HSdX/UvlHCgQL2zGn12HeYosMS4gA5HHyxYYoYyRzHNJd52dBJ
4cD0QS1hoc0EBmctXNMmigONPnHH4I8TmJnz60QOQjjoqOJk1WGdxKy1VVsR
8uFg7B57jp/SJObY62ZV8SUckIanrt3RmMSQM0sS6rHh4KpFjji35iSGbWT3
2iYjDqi+u9NrGUxixMKaKtIu4sAvmXm2/cYkRlXozil5ahykDOW7WrZOYkxm
5S3myXDQssCkO6EwhXFJPCqLOosDq//k5moJ32MCFTv/8RDhwKsgWQdxfcDE
/IwwG/43CJOS91f8Sz5inr1UKfU7GoTPw/ebZnJnMMVXT/+l+W8QXI7zWDNY
5zAtR70mzduDEHP1L7mmwBfMcHlMsc36IGQ7f+zc8viGmbW5cvxvdRDIAx/y
rTxdwPwiPWdcsDQIs7Fk3lYXlzF/24cLtb8NApVv6/emgxUMpc+jw19zgyAl
x+x9VvUXhoPFwPDp9CD89eF9uLS9gREfpSyQnsLr2RL2lz23jVELHz+YeTsI
KJ/tQoHxLsZUOFU/YmQQaPVPxHSm9jGuc2Z5lwYHIel+gt6tlD+YoEd0/w30
DMJx1J0Y/sfHmFil6ave2EHo0+py4e3/h8n49eI1ZdsgnFx6vXMj+xQqzbLZ
q28cBB967p/KwYSoTY9V17J2EG4wihev3jiDRo8/5xxXDEKNtLue3EMStG7r
rK1ZMAhyyelqpFRk6B8Zd/bqq0E4YiC6YXyPAlF1Lm09fjkIHJELhA6xVEiC
1fPlh5RBaDj39faqAi0Knr+x7h41CGU1zzQcxRnRWJOghMXdQbg87/nQu4IJ
8SYvBWmEDMKC6vVkdxEWNKVmc8JxcxAoterfvVBnRxIlWmSfHAfB3Uhh5cnI
JRQfdcoIZzsIdY9tlLmec6Gv1h2pTZaDkNMWMU/kzI2SyCWYU40GoYl0bwHt
8KBfAayCeiqDkDa32j2+xY/U9aZ9FZQGgV01NF24SABl8qTW8svh/Sf/0ltl
Joh0ps/KnxEbBL95msjQbCH0urY3fEdoECIIGAx8ZYTRQUJE1ze+QYiyenP8
aUAYFSnvXsGy/3++K/HDkcvoL111YgXzIOTGYWjCMCLIfNPzbSY93p8i2esW
RSKoYoibNp52EJ4/oBsLOy2KiPK/WARTDkJX94CUiYkosgnPzLxOOgjjwi1M
mumiqM7c/LMpCd7//j7G/mFRdF6U6pIa4SCc31Bw0t4WRU5nR66L/RsAHmPb
jMIzYqjlW0wp29EA3Psnz19yXgxRtav8JvtvAPqvmPdukogh97QjsaPtAfBN
GTiXfCiKsL5NgavrA/Am8GR9d0oU0V252fJxbQCCkk6l1+aIIl8O4eP+5QGY
TIg4739NFPX9WUYN3wfggt5Z/4W/IohlMvd+3ucByN6WM8eliaBbFbaDyZ8G
IMaklGqJQQQNx9CTRn4YgMZTETTnEy+jSw4TBr4TA/DCRVuc5qcwCpF7nGIz
NgDUelub3+WE0Ttq7Q86wwOwEhPU6xMohPh/nmaSGxiA7kAp9fJsQfQh+07u
BewAPM7+r8K3lR9dDpZcOt02AHcaNTQuVfChB0br/FuNA1D4rJfv9yNeJEno
WvOmcgD6Bju1Shm5UcIc22576QD8qB7hFRy4hL43zsiWFQ4AYeXbgq9OnCjZ
wxBis/H6Tyl8ujTOglZUzxMGvRiAI3LB+r0SRoSY+7Vc0gdAZqJ9ccOZDq2/
URhDjwfAr8dA4TIRJboqyTt/ED4Av82XgyTcejD+QYLJR3cGgNUnK1HedA37
rFlE/W/gAFw+OyFMvHyM/aooW0roOwAPLmWo1iZQQKCGdhCF3QCMtet+PfrC
Di9i9fiprQZg5kXMiCbpJcDijGZpzQdAlLtyqZqPG87qW6ky6g8A394gW5kD
P2SZe5FzK+P74e6N+jELMeh+7tfFKz8A9FT+tj1W4rA8E3BLQHoAPBt99uct
JUDMPmxG5PIADNgGy+vqSIH568hH4gIDsHki4xMqLw2h3+8jKZ4BKHUX00nh
koF+t0eF8qwDUJkny6u+IAtrJcmWSoz4+gWGuPU3ywHVzzRSdBGvV3TizukH
8mB9I/umBvkAnDvDeubFKUWIrM3lvnJuALL2zJY2ahWhYKfwo86ZAXCYpSQ5
uaYE68FVyoYn/fAr28PO9r4y0LbVbRr/6YebI3kawyQYkDtuyjfb6we90Fov
3nsYsMO0W1zb6ofwUPOH539hIPoenLP+3Q81NfOpF68iKO7p7bBd7YfL42RU
v7IQjBLhbjgs9YNlWaKG3DcE21qjl5y/9UOgtp3qe1IVoI9/9951vh8oxOdr
jtlVQGlkKs59ph/e3kPHm8Iq4Ew+o+j1vh/gwOV8moQKPDScX/cZ7weXLG/Z
ETEVqHj6LffGm35YyPriE8mnAuOTS2YBQ/3gOnRBLptOBfYvrpEE9feD/H3/
ToFjBMyW623B3f1AxLn5vaEdgUrmtm9oZz/05vq2jngjuD63z3G3tR+C70Ws
XydDkMB2NBnZiM/vxzvW+9kYqHb8Fxtd2w+xiRrLguwYmMojVIip7Ie0Vy2H
Pk+V4c8iye+Hpf1weitaxGlXCdj4yF4nFPbD3s+wu3zaSuBRfoE4Obsfuqx/
y072KMDj3wytKS/6gSXN8gbnmjzUibL6pKf3w30OW11aQnk4rueZyHzcDxYZ
973JSGWBc18gJjsez284P9xxKA1aciJyr2P64cq4yKjzvBQ87ZDJKbzbD5Tx
Sx9k7kpA2jJ3t3FIPzyIyfkSxi4Oz6hoF08C+6GWbWWBx1MUMl03BCx8+mHg
8En4h1sCkEdW0khs0w9R1OI0KQyM0GDL+MZdrh8kRkM+2vqyo6ZYkk1aqX7g
95vgJDHnQi01ezRdoni/496NPd7iRR1EE5YMfP2Qn8fFNM8igvorEhZxF/tB
Jo/Nme+UDMJ9uEMSRN0PGZWlgacrZNEwgbsgJ3k/6K80PanVl0djZur+IUT9
8K6xavjJTSX0LkI8lYegHy4kOC3gtpTRRAl70/hRHzCHDEtuuiL04fjoSGCn
D7q9gOwylSqa5l1j+7DeB4w/OtO861XRJ6Np1ei1PhjnkBy2MVBDc6EDriLL
fVA3SL2d/lUNfS5oePjpWx/MCcZXNXmqo69jeWWx833Q522s7rCqjr4fJL+R
mOmDBfbwj9IOGmjxUuTm56k+2EzPalga1kA/9HxpE9/1wZgp0312YU20dttG
Rna0Dwgoou+/iNZEv17rWC0M9sHTP5V9lGOaaH1YNjypF4/TvLTQoNBCm7s8
rxShD1Ye40L+qWmhbbYLPT/a+oA2/XiY0kcL7WqfXkpt6oN7gfreuvFaaD9g
k0Slrg9Gqoy4EzO10EHWZ8FflX1AzGsa1/BKCx0OjOpnlPbBrOk9ipoMLfxP
1OavUdgHkjLfBP1itNBfptLUzdd9YIljdV6+roUINJ83ZWX1AS5hw5JeQQud
vhEzo53RB4cfpb4Qn9ZCRC9uHe+m9sFbtoz97k5NRNzrxJ6b1AeCir1Ttr6a
6NxvQzX9xD7wILz4bZtKE5HRY67/ie2DTrmPlUUlGohCVTiuMBrPt7f9K1dK
A1F5M5UbR/RBpT+P48VGdUSTfnbsJASPE7b1yQmqowuwv1ka1Adp/ONtumlq
iG51kdbiZh9Yr2JKkndUEZNyt1WVRx8oinZSbqSoIOfkEu8CVzz/f5zkMd0I
lS0k3c107AOmwkHhIj0MUkywz4217INJc9fEX5KKyPbj0Yq9dh/cZy+vvmMt
hQoEFw7NNPpA6L3R++wYCfT77jDZVZU+4KN/tCpXJIYiuF+Iycrh6x8cz1ny
TAC9uilzh5K/Dyg+MAb5H9GglT7WhDPc+H452Dj/N+QMEmM4k3XE3ge250Dt
WuoCpgs7CT/o+2B6kp9LyY8MvpPeJOki6QMqb48a4UY+EHSwZGwixOOdP+a9
R4UgoA4JVfzrBYw9pVvyjCgQWlEYZvzXCw9HBf0HlyWBu6j8mf+PXuB9xTq1
HKAIPn9SStwWeuGiLqclTkEZGvRC22y/9EIsBzX3yR4GNHe0P2t/7IWCqr3c
25yq8ERLbBMz2Qusw8k1kauq8OEF/Wnpt70QUCj4Kr5UDdxUlnk4B3sBR144
xU6lAVWpb2Tpe/G4aIvpfqMG/LfcoEMOeDyHOdbZRBNUFLJsCNt74cKLJ9gL
S5oQ9/i+75+mXqAS+8PS46sF7756RW7U9UJx471m7l9awCBl8nSpqheaPf91
HTlcAceH8vmzZb2gvN1XQTp0BUo/cTSOF/VC4+kkQzY+bdi+fHZwMK8Xnkbm
nZwO1QaFqI3pzpxeILLZL3zSrQ3RUx/W6jN7IXfNbu3liTYM82GPS5/1Qh1D
oRSpiA7QhBVSvE7phQXap7geEx2wGXvE8exJL2SStE9UeetAAWegxKOEXrBZ
lA/svqMDvwJtNKJje2GLgm5kO0QHpHBqFneie4EfIv5TuaED4cyCHn4RvcCg
BKw1ljrQ50cd6hraC+4em666MjpA3nOQaH27F9iO3LbZz+qAxcWv2UYBeNz/
6zetMW3I8Ris1vLD49k3FWbjtGG5vapbyasXyjWUvv6V1QYRymeTEm69kFey
Ez0zewXMdN3NJ5x6wa3QhTbQ+wqExMh9vGnXC6tlK1c01rUgp+ucFbVVL8yz
KO+luGpB39GnTzVmvWDUUmJTM6YJqzIVtkZGvUDgxri3I6wJFAF3P29cxddf
PxPTEakBVivs30XUe2G6gyLyNpE6RHBtuYxhekHl94KFlqwaFNj3LPkq9MKs
iP9FC0dVWJ9yXa0Q74VS2zwvFxEED7pLNwU5esHqOm1Ns74slB6HBgwz90L1
/rbdGWlpGJPV2/Wk7wUtmvKTJmpJYKxa/6+EAq9fgdYl3vEyVGVK/uM96QHb
N1d4657TwcytTnKuTz1A2/GP1vwdP/pb9SSp530P7Ca+5NXiuIy41xyoncd7
wD6+IV6pSgz5OZ6+mIvrgcXyzYtcOCmU9nLymUpfD0SmWMdUdMug1g8FDF+h
B6B0YO9dhRwi0r/Cwt7cA4P2VNNDpkpIII4hB1vXA8Fbgaol5Bhk0LvKbl/V
A4xfdvplGhF6If+IK7uwB15LN7gdu6oibKBdoVIuXs/TDPURJjW0WC3CN5fV
Axz7PjNz/WpIhHdckDmtB2L3ELp7qI7MnPIq2pJ6gMr19uM79zVQSNYtEevE
HmiNOfySRKCJcj5q1PyJ7YEMYtOLj25qoj4aOokX0T2geXS7QfmDJlrV/1Ev
F9EDG4Rxp++KaCGK+Bbp6ZAeWH1vSSsYqoWk+uKbg4N6gFO4aUq4VQtZ/bOW
p7/ZA7iQGxeCfmqhCAXh9iafHkg5xRJ1SHUFFQSdKFl49IBY3OvCDoEraKhm
DLvn0gOF/KFfeqSvoPWfr1TSHXqgWe6TIQs+vsB3s0fKpgdK+3MGv/BdQfLO
ahpTFj0g8Z9clRDFFWSfTTtwy6QHGnWeL/CsaKEH04tXaA16ADULZB81aqHg
8H9ygzo90L3OKsUWooW8OJgEwzR7IIf2i+Z/YlrIrk+KWVS1BxRvBer1z2si
Iw9DsgUlfD/stS+PRmoidTKvk2dyPaAH5AWW9JpIpubBuq5UDzi5y422FGgg
1oPWd3VCPSA+q1dlkqeOqLKmut34eiDqlYDXFVp1RKSyUcfE1QOe7z+Sx4ap
obWH3OnRTD1w6lQnLl5SFTXRJ1mZnOuBSwZX8zFZSqi0vVSX+EwP9I8TafmQ
KqIshz7FNoIeGPjinhLjL4+ii/+wXjroBjLFwWsJHDLIUNb1+9ZyN6S6NHrn
eIqgFQt576d93bCYRkYf6rWFmT00tdXs6gYxPaHT708tYsdy/PT/tHfDuby/
I3diTkPDcr6oU303zAnbBz/2p4PiBCzHxepuWH8ewEL1ngUyRWaoh8q6Qb3+
JdlkPCdE3abYFcvrhiwJTz3/eD4IZBJYWszuhjZegYElN0HwwKp/yHjRDbcm
lbYrhC6DAXFIC8HTblhRsSUXkBQH1bLU0oZH3cB0Y4f6yEcCpAyqMj3i8PyC
v+OUMiSB6dlC+LvIbqBYI/Yz6JYGcoW/vg/CuuFbiw25LVYGCD4zOMgFd8PV
Vvlh03JZ2ImSNPoVgJ+fulC39VAOlnkMVF/7dQPPU8XuE1N5mBnykDDz6gaf
50+/XqVUgFHf+1xn3bqhz6l+rb1VAbqocy50OHVDvsHVLHlTRahvbDnjb9cN
Ud3Z9zpmFaHIanKfy6obvs90Tl0xVYLMk98/Ppp1wzKNhfNaqxI8zj07k2jU
DT0sl02wlMpwT5NrGOl1g0pd/P6KmTLcWlVu37nSDUUuVY8z45XB7bFlRbF6
N4zVZh6TVymDlfitbBvUDaocptFxPcqg9/7xE0rFblitX3exGlSGmLxcP3LZ
bvAc0b1MglUG7I1GA1LJbpiqFNmtKVaGA6UhkXOieL/9VLcrHiiD+Pl5ChKh
bqDxGJ+4Zq4MXh8314n4uiEkZNrpApMyFBQQvT3N1Q26V2/KXp1UgvmbDNUE
7N3gPvHPwStKCeiQcNJfpm6Y5FI/tcStBIZkKjeO6brBLSXtWAKrCHEzpoaH
NPj6aaY+eaevCEe3wij3z3dDcOO9L3+NFUBKNWljh7gbepvk7TMH5cGPIv/t
1ulumP3bwZ0pLQ9fS4aTfh92Qa3L/bmDY1lgvP35xs/9Lghh/eQZdE0WTNS3
DVe3u2Bhmzk3uQL//pxnpFpa6wJ75+PRFW1pKKPxTJ771AWnr21bElhLQFA4
ydORti6gvksQLFbDD1U6zDeHmrogSPuBU7MSH6zQiRoP1nXBGjlbsOBbHrCu
taDuLcPPb5L+Q3SOC9IivLa6irogy/fM05VaTnhzNWIcm9cFfv+mGqtdOEBl
ufBpW2YXmEua7rfimCGkvvVmy7MuoCLOiG3zYIS6e2+Mm1K6gPEmYdQqGz3w
MO9R1yV0wd2CYb8L4zRgv3J2uzoWH68QfvQeo4KMRpaJyugukH84OWc4RA7n
jTRSSkO7IH6f/vrLNmJQZ7UMKL7dBT/99v0c7hFC+Jq3SWFAFyjeMTcaCyGA
puZIiXy/LjiYs2Qt0D/CbjxIpcn16oJVtk9LchT7WH6T4u0cty6QcTVxMpTa
wjqzt09kOXeBf2zP97nwVezLX2N1mfZd0CZU8MnZ/Bt2qvV7SoZ1FziyVg4K
zE5iyR/uBzyz6AKG3ZcaRgRtWC2z86ZpJl0wMpnx+sZII+YeJ5tkikEXjIXs
scWRvsO0rovTJut2QWqDzRtNqxnMdrvmzmOtLhg3KiNwb/qKEY63mkxU64Kl
g8Q4OuFFzHUL3/p4TBeYjP64a0n/A5PDFZX6UKELROX/OnpHr2IapiMWRGS6
oOLSBR+v7J+Y4cfhkh/Eu4Bvs0bno9JvzFe10Pt3L3cBnLP5b+jGOua//4In
uQW6gMfLXWNDcwNDURnENcrdBbjtq3eC325guJ1v3brF0QUPZV7LRFNsYhTo
b/YysXTBaDjB8xH2TYzRqB9tD30XsGxSpGK4NzFuUT4unrRdUKqmEZqDj+/K
eNVTUXaBIa3WnW6BTUzaT3fClvNd8FTqfUus0iam7PV1UwfiLiD9Ly1o9Pom
psvcJZ/4dBdc/O/C/vWqTUzlxZ5lmyOAGq+aBGr2LcynyM7Ysm2A8SyCRL+u
LQzxWgvvn1WAbIyN407mNkbCrGHgyjcAARehwoWmHYwDttrt2TTAwtVBJy2W
Pcwj/nLipbcAV1Q1b8xN7GNaUoqKJAcBjv8jPEf//QCzdJyrFY0FyBKhSKcw
PsLQuGcvv2sEiDpDVhHC+xeDGc+IZa8EkHujJmXSQIC8FdN4/QoAqig/nW54
chplFCYNdLwEcDbu86IuJEJ9lIlupKkA14JHdKf/EKOtkFhi6wSA6VuHaeJJ
5xDbYlRRSRSASnPj9xM3MqRrcFfrvzsAoj4VahPRlCi45c6ypj/AZa+T3MOb
1Ojdoxu8C/YA5t9+Bk8pXUTH+14D4hYA/76eZKReo0cCTm5u9/QB7CPsM5fS
GVG0tF0RqxJA/Z2JMt1wNlT9ylLLRxLgRkAZXctTDjR3zmy5TRCA6xO5Ee8+
J5L+rMtryQjAt9xbW7rBjZy1tQaKqAAmBtcxSfd50ZM6Vbc9EoBZopdaWzz8
aCVWrihlHwtrKROYdylCKFOUl/fNJBb8502IrO6Io8EXnAPMI1iQFfLk8fGT
QLuErG5ePVgwJlKv03eXRPrTtEUktfg4r8AgwV4aEUSd4lV7ggUiKfOJJ3ry
SPjncX9yDBbKz+KY/6opICvzg+tfwrFQZWjIlymtiOoENgrDvbFAybR5OotU
GX1JXdMcccZC/6PkG8y/lRHZ36UlRmssnDuuvXY8gEHXJ+Z4mrWxwFknpHhK
TAWxJQ3nv1DBwszfi+URcSrow9UWznA5LKDns4an5lRQ0tmiV/ZiWGjy+ezH
I6iKtPtTWVX5sTBs0G8eF6CKTkVHveTiwMJx6m4RrkEVtWFuMBIzYMFTWrEo
dlMV3Tqyfb5CiYWuiagYVx41JNyie3GEBAsHLhq1xKZqaClQLrXyXyd4rxWw
XAhRQznivNTJ/3XC/MCXRzLP1dC1ddqkgI1OuM63vsBUqYaoyk+Rm//ohIc5
HF4329TQkPtGguyXTjitcZduHauGornnzzJ97IQUk8r32nhc8dtw7PFYJ3jc
1nyrXKGGdrNbiL4MdIK8pUzpY/z7vNK6KLob2wkbNmJDJwFqyI0+jaCgqROU
+N+kWl5RQ+xTURGxVZ3A+OdKqS+1GppOvnHsUdQJDsuZ7DTjquipvl3o1ZxO
qHw91soRq4p0z189uPysEww8jFlCxVQR4aDcbaonnYDi+f8SvVNBHfd5d7dj
OuEN05RFlasKClK5EPD+bic8PxNEPTmHkMjJqc3moE5Icv1N6fQJg360bvhm
+nZCWubIIUmPMnp9e/5n+HU8X1v2yIdUJWQlOeLpYNcJq+pU1muGiohms+WH
qjk+379b8b778uiBZ9oCsWYnWHGEBzQSyiJl3minVaVO+MgD5vTe0mj/+40v
I1Kd0EZdacCFlUQetldnk7k7IeLybjCNgBjSMzw9yUTUCRlp/7Y6NDjQGbJN
o5OjDijN8kS/PtEjLG5+7MtOB0xTNOyyfyFHYmqtwwULHaA+NxF1NvQXllba
v0ektwPIbvE+OOfAA6NbdirU7R3wMsa7vTZAEB5UXcXu1HXA2kNU9zdVFPb5
+Npa8jrgjWkJ7+ChFHxi+lyrFt0BBSl0ibFBCFI/jojyhHYAz3SkbedZVdBL
a60kCegA1cOp291maoAlTy8ddeqA9wcT26cWNSCPQC/XQrUDengEBt4P68D+
k9ETJ/kOoLkaIfRpXReusupb+4p3QOhSwLQ1qR7syhvQPuDE62HA3qMVMgBt
3NiNJMYOaKGz5t8SNoRsC8PRTGp8fpHKr67SGIHWLaOY2lMdcPFzJY/JHyPI
PDX+reNPOzBT6XQvuBjDRpIxBrfVDpaLBgp0OGPQYJvInFxtB4Z4HGTzmEBG
hcl/n7+1w71P7cti4SbwS2HSdG2mHdIdJz/FjZiA6pBpzd54Owi85XjiRGsK
z65NkZ0abgfD/2Z/hJiawtqSmSdZTzv8PCTYTk00BUzg+376tnZQsa85E9Ru
CqmnLS5x1bXDzJTk/tJ3U1hJ/hAhUtYOnKOPFOpPmYES+7VZ+bx26Jm+cbGS
3gySKz/Kama2w5plSnsxtxksKVqmGaW0Q02o+J0wfjNQGJ7etEloh9NszW+J
uMzgiaWVvnt0O5C8u/6a+4IZfF+eKQ0IbQeumB2VriNTkA2yJo4IaIeO7OOs
7hlTeEQ46xzv1Q7tZfKG9FWm8PWpDaQ5t8PWtEtrwx1TkOKYY35t3Q4l1fWM
KfKmEF9le6fcBO/Xp9Xsik0T+Kw0P9Wk2w5f3N7eIs4xAYkRO/EetXZwPWT7
WKRqArFWnx+/UWiHsmAcS+asMcz+sF+blmgH81P327e8jUHs9hetRcF2OH82
17hv2wgeEDnmb1xqh5hdlpLL/kYwnfL13yFTO/geVV7PxhnCZU4nW2LadmBj
+4/5ZY4BfFB2vshK2A6mrpIZly/qgeDo95v8R23wXW3x++MmXYi0dhmT3GmD
j1f1C1Wu6AB/sOtD3YU22LucwpInpwWhNW5/gnvbgPJpM/XFjxgYw/wwv9/e
BjGRZ9EnEUXgeuNe96S+DWxHe4Tlb8jC6KqHd2F+Gzyiv6ZK5igKbFze8xP3
2yDwk97hxsICpjf9RvdlDfx6ri/8L/mroomd3pNExTZoHrd3nu5RR1+NGRTW
JNrgv0wdNU9qLfSXvLuuiLMNXGlfCddl6SIyn4sbRIxtUD/5SbPxgx5iHvYU
cqFqg2cO0TRCJIZILpamgP1fKwQfZbGT5hsjrUW3r3f3WyE0aWRwp8QEmau1
s8z9bgUVV8nkgGJTFPDXJT1jrhWe5tNGlyaao3u2LeP7k63Q8ve8L4+/BUpq
I6MwH2mFx6TyI6B7DVXcboylbmuFCWFRH6Kvlqht6lzvjdpWIFI/FEl/YYWG
JOz/vSlpha2zIrw0V6zx+2+dovDrVqBTTgw9/mGNlteJ7yQ8x+vxaI2fDbNB
e3o2DStPWsHt12ll5dO2iKi8elMrthWUJGpsm0JtEc05osuFd1uhSXHwy/dF
W8TpbulJGNQKwvZ7sm4qdkisv6LQyacV/qx7vfj5yA5huE59B5dWeBIeiOEd
tkP6UeZsbDatcLyQXTT+nx2y/VJqHW7SCgzUIuO1F+2Rl/LfZ590WuEXw9uA
VC57FPLSZFJOtRUipWR49TjtUdyfIsrncq0w7VnwvI3CHj27dnR1TxSfbyxT
+cBPO1TQaBhnytcK6+Vs2U4tdqietqCvlq0V0mt3WWMD7VDPzQMCKrpWgBUR
dzkOO/TurZ6yH3krOM5HXI1tt0VfLueGjBK1Qj9VncpDLVu0nrjXKHjcAk6U
Iy623TboeFVnO26nBS4TCQSLCdsgUu0ckR9rLVDwrvGT7ENrxFS07aX5vQWi
Yy5E1ExYIX6iK8X5My1gyf1u9BuFFdLq2mB3xLVAjZbSUpv1NWTGpmGLhRbw
CL/1k93bArmEZ2SwNLdACOdYX7Mvvv5yqtQzhS3gZpq7bnPVFD15lq4vm90C
p7rqLbz5TFD27mp8eloLKH6VUav/zwi11aScNrnfAt2+Z9nS1vXQLv/izrBj
C2zvfDZzOqeGPBkffuhgbgHHt3pnnBj5gWj4zWYVbQvU4qoUf0yJQ07oBdJc
Ujx/O8nn8CxZmJrNRTFHzdAYR72jnqQKKjkdJfqzzfDeXuRB1Vs9mDUg7EWT
zUB4kCq1H28It//pzIuPNIPfBfl6RxZjqHD8SE3X3gzVWAwFajYFBq7t0M+Z
zfBTbASRJFri/xu59HcpzRBp+uDlz2IrMHgQWd2T0AxfJDgunGqzhgdLZItF
oc2gM57uHtNuC+zPTP9mBDSDA+m3wMVSO2jTymRI9GqG+3LhL80T7WGjmE//
hnUzHGaleQ/SOEKCpZ+7k0kzhJpqZrX7OQL3ucYoU91myKZeu27V6wjQevRS
U60ZjDv43G5SOYG1l1qTrEIzfl/9Pv3R3An2mOLfCUg0A1kkU51rqhMkj7xd
YxZshvX5r407OCcQCqc7Q3GpGbgYLZ+47jvBgLAdOwFTM9StV3/JZHYGp/l8
+W3qZhg5T20dIecMx4/XTBfPNYNkgs/QoZ4zPMeI+3041Qwxb7m5CKycQWIj
OA73pwnouGOfRts6w5tX2Ly2rSY4T0FyN/SaM3gYnemsWG0CXLxO6qKOM5w+
pfcx51sTzPJ+HOmWdIbs2pSt5JkmoKxI9aK/6AxyzjOk98eb4Kzwwr/1304w
QcPBGzTUBNmWUW4WWCfw7XVTce9uAtKec+AQ6wRnAyutrVqbwPKJuCenlhPk
c+8GXq1tAn6/hsPGE0fAvFdIUi5tgmtBB5JKlY4wExNVKprbBAeXfbc/mDlC
oAyul/NFE6xoXVO1XnUAyh8Un2mfNkFLQ6f2JKMDlD03PzgT3wTBFIeptxXt
4evBd+G1O03wvVdHb9rUFsJKBa7M+TfBYvhTreCrNkBn7e805oHnV8GKnZKx
Br32k/Q6yyboVT85+b50DX54a9QUGDUBrUddiHGFBUSzJA4/026ClPSLCR/d
zaHlLsO/ULkmIA78+/d5lwlwqUh6qDM0wRzjs/MkdLpwp0vfOY6yCa68t/R3
/6gFoyoetm+Im8C36yHhu0R1uK2abXRtrxHEFi7s3yqTh2E1EnnviUYI1dK8
s/PnCMPeyylZM9QIjyUW3DrUOFGgutLlvS58/EZ92vJYBLFp3OSMrG6EpTPq
FXaMyihAc/Zc6qNGEOaI0jFsvIoG+/cIp+83guHIp+KqOQPEokX1lyWsEbKK
mi3U/xihAS3N7SLPRrDdpH1hu2WKmAcdfv10xK///MzNL7bmyP9K6LKYZSPc
4Q9/r9thgZi0qz+1aTWCnkFL0HtTK3QDNzT1T7kRGj33BWMTrFGf9uKYhnQj
OFmqqarX2SDGob+4eGE8flI96D1si/x0GHvHuBqh9/DgpseEHeodkuykZW6E
f+/v7ZYP2SMGXYNmS5pGSCKZsKqvdkC+wx612ecagbOigp9QzRH16N4v/07Q
CGes0tqZ8x0R/Uh2Id9BA5AWaetuHzoin6str3w2GsCDvMHHRscJdY9MvKhd
boB0meVY8SdOiE7vd+r+fANIF/F9NhtyQt6jJE8U3zeAd79IWfmhE+rSuxR3
b7QBujm8Ll265IwuvlGK7u9tgCSsxcMy5Iy89K+Fn29vgPrBWT5lU2cEb27e
NqxrAFGHYudpW2d0weCRf1ppA7gVJObfw8eeY0VeM68b4M71eVsVE2eENeh2
ZctogMi06WM+jDOifTtr75LUAC446i/6HM7Iw3DfsiS2AUJu/ZUfO3BCnW+p
TH/fbQBh+ddnRwadEI2RkL5EUAP4gPOm92Mn5P5O80qwTwPUdChzfcbn22Hk
qNrh0gAv40UxZieOiHo8VPGUTQP0pfFxE5c4IjfjdGktkwaY3A95L6briNrH
q0UTdRrgdeTmQ2GcA6IyGRZ4p4LHPV5eOfxpj9pM/rFaizbAnOAvrVPEdohy
kpHhFW8DdBXOaEed2CBXUymaRdYGsJy/M5qMP+8pzDyJ/cgaQOeA4iN6Zomc
zSfXo1brgUqHS9DrlikyKb43uPG1HqxXuJ5IM5sg9T+XX9tN18Ni7h8Png4j
xJ0dZyw/WA/+cq+XQmeuouVF5YbNgnrY0QrkuqWCf//K/Hxkn1UPh4OsRZu5
CmgwLuP6aGo9mP3tajXukUIlwjt0JdH18C/B71QTyyXkHVgS4uBYD/efqlF+
zRcC2wFzkzfX6sFbpog90UYS9BgIhRQN6+FDpXBrxqgciHTYzdFh6uGrZ1LS
YoUqsFGQNj6QrofhqGh5DTkNoHRsebwtXA+T3pkGR7VasElIi8aY64Hmtq1U
ofdV+GreRa9Ei8/Hf0bOqlQfxot9N0vP14Nqgo7dyjtDqLuKy435UwcyGXdf
rPwyhrzsoNCdzTrYDLVZbJ0zgdSNS6ZOK3WwfFWGoQdMITD1LpHyxzrI/kcl
y2tvDq5LgvNlY3UQ9GivaovBAsxlpxsZBuqgo4fTfbLfArTiY57EdtbBZZ/O
upeu10BmVsJ9t6EO9g5Y33PvXQPey1+Rc0UdJHPZkpgGWwJ95GOGd/l14Hyt
5PaFn5ZwdlxhS/llHXTTOio6GVnBwaWVofKUOtCk+a2tiD8/VwLT8xgT6sBf
KNSiasMKZgbUwh5G4fOxeNr1VsAahhk2Tffu1OH7v9UFa24NbV7Zwi7+dXA+
Tdw/75Y1lHfonhl3r4N9+hWZyvvWkEVxMI9xqAPL4E8bDLHW8MixsKnCog48
PU6H8odZw906kyQmgzq4e+vMRT4Xa/AjIvCI06wDwQ8zFzww1mBvUamyr1QH
qhWZSVrk1mBYYs3oKlUHWp5DZ3jeWYHKIcn2uFAdzBKiM74PrUBMr3EYceFj
bZrBJ5JWwJnjnF/JVAfVOlgcwXtLoNmkDGemqQMl2g/4zcQSTqt1msWfq4Np
3eeGo3+uwXaq1+X/COqAWKzmqkjENVhYoie+flAL3H7JiZt/LKAvPqBZ5Uct
PPWrN/4wYw4Ns+zJVZ9roXX0st8lZA6Fl994sHyoBYpzF4/YcswgdpyP6aCv
FjgZbP3SrpoC4e3Bd386agGz+7NSu9gE7jG5PzxqqAXHCI/O9H/GEOpStPu3
AB+f1N09KDYC3z3ut2diaoHm0OmV+chVWHvRF0NytxakzGd/f3LXBTeMq9K5
oFqQXpDiNDyjA44P80vJrtfC50/N9alaWmDGeOkBrWYtEJcmifz3RwXGO7sV
LirXglu6gPZpbwQGzk5bdNK1EM7OUVq8qQTa5a/tmXhqQfb2IkOJsBz0G6pc
ZGGthS9htl36S9KgtvtlhPViLailX7zFUCsJisrs8pxnaiFQ39jTnVQUWr5h
Ny6d1EDSw9M73BxCIBVrX8S9VwPsXEaGLk58IPI2m5Z/qQbYNoLpfHw5oPyW
8rDAfA0EPyhhunmLCfgZ5u8Jva+BnPVROhrvC3DJiWVdpL8GnBsXPUa3TsOr
Mx0FYp018CHO87W44jaWpczGRqKxBgLuCYh3k3liXxgcUUtV1oDnIWLkrNzE
0O1k4qQLa6BAxN+U+eAfJvW5QqRsdg1cVU1LEFonRlRKn6Tl0/H6KHpPl4mT
o0dfQ34pPK4Bmcz2KGI3anQuhjFfKaYG1Nlbpka+0aJYgVYrzN0aUJn9bpFP
SYdOj1lSqQTVwB9FObbrO/QoMuBgQNW3BhLVaTPRU0Z0TJdxV/16DRj9yVit
/82EQtplpTTtauB2xfTaU3IWtO/wcU3LvAbah5eJdvdY0C2i4Fxtfbw+qnvV
ChWsaLOEzlJXswauRe63kciwIV/9Jgo95RqoiFCxkX/Bhta2zPv1pWvAbt7y
z+IsG3J/thdmeLkGzLCCY8ZE7GhRIV3CmKcG1MLDdHcY2JHTF6lVE9YaoOy6
Y+jCwY4+3596ZXaxBub6XyvacrIja/5ACwvyGlgb//u27hI7+jhKS255pgYM
4pu2DIXYUcl3t4f1h9XgdfeSnqAaO8oVKtptWqsGrr7Wj8iPHWUGLjm1faoG
qRR53aQmdpTWyf22c7gaEnY1285Sc6AnxK5K3W3VcMYrWmfGhgPFGeaX9pVV
Q06p6TAPcKDojO90uMxqiOC8UK2P4URh3zgfjCRUwwfFXuLXc5xoZehsbWBI
NUDUR1Kz6kvIom5jntUDP19lgz+yigv1ZX44P2hRDYmqfdwn89xI4n6nrL9m
NWzYs/+JVOVFr70LXBmlqoHRSed04hwf/jxLfNpzqRq+kw9f8asTQOFKAVhv
6mrI9O74rjoghNa4rX5eIMDz5e/HfGMSQZbkKgzY9SpIQgx0gVZiaGCPV9N9
vgrqAtkPzHHiSOozeQDVaBXU9radY7WRRHkDuzmtbVWgOn32ZSmNNKKqnh1x
Lq0C0zu93+s3ZFDE854D0owqCHgrYjK8LYesPZJN7IOqIDdQ0inMRxnhjIIj
SVyrINGnqtZsASEZefuKGpMq4OlVfWStoopozgsTE4pVgcPu73ksnQa6t00j
WcGGXw921sezNdH6pz8O5uRV8CiT7N2SzBU0VD7YWrxWCT6dxmktWbpIJq1q
2WimEq6HPaci89BDBeHptIeDlfCrkOFFvJoBuqfv4qtXWAmdcVvPEqiMkdzG
X44th0r4Gv1roU/cHBV9XNLPNKgEu3bT2n/qFuhC12iounIl1JG2NJdYXkOb
yZlT6UyV8LwpdWcuxgoVS8jEKbyvgIbIn6cW3tuhC8ysjQu9FbA4yPxw+5s9
iiYk+v6orgJsTyWQdaw4IPupccUvSRXQWXh3hWLLEY12tHjERVSAwveUGmVP
J6RQ+Cpd3LcCYnGq2Ulz+Pvfbd+N+7oVsM1Jf2xS54we2JuxXJavALLqSs0c
Whe0raWo84GvAkrNfhp2+7ogR9FLtyPpKsCgmeWXQJcLGqM/l89/pgLY/jvh
vnLeFSkRbL4d3ymHU/9VdMRfdUVlKx+OQ7+XA9WDrXLX+66IYbxTgHu8HCgL
I/P0a11RTGuBxRsoB+X70w87p1zRdm7i/dtV5TBh4HUs9tsVOSYE1LBnl4MO
R9In/kNXNBZgNY9LLAfZkHPNgkd4PhuV8wGh5dAf/NKxewPPp84ny+xZDr1r
ZvZ3P+L5hClc+66Vw66XlM8eni/2wl6yr1Y5hPU07Q1EuKLd49lOOulyOJTa
fPxM2RWFJhQX/eAuh8jdOo93Oy7oFMOtpJYLeHz8h75htguKK8TciScqhxMj
kfez8i6IQvK8k/VuGVBvD+hrDjmjtK73OkKLZXCpwprE+aozYjbIlTieLIOc
ipLnlF1OKG/Wh/lNbxnI631jkeRzQvyeckQ59WUgLhgU3nrPEVXtE/72yy+D
yywaSqIvHJD0g7fvUWoZyL2m0Eq/aI/UXrkVfwsoA8Pbv/SzOqwRTlgiuc65
DBq/Z91++MMSGbad3LlvUgYffwdY1f5ngWzfp+nySODHH7sWMg2ZoO/OjpL7
nHi9+hT5UolGyHNTiGWQugx4QonyY/D9fJu097fHVinEfsv1DAtTQ8mqW8kV
NaXAees92VQPM9C97Qi5+7oUftN/+abeKAHZtnHOBsmlIFd/IdOlBwNlwexS
mzdKwdCosDFp/Cr0Vep/lBQtBd6mNiHdQ2vQVWTsImIvBRVrKaGWa/Ywjlss
eU9RCk/rJR1PfXaEzwthocHrJeC6xvtVWscVDhjLWNsrS+AN6WKt1iVviCgO
In6UXQKkFWXj+ZM+cEZadcP2cQk879YOZIzyAxqj6a6/PiXw5e+LL7zL/iAc
S+yqJlwChmlN1kWEgVBHO6FHy1IC5SnLYRHYQJDPzZZeJC0B6424NN1bQaDV
IUUS+7MY3lNR11fjbsOoDsGmxWwx0Er9iVb3CAbTjyPTfCPF0JKmfbf7XzA4
bjuXDZUV4+9ZXhrRF0JgOVIkNTOzGEwaHha8SQ4BX/LDMO+EYpjtFT64QBgK
u5n9rkqhxUDUbOO44BUKofxP9cm9ioGzNVtvcDAUTjXZyny2Kgbid3EjJoxh
EKfOz16tUwwKDrmfmB3CgGJ8h+SefDHsXXVv7MgIg3R72DQSwOvbteOa6g+D
5ESJF4P0xUA/90udbSUMEloKVTHExXCNw4D0/WEYxCwxrDXsFoFW8JHe05Mw
uEfzKEVooQhCI2xHdzbCIBT9U8gbLwIFrdGCwvEwCPIJWGDoKoJzFyiqLPPC
wP/FUmJSVRHIcn6ZG3QKA68BSyni7CIwrjN91UwZBtd3RubCE4vAVqtGar88
FBw5UMxOSBGMaPkT2MqEgrV+3WUvjyIYGhCZHqkKAfNQng9fLYrgGhmfnuTF
EDAqzoi4plkEyu/PrCV43gHdKVK+MckiqLUdCPlQHgyapyLfalwqAklLKyme
udugIrId3E5VBKoUH3eeHgaBos11Dol/hVC9R2CnThIEMnHTuJLfhfCp4dMp
n9OBIPQdy/hsuBCiSVJiBfpvAi+lRA9ZayEoxfr+c3jsDxxKhV73iwuhlSpo
IzfBD+ieJbb7PyiERz+pNi3IPIGq96/Lj4BCYGTlSRXlcAPSzZtk9k6FkM6a
RxBH7wIEupZ2VzGFYOfrzJPibQU/T7j/8RwUQPRhndjMjUtoWTCjOGu5AHKV
75N4K6ujr9dIjWjfF0B3q7p+MaUx+lC79ZqgrgA2I1552XM6oq7rWLVZ7wL8
/VdhaqfjBmpPEf9pbF0AU93ZCT4fbqImKEjFaRfASXqgxNc3t1A5Y+JiI08B
cJM4/YlpCkbP3lyLTf6SD9kufAKxepHo6eGwCMlYPux1qIVJJt1Dj/gwH+92
5MMjxUr+vYAoFBXFze/9Ih/kP9MyevDfR+FVz999e5gPbyQd96cP7qPbs+dD
LG/ng6yZKvPL7gfIR3prSNM0H6alWWvy5GORm7NrQIdqPhgw6GU3/ohFTkkf
mSTF8mFimzKnMfEhsu3Q7S1lywdiplpSap44ZLHa6c1Bng/cFNHECvVxyJhO
/MLzozwY6x6aL5KOR3rqBR3ka3kQcenD7YnyeKTlT3/9wXQe5DzeqVO6mIBU
sxPIjwby4HTTmSmvmwkowJfrVm9jHrj8MSfOxCagAuWO6cSCPPil5Ft4+W8C
+kBujjFLzYNbwynDPaKJ6Ozn3/ks0XlQx6uxcWySiBSqYs8t+ecB3FBGse6J
yCeC/UalQx58Tvj+g9I3EeUYtEwFGeTBK+p3riYuiegdm7ECRjkPRF1thsh1
E9HpjdVXxMJ5gK0dJj7PmYikIPrMW6Y8ON9MIUq/koDckpi9n5/LA2W1oXry
VwnouUPDO4eDXIgm980d00xAOFF9Gf4fuSBGovlBfS4eHf5bern5PheWFiWk
HZ3jkfC7iFOtfbnwLHl/kn06Dtm/pnePqs+FGwwT3HHKcSjZv2ZUJy8X6LYc
mEtSHqIeFR0Jmqe5UKF1Sy/jYyzapfr+/FNkLlivzJ0NI4tFPN9CT/L8cmHc
cCsgXDwGWdTSunjb5cJlTPWTCa0HKC6qAieplwuxUx56nXr30S/Oz6l9Arkw
M+HJEy0Uhdi2b/95xJALya7/3pKfuYeMeigdzElygZSGzPhS7l3U4KwquLz4
GjDYiutZEXdQWH5BF8nr16BrXDOUKuCFKm4p87578houlNW7V5x1RZ/VPyRm
3H0N7EcnPXP3bZDaIsk1AZvXoBW44VLzgRGd5/H+rUv3GiqE+UV8zL1AaY/Q
lPbMa8gdXl2yK/KH2QT5m80/XkGj35x9KV8g5I1kkczkvYJ4wZrHaZJhIKbv
IsXC+AqK987TjGY9gLTfaf8q9nNAi9zfcdA8Fg4eDwwrT+VAFO2dibRzcQBj
Ak4OSTkQ6S/MFGiXCJdu2Ahv+uTA29uzct5HjyCW8vF/93RzQNZQSp4g+QkY
GG0+zjuTA9LPbsx6jiZD3SanleRCNjDf9ZKMjHkKF5+acvd1ZUP1sb3eO9kU
mBtvalsKy4bC7h7iS7GpoBKwEnPbKhvu3vhGwsuZBgU0TMYkstlA85RfwLc+
DbxN7/7g386Ck+hk09X2dCDA3BE8N5EFcb4nLJUCzyCN/5bvam0WhHcIZeo/
eQYCtH41Q0+z4M6dE6mg1WeAPfHYKb2ZBeX0kaXjCs/BdMVFJsE4C16cdCpc
iH4OKxP2IV7iWTCmUrG8hX0OdzutOnSps8A0aCeDa+s50JSY/RPceglE1i9t
3RgyoDjFUI10/CXYins+CpPKAKW7ujE/a15CysOZUwKaGTDurokbSX4JrGXZ
avK6GeBmokJa4f8SpIrDK8LUM+BISdHgkdFLeMAd/apPLAOS+WSe+oi9BOd6
u6Lf1BnAQyM+pUf1Ekg4Z7PeLz+HtmMh+submaDOYT3lWP0cDH/wWpO/ywSL
uMsyId7PYXGcM/t3dSb8EBp2oWB+DiEdLF/fJGVCgmX11EXsM6AopuequpEJ
JpjtrQSzZ5D/lMbtiWEm9H64JnrjczrIhZOX+olmgm7zCuewTTqMup39ZUCZ
CbxhP1NLR9PAyZhQVHTjBRx7Sz3jFE+DfcW/Nynf/o9j+46n8vsDAF5EmS17
lCQhO6kkH0lEGcnKir6IQoPKyp7Jlr33zN7jubhXsrPKCiVk3WtkNfzO/f35
fj3znPM553POuc+Nw6LrqkNuB0Zib/h3Kojv47BeVQ3FW0MRWMXvFZkSuzis
a06C/aFKOKYy+/N1mHochlNWXfrxLAz72jeDeyoahyWaKfdscYdih7JHlSRW
YrFfjYbCRI0gLClsKPBoTywGpxSGZm4GYpIufV2rRbEY61DsaWMRf8xIs02r
zDYWCyxzm6yo98KKd0tNzi/HYNdNNHyCaZ5jij8K0453x2B4zYKPmzhr7Etv
zsx6YQwWc/qguPkzE4wiK+lRhU0MtsfHMdCfoQK6GoEvLyxFY8W4W78jqp1g
8bJPLXNXNFaWlca76+gOHnzuf34VRGN1dM7iPGlekL/j4FX1OBrbd+XVoc6n
AfA3wzTk4uI7bL9AIsOl/REQEWL4ibXzHbZQJnqjwzYS+J10mbbz32HjkylT
acNRoKl+O77m0TuMi9/yBW98DGRuX8y+vBCFsX5hF1MbSIRTvF5WFh+isE/q
r7h/8SdD8q0uofDMKGxMkaOY+UkKxCWbFs+bRGGcYhc+uC2lAkt7/jMm2SiM
zfiF6AvXNIha3Tgvzx6F0Q43/eo+kA4hioE1MQORWIQLV/30n3Sgsxtwbi2J
xBQmb0TjHmdAQAz3VWJwJKZkbMmu+ikDqJof7nE8jsSqI860sopkgtdCabPS
zUjspWZ7dJtbJuwd/+P9/EwkxntF3WyLkAmuV5WUkikiMf3aur/qFFmwaxl2
qGMyAjPn/i/25fkseBU22vGrIQLD1XKvct7Lgo1avuBT8RFYwEuRxNXnWfD8
u52G2qsILLwMf63YIwuI9LVHnbQjsM+Cf8aOemWBjTTlYKZEBLb9k3197GUW
/LyvFt3HGIF5/z7wZcgkCywDY/T/LIZjZd6t492Xs+B72TSHwMdwLGxr6k3s
wSwwHT83cTc7HGv3Svh8pD0TJqheprh7h2MC6dU6bC6ZYCCGMyswDceGN0fN
Y3gy4Ys+Ld/nq+HYgTp1k9c1GaDjpT1LwRmOydEyYDiFDOgvSM4V3Q7D/nj+
Vr+PpYPm0Pwjg6EwrFXo0g0T0XTo/icp4lcWhqnRmlh3hKaBqsBrYmloGEbl
lCtR8z0VPtz5UDphE4ZVn5qYuC6UCoouRx1oVMMwvzPd3Kc/JAP0ZG2bHgjD
cqxUG3VNEsCROPmCvTUUqw1pjej1jgN7BYfdp69DMd1fib3BYTFgNZ9IybMW
gpU1ZCuqP4iEB1ckAl4VhmCX1LKYywXCwTiEQN9rGYIdxHV+VywLBi2pFWa3
sWDMON7ssfiWN1zxAIFx/FvsVgfbA+7C65j0wEDhefe3GLHcpH7C4DEmzm8l
EXT5LcbiZneMidMJ4+sKk5F5H4QFTkmrU1wLwBjZvt2OjXmDcSVVnluRjsW+
Ffs8034UgCXhrpwiyOdiEFPwQ1UwAOPYUq8bSczDEt36712b98ec+ynj2Nfz
MV01HgVRS3+syPy+wuSbIqxcSrmK74w/Nu2++Kil4z12hMtOiHPGDyszGWFs
21eCfVyoP3bogR/WNugUCAKlGH//N79/PH5YwJE8EbfyUsyrlub3xqQvtmWC
t/C5VIZNpoo/WUz2xegftn2drSrDZAP0vk8b+2LqdT8tZUTLsbgnbnpfuHwx
E2vr40zJ5dimblZnz5gP5qnqYUlDXYHdlesCQrwPlu4S+6LEogIrObNeXn/P
B6sISTyc2lCBMTBwCJSx+WBcaYbfn9BWYo825BNzP3tjF9+uZtWoV2Ifxh4e
SYn2xuKk+S4zBVZifK0hPu90vDFz+pxP3LWVmGd+5XYQkzdmGXiB+/nXSuxr
+LiN14AXRtv1wqp4uxK74kQ57RjhhaWyRuFfHKzCYk2FdJ7c8cJYbgQIP6St
wn4p3/loccQLEzm1mXd2fxWmJeZ41ajXE8M+xzkZL1ZixSwppVohnlhNooRY
aXslRv+PcEZFzROrWxz60h1biVn/WIoDek/s1GjpKTPDSqyt6zijdKcH9kiQ
wYHzSCXGWyHjJfzGA7PfjuMoqarA3BPMNnlVPLAfItumQ+oV2LhXwCP2Q+j8
DdNyxS/l2PNBk8aTIe6YJ9GmsU6rHBPOKMyip3fH6Onn/bcay7Afz3aDdwLd
sHTp7HdN7GVYsvzNl7MH3TCc9+29YYtSTP9wtMmA72vsyAeKELr0EqyrUEKs
yNMVS7Ofi2QcLML8XNxZ4/dcsMU1yZqVhQJMXrV7z++1C8YibsxUMJWHVcxZ
9Zk6OWNp83I7lQ+zMLuqqhq1LSeMOF/kGrudjgn4HkiTeYHWYZNHn7s/TMUS
eFOfMT1zxBqFlqIJje8w7dXle/uJr7AzoUNBs4mhGCPuisKKzStsvc+KQuCC
N+Zl/PlYu9VLbPl85ZmtQRuQFT7zu2L2BRZ06g2z7kVf2Nx9/j3N/AU2b1NF
VTkVDo9iGStcTB2wBlZJ7fL4VOB7aJRo9dUeS+7WnWBLz4SvF/J9dIzssZjv
B5tTO3LhzsANHTH959ifr6IGC00lcInx9eY3jadY5ZMi59/idaC7TAytT32C
+YkZmQrkNIBs0w/J0jQ7LGr1P4qEcxgcNP3kmJhhg6Vb/IpjF2uB5IzcA/Y5
VlhH1C3DlpIP0C2kx8VTbIoxsxBa579/AvEz/i9VelmxO4GNpfIGkyDq+lrn
AN8+EHN+Ms7FNQXFmhSz2Tunwei95SpT0BT8Zs+87rR8GZbX7AZLraYh7Z/D
8wdzt2HbI+h0Nc932Hg6QaNnbgI83gMmh1/MQtTc9vQFCVPgiuNzbBmbhfcs
lCAvbgajH0IoHl6bg+8OrDvaov8B/55GoArNPNyWkLd1E3oIjElLBxcDf4Kl
qWpHgKAVbP0YUkme/QkeodpnIwWsoULWyHr42gJULFtN5/A/hnjBUMvs9QXg
zg/X+cT7BCitli5GX1+CXdKRcYzzKZx7fSN+MW4JZunvMbBmP4Un724mn1pZ
gibFn08Idc8AH22vdzBsGfJNJdK4bjwH83aH6syJZYh2deq3730Of13Vjv8T
WAHbCpoLvDP2EDsdRtNeswL6fXcsnewcoKoliUf47wooLsXF9G07QOXhJdHz
QAQuPqFdN4aXoOSuq8feQIRD8s/PDce8hOUe0W+rm0TYMKwzEuF9BUPhBN4S
VhJ0RapiY9KOoL/0ZcD1NglqiiNIks2O0E5JceCYBQkyO0dPvbnlBIZTpR7P
XEkQNsd7d3rICd5NutMlRpDAlfKxzyVTZ9CtKmiOyCGB1cnyytAFZ8io3uPQ
qyeB9pXfs7MOLiC+GTa/0E2Cc/ZBKu8CXSEzums0kEgCltAB56Xjr8H/9qG7
8f9IQFHAWXg9+TWU0l/77kO/Citt/03EC7iBy+0uSjX2VRj9VsC4VuYG1C0C
rpt8q9D2bx1UrrrD870fpr5iq1DGIfss9YM7SKw9Pfrv0ipocCp8+i3gAV0m
bRcsrq3CDcFZ67N2HnDFhb4Bu7kKMhffUNwt94CBQabhYxqrIH5DNMFt2wOW
qz5s/qe9Cvx3+8/nX/WELU3n3hr9VeAye9k15OUJ9t/E1ViNVuHYEw6L/e2e
8EKm552vySocet30V5jBC5wnJahoTVfh35sH0fpaXqApoyRUgLwRSy3mE+MF
fHz78E+QF7LzPxSPe0GL7J0mk/urMFWhbjp2yhsWnjGKuRuvwnDL2jb1Q29w
5OvS+mKwCl190eGShd6wea808JneKrR8lREyWfUGa5vr2lp3V6Fm6WtLoLQP
SOef0/RSX4X3u16GlS4+4H5vW4pGZRUyD53dmML5wJGI0b4VhVWIZ+l8S0/t
C5/uP6C6IrsKYXxPzly65QsjyTL4X1Kr4CpfrRs65AsTyW4zw6i+n6sbEus4
/OBugpMRA9cqWBnt+c/e94NbtE99+4+twl1H5dqrC35A9UFNRHCPBDf9Fu9Y
i/lD652Ilo4NEshFhS5EOfjDMqWBGOcCCYRKPnMu/fMHI/+Wm/MDqP3nH7rF
Hw+Eu9MUQQxZJIg2czp7VjsQNC289vfGkUBw7E1feVQg/Hcjp8YthASaPUW8
3cxvoFsk5QTuFQmSK9bb9liDwDCX97OlKgkkRamevtUPAqkVaYaLQAJCDgs7
e1wQ9N7+2cYjRYKl+MuPJTnewlHP7e67J0hw2dP9sAVXMOjdcbls/ZMIXbth
NatGwWBSstuZOEQEU4d0M7ekYPjFKXdauYUIfg8J5TEnQoDu1oYnZxIROKaH
jfjuhwADQf6uVhARigzmqUpTQqCrnNWF3ZkIg2p0+h08oUB5TkrX7h4RrD5w
7dczC4XQD91fqVSJ8FteNP97WiicE5h9eO0KEY6i4Hc7GgYmVnHUFSeJMKpb
2o+XCAOHmPrV1WNEyDwuc5ZOKwwuDs4HTFMT4VLwrb6YiDCwcH6mNklaAQrV
Qb6vZWEQRVTXX51dgS5qYye+gTC4+Xyss2FiBaJbf3Q/Wg8DxfWLxQpDK3Df
w4639Hg4hF/ufu/dvQICV7debp0Ph+nFcG6PthVY23HvvKodDlNPnm5exK1A
Q9UhHh+HcNip7ZzIr1sBP/twh46ocFhm5j39pXIFNMU5Ph6pDIf7y10tTaUr
wL6czq03FA5ZruMPjd+vwLe8c8+TfoXDA2tGu7KCFSi0rGj7zhwBTZxfv9fn
rcDL01c5haQjYLiq6O2r3BWQnyI8eaobAaf9qL9/y1kB2iR1fNXLCOgpJHL8
Rh6495ntb3QE5H++x9eIzk9kMbW9Xh0BsY3JRWfyV8ByYL458HMEUHAd55co
XAHxsGcsfVsRcHI1DzeG3mf39u4jFrZIyEvIeXmqbAXwNN6Y0aVIKIn5j/Yf
Kk9wGx1Thn4kvHBipbVF5dX1jrL66RgJGiO1/dbYCvDIczeKxUXCdO/3CCJ+
BRb+ZB19WRsJH/MwtZ2OFaioFbVsGEHzZqe9Cc9PK6B8Xv6wCkcUHO5kkNid
XIEjpPb/QmWiQMPpx87XuRUYLbxTM2QQBfeoFPKFUXva8f9n9iAhCowIkmmL
+4mgmZkobdwUBfM5sgEn6IkgwTtMpz8dBRxa1M9LWNB4z61SpXb2HeRy1Tv1
CxPBiVmM7nL5O7iuv/P2ghERfA78rjjcGQ2v3vtsVOOIYOkl9YZ2JRpiVBqf
yHcTQXmf3X2qozHgW0PMKh4hAu2fKZrfujFwtXxv7uwaEULX20xmv8XAxE/R
w9ZHSPD02T6paapY8Pr6boDETAIt4mWacYFY+OfrpqjNSQKmxcLyT3axENJz
3CPzDAk2rWYDusJjwWU6pe2tEAk+z540+VARC3f1xsqUxUgQ/y3iUONuLJgf
vb8gcgnlG9OuiWruOJCxtMLryJLA+CtVeZl8HLQQrB6oyKPxxQgCiv6LA0Ym
DouDiiTgGXU0zvWLA5NFw/AQZRLs1y+TzMiLA4KxWt8EGh++DS0eTO6KA3FN
LbENNRLg756ZiCXGwbuqA1N9miTI+mRSFnksHiIpj12yv0sCP41Y/5AL8eBx
hqp0VAflu+5PRoH68bBs/3eOWp8EKrfoJH1c4mH6n1bS1j00vn1UPOieHA9e
pQIVhYYkoFd2G3dqjofVziUJfmMSLOOrSx1m4kFJuv2quQkJehRW/Z4cTAAq
ub8nH94nQQlOyOiRUAIc1JG+JmZKggg5cwkLtQQwsSYINiLbNyRRmz5NgEGP
QY+jZijfynweM4hMgImLAXQiyNI1R0p1qhKAeYKp8Agym7Sqn+ZIAsgNtZmS
r98p9za89ScBjCn2FKSQRyUaxZVOJsLwymm/l+j5DcWbVNcUEmHbIeClL3q/
ZBHxsSsWicBZdtPxAXp/9wLrEumARHDcd4L6sBEJTAUzfCUKEmHvg1DJWwMS
KOSMGwj3JELWWhPHBKqf02dYxM+uJkLKR+a/+/VIcCBDg4qXKQmojjHy/NUm
wYfklmJWgySQom1KeI3qX2a4hPaJaxIMRUhnH1MnwXuGFIu25CQI3jc17neL
BFGuLpwvvicBdcdUPJMSer6BlH+/TTIssqil/71MgoFw3m+CockofzRR46VJ
oPTxyFXP0mSQTVIacjpPApFLy2tim8lwdr2MtkGYBLvM2SbB7imAzxj+OYjy
gZ1aVO1MWgr84fqVrYnid9rHi0kWnwIyISTJLjR/mnESs3hxIBWYaQycOlD8
d8zTcfKppMJD2jPjrJQk1L+82zUMUiF41gv3do8IV3l2X7g8TgWjekZJ6h0i
lOjN9/UHo/O7PFoNlogQ3Yb38+xPhS+mnC2jg6h/f7siVYTW8TjZpH02vUSg
+Vc2/WUjFUis9GJiHURwvZAmK86aBgPZEc53Uf+VvsO2YCiQBg7rP5Vr6olA
tAmN8b+cBqdJA+a61UR4kPl67athGkj+mlRQLEbzRdxGCq1tGqyXxbpGFxBh
aOyxmrRbGtgPrG7y5xIhZOvbrlloGswELgdtZhLh5nGD3ODUNFB88WSFKp0I
FGKfdGpL04BWxTlfJ4UIDao3KX+0pMFYtteZ2UQivLTESo4MpoF3/nBydTwR
xLykTWR/pIFxMrt4RywR5pOK6Kw208DoxkA3dwwR0mv5aiMPpoPliWM3y94R
wWgowRJjS4e/v0/e8o8iAsvqMaZFwXTgvn7TNDGSCH30b5pZrqSjfFG8Qoog
QqDA/icKt9Mh5PMlWR9kBUVHLjvjdGjr8LDTQf5zn/gxzi4dOnq+Bv2HXOVi
+Yrgng4HUpxdi5CfxEzwrYalwxFZGzpJdH+Bcu1+rvR0SHSdnyMif+vpdL9Z
ng6niI7ZP9D7JC4oiDjg00FYWK7laDQRdKjrRlOG0kGp6kryc1QeRl6JgM7Z
dMjyLPSjjiNC+9XcC1tb6eAoe7+sE9WHdYXM2d8HM8Dj9NTpJFRftOe62fZY
M0Dz9jxEJxPhNtvab+pLGSCgE0fcRvW9HOKzTHszAxwdT/Pez0LtQ8U6yaif
ASnBB2E2B9XH2pUWFscMyBdvpNMsIsIz655yjoAMUJWrPSZWQoRjU6ZZJ2Iz
4G2dY8XZciJod/sG8NdkwKNbNjImtUT4nNOrLr2dAXrvrQfz24jgeOKBvMyh
TDDckzI5heKN7d2GhBxbJuSV8FxNR/nBwIudWelSJhRVDj6qR/H61ei/MR3H
TPi5LpvP+p0Is0e3Hr7YzoSqOCWP1X9E8A8IvOd0KAueH80x4NpPAoE9zluv
2bLA827lx2oKEjxakhf1vZQFiv91xw1QkYDuv4GTgTezIC4m94PWQRIUjlgc
DdbPgicLjOYfDpHQ+uDNRpRjFiTXTX8OoSNB6FXu2diALJA0l66foieBeEXx
58TYLGg6d+IMPyMJnqcN1mXWZEEJ3n8vEPXX42wPC3Pbs6DY27sp5ygJKkJ2
kgq/ZME9Pra06mMk+OVywrNiOwvoDE90FjKh+ehayfOaQ9nALtWQGY7ym7T1
dfMGtmyYkL/c9pAF5a/JIR2cAPKVZAYxND446lop4y9lQ1TUBbM5ZPbu3Uvt
N7OBJ8W+OIyNBHXXg4W69LMho3t0RYidBIZ1J7n6rLLB/+g4dxXyH/EyhkHH
bMj0KVeQ5CBBUo7i3ueAbNh1ufY4BVnuxGfSWGw2jPJPFf5Fnoyy/jaZmw0M
kxf41NB45UH3Z+B7TTYEaRz4FYx8yiuEMNeeDdmxGyo45JZtnurFL9nQHGeq
PYP835PyXOJ8NmgHst/eRT4weyN+fTsbTKiEn1BwkQClh647tDmQERVO/I2O
m0Rx/ivmzAGird/oD+Q3j6nFGUVyYGF36x35/tUKq2Y2cjnwa992yFvkGfbx
yA6NHLjDeveyKvKR1TaCgFkOXMPxHd5F73+1vXTL73kO1DhYhyUiP0pJFPzh
nQObayH/L3/MS3/D6+9yoOwkZUk9qh+82vPgtOwciPnY/PAyMonPGNurzgGW
5Ok/Bah+uf8orxp/zIETyTzUTMiqA5KnG0ZzgNf0Kfdz1B4v87l1OJZyYO2x
12Qbar8+/fWaYcZc+O8xbloXte9fsa8LUjy5oJhKZRGJ2l/o4EeuSIlcaCk0
Zvt4nATelckeGtq58OSMTTIvihfpY6o32+Ny4RPN4f2pKN6SOlM/1/Llwbms
zz1qKH470oNo2KTz4OWMfcBDajT/cXp55aVyHhwbpv3hjeJdU+B2iuSjPLjS
xWrdhvLH6z3pT2EuecCqG++wjPpH/vApSuLbPMCX9y+wIR/w3bIsKEbXf5xJ
d9uH2sfoWyxNcx5su/29aI/yjcn57o6H/XnwI1Z4fOMvEaqn00X5fuXBeUff
SO7fRJipCTb1os6HNX33CgLKR0fCHCOmWPNhkm853WWbCI/k1DcTZfLhtIqF
y7FNIsQwXxb4fSsfdjyOH9nYIAJ+6bTBPeN88HmV+GFmnQikVsa31Xb5kC6U
/2UGzQ+5E3YamT3ygV933HZjlQiqz2eI9uH5UG6+kXUc+aVK76n+9HwYWTkU
pUAiQgZP3V3xinyY88SBJxGNZ1uZviGEfIj5LzKrd4UIf3tCq5eG8+HWAaZq
EWShbOefqvP5YNt91TBhmQi6ry0483byIWjrox0bsre2ptpBugLgP/wGn4ny
a8m5K+4WXAUg2/PhjDzyOAV/aatIAXAs52ktLKL8Onrk+ykoAL6gJIoMZOnS
30wemgVQ09M6Y42s+n1/UJVpATxhITFdQzZhPrR/+WkBbJ4oPcSH/FyZ8dVp
zwIQ/dRocwzZz4lp+V54ASwOj87TIccXcPwXllYA2+OSPEeQ30/wjLSVFgAb
d0npCeSWw2c1/jYXwIVV3UsXkT9fEyGc7y8Ac4m0W/eQl+zPX3n0rQBcT4y6
+yDvy75cmrpWAC4JzpY1yExf4OxnikI46+QbsoEsQKuUxHC8EB7EfPe5hMor
K3v7uOLpQlBKwwa9kTXttAKdzxfChuD0wWFkx36TF3N3C4GBRV4mGNXf2wMW
i9zmhXCaRlFlFTlV+rGZtkMhlP1pNzRA9f8x/pVac1Qh8CmdLryM2guV7kzC
UCHMJoQy86D2rV9vHlLXK4IhnADHuV+oPc+03/J9WARrr2qy8pFn9Hqa618V
wYhud5oAii/6htEigdgimGP2qj2xRQSelanT93OL4Gj0CeVoZCmeubh3NUWw
mfJMkA7Fp5HPui/FSBEk6HykWEJ+WrXz+9LPIrDf3gzTQ/HsM7/37MlOEYgl
KKVjyEW36U3G2d/Dr+LeUp9dVN9uxwaPCb2HS4Qt22nk4RI2VRWZ9/C4ikNQ
BvWPf0xnpKsM3sOJ3Ydqk8jHlM8VLj16D3KKFAnn/hCB30mC97TLe6ga0C2x
R5YpuBh7L+g93FQ4H1SNrD5xlTEs4T3k4r6KbCE/OKzo01bwHlZL/iVLov74
8prq7p/69zCh5fjTGjklS3fWevw9XPPxVu1CrvhsZJS69B7Kns+92UJup/mv
f/jPe/Aq3906gfLp+BXrmwwMxeCg11isgEyyfdJ0nbsYLNm8Bx4gH0h9IeUs
Ugznr+P93ZHZ+l3yS64WQ9ng0nossvABL545tWLYtyaoUIwsLx0QzW1SDE9m
L6S0IHMTrDQo7IqhuXhpqR95967KobnXxfD6l1nLFPLnb4LNncHFUO1aorGE
XPGM1rkkqRj0InzbfiGH71uUfFdUDGZBy/f+ItuFdi46NRaD3OeTcpRofLp1
ojDTpLsYxD6q5h5EFih6a3x9ohi+y93voUWmkrVlEVguhrmb47P0yN861Hrp
/xbD1E68ACPylDAr3pG6BBg94zvIVnfw53nMWAKR5V2Uh5Eb6rdcjVlKgEng
Oy3Z5yitRjROlMAiNTcL2fGqXy4o8JdAQwmzIdmHIm5GSImWQKlRFOMR5Jcj
NSv80iWQ0G1kfhT5B4/gLXa5EsBd3R96HFnbKi6HTqkEcpMrMRbklmKaA//U
SoBVlY+fE1l8y8mUpFMCwaBI4kFOkVto+GZcAv2HJFQFkBn9DNiHLEogwuSA
iQSya3fHiw+2JRCeWXpXFnmB6Up/7YsS4NH+rqmCfM+oQLTwdQlcsB511Edu
z+AMSvYtAeyHxpI1svRi0FxYMDr+Wv/ja+RMyT/Xvd+VAJej6rko5OPONqkv
kkqg62uWUBGyV/P4n4dZJUC1/W+8HZl0SO2eQVEJ7PEvas+R84dmY+XtyhIw
Yt/WPIDyS3eMyDFoLIGbezJWLMiyk0l2EoQSUDCe2BBEzudn7DzdXQK/Pszs
yCGz2bmdZRkqgY3ZWkcdZP/KFe9DEyVw9xb/M1tkc8Ve2eWlErjl2UlIQ+4P
grjJjRJwYnRmb0K+NlD869OfEuCtLx4aQz7xIOx9FX0pSKVTWnCi+eMX9zs8
HsKlcKRXMDoPWelDs+tzqVLwVbcg9SJXMkqOmMuWQrBsidIWckTSsQiV26Ug
W5sefRPlz9v1A5THbUqBQSLh1joyblNnLqugFDoamo5qHSCBg93afzcqSqEl
zO+cB7LgbMjUTEMpqNoqPy1Cjhj6MHK6pxQY+ZxHD6D8raRmrts6XAqvThGL
RZF/4/cNPJgsBQNizhE9ZPOKy11ppFJwGTL8nI7MJjx889pOKbxV8icRkLsz
nhOm9pfBy79xv2eRvTgPK3jQlsEbe+lBKjRfkI4saDp5vAzybtHq8SIv0N68
gnGWAVvKspkscrLXTLUJXxlUOO0fvIustesh9U+4DOZsu4OtkA8+5y5NulAG
KYJGz5yRG37WilyVKwPvTd0HgchPzXTzx5XKgO4Ij9I7ZL6RNX5XjTIIqF+k
TEb+ohmawalfBr8Zv/hkIL9tP8dTb1oGotqUFVnI1+TbEw2syyBwK9Utkzy/
qTZn331WBtfW6AdTkPPF9kfHOZcBZ9pEVgyySU7SscveZeCzuz4XhHz8pEzo
l6AyOMn6JswVuT16mM4xqgz2U8jHWiO7MtoHsCaVQUQb/64WsrjfYarqLFS+
8o/ll5B//C3w1H1fBoPdFwgcyPEvbv77VYXqz3JPfAfVp/ryjPM7rAxqxm78
Ia8vKCw8t6Tay+A/h0rRAuTqcW6Hwb4yqDb273dDttGuI9mPlIFSm/uGOjJP
l67t8W9lsMi2kMGJPHh9/WfZQhlE3otcm0HxEFAfaqm1XgYJOS0b+cir+e33
ww+UQ0jZ9lMR5Gxei3FxhnLoV408uYDmdwbx++/1MZfDMAtuIQO5JVBG6/DZ
cth2nNI/jBxlVagYrFIOh73noj+i+L05dbNZWKscst4/5rJH/qv342qXQTk8
09/8xYFsqXziIp1NOZx2czezRP3lEn+YYGBIOex3aDr8HeWPse/2jL4D6Plq
AcmMKF8eoDlRFDaG7ldN4rJC+VVYtP1W4vdycP4xbYlH+djVkSuwfL0caFQc
qvxQvs5MajuL/S6HuevRFsto/tfV8rStg7ICJg9PSeojczEQKL8drwCTOFvr
K2g+qCj5JH2ZswKs6P3tKtB80EaP/drO6Qq4eIvtoyRyQ5qt2xGpCnhwbSRR
Hs0XZtpYublkK+DsmEdyH5oP0i81159VrACug0D9ENlImmVHTrsCOsTub+eg
+YaPIS5G1agC9jP1rmkhF3o8ktY1rwCHDpHzVMiDWUxDZjYVIGXXOd+E5it/
OprsbR0qgKH0Bngg85Gsjjm5VsCpXRsTFeTbzMdLfXwqYCn93CMOZAeZRo2w
txWg8OCJ1zqa/yTdf7iSEFUBYatMrYPIbT5Hg3MSKyB/e+h6E/JKXv258swK
SFe9zFaCzNJr0dFUWAGPXH018pHlNg5bd1RUQNFE5UYhsiV73cHhhgo4OfKM
sQY5RM48expfAbYt1CmdyFX/Md5Y7qoAeSbzzDnkrwE137cHK6Cbh4ONHr0f
9fsHXgcmKiDogiHxErLoAP2pIz9Q/Urscdgh625XYZzLFVAQGOhfgOzGbWZy
9lcF6DVJcK8iZyvQ/ZX8WwFtEiuYHKqvnoeVCXJUlbDP3FMjCvlkGc2IDnMl
hBtFpOii+r/5ufyVGXcl3LUWpGtFfvrHmMX2TCWs39qolUbth1Mqu+tzoRJY
uTvoz6P2nX9stBZ6tRII1h5X65GPhFOHJ9yoBMGGPx0qKD5Mxwx6ynQqYUZm
leiI4idgH5Vtk3EleJgb7rCheCs5U0zXYVEJW/ja603I+55Sqky/qITXldX3
WVG8ph0obD0cXQkr/62/2UXzu28if2tshivhr0VtCgeKf03vgVdnJtH1il/T
ApCbvuRJf52rBMMJgXubyPHeuhUaO5VwWVhthZwvtEaKiyW5qqDvstWeA+p/
OFE/u0W+KqhcptsaQRb1MRLJFKmC774TLbKoP9OK0RQwQxVUzHHt7iI7+kxa
9yhXQXDg+K4OGh9mRyoF/DWrQPf0+90i5BafB9nbZlUQ+tblgjZ5/Bq9ZFH6
qApsZh8zpZPHb7HDfI/sq2BuK1hmCZne98c3XtcqoNpVd5dE60fn0fq0MZ8q
aDB42eCAPC8WYRoVXAXvNq70lCHr+lqdVIuugkfFRpFLyPhRua9UKVWg4Say
fOoQCSTFmZOacqpAurgQ00JO9V00fFVSBWVe4atuyIxjzRzitVXQS2Fgk43s
Kh47Mt9cBU5H9bg+Ii/42sWmdVSBUG4VaRZZf0xRz2AAPe/627E95DZxTpbj
41Xw6uXnT8dpSCDltzrYOVMFgpkBnbzIGWMfIn2Wq8B9zLtVGPmYRLLW1c0q
2PqcVi2B7OHncHTzXxWsnCnOJXtlTLXv/cFq2LG1jiefbyRxKvThkWo4vOAc
Sb5fh9+WGg97NZyncUgiP+/SeDf9yKlq8FduxZPfJ1siszNcqBrNswvY5pCZ
/J3fqJ6vhiu0FwvI5fEa11ShlK2GwB7h8BxkksTZQw2K1XCk59+0B7KJ/982
B7VqyKuqq9ZB7hof8BXRrQa87ZYoP7KMZL7irEk1XNRptlxD9Z3r70GZ8rAa
sth9PeqQfSRFPI84VUPhC6pFOeQ1f0r5j57VcHYkP/A3al/TiZF/nm+q4Sfj
fFYFsmyAn+t6QjVwa704xI28MTH5aripGpZVswo6UXw9OF8lHfqhGjQcyk2e
IfcFvP2l3FcNvhS67MzIhecv29dOV8NzjRoPPRSv5oERdokHaiBYhSTTQ54f
vX2p0UxfA2UPb8w9Je+/hRqIzzLVAK9Ir9lx5MUo3jWxMzXQ92PVWR/1j+ep
ZS9ab9RArTSdSx/KH9oZ0brzajWQqIuv5kKWzna+yKBbAw2TtqaP0fpmp0Bh
R9eyBsbYV68fReslj+p+1wW/GnhSZkgdgPLNg7oq48OhNXA9+LYpCfVfxcZ4
OamYGojVehNojHyw9cE+t5waYDvlqKqM8s88QWk6vbgG5CaHDfCo/3e0C7V8
qK6BOvu8c8rIIT1r3kfbayCn8dG4CRo/nn4aNpfuqwGMVMixgcaXO4N1Nwy/
1EDQ3rehUGTJz8n8HlM1kNCgIyWJzDTqdTBrvgb4ZjP1x9D4tDluOf+RVAN6
U3VmQchfJlU/rmzXwL/AlkcKyHXfRPOP768FZ5GTQfuQE34cC7pEUwvZoZbD
BDT+uc5vPjY+WgvaXMZGEcgmi6O3vdhrwUVsQ8ASWX6lSSTnFLreUVXxGjLv
ajpjl2At0Dm8LzuNfGDDj0iSqIXyrXQHBuQfm4/6mGVqwfPjD79/aLxt21Ev
lVGoBVVZx2+byLl/JCPuq9ZCSnueK9lv9ljsfbRqQT6OT/kvsg3F77t5BrXw
Zt8fMTp0P3WqSameB7WQ1dlwirw+FzvUyrz+qBYOPnSnlEU+QpezyWpfCyIf
fteYIK8xBH2WdamFv9QpvAHIg0ee1Jh518JaYTp3DXLV8btxfkG1MOB3xmcF
OZblonNBZC3g6JREzqH6cWbnNOxLqAUmSbllW2Qjrr0rvzJqoSnH410V8tWT
37k4Cmsh5t7njQOoPU7wfvgrV1ELitLen/WR950p+PpfQy2EsBkfLEPGC9mn
FnXVgsR0yyN71N7ZInqe/YO18HFc9OwYOX+IX3mwNV4LRimfFMjxcUuaku/a
ci3oEorfnUPx1H8tMmeQoQ5UcBW3uVE8stnP5PUx14Gc53v2ZGSTzAuFXdx1
EFi8j+EUyicL1F9K8CJ1QLq+piO8SwTKLq66CrU6yDk8v6aJ4l31r21DiU4d
iL0JcxxDDhPFmgqN68ArhJXSEvUPrnCz1kzbOjD23+NyRutfKd3srqjgOnAb
98i7hfqXs/9WT9i7OpjYUHkRjIyrufnpbVIdOCk+Uu5BVuNcHPIpqgP864jg
26h/Rt2W/eJRWQd8xIudgcijr4NHXRvrQCfZP51Anv9NiU06dNdBQMRy/SW0
nik86jn9dKgObF969z5BXlPo/24zUQd3qoZOZiG7ZTnMmy/XgVDK0hlaNF7g
hwkLpr/qoN9WvuoyMu0h1mWjv3VAlHK99BA55lHtqjZDPZBS5Yfqkb8m0G5o
MtfDqWLZwW/IfN2Gm7e562GQ+nDIQTQePfpXuH3zTD3UfxXcFkQuEfu3qyhS
D0GWajSqyJumGn/lL9RD03pA7UNk2YjUPdmr9dBmf4XCG9mrdXX/5Rv1cPXM
8a8JyO0bCgcuqNVDURy9ShkyI38UtYQOuh/FM/k2ZG29H4dEjOshs3Og5TNy
fIA0naBFPVj6He6bRZ6u9Wc4Y1sPnIIK1uvIAotfDp96UQ9rWe1hf5HtuISO
cb+uh6GJy6pUKF9XqLkwsfui+62bxtMi77p1sTAH18P9Axf9GZDlS7jZj76r
B02VcVZGZL9pO06GpHr4mBemTY/cdQzHTZNVDynNBUqHkI8pHuWhKqqH9gdR
2/uR9V884N1fWQ+9MdUvdtDzk7PL+f421EOdiHvHCvLM5wNnd/D1MNWpfOAb
8jkaXcFfXfXgkqorMYD8XCbn3OpgPezk9pi2INc83hZZHq+H5cSs9GLkf4kq
4j9n6sHWO/Yguf4Ue+IlfyzVQ+LOyTQf5Dd7i1LTG/VgI2nuaUPOJ+JXL078
qQeaavF68vrXKHLyyhB9A2i7vAzkQJ7fMDJxY26AJgW27B3U3g66ox5nTzRA
3FSE5Gfkt+xDBCexBph2lTgUgtyQ0qFxQqsBRB4wV5P3r7kLK/97GNMA+50u
c4WgeM1nOO93JLUBBM3eWZohSz8pya3NbYDt112TUsjqkgXLdHUNUBz9ED+O
+oNbTeqrkvEGKH9x8ZckMi3Hifh7PxrgvzOa92iRo10SGihWGiDB+K0SYY8I
7+Wi9+vsNYBimIOlMPJXfFDQzqlGuJ7KepoF9cdH/DTv04UaIe+ezvow6q+b
/n59t843Am6UwTMemfGWJ3OyYiP8piHyCiHHF/67qKzWCOFn5fU3yft/jK4G
JJ1GOBFjGExAhk8vUxQeNoJ7W8RJW+QuyY3mxSeNMJh2KegGsn7Us5kox0bY
3mw/fgp55tcKtZxnIyhOT9btoXz5VM9GcC6wEZLYZt2nkf/U/LwVFtEIevJc
pm3IARwP7S4nNEJRao7ue2Qm15mwbxmNwHU11SgOOXXCrDyosBHyL/FY+yML
w+SQVGUjxDlqP3NErkk12p5obASTFyFWNsiKFKMc/m3ofAE9+f+Q+/7Tuyre
2wj/qL3njZCNCIP3Rz43wq01JY17yPP8Wl5eU41gdlzdTB/ZIaA389xP9Hy/
PhoD5H0Ltz8MrjbCa0K+pAny21sdP1/vNsJ4ywu8OTJbkTL9Wcom8IxKybZF
zmQkiPbRNUFptg9Gfj/xpwp3nJiawN4gcMMXueETZs/L3QQBf88LvUO+ef5q
dOeZJuCgVlbMRh6MqqtxEG2CntdjZ2qRzTYvjnFfbELzPJfSbmRTqtaT56EJ
ug/dUfxGNpO6+U3lJhihTGTdJlvSfPm5XhNoWtzkOovaw9QubO/DqyZo8ROY
CSX7NafihHsT6I/ktRSQ/TY7YM0fXR8+zNmOfD+/4Sh3bBPETulO7kfxYTI7
f/p5DXJ+hMgrsn/ZW/njmoDF/KdZFNkH9goT25uAzvuyWSmyMS+z9IcvTbDE
1/9iAdnI5NpNrh1UPt4oDj0Un0a2XW8l9mPg+uAY4SnZrnqflGgwcGY83hCI
bBhva/CMHYMYl50HtcgGedvJfqcw6BSU2Oslu8b7e4IgBlvH3+F+kD0cZ9N2
GQMFa90Y8n6pwQ++0rFrGIB4RtopsjeKf5FUMCjj2a07TzblFRlqLQyMMn2m
FMn7j8fa3DgNMKCzdz2ig6x/6k6r+AMMWrUFVM3JFh8/qPQIA3/OL8HPyVZf
C3vqjEGaUcRl8vcP+savh3y9MDg+L5MTQ7bNIY6ENxh8VWYRSifbJdKkJAKD
EdFbHwqQ9d6cyCDEY/B8fdqnAlk3Lm9uNB2D9qJ66wayc6WESfkY5GEBr1vJ
rsaeUpWj+uhpav9IdptqJUc9BqKXQrR7yR4a2hFrxeAKzWehQbJnTOVudGJw
zpNb9wvZ64teBgMYVAm5TY8h61C8+vBkDAPxyLQvX8n7vUcp6H2/Y6jdi5Wn
yeYJ1oxfxODjoMKV72SLsb0rXsdAt84AN0O2XMYI/jcGLmPqMz+Q8/lZDy/v
x4HbFq5iFlnovVHpFhUOotVCgbzfmn8h/S4FLQ4Y8G0RZAs1zv2iZ8TBqb2o
hv8fVxSJZT2Gg+DnMp3/P971XIaXBQfNr/50/f/43ZpxYQ4cGNiz9pEtOPbX
7eIJHMwfL/1GdpfzvdJYXhwoHYhhm0e246j8vsOPg8F3JV5kH607wmJ4Dgev
DC9I/kSuuGdzs0EMByHSqxcXyO2x88GZWwoHH19LZC4i78aeLnK7hAOr92V+
y8hJl9wnJ2Vx4FcdskJElv8yevTaNRz8Wjm3sIb8/ZW0YvoNHEQ0CPtvIvux
RrykVMWBNp1p/y55/796OddcHQcNQWWf95A7dVXGCFqoPI+OfKJA47vdZibD
WT0czEoPcVMjH4neJx9giION2fRhGuTyC0bPf97HAUfhoz0GZN2h6kxVcxyQ
ikMSjiHvOBz/XGCFg/GkiSJW5ESmJzQMtjhYqg65xI0MFR1X7J7hwMhZ7upp
5G93+e16X+CApm+xgby/7bvumSrujN5/9Fe1OLJA5ER/uBsOjDU4RC8h2/ZH
XdT2x4HYa1f/m+T3e06yrgzCQe6hQw/vIJcdvZ3IEoYDBXfVOgPkbU3K/SOx
OLhxLLXIDtmn91mHcT6yB+e1BOSzT7r/NL1H7/P6pWwOcgejoBhPOQ4mCE/c
y8n3V5+K/FaPg16blvou5IQudeOH3Thw6t05sh/lTzmb/ND2T+j5fnyajMhT
dNQtgsM4mJTcfkPeP+e/1ci/9BUH+coiHy4gl308R3pKwkH92wVWK2Qda3/e
/g0cnOHL3CDvN24f+q59fgcH11IUn7ojX70ZX/trfzPQOuxnfke+/9yvRV3q
Ztjfi+NPQfbyv3OihrYZ5Baac3OR29sOeTsfbwbdrba+WuTHluaVY6zNkPHo
iFkzMiM1bk6Wqxlyq2Sk25FLszg5knmaYVBSVom8ftW+8er2Hl8zsMIz/wHk
rZl+N1PBZpgMziJ9Ro73ES1tFmmGm2e4ncaQZfnefOeVbIaGw0lsX5EnW38w
+0g3g3il/YdJ5IrdrS99Ms0gbGHzegr5jQRtIjc0w5e79+XIvm/Fdf/R9WYw
5y87QD5fKkWUt1q5GdIVLTrHkWmG5X9Q3m4GrQj2kBHkr/R3czU1m+FbDbPK
EHL5dYvHSdrN8N9f1R3y/lKA8yvRBf1m8Ey+l0jezzUuDVyVNm6Gpqoo8RZk
yfmECm+zZihLoaok18/Bk+9f9Vk0w3a/nWAJ8rgOTob7UTM8UlIPySLXz9v+
v9Z2zaB0bXImDtmvdQZX9RyVP5dTLBhZXIJGWdOlGWTvX8knr/eprDhpk9yb
AZfS+82UvH5IFun+6d0M/BtPTmgi+9Br3fV+2wxMSsZV55DvXTdn6Qtrhp1b
wMOGLOr8coTrXTPYfr2TS0n+/WUu/n5VUjMYBixf+ILir+hEES9lejMUOEer
NyN76WA/NLKbwWcuqyAPWbj1++Of75uhU1jI1BHZM1nYkQvXDANaRMbD/++v
cles8c3w0AyvSB6vhOnv/Ktsb4aLPgcJxcjDTi98ND41w8jbY7eAPP7pNIV5
fWuGlSX3aUOU3/aC+u72zjZD/528a6eRB1u+sXAtNgPjevxvcn51Ez+YVLne
DMkuXyhckfvpNPPmD7SAraYmdS7K5zkKD2wu0LRAUl/P6AtkVycHMS+GFujo
Mz5Knr/xz8VWcrK0wLmtilPzaP7wm7vA0YqjBRgaNC81kOdP2o1XKk+0QI29
s1AEsnPLdLP62RZYjF47qoissbPuk3CuBe4+pbzKg8wnTn1zXqwFdM7vL/6H
1pc7lmx0F6RawGPxr/skck+SUI/npRbw5e1qa0HOGJQN75FtASbNldhcZEc6
DW3Oay2QfdyfNhxZXcGM1epGC/Aqqoq6Ip92sh+tUGkB6Uk75kfIZX5v31er
tcDHOVXMEFk+Ksur7k4LfFMc/qmB3JvWpNuo0wJfQjVTlJBNij8L4e61gGpk
1TwgLzeQ/rUYt0B4ZX33FWTXDpoBglkLqLHitWWQ6b7w5rRbtEDpo0kv8vH4
H1dcOq1b4KQf3pB8veC6tkaPbQvkVXZP30Cu2Wd3+tOzFtjq/sVMfr4yo//W
wIsWUKcY3jIg/x7Pmdo57NQC/9wzfa2RLQRrU0Zeo/rsPd/gjLwh3W8/7onO
31uLDkH2VlxUnvRtgU+hK4ezkI9pHeD6FojOF+0/2YScdp+bNBPcAlxSi40j
yOK20vi58BZwmjk3tYWMOWvELrxD7ecs5sKG2kc9wMpmOa4FFFflvK4gT7zz
lCcltcC+t7pzpsg2GfFM62ktoH9SOCEAObCpq2E7D70PQ3nBV/J8t+tH2O+i
Fgh5XvadHsVP9sg/83+lLaBszn3qKjJ+Q5zhQF0L5LzU1c1A3nfunfHhjha0
jqhn9UHxGXrpvcSxnhbAerNJGPIJpQ9UzP0tMI9t0fxFljXbKeIYbQE3OuMg
8v7Cqxjjf2cWWkAmndXPHfWPFUr+FFnaVrhLbbTRgfrX66NgD4ytUMNwvWoR
mf6kvrLCsVY4+I37BD3qz0Iyb4jKHK0gxlqbegu5VjmjVfUEun7FKfER+fcn
nYYYNd5W+D0G+8j7D5ZPV+CuUCvIiOXjW5F/vT7IpCvaCodjPQ+Rx0+fIJ55
fclWYNEdcP6NnJ6tFWYig87ntK0UQ+tBiYrH5mZyreD4lsGc/HssrtnnkrlC
K3iWzzKYIk+MV01Zq7aC4s0bZ94ih1DMKraqt8KbfRb86cjyAsx5XHdb4W0v
U3MVeX9DTZHhpV4r3Jd69vMjcqa9/bNeQ3T9nF3UGLJuXPqQgGkrXM+Zrl5E
PoR9uuxl3godzl6qu8h1M/uSx6xa4fL9X9cPovWrDa04xQXbVkj/ryfxGPIJ
8fuWIc9agXQuWp0LuU8npGPuRSucG+m+y4fs5dIoes25FWa013KEkKXSliLi
3Vrh1V83ZTHk2TbOrXWvVvhYShSTRI5dUjVU828FoSst988jqx5zxrKDWqGX
6dUw+fjvi3mn94W1gl1YeJQ4cqHxF/97Ua0gqh+TIIxs4n1wqSy2FW6qH17h
Rz6SJ61Jn9QKEZ3uoSfJvyf2WFRYpLXCITkbHxbyen0jig3LagUpQa1+OmR+
DrwrW34rlL7Jct9D5f8C61PP3rfChayuyFXkNxa8NzrLWuH8BU7Wb8iyQXfy
+KpbwfpY97FPyCslHgxu9a1ArbAvvAlZ68/XIXE8ul4y+9o78vdpvIwyb9pb
gWKf91s35Crlq8nfu1pBsDbrjSUye2SCZfRQK5jszI5IInfUdHQQR1qBtllL
hRXZ9euOqMrXVhj/EZS7S55fCOpv/Z5thdOlmFMTci6OKcBsuxXK3ecNZJEv
rgTnCXPiQdTWcfYUiu/5440Mfifx4P+n5+gf8vcel5eeTZ7Gg5TLfBJ5PfHP
R1UmQhgPl87qnjuL3MZ5sHPrKh5e/KgxIu8POF6TFrujgIenQaEnhlB/E3po
EZmvhAeVL3Z675BDyloNjTXw8Lg+qYoDWUfFY6nFFA9Vl0szZVF/xt2oMus3
x4PPyOhXBmRhhaXhaSs8BNOqiZPX97FyvLdXbfDQWBVcWIV84Ip+875neEi5
s2oRQt4PuBgifeQFHpicImytkMfO4wtOOuHBS1V1gJxPyoTFo+U88YDNrK4e
QD4haEmn7ouHao+j+Hk0nr05k+hhHIgHtYtJ/L3Im6f6f9kE48HhVDdvDbLZ
iUOPXcPxsKXkhMtA7uKQmwp6h4dSYVbqCORLrA46CXGovGdrtr12yf83yu/I
T8JD0/NDiS+RjxyZgro0PLAzaqzZkPMBPUvlxyw8iBna/bFAnj90W2gkDw/f
3H/UmiFrU3mlzBfhYTugX8CUPN7ur2HaLsVDouqvG+TjQv+WAw9W4SHnbxk9
+fro3dN7LHV4ePuO49VjZIqtew78TXi41vXztQOy3XrozwsteDg7FcHmgTxK
JJjcaMPD/n3Xr5LzgdLS7wHtDjxomf6cSibnv3kJFfMeVP5fclulyNw/HjbZ
9+OBsbvn+QfkgOmk897DqP737ymS8+/GxEBuxCgeaBQ4THbI9TMMkaXf8HAi
nMQjher70sCLQ82zqL4UmbO1yfsZvQWv+xbwUEh5WPAVsks7qxVxDQ+BitJD
zcizeLWJf5voeoGS/p/IWs3eWoy/8dAwX/ryOIoPoTqirAglAX4ObmuRf0+J
rjpTJnuQAAtt9AZxyBTlhmdv0xHgYfCDLPL+w0jBh6OPjxOgVn85lbw/FZCU
Mpt7mgD6pDj5HeSNuCHDmrMEyFPz9hJF8WwaTffpwzkCfNAOkDBHvhj6qn72
PAH86YhWfcizHhphfIoEkBKbuZaH+sN1873LqeYEWOG/PZaO+tPU1iIkWBGg
eCJNro68Hxf05Ua0DQGoOQ8zf0KuKyu989aBANWdGr/+IOsrJev5OxKgrkd4
+Sjqn5sjb4y9XAlw4KSsFD95vrvf3NrRhwD2bilh5P3tvijNJ/YBBDi1Yhlj
gmwncPWF3VsCdO1X63uCTN8g6GIdRgCJzfMXPMj7hxosnuZRBNCodcSFkvPT
dwr/+7EE0MI2bJKRZ18S3xokEqA5dO9CITJvcnusZiYBeCySGMj75TiJyuRb
uQRI+XqfuQ/ZhJCWqVSI3l/4qPAo8h/9kPxrJQSQTX2r8Z28vlhyLpGtIIAL
hZjbIvIlj4dVF2sIQCU8XLWGPHxcu0GygQAKOlPb28gOOfItIjgC6PKeU/yH
fPSKSLsAngBTj47FUaDx7X0Pe8/pdgIwYnbbVOTvkR5QD57oIoBHQeR/h5AX
fq2NsPcR4GSj2jgNckDg5CTTIAHGlabMaZH5ubt+HP5CgN8LFPvIxpfULNKO
E+Djz68l5OsfKGatUk0RoO8ivQs18r4v4Vv7Zgjw2jjkASVy8mO3v7/nCJDF
++nxHnm9tPeIcmsRtf+hrATyeDsaoUezRiTAnYgrWxvIjvyKh5fXUfktTvus
ILPUiTPPbxHA9bLizTnyekqNm/P7bwK8yxxVIa+XtKZpTn3dQ/HSbB86jExy
2OQfoWwD54r5k93IIYe+Cw8ebAMzRgMK8vxBOLFXspeuDUgs5+RqkK1ac+UI
x9ug9kfeVCoytd47RRxrGzhSyetFIWcueKrWc7aBvucfJX/y+u6ooW7p6Tao
s84rf4zsmqVsVHi2DU5u9l0zRua4LPUg51wbeH3weqyOrGvKYJd0vg0GRfZX
iiH3vMd8A6+3wZs6MU4i+XuBW3yVZv+1gXXOux0rZPct/lvlD9tAViB0TxdZ
PkNw+oBNG8S6zEjeQG7ZFWXIdWiDNaE1ZV5kQt5lixXfNrjik62KI+936Mj+
hjdtoBaQcToNWWk/hIeHtAHwW3z1In/Pp6/YKBXTBj9ZekXI3/sFHlC+65fQ
Bjyl4aMiyKolKj8/p7SBFbdiHPn7w66DGswuuW0wYZ39/Bvqv8Hldwq6CpHl
WZI7kdXva187UdoGBbxrfyqRD9PpfX5S2Qa42Svv0pD7qu7ZNte2wQoDhU0I
+XvN/1Vs7/FQbmscwNm1RdLFZaeMEBMpl5xEsfcj0YkTpdJV2AgVOYNKQrkl
SWirBrmFDLlt2pQjJ6VZ602i3EpISG10UShdtJ/15/cz877vmrWeeT/z/tYz
bk7TFGrFEL/TNToEvWW2S4rHHTEMzQwfOIiWr/7doFIshvKujDgndMs+j3sz
GsTwV+KMEHt08jyvPbuaxNBhqFa5Fr3t1v7Rwhb8vEPuq1ehlfb7xHzrEINF
tP/05eh2RT9V+y4x+AfIKrHntUu3BRWZvWLI8lP2Vpli+WCgzeiAGCQLyicV
0QuUjz63/FsMTQFL781Bd949djj5jRiGg2TuyaLT/EJkB0fF8G6v1kdplpeq
nMg2mRDDjh7hhhmsn5WEm8R+EUOB/bNbUuge/6jGzikxrIiotWWvZy6KcV8+
jcB22dBBdrzr/djJ0BkEYh/eiWHnVz9yNqFJlsD03kotdv0XGgl8jbkEinJ+
rlBAX2lM+p+/IgEZ7WHtBWi3Y8kO9coEoop+DVJDa/IvvVJSJXDCJUi4BD3Q
nBLqpUGA6IhD2P05L+Sywk0+AefUWQtM0J46mQUzdQkcGZpwtUC/PpHbVmxE
4LZJRN02dMGy/IM/VhFY/eDGbRe2n9FRIOlgRqDBstWUrdeIfqne2DoCP8b9
XCPR77pvRq9xJGAt/LK0Cj1h1mRMjhLQlfiwbDHWk6D2SdfD4wSWDiQa6qNH
LPoi20/g+I02Sq5Bv7Aef/QyhoDOx+GRzWgnOhX0Jo6AQ96tr3vY87mttPp4
AoFJ47O1nqw+N6kcmi4k8J5e23gc/e/HWkqzLhPoe+E8J5r1y27Tr1HIImCv
3R54Dl21a+1MTRGB8LA2lSy0UZftn7pFOL5jnjtF6CLnbTuNygiklTfqlaGv
uHtdXXuDYL1YZNSiVQf/a2dTQ+Bj4w8Ttv8j9A4e23ybwL0/vng1oOWHI9N2
1hM4eyhf/xE63jfe0pUSyD8+fLad9f++v/i31wMCPs/mR7H8N8I/K9GvmYDi
+KBSL/r7WIHJ0VYCTb7HrFi+G3S0oifsCYH0ti3yLD/9MFkTfaqLwDq57REs
H/UNES8/10sg1avu0lv066mmlgsDBARndLePot3Cnwanv8b1nBdc9xHdPa1f
I2+EwPXPg93jLA8/NUKL3hNIfjBa+gn9WHrC7/oYAd9iF/NJtF3cj19qPmP9
qBmfZvkplZOpvfuNgNb1MuFXtGWi/L4GCQr809YB7PfvLXnerJbpFER5F1S/
o00v8Cs6pSmMrfNJZy6fb7C7bxaF3HdVn5n1Uk0lh+ZSuJQeZTyFFvEsRaOK
FHYUj+9iXpz5n02TyhSuPQcf5nQNxwkJVQrO1jn+zMq5zunSGhQCl+0LYD6/
xNtqLp9CqfT9QGa5AsHw/KUUNgvmhDKfXnb8vJoeBQclz/PMP5VErdZeQSGk
cbiaOdTwXK++MQWVmrxvzJ/LL8WsWk1hbnTwXpYXBxhn6//2K4Xu7OX9zG+r
Ctus11L4eKDQRgLvx95rrofYWVMwdS+5ydxfc0vT0YbCoW5zK0m0M5D7TnYU
nOpbhpmf1DULPBwoCDselbP8eatVp7KPI4XeLYFp09APxf3/D9hFIb+sNZ/1
R9vYvPE8vpfC4djBpz+j6xsm5CJ/p9CQdPhfM9C/2Uv8dWYfhcYqzUpp9M1m
Gafz+ynYunm5s/3LlVsVpqX6UlB+HGs+C13SxivMFuB85udZzkbndhp8LjtG
oVVi3VOWZx9w80s1DKPQfFJYrYQ2HCoxL4ugoC2r2qGMnhC87TGIoWCtMKrP
Q9dM6oWXxlGoTeqvU2P5XLivpkEiBUkPQQLLuzfIFN8rSaYQ8a3+oja6VXn5
zJJ0CoUxDXYs707NOlikd4XCsxemX1aiXXWu2RdfpbB3X9/T1egRE90/ikqx
3ibe6lihp+/Q4V2rw/X4FFHK8u77PV61umIKakdE2a7oRM9818L7FCCv6Brr
V+UdWZJX0EJh2IyM+bP5uKClL3pJoWLK+WEc+gvPo1l7iELfd4exJNYvkZvj
n/8W62O2t7QQvfH64qqrnyj8Wp/Tn4OWN3fbteQbBXXeeAbLH5/czf6aJ8GB
XVKDYSnrP29Rt8iT4aDSkX/7Jlp3j2uf1mwORCriP1n/+fu+zKhceQ6Kv69w
u4uuPPB8idZ8Dl45ZjYQdMiHRVyOCgc7bJ1fN6Atg50Paqpz8Hp9T3kTWvqn
DLkcLQ6CvCv4LaxeYrtLFy/lgN+aZtaOTp6nuuWKHgd7JqLesfx0d4rTmIYR
BwO5ieas311d4/LF7FUcXFZbuKgbPSh6ZqphxoHPcHVCD7rIUOVZFnCwOHJT
/HPWr3Vjd6i6FQdynV/le1n/r0WqWtYGDuKKDFSZp8jTOjU7DsxSC0Xs/fWb
FnhkOnCQIXWynJ3vTMdOKbXtHKyvWWjKrrfZRSjK2M2B+SYLEzaeX1512C5y
4WDITLGEjbfr0Pw36e4ctNUuTGtDX5nYnqDqzYGRu9l39jzgHXZxRboPB5bW
d1sa0fpS7S08AQdJUl6LOPRYvNKRy4c5GBRYdbP5rVZyVOYFc8Br7J/L5v9k
enJ1WhgH+ztMq6vQ6/mtTiqRHDzwz+ksY/lVscKP1BgOCj69C2Dr+3jl1uyF
ZzloXbHjNPs/gbDm/LrURDxeKmxhCvt+Wz1+ueACB/F3AvUS0fwH806npHAw
Kl9Zfwr9D+jbT6Q=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  ImageSize->{720., Automatic},
  PlotRange->{{-0.2, 0.2}, {-0.08609623753752191, 1.0861007357922468`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.77304398814995*^9, 3.7733796145326586`*^9, 3.7733828371215267`*^9, {
   3.7733832368722286`*^9, 3.7733832561070623`*^9}, {3.7733832933131275`*^9, 
   3.773383322126378*^9}, 3.7733846371930885`*^9, 3.7733852373261423`*^9, 
   3.773391342439618*^9, 3.794373264755951*^9, 3.7944597512902317`*^9, 
   3.7944610784391303`*^9, {3.794461275368394*^9, 3.7944613017049007`*^9}, {
   3.7944614259720087`*^9, 3.794461532769117*^9}, {3.7944616434854493`*^9, 
   3.794461658865329*^9}, 3.795335086509699*^9, 3.7954384138354483`*^9, 
   3.802072555159139*^9, 
   3.802272969706441*^9},ExpressionUUID->"099eaa73-917c-4a52-b5ec-\
8541984ee728"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeltaFunc", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"HeaviApprox", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.794374190725914*^9, 
  3.7943742136142225`*^9}},ExpressionUUID->"0c36d5ca-86e9-43d0-a95e-\
73fbdb25cb2f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
     SuperscriptBox["x", "2"]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
     SuperscriptBox["x", "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2.393653682408596`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}],
      "x"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}],
      "x"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"239.36536824085962`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{"300.`", " ", "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"957.4614729634385`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"300.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
    "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1276.6152972845844`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"400.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
      "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7943742288210926`*^9, 3.7944615401055365`*^9, 
  3.794461663618601*^9, 3.7953350889178367`*^9, 3.795438416230585*^9, 
  3.802072555275216*^9},ExpressionUUID->"5ec0f102-63a5-4833-8506-\
6ab62477fff3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DeltaFunction", "[", "z_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"300.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
         "]"}]}], 
       SuperscriptBox["x", "2"]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"400.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
         "]"}]}], 
       SuperscriptBox["x", "2"]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2.393653682408596`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"300.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
         "]"}]}], "x"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"400.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
         "]"}]}], "x"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"239.36536824085962`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Sinc", "[", 
        RowBox[{"300.`", " ", "x"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"957.4614729634385`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Sinc", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"300.`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
        "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1276.6152972845844`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"Sinc", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"400.`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
        "]"}]}]}], ")"}]}], "/.", 
   RowBox[{"x", "->", "z"}]}]}]], "Input",
 CellChangeTimes->{{3.794374310329755*^9, 3.794374379867732*^9}, {
  3.7944615526432533`*^9, 3.7944615926005387`*^9}, {3.7944616716750617`*^9, 
  3.794461679423505*^9}},ExpressionUUID->"70495ab6-7ad6-4407-a56a-\
aa84da3a8d02"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "]"}]}], 
     SuperscriptBox["z", "2"]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "]"}]}], 
     SuperscriptBox["z", "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2.393653682408596`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "]"}]}],
      "z"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "]"}]}],
      "z"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"239.36536824085962`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{"300.`", " ", "z"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"957.4614729634385`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"300.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "]"}]}], 
    "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1276.6152972845844`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"400.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], 
      "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.794374381524827*^9, 3.79446159419063*^9, 
  3.7944616806235733`*^9, 3.795335089935895*^9, 3.7954384184447117`*^9, 
  3.802072556991355*^9},ExpressionUUID->"7257701e-9dd7-40c7-ab50-\
536d4aa421ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"x0", "=", "0"}], "\[IndentingNewLine]", 
 RowBox[{"\[Sigma]", "=", "0.00001"}]}], "Input",
 CellChangeTimes->{
  3.7944597600027294`*^9, {3.7944598102986064`*^9, 3.7944598254944754`*^9}, {
   3.794461851528349*^9, 3.794461852062379*^9}, {3.794462200944334*^9, 
   3.794462251486225*^9}},ExpressionUUID->"5bbe0624-c4cb-4ceb-bc23-\
1a408ff17512"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.794459787794319*^9, 3.794459826483532*^9}, 
   3.794461598685887*^9, 3.79446185348046*^9, {3.7944622022324076`*^9, 
   3.7944622525962887`*^9}, 3.7953350918140025`*^9, 3.795438420446826*^9, 
   3.802072559386945*^9},ExpressionUUID->"5bf78168-f4ac-4002-a7e9-\
adbb2cb8cf4b"],

Cell[BoxData["0.00001`"], "Output",
 CellChangeTimes->{{3.794459787794319*^9, 3.794459826483532*^9}, 
   3.794461598685887*^9, 3.79446185348046*^9, {3.7944622022324076`*^9, 
   3.7944622525962887`*^9}, 3.7953350918140025`*^9, 3.795438420446826*^9, 
   3.802072559388946*^9},ExpressionUUID->"9822f272-32e2-4043-bd5b-\
69990f369841"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeltaApprox", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "*", "\[Pi]"}], "]"}], "*", "\[Sigma]"}], ")"}]}], "*", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "x0"}], ")"}], "^", "2"}], 
      RowBox[{"2", "*", 
       RowBox[{"\[Sigma]", "^", "2"}]}]]}], "]"}]}]}]], "Input",ExpressionUUID\
->"535398e4-a755-4b06-84a0-6dc3a9b3bad8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"DeltaApprox", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.4"}], ",", "0.4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.794459799850009*^9, 
  3.794459804622282*^9}},ExpressionUUID->"33ba32e1-3da5-4afb-ac3a-\
83b5f133234e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "unfl"}], "MessageName"], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.7944622545514*^9, 3.795335093991127*^9, {3.8020725613502474`*^9, 
   3.8020725654950023`*^9}},ExpressionUUID->"6fb09fdf-f3b9-4fdb-8657-\
5dcb8503b1a8"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJxF1I0vFHAcBvCbrC3zMkleT+kQzZUld0kWo0mUt06RiXNeM6dZmeK6aycv
ReHOznEnOmXJkRWNy3VOSCb36uWYupKYzGTnmky16ft7tmfPPv/A40imRiYb
YDCYc3/7b51HzItraibFmO3EshYyWWzk8jhJxIMKZN1Stl1hCfKAyZgwOw85
JaxcFRSD3Cw3wumskd0nd/RGcibAuTPU5VTGODjE02VGn68GV4gI/KYCFdjW
VxIjTFOCD5tVK46mKMDMia9BFufl4FBVWbmZjwzMxzGqik6MgZPl085dZ0bB
jZjQhmj/EbCUTZXgA4fB6TZFapHdEBjn55kWYD0AJpMUy4wFKfiu7KCtvl8C
vvXZkfmhVAxe+615s9erB8yOF6+Eu3WB/XmlJhsDHeCrUQXzrqvPwQI98Yn3
ogCsbWNeu5DBAR83LdBpw+hg7LMKkuzA7VP/bfA9lca1qAFnuSQlkmsF4EF+
X5tVbCt4yLfZa329A2z47TT3p74TTHixsYce3gP2IxRXY+PF4Lc60nxTiwSs
+ZJjWqiQgrX4zdeZ6ndgSkllVp3hEFjuX/VUaTIMjqua9VEZj4ATdUQNljgK
dtNs0ogOY+BZ6ZwlkyAD4/Jypl4Gy8Ez052f0s8qwKRg+lJfghIcQNnyfkRR
gXtDnF4lJqnBOp+PXoO542DB1BF9e94EOINM5XrQkD0WhSfb7yCLfuEZbfeQ
ldbuRkIesuFFV/sWCTJFsd+vadck+NDlBK2TKfKKtp4p2I2cv+rw/rEdMssc
G9mIR+4Ps6HURyCXjl/auS8aOfwKp5kfizydZfWDl4S8VmZ5o+46crclydr+
JjKdx+qupSEbt1pscYuQ5ceiGmzvI3NElQHch8jxgfI5Gzby9n+B/wDACkZG

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.794459805776348*^9, 3.794459828460645*^9}, 
   3.794461855434572*^9, {3.7944622070366826`*^9, 3.794462254589402*^9}, 
   3.7953350940211287`*^9, {3.8020725613992834`*^9, 
   3.802072565502001*^9}},ExpressionUUID->"3243f186-a9e0-4951-b29d-\
604a34f2d332"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeltaFunc", "=", 
  RowBox[{"DeltaFunction", "[", "x", "]"}]}]], "Input",
 CellChangeTimes->{{3.7943744080743456`*^9, 
  3.7943744173838778`*^9}},ExpressionUUID->"56c6aa1c-9d55-4be6-99e4-\
ed966e3485a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
     SuperscriptBox["x", "2"]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
     SuperscriptBox["x", "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2.393653682408596`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}],
      "x"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}],
      "x"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"239.36536824085962`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{"300.`", " ", "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"957.4614729634385`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"300.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "]"}]}], 
    "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1276.6152972845844`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"400.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], 
      "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.794374418317931*^9, 3.794461610764578*^9, 
  3.794461688730037*^9, 3.7953350984513817`*^9, 3.7954384264031515`*^9, 
  3.8020725634576464`*^9},ExpressionUUID->"94edde71-35bc-43d7-a67e-\
bf60e0af281e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"DeltaFunc", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.794374242886897*^9},ExpressionUUID->"25ab854f-9843-49a5-84b2-\
042e29eddc0e"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c81e8Xlz1DZBUlI6MoSpQ8KIWUEcqIjKIkKyMNW0IoUoTsvbeLe65x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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.794374244988017*^9, 3.7943744210840893`*^9, 
  3.79446161237667*^9, 3.7944616909611645`*^9, 3.79533509964645*^9, 
  3.7954384277191944`*^9, 
  3.8020725676704416`*^9},ExpressionUUID->"d9a07e8e-af2b-4e7e-92fb-\
e21d582757fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Heavi2", "=", 
  RowBox[{"HeaviApprox", "[", 
   RowBox[{"1", "-", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.77304541085124*^9, 3.7730454173822494`*^9}, {
  3.7741113694057393`*^9, 3.7741113762311296`*^9}, {3.7741114184225426`*^9, 
  3.7741114483182526`*^9}},ExpressionUUID->"295a5d3a-ef78-4cc8-a11b-\
c7c98c7ef46c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"300.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}], 
     RowBox[{"1", "-", "x"}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.007978845608028654`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"400.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}], 
     RowBox[{"1", "-", "x"}]], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"300.`", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"300.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"400.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.773045418753251*^9, 3.773379620273469*^9, 3.774111376787162*^9, {
   3.7741114195196056`*^9, 3.7741114489002857`*^9}, 3.7943732685661693`*^9, 
   3.7953351016265635`*^9, 3.7954384294832954`*^9, 3.8020725693555593`*^9, 
   3.8022729851947184`*^9},ExpressionUUID->"f6d43f7b-eb31-43b2-80e1-\
32aac613c7d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Heavi2", ",", 
     RowBox[{"HeaviApprox", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.774111386343708*^9, 3.7741113864577146`*^9}, {
  3.774111432868369*^9, 3.7741114367895937`*^9}, {3.7741114771529016`*^9, 
  3.77411151453404*^9}},ExpressionUUID->"a0df5071-9d8b-44c6-9199-\
e11bcb523b88"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwknHk8lF8XwFUislQKiZIkSUWyhFCoKEqRJVGoUFQIqWwtlKiEnyRLtlBS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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c81e8Xb0ipjJKoVDQkX5WdpAchLbLKjJIyKoSQZFVGUkZGVvbeI/s5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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7741113935411196`*^9, {3.774111426974032*^9, 3.774111456778737*^9}, {
   3.774111501872316*^9, 3.774111526037698*^9}, 3.774111592667509*^9, 
   3.7943732740834846`*^9, 3.795335107824918*^9, 3.7954384357656546`*^9, 
   3.802072574859211*^9, 
   3.8022729903191185`*^9},ExpressionUUID->"3248a7a9-3b4e-4c3b-9756-\
a7f94e5d7da1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"L1", "=", "0.4"}], "\[IndentingNewLine]", 
 RowBox[{"L2", "=", "0.2"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", "9.8"}], "\[IndentingNewLine]", 
 RowBox[{"y0", "=", 
  RowBox[{"\[Pi]", "/", "40"}]}], "\[IndentingNewLine]", 
 RowBox[{"y1", "=", 
  RowBox[{"\[Pi]", "/", "20"}]}]}], "Input",
 CellChangeTimes->{{3.7670292211348114`*^9, 3.7670292249880314`*^9}, {
   3.7670292647323046`*^9, 3.7670293213325424`*^9}, 3.767029353043356*^9, {
   3.7670294132287984`*^9, 3.7670295256472282`*^9}, {3.767029600400504*^9, 
   3.7670296181225176`*^9}, 3.7671181484933496`*^9, {3.7671182081007586`*^9, 
   3.7671182413646617`*^9}, 3.7687538867245865`*^9, {3.773032009581832*^9, 
   3.773032011393935*^9}, 3.77338631179663*^9, {3.77338655113225*^9, 
   3.7733865592442646`*^9}},ExpressionUUID->"5d138dec-e361-47d7-bba4-\
444e63d129b6"],

Cell[BoxData["0.4`"], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.774112220608425*^9, 
  3.7943732764406195`*^9, 3.7944598490598235`*^9, 3.794461705472995*^9, 
  3.795335111076104*^9, 3.7954384391488485`*^9, 3.8020725748992376`*^9, 
  3.802272993166007*^9},ExpressionUUID->"e46f1afe-cd6b-4e79-bf92-\
0ca91799690b"],

Cell[BoxData["0.2`"], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.774112220608425*^9, 
  3.7943732764406195`*^9, 3.7944598490598235`*^9, 3.794461705472995*^9, 
  3.795335111076104*^9, 3.7954384391488485`*^9, 3.8020725748992376`*^9, 
  3.8022729931680093`*^9},ExpressionUUID->"284b3d16-461c-4555-9b38-\
ba041bcc9152"],

Cell[BoxData["9.8`"], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.774112220608425*^9, 
  3.7943732764406195`*^9, 3.7944598490598235`*^9, 3.794461705472995*^9, 
  3.795335111076104*^9, 3.7954384391488485`*^9, 3.8020725748992376`*^9, 
  3.80227299316901*^9},ExpressionUUID->"ae553a50-b6d3-474b-aebe-7ae266f0d3c0"],

Cell[BoxData[
 FractionBox["\[Pi]", "40"]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.774112220608425*^9, 
  3.7943732764406195`*^9, 3.7944598490598235`*^9, 3.794461705472995*^9, 
  3.795335111076104*^9, 3.7954384391488485`*^9, 3.8020725748992376`*^9, 
  3.802272993171011*^9},ExpressionUUID->"0d72e5fa-ef24-40cb-b73f-\
f004c3042429"],

Cell[BoxData[
 FractionBox["\[Pi]", "20"]], "Output",
 CellChangeTimes->{3.7670295834805365`*^9, 3.767030219509987*^9, 
  3.767030956594146*^9, 3.7670327687277937`*^9, 3.7671181535656395`*^9, 
  3.7671182456819086`*^9, 3.768670227350072*^9, 3.7687538906858134`*^9, 
  3.7730322339723353`*^9, 3.773045433614272*^9, 3.7733796220830717`*^9, 
  3.7733833575072403`*^9, 3.7733846421850967`*^9, 3.7733852528481693`*^9, 
  3.773386312966632*^9, 3.7733865844071083`*^9, 3.774112220608425*^9, 
  3.7943732764406195`*^9, 3.7944598490598235`*^9, 3.794461705472995*^9, 
  3.795335111076104*^9, 3.7954384391488485`*^9, 3.8020725748992376`*^9, 
  3.802272993173012*^9},ExpressionUUID->"d2bbfb16-3b83-4d3e-9953-\
cae28f5e8223"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeavisideTheta", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
             "L1"}]}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "*", 
         RowBox[{"DeltaApprox", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
         RowBox[{"L1", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeavisideTheta", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
             "L1"}]}], ")"}]}]}], "+", 
        RowBox[{"g", "*", 
         RowBox[{"DeltaApprox", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
         RowBox[{"L1", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"L2", "+", 
             RowBox[{
              RowBox[{"HeavisideTheta", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
              "L1"}]}], ")"}], "^", "2"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.794374447016573*^9, 3.7943744653016186`*^9}, {
   3.7943746437558255`*^9, 3.7943747241324224`*^9}, {3.794374772206173*^9, 
   3.794374784010848*^9}, {3.79437504508078*^9, 3.794375069364169*^9}, {
   3.7944598838838153`*^9, 3.794459891522252*^9}, {3.794460119259269*^9, 
   3.7944601362452407`*^9}, {3.7944601667339845`*^9, 3.7944602000438895`*^9}, 
   3.7944602780753527`*^9, 3.794460436180396*^9, {3.7944605328929276`*^9, 
   3.7944605567612925`*^9}, {3.794460803520406*^9, 3.7944608816608753`*^9}, {
   3.794461045829265*^9, 3.7944610557998357`*^9}, {3.7944618683943133`*^9, 
   3.7944618723675404`*^9}, {3.7944621522785506`*^9, 
   3.7944621702565784`*^9}},ExpressionUUID->"fa1c44a8-7535-4371-9aff-\
bde2a429a7fd"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndnum"}], "MessageName"], ":", 
  " ", "\<\"Encountered non-numerical value for a derivative at \[NoBreak]\\!\
\\(x\\)\[NoBreak] == \[NoBreak]\\!\\(0.`\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/ndnum\\\", \
ButtonNote -> \\\"NDSolve::ndnum\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.802273193101201*^9},ExpressionUUID->"7a1f44b8-dcd9-46c5-8e81-\
82ea95c74154"],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"3.9200000000000004`", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}], " ", 
         RowBox[{"DeltaApprox", "[", 
          RowBox[{
           FractionBox["\[Pi]", "40"], "-", 
           RowBox[{"y", "[", "x", "]"}]}], "]"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"0.2`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.4`", " ", 
            RowBox[{"HeavisideTheta", "[", 
             RowBox[{
              FractionBox["\[Pi]", "40"], "-", 
              RowBox[{"y", "[", "x", "]"}]}], "]"}]}]}], ")"}], "2"]], "+", 
       FractionBox[
        RowBox[{"9.8`", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}], 
        RowBox[{"0.2`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.4`", " ", 
          RowBox[{"HeavisideTheta", "[", 
           RowBox[{
            FractionBox["\[Pi]", "40"], "-", 
            RowBox[{"y", "[", "x", "]"}]}], "]"}]}]}]], "-", 
       FractionBox[
        RowBox[{"0.4`", " ", 
         RowBox[{"DeltaApprox", "[", 
          RowBox[{
           FractionBox["\[Pi]", "40"], "-", 
           RowBox[{"y", "[", "x", "]"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "2"]}], 
        RowBox[{"0.2`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.4`", " ", 
          RowBox[{"HeavisideTheta", "[", 
           RowBox[{
            FractionBox["\[Pi]", "40"], "-", 
            RowBox[{"y", "[", "x", "]"}]}], "]"}]}]}]], "+", 
       RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "1.`"}]}], 
    "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.7943751248813443`*^9, 3.7944599330286264`*^9, 3.794460138349361*^9, 
   3.7944602021200085`*^9, 3.794460333537525*^9, 3.794460474752602*^9, 
   3.7944605958695297`*^9, {3.7944608083256807`*^9, 3.794460825738677*^9}, {
   3.7944608679230895`*^9, 3.794460883032954*^9}, 3.794461795406139*^9, 
   3.7944619101647024`*^9, {3.7944621653162966`*^9, 3.794462171942675*^9}, {
   3.7944622146611185`*^9, 3.794462260412736*^9}, 3.7953351153693495`*^9, 
   3.795438444526156*^9, 3.802072582782467*^9, 
   3.802273193106202*^9},ExpressionUUID->"d0218d22-bbbf-49de-8299-\
7754b1e1a433"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL40", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeaviApprox", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
             "L1"}]}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.773032253285169*^9, {3.773046340199565*^9, 3.773046390337636*^9}, 
   3.773046440636707*^9, {3.773046477021758*^9, 3.7730464781717596`*^9}, {
   3.7730465715458913`*^9, 3.773046572565892*^9}, {3.7733833636224513`*^9, 
   3.7733834014369173`*^9}, {3.773384645367502*^9, 3.7733846494703097`*^9}, {
   3.7733868826328325`*^9, 3.7733868889508433`*^9}, {3.794373514909259*^9, 
   3.794373533264309*^9}, 
   3.7943744412622433`*^9},ExpressionUUID->"67f106fe-0157-4d0c-9b8a-\
b340587f8f49"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.77303229928965*^9, 3.7730463014725103`*^9, {3.773046422562681*^9, 
   3.7730464441777115`*^9}, 3.7730464803117623`*^9, 3.7730465753458967`*^9, 
   3.773379629727085*^9, 3.7733834391733837`*^9, 3.773384688626378*^9, 
   3.773385300896254*^9, 3.773386361357917*^9, 3.773386632205592*^9, 
   3.7733870314570937`*^9, 3.7741122731714315`*^9, 3.7943751814205785`*^9, 
   3.7944600814831085`*^9, 3.7953351313932657`*^9, 3.7954384601470385`*^9, 
   3.802072600760396*^9, 
   3.8022732076368446`*^9},ExpressionUUID->"fd4b3d09-764f-4a66-9fa3-\
19a7e39d1464"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSol2", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "*", 
         RowBox[{"DiracDelta", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
         RowBox[{"L1", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeavisideTheta", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
             "L1"}]}], ")"}]}]}], "+", 
        RowBox[{"g", "*", 
         RowBox[{"DiracDelta", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
         RowBox[{"L1", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"L2", "+", 
             RowBox[{
              RowBox[{"HeavisideTheta", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
              "L1"}]}], ")"}], "^", "2"}]}]}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeavisideTheta", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
             "L1"}]}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.79437559232108*^9, 3.794375621894772*^9}, {
   3.794375657593814*^9, 3.7943756674263763`*^9}, 
   3.8020726501775455`*^9},ExpressionUUID->"c8ab0ae4-b42e-4624-bc42-\
8213918e17ab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.794375669792512*^9, 3.7944602480146337`*^9, 
  3.7953351345194445`*^9, 3.7954384603320494`*^9, 3.8020726538135605`*^9, 
  3.802273207844981*^9},ExpressionUUID->"97f6cbb6-2314-461a-a778-\
4d7bcf25d296"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiffSol", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "FullSol2"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.795335155343636*^9, 3.7953351794100122`*^9}, {
  3.7953353539629965`*^9, 
  3.7953353543680196`*^9}},ExpressionUUID->"f976f979-ff6c-4751-9578-\
66011e5a429c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7953351804100695`*^9, 3.795335356562145*^9, 
  3.795438460390053*^9, 3.802072656168124*^9, 
  3.802273207906023*^9},ExpressionUUID->"be25024e-e939-4cd1-bc59-\
bd6586518dbc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiffSol2", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DiffSol", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7954385326711864`*^9, 
  3.795438542026722*^9}},ExpressionUUID->"dd1664c4-0adb-4b75-8112-\
cafc7166bd30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7954385468449974`*^9, 3.8020726581304264`*^9, 
  3.802273207968065*^9},ExpressionUUID->"d9c5083b-8b72-46c2-a4b6-\
64bfde0be342"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"DiffSol", ",", 
     RowBox[{"8", "*", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/.", "FullSol2"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.319", ",", "1.622"}], "}"}], ",", "Automatic"}], "}"}]}], 
   ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<time,s\>\"", ",", "\"\<Angular speed, 8 x Angle\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7953352033143797`*^9, 3.795335296543712*^9}, {
  3.7953354104212255`*^9, 3.79533547011864*^9}, {3.7953357820384808`*^9, 
  3.795335877551944*^9}, {3.802272817499441*^9, 3.8022728522364902`*^9}, {
  3.8022728953230863`*^9, 3.802272949759205*^9}, {3.802273323481753*^9, 
  3.802273335065439*^9}},ExpressionUUID->"d9a78473-55ea-40e3-b62f-\
5a7cd823d54f"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVmHk8VN8bx8mSJKGSJREqJHxVCuVJJLIvLYhspUVFVKIURZElhbKnpOz7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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwVmHk8VO8Xx7NUQpZISKWSkFCJKE6hsmbJVrZC8lVUQtFCtqgsSVJZKqWS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox["\"Angular speed, 8 x Angle\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{1.319, 1.622}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{767., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.795335422195899*^9, 3.7953354711907015`*^9}, 
   3.795335787355785*^9, {3.795335853953594*^9, 3.7953358782759852`*^9}, 
   3.795438555204476*^9, {3.8020726606661067`*^9, 3.802072674164049*^9}, 
   3.8022732080531206`*^9, 
   3.8022733360701075`*^9},ExpressionUUID->"c3214fa8-2e98-4aad-bb1c-\
561b9244a76f"]
}, Open  ]],

Cell[BoxData["Exclude"], "Input",
 CellChangeTimes->{{3.802273481361906*^9, 
  3.80227349021578*^9}},ExpressionUUID->"aae9a143-7ae2-4bca-b81a-\
c89d11c74fa2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"DiffSol2", ",", 
     RowBox[{"8", "*", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/.", "FullSol2"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Pi]", "/", "40"}], "-", "0.001"}], ",", 
      RowBox[{
       RowBox[{"\[Pi]", "/", "40"}], "+", "0.001"}]}], "]"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.319", ",", "1.62"}], "}"}], ",", "Automatic"}], "}"}]}], 
   ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<time,s\>\"", ",", "\"\<Angular acceleration, 8 x Angle\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7954385756216335`*^9, {3.802273578618416*^9, 3.8022736110989685`*^9}, {
   3.8022736520721555`*^9, 3.8022737057657843`*^9}, {3.8022737393770866`*^9, 
   3.802273752088521*^9}},ExpressionUUID->"18ae3dd3-94a6-4aa9-98e0-\
edfec82d9bd7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[Large], 
     LineBox[{{4.081632653061224*^-8, -0.000025930620501197913`}, {
      0.0006134358411192535, -0.009753505499663698}, {
      0.0012268308659119764`, -0.020038121871353665`}, {
      0.0024536209154974223`, -0.0400750989182751}, {
      0.004907201014668314, -0.08013553789505466}, {
      0.009814361213010098, -0.16026613254855873`}, {
      0.019628681609693666`, -0.3202665618561819}, {
      0.0392573224030608, -0.6383280622921945}, {
      0.07690206123770402, -1.2347014559079323`}}], LineBox[CompressedData["
1:eJwVl3k8lN8Xx8m+jn2fKSRLC6JI5Tyi0oYkFaIs6SsVhRYSSSJpISk7keyy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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
     LineBox[{{4.081632653061224*^-8, 3.2653061224482624`*^-7}, {
      0.0006134358411192535, 0.004907481596858524}, {0.0012268308659119764`, 
      0.009814606730975298}, {0.0024536209154974223`, 
      0.019628645366534653`}, {0.004907201014668314, 0.039255033904207814`}, {
      0.009814361213010098, 0.07849430307174074}, {0.019628681609693666`, 
      0.1568648097781451}, {0.0392573224030608, 0.3127427617074979}, {
      0.07690206123770402, 0.6053626757584983}}], LineBox[CompressedData["
1:eJwVmHk4VO8bxkWyE5VKWlQqEhVFojuUUopSWbKUL1ok2rRQlFRKi0LKTkqK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      "]]}, {}}, {{}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"time,s\"", TraditionalForm], 
    FormBox["\"Angular acceleration, 8 x Angle\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{{1.319, 1.62}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  ImageSize->{715., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.795438576765699*^9, 3.802072676999928*^9, {3.8022735834586267`*^9, 
   3.802273611968547*^9}, 3.8022737103358164`*^9, 
   3.8022737560171266`*^9},ExpressionUUID->"234ca101-b04d-43ba-96a5-\
80a12aa17311"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL40"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "FullSol"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.794375202663793*^9, 3.7943752324454966`*^9}, {
   3.7943754066624613`*^9, 3.7943754729312515`*^9}, 3.7943756834122906`*^9, 
   3.794460087538455*^9, 3.7944602527379036`*^9, 3.7944605183470955`*^9, 
   3.7944607522064714`*^9, {3.794461822020661*^9, 
   3.7944618225476913`*^9}},ExpressionUUID->"e5930e42-918d-41b7-8e98-\
f315a93b809d"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwll3k41N/bxxElyRKptKu0kLSpFG9JkqWyRCuStCgJSVQqlCWJJAmJkkRS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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwll3c81f/3wI2SZCdZpYFU0iKKj6PM0LJJSEhmmWVkC5GGisxC2euSknqV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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.794375239701912*^9, 3.794375411284726*^9, 3.7943754738203025`*^9, 
   3.7943756853864036`*^9, 3.7944600901066017`*^9, 3.794460144862734*^9, 
   3.7944602544430013`*^9, 3.7944605198871837`*^9, {3.7944607459811153`*^9, 
   3.7944607534365416`*^9}, 3.79446088663616*^9, {3.794461805951742*^9, 
   3.794461823653754*^9}, 3.794462122686858*^9, {3.79446217867206*^9, 
   3.7944621819432473`*^9}, {3.794462216804241*^9, 3.7944622623208447`*^9}, 
   3.802072699522873*^9},ExpressionUUID->"93e7d926-e473-44ea-a392-\
b02f4703f71a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL20", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeaviApprox", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y1"}], "]"}], "*", 
             "L1"}]}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733856821785235`*^9, 3.77338569704535*^9}, {
  3.773386575093892*^9, 3.7733865811311026`*^9}, {3.773386873132416*^9, 
  3.7733868928820505`*^9}},ExpressionUUID->"b4d03d21-a27c-434a-a2a4-\
d04e3a4105b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.773385701148157*^9, 3.773386521133397*^9, 
  3.773386779891052*^9, 3.7733870711591635`*^9, 
  3.774112314654804*^9},ExpressionUUID->"89bdee7d-a482-4af9-b033-\
03402608943f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL2", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", "L2", ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733869761393967`*^9, 3.7733869835182095`*^9}, {
  3.7733874910131626`*^9, 
  3.7733874949287696`*^9}},ExpressionUUID->"457175f9-817a-447e-a551-\
c4f2421661c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.7733870713151636`*^9, 3.773387503134384*^9, 
  3.774112314831815*^9},ExpressionUUID->"1984060b-d07a-472f-8293-\
becffb7f7449"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL2L1", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", "L1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.773387270901914*^9, 3.773387273351118*^9}, {
  3.773387337342431*^9, 
  3.773387343473242*^9}},ExpressionUUID->"86467969-5ed9-4fe0-8330-\
66f8016618e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.773387275675523*^9, 3.773387344736844*^9, 
  3.7741123150098248`*^9},ExpressionUUID->"7170780e-6644-4dcf-84c8-\
8619b2549a37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x0", "=", "0.17016138104753686`", "\[VeryThinSpace]"}]], "Input",
 CellChangeTimes->{{3.7741117605091095`*^9, 
  3.774111762059198*^9}},ExpressionUUID->"6d6b075a-bcfe-4029-b94c-\
1b35159a30ac"],

Cell[BoxData["0.17016138104753686`"], "Output",
 CellChangeTimes->{
  3.7741123151798344`*^9},ExpressionUUID->"7d4f1665-5802-4da0-a0b8-\
93f4ab64b3ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CombinedSol", "=", 
  RowBox[{
   RowBox[{"sL2L1", "*", 
    RowBox[{"HeaviApprox", "[", 
     RowBox[{"x0", "-", "x"}], "]"}]}], "+", 
   RowBox[{"sL2", "*", 
    RowBox[{"HeaviApprox", "[", 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.774108146191382*^9, 3.7741081589571123`*^9}, {
  3.774111631644738*^9, 3.774111662753518*^9}, {3.7741117659504204`*^9, 
  3.7741118017944703`*^9}, {3.774111913662869*^9, 
  3.774111916283019*^9}},ExpressionUUID->"23b7da7a-ff5b-4583-bce0-\
241310896959"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
       RowBox[{
        TagBox[
         RowBox[{"InterpolatingFunction", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
          "]"}],
         False,
         Editable->False], "[", "x", "]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
             RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}], 
            ")"}]}], "]"}]}], 
        RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
             RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}], 
            ")"}]}], "]"}]}], 
        RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"SinIntegral", "[", 
         RowBox[{"1200.`", " ", 
          RowBox[{"(", 
           RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}], 
           ")"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"SinIntegral", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}], 
           ")"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"SinIntegral", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "-", "x"}], 
           ")"}]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.3989438184180913`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
       RowBox[{
        TagBox[
         RowBox[{"InterpolatingFunction", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
          "]"}],
         False,
         Editable->False], "[", "x", "]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1.2533141373155`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
             RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "0.17016138104753686`"}], "+", "x"}], ")"}]}], 
          "]"}]}], 
        RowBox[{
         RowBox[{"-", "0.17016138104753686`"}], "+", "x"}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"0.0019947114020071634`", "\[VeryThinSpace]", "+", 
           RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
             RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "0.17016138104753686`"}], "+", "x"}], ")"}]}], 
          "]"}]}], 
        RowBox[{
         RowBox[{"-", "0.17016138104753686`"}], "+", "x"}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.7978845608028654`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"SinIntegral", "[", 
         RowBox[{"1200.`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "0.17016138104753686`"}], "+", "x"}], ")"}]}], 
         "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.1915382432114616`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"SinIntegral", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1200.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "0.17016138104753686`"}], "+", "x"}], ")"}]}], 
         "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3.191538243211461`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        RowBox[{"SinIntegral", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1600.`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "0.17016138104753686`"}], "+", "x"}], ")"}]}], 
         "]"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.774112315365845*^9},ExpressionUUID->"85a3ea7d-6064-485a-8e4c-\
77d59014fea7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL40"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL20"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL2"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL2L1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.773046487081772*^9, 3.7730464959527845`*^9}, 
   3.773046526278827*^9, {3.7730466031389356`*^9, 3.7730466154609528`*^9}, {
   3.7730467250651073`*^9, 3.7730467265251093`*^9}, 3.773047027642534*^9, {
   3.7730470992726345`*^9, 3.7730471000326357`*^9}, {3.773047211679793*^9, 
   3.7730472248228116`*^9}, {3.7730472566178565`*^9, 3.773047501403201*^9}, {
   3.7730475649732904`*^9, 3.773047584995319*^9}, {3.773047956725842*^9, 
   3.7730480315559473`*^9}, {3.7730481135370626`*^9, 3.773048136680095*^9}, 
   3.7730481702651424`*^9, {3.77304843814252*^9, 3.773048447673533*^9}, {
   3.773385713706179*^9, 3.773385745795436*^9}, {3.7733870017078414`*^9, 
   3.7733870285866885`*^9}, {3.773387285144739*^9, 3.773387295783958*^9}, {
   3.7733873501344533`*^9, 3.773387350368454*^9}, {3.773387499905178*^9, 
   3.7733875004355793`*^9}, {3.773390166648345*^9, 3.7733901794247675`*^9}, {
   3.77339064737879*^9, 
   3.7733906973074813`*^9}},ExpressionUUID->"e53aa6bd-479c-4689-bae5-\
cb963b870b0c"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwlmnk8VN//x2cwg6K0KImSipRQpIW8T9pRWdJiaaEQCiUiS0miIirKrrJ9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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwlV3k4Vd/3dslFUYR8SkWURNGgQcnaSYVEpVRmokEqRMrYIBnLHCpKpoyZ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     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwlW3k4Vd/3vlxcREmGiEgZPkKSKWFtMpMylAqRKNGAREk0IkpShBJRRJnn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     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwlmHk81N/3x8cytrRQZCkRUhRKJaLzTipL2SuVsrRLlsi+JCpRQlTChyRR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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{849., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.773048172415146*^9, {3.7730484404225225`*^9, 3.773048448953535*^9}, 
   3.773379631536689*^9, 3.7733834581118174`*^9, 3.773384704288806*^9, 
   3.773385329631504*^9, 3.7733857482602396`*^9, 3.7733865245342035`*^9, 
   3.7733868271279345`*^9, 3.773387071564764*^9, 3.773387300994367*^9, 
   3.773387351491656*^9, 3.7733875073151913`*^9, 3.773390182341973*^9, 
   3.7733906982434826`*^9, 
   3.7741123156528616`*^9},ExpressionUUID->"2d79fc0b-73fa-45d9-99e9-\
a9aaee99cb7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CombinedSol", ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL20"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.774112365573717*^9, 
  3.774112371639064*^9}},ExpressionUUID->"618ff81a-d82c-4ad1-9f38-\
635bda2b53cb"],

Cell[BoxData[
 GraphicsBox[{{}, {}, {}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwlV3k4Vd/3dslFUYR8SkWURNGgQcnaSYVEpVRmokEqRMrYIBnLHCpKpoyZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{588., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.774112375371277*^9},ExpressionUUID->"eceadcc4-0282-4970-97f5-\
617c6d7a4b35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CombinedSol", ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL20"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.1701", ",", "0.1702"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.774112413619465*^9, 3.7741124180917206`*^9}, {
  3.7741124551908426`*^9, 
  3.774112463133297*^9}},ExpressionUUID->"674582af-1b49-449d-9c5b-\
897f1751e966"],

Cell[BoxData[
 GraphicsBox[{{}, {}, {}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwVznlM03cYBvAqo1wiV1kpMCstUBAmAYagOH4Uce1WRBgKBcMhSuiycNRx
FDe3AEplUOUGHQYUBqhMxMGk6gChHZdDmXJGYLMOYXjECYESyPZ8/3jz5pM8
ed7XLj7l84TNNBrtAIbsXJncZ0ytpjovuh26zFJRn4iPnySu5THkxPo+/HvE
m9tWlcSFK2vUOCwcus++ApdlJAsm4Nl3YYvE9WmHw6dgrw9lOfWwKpWbNgN/
6999sxGmf9HVMgdnLAQb34DdTeX5qzDrbfTEXfjL0ayPDH5TU/G7E5T98Ly/
soAFf/XsduQobHzs7H4XWBa8aqSBA+pyHvnCgimPJ29g9sUtnQdgSWHkjQ3Y
z1sTEQtfWx8UGFmrqKR/n/ekwF/LfFaYcODxjKJs+DSzqMMB3rHk4VZC+u89
P+8Bh+3Ye/IKvI+R50jB9sxRXhs8V2nyMAh+j3OhQQW/3lSliIQVmpfyMfg/
LT0mERaLFJbz8OCmnldpsOeIOG0Vdp4+VZoN/2Lc5mXYp6bW+NtE52GhZE+/
NSxN77aqhnOzQn51hXnF+1evwjT3n2P84Kh0ZuVtuJDOHwmGP2O9Eqng+yUx
DXFwU3Wd+R+w7seNQVJ49GnMmxmSV+ytyYZrZyUFi/DdsqOHSuFpVehuLaxV
tk7VwTVB/A1dGxX1Z3lxbzucyNj62AI2sOoU98G/a50kdjC/w7JrHBakBVns
hDkmG/IFONVe9MgXNj9twlmD5YlhdUI4sCZZYtivpjS9170Ow2xptJktfC5i
ejKe9B/NLHCFQxOsy1Lgaj07iR/8kO4Wdwr2e7BseRD244QEfE/ueTNTY+HL
Zj2aCrhF3O8qhZ1LDCrrYVFV/Z1s+GZmbFwrXHTO9HopHCXI9+2CmS4Dgh9h
p0CdsQfwT383t7fDK5cUeZPwy/DteX3w45EF4Qt4z1wnbwIWHouwW4IHba6l
z8P6XKaSZquidPQdHNfgno6G+K2wyHyo0XBATeVXfcqxgWWp370l1h7cdYS4
YdjT1whW07llxLSC6mHipBPrurZwu07y8haYHtCyQMxeNt1nAof1MFq3we/G
w2cs4EjBLMWBt+8ycmLA7v8MyYiDy7qkxAmFHa3ETSFOupbw0+FiLheOHtC6
vA+bBQXq2cN9d6qzrOBy3tVhB3jJKrSXmN1drucIczJ1jVnkH3GOP/E3nsm1
xJozR24RuzdTfdbEk8YVPDjGcMnUBhYkrQ0TF0qaooj1aC/0nOA5e7PXxBXc
7ixii1y1ty2c2NZ8i9j/r6xs4tLAC4vEydTOIWLrJ2fsneEfLj1jfACvx5+I
Jv4fjlZBow==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.1701, 0.157032},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->{Automatic, Automatic},
  ImageSize->{503., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7741124212359004`*^9, 
  3.7741124657294455`*^9},ExpressionUUID->"6898dbdc-bcba-458d-96fb-\
2a1d7ed3286d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL20A", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeaviApprox", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y1"}], "]"}], "*", 
             "L1"}]}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1."}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.15", ",", "0.2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733880192423024`*^9, 3.7733880613795843`*^9}, {
  3.7733882174266586`*^9, 3.773388223027068*^9}, {3.773389441958849*^9, 
  3.77338944292605*^9}, {3.77338965369424*^9, 
  3.773389660885853*^9}},ExpressionUUID->"1e99fbca-fa85-43a8-a598-\
bdf43d8c7c73"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.15`", ",", "0.2`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.7733880533681664`*^9, 3.773388163200963*^9, 
  3.773388317906435*^9, 3.7733894461864557`*^9, 
  3.7733896635534573`*^9},ExpressionUUID->"541fe58d-ec22-496e-8f3b-\
5fc50ce5d855"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL20A"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sL2L1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.17", ",", "0.175"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7733876490208445`*^9, 3.7733876496448455`*^9}, {
   3.773387699580533*^9, 3.773387730905388*^9}, {3.7733878807592516`*^9, 
   3.77338798234663*^9}, 3.7733880688051977`*^9, {3.773388229095479*^9, 
   3.7733882317006836`*^9}, {3.773388359714508*^9, 3.773388606662942*^9}, {
   3.77338886627321*^9, 3.7733889552089663`*^9}, {3.773389005503454*^9, 
   3.773389098230017*^9}, 3.7733892025560045`*^9, {3.7733896486398315`*^9, 
   3.7733896696530685`*^9}},ExpressionUUID->"a8a7b70f-c099-4440-b0a2-\
84947db9ea62"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0X801XcYB/DbtqTc9UOh69zC4ZDMjzs3CfVG16mVq6JGDeXX5czklsLK
j8qdJsVoWo2UtMitjtIYFR17vp9I7cqtFNG05cekX1qn9Guf/fGc57z+eT/P
cx6ryMTAmI9EIpGS1//9wuSI0PxmAWNFh5QSM8LRZs2CEm5n882w5s5OrjQ9
ye0+4idz5A7sfdLezB2Yfn+GD/fQ6Qy/l9z75F3dcdxmyhKnsN8FnNg6Evcb
d1Jup8iBBOQNZ2cGzyQ4GAb8wgQBMd6RpUUSguaMv9PiVgGVRupZS6SEO651
BZprAlwCxAeuziZYfW5e8qtOwMHqMKmPFSGoJ6/fQS+gznZNzSNrwo7YRKPY
2wL6RCeUX9sSikoj1AN3BVzR3uuV2hOOBPinBfcI6H2cENvsQDjecyxy758C
Ju0ZfrfAiVAoMcox+FvApVNd0f0uhO3y+zl+AwL8cmU90a6EtS1a2ZZ/BNiE
vQ+6PY9gOXGPZHCE7+P/kzrNnfBgzs1uy2cC9HYFVS88CPv+de4tfcEt748p
W0hw9NTsFr8SYOam+eDtTWhZrzDCGwFVTV7COV+Cv8xUV/tewAHzss4QP0Jb
X1DC6DiG9sWJ0htLCK4oX751PIPFa4es9GWEfJPh9n5DBktjWa1USRi4Wuoy
S8yQ3rhLlreCYOcY3X5wCoOsOPVH10BC5MaiZXeNGWq0Ucu1q/m9c5riJ5oy
hLzrfGgSTNDmj13LkDBIhvc7n19LaLpVZlgvZdjwqmHEJpRwsWWdxt2SwVGt
c24NJ5yRiysqrBk+jXzquSGCUJxpf7zblsH+ieJhaxRhU0pI3+q5DNmSs70q
FcE3YPRVoSNDTmj13ttxBMPS7LrLLgxJx51dF8QT6n52qHWVMyQ4z377RwIh
ItkrP34+w0pTm6r5asLo+/DKQQ+Gx9K9wfrNhJ2qkeK5ixhmnc4a77uV8MmS
LW6hPgznig8L5SmExJviaXoFg5WFV7j7NsIt72ls8lKGzm8b5h5NI9iss7uQ
v5xBt6qt2iOTEPdoXrBoBcNfXVq/lp2EirDq6/MC+XzjQh97DUG33UtTvYZB
3qHRX8wmPE+VmzwNYSh/091vnUOY9MRGaRHK0Pu6aWFGLsHI2E7Yv57/Y+mY
oVEeYcKMIrPrkQxQHc6K/4HwKFWX1s2dumuORTJ3R8/EB0PcV8QVDTu4Sysy
ThlEMXxIyHhWxC33jPPx5l6VdCD8MveGSM/4Gm61+Bs3kwJCQ3Vf46Fonn/k
7L1G7qMmUptKbtUxbXIr93fbvsyp5d5se2jqTe6VirYgPXd2TYBiiHug8/yg
OIbhzDNr7fRCwowPu413cMempyTHcY9FNafkca/Wn5ySxH2/5e29Em6PGl1l
OndV4aaKem7H6S+7Crl9bL/yGuVWRJ1edInbNreobJyKIW9mWucVbvFTncFU
bt/QReoO7jv1ihufcUsLDpcNcDfOznTz5F6X5eHxnLs8q774C25Xg7aOt9zf
D46KQrjl5iviJ+wnbFQ6qVTcQ03sY2Pu/wDtv1j4
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV031UzXccB/A4KLqoTg/ulseum0qRbmThXamFurGea7el1JVFoVRbpOwm
ZO7ZtTze3fRgN8vTjqel0PL9fReiiNIsD43KiLhMK8s+++N7Pud1zufzOZ/3
H9/J8anBiUONjIzk9P6v1WPiFOo6AU3lh+aLbRgO1anmasmnp7q62pG3ZlRY
HyGXRV2UOJOD779sqiPv/f2GqTf56bEcv7/Jeq/6tiSyjVzrEnNZwBCt7YZf
yGmFrUZOTMBiVcCRiHEMTiZBh7kgILL2V+M9YgbV8UCXhVeoP0spXWTLcNft
3HeqBgFi2ZLPGiYwTJ71kfZMowDDgtryhZMZQtp3dTo1C1D9XINeO4bclamm
K1sEjP8txZAiZSjSxa3tahPwuv+fP6c4MBQHBW6MaKf9N5/1XXFiKG8vjd/5
UEDuaIXbQhcGjdh0+4jHlOdl6A+vZjJkyx5s9+sSMGwgyG29G0NUfaVr+l8C
OsRn+p+4M0wauUPc3SPgtrjs8S4Pho5pt+9NeiVA0SAyHuXJ8O3bGfd1bwRY
mgd5n5/P4OypKhD1CQi8e6MixouhPtbXFAMChvvtC2v2YQh0tW48OyiAD30i
yvFjuPYoZI1hCMcsrw9jB/wZ3FAWsGE4h4dPm8WxJQxqq2dNnSYcN5TX/IPl
DF1XdTPHizhKK1PuXFnKYO+c0LRvLM1rE8MyghniU4qWtFlw5DroZG9DKe+0
S8kjrTnaLowNWRnBUKnub8gRc6gkVeFjohku3SkxqbLlmP6vBy9QMNTUR6s8
JnH0TXU0mx3LcFwm0uvtOPI+nVjUGsdwcLND+T0ph3rPLU1AAsO6zMhHoY4c
zUkFMW+UDD5Bhj6NM0fHm5361FUMJrqt52pn0v1Z1XPvJzOcO+B01k3GUSlv
KMxLYYjLmKdOnsPxOoGvereWwTD4RUX3JxyatLb3JWkMecqeg44LOHy70qZM
zGAY5p8+W+FNeV9YFamzGFJvi8ybfTmOSQ6ckGUz3PEy52MWcaTXhK46uolB
Em1frQ6gfC8sayNzGZKeu0cYLeVodS2O7dvCoI85ed09mKPQI77yy3yGxux5
qpNhHMt/LN5qvo3hdZbMqjeSY8bgGcvCHQyjXkrkExUcmSUtfe92Mpha2Au7
YzlWF8+J3a9mMLYssrkez1EukeSP1jA8z2rceI/8fE3mV+PIt9pHdjwl92fz
NXZknT7n6IgVHDGdEeFzyTLPJG8v8qDB3z6RvDzeM/kU+UKvor6GfP7ko4v7
Ezh2L482Xr2b/q+VraSCPGOBdCCDnP91+Paz5MUPe17kkZf5XgtpJvesW9uy
l9zVerpblMhRddXn8GWy5YcCi1yycpmtz8ffM/SvqMvcRW5OL3eXkh/Uv/9D
S94fM83BlfyTZp2+iuy40c7Mn+wt/XyegSzp6WxfT5YWFpUMUXJMkclvbiKL
ehtHmJGTcIJtI9+t8r05nSyUKit15IsTNs/2JLf0V+uOkMu+qTq4mCy1Ga05
Td7WbTCKJJ96F5V/iZwid1Eqydna0qyr5P8A1CRbsw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.17, 0.1569},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  ImageSize->{762., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7733876508616476`*^9, {3.773387705056143*^9, 3.7733877316541896`*^9}, {
   3.773387904627293*^9, 3.7733879834698315`*^9}, {3.7733881633725634`*^9, 
   3.773388188519808*^9}, 3.7733883180000353`*^9, {3.7733883664069204`*^9, 
   3.7733886091901464`*^9}, {3.773388884930843*^9, 3.773388956316568*^9}, {
   3.77338901458267*^9, 3.773389098854018*^9}, 3.7733892038508067`*^9, 
   3.773389449883662*^9, 
   3.77338967065147*^9},ExpressionUUID->"ead036dd-0354-478e-996d-\
e999f62657be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "sL20A"}], "]"}], "==", 
    RowBox[{"\[Pi]", "/", "20"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.17"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.773388705138919*^9, 
  3.7733888473971767`*^9}},ExpressionUUID->"c0bcb690-1011-4a97-99d4-\
86677533966c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"0.17016138104753686`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7733887544522133`*^9, 3.773388848676379*^9}, 
   3.773389673724675*^9},ExpressionUUID->"b9f43d90-094f-466a-8b79-\
4daac8e65180"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "s"}], "]"}], "\[Equal]", "0"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.3"}], "}"}]}], "]"}], ",", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", 
      RowBox[{"s", "\[Equal]", "0"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}]}], "]"}], ",", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", 
      RowBox[{"s", "\[Equal]", "0"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1.7"}], "}"}]}], "]"}]}]], "Input",ExpressionUUID->\
"a624034c-a7d3-47a7-9720-50dd1d4e5caf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sL20A"}]}]], "Input",
 CellChangeTimes->{{3.7730476058673477`*^9, 3.773047617879365*^9}, 
   3.773389239193473*^9},ExpressionUUID->"1fded208-1cf4-40ef-ba2c-\
6112a46be933"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "0.2`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7730476207493687`*^9, 3.7733892406910753`*^9, 
  3.773389457558876*^9, 
  3.7733896782798834`*^9},ExpressionUUID->"debf8942-4b67-47e6-aff5-\
4d1d3c84f827"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol1", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSol", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.773047626360377*^9, 3.7730476323713856`*^9}, {
  3.7730476687554364`*^9, 
  3.773047677876449*^9}},ExpressionUUID->"78568049-9dbe-4bc0-924b-\
54b042725227"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "0.2`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.773047678917451*^9, 3.7733892507218933`*^9, 
  3.773389460366881*^9, 
  3.7733896795122857`*^9},ExpressionUUID->"7aea96f3-6b18-4a10-86f1-\
5c906a10deef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSolL2L1", "=", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", "sL2L1"}]}]], "Input",
 CellChangeTimes->{{3.773389526972002*^9, 
  3.773389573172287*^9}},ExpressionUUID->"24d1d4fb-88c6-42cb-b28d-\
009fd390daba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.773389575293891*^9, 
  3.773389680853888*^9},ExpressionUUID->"717d12dc-d006-45aa-ab69-\
86ce419a1fbc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirSol2", "=", 
  RowBox[{"D", "[", 
   RowBox[{"DirSolL2L1", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.773389585177312*^9, 
  3.773389591472727*^9}},ExpressionUUID->"44457d77-8ca2-4533-a1ef-\
51fc639b3925"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "x", "]"}], "}"}]], "Output",
 CellChangeTimes->{3.7733895965895357`*^9, 
  3.7733896818678894`*^9},ExpressionUUID->"cb69eb0f-ead5-40df-9f67-\
167e3bd64f7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "DirSol1", "]"}], ",", 
     RowBox[{"Evaluate", "[", "DirSol2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.1665", ",", "0.1699"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7730476822874556`*^9, 3.773047700310481*^9}, 
   3.773389267250926*^9, {3.7733893115636077`*^9, 3.7733893381008625`*^9}, 
   3.773389378185937*^9, {3.7733894144092*^9, 3.7733894191672087`*^9}, 
   3.773389488736335*^9, {3.7733896013319445`*^9, 3.773389633117804*^9}, {
   3.7733896869378986`*^9, 3.773389697951518*^9}, {3.7733897449388003`*^9, 
   3.773389798322094*^9}, {3.773389831128952*^9, 3.7733898348417587`*^9}, {
   3.773390268032923*^9, 3.773390284147752*^9}, {3.7733903403702507`*^9, 
   3.7733903717107053`*^9}, {3.773390519739365*^9, 
   3.7733905290057817`*^9}},ExpressionUUID->"81fddb06-fbf6-4ca8-8646-\
2d035f51a95f"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwV0ntYzXccB/DTlXIplzZT2nJtRRm6PFrezmoNDdUs0cVKiLOWXMKwo4so
dKElZElHi9WzWuqpFm21r4iTVpOOposc5/vrRDGn+2Uff3ye7/P65/t8Lm+L
oDCvbdoikWgt1bv3rDTeqXU9w+5CG0WCgYCNDm2DKnKwhUVyHNms266sh1xo
/9HqGPLPAe2O2h4MWl+6lh4ilzs72s8jf/z3nIvBZOWQcrGE3F7qHLCc7HhQ
PL+PnKFzt1s5XkDL7n5jIy8GuUuMgzP5lOzISOgGhvvKhXp1+gLQWFYg82a4
sD301mE9AZVmC1bV+TCkiWdW2OgKyL52XWPly8Dd9efd0RaQvPDFLn9/Bun8
s6YRWgKeahz7bm9hKAq7vNVQJKC/oXSbSRCDTFd8/doox8z8t5dcghl2Tg6b
vWmE43Lt58KV7Qzntc0LeoY4Fqg9Rh+FMIhdj9pfGeSINIvXjO1iSBhuEnsP
cDglKXQ2hTJM2Jmm19PHMazVoYgLY9ja1yHJ7OUwL9auFsIZzOXl9vYaDmOp
R+qKfQwGdXr9df9xGLj5LJJEMPQufTgh+g1H0PqI5jsHGU7Oan32/muOSu91
noPfMxSMc35c1c0RfeXTFr+jNN9XPbperzimj/msvSllqClx26zs4sj1tY3p
iGQQIrOSEtUcskHTenEM7ff3Y1NNOzmyzleqDsQysLfyNbc4x57V51uvnmQ4
0hTqGaziuOoc9Wo4nqHEseOkWsmhsF3AbM4w+BtMXhf3nCM8+NlviYkMHUue
uOl3cDTl3Y9SJlNeCja+iW3ncNN8N3NaCkPgD+0Lzds4TKSW98JSGXztumef
a+FQ66dDlsYw7UOnWPOnHElZzmnyiwxdc/Q25zVzpEZpxs2/zIB84ykznlC/
W3bAO4PBtN7A/UITxxRp95miTAav471jbxs5YtM/kXVlUR7sfOx2POKoqc1M
n5HNMDgS0t7cwBHmYpm7N4fhzvKRXMt6DtPikOjsG5SvL45POV3HYSmpCB+f
R25uTmG1HLp2rp9t+ZVh1iTXlLEHHKrhqCdnCuieJ8RlHvc5rMc1xakLGVwC
x4z33+OIMFKJLIoZTpk9j86v5pS/uZvdS6gfq5xtXYxj4ukDNbIyhrrRn172
VXEkCDHajeUM2Sd8lplWclySHHrQSj4xViifSs55GZoqkG8ec99uSK587W01
Qk4fWPTjwJ8cmgFLr7m3GB4sLxcek/0M5Zl7yJUeitAUspW1idjoNu1rrbpt
Itkhz2DCB+T0of2BumRX29F/ZpMTfRzah/7gCFiqCrEn10v8WzrJyU6lSf7k
8OlLHt4l97v7t/1CjhQ1xseQ9Wo9bxSRM2KLRw+Tp3q47asgK1Q14XvJ1hts
xzeQPaMTvg5697+f1uJBctXkI9NWkiUtmgGdCobGgN5jDuSD33RWTSL/+17W
Sxvy2eCGjRbkDTrn/ppFznhRbWFNlise2ZiQc0PK1cvIq/zWpE0kl3TmF60g
n/LtEemS2bfXpKvIK3OqQ4YqOP4HIO6Lzw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwV0ms0FHgYBvChhC6rvdR2O7umWmmIrjin1bNSTm1bTR0pi1GiBqtZJdSp
M7lshXXLnqnEopkkZXVZKqu0M/6JsIouUoMV858mdJsTk9h3P7znOb8v7/t8
eIVBso0h5gKBYC3N/3lMnry0fT1DZf2E0B5rPTa7dph05KlHfV92kGf0L6l4
RXbcqpS1kc9KOt3MxQz7dyyIbiJXuru5fEOuvuuSUEHu/tA9P5wcMtiTk0Z2
i/Wwe0+u6Xra6ELW/jww0WYjw/bxX887YqVHiurAxwhvhlRNi+dYSz3wsOKS
yofB4n5KbKGFHuoZc1Y1bWEo2dabtHq0HoVnzhlFfgyl1dk9jeZ6ZDr2hAUE
MKAjRhphpsczo9v7m4EMctvjzn0jHAPN10MmBTEMZ025t3eYY9rFd6c8gxm8
bWflTf7Ikdu4Up+/g2GdsL/45AeOOQbx8AMpgyholG6JiSNuRrJxJIwhe+7A
6NYBjqUZraN8Ixj8d0p8Je85hsy6WpNkDFG1C7uHjBxflZvX6CMZTObRBQff
cUyUixXLohjUod7uFm85rL22zAuPpvtK45eFrzmC1ke33Y5l0Cizps99xaH2
WbfBtJ8hyVC6jfVxJOR/q/U/yMA81HWevRxfjGxZ+6ecQTGwYXKtgeOCn3Ni
VxzD971l53e+4FCZpt/3SGQ4aZHlzzmH8rhaF3OYoaHBzC9ex7F79fH200cZ
tO1Sz1k9HKfd4/uGkhn+ujqEwuccrc5zmFMqg+HZiszlXRyRwf9eTk9nyHeq
eHWrk+Nxyd347kyGi7u6XL06OLyMu6Z9/huD2PeTtudajkly+1qZgsHphzeJ
Ic84DGNyoDrBENufkTbSxpGhdD/RkM0wOWvTkfwnHIp4o6VdLsPfx9Lls1qp
b+BO+OQxrAz8XVv1iONTeX9qWQGD7RiR67KHHIdzFqheKhne3vIyPWjhqGss
yJlSyDBF61ca1cwh87S/sKeIwahV+hjvcUwvlyYUFjNM8MuVpTdx2IdXRVqV
MOTZ1keN+4dj9JIVywNLab+mNDStgUM3FP8k9RJDTGf6I1E9h4Pl4yTDFYah
K4tE5+o4om10AmE5g2tbyuB3tZz+b/aPa64xhCqsbrXXcIz/NaZOVcFQXm0Z
vPU2R5o+0fxhJYPl3OYUUzXHqfB99e1kf0H52nfkot4IhZ4cHaew6SOrX/uI
PpIFceKsTrJx0H7j7BsMh/YWZd8h+49tKNhNLl7MixRkkcMkD5ubDF02ZzUL
ya4l1uOmkhcL8YsjeYXzcMtMsuRpi5cdWbJIJ3Uhe4gHa6eSM5dezwgg+znZ
NQnIA2sCOs6TN1XbPG3UcFg0biguI6fsic+9Q/5M7BVVRVbVv5GoyQ7ezlbN
5MQD9Z1lZIm/2XwTeUzzdl0OOVxrHBxVxSC9pylSkGO3vtBMIF/eJwzLIB8L
bt4sJJvdefAygZzXUyN0IFvvcvzjIPmCtNKwmPzhxiFZDPnai4tly8iPr96f
H0lmP52RryLn+818E0b+D1J6mDE=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.1665, 0.7735},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->Automatic,
  ImageSize->{845., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.773047704440487*^9, 3.7733892788105464`*^9, 3.773389340893267*^9, 
   3.7733893822575436`*^9, 3.7733894211952124`*^9, {3.7733894662948914`*^9, 
   3.7733894919499407`*^9}, {3.7733896127909684`*^9, 
   3.7733896340538054`*^9}, {3.773389691149906*^9, 3.77338969907472*^9}, {
   3.773389752941614*^9, 3.773389800537298*^9}, 3.77338983568416*^9, {
   3.7733902751153355`*^9, 3.773390285192953*^9}, {3.773390341415452*^9, 
   3.773390372537507*^9}, 
   3.773390529926183*^9},ExpressionUUID->"c1e8fa7e-7c26-4ed7-9ac2-\
1024efea4e34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", "DirSol1", "]"}], ",", 
     RowBox[{"Evaluate", "[", "DirSol2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.16", ",", "0.18"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "16"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7733898628222113`*^9, 3.773389865723817*^9}, {
  3.773390543264207*^9, 
  3.773390622044345*^9}},ExpressionUUID->"90a72f30-ac4b-4378-8949-\
07dc127385fd"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwVzX08lAcAB/DDnbfeVlTOsXar0a72olIJ+4nIjrzEylucXmZemlSMaNpw
SC33iZY1mfS2sVCIdldbPc9zUjZr5Qhxsz33PK28Rzcv7dkfv8/v8/3n9xPv
TNy6x5DH423h8n+HpX7lrT1EwGAyylF0nMXwZluVZTqBdfXZM5PHWOQtrnLw
5lycqVd3c25ouGtdzdk2uS/8LOcFL/jPMzIItIr1uWLOLUnpCqvPCYh8ikft
C1hsiP/ksf8XBJyPPlzqmM/COtI94WYugW2J3p0BOSwOT7gU1hQTUO2t5NMZ
LO7P1tk2nCNQJdabzEtmMSg4sPlQNfeXNTdMtpdF/VXPpCAVgafhXQrBHhYx
XWq+WwuBQkfp9Xd2sFBeLzy9sYOAsqHmfEkwi78/c242oAmcGfuZb+nLYvJa
cfSjEQL3o1yumG5iUVexdlLFI5EqCEtd78widF7uTNMcEkOJJbKhVSweRDaV
HrQmsXpbn6BNwmIgepXrpuUkKr6tIszfZDHeF+Zl70iCZ7JEPCpkUW7R4r/E
g4SzPcUPmM/iDYnoxaMAEpWV34/pTVkcU4r43+0gkV/TFeJnwOKM4S6LzHgS
HqqH2eZ6BqeI0GNJqSTWz43w8hlmsGbD14I0OQnp5coSJcPg4skGaxSRyA2e
KDToY8CPzSmxKichZqJX7tQwEIx8Y2VSTcLuns0z91YGo+NRBmZKEv2SguSW
2wzqeo3ld5tJCO+NH3G6zkCYMWZe1k4itKwsRXWZQVyRQp/bT6LMoMFBe5pB
pCyZyRkm0W0m3ZWdzcDuNecD7q9I/PXqA19NAoPHzjUxC2ZTmKl1WpgQxMBB
lBAxIaRwpD2ztmcNg4MpmhuDdhQKVr0899MiBgX1y+ovrqYQ1lM2PfNSB8/L
jdX7N1I4PTlGXurU4dmiKYutfhRWYn+vRqXDWid5qlcEBflRXUhwuQ4Jmlte
frEUBhd2MEZ5OqSEdtVYplAQFp0ZWbhPh6UnXEVDWRSWGymu1m3TQenmP/ik
kEJg37X496DDywuX7vx5loIyYZbVl2/pYDqoXX2hikL6+4E//jZLB0HdvTnp
TRROCeucnEZpXFg5pdujptCfXZ76q4aGg7h7xe6HFKo3LrfJU9FQ6EtnibUU
xk8k0+4VNIpyLv4zMkChim+Y+7GcRtbxSMeOSQrGjYED4fE0rMXeLfOnKMT5
unj2x9GoqXOI8uH8b8TZ0jjOT7r4+Tc5S+p3BqXF0lgvqew+P01BFundfiqG
xnNqIivpFYV9bjcCHuyisZ2neGBupIYsb7rSJ4LGwMlDMZs4t86RRv8RTiPb
fvfUYc63oxXW4Zyv+q2zG+bsqn23JC6MxuzSnjQNXw3DnkB1fgiNX5wk4vPG
apQ14WlzMI2QVouGHs52lr7aAM4DsmnpYhM1mmRp3R1BNGzy2g4e5bw949Ne
ZiuNlPaU5n2maszr8xCZBXL7cbIdP3BOl2sdFQE0KqY/HOnnHNwo/UjIuW2Z
rc12MzXkV26de9ufRkyjcW0hZ7g/bav1ozHjM+TZwlnCe52/gXNRb+djI3M1
POxjXW5vobHiwJ1EV86/Z3amSTn/B6DoaSc=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    LineBox[CompressedData["
1:eJwV03001XccB3APF2mskNGVyqarMEbT0qU3eYjuodY0aVwshuLISCJS8hQV
oVUb8xA1akwijdrW7/e7qLbmzENXSdO6398p11OiofbdH5/zPq/z+evzPudj
9mXs9nA1FRUVHzr/566kk15PkhmcNhNb+Z7gMb7ZtH1JCgP5YMiUDXWO0WU7
L+qnL9xuLaJubu4U1lNnzLlu/zOfh/6UYOTQIQaiSdP9ftRdcSmFxmkMvLJ3
/Lgrj8eGvZHyrUcYxJWwyq9yeQilm6JvZjN4VvrzxbRMHqnTTgUNJQzSeVsX
tVQed3UUps2VDELr8sL19vMY1YjfnFzPIKh+yts9hse1Ro+4z9oZ2CYIJZ1h
PCIGZAKXLgYtkpwH8kAebS0FZ137GXRVzjQ6+/H454C4Q/UZg0KTNSqMhMfs
1ZLQngkGdp6rh/rceDRVrZttV2Eh0JvWchLzCFiU/aZVl0XQGVMvm7U8uqWt
pQlCFsf9hVoeVjyUofbO7qtZVAYu1q97n8eroV2eFg4sTh/dZ18u5FFh0LV1
hRuL8vv9fwzr8VhpaTLVs42FpU9vhUSbR36biaA8iMWoYViemyqPb9V2Gxze
y0Jy1HEiZ4bgDBOQH5fEondLykvpGMHHG77ROJjFoqfboeaIgqCmqFmIYhYO
Au/pjkECQVTmOeMKFlXWus8qegk0Js4ba9WzkN0pyuTuEUy+ClbVbmOxoszf
M5UlaHqsmdXZwaI/qeBKQDvB0kMvF37fy6IzSvX39CaCPcWFr7OHWewN5xeI
LxNIQ/aTzHEW72ZV26GKQLRYHL/pLYsvdETXI88TyMUNEfo6HBpHJP6i0wR2
JtGB00s5aP+izVvnEiQk9t0YFXGQnnU27EgnyLtmfq1mLYdx0UBlbhKBx6Xr
9V+7ctB31LctiiV48d6cwXZfDhfsyiX2EQTrHLOSPAM5GKr5lBlLCaL7bnn6
RnGYsX6qVrKDIDFgoGFJIt2nDtus9yH44JSzyVgGB12n30rN3AnaXLaODhZw
CGkZMagUE8xUX7z9dxmHNgtTjUh7ggWjT9ZWX+bga34y0W8N7a/pjm5KK4cD
Lml8/0qCaus5RbiMg3zVlaEKI3qf2UOrsL84ZKRZBKgvIih8XfqO2RMOI5bp
n+ZrEhRn1jyfUHKwiEwe3DmvQMYJqUP/LEf/4ergzZcKCM28uvTmOARfiYk5
S93QZBcsoTa++mA2jnpwQJB7k/pAsMxoFfV6y7qHF+Y5mG95LcmbVGCEm86I
e8thqL+l2n9CAX+Vwu6F6jKkRFUtHxtVQFmUHOFOXXL4fFUn9TGLsLlU6lOZ
bqurqBt9PxGNU9vurvvoc2qd0kcH+wQy+MV3O7cpFfjV0dLsgqYMczvTvHNG
FNh5z6D5EbVJbXFnKLUyZH6LkZYMGycDvcXUy3LuJxynPhmr7qV8oUBib2LH
vgUy/LD8kqsftc6ekKBaasONvrc+pK6a954Ypi4OqHHSor5vbrrMX1uGnqzo
dTeeKxBxXfOnAurvzskbi6jfSMY8uqhTa/+1iaEufvxArr5Qhjetd2s9qa3i
b8c6U5d1bBOtpP4Pw1JsXA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.16, 0.6950000000000001},
  AxesStyle->Directive[
    GrayLevel[0], 16],
  GridLines->Automatic,
  ImageSize->{855., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.773389866659818*^9, {3.7733905582558327`*^9, 
   3.7733906228867464`*^9}},ExpressionUUID->"081bdf17-0281-4f2b-8c75-\
593070dda9cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", "DirSol1", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", "DirSol", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.773047728813521*^9, {3.773048294411317*^9, 
   3.773048331265369*^9}},ExpressionUUID->"db7c16fb-fc37-4fbf-8837-\
97cc3fbf2b1d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"0.31509722671411705`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7730475179662247`*^9, 3.7730477326545267`*^9, 
  3.7730483325653706`*^9},ExpressionUUID->"d4500725-c5c8-4171-8fe7-\
12b3a122e5eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"0.6301944739300914`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7730475179662247`*^9, 3.7730477326545267`*^9, 
  3.7730483325653706`*^9},ExpressionUUID->"de2051bf-b62f-4bf1-aa59-\
b48f57247cf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.6301944739300914`", "\[VeryThinSpace]", "-", 
  "0.31509722671411705`", "\[VeryThinSpace]"}]], "Input",
 CellChangeTimes->{{3.7730483464373903`*^9, 
  3.7730483535984*^9}},ExpressionUUID->"5ba785ec-b102-46d1-b04b-0e8535e7963d"],

Cell[BoxData["0.3150972472159744`"], "Output",
 CellChangeTimes->{
  3.7730483548184023`*^9},ExpressionUUID->"5829b6b1-7ae4-4f95-8ab3-\
2fc1b7175f33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", "DirSol1", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.773047753517556*^9},ExpressionUUID->"7be655f8-7f0a-4e7d-bc3b-\
69e9018c90bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"1.0016072878173914`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.773047754427557*^9},ExpressionUUID->"7374384e-dafc-40ce-9fdd-\
f3350933b238"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.0016072878173914`", "-", "0.6301944739300914`", 
  "\[VeryThinSpace]"}]], "Input",
 CellChangeTimes->{{3.7730483962854605`*^9, 
  3.77304841004748*^9}},ExpressionUUID->"9c79909b-a56c-4f3a-b6eb-\
202a7426cb1b"],

Cell[BoxData["0.37141281388729996`"], "Output",
 CellChangeTimes->{
  3.7730484111074815`*^9},ExpressionUUID->"01c5d713-21cd-415a-93ca-\
8170d8bb271b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", "DirSol1", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1.7"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7730478252166567`*^9, 
  3.7730478256166573`*^9}},ExpressionUUID->"acfda7eb-2034-44f1-bcbe-\
62701acc3b54"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"1.6881173448712699`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7730478265666585`*^9},ExpressionUUID->"a45b7e53-120e-4004-a4b3-\
5c2601e89541"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", "DirSol1", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2.4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7730478592717047`*^9, 3.7730478715827217`*^9}, {
  3.773047920789791*^9, 
  3.7730479343328104`*^9}},ExpressionUUID->"055d3ab7-7412-409e-be22-\
170f05b84628"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"2.3746274064726527`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7730479353428116`*^9},ExpressionUUID->"1a7aab00-0460-4578-bb46-\
b39e532c141b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", "DirSol1", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.773047945533826*^9},ExpressionUUID->"4656c61b-6673-4668-9da9-\
c2865a1a27a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"3.06113745532454`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7730479463938274`*^9},ExpressionUUID->"b0192de6-afab-44e7-b58d-\
dd5d3017b753"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.0016072878173914`", "\[VeryThinSpace]", "-", 
  "0.31509722671411705`"}]], "Input",
 CellChangeTimes->{{3.7730482191712112`*^9, 
  3.7730482263922215`*^9}},ExpressionUUID->"3f9c0f4c-d713-4aee-a36b-\
54f905ded8e0"],

Cell[BoxData["0.6865100611032744`"], "Output",
 CellChangeTimes->{
  3.7730482358232346`*^9},ExpressionUUID->"7e103a8d-c88e-405d-899d-\
2c2be9256bc5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.6881173448712699`", "\[VeryThinSpace]", "-", 
  "1.0016072878173914`", "\[VeryThinSpace]"}]], "Input",
 CellChangeTimes->{{3.773048251755257*^9, 
  3.7730482576762657`*^9}},ExpressionUUID->"98487046-f994-4ee2-9c3b-\
766967d2f742"],

Cell[BoxData["0.6865100570538785`"], "Output",
 CellChangeTimes->{
  3.773048258666267*^9},ExpressionUUID->"8bfefdb6-af28-4485-8c9f-\
fb2fc5895bf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"g", "/", 
          RowBox[{"(", 
           RowBox[{"L2", "+", 
            RowBox[{
             RowBox[{"HeaviApprox", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"y", "[", "x", "]"}]}], "+", "y0"}], "]"}], "*", 
             "L1"}]}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0."}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0.", "]"}], "==", "0."}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0.", "]"}], "\[Equal]", "1."}]}], "}"}], 
    ",", 
    RowBox[{"y", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.1", ",", "0.3"}], "}"}], ",", 
    RowBox[{"AccuracyGoal", "->", "24"}], ",", 
    RowBox[{"PrecisionGoal", "->", "24"}], ",", 
    RowBox[{"WorkingPrecision", "->", "35"}], ",", 
    RowBox[{"MaxSteps", "->", "Infinity"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7733797194384503`*^9, 3.7733797239624586`*^9}, {
   3.773379864471905*^9, 3.7733798839407396`*^9}, {3.773379918994001*^9, 
   3.7733799230968084`*^9}, {3.7733799866669197`*^9, 3.773380003296549*^9}, {
   3.7733800815930862`*^9, 3.7733800963351126`*^9}, {3.773380129750371*^9, 
   3.77338013472678*^9}, {3.7733801921816807`*^9, 3.773380222866935*^9}, {
   3.7733802997282696`*^9, 3.7733803016158733`*^9}, {3.7733806640357094`*^9, 
   3.77338068684295*^9}, {3.773380768633893*^9, 3.7733807726119003`*^9}, {
   3.773381063911212*^9, 3.773381064644413*^9}, 3.773381114938902*^9, {
   3.7733835111675105`*^9, 3.773383537609557*^9}, {3.7733836506161556`*^9, 
   3.7733836560293646`*^9}, {3.7733837093502584`*^9, 3.773383710801061*^9}, {
   3.7733837854939923`*^9, 3.773383788348797*^9}, {3.7733838680493374`*^9, 
   3.773383870607742*^9}, {3.7733840901157274`*^9, 3.7733841169945745`*^9}, {
   3.773384713368022*^9, 3.7733847188904314`*^9}, {3.7733849179623814`*^9, 
   3.773384922299189*^9}, {3.7733853535307465`*^9, 
   3.7733853579923544`*^9}},ExpressionUUID->"109f27d3-93cc-49ea-8be5-\
9336dfbbe370"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], ":", 
  " ", "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(9.8`\\\\ \
\\(\\(Sin[\\(\\(y[x]\\)\\)]\\)\\)\\)\\/\\(\\(\\(0.2` \[VeryThinSpace]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\) + \\(\\(\
\\(\\(\\*SuperscriptBox[\\\"y\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\)\\) \[Equal] 0.`\\)\\), \
\\(\\(\\(\\(y[0.`]\\)\\) \[Equal] 0.`\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"y\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[0.`]\\)\\) \[Equal] 1.`\\)\\)}\\)\\), \
\\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\)}\\)\\n\
\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(35.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.773383712548264*^9, 3.7733837894095993`*^9, 
  3.773383871512543*^9, 3.7733841180709763`*^9, 3.7733847227436385`*^9, 
  3.7733849260431957`*^9, 
  3.7733853605663586`*^9},ExpressionUUID->"9a823734-ec54-44da-8a3a-\
fa340ee66182"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
          "0.1000000000000000055511151231257827021181583404541015625`35.", 
           ",", "0.299999999999999988897769753748434595763683319091796875`35.\
"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.77337972494526*^9, {3.773379869073913*^9, 3.7733798895723495`*^9}, 
   3.7733799265444145`*^9, {3.7733800062605543`*^9, 3.773380019348977*^9}, 
   3.7733801002663193`*^9, 3.773380135974782*^9, 3.7733801953796864`*^9, 
   3.7733802349101562`*^9, 3.7733805460527024`*^9, 3.7733806731149254`*^9, 
   3.7733807431902485`*^9, 3.773380913074547*^9, 3.7733812583811536`*^9, 
   3.7733835407919626`*^9, 3.7733836589621696`*^9, 3.77338376699236*^9, 
   3.77338385833052*^9, 3.773383964675907*^9, 3.773384203153526*^9, 
   3.773384807748188*^9, 3.773385017724557*^9, 
   3.773385533198262*^9},ExpressionUUID->"7f5aef50-88b6-405c-9191-\
5a7c67055274"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "s2"}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.1", ",", "0.3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.773379758110918*^9, 3.7733797625725265`*^9}, {
   3.7733798862807436`*^9, 3.7733798993223667`*^9}, {3.77337993002322*^9, 
   3.7733799351088295`*^9}, 3.7733800161665716`*^9, 3.773380111233139*^9, {
   3.7733801461772003`*^9, 3.7733801488760047`*^9}, 3.7733811110388947`*^9, {
   3.7733827649869995`*^9, 3.773382765767001*^9}, {3.773383665810582*^9, 
   3.773383671067791*^9}, {3.7733841072913575`*^9, 3.773384109771762*^9}, {
   3.7733849339368095`*^9, 3.7733849379460163`*^9}, {3.773385602899184*^9, 
   3.773385607079992*^9}},ExpressionUUID->"7f0f588e-9136-4832-a485-\
aa9d3ee68537"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8lF0UB3BKtJNEtJFE9SYRCflR0YJUJJGSLJWtshYtVLaQLZSthV6R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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.1, 0.1},
  ImageSize->{867., Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7733797637269287`*^9, {3.773379875251524*^9, 3.773379900227168*^9}, 
   3.7733799362944317`*^9, 3.7733800205969796`*^9, {3.7733801129647417`*^9, 
   3.7733801498744063`*^9}, 3.773380199981694*^9, 3.773380237671361*^9, 
   3.7733806419148707`*^9, 3.773380677248933*^9, 3.773380762924283*^9, 
   3.773381004100707*^9, 3.773381278661189*^9, 3.773382766843403*^9, 
   3.773383553771185*^9, {3.773383662269376*^9, 3.7733836720817933`*^9}, 
   3.773383775743975*^9, 3.7733840687280893`*^9, 3.7733842251183643`*^9, 
   3.773384860881881*^9, 
   3.7733856090611954`*^9},ExpressionUUID->"6c243069-47e6-4839-ac52-\
265e88f892ed"]
}, Open  ]]
},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7b67c8d7-0a16-41f1-83d2-40ed3ac658d8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 446, 8, 30, "Input",ExpressionUUID->"0b14b5d0-37a6-4a04-a5b0-531dac71859e"],
Cell[1028, 32, 477, 8, 34, "Output",ExpressionUUID->"e9db1e3c-b6be-40a0-9395-1cb2f08a24c3"]
}, Open  ]],
Cell[1520, 43, 2711, 67, 204, "Input",ExpressionUUID->"38e630ab-310c-44c1-969e-8f16fdabcd36"],
Cell[CellGroupData[{
Cell[4256, 114, 368, 7, 30, "Input",ExpressionUUID->"6d975f67-cc5f-4c9d-ae34-eccda3b39f2a"],
Cell[4627, 123, 2692, 67, 123, "Output",ExpressionUUID->"76fb4f67-850b-4624-baac-4a67884829cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7356, 195, 712, 15, 30, "Input",ExpressionUUID->"cca90053-1f6b-4be0-9123-464d5bd36457"],
Cell[8071, 212, 47783, 791, 462, "Output",ExpressionUUID->"099eaa73-917c-4a52-b5ec-8541984ee728"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55891, 1008, 277, 7, 30, "Input",ExpressionUUID->"0c36d5ca-86e9-43d0-a95e-73fbdb25cb2f"],
Cell[56171, 1017, 2982, 80, 169, "Output",ExpressionUUID->"5ec0f102-63a5-4833-8506-6ab62477fff3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59190, 1102, 3277, 86, 309, "Input",ExpressionUUID->"70495ab6-7ad6-4407-a56a-aa84da3a8d02"],
Cell[62470, 1190, 2979, 80, 169, "Output",ExpressionUUID->"7257701e-9dd7-40c7-ab50-536d4aa421ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65486, 1275, 369, 7, 52, "Input",ExpressionUUID->"5bbe0624-c4cb-4ceb-bc23-1a408ff17512"],
Cell[65858, 1284, 324, 5, 34, "Output",ExpressionUUID->"5bf78168-f4ac-4002-a7e9-adbb2cb8cf4b"],
Cell[66185, 1291, 331, 5, 34, "Output",ExpressionUUID->"9822f272-32e2-4043-bd5b-69990f369841"]
}, Open  ]],
Cell[66531, 1299, 540, 17, 48, "Input",ExpressionUUID->"535398e4-a755-4b06-84a0-6dc3a9b3bad8"],
Cell[CellGroupData[{
Cell[67096, 1320, 829, 22, 73, "Input",ExpressionUUID->"33ba32e1-3da5-4afb-ac3a-83b5f133234e"],
Cell[67928, 1344, 535, 11, 24, "Message",ExpressionUUID->"6fb09fdf-f3b9-4fdb-8657-5dcb8503b1a8"],
Cell[68466, 1357, 1633, 34, 236, "Output",ExpressionUUID->"3243f186-a9e0-4951-b29d-604a34f2d332"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70136, 1396, 227, 5, 30, "Input",ExpressionUUID->"56c6aa1c-9d55-4be6-99e4-ed966e3485a7"],
Cell[70366, 1403, 2982, 80, 169, "Output",ExpressionUUID->"94edde71-35bc-43d7-a67e-bf60e0af281e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73385, 1488, 441, 12, 30, "Input",ExpressionUUID->"25ab854f-9843-49a5-84b2-042e29eddc0e"],
Cell[73829, 1502, 49297, 815, 233, "Output",ExpressionUUID->"d9a07e8e-af2b-4e7e-92fb-e21d582757fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123163, 2322, 346, 7, 30, "Input",ExpressionUUID->"295a5d3a-ef78-4cc8-a11b-c7c98c7ef46c"],
Cell[123512, 2331, 2742, 71, 144, "Output",ExpressionUUID->"f6d43f7b-eb31-43b2-80e1-32aac613c7d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126291, 2407, 698, 18, 52, "Input",ExpressionUUID->"a0df5071-9d8b-44c6-9199-e11bcb523b88"],
Cell[126992, 2427, 125014, 2058, 239, "Output",ExpressionUUID->"3248a7a9-3b4e-4c3b-9756-a7f94e5d7da1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[252043, 4490, 850, 15, 115, "Input",ExpressionUUID->"5d138dec-e361-47d7-bba4-444e63d129b6"],
Cell[252896, 4507, 690, 10, 34, "Output",ExpressionUUID->"e46f1afe-cd6b-4e79-bf92-0ca91799690b"],
Cell[253589, 4519, 692, 10, 34, "Output",ExpressionUUID->"284b3d16-461c-4555-9b38-ba041bcc9152"],
Cell[254284, 4531, 687, 9, 34, "Output",ExpressionUUID->"ae553a50-b6d3-474b-aebe-7ae266f0d3c0"],
Cell[254974, 4542, 712, 11, 47, "Output",ExpressionUUID->"0d72e5fa-ef24-40cb-b73f-f004c3042429"],
Cell[255689, 4555, 712, 11, 47, "Output",ExpressionUUID->"d2bbfb16-3b83-4d3e-9953-cae28f5e8223"]
}, Open  ]],
Cell[CellGroupData[{
Cell[256438, 4571, 2901, 74, 136, "Input",ExpressionUUID->"fa1c44a8-7535-4371-9aff-bde2a429a7fd"],
Cell[259342, 4647, 551, 11, 24, "Message",ExpressionUUID->"7a1f44b8-dcd9-46c5-8e81-82ea95c74154"],
Cell[259896, 4660, 2825, 71, 139, "Output",ExpressionUUID->"d0218d22-bbbf-49de-8299-7754b1e1a433"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262758, 4736, 1458, 38, 52, "Input",ExpressionUUID->"67f106fe-0157-4d0c-9b8a-b340587f8f49"],
Cell[264219, 4776, 978, 24, 34, "Output",ExpressionUUID->"fd4b3d09-764f-4a66-9fa3-19a7e39d1464"]
}, Open  ]],
Cell[CellGroupData[{
Cell[265234, 4805, 2279, 65, 136, "Input",ExpressionUUID->"c8ab0ae4-b42e-4624-bc42-8213918e17ab"],
Cell[267516, 4872, 628, 18, 34, "Output",ExpressionUUID->"97f6cbb6-2314-461a-a778-4d7bcf25d296"]
}, Open  ]],
Cell[CellGroupData[{
Cell[268181, 4895, 395, 11, 30, "Input",ExpressionUUID->"f976f979-ff6c-4751-9578-66011e5a429c"],
Cell[268579, 4908, 491, 14, 34, "Output",ExpressionUUID->"be25024e-e939-4cd1-bc59-bd6586518dbc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[269107, 4927, 242, 6, 30, "Input",ExpressionUUID->"dd1664c4-0adb-4b75-8112-cafc7166bd30"],
Cell[269352, 4935, 446, 13, 34, "Output",ExpressionUUID->"d9c5083b-8b72-46c2-a4b6-64bfde0be342"]
}, Open  ]],
Cell[CellGroupData[{
Cell[269835, 4953, 1540, 40, 94, "Input",ExpressionUUID->"d9a78473-55ea-40e3-b62f-5a7cd823d54f"],
Cell[271378, 4995, 26947, 454, 440, "Output",ExpressionUUID->"c3214fa8-2e98-4aad-bb1c-561b9244a76f"]
}, Open  ]],
Cell[298340, 5452, 158, 3, 30, "Input",ExpressionUUID->"aae9a143-7ae2-4bca-b81a-c89d11c74fa2"],
Cell[CellGroupData[{
Cell[298523, 5459, 1674, 47, 115, "Input",ExpressionUUID->"18ae3dd3-94a6-4aa9-98e0-edfec82d9bd7"],
Cell[300200, 5508, 27261, 458, 402, "Output",ExpressionUUID->"234ca101-b04d-43ba-96a5-80a12aa17311"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327498, 5971, 1285, 32, 73, "Input",ExpressionUUID->"e5930e42-918d-41b7-8e98-f315a93b809d"],
Cell[328786, 6005, 23898, 400, 221, "Output",ExpressionUUID->"93e7d926-e473-44ea-a392-b02f4703f71a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352721, 6410, 1176, 33, 52, "Input",ExpressionUUID->"b4d03d21-a27c-434a-a2a4-d04e3a4105b5"],
Cell[353900, 6445, 600, 18, 34, "Output",ExpressionUUID->"89bdee7d-a482-4af9-b033-03402608943f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354537, 6468, 894, 26, 30, "Input",ExpressionUUID->"457175f9-817a-447e-a551-c4f2421661c8"],
Cell[355434, 6496, 553, 17, 34, "Output",ExpressionUUID->"1984060b-d07a-472f-8293-becffb7f7449"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356024, 6518, 921, 27, 30, "Input",ExpressionUUID->"86467969-5ed9-4fe0-8330-66f8016618e4"],
Cell[356948, 6547, 553, 17, 34, "Output",ExpressionUUID->"7170780e-6644-4dcf-84c8-8619b2549a37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357538, 6569, 217, 4, 30, "Input",ExpressionUUID->"6d6b075a-bcfe-4029-b94c-1b35159a30ac"],
Cell[357758, 6575, 151, 3, 34, "Output",ExpressionUUID->"7d4f1665-5802-4da0-a0b8-93f4ab64b3ba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357946, 6583, 568, 14, 30, "Input",ExpressionUUID->"23b7da7a-ff5b-4583-bce0-241310896959"],
Cell[358517, 6599, 6895, 179, 374, "Output",ExpressionUUID->"85a3ea7d-6064-485a-8e4c-77d59014fea7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[365449, 6783, 2166, 47, 94, "Input",ExpressionUUID->"e53aa6bd-479c-4689-bae5-cb963b870b0c"],
Cell[367618, 6832, 69047, 1144, 531, "Output",ExpressionUUID->"2d79fc0b-73fa-45d9-99e9-a9aaee99cb7e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[436702, 7981, 963, 26, 73, "Input",ExpressionUUID->"618ff81a-d82c-4ad1-9f38-635bda2b53cb"],
Cell[437668, 8009, 15953, 270, 370, "Output",ExpressionUUID->"eceadcc4-0282-4970-97f5-617c6d7a4b35"]
}, Open  ]],
Cell[CellGroupData[{
Cell[453658, 8284, 1022, 27, 73, "Input",ExpressionUUID->"674582af-1b49-449d-9c5b-897f1751e966"],
Cell[454683, 8313, 1990, 41, 296, "Output",ExpressionUUID->"6898dbdc-bcba-458d-96fb-2a1d7ed3286d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[456710, 8359, 1229, 34, 52, "Input",ExpressionUUID->"1e99fbca-fa85-43a8-a598-bdf43d8c7c73"],
Cell[457942, 8395, 606, 18, 34, "Output",ExpressionUUID->"541fe58d-ec22-496e-8f3b-5fc50ce5d855"]
}, Open  ]],
Cell[CellGroupData[{
Cell[458585, 8418, 1097, 24, 52, "Input",ExpressionUUID->"a8a7b70f-c099-4440-b0a2-84947db9ea62"],
Cell[459685, 8444, 4110, 75, 475, "Output",ExpressionUUID->"ead036dd-0354-478e-996d-e999f62657be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[463832, 8524, 419, 12, 30, "Input",ExpressionUUID->"c0bcb690-1011-4a97-99d4-86677533966c"],
Cell[464254, 8538, 332, 7, 34, "Output",ExpressionUUID->"b9f43d90-094f-466a-8b79-4daac8e65180"]
}, Open  ]],
Cell[464601, 8548, 825, 27, 52, "Input",ExpressionUUID->"a624034c-a7d3-47a7-9720-50dd1d4e5caf"],
Cell[CellGroupData[{
Cell[465451, 8579, 262, 6, 30, "Input",ExpressionUUID->"1fded208-1cf4-40ef-ba2c-6112a46be933"],
Cell[465716, 8587, 481, 15, 34, "Output",ExpressionUUID->"debf8942-4b67-47e6-aff5-4d1d3c84f827"]
}, Open  ]],
Cell[CellGroupData[{
Cell[466234, 8607, 291, 7, 30, "Input",ExpressionUUID->"78568049-9dbe-4bc0-924b-54b042725227"],
Cell[466528, 8616, 479, 15, 34, "Output",ExpressionUUID->"7aea96f3-6b18-4a10-86f1-5c906a10deef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467044, 8636, 241, 6, 30, "Input",ExpressionUUID->"24d1d4fb-88c6-42cb-b28d-009fd390daba"],
Cell[467288, 8644, 420, 13, 34, "Output",ExpressionUUID->"717d12dc-d006-45aa-ab69-86ce419a1fbc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467745, 8662, 242, 6, 30, "Input",ExpressionUUID->"44457d77-8ca2-4533-a1ef-51fc639b3925"],
Cell[467990, 8670, 424, 13, 34, "Output",ExpressionUUID->"cb69eb0f-ead5-40df-9f67-167e3bd64f7c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[468451, 8688, 1216, 24, 52, "Input",ExpressionUUID->"81fddb06-fbf6-4ca8-8646-2d035f51a95f"],
Cell[469670, 8714, 4205, 78, 525, "Output",ExpressionUUID->"c1e8fa7e-7c26-4ed7-9ac2-1024efea4e34"]
}, Open  ]],
Cell[CellGroupData[{
Cell[473912, 8797, 734, 18, 52, "Input",ExpressionUUID->"90a72f30-ac4b-4378-8949-07dc127385fd"],
Cell[474649, 8817, 3937, 74, 539, "Output",ExpressionUUID->"081bdf17-0281-4f2b-8c75-593070dda9cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[478623, 8896, 572, 16, 52, "Input",ExpressionUUID->"db7c16fb-fc37-4fbf-8837-97cc3fbf2b1d"],
Cell[479198, 8914, 333, 7, 34, "Output",ExpressionUUID->"d4500725-c5c8-4171-8fe7-12b3a122e5eb"],
Cell[479534, 8923, 332, 7, 34, "Output",ExpressionUUID->"de2051bf-b62f-4bf1-aa59-b48f57247cf7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[479903, 8935, 253, 4, 30, "Input",ExpressionUUID->"5ba785ec-b102-46d1-b04b-0e8535e7963d"],
Cell[480159, 8941, 150, 3, 34, "Output",ExpressionUUID->"5829b6b1-7ae4-4f95-8ab3-2fc1b7175f33"]
}, Open  ]],
Cell[CellGroupData[{
Cell[480346, 8949, 309, 9, 30, "Input",ExpressionUUID->"7be655f8-7f0a-4e7d-bc3b-69e9018c90bb"],
Cell[480658, 8960, 282, 7, 34, "Output",ExpressionUUID->"7374384e-dafc-40ce-9fdd-f3350933b238"]
}, Open  ]],
Cell[CellGroupData[{
Cell[480977, 8972, 235, 5, 30, "Input",ExpressionUUID->"9c79909b-a56c-4f3a-b6eb-202a7426cb1b"],
Cell[481215, 8979, 151, 3, 34, "Output",ExpressionUUID->"01c5d713-21cd-415a-93ca-8170d8bb271b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[481403, 8987, 339, 9, 30, "Input",ExpressionUUID->"acfda7eb-2034-44f1-bcbe-62701acc3b54"],
Cell[481745, 8998, 284, 7, 34, "Output",ExpressionUUID->"a45b7e53-120e-4004-a4b3-5c2601e89541"]
}, Open  ]],
Cell[CellGroupData[{
Cell[482066, 9010, 390, 10, 30, "Input",ExpressionUUID->"055d3ab7-7412-409e-be22-170f05b84628"],
Cell[482459, 9022, 284, 7, 34, "Output",ExpressionUUID->"1a7aab00-0460-4578-bb46-b39e532c141b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[482780, 9034, 309, 9, 30, "Input",ExpressionUUID->"4656c61b-6673-4668-9da9-c2865a1a27a1"],
Cell[483092, 9045, 282, 7, 34, "Output",ExpressionUUID->"b0192de6-afab-44e7-b58d-dd5d3017b753"]
}, Open  ]],
Cell[CellGroupData[{
Cell[483411, 9057, 239, 5, 30, "Input",ExpressionUUID->"3f9c0f4c-d713-4aee-a36b-54f905ded8e0"],
Cell[483653, 9064, 150, 3, 34, "Output",ExpressionUUID->"7e103a8d-c88e-405d-899d-2c2be9256bc5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[483840, 9072, 256, 5, 30, "Input",ExpressionUUID->"98487046-f994-4ee2-9c3b-766967d2f742"],
Cell[484099, 9079, 148, 3, 34, "Output",ExpressionUUID->"8bfefdb6-af28-4485-8c9f-fb2fc5895bf1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484284, 9087, 2280, 50, 73, "Input",ExpressionUUID->"109f27d3-93cc-49ea-8be5-9336dfbbe370"],
Cell[486567, 9139, 1312, 23, 62, "Message",ExpressionUUID->"9a823734-ec54-44da-8a3a-fa340ee66182"],
Cell[487882, 9164, 1201, 27, 56, "Output",ExpressionUUID->"7f5aef50-88b6-405c-9191-5a7c67055274"]
}, Open  ]],
Cell[CellGroupData[{
Cell[489120, 9196, 922, 18, 30, "Input",ExpressionUUID->"7f0f588e-9136-4832-a485-aa9d3ee68537"],
Cell[490045, 9216, 6114, 106, 551, "Output",ExpressionUUID->"6c243069-47e6-4839-ac52-265e88f892ed"]
}, Open  ]]
}
]
*)

