(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10728,        321]
NotebookOptionsPosition[      9911,        300]
NotebookOutlinePosition[     10232,        314]
CellTagsIndexPosition[     10189,        311]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ham", "]"}], ";", 
  RowBox[{"\[Sigma]x", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]y", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]z", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "ham", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", " ", 
   RowBox[{
    RowBox[{"\[Sigma]x", " ", 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "-", 
        SuperscriptBox["ky", "2"]}], ")"}], "2"]}], "+", 
    RowBox[{"\[Sigma]y", " ", "kx", " ", "ky"}], "+", 
    RowBox[{"\[Sigma]z", " ", "kz"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eigensystem", "[", 
   RowBox[{"ham", "+", 
    RowBox[{"V", " ", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0"},
        {"0", "1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}]}], 
   "]"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.795085954124455*^9, 3.7950859982524014`*^9}, {
  3.795116011972033*^9, 3.795116061641129*^9}, {3.795116166304434*^9, 
  3.795116167050086*^9}, {3.795116218605338*^9, 3.795116220039884*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"b9709eda-1830-44c1-a55e-f8b3d4795753"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"]}], ")"}], "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["kz", "2"]}]}]]}], "+", "V"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"]}], ")"}], "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["kz", "2"]}]}]]}], "+", "V"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "kz"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"]}], ")"}], "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"]}], ")"}], "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", "1"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.795085976374176*^9, 3.795085998741048*^9}, {
   3.795116051819973*^9, 3.795116062333172*^9}, 3.795116168947401*^9, 
   3.795116221142551*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"a9237c6a-1df7-4060-b255-b987ea028313"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"ham", ",", "\[Psi]"}], "]"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"bdy", " ", "conditions", " ", "from", " ", "continuity", " ", 
    RowBox[{"eqn", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["idx", "2"], "-", 
        SuperscriptBox["idy", "2"]}], ")"}], "2"], " ", "\[Sigma]x"}], "+", 
    RowBox[{"idx", " ", "idy", " ", "\[Sigma]y"}], "-", 
    RowBox[{"idz", " ", "\[Sigma]z"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Psi]1", ",", "\[Psi]2"}], "}"}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"ham", "+", "V"}], ")"}], ".", "\[Psi]"}]}], "Input",
 CellChangeTimes->{{3.795086039893875*^9, 3.7950860621695967`*^9}, {
  3.795116095066002*^9, 3.795116132968729*^9}, {3.795116380319216*^9, 
  3.79511639511106*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"b1ea21a3-d501-4b2b-8907-e9f0d43e20e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "idz"}], "+", "V"}], ")"}], " ", "\[Psi]1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "idx", " ", "idy"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["idx", "2"], "-", 
          SuperscriptBox["idy", "2"]}], ")"}]}], "+", "V"}], ")"}], " ", 
     "\[Psi]2"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "idx", " ", "idy"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["idx", "2"], "-", 
          SuperscriptBox["idy", "2"]}], ")"}]}], "+", "V"}], ")"}], " ", 
     "\[Psi]1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"idz", "+", "V"}], ")"}], " ", "\[Psi]2"}]}]}], "}"}]], "Output",\

 CellChangeTimes->{3.795086062736177*^9, 3.795116135259673*^9, 
  3.795116395938826*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"0d1469ff-e096-492b-930b-a8c9ac6fa675"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "  ", 
  RowBox[{
   RowBox[{"idy", "  ", "\[Psi]2"}], " ", "+", " ", 
   RowBox[{
    FractionBox["idx", "2"], " ", "\[Psi]2", " ", "means", " ", "both", " ", 
    "\[Psi]2", " ", "and", " ", "idx", " ", "\[Psi]2", " ", "are", " ", 
    "continuous"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.795117184722939*^9, 3.795117191772575*^9}, {
  3.795117238212161*^9, 3.795117269107945*^9}, {3.795117327206044*^9, 
  3.795117366536212*^9}, {3.79511788508676*^9, 
  3.795117911641642*^9}},ExpressionUUID->"ed0c20fb-debf-4609-804d-\
638c90893810"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"we", " ", "will", " ", "conside", " ", "kz"}], "=", 
   RowBox[{"0", " ", "case"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.79511642626335*^9, 
  3.7951164364419107`*^9}},ExpressionUUID->"65d5fefe-e95b-4fc9-9064-\
8715e5ba10ce"]
},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"69c84e55-2ac7-4d8f-a73a-2d91a6000b1a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3777, 101, 150, "Input",ExpressionUUID->"b9709eda-1830-44c1-a55e-f8b3d4795753"],
Cell[4360, 125, 2290, 73, 103, "Output",ExpressionUUID->"a9237c6a-1df7-4060-b255-b987ea028313"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6687, 203, 1148, 31, 120, "Input",ExpressionUUID->"b1ea21a3-d501-4b2b-8907-e9f0d43e20e9"],
Cell[7838, 236, 1182, 38, 49, "Output",ExpressionUUID->"0d1469ff-e096-492b-930b-a8c9ac6fa675"]
}, Open  ]],
Cell[9035, 277, 576, 12, 36, "Input",ExpressionUUID->"ed0c20fb-debf-4609-804d-638c90893810"],
Cell[9614, 291, 293, 7, 30, "Input",ExpressionUUID->"65d5fefe-e95b-4fc9-9064-8715e5ba10ce"]
}
]
*)

