(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    419018,       9188]
NotebookOptionsPosition[    413882,       9103]
NotebookOutlinePosition[    414203,       9117]
CellTagsIndexPosition[    414160,       9114]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Normal metal: eqn. 10 of https://arxiv.org/abs/cond-mat/0604323\
\>", "Section",
 CellChangeTimes->{{3.795493240378099*^9, 
  3.795493274070298*^9}},ExpressionUUID->"b8b2dba5-6f71-414d-808e-\
803fd7ac87bd"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "\[Psi]", " ", "and", " ", "its", " ", "derivative", " ", "continuous"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.795495268299068*^9, 
  3.79549530113418*^9}},ExpressionUUID->"598db16e-f0e8-4cba-bfc4-\
b64182a1ef8b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "sol", ",", "eq1", ",", "eq2", ",", "eq3", ",", "eq4", ",", "rp", ",", 
    "tp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"r", 
        RowBox[{"(", "1", ")"}], " "}]}], 
      SqrtBox["v"]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", "1", ")"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", "1", ")"}]}]}], 
      SqrtBox["vs"]]}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", "1", ")"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", "1", ")"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
      SqrtBox["vs"]], "-", 
     FractionBox[
      RowBox[{"t", 
       RowBox[{"(", "1", ")"}], " "}], 
      SqrtBox["v"]]}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"kx", "+", 
       RowBox[{"r", 
        RowBox[{"(", 
         RowBox[{"-", "kx"}], ")"}], " "}]}], 
      SqrtBox["v"]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", "kt", ")"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{"-", "kt"}], ")"}]}]}], 
      SqrtBox["vs"]]}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq4", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", "kt", ")"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{"-", "kt"}], ")"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
      SqrtBox["vs"]], "-", 
     FractionBox[
      RowBox[{"t", 
       RowBox[{"(", "kx", ")"}], " "}], 
      SqrtBox["v"]]}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"eq1", "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{"eq2", "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{"eq3", "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{"eq4", "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "t", ",", "a", ",", "b"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rp", "=", 
  RowBox[{
   RowBox[{"r", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"tp", "=", 
  RowBox[{
   RowBox[{"t", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.795494599513937*^9, 3.795494650787484*^9}, {
  3.795495064647753*^9, 3.795495065353921*^9}, {3.795495119974518*^9, 
  3.795495158864544*^9}, {3.795495308787545*^9, 3.795495398582904*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"91681390-7143-4bf8-9f2d-43953ae36692"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["kt", "2"]}], "+", 
     SuperscriptBox["kx", "2"]}], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"kt", " ", "L"}], "]"}]}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kt", "2"], "+", 
      SuperscriptBox["kx", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.7954946809440203`*^9, 3.795495066018907*^9, {3.795495134129424*^9, 
   3.795495159364559*^9}, {3.795495366324934*^9, 3.795495400922817*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"13001827-f847-4b17-bd5d-80d761135bc1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx"}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kt", "2"], "+", 
      SuperscriptBox["kx", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.7954946809440203`*^9, 3.795495066018907*^9, {3.795495134129424*^9, 
   3.795495159364559*^9}, {3.795495366324934*^9, 3.795495400950077*^9}},
 CellLabel->"Out[8]=",ExpressionUUID->"66ff0b62-01b3-471f-aa1e-a61642e7dca9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx"}], 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kt", "2"], "+", 
        SuperscriptBox["kx", "2"]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}]}]], "==", 
   FractionBox[
    RowBox[{"4", " ", "kt", " ", "kx", " "}], 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kt", "+", "kx"}], ")"}], "2"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kt", "-", "kx"}], ")"}], "2"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " "}]}]]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.795495427472686*^9, 3.7954954413984423`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"48609805-ebbe-4843-941e-db81d35388a3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.795495441784539*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"2ad7e03f-4dff-46c9-8fa9-ee2e25da8ca3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"en", "=", 
    RowBox[{"V", "/", "2"}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "L", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", "kt", " ", "kx", " "}], 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"kt", "+", "kx"}], ")"}], "2"], 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], "-", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"kt", "-", "kx"}], ")"}], "2"], 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " "}]}]], "/.", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"kx", "\[Rule]", 
            RowBox[{
             SqrtBox["en"], 
             RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
           RowBox[{"ky", "\[Rule]", 
            RowBox[{
             SqrtBox["en"], 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
           RowBox[{"kt", "\[Rule]", 
            RowBox[{"\[ImaginaryI]", 
             SqrtBox[
              RowBox[{"V", "-", "en", "-", 
               RowBox[{"en", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}]}],
           "}"}]}], "//", "Simplify"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"en", "\[Rule]", 
        RowBox[{"V", "/", "2"}]}], "}"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"V", ",", "\[Phi]", ",", "m", ",", "en", ",", "hbar"}], 
         "}"}], " ", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
       RowBox[{"V", ">", "0"}], " ", "&&", " ", 
       RowBox[{"m", ">", "0"}]}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"V", "-", 
      RowBox[{"en", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}], ")"}]}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"V", ",", "en", ",", "\[Phi]"}], "}"}], " ", "\[Element]", 
        " ", "Reals"}], " ", "&&", " ", 
       RowBox[{"V", ">", "0"}], "  ", "&&", " ", 
       RowBox[{"en", "<", "V"}], " ", "&&", " ", 
       RowBox[{"m", ">", "0"}]}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"V", "-", 
     RowBox[{"V", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}], ")"}], "/", "2"}]}]}], 
    "//", "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.7954969979887953`*^9, 3.7954970814409113`*^9}, {
   3.795497215454172*^9, 3.7954972166021*^9}, {3.795497254754887*^9, 
   3.79549726342852*^9}, {3.795497330743946*^9, 3.7954974004315033`*^9}, {
   3.795497440365288*^9, 3.7954974554732113`*^9}, {3.795498812624486*^9, 
   3.795498837205146*^9}, {3.795498873783086*^9, 3.795498886839905*^9}, 
   3.7954990790006447`*^9, {3.7954991275801487`*^9, 3.79549919822464*^9}, {
   3.7955005974548187`*^9, 3.7955006035367126`*^9}, {3.795500646322793*^9, 
   3.7955006640154457`*^9}, {3.795500730852562*^9, 3.795500743657049*^9}, {
   3.795500783781486*^9, 3.795500806205771*^9}, {3.7955008885738688`*^9, 
   3.7955008954298487`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"6b8f143d-9ba1-43a3-b9c7-88f5a81e1708"],

Cell[BoxData[
 RowBox[{"Sech", "[", 
  FractionBox[
   RowBox[{"L", " ", 
    SqrtBox["V"], " ", 
    RowBox[{"Cos", "[", "\[Phi]", "]"}]}], 
   SqrtBox["2"]], "]"}]], "Output",
 CellChangeTimes->{
  3.795496984112329*^9, {3.795497025553198*^9, 3.7954970370028257`*^9}, 
   3.795497083307173*^9, 3.7954972197951*^9, {3.795497344137684*^9, 
   3.795497402470479*^9}, {3.795497450453858*^9, 3.795497457915188*^9}, {
   3.795498823864699*^9, 3.7954988391217527`*^9}, 3.7954988890397663`*^9, 
   3.795499200488062*^9, 3.795500610509441*^9, 3.795500667288876*^9, 
   3.795500747077694*^9, 3.795500809595245*^9, 3.795500898687336*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"d075e0c4-638f-4d43-80db-71c084a2ebfe"],

Cell[BoxData[
 RowBox[{"V", "-", 
  RowBox[{"en", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.795496984112329*^9, {3.795497025553198*^9, 3.7954970370028257`*^9}, 
   3.795497083307173*^9, 3.7954972197951*^9, {3.795497344137684*^9, 
   3.795497402470479*^9}, {3.795497450453858*^9, 3.795497457915188*^9}, {
   3.795498823864699*^9, 3.7954988391217527`*^9}, 3.7954988890397663`*^9, 
   3.795499200488062*^9, 3.795500610509441*^9, 3.795500667288876*^9, 
   3.795500747077694*^9, 3.795500809595245*^9, 3.795500898708762*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"2727f8db-063f-4e9c-99a9-c3bfcd355b64"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "V", " ", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "\[Phi]", "]"}], "2"]}]], "Output",
 CellChangeTimes->{
  3.795496984112329*^9, {3.795497025553198*^9, 3.7954970370028257`*^9}, 
   3.795497083307173*^9, 3.7954972197951*^9, {3.795497344137684*^9, 
   3.795497402470479*^9}, {3.795497450453858*^9, 3.795497457915188*^9}, {
   3.795498823864699*^9, 3.7954988391217527`*^9}, 3.7954988890397663`*^9, 
   3.795499200488062*^9, 3.795500610509441*^9, 3.795500667288876*^9, 
   3.795500747077694*^9, 3.795500809595245*^9, 3.795500898713262*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"9a77748f-2e1f-41c8-8d22-eefffc0e0c7c"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"32b6299f-8588-4d96-99e0-a2e9e464d864"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"V", " ", ">", " ", 
     RowBox[{"en", " ", "case"}]}], ";", " ", 
    FractionBox[
     RowBox[{"4", " ", "kt", " ", "kx", " "}], 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kt", "+", "kx"}], ")"}], "2"], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kt", "-", "kx"}], ")"}], "2"], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " "}]}]]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"tamp", ",", "tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tamp", "[", 
    RowBox[{"\[Phi]_", ",", "en_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"4", " ", "kt", " ", "kx", " "}], 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kt", "+", "kx"}], ")"}], "2"], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kt", "-", "kx"}], ")"}], "2"], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " "}]}]], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"L", "\[Rule]", "1"}], ",", 
        RowBox[{"kx", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"ky", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"kt", "\[Rule]", 
         RowBox[{"\[ImaginaryI]", 
          SqrtBox[
           RowBox[{"V", "-", "en", "+", 
            RowBox[{"en", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}]}], 
       "}"}]}], ")"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VL", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.3", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.5", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.8", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"1", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "0.95"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.8"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<normalTimage12.jpg\>\"", ",", "g1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"enL", ",", "g", ",", "VL"}], "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VL", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.3", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.5", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.8", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"1", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.03"}], ",", "0.33"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.35"}], ",", "0.35"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.3"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<normalTimage13.jpg\>\"", ",", "g1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"enL", ",", "g", ",", "VL"}], "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VL", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.3", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.5", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"0.8", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "enL", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"enL", "=", 
   RowBox[{"1", "*", "VL"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "enL", ",", "VL"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 0.1 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<normalTimage11.jpg\>\"", ",", "g1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"enL", ",", "g", ",", "VL"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.795430800710774*^9, 3.795430822601384*^9}, 
   3.7954319645938463`*^9, {3.795432057162355*^9, 3.795432106092453*^9}, {
   3.795432203645256*^9, 3.795432362713727*^9}, {3.795432440392194*^9, 
   3.795432457103022*^9}, {3.795432495702147*^9, 3.7954325343192787`*^9}, {
   3.79543290746458*^9, 3.795432913225194*^9}, {3.7954932287991247`*^9, 
   3.7954932292033978`*^9}, {3.79549331634379*^9, 3.795493445839096*^9}, {
   3.795493506111568*^9, 3.795493565149144*^9}, {3.795493599771323*^9, 
   3.7954936226530933`*^9}, {3.795493661893777*^9, 3.7954936630873337`*^9}, {
   3.795493740558333*^9, 3.7954937718266687`*^9}, {3.795494062546967*^9, 
   3.795494290668097*^9}, 3.79549569885426*^9, {3.7955008535263166`*^9, 
   3.795500864498458*^9}, 3.795500933267984*^9, {3.795501060208802*^9, 
   3.795501091463449*^9}, {3.795501277508391*^9, 3.795501278090493*^9}, {
   3.795501463070692*^9, 3.795501543179648*^9}, {3.7955015837274523`*^9, 
   3.79550187406859*^9}, {3.7955019129721403`*^9, 3.795501960803802*^9}, {
   3.79562753232176*^9, 3.795627534488501*^9}, {3.7956276124817047`*^9, 
   3.795627709738368*^9}, {3.795627760608523*^9, 3.795627788258016*^9}, {
   3.795627957218738*^9, 3.795627959875511*^9}},
 CellLabel->
  "In[433]:=",ExpressionUUID->"cfa3fb63-aeb4-4bf7-96c8-cf5d1b811223"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.7999998650571132}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.3999999325285566, -0.6928202061635829}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.6928202061635829, -0.3999999325285566}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.7999998650571132, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.6928202061635829, 0.3999999325285566}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.3999999325285566, 0.6928202061635829}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.7999998650571132}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.15999997301142266, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.3199999460228453, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.479999919034268, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.6399998920456906, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkWGVYVV2wlg9UQFBQQpSQUGxEBSkZGilBGlGRlBAQAWlJCZGUlO6Q7l50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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.7999998650571132}], 
         Scaled[{0., -0.006}, {0., -0.7999998650571132}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.3999999325285566, -0.6928202061635829}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.3999999325285566, -0.6928202061635829}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.6928202061635829, -0.3999999325285566}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.6928202061635829, -0.3999999325285566}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.7999998650571132, 0.}], 
         Scaled[{0.006, 0.}, {0.7999998650571132, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.6928202061635829, 0.3999999325285566}], 
         Scaled[{0.005196152422706632, 0.003}, {0.6928202061635829, 
          0.3999999325285566}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.3999999325285566, 0.6928202061635829}], 
         Scaled[{0.003, 0.005196152422706632}, {0.3999999325285566, 
          0.6928202061635829}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.7999998650571132}], 
         Scaled[{0., 0.006}, {0., 0.7999998650571132}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.7999998650571132}], {0, 1},
       
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.3999999325285566, -0.6928202061635829}], 
        Offset[{4, -6.928203230275509}, {
         0.3999999325285566, -0.6928202061635829}]], 
       NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 
        0.8660254037844386}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.6928202061635829, -0.3999999325285566}], 
        Offset[{6.928203230275509, -4}, {
         0.6928202061635829, -0.3999999325285566}]], 
       NCache[{Rational[-1, 2] 3^Rational[1, 2], Rational[
         1, 2]}, {-0.8660254037844386, 0.5}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.7999998650571132, 0.}], {-1, 0},
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.6928202061635829, 
         0.3999999325285566}], 
        Offset[{6.928203230275509, 4}, {0.6928202061635829, 
         0.3999999325285566}]], 
       NCache[{Rational[-1, 2] 3^Rational[1, 2], 
         Rational[-1, 2]}, {-0.8660254037844386, -0.5}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.3999999325285566, 
         0.6928202061635829}], 
        Offset[{4, 6.928203230275509}, {0.3999999325285566, 
         0.6928202061635829}]], 
       NCache[{Rational[-1, 2], Rational[-1, 2] 
         3^Rational[1, 2]}, {-0.5, -0.8660254037844386}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.7999998650571132}], {0, -1},
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.7999998650571132, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 0.95}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795493464662138*^9, {3.795493507868479*^9, 3.7954935668331747`*^9}, {
   3.795493601701117*^9, 3.795493624712894*^9}, 3.795493664752317*^9, {
   3.795493743934907*^9, 3.79549377333425*^9}, 3.7954940644942493`*^9, 
   3.79549409862062*^9, {3.795494145560314*^9, 3.79549425912331*^9}, 
   3.7954942924929113`*^9, 3.795500956164681*^9, 3.795501092446679*^9, 
   3.795501391814272*^9, {3.795501528822583*^9, 3.795501544262586*^9}, {
   3.79550159200723*^9, 3.795501618142964*^9}, 3.795501652894493*^9, {
   3.795501688941633*^9, 3.7955017848278418`*^9}, {3.795501824822403*^9, 
   3.795501875297021*^9}, {3.79550194921216*^9, 3.7955019615594*^9}, 
   3.795627538124237*^9, {3.7956276202683353`*^9, 3.7956277109301443`*^9}, {
   3.795627762166752*^9, 3.795627789435711*^9}, 3.795627961429845*^9},
 CellLabel->
  "Out[448]=",ExpressionUUID->"0b9b623f-0083-40ed-ae62-ee0cc0b672cf"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.2857137263214961}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.14285686316074805`, -0.24743534520433025`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.24743534520433025`, -0.14285686316074805`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.2857137263214961, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.24743534520433025`, 0.14285686316074805`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.14285686316074805`, 0.24743534520433025`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.2857137263214961}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.05714274526429922, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.11428549052859845, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.17142823579289768, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.2285709810571969, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkmHc411/Yx1EokVW2UETIzsz3RmTvnb339rX3/tp77x1ZoYw4SJFS2ZGt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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.2857137263214961}], 
         Scaled[{0., -0.006}, {0., -0.2857137263214961}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.14285686316074805`, -0.24743534520433025`}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.14285686316074805`, -0.24743534520433025`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.24743534520433025`, -0.14285686316074805`}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.24743534520433025`, -0.14285686316074805`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.2857137263214961, 0.}], 
         Scaled[{0.006, 0.}, {0.2857137263214961, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.24743534520433025`, 0.14285686316074805`}], 
         Scaled[{0.005196152422706632, 0.003}, {0.24743534520433025`, 
          0.14285686316074805`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.14285686316074805`, 0.24743534520433025`}], 
         Scaled[{0.003, 0.005196152422706632}, {0.14285686316074805`, 
          0.24743534520433025`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.2857137263214961}], 
         Scaled[{0., 0.006}, {0., 0.2857137263214961}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.2857137263214961}], {0, 1},
       
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.14285686316074805`, -0.24743534520433025`}], 
        Offset[{4, -6.928203230275509}, {
         0.14285686316074805`, -0.24743534520433025`}]], 
       NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 
        0.8660254037844386}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.24743534520433025`, -0.14285686316074805`}], 
        Offset[{6.928203230275509, -4}, {
         0.24743534520433025`, -0.14285686316074805`}]], 
       NCache[{Rational[-1, 2] 3^Rational[1, 2], Rational[
         1, 2]}, {-0.8660254037844386, 0.5}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.2857137263214961, 0.}], {-1, 0},
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.24743534520433025`, 
         0.14285686316074805`}], 
        Offset[{6.928203230275509, 4}, {0.24743534520433025`, 
         0.14285686316074805`}]], 
       NCache[{Rational[-1, 2] 3^Rational[1, 2], 
         Rational[-1, 2]}, {-0.8660254037844386, -0.5}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.14285686316074805`, 
         0.24743534520433025`}], 
        Offset[{4, 6.928203230275509}, {0.14285686316074805`, 
         0.24743534520433025`}]], 
       NCache[{Rational[-1, 2], Rational[-1, 2] 
         3^Rational[1, 2]}, {-0.5, -0.8660254037844386}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.2857137263214961}], {0, -1},
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.2857137263214961, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.3, 
       FormBox["0.3`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.03, 0.33}, {-0.35, 0.35}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795493464662138*^9, {3.795493507868479*^9, 3.7954935668331747`*^9}, {
   3.795493601701117*^9, 3.795493624712894*^9}, 3.795493664752317*^9, {
   3.795493743934907*^9, 3.79549377333425*^9}, 3.7954940644942493`*^9, 
   3.79549409862062*^9, {3.795494145560314*^9, 3.79549425912331*^9}, 
   3.7954942924929113`*^9, 3.795500956164681*^9, 3.795501092446679*^9, 
   3.795501391814272*^9, {3.795501528822583*^9, 3.795501544262586*^9}, {
   3.79550159200723*^9, 3.795501618142964*^9}, 3.795501652894493*^9, {
   3.795501688941633*^9, 3.7955017848278418`*^9}, {3.795501824822403*^9, 
   3.795501875297021*^9}, {3.79550194921216*^9, 3.7955019615594*^9}, 
   3.795627538124237*^9, {3.7956276202683353`*^9, 3.7956277109301443`*^9}, {
   3.795627762166752*^9, 3.795627789435711*^9}, 3.795627961662487*^9},
 CellLabel->
  "Out[463]=",ExpressionUUID->"b8897e14-8299-481c-868c-c92f668a0525"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9756097405441904}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4878048702720952, -0.8449028194908138}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8449028194908138, -0.4878048702720952}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9756097405441904, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8449028194908138, 0.4878048702720952}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4878048702720952, 0.8449028194908138}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9756097405441904}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.1951219481088381, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.3902438962176762, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5853658443265143, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7804877924353524, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkmGk4ld/3/yUUFZIpoQyFCkkhyVKGEEopKlEpM6k04dNARKYiypCxzFHI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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9756097405441904}], 
         Scaled[{0., -0.006}, {0., -0.9756097405441904}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4878048702720952, -0.8449028194908138}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.4878048702720952, -0.8449028194908138}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8449028194908138, -0.4878048702720952}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.8449028194908138, -0.4878048702720952}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9756097405441904, 0.}], 
         Scaled[{0.006, 0.}, {0.9756097405441904, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8449028194908138, 0.4878048702720952}], 
         Scaled[{0.005196152422706632, 0.003}, {0.8449028194908138, 
          0.4878048702720952}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4878048702720952, 0.8449028194908138}], 
         Scaled[{0.003, 0.005196152422706632}, {0.4878048702720952, 
          0.8449028194908138}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9756097405441904}], 
         Scaled[{0., 0.006}, {0., 0.9756097405441904}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9756097405441904}], {0, 1},
       
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.4878048702720952, -0.8449028194908138}], 
        Offset[{4, -6.928203230275509}, {
         0.4878048702720952, -0.8449028194908138}]], 
       NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 
        0.8660254037844386}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.8449028194908138, -0.4878048702720952}], 
        Offset[{6.928203230275509, -4}, {
         0.8449028194908138, -0.4878048702720952}]], 
       NCache[{Rational[-1, 2] 3^Rational[1, 2], Rational[
         1, 2]}, {-0.8660254037844386, 0.5}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9756097405441904, 0.}], {-1, 0},
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.8449028194908138, 
         0.4878048702720952}], 
        Offset[{6.928203230275509, 4}, {0.8449028194908138, 
         0.4878048702720952}]], 
       NCache[{Rational[-1, 2] 3^Rational[1, 2], 
         Rational[-1, 2]}, {-0.8660254037844386, -0.5}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.4878048702720952, 
         0.8449028194908138}], 
        Offset[{4, 6.928203230275509}, {0.4878048702720952, 
         0.8449028194908138}]], 
       NCache[{Rational[-1, 2], Rational[-1, 2] 
         3^Rational[1, 2]}, {-0.5, -0.8660254037844386}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9756097405441904}], {0, -1},
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9756097405441904, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 0.1 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795493464662138*^9, {3.795493507868479*^9, 3.7954935668331747`*^9}, {
   3.795493601701117*^9, 3.795493624712894*^9}, 3.795493664752317*^9, {
   3.795493743934907*^9, 3.79549377333425*^9}, 3.7954940644942493`*^9, 
   3.79549409862062*^9, {3.795494145560314*^9, 3.79549425912331*^9}, 
   3.7954942924929113`*^9, 3.795500956164681*^9, 3.795501092446679*^9, 
   3.795501391814272*^9, {3.795501528822583*^9, 3.795501544262586*^9}, {
   3.79550159200723*^9, 3.795501618142964*^9}, 3.795501652894493*^9, {
   3.795501688941633*^9, 3.7955017848278418`*^9}, {3.795501824822403*^9, 
   3.795501875297021*^9}, {3.79550194921216*^9, 3.7955019615594*^9}, 
   3.795627538124237*^9, {3.7956276202683353`*^9, 3.7956277109301443`*^9}, {
   3.795627762166752*^9, 3.795627789435711*^9}, 3.79562796218575*^9},
 CellLabel->
  "Out[478]=",ExpressionUUID->"a3263752-bdb5-4d9e-a860-ffddcb50deb0"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"0aab99be-e023-4389-8fec-079b8ba3245c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", "kt", " ", "kx", " "}], 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kt", "+", "kx"}], ")"}], "2"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kt", "-", "kx"}], ")"}], "2"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " "}]}]], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kx", " ", "\[Rule]", 
      RowBox[{
       SqrtBox[
        RowBox[{" ", "en"}]], " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", " ", 
     RowBox[{"ky", "\[Rule]", " ", 
      RowBox[{
       SqrtBox["en"], " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
     RowBox[{"kt", "\[Rule]", 
      RowBox[{"\[ImaginaryI]", 
       SqrtBox[
        RowBox[{"V", "-", "en", "+", 
         RowBox[{"en", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}], ")"}], "2"]}]}]]}]}]}], 
    "}"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"899efe71-4691-479a-a8d3-9143fcf5f55d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    SqrtBox["en"], " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "en"}], "+", "V", "+", 
      RowBox[{"en", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"L", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "en"}], "+", "V", "+", 
         RowBox[{"en", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["en"], " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "en"}], "+", "V", "+", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
      "2"]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "L"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "en"}], "+", "V", "+", 
         RowBox[{"en", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["en"], " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "en"}], "+", "V", "+", 
          RowBox[{"en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], 
      "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.795502380293339*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"33b9bcc2-0265-468c-a1ae-8a6e478b4155"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "  ", 
        SqrtBox["en"], " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "en"}], "+", "V", "+", 
          RowBox[{"en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"L", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "en"}], "+", "V", "+", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["en"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", "en"}], "+", "V", "+", 
               RowBox[{"en", " ", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
          "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "L"}], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "en"}], "+", "V", "+", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["en"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", "en"}], "+", "V", "+", 
              RowBox[{"en", " ", 
               SuperscriptBox[
                RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], 
          "2"]}]}], ")"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "  ", 
        SqrtBox["en"], " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "en"}], "+", "V", "+", 
          RowBox[{"en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"L", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "en"}], "+", "V", "+", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["en"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", "en"}], "+", "V", "+", 
               RowBox[{"en", " ", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
          "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "L"}], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "en"}], "+", "V", "+", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", 
             SqrtBox["en"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", "en"}], "+", "V", "+", 
              RowBox[{"en", " ", 
               SuperscriptBox[
                RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], 
          "2"]}]}], ")"}]}], ")"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"L", "\[Rule]", "1"}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.795502399392417*^9, 3.795502435573657*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"adf76fab-6829-408a-b80a-6ec54856b023"],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", "en", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"en", "-", 
     RowBox[{"2", " ", "V"}], "+", 
     RowBox[{"en", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}], ")"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"en", "-", "V"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "en"}], "-", "V", "+", 
      RowBox[{"4", " ", "en", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["en", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "\[Theta]"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["V", "2"], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "en"}], "+", 
        RowBox[{"2", " ", "V"}], "-", 
        RowBox[{"en", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}]]}], "]"}]}]}]]], "Output",\

 CellChangeTimes->{{3.795502419783387*^9, 3.795502436910969*^9}},
 CellLabel->"Out[3]=",ExpressionUUID->"c3775970-6158-4cbc-bc5d-089cf9aa6ba3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ttdag", ",", "t", ",", "fn", ",", "dat11", ",", "space"}], "]"}], 
  ";", 
  RowBox[{"L", "=", "1"}], ";", 
  RowBox[{"space", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t", "[", 
    RowBox[{"en_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
   FractionBox[
    RowBox[{"4", " ", "en", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"en", "-", 
       RowBox[{"2", " ", "V"}], "+", 
       RowBox[{"en", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}], ")"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"en", "-", "V"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "en"}], "-", "V", "+", 
        RowBox[{"4", " ", "en", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["en", "2"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"4", " ", "\[Theta]"}], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["V", "2"], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "en"}], "+", 
          RowBox[{"2", " ", "V"}], "-", 
          RowBox[{"en", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}]]}], "]"}]}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"fn", ",", "int", ",", "dat"}], "]"}], ";", 
  RowBox[{
   RowBox[{"int", "[", 
    RowBox[{"rat_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"rat", " ", 
      RowBox[{"V", "/", 
       SuperscriptBox["L", "2"]}]}], ",", 
     RowBox[{"V", "/", 
      SuperscriptBox["L", "2"]}], ",", "\[Theta]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fn", "[", 
   RowBox[{"rat_", ",", "V_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t1", ",", "t2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t1", "=", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"int", "[", 
          RowBox[{"rat", ",", "V", ",", "\[Theta]"}], "]"}], " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
        RowBox[{"PrecisionGoal", "\[Rule]", "10"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]}], ";", 
     RowBox[{"t2", "=", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"int", "[", 
          RowBox[{"rat", ",", "V", ",", "\[Theta]"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"int", "[", 
            RowBox[{"rat", ",", "V", ",", "\[Theta]"}], "]"}]}], ")"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
        RowBox[{"PrecisionGoal", "\[Rule]", "10"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SqrtBox[
         RowBox[{"rat", " ", "V"}]], "t1"}], ",", 
       RowBox[{"t2", "/", "t1"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat11", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "5"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "0.01", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat21", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "25"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "0.01", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat31", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "50"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "0.01", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dat11", ",", "dat21", ",", "dat31"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", 
   RowBox[{"Length", "[", "dat11", "]"}]}], ";", 
  RowBox[{"dat11", "[", 
   RowBox[{"[", "ele", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"dat21", "[", 
  RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat31", "[", 
   RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "**", "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<************\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data11", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "5"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "0.01", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data21", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "25"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "0.01", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data31", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "50"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "0.01", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "L", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.795119119854344*^9, 3.795119123596528*^9}, {
   3.7951191721161423`*^9, 3.795119265781043*^9}, {3.79511932471906*^9, 
   3.795119353568372*^9}, {3.795119389258197*^9, 3.795119491306999*^9}, {
   3.795119531801958*^9, 3.795119758298603*^9}, {3.795119854246603*^9, 
   3.795119906475195*^9}, {3.795119986495932*^9, 3.795120021574985*^9}, {
   3.795120061146966*^9, 3.795120061740101*^9}, {3.795120455763092*^9, 
   3.79512073068731*^9}, {3.795120778697257*^9, 3.795120782596369*^9}, {
   3.795120962101157*^9, 3.795121028557564*^9}, {3.795121219566338*^9, 
   3.7951212231221*^9}, {3.795121261692348*^9, 3.7951212857968283`*^9}, 
   3.795121374319318*^9, {3.795121430549168*^9, 3.79512144776952*^9}, {
   3.7951214953293037`*^9, 3.795121525078743*^9}, {3.795121665516431*^9, 
   3.7951217020190372`*^9}, {3.795121766934218*^9, 3.7951217678928947`*^9}, {
   3.7951217980836983`*^9, 3.795121824213675*^9}, {3.7951222111320257`*^9, 
   3.795122262134712*^9}, {3.795122312783399*^9, 3.795122331591797*^9}, {
   3.795122366322688*^9, 3.795122404983653*^9}, {3.795122458363439*^9, 
   3.795122506527163*^9}, {3.7951225507505713`*^9, 3.795122646891032*^9}, {
   3.7951228184612207`*^9, 3.795122846278874*^9}, {3.795122892637504*^9, 
   3.795122898402958*^9}, {3.7951233015045958`*^9, 3.795123331178849*^9}, {
   3.7951261687022943`*^9, 3.7951261944735527`*^9}, {3.7951262495350533`*^9, 
   3.7951262561717*^9}, {3.795126594717926*^9, 3.795126622848489*^9}, {
   3.795127067416565*^9, 3.7951270715262117`*^9}, {3.795127154434876*^9, 
   3.795127184765744*^9}, 3.7951329293264093`*^9, {3.795329018723386*^9, 
   3.7953290410731983`*^9}, {3.7953297106310472`*^9, 3.795329715730199*^9}, {
   3.795330858635632*^9, 3.7953308671004553`*^9}, {3.795331674887415*^9, 
   3.795331712104721*^9}, {3.795331805574004*^9, 3.795331823862542*^9}, {
   3.795332008288456*^9, 3.7953320419261417`*^9}, 3.795332107853075*^9, {
   3.795332613606153*^9, 3.795332653477936*^9}, {3.7953329083713083`*^9, 
   3.795332915414948*^9}, {3.795338145252019*^9, 3.7953381494572897`*^9}, {
   3.795338237163353*^9, 3.79533824190969*^9}, {3.79533941488735*^9, 
   3.795339430592025*^9}, {3.7953403002709627`*^9, 3.795340314981183*^9}, {
   3.7953409862781057`*^9, 3.795340994175733*^9}, {3.795341109824277*^9, 
   3.795341110333034*^9}, {3.795341221520659*^9, 3.79534124791958*^9}, {
   3.7953412965225487`*^9, 3.795341356868442*^9}, 3.795341488250928*^9, {
   3.7953416066287193`*^9, 3.795341611816525*^9}, 3.795495818394877*^9, 
   3.795501172308792*^9, {3.795501265782166*^9, 3.7955012663467007`*^9}, {
   3.795502045589498*^9, 3.795502047292859*^9}, {3.795502267333741*^9, 
   3.795502300769043*^9}, {3.7955024518903017`*^9, 3.795502482692301*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"a726733d-831a-47a9-a710-e1867a6e5465"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.6565140430659903`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.795502144031489*^9, 3.795502353822859*^9, 3.7955024862865458`*^9, 
   3.801036200852887*^9, {3.8010363449356947`*^9, 3.801036356816278*^9}},
 CellLabel->
  "Out[119]=",ExpressionUUID->"6cddb022-a2d7-41f4-9d04-1a629019a6c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.9032532944304491`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.795502144031489*^9, 3.795502353822859*^9, 3.7955024862865458`*^9, 
   3.801036200852887*^9, {3.8010363449356947`*^9, 3.801036356817833*^9}},
 CellLabel->
  "Out[120]=",ExpressionUUID->"46331d0c-859d-4a4b-a6cb-33e6ba8afa59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.9487429640145402`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.795502144031489*^9, 3.795502353822859*^9, 3.7955024862865458`*^9, 
   3.801036200852887*^9, {3.8010363449356947`*^9, 3.8010363568196363`*^9}},
 CellLabel->
  "Out[121]=",ExpressionUUID->"96937d04-8081-4c63-812b-7f71b2e82a3e"],

Cell[BoxData["\<\"************\"\>"], "Print",
 CellChangeTimes->{
  3.795502144043818*^9, 3.795502353838838*^9, 3.795502486292878*^9, 
   3.801036200873911*^9, {3.801036344947318*^9, 3.8010363568211937`*^9}},
 CellLabel->
  "During evaluation of \
In[111]:=",ExpressionUUID->"19fbd073-024e-437a-9d42-cfdc6504d307"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ttdag", ",", "t", ",", "space"}], "]"}], ";", 
  RowBox[{"L", "=", "1"}], ";", 
  RowBox[{"space", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t", "[", 
    RowBox[{"en_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "kt", " ", "kx", " ", 
       SuperscriptBox["ky", "2"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
        SuperscriptBox["ky", "2"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["kt", "2"], " ", 
           SuperscriptBox["kx", "2"]}], "+", 
          SuperscriptBox["ky", "4"]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"kx", " ", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{" ", "en"}]], " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", " ", 
       RowBox[{"ky", "\[Rule]", " ", 
        RowBox[{
         SqrtBox["en"], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"en", "-", "V"}], ")"}], "-", 
          RowBox[{"en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"fn", ",", "int", ",", "dat"}], "]"}], ";", 
  RowBox[{
   RowBox[{"int", "[", 
    RowBox[{"rat_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"rat", " ", 
      RowBox[{"V", "/", 
       SuperscriptBox["L", "2"]}]}], ",", 
     RowBox[{"V", "/", 
      SuperscriptBox["L", "2"]}], ",", "\[Theta]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fn", "[", 
   RowBox[{"rat_", ",", "V_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t1", ",", "t2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t1", "=", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"int", "[", 
            RowBox[{"rat", ",", "V", ",", "\[Theta]"}], "]"}], "]"}], "2"], 
         " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
        RowBox[{"PrecisionGoal", "\[Rule]", "10"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]}], ";", 
     RowBox[{"t2", "=", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"int", "[", 
            RowBox[{"rat", ",", "V", ",", "\[Theta]"}], "]"}], "]"}], "2"], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"int", "[", 
              RowBox[{"rat", ",", "V", ",", "\[Theta]"}], "]"}], "]"}], 
            "2"]}], ")"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
        RowBox[{"PrecisionGoal", "\[Rule]", "10"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SqrtBox[
         RowBox[{"rat", " ", "V"}]], "t1"}], ",", 
       RowBox[{"t2", "/", "t1"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat12", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "5"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat22", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "25"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat32", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "50"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "V", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dat13", ",", "dat23", ",", "dat33"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", "1"}], ";", 
  RowBox[{"dat12", "[", 
   RowBox[{"[", "ele", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"dat22", "[", 
  RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat32", "[", 
   RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data12", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "5"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data22", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "25"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data32", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{
        RowBox[{"fn", "[", 
         RowBox[{"rat", ",", "50"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"L", ",", "space"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.795119119854344*^9, 3.795119123596528*^9}, {
   3.7951191721161423`*^9, 3.795119265781043*^9}, {3.79511932471906*^9, 
   3.795119353568372*^9}, {3.795119389258197*^9, 3.795119491306999*^9}, {
   3.795119531801958*^9, 3.795119758298603*^9}, {3.795119854246603*^9, 
   3.795119906475195*^9}, {3.795119986495932*^9, 3.795120021574985*^9}, {
   3.795120061146966*^9, 3.795120061740101*^9}, {3.795120455763092*^9, 
   3.79512073068731*^9}, {3.795120778697257*^9, 3.795120782596369*^9}, {
   3.795120962101157*^9, 3.795121028557564*^9}, {3.795121219566338*^9, 
   3.7951212231221*^9}, {3.795121261692348*^9, 3.7951212857968283`*^9}, 
   3.795121374319318*^9, {3.795121430549168*^9, 3.79512144776952*^9}, {
   3.7951214953293037`*^9, 3.795121525078743*^9}, {3.795121665516431*^9, 
   3.7951217020190372`*^9}, {3.795121766934218*^9, 3.7951217678928947`*^9}, {
   3.7951217980836983`*^9, 3.795121824213675*^9}, {3.7951222111320257`*^9, 
   3.795122262134712*^9}, {3.795122312783399*^9, 3.795122331591797*^9}, {
   3.795122366322688*^9, 3.795122404983653*^9}, {3.795122458363439*^9, 
   3.795122506527163*^9}, {3.7951225507505713`*^9, 3.795122646891032*^9}, {
   3.7951228184612207`*^9, 3.795122846278874*^9}, {3.795122892637504*^9, 
   3.795122898402958*^9}, {3.7951233015045958`*^9, 3.795123331178849*^9}, {
   3.7951261687022943`*^9, 3.7951261944735527`*^9}, {3.7951262495350533`*^9, 
   3.7951262561717*^9}, {3.795126594717926*^9, 3.795126622848489*^9}, {
   3.795127067416565*^9, 3.7951270715262117`*^9}, {3.795127154434876*^9, 
   3.795127184765744*^9}, {3.79512735817684*^9, 3.795127364881034*^9}, {
   3.795129063597739*^9, 3.795129079590725*^9}, {3.795129260349701*^9, 
   3.795129273833009*^9}, {3.79512931975395*^9, 3.7951293211831713`*^9}, {
   3.795129496522274*^9, 3.7951295009368343`*^9}, 3.795132978455655*^9, {
   3.795329725083877*^9, 3.795329729343388*^9}, {3.795330846498467*^9, 
   3.795330872507476*^9}, {3.795331850196862*^9, 3.7953319064863997`*^9}, {
   3.795331961288106*^9, 3.795331965599843*^9}, 3.795332258308421*^9, {
   3.795338323309299*^9, 3.7953383291680098`*^9}, {3.795338361142456*^9, 
   3.795338362069359*^9}, {3.79533939015594*^9, 3.795339404747386*^9}, {
   3.795340220275043*^9, 3.795340276006913*^9}, {3.795341323316277*^9, 
   3.795341323723103*^9}, {3.79534136450562*^9, 3.795341387243456*^9}, {
   3.7953414751825438`*^9, 3.795341478278921*^9}, {3.7953416162653522`*^9, 
   3.795341621065442*^9}, {3.7955023102536163`*^9, 3.795502328047451*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"6fc3ed1d-0de5-47d7-b6fd-1b6ab9fd0439"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.6565140430659596`"}], "}"}]], "Output",
 CellChangeTimes->{3.7954958928598747`*^9, 3.795502245042964*^9, 
  3.795502553258687*^9, 3.801036221566971*^9, 3.801036374123912*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"bbbc16b7-8344-445f-8335-45f1abbd976a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.90325329443047`"}], "}"}]], "Output",
 CellChangeTimes->{3.7954958928598747`*^9, 3.795502245042964*^9, 
  3.795502553258687*^9, 3.801036221566971*^9, 3.801036374135921*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"efe8efcb-43a0-4769-b406-c761f6fab873"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.9487429640145347`"}], "}"}]], "Output",
 CellChangeTimes->{3.801036389145186*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"76aa7ec8-35de-4492-a641-467f03177295"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"fp", ",", "sp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sp", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"data1", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"data11", ",", "data12"}], "]"}], "]"}]}], ",", 
      RowBox[{"data2", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"data21", ",", "data22"}], "]"}]}], ",", 
      RowBox[{"data3", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"data31", ",", "data32"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<E/\!\(\*SubscriptBox[\(V\), \(0\)]\)\>\"", ",", 
       "\"\<\[Sigma](E,\!\(\*SubscriptBox[\(V\), \(0\)]\))\>\""}], "}"}]}], 
    ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", " ", "Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Dotted", ",", "Thick"}],
         "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 5.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", 
           RowBox[{"-", "0.35"}]}], "}"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<conduct_normal.jpg\>\"", ",", "sp"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**", "**", "**", "**", "**", "**"}], 
   "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{"fp", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"dat1", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"dat11", ",", "dat12"}], "]"}], "]"}]}], ",", 
      RowBox[{"dat2", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"dat21", ",", "dat22"}], "]"}]}], ",", 
      RowBox[{"dat3", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"dat31", ",", "dat32"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<E/\!\(\*SubscriptBox[\(V\), \(0\)]\)\>\"", ",", 
       "\"\<F(E,\!\(\*SubscriptBox[\(V\), \(0\)]\))\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", " ", "Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Dotted", ",", "Thick"}],
         "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 5.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", 
           RowBox[{"-", "0.35"}]}], "}"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<fano_normal.jpg\>\"", ",", "fp"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "fp", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.795129099453619*^9, 3.795129189948071*^9}, {
   3.7951295349429703`*^9, 3.7951296402915897`*^9}, {3.795131855760603*^9, 
   3.795131919185946*^9}, {3.7951330177805634`*^9, 3.795133031078107*^9}, 
   3.795329074906158*^9, {3.795329117030916*^9, 3.795329164586104*^9}, {
   3.795329247183672*^9, 3.795329301100008*^9}, {3.795329386471616*^9, 
   3.795329495425994*^9}, {3.795329529675766*^9, 3.795329686176647*^9}, {
   3.795329949118679*^9, 3.7953299497312813`*^9}, {3.795329985317622*^9, 
   3.7953300257592993`*^9}, {3.79533005610296*^9, 3.795330076281754*^9}, {
   3.795330131819062*^9, 3.795330135592486*^9}, {3.795330184311407*^9, 
   3.795330189545801*^9}, {3.7953302330265007`*^9, 3.7953303077405167`*^9}, {
   3.795330397741708*^9, 3.795330402007928*^9}, {3.795330462641107*^9, 
   3.7953304838507*^9}, 3.795330535206356*^9, {3.795330566048111*^9, 
   3.795330579445199*^9}, {3.795330621641899*^9, 3.7953306874599257`*^9}, {
   3.7953307535225058`*^9, 3.795330814871068*^9}, {3.795330935160137*^9, 
   3.795330938614215*^9}, {3.7953310322805443`*^9, 3.795331082932808*^9}, {
   3.795331258430461*^9, 3.795331278376979*^9}, {3.795331975568935*^9, 
   3.795331984527747*^9}, {3.795339089593481*^9, 3.7953391979475937`*^9}, {
   3.795341771691587*^9, 3.795341772575748*^9}, {3.7953418877949743`*^9, 
   3.79534192631677*^9}, {3.795342002618416*^9, 3.795342003245421*^9}, {
   3.7953426297868223`*^9, 3.795342680359707*^9}, {3.79549636898326*^9, 
   3.795496376231245*^9}, {3.801036367681737*^9, 3.801036486932309*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"fe7575a3-ec47-4a5a-baee-a376266cf7b6"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJxF1gtYzPkaB/C0whGOk5B1Cz2WFHvKJZa+FTblcuh0Q0gSm+uinlbRCtW6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         "]]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJw91gk4lGsbB3BLyUcz3pR2ddKpfIUj2nQ6/m8p2jdFWg6nTfW1oF1RJ6XQ
JmQ5Tqm0yDeqaVOiUCESIlLJEtljNjMYc5j3/r7nulyux5jnue//736HUet3
Ld+kpaGhkdX91fP90IAEhwrv4yg9PXdhjqLQltuHYmmX6xj9a822iSNONCxL
vIT5M3eWlPRT0uuxENp6fROO6IOoyJ4VhxKX2MKkewyeqH8/Ab5Hfr7hmjAQ
3Zvun9xDdGCldWyQMbj3P0BWyNX8aXEm0Cu+5vGb3mMoL4qKinXGQX1c5BPk
fVvzoOvbBPx77bk0qekzmKUerV5/3RJcPSm4WeDwQCvGGrHd7y6+9gIK1/XR
cTVT0Ki+LxUNO160a/pOxyTrnpWOWbGRgwf/x5bufwlGaF+Z4DIT6VLT7hte
wajEeK9zgh301fVkoHa7zfH4KfZYrr4wEwGHa57oy+ZSv1lwWP6HxaCWBaj0
7jnwDWbULF5wx3QJ1ZsDH6GLbteyZfDsKc/jLTLCfnKdZu1I+eSCKY3z2jJ9
JTTUKw9P3S9Khm5zpn7yINIa5K33ygVzK3ouyId9SNMDk8Vrqb98uDixP/x0
XXE+raeBAqgsotzTO9ygbtf6PQ6H1Vq7nVsPdTvF7yFfemWx9syN1H8hcq+E
eT413IyRPeWMKMKQeZYJiTpbKI8i1O1irFxGboP75p71AcUTs2ebuG6nfIqx
OfGWX2bmTvScNiChGB/nOlpG3vGgvEpQ6TBbmmzoBVnPcdISGFwe6+Vzbjfl
9xFDhnpHXhm3F7bqASiF1qqLhUZf9lGepWCz/o6uu3cA6vJOfELzliELHG95
U76fsafEZtz9tMN4m9OzPmPwiskPL2ofoby/4ERo+diyR0dhpC6wDPOHGR/T
1zpG+ZdhQq/VnnUb/aA+bu1X7NjWlGpWcZw8ytEgEgTEH/CnfsrRmjnxq6v5
KfIph0E/l3fbNAOpv3Lc160PG9QWRF4VOLgkYuRX5iz1WwHzGJvmh6bnya8C
FmaTpbnrgqn/StzgWeQ5xF0gz0pMfek7823fUHDHVeLPzgYni8Aw8q2Cf1z+
OtfR4ZRPFTSDrIx9SiPIuwqHLHzX5t2Lory+IV07OCU/Ppr8v0GYbKUwz75E
+X2DYrSRzaaAGJqHaqxKEo2pTrtCeVajep6zLKv/NZqPatSMsfVv8ImlfGvw
afy8+HnaN2heahAU//CDwY2blHcNmp+6MpFb4uh5/478lfsd9yyKp/y/I+zJ
UqetzgKap+9YJw/I8Am4Qx61cNN+e8JHfJc8ajHaztXuqY2QPGrR+IVh3SPv
k0ctrPu3F10d8JA86jDtq//DJMEj8qiD7sBE98nuieRRh3V6hdPf2j0lj3ps
d3t+5Yj9M/Koh2LMQv5ZrxSaz3pMHb7qZtqmF+TRAGupfPrV26nk0YBygfkE
Lb108miA/tKarF/8X5JHIzpUsluCUa/JoxEDffK6a8wgj0ZIVjwoe5OaRR5N
yH7+piE2J5s8mjBB13bDEu1c8mhCdV2MQ/6kPPJoRnbfFHH1n/nk0Yz4DRM1
xjcUkEczPkhmTTbcXUgeP9An51y8/fAP5PEDNifHb7peV0weP+CxTTdwdtlH
8mhBbJPOsD3KT//fM/XcnuuvBS2vPXXbT9WTVws05DsUM440U78tWPg4vMAq
vIX8WrDrt6B+rjGt1H8LrksmD5x2SESeLfhcPiMgc6qY8mjF7SIrxu2rmHxb
Ie0326Zlv4TyacXaz18MTvWWkncrPA8MTDYMklJerZh/3vnvF3oy8m+FffAh
zzn+MqjLGyBCcIn/SlWXjOZBBC+to+uYfW1Qx7m5+3ULf1OPxjao4zonQtOG
Vg/5ejn9fRKhM+b11p2lcnp+RagzPMELdFRQ3mIk9X8ysjNXQfMjRoXg7tbd
i9opfzFWpUVEXXnXTvMkhu/926NZpw7yEMNI8/smo8oOmi8xzIOHn2vf3Uke
EnxRTo+s7KskDwl+Ck7pXSVQkocE0ZXhlljVRR4SzJ5+ym8/T0UeElhajTjz
+zsVeUig82D/1WFLNVjOQ4KDJz/zPFM1WM5DCsYuxjv4N02W85Dio3jZw39l
aLKchxRfQgYJ9vyhxXIeUlhvstw7xVCbVceXJkXjr+vse1dqs5yHFN5H+BHC
8l4s5yHDi12jHy+dqMNyHjJk8+ZV5CzRZTkPGX5uunnDaDif5Z5XGarW/l7r
FGjAch4yhF7sDFtjyrCchwz+4tU5j90ZlvNow8JRY5cXBzMs59EGE0V00WUB
w3IebYiYr+/X5znDch5tqEk1LozKZFjOow251WtqjXMYlvNow7FTd5+UvmFY
zkOOBpn5huxXDMt5yDG3bUWtMJlhOQ85TocUxJvdZ1jOQ46MlMKwRzcYlvOQ
I7Puv70TIxiW85AjLVT0zD+AIQ85Xn7V27ftIEMeCoyvXR5yeQtDHgq02h02
c3FmWPVxHgocGl5wM20OQx4KmPvM79KYxJCHAjZTsp5bmzDkoUBRTlLNXoYh
j3Z42ffqm6w0II92yHXchVqfDMijHSabg73LEg3Iox2x446Z7Qj/n0c7nMLD
52fsM2C5z9N2aI3fFavpbEAeHagcdafQfJoBy/3/1oGyX6YIVg81II8OTBUc
DQ1V8smjA672Zz5UV/DJowPWOiYNThl88ujAngsqYbOATx6dWCRaJBCG8cmj
ExaRq8be9OWTRyfExX5u77bwyaMTt0bMSjRfwSePTjDawvR0lk8enRh8Zu/O
CxZ88ujEijJbwyhjPnkoUW/qc7qUxycPJabt9V/mqOKRhxI5B876aIt45KFE
vPPdqrpqHnko8avD3GG9P/HIQ4mLOwqCHPN55NGFkAKf/e8zeeTRhTXh0b38
Unnk0QVJgZG9WxKPPLpw0k4xa+sjHnl0oXjzMuVfQh55dOH0jkUHZHd45KGC
/puPyfsSeOShwsbMpKqh3XvOQ4U5f81iKrr3nIcKn0Mu+Wbc5ZGHCu5pTcdy
7vPIQwV77b5nmx/zyEODtd9tPdEsmcf+AxNRDA0=
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}], LineBox[CompressedData["
1:eJw91gk4lGsbB/BJSakxFMXMUJaiviiUpJr/myRKi9LOqShJiRynRacUbd+R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         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, 
    InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 5.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], Bold, 12], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    Rational[2, 3], 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.4444444444444444, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    FractionBox["2", "3"], ",", "0", ",", "0"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[2, 3], 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    Rational[2, 3], 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 
                    Rational[2, 3], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.4444444444444444, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", 
                    FractionBox["2", "3"], ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 
                    Rational[2, 3], 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 
                    Rational[2, 3], 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 "Bold", ",", "12"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Column\"", ",", 
                 RowBox[{"{", 
                   RowBox[{"Automatic", ",", "5"}], "}"}]}], "}"}]}]}], 
         "]"}]& )], Scaled[{0.5, 0.5}], ImageScaled[{0.1, -0.35}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{False, False},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"\[Sigma](E,\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\))\"", 
       TraditionalForm], None}, {
      FormBox[
      "\"E/\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
      None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->Large,
   LabelStyle->Directive[
     GrayLevel[0], Bold, 12],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 2.}, {0, 7.196899830365019}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJxF1gtYzPkaB/C0whGOk5B1Cz2WFHvKJZa+FTblcuh0Q0gSm+uinlbRCtW6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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJw91gk4lGsbB3BLyUcz3pR2ddKpfIUj2nQ6/m8p2jdFWg6nTfW1oF1RJ6XQ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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJw91gk4lGsbB/BJSakxFMXMUJaiviiUpJr/myRKi9LOqShJiRynRacUbd+R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          "]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {False, False}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{
        "\[Sigma](E,\!\(\*SubscriptBox[\(V\), \(0\)]\))", None}, {
        "E/\!\(\*SubscriptBox[\(V\), \(0\)]\)", None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Large, LabelStyle -> Directive[
        GrayLevel[0], Bold, 12], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 2.}, {0, 7.196899830365019}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[
          Rational[2, 3], 0, 0], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 1], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 
          Rational[2, 3], 0], 
         Dashing[{0, Small}], 
         Thickness[Large]]}, {
       "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 5.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
         False, Automatic}}, Joined -> {True, True, True}, LabelStyle -> 
       Directive[
         GrayLevel[0], Bold, 12], 
       LegendLayout -> {"Column", {Automatic, 5}}]], {
      Scaled[{0.5, 0.5}], {0.1, -0.35}}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.79549638922402*^9, 3.79550257853833*^9, 3.801036240814377*^9, {
   3.801036395676819*^9, 3.8010364420427513`*^9}, 3.801036487976449*^9},
 CellLabel->
  "Out[195]=",ExpressionUUID->"dc10b254-da47-4a28-85b6-5994b6fbab8e"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJxF1gtUzGkfB/DINcSStJVy2xRlX92OXPqGFfHuW8o1ucS6X6J4o45c3hJW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         "]]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJw91gs4lPkeB3DpVLrRKWpLcbbLppvtVFI6+upsGyX2VNvlLLZ00R4PIbu1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         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}], LineBox[CompressedData["
1:eJxF1gdUk+ceBvCobRWpVAUvUhShWPdAgqPXwiPWClQEL4K2lLqD+0ArKkVt
qyKOoCA4EDyiZV3LFbFOFBURJGzCCoYdZMoKkD24X+L7pt85HM4Dyfu9/+f3
fgGbbQFenJEsFiuf+dJ9P2KW5tIcEor//nalcHi4Dx/yJaw4ZnVRl59YnXr/
nyc3sLpA4/nP7xMxbzt3tC7HXtNdt7F7lMljLZMz9K9Pw+sLT3/SZSYwP7kH
e6+/lRrD+x/gjfmI87o8VpAQ6Dj2Mb4dE2eqy/rlrmXA2cf3vJrJs/0isiWz
MvEqSS1XGfbzAsVO1j66nMi8W5CQhbCmFTeVTO7W3+8Vtno+qFEw2YGtu17j
yh/Jarnh/jmw3TxprC6/lsxi7pCLHVZFWimTjfX7yYPi0001EiZ76W/IQ+Fb
60tDhnnz4bF8xsJBJotCdAsWQNDmkCw27LcIL19nSfqY/LNue4HFGL9KZNFr
6KcECp67STeTWfqrDLnSb0o6DfOUQSmI8G5nsmuz7gZ8vE0NiHtnmI+PuUu5
15uZHJmtG6AcubtF6xqYrB+XXQHt9GfpQibrxxFUYE1H+P1qw/yV4HzR5VnO
5Gm67VhV4WGt/5FiQx9VSOEcncNj8k5/3VWNmLTd67IN/QgQV/xZ4zMm61Yz
SxMg3a3gzQNDXzVwi1wp/R+TpbrlJDVQKBx9Ew39vcXHKZz6WCY76Q+AEGnb
Ru+KNPQphG18SWMok/XbO1WLDb8GzQw29FsHVjjHag+Ti4t0Vx3c5vnd9DX0
XY8xQT2hbkyepN9gA4KdR8cvMfTfADvjnzJtmKxfzq8RwZNeJY41eDThKnun
hVhL52mCU+m4ykot9WmC+T6jsIdaOl8TfJwXCKK01KsZY0qiduzT0nmb4XL4
y5fOWurXjC0rTfZM1NL5RUi8XFlTr6GeIpifw/4EJn9YTgRuRmvQNg31bUFR
2OYZn2toPy2YG/3pjXw19W5Bxg++wgA17esdGpMOPTZWU/93MH/g3RWnov29
Q9eUdqWVip6HVtQY7XWMVtI+W/FgT2yBVEHPRyuWpkcdclHQfttw8k/2mxNy
el7acLbujihJRvtug01e57k7Uvq8tyPqo00jr0ho/+24urZa7TtEz1M73lZH
hskGqEcHdrNl7Rwx9eiAU65JaHwf9ejAIbtz6dd7qEcHZAdnhHm/px6dyJib
npLZQT060fIkVcNrpR6dGLnDZsdeEfXowsuaIJfoBurRBf6CgHnzhfR8diEv
+67VF1XU4z3OZp4a3lBKPd7j19vpd1J51OM9Tqy6rlZkUY9urBmPALMn1KMb
Eaz7KTl3qEc3khZnB+ffoh49CBfmHa+Mph49+OvkV0tPn6QePWDbP7MPCKQe
vTg4J/76CF/q0QvWcetDl0E9enG+vvp3P2vqwXxOx1Tt9VX1Eo8+HDUXs3xL
e4kHs6+VIfzG2F7i0Y9es+8dPvf7Jz8n+cN8/Yi+/W/xd81NxKsf33ruuhif
1UDm7cfJyAnuzxzqiV8/wmYJ3Zu+riPz9+NPx8Sr1dG1xLMf2ZvqE+Ita0kf
YnhMPPDwdY6Q+Iohv/7IOTBMSPoRY+XsmUqvH4XEW4xlW6afnr1CSPoSw6rt
cJoxW0j8xbA4/XRgApP12zMbwAKbz7LYzOs/nIcBRD5ax17PrKev038AysPb
vU8w99PXFTGAZxNi3e7nCsnfpwEcLx/aeMC6ljy/A+AkK9NtUmpJ34MQTFpm
P4tbR87PILaKPbLHHqwl/Q/C4lb/J6ExAnKeBnEq1jVrtGMV8RjEb32ZGwX7
Ksj5GkTKBlWdZIBPPIawZv89V3ZGGfEYwmn1fJtb/qXEYwgdFy9sPfp3MfEY
Qqv3owatWxHxGMKmmpjWUNtC4jGEqTfXT2pdUkA8hnDLyL6HdSyfeEjgU7f3
5Jk+HvGQ4McbzacFZ3jEQ4LIRVGTG7/hEQ8JdiZdmPuvKTzo68uWwCI6eMf+
cTziIUHOopmZq8x4xEMKfmSB3bb5POIhhZ3/fetOHx7xkCLBIXeWF5dHnlcp
Om3sQrYX8oiHFPF3k5Jnm+UTDymyROPb+rfnEw8ZgnZ11jhl5BMPGZq2pvKK
JhYQDxlYc2WcEwEFxEOGpa79I34uKSAeMmxZJXIqXVBIPGR4+tSULYkoJB5y
iM1Gyb8XFxIPOeLaR93kehURDzm4yd+FL7lfRDzkCHeonWphWkw85Eg/cCzz
k1+KiYccG5eXLGwtLSYeciQbv3BJnVdCPBQI9ver2HymhHgokOmU0za5pQT6
5QIV8Gb/fkD1dSnxUDB9KL9afqWUeChg3DRummVfKfFQIGe1m0pqW0Y8lFj2
eH0vd10Z8VCiUPbG5syxMuKhRO2yjYftU8uIhxJ5LzvNG9+WEQ8l7pqFBA0Y
8cnnqRL3xkdHtC7nEw8VwuIbHdwD+eT/NxXYfQ8dGlL4xEOFnuRz3FMtfOKh
gqnEShs0vZx4qHDMM2G+x75y4qFiPq/s3P2flxMPNWwVZy09LCuIhxqLOElV
H4VXEA811k7r+cHVspJ4qFG4Ntulub2SeKgx7dK8OYt51cRDjdWR/n3Pd1cR
DzVUW1nB3VcqiYcGZ0YcNK5oqSAeGnDqyo6ecK4gHhp80mz1i/tf5cRDAw9r
2xiOZTnx0MDHyPeIYzSfeGiwKjBvnGg8n3hoMTlmcVxGNPXQQrDLf+lmS+qh
hZGjmWaqZynx0GK/tVemQ2AJ8dBiYZ8799W1YuKhRdxwSOnlwiLiMYzb1dOn
RHxcRDyG8WK5hTDKpZB4DENmstOZe5E+H8PgXvxjGacln3gMo0zRVm7imE88
hmHqaup86AaPeLBWeK2bPvHsaB7+DzAIj7Y=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, 
    InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 5.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], Bold, 12], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    Rational[2, 3], 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.4444444444444444, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    FractionBox["2", "3"], ",", "0", ",", "0"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[2, 3], 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    Rational[2, 3], 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 
                    Rational[2, 3], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.4444444444444444, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", 
                    FractionBox["2", "3"], ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 
                    Rational[2, 3], 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 
                    Rational[2, 3], 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 "Bold", ",", "12"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Column\"", ",", 
                 RowBox[{"{", 
                   RowBox[{"Automatic", ",", "5"}], "}"}]}], "}"}]}]}], 
         "]"}]& )], Scaled[{0.5, 0.5}], ImageScaled[{-0.5, -0.35}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{False, False},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"F(E,\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\))\"", TraditionalForm],
       None}, {
      FormBox[
      "\"E/\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
      None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->Large,
   LabelStyle->Directive[
     GrayLevel[0], Bold, 12],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 2.}, {0, 0.9999999023748005}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJxF1gtUzGkfB/DINcSStJVy2xRlX92OXPqGFfHuW8o1ucS6X6J4o45c3hJW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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJw91gs4lPkeB3DpVLrRKWpLcbbLppvtVFI6+upsGyX2VNvlLLZ00R4PIbu1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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJxF1gdUk+ceBvCobRWpVAUvUhShWPdAgqPXwiPWClQEL4K2lLqD+0ArKkVt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          "]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {False, False}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"F(E,\!\(\*SubscriptBox[\(V\), \(0\)]\))", None}, {
        "E/\!\(\*SubscriptBox[\(V\), \(0\)]\)", None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Large, LabelStyle -> Directive[
        GrayLevel[0], Bold, 12], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 2.}, {0, 0.9999999023748005}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[
          Rational[2, 3], 0, 0], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 1], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 
          Rational[2, 3], 0], 
         Dashing[{0, Small}], 
         Thickness[Large]]}, {
       "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 5.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
         False, Automatic}}, Joined -> {True, True, True}, LabelStyle -> 
       Directive[
         GrayLevel[0], Bold, 12], 
       LegendLayout -> {"Column", {Automatic, 5}}]], {
      Scaled[{0.5, 0.5}], {-0.5, -0.35}}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.79549638922402*^9, 3.79550257853833*^9, 3.801036240814377*^9, {
   3.801036395676819*^9, 3.8010364420427513`*^9}, 3.801036488303874*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"78daa901-01e1-4b7a-b989-8986c3115668"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"f0d347ce-41d0-4410-a84a-36f0293121a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3d case", "Section",
 CellChangeTimes->{{3.795628539244643*^9, 
  3.795628540753867*^9}},ExpressionUUID->"85491848-c1e6-4e8b-80c6-\
f371850b38f4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "ttdag", ",", "t", ",", "fn", ",", "int", ",", "dat11", ",", "dat21", ",", 
    "dat31", ",", "data11", ",", "data21", ",", "data31", ",", "space"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"space", "=", "0.01"}], ";", 
   RowBox[{"ll", "=", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"V", " ", ">", " ", "en"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t", "[", 
    RowBox[{"en_", ",", "V_", ",", "\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
   
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "kt", " ", "kx"}], 
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kt", "2"], "+", 
           SuperscriptBox["kx", "2"]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"L", "\[Rule]", "1"}], ",", " ", 
        RowBox[{"kx", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"ky", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"kz", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
        RowBox[{"kt", "\[Rule]", 
         SqrtBox[
          RowBox[{"en", "-", "V", "-", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Sin", "[", "\[Theta]", "]"}], 
               RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "-", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}], 
     ")"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"fn", ",", "int"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"int", "[", 
    RowBox[{"rat_", ",", "V_", ",", "\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"rat", " ", "V"}], ",", "V", ",", "\[Theta]", ",", "\[Phi]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn", "[", 
    RowBox[{"rat_", ",", "V_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "t1", ",", "t2", ",", "exp", ",", "\[Theta]", ",", "\[Phi]", ",", 
       "expr"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"expr", "=", 
       RowBox[{"int", "[", 
        RowBox[{"rat", ",", "V", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"exp", "=", 
       RowBox[{"expr", "*", 
        RowBox[{"Conjugate", "[", "expr", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"t1", "=", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"exp", " ", 
          RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Pi]"}], "/", "2.0"}], "+", 
            SuperscriptBox["10", 
             RowBox[{"-", "6"}]]}], ",", 
           RowBox[{"\[Pi]", "/", "2.0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "5"}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}]}], ";", 
      RowBox[{"t2", "=", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"1", "-", "exp"}], ")"}], 
          RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Pi]"}], "/", "2.0"}], "+", 
            SuperscriptBox["10", 
             RowBox[{"-", "6"}]]}], ",", 
           RowBox[{"\[Pi]", "/", "2.0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "5"}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"rat", " ", "V", " ", 
         RowBox[{"Chop", "[", " ", "t1", "]"}]}], ",", 
        RowBox[{"Chop", "[", 
         RowBox[{"t2", "/", "t1"}], "]"}]}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{"fn", "[", 
        RowBox[{"rat", ",", "10"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "ll", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len", "=", 
   RowBox[{"Length", "[", "dat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat11", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data11", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", 
   RowBox[{"Length", "[", "dat11", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat11", "[", 
   RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "dat1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{"fn", "[", 
        RowBox[{"rat", ",", "25"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "ll", ",", "1", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len", "=", 
   RowBox[{"Length", "[", "dat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat21", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data21", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", 
   RowBox[{"Length", "[", "dat21", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat21", "[", 
   RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "dat1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{"fn", "[", 
        RowBox[{"rat", ",", "50"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "ll", ",", "1", " ", ",", "space"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len", "=", 
   RowBox[{"Length", "[", "dat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat31", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data31", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", 
   RowBox[{"Length", "[", "dat31", "]"}]}], ";", 
  RowBox[{"dat31", "[", 
   RowBox[{"[", "ele", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7955443945101137`*^9, 3.7955445216740828`*^9}, {
   3.79554474671462*^9, 3.795544760955606*^9}, {3.79554483552195*^9, 
   3.7955448360941687`*^9}, {3.795544942592896*^9, 3.795544949083489*^9}, {
   3.795545012637274*^9, 3.795545013649784*^9}, {3.795545170219722*^9, 
   3.795545197120817*^9}, {3.795545250532687*^9, 3.795545253616083*^9}, {
   3.795545618638639*^9, 3.79554561894132*^9}, {3.795546304972234*^9, 
   3.795546317192102*^9}, {3.7955463676854486`*^9, 3.795546377384142*^9}, {
   3.7955464225004253`*^9, 3.795546422674135*^9}, {3.795546484928206*^9, 
   3.795546501020814*^9}, {3.7955465376625977`*^9, 3.7955465795086184`*^9}, {
   3.795547156698739*^9, 3.7955471688855267`*^9}, 3.795589318660206*^9, {
   3.795589465362862*^9, 3.795589529148932*^9}, {3.795589713598452*^9, 
   3.795589715510908*^9}, {3.795589980182246*^9, 3.795589981250493*^9}, 
   3.7956285212016706`*^9, {3.7956285567935963`*^9, 3.795628561637415*^9}, {
   3.795628613954863*^9, 3.79562863513338*^9}},
 CellLabel->
  "In[200]:=",ExpressionUUID->"78641a79-e85f-4206-ba4d-695a7283cb6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.990001`", ",", "0.848613284780921`"}], "}"}]], "Output",
 CellChangeTimes->{3.795628655560157*^9, 3.801036246799137*^9, 
  3.801036510569047*^9},
 CellLabel->
  "Out[211]=",ExpressionUUID->"d92b264c-ce1c-4ffa-a4de-9e3edd2a3c9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.990001`", ",", "0.9376297932436103`"}], "}"}]], "Output",
 CellChangeTimes->{3.795628655560157*^9, 3.801036246799137*^9, 
  3.801036513060384*^9},
 CellLabel->
  "Out[218]=",ExpressionUUID->"0f176682-07df-476e-b92e-157894d2a2c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.990001`", ",", "0.970236174107007`"}], "}"}]], "Output",
 CellChangeTimes->{3.795628655560157*^9, 3.801036246799137*^9, 
  3.801036515796977*^9},
 CellLabel->
  "Out[224]=",ExpressionUUID->"4ddf72c1-d1ed-4662-9cb8-3c01d193f163"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "ttdag", ",", "t", ",", "fn", ",", "int", ",", "dat12", ",", "dat22", ",", 
    "dat32", ",", "data12", ",", "data22", ",", "data32", ",", "space"}], 
   "]"}], ";", 
  RowBox[{"space", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t", "[", 
    RowBox[{"en_", ",", "V_", ",", "\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
   
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "kt", " ", "kx"}], 
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kt", "2"], "+", 
           SuperscriptBox["kx", "2"]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"L", "\[Rule]", "1"}], ",", " ", 
        RowBox[{"kx", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"ky", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"kz", "\[Rule]", 
         RowBox[{
          SqrtBox["en"], 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
        RowBox[{"kt", "\[Rule]", 
         SqrtBox[
          RowBox[{"en", "-", "V", "-", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Sin", "[", "\[Theta]", "]"}], 
               RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "-", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}], 
     ")"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"fn", ",", "int", ",", "dat"}], "]"}], ";", 
  RowBox[{
   RowBox[{"int", "[", 
    RowBox[{"rat_", ",", "V_", ",", "\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"rat", " ", "V"}], ",", "V", ",", "\[Theta]", ",", "\[Phi]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn", "[", 
    RowBox[{"rat_", ",", "V_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t1", ",", "t2", ",", "exp", ",", "\[Theta]", ",", "\[Phi]"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"exp", "=", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"int", "[", 
          RowBox[{"rat", ",", "V", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
         "]"}], "2"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"t1", "=", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"exp", " ", 
          RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", 
           RowBox[{
            RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
           RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "5"}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "15"}]}], "]"}]}], ";", 
      RowBox[{"t2", "=", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"1", "-", "exp"}], ")"}], 
          RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", 
           RowBox[{
            RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
           RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "5"}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "15"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"rat", " ", "V", " ", "t1"}], ",", 
        RowBox[{"t2", "/", "t1"}]}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{"fn", "[", 
        RowBox[{"rat", ",", "10"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len", "=", 
   RowBox[{"Length", "[", "dat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat12", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data12", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat12", "[", 
   RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "dat1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{"fn", "[", 
        RowBox[{"rat", ",", "25"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", ",", "space"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len", "=", 
   RowBox[{"Length", "[", "dat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat22", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data22", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat22", "[", 
   RowBox[{"[", "ele", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "dat1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rat", ",", 
       RowBox[{"fn", "[", 
        RowBox[{"rat", ",", "50"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rat", ",", "1", ",", "2", " ", ",", "space"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"len", "=", 
   RowBox[{"Length", "[", "dat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat32", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data32", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dat1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ele", "=", "1"}], ";", 
  RowBox[{"dat32", "[", 
   RowBox[{"[", "ele", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.795119119854344*^9, 3.795119123596528*^9}, {
   3.7951191721161423`*^9, 3.795119265781043*^9}, {3.79511932471906*^9, 
   3.795119353568372*^9}, {3.795119389258197*^9, 3.795119491306999*^9}, {
   3.795119531801958*^9, 3.795119758298603*^9}, {3.795119854246603*^9, 
   3.795119906475195*^9}, {3.795119986495932*^9, 3.795120021574985*^9}, {
   3.795120061146966*^9, 3.795120061740101*^9}, {3.795120455763092*^9, 
   3.79512073068731*^9}, {3.795120778697257*^9, 3.795120782596369*^9}, {
   3.795120962101157*^9, 3.795121028557564*^9}, {3.795121219566338*^9, 
   3.7951212231221*^9}, {3.795121261692348*^9, 3.7951212857968283`*^9}, 
   3.795121374319318*^9, {3.795121430549168*^9, 3.79512144776952*^9}, {
   3.7951214953293037`*^9, 3.795121525078743*^9}, {3.795121665516431*^9, 
   3.7951217020190372`*^9}, {3.795121766934218*^9, 3.7951217678928947`*^9}, {
   3.7951217980836983`*^9, 3.795121824213675*^9}, {3.7951222111320257`*^9, 
   3.795122262134712*^9}, {3.795122312783399*^9, 3.795122331591797*^9}, {
   3.795122366322688*^9, 3.795122404983653*^9}, {3.795122458363439*^9, 
   3.795122506527163*^9}, {3.7951225507505713`*^9, 3.795122646891032*^9}, {
   3.7951228184612207`*^9, 3.795122846278874*^9}, {3.795122892637504*^9, 
   3.795122898402958*^9}, {3.7951233015045958`*^9, 3.795123331178849*^9}, {
   3.7951261687022943`*^9, 3.7951261944735527`*^9}, {3.7951262495350533`*^9, 
   3.7951262561717*^9}, {3.795126594717926*^9, 3.795126622848489*^9}, {
   3.795127067416565*^9, 3.7951270715262117`*^9}, {3.795127154434876*^9, 
   3.795127184765744*^9}, {3.79512735817684*^9, 3.795127364881034*^9}, {
   3.795129063597739*^9, 3.795129079590725*^9}, {3.795129260349701*^9, 
   3.795129273833009*^9}, {3.79512931975395*^9, 3.7951293211831713`*^9}, {
   3.795129496522274*^9, 3.7951295009368343`*^9}, 3.795132978455655*^9, {
   3.795329725083877*^9, 3.795329729343388*^9}, {3.795330846498467*^9, 
   3.795330872507476*^9}, {3.795331850196862*^9, 3.7953319064863997`*^9}, {
   3.795331961288106*^9, 3.795331965599843*^9}, 3.795332258308421*^9, {
   3.795338323309299*^9, 3.7953383291680098`*^9}, {3.795338361142456*^9, 
   3.795338362069359*^9}, {3.79533939015594*^9, 3.795339404747386*^9}, {
   3.795340220275043*^9, 3.795340276006913*^9}, {3.795341323316277*^9, 
   3.795341323723103*^9}, {3.79534136450562*^9, 3.795341387243456*^9}, {
   3.7953414751825438`*^9, 3.795341478278921*^9}, {3.7953416162653522`*^9, 
   3.795341621065442*^9}, {3.795535088480639*^9, 3.795535254846726*^9}, 
   3.795536253531149*^9, 3.79554461856807*^9, {3.795544683895138*^9, 
   3.795544687711175*^9}, 3.79554481656409*^9, 3.795545413856152*^9, {
   3.795545474341548*^9, 3.795545481662225*^9}, {3.795545557131918*^9, 
   3.7955455632277803`*^9}, {3.7955456283505*^9, 3.7955456298321238`*^9}, {
   3.795589676187935*^9, 3.795589701719468*^9}, {3.795599219077442*^9, 
   3.795599226498415*^9}, {3.7956286936592407`*^9, 3.795628858770535*^9}, {
   3.795628890069903*^9, 3.795628939458943*^9}},
 CellLabel->
  "In[225]:=",ExpressionUUID->"d084fc84-3d53-4681-a3d7-a87c8ae18e58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.8437997148664563`"}], "}"}]], "Output",
 CellChangeTimes->{3.795628589979259*^9, 3.795628868737401*^9, 
  3.795628922329776*^9, 3.795628972599717*^9, 3.801036263472412*^9, 
  3.801036522767096*^9},
 CellLabel->
  "Out[234]=",ExpressionUUID->"da487062-fd3c-4210-9626-1ab6131fdb27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.9324101823304156`"}], "}"}]], "Output",
 CellChangeTimes->{3.795628589979259*^9, 3.795628868737401*^9, 
  3.795628922329776*^9, 3.795628972599717*^9, 3.801036263472412*^9, 
  3.801036530674559*^9},
 CellLabel->
  "Out[241]=",ExpressionUUID->"4d1201f7-4937-4c5b-a56e-abab89834feb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.9650273811290866`"}], "}"}]], "Output",
 CellChangeTimes->{3.795628589979259*^9, 3.795628868737401*^9, 
  3.795628922329776*^9, 3.795628972599717*^9, 3.801036263472412*^9, 
  3.801036542050853*^9},
 CellLabel->
  "Out[247]=",ExpressionUUID->"c7573f4a-24b4-4617-8ad5-18fa1e66dad1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"fp", ",", "sp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sp", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"data1", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"data11", ",", "data12"}], "]"}], "]"}]}], ",", 
      RowBox[{"data2", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"data21", ",", "data22"}], "]"}]}], ",", 
      RowBox[{"data3", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"data31", ",", "data32"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", "All"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<E/\!\(\*SubscriptBox[\(V\), \(0\)]\)\>\"", ",", 
       "\"\<\[Sigma](E,\!\(\*SubscriptBox[\(V\), \(0\)]\))\>\""}], "}"}]}], 
    ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", " ", "Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Dotted", ",", "Thick"}],
         "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", 
           RowBox[{"-", "0.25"}]}], "}"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<conduct3dnormal.jpg\>\"", ",", "sp"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", "**", "**", "**", "**", "**", "**"}], 
   "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{"fp", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"dat1", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"dat11", ",", "dat12"}], "]"}], "]"}]}], ",", 
      RowBox[{"dat2", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"dat21", ",", "dat22"}], "]"}]}], ",", 
      RowBox[{"dat3", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"dat31", ",", "dat32"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", "All"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<E/\!\(\*SubscriptBox[\(V\), \(0\)]\)\>\"", ",", 
       "\"\<F(E,\!\(\*SubscriptBox[\(V\), \(0\)]\))\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", " ", "Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Dotted", ",", "Thick"}],
         "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7"}], ",", 
           RowBox[{"-", "0.25"}]}], "}"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<fano3dnormal.jpg\>\"", ",", "fp"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "fp", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.795129099453619*^9, 3.795129189948071*^9}, {
   3.7951295349429703`*^9, 3.7951296402915897`*^9}, {3.795131855760603*^9, 
   3.795131919185946*^9}, {3.7951330177805634`*^9, 3.795133031078107*^9}, 
   3.795329074906158*^9, {3.795329117030916*^9, 3.795329164586104*^9}, {
   3.795329247183672*^9, 3.795329301100008*^9}, {3.795329386471616*^9, 
   3.795329495425994*^9}, {3.795329529675766*^9, 3.795329686176647*^9}, {
   3.795329949118679*^9, 3.7953299497312813`*^9}, {3.795329985317622*^9, 
   3.7953300257592993`*^9}, {3.79533005610296*^9, 3.795330076281754*^9}, {
   3.795330131819062*^9, 3.795330135592486*^9}, {3.795330184311407*^9, 
   3.795330189545801*^9}, {3.7953302330265007`*^9, 3.7953303077405167`*^9}, {
   3.795330397741708*^9, 3.795330402007928*^9}, {3.795330462641107*^9, 
   3.7953304838507*^9}, 3.795330535206356*^9, {3.795330566048111*^9, 
   3.795330579445199*^9}, {3.795330621641899*^9, 3.7953306874599257`*^9}, {
   3.7953307535225058`*^9, 3.795330814871068*^9}, {3.795330935160137*^9, 
   3.795330938614215*^9}, {3.7953310322805443`*^9, 3.795331082932808*^9}, {
   3.795331258430461*^9, 3.795331278376979*^9}, {3.795331975568935*^9, 
   3.795331984527747*^9}, {3.795339089593481*^9, 3.7953391979475937`*^9}, {
   3.795341771691587*^9, 3.795341772575748*^9}, {3.7953418877949743`*^9, 
   3.79534192631677*^9}, {3.795342002618416*^9, 3.795342003245421*^9}, {
   3.7953426297868223`*^9, 3.795342680359707*^9}, {3.7955332160215883`*^9, 
   3.795533222668001*^9}, {3.7955456384813433`*^9, 3.795545639965517*^9}, {
   3.795545752636393*^9, 3.7955457543540173`*^9}, {3.795545898566455*^9, 
   3.7955459777913637`*^9}, {3.795546016209198*^9, 3.7955460786783743`*^9}, {
   3.795589651696332*^9, 3.79558965804452*^9}, {3.7955898474670887`*^9, 
   3.7955899116887007`*^9}, {3.795590091236905*^9, 3.7955900932943497`*^9}, {
   3.7956290422737627`*^9, 3.7956290496283417`*^9}, {3.8010365464903793`*^9, 
   3.8010365717249737`*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"251569e6-bd69-43fe-9696-11ae5c596efd"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJwt1Hk4VfkfB3Bjd6eUNUzZItosXSHS+6iJZMaalFGJojKiaEG/IUtlSpgp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         "]]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJwt1Hs0lGsbBnCdJEUHRJJUSKGUShHX66wQameX1EZkp0JUihCdCEmFJpJT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         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}], LineBox[CompressedData["
1:eJwt1Xk4lGsfB/BRoledQsrJCYlQnalEG5nvk6wlzYzlCOFEHK+yJJVynd4O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         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, 
    InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], Bold, 12], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    Rational[2, 3], 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.4444444444444444, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    FractionBox["2", "3"], ",", "0", ",", "0"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[2, 3], 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    Rational[2, 3], 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 
                    Rational[2, 3], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.4444444444444444, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", 
                    FractionBox["2", "3"], ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 
                    Rational[2, 3], 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 
                    Rational[2, 3], 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 "Bold", ",", "12"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Column\"", ",", 
                 RowBox[{"{", 
                   RowBox[{"Automatic", ",", "5"}], "}"}]}], "}"}]}]}], 
         "]"}]& )], Scaled[{0.5, 0.5}], ImageScaled[{0.1, -0.25}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{False, False},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"\[Sigma](E,\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\))\"", 
       TraditionalForm], None}, {
      FormBox[
      "\"E/\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
      None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->Large,
   LabelStyle->Directive[
     GrayLevel[0], Bold, 12],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 2.}, {0, 126.70633840844022`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJwt1Hk4VfkfB3Bjd6eUNUzZItosXSHS+6iJZMaalFGJojKiaEG/IUtlSpgp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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJwt1Hs0lGsbBnCdJEUHRJJUSKGUShHX66wQameX1EZkp0JUihCdCEmFJpJT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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJwt1Xk4lGsfB/BRoledQsrJCYlQnalEG5nvk6wlzYzlCOFEHK+yJJVynd4O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          "]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {False, False}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{
        "\[Sigma](E,\!\(\*SubscriptBox[\(V\), \(0\)]\))", None}, {
        "E/\!\(\*SubscriptBox[\(V\), \(0\)]\)", None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Large, LabelStyle -> Directive[
        GrayLevel[0], Bold, 12], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 2.}, {0, 126.70633840844022`}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[
          Rational[2, 3], 0, 0], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 1], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 
          Rational[2, 3], 0], 
         Dashing[{0, Small}], 
         Thickness[Large]]}, {
       "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
         False, Automatic}}, Joined -> {True, True, True}, LabelStyle -> 
       Directive[
         GrayLevel[0], Bold, 12], 
       LegendLayout -> {"Column", {Automatic, 5}}]], {
      Scaled[{0.5, 0.5}], {0.1, -0.25}}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.795629050890492*^9, 3.801036291308297*^9, {3.8010365567135553`*^9, 
   3.80103657226847*^9}},
 CellLabel->
  "Out[264]=",ExpressionUUID->"dda5b6f1-212a-4fd1-90b1-95ff33b14726"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJwt1Hk0lfsaB3CllNBVcRtOpUSGU6kUpfStDpFG56CjaFKKjhIiFM2lSK4c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         "]]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        LineBox[CompressedData["
1:eJw10Xk01Psfx3GJFrfcSnuWtltCWijdlJd2pUS3FLmu20K4pEXaLj9coltJ
WkhSIiqpq2gqZZ1B2YUs2YcxY+bLmDHW8fua85n3OXPmPP/4vs/n83ksOHJy
33FFBQWFfPo3+n+dn/JIwnptUn7y08jICAWdua4+Tpf+QWntQh8x3b/du3Z0
8aXbuMJdvJ1L983HR8ffYTxExfxpO+vpbj8QVaF4KRZHFrpfKqV7XG3Q0o8R
z6CVpFCSTfdih7MXzjCS8DzoxboUumOEr9h3eP8hxXpuShzdq1LiVIUX3+K+
ktnEO3RneEUaWai8w4Y0fUt/ui3Xhzo8j3iP8Zk/O3vQ3TAUGDxuWRqeffQ2
taPbPf1y8hHGZ+waaM3cTveI6Xu3hicZqDgYXbWC7h0LDf2u8zJxct0Yl1l0
3xj76q6xQTaU32k5DEspVLYue9FxMQdx5zlxTXRrsmLT72Ux4Rz+clIO3cfj
tb5tU8nFwozigFi6Xwbd5/RY5eHYUUrgR7fYecbw44h83PCpWPQH3RvMb061
bPqC8oTKkXV0/6P30xKpdgFMlz0/PIXugsmB6xM9ChEauWkye5iCGqWw15ZR
BFtrbnsq3cs5n1YpKZTAa2XkxwC6Sw8NGtc+KYGVp+kBK7o989dtT95RCrNz
bt5z6J6z/pxlMK8Ua3UPDf0YopD2/I2tQ0gZZs8+evMh3Q7zuo8ZGZTjU9w1
iS3dStf0T6pWlcPh6kbuNLoThlwvsC9+w5y1LvNYgxR2uz3zT9OsQMsT3rqz
dHf9aLsellUBo7Rwrjrdty0Wh7s4VkKyfUpZ+gAFo/Q/YzapVCFhQmOwHd21
K6ITZydVIV7jXZywn4LPo7pUyuo7zHldr33pXjR1biZL/B3RcwP1J9Kd63vw
a1RENc4brw8P6qPgKrxdcXZjDeLft/0+IqGgerSswbypBquUolv/oju5/Gfu
woBanIuaHFjSS8F66x5Rv3YdPC+vCVlG98Dbq9KSgjqo34yEl5jCw1/yJiR4
/MAJ9oo8hojC5rvKaj7T63H4lPIufg8F9rgtGtaMephrqFeo0R3s9b+ly+0a
EG7d4KgrpDBLVD9bUaERQc5xnNXdFJwTh6P4Vo3gBQ0tX9ZF4eMx9UXVTxrx
yCNTOImiMFnDOCFH3AjNC3uq6/gU/qiwWf56RxMOxc8+ca+Twn/XzydHRjTh
2as/xxvzKIzdfs/oCq8JLtHxUmYHhQPSlLTTG5ux1p5/Yi2HwtPUb5vsQ5qR
6GB4/GobhT73HtbOpmb4D7uGpLdS2LV02u41Bi2wu9CeWt5M4UHDytL5AS1I
veO0NaeRguDeXutJVS2Ibd/rdqOegqmle61EuxV9H3fqrKijcGvCdYeWi61w
DLpq/qSaQmvGC3ZRQSvQa7m5vZLC2gtfXD5osvHAifOmt5xC0KoOKs6DjcPM
x/1FJRRqOsZ7hmax8W2SdbBLIQW9mCUDl6e34YgZOy47n4K37TafE45tMK2e
rFfJpFA87ZjSfkYbHE65iSIzKSz46hcMlXasPJ9QqPqJwhn/x6q6du2w91+3
eSmDAtM4I2xmUjvO+llY1CfLPThIDzl5S/el3IODg7tj546Ll3twUD/BRPvY
I7kHB38bSsTrI+QeHSg+/CvfO1Tu0QHDz4Z3FwfLPTog2OHNLfKWe3Ch8tlF
98A5CvEyDy4kPz5oprvKPbhYcmewcI+D3IOHlza+eh2/yT14GGO4wObidrkH
Dx82HbbgGsk9OpEcfjpBS1vu0YnKwqXlwzPlHp3YFphh5qgk9+DDThCasKZL
QDz4+Pii4YVZjYB48NHAecD0zBIQDwH+FVoIbyUIiIcA4X7mPe7XBMRDgKUp
EqMqNwHxoM8hOf00bLeAeFDwU/+Ue1xbQDwoFIYarZ4yRgAF2XRhwgJh455K
PpbZhWSJtbtQal9gUhbPxz6GZgDPqgvqep4Guz35uDQ9aUfTxS64m0ianE34
iPXYqFL1pAtvtnrcK1fko7BgdLqg3Pa8Xz+rE73aowu74Kfo7at1uRNa9DaG
ZjearWLE21Z2wqzpIr2xG+eULe5uqefh1Og6j278ZHhmRRr97vcjRqcbYVY8
1QNLeMgWjy7shoHVLzUZ6Vx0Wo0esBtjivabM6y4kB1vuhB+vQdixtZ1wGR0
3UYhlEUxb87Yd8BRNkIsv/JSOquag9Hb2oUIUfX0V2a9OQey6zKE6N4bslea
2g7Z8ZqEkB40npIztx2ydSo9YDZ12cd6tcFANj1Iqht6vb6IDdnz2fVA1WbX
lJ1abMiuG9CDv/zrP6W6tkJ2vKQeNKT8veP62xbI1lX1wH+R2u3ugWbiIULG
bRMrDdNm4iGCjuOKt9YBTcRDBPtZ+1eyvzYSDxH0XfJ+njijkXiIEG2m5tSS
XU88RHB7N/2Ns9MP4iFCnsGW9Csz64iHGPmqrbt7y2qIhxiMJzt1+FHVxEOM
gOcC1VPnvxMPMTiqkw4sP1oF2fNliRFnNGdKoH0l8RCjiJ2bfsulgnj04nrx
7n9WX/lGPHox3/Sx7dS35cSjF4rZiszXXWW4KVvYi5v+a2s9NpQRj14ouQex
798tJR69CIk9fchJWkI8JHhm+WC68pkS4iGB7ufNbza0FxMPCcaWJQ1/lBYR
DwlUCjRzW3WKiIcEUcVZBfNdComHBFufr0nifiggHn0INqpZVTKvgHj0YUK+
yOfsv1+JRx++Lt98I3LCV+LRh4DBPRJp6Bfi0YfLIottN5Z8IR59uPuQUbuF
mU88+mCop3FioVs+8ejHNNdW9+Ma+cSjH1f2d8StrsiDbJ1HP+5H+bUUh+UR
j370h1johB3KIx79UFS/ptqwMI949KPwp3KnX4S5xGMAij1mL1uYucRjAHqi
d4iJyiUeA6j/ertGdD6XeAxg/s3mp+cP5hKPAQycynAsW5eLZpnHAFT0v7fm
qecSj0H8t8zkO1MxF4Yyj0Gkq9VnFHFZxGMQSolp4de+sYjHINSiXY8y01nE
YxA2c3r1tiWyiAf9fU3cxLoIFvEYwqIjTW9/D2IRjyHkF+nVxHixiMcQ9EOc
MwOdWMRjCLYO9y04B1nEYwh/BDGKEsxYxGMIO7ILq1/8yiIeQ6gqbo6p0WER
j2Ec3ye1mafOIh7DiFLbb2w7mUU8hqF/KrLcX8okHsP4NNjy2xWKSTyGMUnd
5ez+RibxGEZSmXvmjxIm8ZDiX42WVzMzmcRDish9GQtEr5nEQ4oQ60u+ro+Y
xEMKvv5ElzMhTOIhpd9N8U8lbybxkCK5W+o78y8m8RhB2OOpW57aMInHCEoN
vXQTtzOJxwhUdfNnaBswiccIfJUv6czQYhKPEeRqHJ7josIkHiMomG2iskKc
QzwUTN9bzPH4vSEH/wcU9JDk
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}], LineBox[CompressedData["
1:eJw11ns41Gkfx3GLWquwqbZdHUkOnYt0euwHFU9FSknJ5tRJ7ZY2VlHJonTU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         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], Thickness[Large], 
        Dashing[{0, Small}]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, 
    InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0], 
                    Dashing[{0, Small}], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], Bold, 12], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    Rational[2, 3], 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.4444444444444444, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    FractionBox["2", "3"], ",", "0", ",", "0"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[2, 3], 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    Rational[2, 3], 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 
                    Rational[2, 3], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.4444444444444444, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", 
                    FractionBox["2", "3"], ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 
                    Rational[2, 3], 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 
                    Rational[2, 3], 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 "Bold", ",", "12"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Column\"", ",", 
                 RowBox[{"{", 
                   RowBox[{"Automatic", ",", "5"}], "}"}]}], "}"}]}]}], 
         "]"}]& )], Scaled[{0.5, 0.5}], ImageScaled[{-0.7, -0.25}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{False, False},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"F(E,\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\))\"", TraditionalForm],
       None}, {
      FormBox[
      "\"E/\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
      None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->Large,
   LabelStyle->Directive[
     GrayLevel[0], Bold, 12],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 2.}, {0, 0.9999999999923047}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJwt1Hk0lfsaB3CllNBVcRtOpUSGU6kUpfStDpFG56CjaFKKjhIiFM2lSK4c
ZDgNpMHBVUQ5hqIoYRvCNm5s9vwzbbPtsu/vu9a73r/e73qe57PWu/T4uV9P
TpaRkSkafybeQcK0x/2fU7b4lrwRj40R6C4443/K9wZeRmm6OkoIfgsPdNDw
fYiYKSUK2SMED544TAvLiIV21SRzuWGCDuuYqsm+cWiLuxy7ZZBAru6O1ofI
l7AOSbrp2E+gcdTD2z0jCfu0lpy7LCZ42p3MDuP/F/cNnudf6yFYkxY/s9vn
LcJmGXde6CLI9Yoy3DvjHeab+v1mQwj2G4UcfRWZiRwNl53LhARNI7cC5HSy
cPBehW49j+BszqXU4xnZSHlxbucVDsHY1kyXpme5yHurnjWzncBMfd21IH4e
rgXLOdxuJbgvm/znJv1POMn0ZHGaCX606bzm+uTjpH5n3NpGgsWf43LCPxag
gqmj6lhHcDJBrdJ0xhd0JHV/960h+PvOI06PZSEijh208a4iEDupjj6JLALL
OpZ5qJxg864Hs/azvkLJ4ri1einBjRUKyyXaxejMt9rw7RtBsdIto0TX75j0
RbT5QCHBHCKz72BGCZK2pbz/lE+wkvPPmikyZfATqlQo5xEwfh/eVPesDAWX
yhds/ofgQtGGHalmDLi6fAwzySSYb+S5P4DPQOFiBTPdNIKsV28OHg0uR8uN
h/f4KQRHf+o6Yahfge8vnyvdTiSYErjq3MzqCjg4pu4bSiB4MXLGm+1TCQvB
Xs8dzwh2u7y8nrW4CgyT/OVHYgk6G9qDQj9WwYhRWHY4kuDhXo0IZ8cfeGxi
J9R+SGCYc+zpthnVUGxw8su/T1Cn91fivKRqHOfcvbg6gMD/cX06sazBo/vT
dc5cJ1g2a0HeZ3ENXqw9oOd+meDL1QPfYiJrsaklKHCHF8GZ7odVHsZMrAwJ
m9PqSjDTobxpF4sJP92602bOBKkV/+Kp36zDLWeF4vMOBDYme3oHtevhsMu6
+7AdwdDbu5Ky4noY2L6VV7QmiNUsnP7CtQEbvpH3fnsItv85dY6/SiPelTq7
JpkSsOV+WWST0QjdhR4qUcYEAV5XtFbaNaF+Ukji5vUEc3sb502WaUbaUGxt
2AoCp8TRGKFlM56XlNbHLyP4cGLhstpnzThxrPCPUwsIlBZtepEvboZ3lEtl
jTLBkSrblSlmLDyMT7vWL0fw36CLqVGRLOydVsPIHRFBdke44W0+C9vSriis
7RbBWpKW5WbcMn63tlTzDhGep1duOxzcgjpeo82kehEGzvZ83slqwdQRI3nb
MhEstGbvXq/fCoXsyTZ78kWIblrNWHKzFWMNr1qZ70QQhe+zUaxuxRP50QDJ
KxG27j9b16/dhisMpnJajAj/mR50tNWnDZZeDnOHg0Voy33NLilug33Xzye+
XxXBwPur8/vFbDzbeMBe212EO2u4JN6VjUTHkZfTT4jA5E67EPKRjQejy544
W4mw4unyoUsq7bgKEmlhIoLfQVP/047tKP7e/zlOX4TS2SemWGW0I4MZF3JB
XYSl364FYEYHmtqH5TOVRXC//mTmz3YdcHITRp2RCFGwKTf030kdeL967l93
+ELqwYGm7N/hijVC6sFB7aEdR3s+CakHByt/cevYkCykHhzYT8s9VBsppB5c
+GkmypddF1IPLh6dUm+c5yKkHlzcdVQfTrYWUg8e/J30EGIsRILUg4eykuZj
GRpC6sFDRTFz61IFIfXgY1rzk+wvnQLqwUdB0PnPCVUC6sFHn/xN638yBdRD
gO2ydW5TYgTUQwDlbLsjPv4C6iHAdA01MveYgHoIoSn5M6d+m4B6CBEY/2ld
/lIB9RCid/s65lcZAfUYv3vEypPCRj71EMGyKT5bO4tPPURo4tsPe0fwqQfB
8bJIq0Z3PvUgOKRx6/xve/nUg4CVqa5YrcWHjDSdyDH02n5ahg8du+CPYu1O
XFhgvl22hodfMxbf5Ft2QvnGgryEJB58VZLMWD6dsPFJTbe6wUOcq/GM6med
yGLae8vb8vC9eCKdeJ30e3rBCh76tCcKOzHp1aK7AWNcqI23ZSzugqjI4ow1
gwtzls94YxccXapMdZ9ycX6izrULf9hF+8i7jbtGTqQLF9d6N/Ru5eKTeKKw
C6o77r0TzeRCYDkxYBfqH5wtG6zjQDqeSjd25zp6zn/BwZaJOuNu+OZGeFi6
c+AoTTe+yrDVnhtzMLGtXXA3/Nc/Mls4jQPpuhndaElUtcos7YB0PFY3hGrX
NK+Hd0BaN6MH7nLVS64c7oC+ND1IUt59+p1GB6Tns+tBtuTQmtW8dkjXvdkD
NTWPW91J7ZCOl9SDlZc8c+Xc2yGtq+7BvM8JCz0N2qlHL1Kbdn3YOcimHr04
V0ru3PvAph69eGOh3mB6mU09ehEY7b7k+hY29ejFqsBQg31jbdSjF/wm4U9v
ctqoRy/CT+m9zvJvox5idMmECDzRRj3E0JnVryeStFIPMUqCD7vuzG6lHmIo
RTmtOnC5FdLzfRTDK9NAb9PmVuohRvL6+y1LhluoRx+StT95THrfQj36EBm6
5RL3Ygv16EOEu4MF27AFD6SFfSg+ZFEi08+iHn0wTtCqME9nUY8+bDQL6ii8
wKIe/XhnsqohcD2LevTDarai5uPx//j/PfrhU3e1Rim9mXr0Q9/dvLbZs5l6
9INTEhW6bEMz9ejHafsMw9yeJuoxgD2xQ7pbLzZRjwHMWOPlVjvaSD0GEFT+
LSPmRiP1GMCHwalJMYqN1GMAJqpvFnHDGqjHAHipl9TuL2mgHgPwVOsrepRY
Tz0GIepbqrLQqJ56DKJF87nPoqI6SOtcB6F0eeHIS9s66jGIAoX3K77xmdRj
EPNtLbkB/kzqMQhyZCNPqMKkHkOAyHaO5HUt9RhCYaHu4TyTWuoxhCpZ8xNG
TTXUYwhhu3lLz/nWUI8hFHEnc4/Pr0GL1GMIJ61jm1Uzq6nHMHJUS6cGHazG
OqnHMJ6fb5tbOPqDegwjPPoP1S9Pf1CPYbyKNn4dsPMH9RhGQYEie2Z3FfUY
RjvLSNYquop6jCAlorTwd/Mq6jGC9BT5hvl9ldRjBJaM05NC4yupxwg2y8fr
5tlUUo8RqBstUnksX0k9RuCjVWv9c3YF9Rj/3s2Pae9RQT1G4eZqFbt2RQX1
GEXT8rmr4tjl1GMUy+r1QhMfl1OPUShtS91ial9OPUZxgYhFTj+VU49RFMsu
3jG7jkE9JJDPD7y2IZpBPSTI3OjPrzrMoB4SXGJklrSqM6iHBOlOUeqHOGXU
Q4K5/VMV1ieXUQ8JcoJ67jp7lVGPMaQ8UIzo3VpGPcYw+03oqmKFMuoxBmc7
F7fK5FLqMYaincPhwRal1GMMBufFzz50lFCPMcTbdoZY3C6hHjJb96Xfv7dK
pwT/A5amfWQ=
          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJw10Xk01Psfx3GJFrfcSnuWtltCWijdlJd2pUS3FLmu20K4pEXaLj9coltJ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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJw11ns41Gkfx3GLWquwqbZdHUkOnYt0euwHFU9FSknJ5tRJ7ZY2VlHJonTU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          "]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}, {{
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[
           Rational[2, 3], 0, 0], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 1], 
          Thickness[Large]]}, {
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 
           Rational[2, 3], 0], 
          Dashing[{0, Small}], 
          Thickness[Large]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {False, False}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"F(E,\!\(\*SubscriptBox[\(V\), \(0\)]\))", None}, {
        "E/\!\(\*SubscriptBox[\(V\), \(0\)]\)", None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Large, LabelStyle -> Directive[
        GrayLevel[0], Bold, 12], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 2.}, {0, 0.9999999999923047}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[
          Rational[2, 3], 0, 0], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 1], 
         Thickness[Large]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 
          Rational[2, 3], 0], 
         Dashing[{0, Small}], 
         Thickness[Large]]}, {
       "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)", 
        "\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
         False, Automatic}}, Joined -> {True, True, True}, LabelStyle -> 
       Directive[
         GrayLevel[0], Bold, 12], 
       LegendLayout -> {"Column", {Automatic, 5}}]], {
      Scaled[{0.5, 0.5}], {-0.7, -0.25}}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.795629050890492*^9, 3.801036291308297*^9, {3.8010365567135553`*^9, 
   3.801036572588902*^9}},
 CellLabel->
  "Out[266]=",ExpressionUUID->"06d70eb4-fcf8-4894-bf97-3c393737d6f7"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"006ca6a1-811e-42ca-9b57-ba8599a3cbcb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 216, 5, 67, "Section",ExpressionUUID->"b8b2dba5-6f71-414d-808e-803fd7ac87bd"],
Cell[799, 29, 272, 7, 30, "Input",ExpressionUUID->"598db16e-f0e8-4cba-bfc4-b64182a1ef8b"],
Cell[CellGroupData[{
Cell[1096, 40, 3562, 114, 300, "Input",ExpressionUUID->"91681390-7143-4bf8-9f2d-43953ae36692"],
Cell[4661, 156, 840, 24, 61, "Output",ExpressionUUID->"13001827-f847-4b17-bd5d-80d761135bc1"],
Cell[5504, 182, 690, 17, 57, "Output",ExpressionUUID->"66ff0b62-01b3-471f-aa1e-a61642e7dca9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6231, 204, 1199, 34, 55, "Input",ExpressionUUID->"48609805-ebbe-4843-941e-db81d35388a3"],
Cell[7433, 240, 151, 2, 34, "Output",ExpressionUUID->"2ad7e03f-4dff-46c9-8fa9-ee2e25da8ca3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7621, 247, 3813, 98, 233, "Input",ExpressionUUID->"6b8f143d-9ba1-43a3-b9c7-88f5a81e1708"],
Cell[11437, 347, 707, 14, 58, "Output",ExpressionUUID->"d075e0c4-638f-4d43-80db-71c084a2ebfe"],
Cell[12147, 363, 719, 14, 37, "Output",ExpressionUUID->"2727f8db-063f-4e9c-99a9-c3bfcd355b64"],
Cell[12869, 379, 675, 13, 49, "Output",ExpressionUUID->"9a77748f-2e1f-41c8-8d22-eefffc0e0c7c"]
}, Open  ]],
Cell[13559, 395, 329, 10, 8, "Text",ExpressionUUID->"32b6299f-8588-4d96-99e0-a2e9e464d864"],
Cell[CellGroupData[{
Cell[13913, 409, 25329, 734, 1756, "Input",ExpressionUUID->"cfa3fb63-aeb4-4bf7-96c8-cf5d1b811223"],
Cell[39245, 1145, 39861, 745, 449, "Output",ExpressionUUID->"0b9b623f-0083-40ed-ae62-ee0cc0b672cf"],
Cell[79109, 1892, 40054, 747, 449, "Output",ExpressionUUID->"b8897e14-8299-481c-868c-c92f668a0525"],
Cell[119166, 2641, 39786, 744, 449, "Output",ExpressionUUID->"a3263752-bdb5-4d9e-a860-ffddcb50deb0"]
}, Open  ]],
Cell[158967, 3388, 329, 10, 8, "Text",ExpressionUUID->"0aab99be-e023-4389-8fec-079b8ba3245c"],
Cell[CellGroupData[{
Cell[159321, 3402, 1288, 39, 87, "Input",ExpressionUUID->"899efe71-4691-479a-a8d3-9143fcf5f55d"],
Cell[160612, 3443, 1951, 61, 82, "Output",ExpressionUUID->"33b9bcc2-0265-468c-a1ae-8a6e478b4155"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162600, 3509, 4418, 128, 223, "Input",ExpressionUUID->"adf76fab-6829-408a-b80a-6ec54856b023"],
Cell[167021, 3639, 1245, 39, 60, "Output",ExpressionUUID->"c3775970-6158-4cbc-bc5d-089cf9aa6ba3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168303, 3683, 9763, 248, 505, "Input",ExpressionUUID->"a726733d-831a-47a9-a710-e1867a6e5465"],
Cell[178069, 3933, 341, 7, 34, "Output",ExpressionUUID->"6cddb022-a2d7-41f4-9d04-1a629019a6c5"],
Cell[178413, 3942, 341, 7, 34, "Output",ExpressionUUID->"46331d0c-859d-4a4b-a6cb-33e6ba8afa59"],
Cell[178757, 3951, 343, 7, 34, "Output",ExpressionUUID->"96937d04-8081-4c63-812b-7f71b2e82a3e"],
Cell[179103, 3960, 315, 6, 24, "Print",ExpressionUUID->"19fbd073-024e-437a-9d42-cfdc6504d307"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179455, 3971, 9899, 257, 557, "Input",ExpressionUUID->"6fc3ed1d-0de5-47d7-b6fd-1b6ab9fd0439"],
Cell[189357, 4230, 311, 6, 34, "Output",ExpressionUUID->"bbbc16b7-8344-445f-8335-45f1abbd976a"],
Cell[189671, 4238, 309, 6, 34, "Output",ExpressionUUID->"efe8efcb-43a0-4769-b406-c761f6fab873"],
Cell[189983, 4246, 218, 5, 34, "Output",ExpressionUUID->"76aa7ec8-35de-4492-a641-467f03177295"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190238, 4256, 7413, 172, 552, "Input",ExpressionUUID->"fe7575a3-ec47-4a5a-baee-a376266cf7b6"],
Cell[197654, 4430, 44484, 921, 393, "Output",ExpressionUUID->"dc10b254-da47-4a28-85b6-5994b6fbab8e"],
Cell[242141, 5353, 43724, 908, 296, "Output",ExpressionUUID->"78daa901-01e1-4b7a-b989-8986c3115668"]
}, Open  ]],
Cell[285880, 6264, 329, 10, 8, "Text",ExpressionUUID->"f0d347ce-41d0-4410-a84a-36f0293121a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[286246, 6279, 152, 3, 67, "Section",ExpressionUUID->"85491848-c1e6-4e8b-80c6-f371850b38f4"],
Cell[CellGroupData[{
Cell[286423, 6286, 11227, 318, 912, "Input",ExpressionUUID->"78641a79-e85f-4206-ba4d-695a7283cb6d"],
Cell[297653, 6606, 270, 6, 34, "Output",ExpressionUUID->"d92b264c-ce1c-4ffa-a4de-9e3edd2a3c9d"],
Cell[297926, 6614, 271, 6, 34, "Output",ExpressionUUID->"0f176682-07df-476e-b92e-157894d2a2c2"],
Cell[298200, 6622, 270, 6, 34, "Output",ExpressionUUID->"4ddf72c1-d1ed-4662-9cb8-3c01d193f163"]
}, Open  ]],
Cell[CellGroupData[{
Cell[298507, 6633, 12483, 323, 870, "Input",ExpressionUUID->"d084fc84-3d53-4681-a3d7-a87c8ae18e58"],
Cell[310993, 6958, 334, 7, 34, "Output",ExpressionUUID->"da487062-fd3c-4210-9626-1ab6131fdb27"],
Cell[311330, 6967, 334, 7, 34, "Output",ExpressionUUID->"4d1201f7-4937-4c5b-a56e-abab89834feb"],
Cell[311667, 6976, 334, 7, 34, "Output",ExpressionUUID->"c7573f4a-24b4-4617-8ad5-18fa1e66dad1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[312038, 6988, 7943, 182, 552, "Input",ExpressionUUID->"251569e6-bd69-43fe-9696-11ae5c596efd"],
Cell[319984, 7172, 47279, 969, 385, "Output",ExpressionUUID->"dda5b6f1-212a-4fd1-90b1-95ff33b14726"],
Cell[367266, 8143, 46588, 956, 387, "Output",ExpressionUUID->"06d70eb4-fcf8-4894-bf97-3c393737d6f7"]
}, Open  ]]
}, Open  ]]
}
]
*)

