(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3275443,      58669]
NotebookOptionsPosition[   3267247,      58545]
NotebookOutlinePosition[   3267568,      58559]
CellTagsIndexPosition[   3267525,      58556]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"hbar", "=", "1"}], ";", 
  RowBox[{"m", "=", "1"}], ";", 
  RowBox[{"v", "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["hbar", "2"], 
     RowBox[{"2", "m"}]], "2", "kl"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vs", "=", "1"}], 
  RowBox[{"(*", 
   RowBox[{"=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["hbar", "2"], 
      RowBox[{"2", "m"}]], "2", 
     RowBox[{"Abs", "[", "kt", "]"}]}]}], "*)"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]1", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], ",", 
     
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
     "0", ",", "1"}], "}"}]}], 
  RowBox[{"(*", 
   RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]2", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}], 
      RowBox[{"2", " ", "kz"}]], ",", 
     FractionBox[
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
      RowBox[{"2", " ", "kz"}]], ",", "1", ",", "0"}], "}"}]}], 
  RowBox[{"(*", 
   RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]3", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], ",", 
     
     FractionBox[
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}]}], 
      RowBox[{"2", " ", "kz"}]], ",", "0", ",", "1"}], "}"}]}], 
  RowBox[{"(*", 
   RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]4", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["kz", "2"]}]}], 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       "kz"}]], ",", 
     FractionBox[
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
      RowBox[{"2", " ", "kz"}]], ",", "1", ",", "0"}], "}"}]}], 
  RowBox[{"(*", 
   RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[ImaginaryI]", ",", "0", ",", "1", ",", "0"}], "}"}], "+", 
       RowBox[{"rp", " ", 
        RowBox[{"{", 
         RowBox[{"\[ImaginaryI]", ",", "0", ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "+", 
       RowBox[{"rm", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "\[ImaginaryI]"}], "}"}], 
        "  "}]}], 
      SqrtBox["v"]], "-", 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"\[Psi]1", "[", "kt", "]"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"\[Psi]2", "[", "kt", "]"}]}], "+", 
        RowBox[{"a3", " ", 
         RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
        RowBox[{"a4", " ", 
         RowBox[{"\[Psi]4", "[", "kt", "]"}]}]}], ")"}], 
      SqrtBox["vs"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy2", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a1", " ", 
          RowBox[{"\[Psi]1", "[", "kt", "]"}]}], "+", 
         RowBox[{"a2", " ", 
          RowBox[{"\[Psi]2", "[", "kt", "]"}]}], "+", 
         RowBox[{"a3", " ", 
          RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
         RowBox[{"a4", " ", 
          RowBox[{"\[Psi]4", "[", "kt", "]"}]}]}], ")"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
      SqrtBox["vs"]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"tp", 
        RowBox[{"{", 
         RowBox[{"\[ImaginaryI]", ",", "0", ",", "1", ",", "0"}], "}"}]}], 
       "+", 
       RowBox[{"tm", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0", ",", "\[ImaginaryI]"}], "}"}], 
        " "}]}], 
      SqrtBox["v"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "sol", "]"}], ";", 
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
      "rp", ",", "rm", ",", "tp", ",", "tm", ",", "a1", ",", "a2", ",", "a3", 
       ",", "a4"}], "}"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7937818238754663`*^9, 3.7937819439289713`*^9}, {
   3.7937820201854477`*^9, 3.793782213726076*^9}, {3.793782312356654*^9, 
   3.7937823180962677`*^9}, {3.7937824253246183`*^9, 3.793782558963937*^9}, {
   3.7937826940308104`*^9, 3.793782701493499*^9}, {3.7937830096826143`*^9, 
   3.7937830149801598`*^9}, {3.7937830772374363`*^9, 3.793783083258094*^9}, 
   3.79534564889083*^9},ExpressionUUID->"8ee2601f-e994-4284-a8d8-\
5dcdb4752b04"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"rp", "\[Rule]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                RowBox[{"-", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], 
                   " ", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                  RowBox[{
                   SqrtBox["kl"], " ", 
                   RowBox[{"(", 
                    RowBox[{"kx", "-", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], "-", 
                FractionBox[
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], 
                 SqrtBox["kl"]]}], 
               RowBox[{
                RowBox[{"-", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], 
                   " ", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                  RowBox[{
                   SqrtBox["kl"], " ", 
                   RowBox[{"(", 
                    RowBox[{"kx", "-", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], "+", 
                FractionBox[
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], 
                 SqrtBox["kl"]]}]]}]}], ",", 
            TemplateBox[{"6"},
             "OutputSizeLimit`Skeleton"], ",", 
            RowBox[{"a4", "\[Rule]", 
             FractionBox[
              RowBox[{
               SqrtBox["3"], 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"], 
               RowBox[{"(", 
                RowBox[{
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}]}]}], 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 38, 23293984867209521645, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 38, 23293984867209521645, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 38, 23293984867209521645, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23293984867209521645 === $SessionID, 
   Out[38], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.7937830481020184`*^9, 3.793783115454921*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"3d0cf7e9-3a72-4b9c-9fbe-db7dad9e2f82"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"cbc79881-723a-4548-a08a-13f6d2451498"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rpp", "=", 
   RowBox[{"rp", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rmp", "=", 
   RowBox[{"rm", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tpp", "=", 
   RowBox[{"tp", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"tm", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.793782818921529*^9, 3.793782829343287*^9}, {
   3.793782862203722*^9, 3.7937828955301857`*^9}, 3.7937986312688313`*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"60ba82d1-f314-4611-a663-521dc4582c12"],

Cell[CellGroupData[{

Cell[BoxData["tpp"], "Input",
 CellChangeTimes->{{3.793782843840455*^9, 3.7937828442262697`*^9}, 
   3.7937829721231813`*^9, {3.793783210494738*^9, 3.7937832136749268`*^9}, {
   3.793783362535164*^9, 3.7937833781992607`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"b7130cda-c21e-4e14-b448-9f7cccf543b4"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]], "Output",
 CellChangeTimes->{
  3.793782844788271*^9, {3.793782965824848*^9, 3.793782972649485*^9}, {
   3.7937831962917233`*^9, 3.793783214423918*^9}, {3.793783371185812*^9, 
   3.793783378882511*^9}},
 CellLabel->"Out[55]=",ExpressionUUID->"c6ae5f31-3f48-46e0-9587-9b128d2d91a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.79378321694352*^9, 3.793783273303342*^9}, {
  3.7937833200712976`*^9, 3.793783322336042*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"88b22f67-10eb-4446-a06b-c63e428dda4b"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         InterpretationBox[
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["kt", "8"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"16", " ", 
                    SuperscriptBox["kt", "4"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["kt", "2"], " ", 
                    SuperscriptBox["kx", "2"]}], "+", 
                   SuperscriptBox["kx", "4"], "+", 
                   RowBox[{"24", " ", "\[ImaginaryI]", " ", 
                    SuperscriptBox["kt", "2"], " ", "kx", " ", "ky"}], "+", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["kt", "2"], " ", 
                    SuperscriptBox["ky", "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["kx", "2"], " ", 
                    SuperscriptBox["ky", "2"]}], "+", 
                   SuperscriptBox["ky", "4"]}], ")"}]}], 
                RowBox[{"40320", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"kx", "+", 
                    RowBox[{"\[ImaginaryI]", " ", 
                    TemplateBox[{"2"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", 
                    SqrtBox["3"], " ", 
                    SuperscriptBox["kt", "2"]}], "-", 
                   RowBox[{"6", " ", "kt", " ", "kx"}], "+", 
                   RowBox[{
                    SqrtBox["3"], " ", 
                    SuperscriptBox["kx", "2"]}], "+", 
                   RowBox[{"6", " ", "\[ImaginaryI]", " ", "kt", " ", "ky"}], 
                   "+", 
                   RowBox[{
                    SqrtBox["3"], " ", 
                    SuperscriptBox["ky", "2"]}]}], ")"}]}]]}], "+", 
              FractionBox[
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], ")"}], " ", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], " ", 
                RowBox[{"(", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], ")"}]}], 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], "2"], " ", 
                RowBox[{"(", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], ")"}]}]]}], ")"}], " ", 
            SuperscriptBox["L", "8"]}], "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", "L", "]"}], "9"],
            SeriesData[$CellContext`L, 0, {}, 8, 9, 1],
            Editable->False]}],
          
          SeriesData[$CellContext`L, 
           0, {(((Rational[-1, 40320] $CellContext`kt^8) ($CellContext`kx + 
                 Complex[0, 1] $CellContext`ky)^(-2))/((4 
                3^Rational[1, 2]) $CellContext`kt^2 - (
               6 $CellContext`kt) $CellContext`kx + 
              3^Rational[1, 2] $CellContext`kx^2 + (
                Complex[0, 6] $CellContext`kt) $CellContext`ky + 
              3^Rational[1, 2] $CellContext`ky^2)) (
              16 $CellContext`kt^4 - (
               4 $CellContext`kt^2) $CellContext`kx^2 + $CellContext`kx^4 + ((
                 Complex[
                  0, 24] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(20 $CellContext`kt^2) $CellContext`ky^2 + (
                2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4) + \
((((4 ($CellContext`kx + 
                   Complex[
                    0, 1] $CellContext`ky)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)) (
                4 $CellContext`kt^2 - ((2 
                  3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                   3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2))/((4 3^Rational[1, 2]) $CellContext`kt^2 - (
               6 $CellContext`kt) $CellContext`kx + 
              3^Rational[1, 2] $CellContext`kx^2 + (
                Complex[0, 6] $CellContext`kt) $CellContext`ky + 
              3^Rational[
                 1, 2] $CellContext`ky^2)) ((((((Rational[-3, 2] 
                    3^Rational[1, 2]) $CellContext`kl^2) $CellContext`kt^5) (
                    Complex[
                    0, -1] $CellContext`kx - $CellContext`ky)^3) \
(($CellContext`kt^2 + $CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Complex[0, 
                    Rational[9, 8]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^5) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2))) ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                   Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                   Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                   Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                   4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((
                    Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + (((((Complex[0, 
                    Rational[-1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((Complex[0, 
                    
                    Rational[-1, 
                    2]]/$CellContext`kl) ($CellContext`kt $CellContext`kx + (
                    Complex[
                    0, -1] $CellContext`kt) $CellContext`ky)) (((((
                    Rational[-1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ($CellContext`kl^(-1) (-$CellContext`kx + 
                   Complex[0, 1] $CellContext`ky)) (((((Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (($CellContext`kl^(-1)/$CellContext`kt) (
                   Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) (((((
                    Rational[1, 1440] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[-1, 1440] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[-1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 2] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[-1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[1, 8]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[
                    1, 3]]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[-1, 40] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[
                    1, 3]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    
                    Rational[-1, 
                    2880]]/$CellContext`kl) $CellContext`kt^4) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[-1, 720]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 1440]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2))/(
                4 $CellContext`kt^2 - ((2 
                  3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                   3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                   Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                   Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                   Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + (((((Complex[0, 
                    Rational[-1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                   4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((
                    Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 5040]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7 + ((((
                    Rational[1, 1680] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 5040]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^7 + (((((Rational[1, 560] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((Complex[0, 
                    
                    Rational[-1, 
                    2]]/$CellContext`kl) ($CellContext`kt $CellContext`kx + (
                    Complex[
                    0, -1] $CellContext`kt) $CellContext`ky)) (((((
                    Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ($CellContext`kl^(-1) (-$CellContext`kx + 
                   Complex[
                    0, 1] $CellContext`ky)) (((((
                    Rational[1, 1440] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[-1, 1440] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (($CellContext`kl^(-1)/$CellContext`kt) (
                   Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) (((((
                    Complex[0, 
                    Rational[1, 10080]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 10080]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[-1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[-1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 2] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[-1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[1, 8]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[-1, 40] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[
                    1, 3]]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[
                    1, 3]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 5040]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7 + ((((
                    Rational[-1, 1680] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 1680] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    
                    Rational[-1, 
                    2880]]/$CellContext`kl) $CellContext`kt^4) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[-1, 720]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 1440]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 20160]/$CellContext`kl) $CellContext`kt^5) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 5040] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7 + ((((
                    Rational[1, 10080] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Complex[0, 
                    Rational[3, 4]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2))/(
                4 $CellContext`kt^2 - ((2 
                  3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                   3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                   Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                   Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                   Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + (((((Complex[0, 
                    Rational[-1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 5040]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7 + ((((
                    Rational[1, 1680] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 5040]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^7 + (((((Rational[1, 560] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                   4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((
                    Complex[
                    0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 40320] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^8 + ((((Complex[0, 
                    Rational[1, 13440]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[1, 40320] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^8 + (((((Complex[0, 
                    Rational[1, 4480]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((Complex[0, 
                    
                    Rational[-1, 
                    2]]/$CellContext`kl) ($CellContext`kt $CellContext`kx + (
                    Complex[
                    0, -1] $CellContext`kt) $CellContext`ky)) (((((
                    Rational[1, 1440] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[-1, 1440] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ($CellContext`kl^(-1) (-$CellContext`kx + 
                   Complex[0, 1] $CellContext`ky)) (((((Complex[0, 
                    Rational[1, 10080]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 10080]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (($CellContext`kl^(-1)/$CellContext`kt) (
                   Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) (((((
                    Rational[-1, 80640] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[1, 80640] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[-1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 2] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[-1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[-1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[1, 8]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[-1, 40] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[
                    1, 3]]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 5040]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7 + ((((
                    Rational[-1, 1680] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 1680] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[
                    1, 3]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[1, 40320] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^8 + ((((Complex[0, 
                    Rational[-1, 13440]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[1, 13440]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Complex[0, 
                    
                    Rational[-1, 
                    2880]]/$CellContext`kl) $CellContext`kt^4) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[-1, 720]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 1440]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 20160]/$CellContext`kl) $CellContext`kt^5) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 5040] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7 + ((((
                    Rational[1, 10080] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 161280]]/$CellContext`kl) $CellContext`kt^6) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 40320]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^8 + ((((Complex[0, 
                    Rational[1, 80640]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^7)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                   Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                   Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                   Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                   4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((
                    Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((Complex[0, 
                    
                    Rational[-1, 
                    2]]/$CellContext`kl) ($CellContext`kt $CellContext`kx + (
                    Complex[
                    0, -1] $CellContext`kt) $CellContext`ky)) (((((
                    Complex[0, 
                    Rational[1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ($CellContext`kl^(-1) (-$CellContext`kx + 
                   Complex[
                    0, 1] $CellContext`ky)) (((((
                    Rational[-1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (($CellContext`kl^(-1)/$CellContext`kt) (
                   Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) (((((
                    Complex[0, 
                    Rational[-1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[1, 240]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[-1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 2] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[
                    1, 3]]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[-1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[1, 8]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[
                    1, 3]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[-1, 40] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) (((((Complex[0, 
                    Rational[-3, 2]] 
                    3^Rational[1, 2]) $CellContext`kl^2) $CellContext`kt^6) (
                    Complex[
                    0, -1] $CellContext`kx - $CellContext`ky)^3) \
(($CellContext`kt^2 + $CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Rational[-5, 8] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^6) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) - (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((
                    4 $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))) + (((((Complex[0, 
                    Rational[1, 12]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[
                    0, 1] $CellContext`ky)^2) ($CellContext`kt \
$CellContext`kx + (Complex[0, -1] $CellContext`kt) $CellContext`ky)) (
                  3^Rational[1, 2] $CellContext`kt^2 + 
                  3^Rational[1, 2] $CellContext`kx^2 + 
                  3^Rational[1, 2] $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                   3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                  Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                  Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                  Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                   4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((
                    Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ($CellContext`kl^(-1) (-$CellContext`kx + 
                   Complex[0, 1] $CellContext`ky)) (((((Complex[0, 
                    Rational[1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (($CellContext`kl^(-1)/$CellContext`kt) (
                   Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) (((((
                    Rational[-1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((
                    Rational[1, 48] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((Complex[0, 
                    Rational[
                    1, 3]]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[-1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 2] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[
                    1, 3]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((
                    Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[-1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((Complex[0, 
                    Rational[1, 8]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) (((((Rational[3, 4] 
                    3^Rational[1, 2]) $CellContext`kl^2) $CellContext`kt^7) (
                    Complex[
                    0, -1] $CellContext`kx - $CellContext`ky)^3) \
(($CellContext`kt^2 + $CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Complex[0, 
                    Rational[-7, 32]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^7) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((((Complex[0, 
                    Rational[3, 4]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) - (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((
                    4 $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))))) + (((((
                    Rational[-1, 6] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (-$CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                  3^Rational[1, 2] $CellContext`kt^2 + 
                  3^Rational[1, 2] $CellContext`kx^2 + 
                  3^Rational[
                    1, 2] $CellContext`ky^2) + (((((
                    Rational[
                    1, 6] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[
                    0, 1] $CellContext`ky)^2) ($CellContext`kt \
$CellContext`kx + (Complex[0, -1] $CellContext`kt) $CellContext`ky)) (
                  3^Rational[1, 2] $CellContext`kt^2 + 
                  3^Rational[1, 2] $CellContext`kx^2 + 
                  3^Rational[1, 2] $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                   3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                   5 $CellContext`kt^2) $CellContext`ky^2 - (
                   2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (
                  Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                  Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                  Complex[0, -1] $CellContext`ky^4) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                   4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((
                    Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (($CellContext`kl^(-1)/$CellContext`kt) (
                   Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) (((((
                    Complex[0, 
                    Rational[1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((((Complex[0, 
                    Rational[-1, 12]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((((
                    Rational[
                    1, 3]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) ((((Complex[0, 
                    Rational[1, 2]] $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[-1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + (((((
                    Rational[1, 2] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    Complex[
                    0, 1] $CellContext`kx + $CellContext`ky)) \
(-$CellContext`kl^Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                   Complex[0, -1] $CellContext`ky)) (
                   3^Rational[1, 2] $CellContext`kt^2 + 
                   3^Rational[1, 2] $CellContext`kx^2 + 
                   3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) (((((Complex[0, 
                    Rational[1, 4]] 
                    3^Rational[1, 2]) $CellContext`kl^2) $CellContext`kt^8) (
                    Complex[
                    0, -1] $CellContext`kx - $CellContext`ky)^3) \
(($CellContext`kt^2 + $CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Rational[9, 160] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^8) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((((Rational[-3, 8] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^5) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) - (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((
                    4 $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[8, 
                    9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) + ((((((Complex[0, 
                    Rational[3, 4]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((-4) $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)))) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + \
Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + (((((Complex[0, 
                    Rational[1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-1, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) \
((-$CellContext`kl^Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((((((
                    Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) - (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[1, 
                    
                    2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 
                    2] $CellContext`kt) $CellContext`kx^3 + $CellContext`kx^4 + \
(2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[2, 
                    9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))))) + (((((Complex[0, 
                    Rational[
                    2, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                  3^Rational[1, 2] $CellContext`kt^2 + 
                  3^Rational[1, 2] $CellContext`kx^2 + 
                  3^Rational[1, 2] $CellContext`ky^2)) (
                 16 $CellContext`kt^4 - (
                  4 $CellContext`kt^2) $CellContext`kx^2 + $CellContext`kx^4 + \
((Complex[0, 24] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                   20 $CellContext`kt^2) $CellContext`ky^2 + (
                   2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) (((((Rational[-1, 16] 
                    3^Rational[1, 2]) $CellContext`kl^2) $CellContext`kt^9) (
                    Complex[
                    0, -1] $CellContext`kx - $CellContext`ky)^3) \
(($CellContext`kt^2 + $CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Complex[0, 
                    Rational[-1, 320]] 
                    3^Rational[-1, 
                    2]) $CellContext`kl^2) $CellContext`kt^9) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Complex[0, 
                    Rational[1, 80]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^9) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((((Complex[0, 
                    Rational[-1, 8]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^6) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) - (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((
                    4 $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 
                    2] $CellContext`kt) $CellContext`kx^3 + $CellContext`kx^4 + \
(2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) + ((((((Rational[-3, 8] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^5) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))) + ((((((Complex[0, 
                    Rational[3, 4]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((-4) $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)))) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + (((((Complex[0, 
                    Rational[1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-1, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) \
((-$CellContext`kl^Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((((((
                    Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) - (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[2, 
                    9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((-4) $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)))) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + (((((Complex[0, 
                    Rational[1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-1, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) \
((-$CellContext`kl^Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + (((((Complex[0, 
                    Rational[1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    
                    Rational[-1, 
                    2880]]/$CellContext`kl) $CellContext`kt^4) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[-1, 720]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^6 + (((((Rational[-1, 480] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-1, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) \
((-$CellContext`kl^Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + (((((Complex[0, 
                    Rational[-1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 240]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[-1, 720] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + (((((Complex[0, 
                    Rational[-1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) - ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    
                    Rational[-1, 
                    2880]]/$CellContext`kl) $CellContext`kt^4) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[-1, 720]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^6 + ((((Complex[0, 
                    Rational[-1, 1440]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) ((((((((Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) - ((((-4) $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[2, 
                    9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))) - (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((-4) $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)))) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[1, 
                    96]]/$CellContext`kl) $CellContext`kt^2) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + (((((Complex[0, 
                    Rational[1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-1, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) \
((-$CellContext`kl^Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((((((
                    Rational[-3, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[2, 
                    9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))))) + (((((
                    Rational[
                    2, 9] $CellContext`kl^(-2)) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                  3^Rational[1, 2] $CellContext`kt^2 + 
                  3^Rational[1, 2] $CellContext`kx^2 + 
                  3^Rational[1, 2] $CellContext`ky^2)) (
                 16 $CellContext`kt^4 - (
                  4 $CellContext`kt^2) $CellContext`kx^2 + $CellContext`kx^4 + \
((Complex[0, 24] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                   20 $CellContext`kt^2) $CellContext`ky^2 + (
                   2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) (((((Complex[0, 
                    Rational[-1, 80]] 
                    3^Rational[1, 2]) $CellContext`kl^2) $CellContext`kt^10) (
                    Complex[
                    0, -1] $CellContext`kx - $CellContext`ky)^3) \
(($CellContext`kt^2 + $CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((Rational[-13, 2240] 
                    3^Rational[-1, 
                    2]) $CellContext`kl^2) $CellContext`kt^10) \
($CellContext`kx + Complex[
                    0, -1] $CellContext`ky)^3) (($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)/(
                  4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) + ((((((Rational[1, 32] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^7) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) - (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((
                    4 $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) + ((((((Complex[0, 
                    Rational[-1, 8]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^6) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 
                    2] $CellContext`kt) $CellContext`kx^3 + $CellContext`kx^4 + \
(2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))))) + ((((((Rational[-3, 8] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^5) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((-4) $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)))) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 
                    9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + (((((Complex[0, 
                    Rational[1, 80]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-1, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) \
((-$CellContext`kl^Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((
                    Rational[-1, 6]/$CellContext`kl) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[-1, 120]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((Rational[-1, 40] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[1, 120]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^5 + (((((Rational[-1, 40] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[-1, 
                    480]/$CellContext`kl) $CellContext`kt^3) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[-1, 120] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^5 + ((((
                    Rational[-1, 240] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((((((
                    Rational[-3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + ((((((
                    Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))) - (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) ((((-4) \
$CellContext`kt^2) (Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4))) + (((((((
                    Rational[3, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[
                    2, 9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + ((((((Rational[-3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((Complex[0, 
                    Rational[2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[1, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[0, -1] $CellContext`ky^4) + (((Complex[0, 
                    Rational[4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[
                    4, 3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^4 + (((((Rational[1, 16] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Rational[-2, 3]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-1, 
                    3]/$CellContext`kl)/$CellContext`kt) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ((-4) $CellContext`kt^4 + \
$CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + ((
                    Complex[
                    0, -6] $CellContext`kt^2) $CellContext`kx) \
$CellContext`ky - (5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((
                    Rational[-1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 8]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Rational[1, 24] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + (((((Complex[0, 
                    Rational[1, 8]] 3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + (((Complex[0, 
                    Rational[-4, 3]]/$CellContext`kl)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[
                    1, 24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((
                    Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((Complex[0, 
                    Rational[
                    1, 96]]/$CellContext`kl) $CellContext`kt^2) \
($CellContext`kx + Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Complex[0, 
                    Rational[1, 24]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^4 + ((((Complex[0, 
                    Rational[1, 48]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)))) + (((2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) ((((((((Rational[-3, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)^(-2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + \
(2 $CellContext`kx^2) $CellContext`ky^2 + $CellContext`ky^4)) + (((
                    2 $CellContext`kt)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)) (((4 $CellContext`kt^2) (
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[1, 
                    2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[-3, 4] 
                    3^Rational[1, 
                    2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[0, 
                    6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4) + ((Complex[0, 
                    Rational[-16, 3]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`ky)^(-2)) ($CellContext`kt^4 - (
                    3^Rational[1, 2] $CellContext`kt^3) $CellContext`kx + (
                    2 $CellContext`kt^2) $CellContext`kx^2 - (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`kx^3 + \
$CellContext`kx^4 + (2 $CellContext`kt^2) $CellContext`ky^2 - ((
                    3^Rational[1, 
                    2] $CellContext`kt) $CellContext`kx) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4))) + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`ky^2) + (((
                    Rational[4, 9] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-2)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    3^Rational[1, 2] $CellContext`kt^3 - (
                    3 $CellContext`kt^2) $CellContext`kx + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2) + ((((
                    Rational[2, 
                    9] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^3 + (
                    3^Rational[1, 2] $CellContext`kt) $CellContext`kx^2 + (
                    3^Rational[
                    1, 2] $CellContext`kt) $CellContext`ky^2)) ((-4) \
$CellContext`kt^4 + $CellContext`kt^2 $CellContext`kx^2 - $CellContext`kx^4 + \
((Complex[0, -6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky - (
                    5 $CellContext`kt^2) $CellContext`ky^2 - (
                    2 $CellContext`kx^2) $CellContext`ky^2 - \
$CellContext`ky^4) + (((Complex[0, 
                    Rational[-2, 9]] $CellContext`kl^(-2)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    Complex[0, -4] $CellContext`kt^4 + (
                    Complex[0, 1] $CellContext`kt^2) $CellContext`kx^2 + 
                    Complex[
                    0, -1] $CellContext`kx^4 + ((
                    6 $CellContext`kt^2) $CellContext`kx) $CellContext`ky + (
                    Complex[0, -5] $CellContext`kt^2) $CellContext`ky^2 + (
                    Complex[0, -2] $CellContext`kx^2) $CellContext`ky^2 + 
                    Complex[
                    0, -1] $CellContext`ky^4) + ((((
                    Rational[4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + ((
                    Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + (((((Complex[0, 
                    Rational[-1, 4]] 3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2) (
                    Complex[
                    0, -1] $CellContext`kx - \
$CellContext`ky))/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    Rational[
                    2, 3]]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 - (
                    3 $CellContext`kt) $CellContext`kx + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Complex[0, 
                    
                    Rational[-1, 
                    3]]/$CellContext`kl) $CellContext`kt^(-2)) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $CellContext`kt^2) $CellContext`kx) $CellContext`ky + \
(5 $CellContext`kt^2) $CellContext`ky^2 + (
                    2 $CellContext`kx^2) $CellContext`ky^2 + \
$CellContext`ky^4)) ((-$CellContext`kl^
                    Rational[-1, 2] + (((Rational[-1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) ((Complex[0, 
                    Rational[1, 6]] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 6 $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) + ((Complex[0, 
                    Rational[-1, 6]] $CellContext`kl^
                    Rational[-1, 
                    2]) $CellContext`kt^3 + (((((Rational[1, 2] 
                    3^Rational[1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/(
                    Complex[0, -6] $CellContext`kx - 
                    6 $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)) (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))) + ((((Rational[-4, 
                    3]/$CellContext`kl)/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (((
                    Rational[1, 
                    24]/$CellContext`kl) $CellContext`kt) ($CellContext`kx + 
                    Complex[0, 1] $CellContext`ky)^2 + (-$CellContext`kl^
                    Rational[-1, 
                    2] + ((((Rational[1, 2] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2])/$CellContext`kt)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2)) ((Rational[1, 6] $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^3 + ((((Rational[1, 12] 
                    3^Rational[-1, 2]) $CellContext`kl^
                    Rational[-1, 2]) $CellContext`kt^2)/($CellContext`kx + 
                    Complex[0, -1] $CellContext`ky)) (
                    4 $CellContext`kt^2 + $CellContext`kx^2 + \
$CellContext`ky^2))))))) + ((((((Complex[0, 
                    Rational[3, 4]] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^4) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                   Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                   Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                   Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) ((((-4) $CellContext`kt^2) (
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[0, -1] $CellContext`ky^2)^(-2)) (
                    4 $CellContext`kt^2 - ((2 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`kx + \
$CellContext`kx^2 + ((Complex[0, 2] 
                    3^Rational[
                    1, 2]) $CellContext`kt) $CellContext`ky + \
$CellContext`ky^2)^2 + ((((((Rational[3, 4] 
                    3^Rational[
                    1, 2]) $CellContext`kl^2) $CellContext`kt^3) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^3)/(
                    Complex[
                    0, -4] $CellContext`kt^2 + ((Complex[0, 2] 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`kx + 
                    Complex[
                    0, -1] $CellContext`kx^2 + ((2 
                    3^Rational[1, 2]) $CellContext`kt) $CellContext`ky + 
                    Complex[
                    0, -1] $CellContext`ky^2)) ($CellContext`kt^2 + \
$CellContext`kx^2 + $CellContext`ky^2)^(-2)) (((((Complex[0, 
                    Rational[
                    8, 9]] $CellContext`kl^(-2))/$CellContext`kt) \
($CellContext`kx + Complex[0, -1] $CellContext`ky)^(-3)) (
                    3^Rational[1, 2] $CellContext`kt^2 + 
                    3^Rational[1, 2] $CellContext`kx^2 + 
                    3^Rational[1, 2] $CellContext`ky^2)) (
                    4 $CellContext`kt^4 - $CellContext`kt^2 $CellContext`kx^2 + \
$CellContext`kx^4 + ((Complex[
                    0, 6] $Cel